/**************************************************************
            ==================================
            Star Wars - The POV-Ray Collection
            ==================================

SD.INC - 3D model description file for use with the
Persistence of Vision Ray-Tracer, v3.0
* Converted to POV-Ray 3.1 by John Dickson

Original POV-Ray code copyright (c) 1997 D M Beattie
dmb197@ecs.soton.ac.uk

This model is provided for personal use only. Any use of this
model for commercial gain or profit is strictly forbidden -
please see the accompanying README.TXT and Conditions of Use
before using or distributing this model.

'Star Wars' and all associated images, designs and trademarks,
(including the designs of the vehicles and objects depicted in
the Star Wars POV-Ray Collection, except where otherwise
stated) are copyright (c) 1997 Lucasfilm Ltd, and are used
without permission.

**************************************************************/

// Star Destroyer - converted from 3DS object file on SWMA website.
// Original 3D mesh by <fill in later>
// Approx dimensions : Length 1600m, width 225m

#declare Lights = texture {
  pigment {
    image_map {png "LIGHTS.png" filter 255, 1}
  }
  scale <20,10,10>
  rotate <0,90,0>
  rotate <0,45,0>
  finish {ambient 1}
}

#declare SD_BigGlow = object {
  union {
    object {
      sphere {<0,0,0>, 1}
	  texture {
	    pigment {colour rgbt 1}
	  }
	  hollow
	  interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }
	      samples 10,10
	    }
	  }
	  scale <10,10,1>
      translate <0,0,0>
	}

    object {
      sphere {<0,0,0>, 1}
	  texture {
	    pigment {colour rgbt 1}
	  }
	  hollow
	  interior
      {
        media 
        {
          emission .2
          density 
          {
            spherical
            color_map
            {
              [0.0 rgbt <1,1,0,1>]
              [1.0 rgbt <1,1,0,.25>]
             }
          }
	    samples 10,10
	    }
	  }
	  scale <8,8,25>
      translate <0,0,1>
	}
  }
}



#declare _HullO01 = texture { //Top of main hull, not including structural detailing
  pigment {
    image_map {png "STDESTTM.png"}
    rotate <90,0,0>
    scale 20
  }
  normal {
    bump_map {png "STDESTBM.png"}
    rotate <90,0,0>
    scale 10
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
}

#declare _HullU01 = texture { //Underside of main hull
  pigment {
    image_map {png "STDESTTM.png"}
    rotate <90,0,0>
    scale 20
  }
  normal {
    bump_map {png "STDESTBM.png"}
    rotate <90,0,0>
    scale 20
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
}

#declare _Aufbau01 = texture { //Detail on top of bridge
  pigment {
    image_map {png "STDESTTM.png"}
    rotate <90,0,0>
    scale 20
  }
  normal {
    bump_map {png "STDESTBM.png"}
    rotate <90,0,0>
    scale 20
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
}
#declare _Aufbau02 = texture {Lights} //Lights texture for second copy of hull detailing

#declare _Zeug02 = texture { //Detail along sides of hull
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
} texture {
  Lights
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
}

#declare _Zeug01 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
}

#declare _Bridge01 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
}
#declare _Bridge02 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.01
    diffuse 0.7
  }
} texture {
  Lights
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
}


#declare _Shield01 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
  }
  finish {ambient 0.01 diffuse 0.7}
}

#declare _Shield02 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
  }
  finish {ambient 0.01 diffuse 0.7}
}

#declare _BrTop01 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Heck03 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Heck04 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Heck09 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Heck11 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Duse02 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare _Duse01 = texture {
  pigment {color rgb 0.75}
}

#declare _Duse04 = texture {
  pigment {color rgb 0.75}
}

#declare _Duse05 = texture {
  pigment {color rgb 0.75}
}

#declare _BrDetail01 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
} texture {
  Lights
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {ambient 1}
}



#declare _Object05 = texture {
  pigment {
    image_map {png "STDESTTM.png"}
    scale 5
  }
  normal {
    bump_map {png "STDESTBM.png"}
    scale 5
  }
  finish {
    ambient 0.1
    diffuse 0.7
  }
}

#declare StarDestroyer = object {
  union {
    object {SD_BigGlow translate <-0.75,-23,171>}
    object {SD_BigGlow translate <-53.5,-23,171>}
    object {SD_BigGlow translate <54,-23,171>}

    // _HullO01
    mesh {
      triangle {<-7.163564,-20.229992,-185.842065>,<-0.007963,-19.188290,-189.468072>,<-0.007970,-0.601902,189.492211>}
      triangle {<-0.007970,-0.601902,189.492211>,<-105.293055,-20.404049,151.657027>,<-71.324874,-20.433140,33.041938>}
      triangle {<-0.007970,-0.601902,189.492211>,<-71.324874,-20.433140,33.041938>,<-65.485567,-19.423939,33.330451>}
      triangle {<-62.565933,-19.379688,24.088187>,<-67.107585,-20.364864,19.781363>,<-45.061056,-20.334759,-56.204446>}
      triangle {<-62.565933,-19.379688,24.088187>,<-45.061056,-20.334759,-56.204446>,<-39.165044,-19.345417,-56.518609>}
      triangle {<-27.914560,-19.440182,-97.540215>,<-31.049062,-20.223766,-102.625909>,<-7.163564,-20.229992,-185.842065>}
      triangle {<-27.914560,-19.440182,-97.540215>,<-7.163564,-20.229992,-185.842065>,<-0.007970,-0.601902,189.492211>}
      triangle {<-39.165044,-19.345417,-56.518609>,<-27.914560,-19.440182,-97.540215>,<-0.007970,-0.601902,189.492211>}
      triangle {<-62.565933,-19.379688,24.088187>,<-39.165044,-19.345417,-56.518609>,<-0.007970,-0.601902,189.492211>}
      triangle {<-62.565933,-19.379688,24.088187>,<-0.007970,-0.601902,189.492211>,<-65.485567,-19.423939,33.330451>}
      triangle {<-0.007963,-19.188290,-189.468072>,<-7.163564,-20.229992,-185.842065>,<-7.163564,-19.571789,-185.816186>}
      triangle {<-0.007963,-19.188290,-189.468072>,<-7.163564,-19.571789,-185.816186>,<-0.007963,-18.530109,-189.492211>}
      triangle {<-7.163564,-20.229992,-185.842065>,<-31.049062,-20.223766,-102.625909>,<-31.049062,-19.565586,-102.700006>}
      triangle {<-7.163564,-20.229992,-185.842065>,<-31.049062,-19.565586,-102.700006>,<-7.163564,-19.571789,-185.816186>}
      triangle {<-31.049062,-20.223766,-102.625909>,<-27.914560,-19.440182,-97.540215>,<-27.914560,-18.781994,-97.614343>}
      triangle {<-31.049062,-20.223766,-102.625909>,<-27.914560,-18.781994,-97.614343>,<-31.049062,-19.565586,-102.700006>}
      triangle {<-27.914560,-19.440182,-97.540215>,<-39.165044,-19.345417,-56.518609>,<-39.165044,-18.687229,-56.592706>}
      triangle {<-27.914560,-19.440182,-97.540215>,<-39.165044,-18.687229,-56.592706>,<-27.914560,-18.781994,-97.614343>}
      triangle {<-39.165044,-19.345417,-56.518609>,<-45.061056,-20.334759,-56.204446>,<-45.061056,-19.676571,-56.278558>}
      triangle {<-39.165044,-19.345417,-56.518609>,<-45.061056,-19.676571,-56.278558>,<-39.165044,-18.687229,-56.592706>}
      triangle {<-45.061056,-20.334759,-56.204446>,<-67.107585,-20.364864,19.781363>,<-67.107585,-19.706676,19.707252>}
      triangle {<-45.061056,-20.334759,-56.204446>,<-67.107585,-19.706676,19.707252>,<-45.061056,-19.676571,-56.278558>}
      triangle {<-67.107585,-20.364864,19.781363>,<-62.565933,-19.379688,24.088187>,<-62.565933,-18.721500,24.014197>}
      triangle {<-67.107585,-20.364864,19.781363>,<-62.565933,-18.721500,24.014197>,<-67.107585,-19.706676,19.707252>}
      triangle {<-62.565933,-19.379688,24.088187>,<-65.485567,-19.423939,33.330451>,<-65.485567,-18.765759,33.256263>}
      triangle {<-62.565933,-19.379688,24.088187>,<-65.485567,-18.765759,33.256263>,<-62.565933,-18.721500,24.014197>}
      triangle {<-65.485567,-19.423939,33.330451>,<-71.324874,-20.433140,33.041938>,<-71.324838,-19.774952,32.967841>}
      triangle {<-65.485567,-19.423939,33.330451>,<-71.324838,-19.774952,32.967841>,<-65.485567,-18.765759,33.256263>}
      triangle {<-71.324874,-20.433140,33.041938>,<-105.293055,-20.404049,151.657027>,<-105.293055,-19.745876,151.582931>}
      triangle {<-71.324874,-20.433140,33.041938>,<-105.293055,-19.745876,151.582931>,<-71.324838,-19.774952,32.967841>}
      triangle {<-105.293055,-20.404049,151.657027>,<-0.007970,-0.601902,189.492211>,<-0.007970,0.056286,189.463573>}
      triangle {<-105.293055,-20.404049,151.657027>,<-0.007970,0.056286,189.463573>,<-105.293055,-19.745876,151.582931>}
      triangle {<-0.007970,-0.601902,189.492211>,<-0.007963,-19.188290,-189.468072>,<-0.007963,-18.530109,-189.492211>}
      triangle {<-0.007970,-0.601902,189.492211>,<-0.007963,-18.530109,-189.492211>,<-0.007970,0.056286,189.463573>}
      triangle {<-0.007970,0.056286,189.463573>,<-0.007963,-18.530109,-189.492211>,<-7.163564,-19.571789,-185.816186>}
      triangle {<-71.324838,-19.774952,32.967841>,<-105.293055,-19.745876,151.582931>,<-0.007970,0.056286,189.463573>}
      triangle {<-65.485567,-18.765759,33.256263>,<-71.324838,-19.774952,32.967841>,<-0.007970,0.056286,189.463573>}
      triangle {<-45.061056,-19.676571,-56.278558>,<-67.107585,-19.706676,19.707252>,<-62.565933,-18.721500,24.014197>}
      triangle {<-39.165044,-18.687229,-56.592706>,<-45.061056,-19.676571,-56.278558>,<-62.565933,-18.721500,24.014197>}
      triangle {<-7.163564,-19.571789,-185.816186>,<-31.049062,-19.565586,-102.700006>,<-27.914560,-18.781994,-97.614343>}
      triangle {<-0.007970,0.056286,189.463573>,<-7.163564,-19.571789,-185.816186>,<-27.914560,-18.781994,-97.614343>}
      triangle {<-0.007970,0.056286,189.463573>,<-27.914560,-18.781994,-97.614343>,<-39.165044,-18.687229,-56.592706>}
      triangle {<-0.007970,0.056286,189.463573>,<-39.165044,-18.687229,-56.592706>,<-62.565933,-18.721500,24.014197>}
      triangle {<-65.485567,-18.765759,33.256263>,<-0.007970,0.056286,189.463573>,<-62.565933,-18.721500,24.014197>}
      triangle {<-0.007970,-0.601902,189.492211>,<-0.007963,-19.188290,-189.468072>,<7.163172,-20.229977,-185.842065>}
      triangle {<71.324961,-20.433132,33.041938>,<105.293055,-20.404049,151.657023>,<-0.007970,-0.601902,189.492211>}
      triangle {<65.485697,-19.423939,33.329917>,<71.324961,-20.433132,33.041938>,<-0.007970,-0.601902,189.492211>}
      triangle {<45.060999,-20.334759,-56.204415>,<67.107707,-20.364864,19.781363>,<62.566050,-19.379688,24.088080>}
      triangle {<39.164271,-19.345417,-56.518594>,<45.060999,-20.334759,-56.204415>,<62.566050,-19.379688,24.088080>}
      triangle {<7.163172,-20.229977,-185.842065>,<31.048289,-20.223766,-102.625909>,<27.913798,-19.440182,-97.540215>}
      triangle {<-0.007970,-0.601902,189.492211>,<7.163172,-20.229977,-185.842065>,<27.913798,-19.440182,-97.540215>}
      triangle {<-0.007970,-0.601902,189.492211>,<27.913798,-19.440182,-97.540215>,<39.164271,-19.345417,-56.518594>}
      triangle {<-0.007970,-0.601902,189.492211>,<39.164271,-19.345417,-56.518594>,<62.566050,-19.379688,24.088080>}
      triangle {<65.485697,-19.423939,33.329917>,<-0.007970,-0.601902,189.492211>,<62.566050,-19.379688,24.088080>}
      triangle {<7.163172,-19.571789,-185.816186>,<7.163172,-20.229977,-185.842065>,<-0.007963,-19.188290,-189.468072>}
      triangle {<-0.007963,-18.530109,-189.492211>,<7.163172,-19.571789,-185.816186>,<-0.007963,-19.188290,-189.468072>}
      triangle {<31.048289,-19.565586,-102.700006>,<31.048289,-20.223766,-102.625909>,<7.163172,-20.229977,-185.842065>}
      triangle {<7.163172,-19.571789,-185.816186>,<31.048289,-19.565586,-102.700006>,<7.163172,-20.229977,-185.842065>}
      triangle {<27.913798,-18.781994,-97.614343>,<27.913798,-19.440182,-97.540215>,<31.048289,-20.223766,-102.625909>}
      triangle {<31.048289,-19.565586,-102.700006>,<27.913798,-18.781994,-97.614343>,<31.048289,-20.223766,-102.625909>}
      triangle {<39.164271,-18.687229,-56.592690>,<39.164271,-19.345417,-56.518594>,<27.913798,-19.440182,-97.540215>}
      triangle {<27.913798,-18.781994,-97.614343>,<39.164271,-18.687229,-56.592690>,<27.913798,-19.440182,-97.540215>}
      triangle {<45.060999,-19.676571,-56.278543>,<45.060999,-20.334759,-56.204415>,<39.164271,-19.345417,-56.518594>}
      triangle {<39.164271,-18.687229,-56.592690>,<45.060999,-19.676571,-56.278543>,<39.164271,-19.345417,-56.518594>}
      triangle {<67.107707,-19.706676,19.707252>,<67.107707,-20.364864,19.781363>,<45.060999,-20.334759,-56.204415>}
      triangle {<45.060999,-19.676571,-56.278543>,<67.107707,-19.706676,19.707252>,<45.060999,-20.334759,-56.204415>}
      triangle {<62.566050,-18.721500,24.013999>,<62.566050,-19.379688,24.088080>,<67.107707,-20.364864,19.781363>}
      triangle {<67.107707,-19.706676,19.707252>,<62.566050,-18.721500,24.013999>,<67.107707,-20.364864,19.781363>}
      triangle {<65.485697,-18.765759,33.255805>,<65.485697,-19.423939,33.329917>,<62.566050,-19.379688,24.088080>}
      triangle {<62.566050,-18.721500,24.013999>,<65.485697,-18.765759,33.255805>,<62.566050,-19.379688,24.088080>}
      triangle {<71.324961,-19.774952,32.967841>,<71.324961,-20.433132,33.041938>,<65.485697,-19.423939,33.329917>}
      triangle {<65.485697,-18.765759,33.255805>,<71.324961,-19.774952,32.967841>,<65.485697,-19.423939,33.329917>}
      triangle {<105.293055,-19.745876,151.582929>,<105.293055,-20.404049,151.657023>,<71.324961,-20.433132,33.041938>}
      triangle {<71.324961,-19.774952,32.967841>,<105.293055,-19.745876,151.582929>,<71.324961,-20.433132,33.041938>}
      triangle {<-0.007970,0.056286,189.463573>,<-0.007970,-0.601902,189.492211>,<105.293055,-20.404049,151.657023>}
      triangle {<105.293055,-19.745876,151.582929>,<-0.007970,0.056286,189.463573>,<105.293055,-20.404049,151.657023>}
      triangle {<7.163172,-19.571789,-185.816186>,<-0.007963,-18.530109,-189.492211>,<-0.007970,0.056286,189.463573>}
      triangle {<-0.007970,0.056286,189.463573>,<105.293055,-19.745876,151.582929>,<71.324961,-19.774952,32.967841>}
      triangle {<-0.007970,0.056286,189.463573>,<71.324961,-19.774952,32.967841>,<65.485697,-18.765759,33.255805>}
      triangle {<62.566050,-18.721500,24.013999>,<67.107707,-19.706676,19.707252>,<45.060999,-19.676571,-56.278543>}
      triangle {<62.566050,-18.721500,24.013999>,<45.060999,-19.676571,-56.278543>,<39.164271,-18.687229,-56.592690>}
      triangle {<27.913798,-18.781994,-97.614343>,<31.048289,-19.565586,-102.700006>,<7.163172,-19.571789,-185.816186>}
      triangle {<27.913798,-18.781994,-97.614343>,<7.163172,-19.571789,-185.816186>,<-0.007970,0.056286,189.463573>}
      triangle {<39.164271,-18.687229,-56.592690>,<27.913798,-18.781994,-97.614343>,<-0.007970,0.056286,189.463573>}
      triangle {<62.566050,-18.721500,24.013999>,<39.164271,-18.687229,-56.592690>,<-0.007970,0.056286,189.463573>}
      triangle {<62.566050,-18.721500,24.013999>,<-0.007970,0.056286,189.463573>,<65.485697,-18.765759,33.255805>}
      triangle {<-66.137756,-15.845280,76.678786>,<-82.928319,-15.935665,129.669795>,<-44.916837,-8.639568,143.336074>}
      triangle {<-43.900709,-12.236599,72.244460>,<-66.137756,-15.845280,76.678786>,<-44.916837,-8.639568,143.336074>}
      triangle {<-82.928407,-17.403042,129.669101>,<-44.916837,-10.106945,143.336070>,<-44.916837,-8.639568,143.336074>}
      triangle {<-82.928319,-15.935665,129.669795>,<-82.928407,-17.403042,129.669101>,<-44.916837,-8.639568,143.336074>}
      triangle {<-66.137771,-17.312656,76.678794>,<-82.928407,-17.403042,129.669101>,<-82.928319,-15.935665,129.669795>}
      triangle {<-66.137756,-15.845280,76.678786>,<-66.137771,-17.312656,76.678794>,<-82.928319,-15.935665,129.669795>}
      triangle {<-43.900709,-13.703976,72.244460>,<-66.137771,-17.312656,76.678794>,<-66.137756,-15.845280,76.678786>}
      triangle {<-43.900709,-12.236599,72.244460>,<-43.900709,-13.703976,72.244460>,<-66.137756,-15.845280,76.678786>}
      triangle {<-44.916837,-10.106945,143.336070>,<-43.900709,-13.703976,72.244460>,<-43.900709,-12.236599,72.244460>}
      triangle {<-44.916837,-8.639568,143.336074>,<-44.916837,-10.106945,143.336070>,<-43.900709,-12.236599,72.244460>}
      triangle {<-66.137771,-17.312656,76.678794>,<-43.900709,-13.703976,72.244460>,<-44.916837,-10.106945,143.336070>}
      triangle {<-82.928407,-17.403042,129.669101>,<-66.137771,-17.312656,76.678794>,<-44.916837,-10.106945,143.336070>}
      triangle {<-29.965566,-15.833538,-42.840661>,<-52.840307,-15.390461,41.526175>,<0.123766,-6.013447,41.526282>}
      triangle {<0.096545,-10.459484,-45.898034>,<-29.965566,-15.833538,-42.840661>,<0.123766,-6.013447,41.526282>}
      triangle {<-52.840307,-16.832958,41.526114>,<0.123759,-7.455944,41.526114>,<0.123766,-6.013447,41.526282>}
      triangle {<-52.840307,-15.390461,41.526175>,<-52.840307,-16.832958,41.526114>,<0.123766,-6.013447,41.526282>}
      triangle {<-29.965566,-17.276035,-42.840661>,<-52.840307,-16.832958,41.526114>,<-52.840307,-15.390461,41.526175>}
      triangle {<-29.965566,-15.833538,-42.840661>,<-29.965566,-17.276035,-42.840661>,<-52.840307,-15.390461,41.526175>}
      triangle {<0.096545,-11.901981,-45.898034>,<-29.965566,-17.276035,-42.840661>,<-29.965566,-15.833538,-42.840661>}
      triangle {<0.096545,-10.459484,-45.898034>,<0.096545,-11.901981,-45.898034>,<-29.965566,-15.833538,-42.840661>}
      triangle {<0.123759,-7.455944,41.526114>,<0.096545,-11.901981,-45.898034>,<0.096545,-10.459484,-45.898034>}
      triangle {<0.123766,-6.013447,41.526282>,<0.123759,-7.455944,41.526114>,<0.096545,-10.459484,-45.898034>}
      triangle {<-29.965566,-17.276035,-42.840661>,<0.096545,-11.901981,-45.898034>,<0.123759,-7.455944,41.526114>}
      triangle {<-52.840307,-16.832958,41.526114>,<-29.965566,-17.276035,-42.840661>,<0.123759,-7.455944,41.526114>}
      triangle {<44.739222,-8.639568,143.335368>,<82.751353,-15.935665,129.669456>,<65.960795,-15.845280,76.678863>}
      triangle {<44.739222,-8.639568,143.335368>,<65.960795,-15.845280,76.678863>,<43.723094,-12.236599,72.244460>}
      triangle {<44.739222,-8.639568,143.335368>,<44.739222,-10.106945,143.335486>,<82.751353,-17.403042,129.669681>}
      triangle {<44.739222,-8.639568,143.335368>,<82.751353,-17.403042,129.669681>,<82.751353,-15.935665,129.669456>}
      triangle {<82.751353,-15.935665,129.669456>,<82.751353,-17.403042,129.669681>,<65.960780,-17.312656,76.678794>}
      triangle {<82.751353,-15.935665,129.669456>,<65.960780,-17.312656,76.678794>,<65.960795,-15.845280,76.678863>}
      triangle {<65.960795,-15.845280,76.678863>,<65.960780,-17.312656,76.678794>,<43.723094,-13.703976,72.244460>}
      triangle {<65.960795,-15.845280,76.678863>,<43.723094,-13.703976,72.244460>,<43.723094,-12.236599,72.244460>}
      triangle {<43.723094,-12.236599,72.244460>,<43.723094,-13.703976,72.244460>,<44.739222,-10.106945,143.335486>}
      triangle {<43.723094,-12.236599,72.244460>,<44.739222,-10.106945,143.335486>,<44.739222,-8.639568,143.335368>}
      triangle {<44.739222,-10.106945,143.335486>,<43.723094,-13.703976,72.244460>,<65.960780,-17.312656,76.678794>}
      triangle {<44.739222,-10.106945,143.335486>,<65.960780,-17.312656,76.678794>,<82.751353,-17.403042,129.669681>}
      triangle {<26.123255,-16.461033,-55.403512>,<-0.081098,-11.934452,-51.372064>,<-0.081113,-14.434978,-103.780786>}
      triangle {<18.060374,-17.339428,-101.765069>,<19.462183,-17.242344,-94.870538>,<16.920428,-16.790394,-94.209649>}
      triangle {<-0.081113,-14.434978,-103.780786>,<18.060374,-17.339428,-101.765069>,<16.920428,-16.790394,-94.209649>}
      triangle {<20.874712,-17.072659,-86.417413>,<22.502947,-16.886951,-76.880609>,<19.944285,-16.424900,-76.066461>}
      triangle {<18.083453,-16.622074,-86.649987>,<20.874712,-17.072659,-86.417413>,<19.944285,-16.424900,-76.066461>}
      triangle {<21.688830,-16.180744,-64.901467>,<24.480082,-16.631321,-64.668862>,<26.123255,-16.461033,-55.403512>}
      triangle {<21.688830,-16.180744,-64.901467>,<26.123255,-16.461033,-55.403512>,<-0.081113,-14.434978,-103.780786>}
      triangle {<19.944285,-16.424900,-76.066461>,<21.688830,-16.180744,-64.901467>,<-0.081113,-14.434978,-103.780786>}
      triangle {<18.083453,-16.622074,-86.649987>,<19.944285,-16.424900,-76.066461>,<-0.081113,-14.434978,-103.780786>}
      triangle {<18.083453,-16.622074,-86.649987>,<-0.081113,-14.434978,-103.780786>,<16.920428,-16.790394,-94.209649>}
      triangle {<-0.081113,-14.434978,-103.780786>,<-0.081098,-11.934452,-51.372064>,<-0.081098,-10.870152,-51.372064>}
      triangle {<-0.081113,-14.434978,-103.780786>,<-0.081098,-10.870152,-51.372064>,<-0.081113,-13.370678,-103.780786>}
      triangle {<-0.081098,-11.934452,-51.372064>,<26.123255,-16.461033,-55.403512>,<26.123255,-15.396732,-55.403466>}
      triangle {<-0.081098,-11.934452,-51.372064>,<26.123255,-15.396732,-55.403466>,<-0.081098,-10.870152,-51.372064>}
      triangle {<26.123255,-16.461033,-55.403512>,<24.480082,-16.631321,-64.668862>,<24.480082,-15.567013,-64.668862>}
      triangle {<26.123255,-16.461033,-55.403512>,<24.480082,-15.567013,-64.668862>,<26.123255,-15.396732,-55.403466>}
      triangle {<24.480082,-16.631321,-64.668862>,<21.688830,-16.180744,-64.901467>,<21.688830,-15.116444,-64.901330>}
      triangle {<24.480082,-16.631321,-64.668862>,<21.688830,-15.116444,-64.901330>,<24.480082,-15.567013,-64.668862>}
      triangle {<21.688830,-16.180744,-64.901467>,<19.944285,-16.424900,-76.066461>,<19.944285,-15.360600,-76.066461>}
      triangle {<21.688830,-16.180744,-64.901467>,<19.944285,-15.360600,-76.066461>,<21.688830,-15.116444,-64.901330>}
      triangle {<19.944285,-16.424900,-76.066461>,<22.502947,-16.886951,-76.880609>,<22.502947,-15.822651,-76.880609>}
      triangle {<19.944285,-16.424900,-76.066461>,<22.502947,-15.822651,-76.880609>,<19.944285,-15.360600,-76.066461>}
      triangle {<22.502947,-16.886951,-76.880609>,<20.874712,-17.072659,-86.417413>,<20.874712,-16.008350,-86.417413>}
      triangle {<22.502947,-16.886951,-76.880609>,<20.874712,-16.008350,-86.417413>,<22.502947,-15.822651,-76.880609>}
      triangle {<20.874712,-17.072659,-86.417413>,<18.083453,-16.622074,-86.649987>,<18.083453,-15.557774,-86.649987>}
      triangle {<20.874712,-17.072659,-86.417413>,<18.083453,-15.557774,-86.649987>,<20.874712,-16.008350,-86.417413>}
      triangle {<18.083453,-16.622074,-86.649987>,<16.920428,-16.790394,-94.209649>,<16.920428,-15.726093,-94.209649>}
      triangle {<18.083453,-16.622074,-86.649987>,<16.920428,-15.726093,-94.209649>,<18.083453,-15.557774,-86.649987>}
      triangle {<16.920428,-16.790394,-94.209649>,<19.462183,-17.242344,-94.870538>,<19.462183,-16.178043,-94.870538>}
      triangle {<16.920428,-16.790394,-94.209649>,<19.462183,-16.178043,-94.870538>,<16.920428,-15.726093,-94.209649>}
      triangle {<19.462183,-17.242344,-94.870538>,<18.060374,-17.339428,-101.765069>,<18.060374,-16.275127,-101.765069>}
      triangle {<19.462183,-17.242344,-94.870538>,<18.060374,-16.275127,-101.765069>,<19.462183,-16.178043,-94.870538>}
      triangle {<18.060374,-17.339428,-101.765069>,<-0.081113,-14.434978,-103.780786>,<-0.081113,-13.370678,-103.780786>}
      triangle {<18.060374,-17.339428,-101.765069>,<-0.081113,-13.370678,-103.780786>,<18.060374,-16.275127,-101.765069>}
      triangle {<-0.081113,-13.370678,-103.780786>,<-0.081098,-10.870152,-51.372064>,<26.123255,-15.396732,-55.403466>}
      triangle {<16.920428,-15.726093,-94.209649>,<19.462183,-16.178043,-94.870538>,<18.060374,-16.275127,-101.765069>}
      triangle {<16.920428,-15.726093,-94.209649>,<18.060374,-16.275127,-101.765069>,<-0.081113,-13.370678,-103.780786>}
      triangle {<19.944285,-15.360600,-76.066461>,<22.502947,-15.822651,-76.880609>,<20.874712,-16.008350,-86.417413>}
      triangle {<19.944285,-15.360600,-76.066461>,<20.874712,-16.008350,-86.417413>,<18.083453,-15.557774,-86.649987>}
      triangle {<26.123255,-15.396732,-55.403466>,<24.480082,-15.567013,-64.668862>,<21.688830,-15.116444,-64.901330>}
      triangle {<-0.081113,-13.370678,-103.780786>,<26.123255,-15.396732,-55.403466>,<21.688830,-15.116444,-64.901330>}
      triangle {<-0.081113,-13.370678,-103.780786>,<21.688830,-15.116444,-64.901330>,<19.944285,-15.360600,-76.066461>}
      triangle {<-0.081113,-13.370678,-103.780786>,<19.944285,-15.360600,-76.066461>,<18.083453,-15.557774,-86.649987>}
      triangle {<16.920428,-15.726093,-94.209649>,<-0.081113,-13.370678,-103.780786>,<18.083453,-15.557774,-86.649987>}
      triangle {<-0.216032,-14.434978,-103.780786>,<-0.216047,-11.934452,-51.372064>,<-26.420400,-16.461033,-55.403512>}
      triangle {<-17.217573,-16.790394,-94.209649>,<-19.759328,-17.242344,-94.870538>,<-18.357519,-17.339428,-101.765069>}
      triangle {<-17.217573,-16.790394,-94.209649>,<-18.357519,-17.339428,-101.765069>,<-0.216032,-14.434978,-103.780786>}
      triangle {<-20.241430,-16.424900,-76.066461>,<-22.800092,-16.886951,-76.880609>,<-21.171857,-17.072659,-86.417413>}
      triangle {<-20.241430,-16.424900,-76.066461>,<-21.171857,-17.072659,-86.417413>,<-18.380598,-16.622074,-86.649987>}
      triangle {<-26.420400,-16.461033,-55.403512>,<-24.777227,-16.631321,-64.668862>,<-21.985975,-16.180744,-64.901467>}
      triangle {<-0.216032,-14.434978,-103.780786>,<-26.420400,-16.461033,-55.403512>,<-21.985975,-16.180744,-64.901467>}
      triangle {<-0.216032,-14.434978,-103.780786>,<-21.985975,-16.180744,-64.901467>,<-20.241430,-16.424900,-76.066461>}
      triangle {<-0.216032,-14.434978,-103.780786>,<-20.241430,-16.424900,-76.066461>,<-18.380598,-16.622074,-86.649987>}
      triangle {<-17.217573,-16.790394,-94.209649>,<-0.216032,-14.434978,-103.780786>,<-18.380598,-16.622074,-86.649987>}
      triangle {<-0.216047,-10.870152,-51.372064>,<-0.216047,-11.934452,-51.372064>,<-0.216032,-14.434978,-103.780786>}
      triangle {<-0.216032,-13.370678,-103.780786>,<-0.216047,-10.870152,-51.372064>,<-0.216032,-14.434978,-103.780786>}
      triangle {<-26.420400,-15.396732,-55.403512>,<-26.420400,-16.461033,-55.403512>,<-0.216047,-11.934452,-51.372064>}
      triangle {<-0.216047,-10.870152,-51.372064>,<-26.420400,-15.396732,-55.403512>,<-0.216047,-11.934452,-51.372064>}
      triangle {<-24.777227,-15.567013,-64.668862>,<-24.777227,-16.631321,-64.668862>,<-26.420400,-16.461033,-55.403512>}
      triangle {<-26.420400,-15.396732,-55.403512>,<-24.777227,-15.567013,-64.668862>,<-26.420400,-16.461033,-55.403512>}
      triangle {<-21.985975,-15.116444,-64.901467>,<-21.985975,-16.180744,-64.901467>,<-24.777227,-16.631321,-64.668862>}
      triangle {<-24.777227,-15.567013,-64.668862>,<-21.985975,-15.116444,-64.901467>,<-24.777227,-16.631321,-64.668862>}
      triangle {<-20.241430,-15.360600,-76.066461>,<-20.241430,-16.424900,-76.066461>,<-21.985975,-16.180744,-64.901467>}
      triangle {<-21.985975,-15.116444,-64.901467>,<-20.241430,-15.360600,-76.066461>,<-21.985975,-16.180744,-64.901467>}
      triangle {<-22.800092,-15.822651,-76.880609>,<-22.800092,-16.886951,-76.880609>,<-20.241430,-16.424900,-76.066461>}
      triangle {<-20.241430,-15.360600,-76.066461>,<-22.800092,-15.822651,-76.880609>,<-20.241430,-16.424900,-76.066461>}
      triangle {<-21.171857,-16.008350,-86.417413>,<-21.171857,-17.072659,-86.417413>,<-22.800092,-16.886951,-76.880609>}
      triangle {<-22.800092,-15.822651,-76.880609>,<-21.171857,-16.008350,-86.417413>,<-22.800092,-16.886951,-76.880609>}
      triangle {<-18.380598,-15.557774,-86.649987>,<-18.380598,-16.622074,-86.649987>,<-21.171857,-17.072659,-86.417413>}
      triangle {<-21.171857,-16.008350,-86.417413>,<-18.380598,-15.557774,-86.649987>,<-21.171857,-17.072659,-86.417413>}
      triangle {<-17.217573,-15.726093,-94.209649>,<-17.217573,-16.790394,-94.209649>,<-18.380598,-16.622074,-86.649987>}
      triangle {<-18.380598,-15.557774,-86.649987>,<-17.217573,-15.726093,-94.209649>,<-18.380598,-16.622074,-86.649987>}
      triangle {<-19.759328,-16.178043,-94.870538>,<-19.759328,-17.242344,-94.870538>,<-17.217573,-16.790394,-94.209649>}
      triangle {<-17.217573,-15.726093,-94.209649>,<-19.759328,-16.178043,-94.870538>,<-17.217573,-16.790394,-94.209649>}
      triangle {<-18.357519,-16.275127,-101.765069>,<-18.357519,-17.339428,-101.765069>,<-19.759328,-17.242344,-94.870538>}
      triangle {<-19.759328,-16.178043,-94.870538>,<-18.357519,-16.275127,-101.765069>,<-19.759328,-17.242344,-94.870538>}
      triangle {<-0.216032,-13.370678,-103.780786>,<-0.216032,-14.434978,-103.780786>,<-18.357519,-17.339428,-101.765069>}
      triangle {<-18.357519,-16.275127,-101.765069>,<-0.216032,-13.370678,-103.780786>,<-18.357519,-17.339428,-101.765069>}
      triangle {<-26.420400,-15.396732,-55.403512>,<-0.216047,-10.870152,-51.372064>,<-0.216032,-13.370678,-103.780786>}
      triangle {<-18.357519,-16.275127,-101.765069>,<-19.759328,-16.178043,-94.870538>,<-17.217573,-15.726093,-94.209649>}
      triangle {<-0.216032,-13.370678,-103.780786>,<-18.357519,-16.275127,-101.765069>,<-17.217573,-15.726093,-94.209649>}
      triangle {<-21.171857,-16.008350,-86.417413>,<-22.800092,-15.822651,-76.880609>,<-20.241430,-15.360600,-76.066461>}
      triangle {<-18.380598,-15.557774,-86.649987>,<-21.171857,-16.008350,-86.417413>,<-20.241430,-15.360600,-76.066461>}
      triangle {<-21.985975,-15.116444,-64.901467>,<-24.777227,-15.567013,-64.668862>,<-26.420400,-15.396732,-55.403512>}
      triangle {<-21.985975,-15.116444,-64.901467>,<-26.420400,-15.396732,-55.403512>,<-0.216032,-13.370678,-103.780786>}
      triangle {<-20.241430,-15.360600,-76.066461>,<-21.985975,-15.116444,-64.901467>,<-0.216032,-13.370678,-103.780786>}
      triangle {<-18.380598,-15.557774,-86.649987>,<-20.241430,-15.360600,-76.066461>,<-0.216032,-13.370678,-103.780786>}
      triangle {<-18.380598,-15.557774,-86.649987>,<-0.216032,-13.370678,-103.780786>,<-17.217573,-15.726093,-94.209649>}
      triangle {<-3.417280,-17.366100,-137.074731>,<-10.850690,-18.621395,-137.074731>,<-3.765028,-18.622730,-164.907342>}
      triangle {<-2.299306,-17.310406,-140.167230>,<-3.417280,-17.366100,-137.074731>,<-3.765028,-18.622730,-164.907342>}
      triangle {<-3.765028,-18.622730,-164.907342>,<-0.010152,-18.022114,-165.680474>,<-0.032941,-16.920185,-140.167230>}
      triangle {<-2.299306,-17.310406,-140.167230>,<-3.765028,-18.622730,-164.907342>,<-0.032941,-16.920185,-140.167230>}
      triangle {<-0.010152,-18.022114,-165.680474>,<-3.765028,-18.622730,-164.907342>,<-3.765028,-17.308796,-164.907342>}
      triangle {<-0.010152,-18.022114,-165.680474>,<-3.765028,-17.308796,-164.907342>,<-0.010152,-16.708179,-165.680474>}
      triangle {<-3.765028,-18.622730,-164.907342>,<-10.850690,-18.621395,-137.074731>,<-10.850690,-17.307461,-137.074731>}
      triangle {<-3.765028,-18.622730,-164.907342>,<-10.850690,-17.307461,-137.074731>,<-3.765028,-17.308796,-164.907342>}
      triangle {<-10.850690,-18.621395,-137.074731>,<-3.417280,-17.366100,-137.074731>,<-3.417280,-16.052166,-137.074731>}
      triangle {<-10.850690,-18.621395,-137.074731>,<-3.417280,-16.052166,-137.074731>,<-10.850690,-17.307461,-137.074731>}
      triangle {<-3.417280,-17.366100,-137.074731>,<-2.299306,-17.310406,-140.167230>,<-2.299306,-15.996471,-140.167230>}
      triangle {<-3.417280,-17.366100,-137.074731>,<-2.299306,-15.996471,-140.167230>,<-3.417280,-16.052166,-137.074731>}
      triangle {<-2.299306,-17.310406,-140.167230>,<-0.032941,-16.920185,-140.167230>,<-0.032941,-15.606251,-140.167230>}
      triangle {<-2.299306,-17.310406,-140.167230>,<-0.032941,-15.606251,-140.167230>,<-2.299306,-15.996471,-140.167230>}
      triangle {<-0.032941,-16.920185,-140.167230>,<-0.010152,-18.022114,-165.680474>,<-0.010152,-16.708179,-165.680474>}
      triangle {<-0.032941,-16.920185,-140.167230>,<-0.010152,-16.708179,-165.680474>,<-0.032941,-15.606251,-140.167230>}
      triangle {<-3.765028,-17.308796,-164.907342>,<-10.850690,-17.307461,-137.074731>,<-3.417280,-16.052166,-137.074731>}
      triangle {<-3.765028,-17.308796,-164.907342>,<-3.417280,-16.052166,-137.074731>,<-2.299306,-15.996471,-140.167230>}
      triangle {<-0.032941,-15.606251,-140.167230>,<-0.010152,-16.708179,-165.680474>,<-3.765028,-17.308796,-164.907342>}
      triangle {<-0.032941,-15.606251,-140.167230>,<-3.765028,-17.308796,-164.907342>,<-2.299306,-15.996471,-140.167230>}
      triangle {<3.743533,-18.622730,-164.907342>,<10.829203,-18.621395,-137.074731>,<3.395792,-17.366100,-137.074731>}
      triangle {<3.743533,-18.622730,-164.907342>,<3.395792,-17.366100,-137.074731>,<2.277812,-17.310406,-140.167230>}
      triangle {<-0.032941,-16.920185,-140.167230>,<-0.010152,-18.022114,-165.680474>,<3.743533,-18.622730,-164.907342>}
      triangle {<-0.032941,-16.920185,-140.167230>,<3.743533,-18.622730,-164.907342>,<2.277812,-17.310406,-140.167230>}
      triangle {<3.743533,-17.308796,-164.907342>,<3.743533,-18.622730,-164.907342>,<-0.010152,-18.022114,-165.680474>}
      triangle {<-0.010152,-16.708179,-165.680474>,<3.743533,-17.308796,-164.907342>,<-0.010152,-18.022114,-165.680474>}
      triangle {<10.829562,-17.307468,-137.074731>,<10.829203,-18.621395,-137.074731>,<3.743533,-18.622730,-164.907342>}
      triangle {<3.743533,-17.308796,-164.907342>,<10.829562,-17.307468,-137.074731>,<3.743533,-18.622730,-164.907342>}
      triangle {<3.395792,-16.052174,-137.074731>,<3.395792,-17.366100,-137.074731>,<10.829203,-18.621395,-137.074731>}
      triangle {<10.829562,-17.307468,-137.074731>,<3.395792,-16.052174,-137.074731>,<10.829203,-18.621395,-137.074731>}
      triangle {<2.277812,-15.996471,-140.167230>,<2.277812,-17.310406,-140.167230>,<3.395792,-17.366100,-137.074731>}
      triangle {<3.395792,-16.052174,-137.074731>,<2.277812,-15.996471,-140.167230>,<3.395792,-17.366100,-137.074731>}
      triangle {<-0.032941,-15.606251,-140.167230>,<-0.032941,-16.920185,-140.167230>,<2.277812,-17.310406,-140.167230>}
      triangle {<2.277812,-15.996471,-140.167230>,<-0.032941,-15.606251,-140.167230>,<2.277812,-17.310406,-140.167230>}
      triangle {<3.395792,-16.052174,-137.074731>,<10.829562,-17.307468,-137.074731>,<3.743533,-17.308796,-164.907342>}
      triangle {<2.277812,-15.996471,-140.167230>,<3.395792,-16.052174,-137.074731>,<3.743533,-17.308796,-164.907342>}
      triangle {<3.743533,-17.308796,-164.907342>,<-0.010152,-16.708179,-165.680474>,<-0.032941,-15.606251,-140.167230>}
      triangle {<2.277812,-15.996471,-140.167230>,<3.743533,-17.308796,-164.907342>,<-0.032941,-15.606251,-140.167230>}
      triangle {<0.066996,-6.019718,41.477836>,<52.972132,-15.386295,41.477942>,<30.122851,-15.828884,-42.795449>}
      triangle {<0.066996,-6.019718,41.477836>,<30.122851,-15.828884,-42.795449>,<0.094187,-10.460804,-45.849420>}
      triangle {<0.066996,-6.019718,41.477836>,<0.067011,-7.460606,41.477637>,<52.972132,-16.827198,41.477469>}
      triangle {<0.066996,-6.019718,41.477836>,<52.972132,-16.827198,41.477469>,<52.972132,-15.386295,41.477942>}
      triangle {<52.972132,-15.386295,41.477942>,<52.972132,-16.827198,41.477469>,<30.122851,-17.269779,-42.795403>}
      triangle {<52.972132,-15.386295,41.477942>,<30.122851,-17.269779,-42.795403>,<30.122851,-15.828884,-42.795449>}
      triangle {<30.122851,-15.828884,-42.795449>,<30.122851,-17.269779,-42.795403>,<0.094187,-11.901707,-45.849420>}
      triangle {<30.122851,-15.828884,-42.795449>,<0.094187,-11.901707,-45.849420>,<0.094187,-10.460804,-45.849420>}
      triangle {<0.094187,-10.460804,-45.849420>,<0.094187,-11.901707,-45.849420>,<0.067011,-7.460606,41.477637>}
      triangle {<0.094187,-10.460804,-45.849420>,<0.067011,-7.460606,41.477637>,<0.066996,-6.019718,41.477836>}
      triangle {<0.067011,-7.460606,41.477637>,<0.094187,-11.901707,-45.849420>,<30.122851,-17.269779,-42.795403>}
      triangle {<0.067011,-7.460606,41.477637>,<30.122851,-17.269779,-42.795403>,<52.972132,-16.827198,41.477469>}
      triangle {<-23.048421,-13.128902,-33.895272>,<-32.515989,-12.945515,1.023276>,<-10.594823,-9.064487,1.023139>}
      triangle {<-10.606092,-10.904652,-35.160684>,<-23.048421,-13.128902,-33.895272>,<-10.594823,-9.064487,1.023139>}
      triangle {<-32.515989,-13.542553,1.023078>,<-10.594831,-9.661518,1.023078>,<-10.594823,-9.064487,1.023139>}
      triangle {<-32.515989,-12.945515,1.023276>,<-32.515989,-13.542553,1.023078>,<-10.594823,-9.064487,1.023139>}
      triangle {<-23.048421,-13.725933,-33.895257>,<-32.515989,-13.542553,1.023078>,<-32.515989,-12.945515,1.023276>}
      triangle {<-23.048421,-13.128902,-33.895272>,<-23.048421,-13.725933,-33.895257>,<-32.515989,-12.945515,1.023276>}
      triangle {<-10.606092,-11.501682,-35.160684>,<-23.048421,-13.725933,-33.895257>,<-23.048421,-13.128902,-33.895272>}
      triangle {<-10.606092,-10.904652,-35.160684>,<-10.606092,-11.501682,-35.160684>,<-23.048421,-13.128902,-33.895272>}
      triangle {<-10.594831,-9.661518,1.023078>,<-10.606092,-11.501682,-35.160684>,<-10.606092,-10.904652,-35.160684>}
      triangle {<-10.594823,-9.064487,1.023139>,<-10.594831,-9.661518,1.023078>,<-10.606092,-10.904652,-35.160684>}
      triangle {<-23.048421,-13.725933,-33.895257>,<-10.606092,-11.501682,-35.160684>,<-10.594831,-9.661518,1.023078>}
      triangle {<-32.515989,-13.542553,1.023078>,<-23.048421,-13.725933,-33.895257>,<-10.594831,-9.661518,1.023078>}
      triangle {<10.157305,-9.064487,1.023139>,<32.078471,-12.945515,1.023276>,<22.610903,-13.128902,-33.895272>}
      triangle {<10.157305,-9.064487,1.023139>,<22.610903,-13.128902,-33.895272>,<10.168574,-10.904652,-35.160684>}
      triangle {<10.157305,-9.064487,1.023139>,<10.157313,-9.661518,1.023078>,<32.078471,-13.542553,1.023078>}
      triangle {<10.157305,-9.064487,1.023139>,<32.078471,-13.542553,1.023078>,<32.078471,-12.945515,1.023276>}
      triangle {<32.078471,-12.945515,1.023276>,<32.078471,-13.542553,1.023078>,<22.610903,-13.725933,-33.895257>}
      triangle {<32.078471,-12.945515,1.023276>,<22.610903,-13.725933,-33.895257>,<22.610903,-13.128902,-33.895272>}
      triangle {<22.610903,-13.128902,-33.895272>,<22.610903,-13.725933,-33.895257>,<10.168574,-11.501682,-35.160684>}
      triangle {<22.610903,-13.128902,-33.895272>,<10.168574,-11.501682,-35.160684>,<10.168574,-10.904652,-35.160684>}
      triangle {<10.168574,-10.904652,-35.160684>,<10.168574,-11.501682,-35.160684>,<10.157313,-9.661518,1.023078>}
      triangle {<10.168574,-10.904652,-35.160684>,<10.157313,-9.661518,1.023078>,<10.157305,-9.064487,1.023139>}
      triangle {<10.157313,-9.661518,1.023078>,<10.168574,-11.501682,-35.160684>,<22.610903,-13.725933,-33.895257>}
      triangle {<10.157313,-9.661518,1.023078>,<22.610903,-13.725933,-33.895257>,<32.078471,-13.542553,1.023078>}
      triangle {<-3.189298,-19.642887,-182.712213>,<3.020953,-19.642887,-182.712213>,<3.020953,-19.642887,-184.826348>}
      triangle {<-3.189298,-19.642887,-182.712213>,<3.020953,-19.642887,-184.826348>,<-3.189298,-19.642887,-184.826348>}
      triangle {<-3.189298,-19.642887,-182.712213>,<-3.189298,-26.176189,-182.712213>,<3.020953,-26.176189,-182.712213>}
      triangle {<-3.189298,-19.642887,-182.712213>,<3.020953,-26.176189,-182.712213>,<3.020953,-19.642887,-182.712213>}
      triangle {<3.020953,-19.642887,-182.712213>,<3.020953,-26.176189,-182.712213>,<3.020953,-26.176189,-184.826348>}
      triangle {<3.020953,-19.642887,-182.712213>,<3.020953,-26.176189,-184.826348>,<3.020953,-19.642887,-184.826348>}
      triangle {<3.020953,-19.642887,-184.826348>,<3.020953,-26.176189,-184.826348>,<-3.189298,-26.176189,-184.826348>}
      triangle {<3.020953,-19.642887,-184.826348>,<-3.189298,-26.176189,-184.826348>,<-3.189298,-19.642887,-184.826348>}
      triangle {<-3.189298,-19.642887,-184.826348>,<-3.189298,-26.176189,-184.826348>,<-3.189298,-26.176189,-182.712213>}
      triangle {<-3.189298,-19.642887,-184.826348>,<-3.189298,-26.176189,-182.712213>,<-3.189298,-19.642887,-182.712213>}
      triangle {<-3.189298,-26.176189,-182.712213>,<-3.189298,-26.176189,-184.826348>,<3.020953,-26.176189,-184.826348>}
      triangle {<-3.189298,-26.176189,-182.712213>,<3.020953,-26.176189,-184.826348>,<3.020953,-26.176189,-182.712213>}
      triangle {<-6.853857,-19.642887,-181.409448>,<-5.234334,-19.642887,-180.050500>,<-1.242460,-19.642887,-184.807824>}
      triangle {<-2.861982,-19.642887,-186.166772>,<-6.853857,-19.642887,-181.409448>,<-1.242460,-19.642887,-184.807824>}
      triangle {<-5.234334,-26.176189,-180.050500>,<-1.242460,-26.176189,-184.807824>,<-1.242460,-19.642887,-184.807824>}
      triangle {<-5.234334,-19.642887,-180.050500>,<-5.234334,-26.176189,-180.050500>,<-1.242460,-19.642887,-184.807824>}
      triangle {<-6.853857,-26.176189,-181.409448>,<-5.234334,-26.176189,-180.050500>,<-5.234334,-19.642887,-180.050500>}
      triangle {<-6.853857,-19.642887,-181.409448>,<-6.853857,-26.176189,-181.409448>,<-5.234334,-19.642887,-180.050500>}
      triangle {<-2.861982,-26.176189,-186.166772>,<-6.853857,-26.176189,-181.409448>,<-6.853857,-19.642887,-181.409448>}
      triangle {<-2.861982,-19.642887,-186.166772>,<-2.861982,-26.176189,-186.166772>,<-6.853857,-19.642887,-181.409448>}
      triangle {<-1.242460,-26.176189,-184.807824>,<-2.861982,-26.176189,-186.166772>,<-2.861982,-19.642887,-186.166772>}
      triangle {<-1.242460,-19.642887,-184.807824>,<-1.242460,-26.176189,-184.807824>,<-2.861982,-19.642887,-186.166772>}
      triangle {<-6.853857,-26.176189,-181.409448>,<-2.861982,-26.176189,-186.166772>,<-1.242460,-26.176189,-184.807824>}
      triangle {<-5.234334,-26.176189,-180.050500>,<-6.853857,-26.176189,-181.409448>,<-1.242460,-26.176189,-184.807824>}
      triangle {<-6.261793,-21.325214,-183.573907>,<6.093432,-21.325214,-183.573907>,<4.154322,-21.325214,-185.688043>}
      triangle {<-6.261793,-21.325214,-183.573907>,<4.154322,-21.325214,-185.688043>,<-4.322675,-21.325214,-185.688043>}
      triangle {<-6.261793,-21.325214,-183.573907>,<-6.261793,-24.493862,-183.573907>,<6.093432,-24.493862,-183.573907>}
      triangle {<-6.261793,-21.325214,-183.573907>,<6.093432,-24.493862,-183.573907>,<6.093432,-21.325214,-183.573907>}
      triangle {<6.093432,-21.325214,-183.573907>,<6.093432,-24.493862,-183.573907>,<4.154322,-24.493862,-185.688043>}
      triangle {<6.093432,-21.325214,-183.573907>,<4.154322,-24.493862,-185.688043>,<4.154322,-21.325214,-185.688043>}
      triangle {<4.154322,-21.325214,-185.688043>,<4.154322,-24.493862,-185.688043>,<-4.322675,-24.493862,-185.688043>}
      triangle {<4.154322,-21.325214,-185.688043>,<-4.322675,-24.493862,-185.688043>,<-4.322675,-21.325214,-185.688043>}
      triangle {<-4.322675,-21.325214,-185.688043>,<-4.322675,-24.493862,-185.688043>,<-6.261793,-24.493862,-183.573907>}
      triangle {<-4.322675,-21.325214,-185.688043>,<-6.261793,-24.493862,-183.573907>,<-6.261793,-21.325214,-183.573907>}
      triangle {<-6.261793,-24.493862,-183.573907>,<-4.322675,-24.493862,-185.688043>,<4.154322,-24.493862,-185.688043>}
      triangle {<-6.261793,-24.493862,-183.573907>,<4.154322,-24.493862,-185.688043>,<6.093432,-24.493862,-183.573907>}
      triangle {<0.941988,-19.642887,-184.807824>,<4.933970,-19.642887,-180.050500>,<6.553492,-19.642887,-181.409448>}
      triangle {<0.941988,-19.642887,-184.807824>,<6.553492,-19.642887,-181.409448>,<2.561511,-19.642887,-186.166772>}
      triangle {<0.941988,-19.642887,-184.807824>,<0.941988,-26.176189,-184.807824>,<4.933863,-26.176189,-180.050500>}
      triangle {<0.941988,-19.642887,-184.807824>,<4.933863,-26.176189,-180.050500>,<4.933970,-19.642887,-180.050500>}
      triangle {<4.933970,-19.642887,-180.050500>,<4.933863,-26.176189,-180.050500>,<6.553385,-26.176189,-181.409448>}
      triangle {<4.933970,-19.642887,-180.050500>,<6.553385,-26.176189,-181.409448>,<6.553492,-19.642887,-181.409448>}
      triangle {<6.553492,-19.642887,-181.409448>,<6.553385,-26.176189,-181.409448>,<2.561511,-26.176197,-186.166772>}
      triangle {<6.553492,-19.642887,-181.409448>,<2.561511,-26.176197,-186.166772>,<2.561511,-19.642887,-186.166772>}
      triangle {<2.561511,-19.642887,-186.166772>,<2.561511,-26.176197,-186.166772>,<0.941988,-26.176189,-184.807824>}
      triangle {<2.561511,-19.642887,-186.166772>,<0.941988,-26.176189,-184.807824>,<0.941988,-19.642887,-184.807824>}
      triangle {<0.941988,-26.176189,-184.807824>,<2.561511,-26.176197,-186.166772>,<6.553385,-26.176189,-181.409448>}
      triangle {<0.941988,-26.176189,-184.807824>,<6.553385,-26.176189,-181.409448>,<4.933863,-26.176189,-180.050500>}
      texture{_HullO01}
    }
    //_HullU01
    mesh{
      triangle {<-71.324712,-25.308521,33.041938>,<-105.292829,-25.337582,151.657020>,<-0.007925,-45.139729,189.491493>}
      triangle {<-65.485448,-26.317722,33.329917>,<-71.324712,-25.308521,33.041938>,<-0.007925,-45.139729,189.491493>}
      triangle {<-45.061063,-25.406925,-56.204461>,<-67.107458,-25.376804,19.781363>,<-62.565809,-26.361980,24.088080>}
      triangle {<-39.165048,-26.396267,-56.518609>,<-45.061063,-25.406925,-56.204461>,<-62.565809,-26.361980,24.088080>}
      triangle {<-7.163518,-25.511738,-185.842065>,<-31.049066,-25.517918,-102.625909>,<-27.914541,-26.301510,-97.540215>}
      triangle {<-0.007925,-45.139729,189.491493>,<-27.914541,-26.301510,-97.540215>,<-39.165048,-26.396267,-56.518609>}
      triangle {<-0.007925,-45.139729,189.491493>,<-39.165048,-26.396267,-56.518609>,<-62.565809,-26.361980,24.088080>}
      triangle {<-65.485448,-26.317722,33.329917>,<-0.007925,-45.139729,189.491493>,<-62.565809,-26.361980,24.088080>}
      triangle {<-7.163518,-26.169918,-185.816186>,<-7.163518,-25.511738,-185.842065>,<-0.007917,-26.553417,-189.468072>}
      triangle {<-0.007917,-27.211597,-189.492211>,<-7.163518,-26.169918,-185.816186>,<-0.007917,-26.553417,-189.468072>}
      triangle {<-31.049039,-26.176098,-102.700006>,<-31.049066,-25.517918,-102.625909>,<-7.163518,-25.511738,-185.842065>}
      triangle {<-7.163518,-26.169918,-185.816186>,<-31.049039,-26.176098,-102.700006>,<-7.163518,-25.511738,-185.842065>}
      triangle {<-27.914541,-26.959690,-97.614343>,<-27.914541,-26.301510,-97.540215>,<-31.049066,-25.517918,-102.625909>}
      triangle {<-31.049039,-26.176098,-102.700006>,<-27.914541,-26.959690,-97.614343>,<-31.049066,-25.517918,-102.625909>}
      triangle {<-39.165048,-27.054447,-56.592721>,<-39.165048,-26.396267,-56.518609>,<-27.914541,-26.301510,-97.540215>}
      triangle {<-27.914541,-26.959690,-97.614343>,<-39.165048,-27.054447,-56.592721>,<-27.914541,-26.301510,-97.540215>}
      triangle {<-45.061063,-26.065113,-56.278573>,<-45.061063,-25.406925,-56.204461>,<-39.165048,-26.396267,-56.518609>}
      triangle {<-39.165048,-27.054447,-56.592721>,<-45.061063,-26.065113,-56.278573>,<-39.165048,-26.396267,-56.518609>}
      triangle {<-67.107458,-26.034992,19.707252>,<-67.107458,-25.376804,19.781363>,<-45.061063,-25.406925,-56.204461>}
      triangle {<-45.061063,-26.065113,-56.278573>,<-67.107458,-26.034992,19.707252>,<-45.061063,-25.406925,-56.204461>}
      triangle {<-62.565809,-27.020161,24.013984>,<-62.565809,-26.361980,24.088080>,<-67.107458,-25.376804,19.781363>}
      triangle {<-67.107458,-26.034992,19.707252>,<-62.565809,-27.020161,24.013984>,<-67.107458,-25.376804,19.781363>}
      triangle {<-65.485448,-26.975903,33.255805>,<-65.485448,-26.317722,33.329917>,<-62.565809,-26.361980,24.088080>}
      triangle {<-62.565809,-27.020161,24.013984>,<-65.485448,-26.975903,33.255805>,<-62.565809,-26.361980,24.088080>}
      triangle {<-71.324712,-25.966709,32.967841>,<-71.324712,-25.308521,33.041938>,<-65.485448,-26.317722,33.329917>}
      triangle {<-65.485448,-26.975903,33.255805>,<-71.324712,-25.966709,32.967841>,<-65.485448,-26.317722,33.329917>}
      triangle {<-105.292829,-25.995762,151.582908>,<-105.292829,-25.337582,151.657020>,<-71.324712,-25.308521,33.041938>}
      triangle {<-71.324712,-25.966709,32.967841>,<-105.292829,-25.995762,151.582908>,<-71.324712,-25.308521,33.041938>}
      triangle {<-0.007925,-45.797932,189.462852>,<-0.007925,-45.139729,189.491493>,<-105.292829,-25.337582,151.657020>}
      triangle {<-105.292829,-25.995762,151.582908>,<-0.007925,-45.797932,189.462852>,<-105.292829,-25.337582,151.657020>}
      triangle {<-0.007925,-45.797932,189.462852>,<-105.292829,-25.995762,151.582908>,<-71.324712,-25.966709,32.967841>}
      triangle {<-0.007925,-45.797932,189.462852>,<-71.324712,-25.966709,32.967841>,<-65.485448,-26.975903,33.255805>}
      triangle {<-62.565809,-27.020161,24.013984>,<-67.107458,-26.034992,19.707252>,<-45.061063,-26.065113,-56.278573>}
      triangle {<-62.565809,-27.020161,24.013984>,<-45.061063,-26.065113,-56.278573>,<-39.165048,-27.054447,-56.592721>}
      triangle {<-27.914541,-26.959690,-97.614343>,<-31.049039,-26.176098,-102.700006>,<-7.163518,-26.169918,-185.816186>}
      triangle {<-39.165048,-27.054447,-56.592721>,<-27.914541,-26.959690,-97.614343>,<-0.007925,-45.797932,189.462852>}
      triangle {<-62.565809,-27.020161,24.013984>,<-39.165048,-27.054447,-56.592721>,<-0.007925,-45.797932,189.462852>}
      triangle {<-62.565809,-27.020161,24.013984>,<-0.007925,-45.797932,189.462852>,<-65.485448,-26.975903,33.255805>}
      triangle {<-0.007925,-45.139729,189.491493>,<105.292017,-25.337582,151.657020>,<71.323939,-25.308521,33.041938>}
      triangle {<-0.007925,-45.139729,189.491493>,<71.323939,-25.308521,33.041938>,<65.484660,-26.317722,33.329917>}
      triangle {<62.565012,-26.361980,24.088080>,<67.106669,-25.376797,19.781363>,<45.060282,-25.406925,-56.204431>}
      triangle {<62.565012,-26.361980,24.088080>,<45.060282,-25.406925,-56.204431>,<39.164256,-26.396267,-56.518594>}
      triangle {<27.913844,-26.301510,-97.540215>,<31.048327,-25.517918,-102.625909>,<7.162798,-25.511730,-185.842065>}
      triangle {<39.164256,-26.396267,-56.518594>,<27.913844,-26.301510,-97.540215>,<-0.007925,-45.139729,189.491493>}
      triangle {<62.565012,-26.361980,24.088080>,<39.164256,-26.396267,-56.518594>,<-0.007925,-45.139729,189.491493>}
      triangle {<62.565012,-26.361980,24.088080>,<-0.007925,-45.139729,189.491493>,<65.484660,-26.317722,33.329917>}
      triangle {<-0.007917,-26.553417,-189.468072>,<7.162798,-25.511730,-185.842065>,<7.162798,-26.169918,-185.816186>}
      triangle {<-0.007917,-26.553417,-189.468072>,<7.162798,-26.169918,-185.816186>,<-0.007917,-27.211597,-189.492211>}
      triangle {<7.162798,-25.511730,-185.842065>,<31.048327,-25.517918,-102.625909>,<31.048327,-26.176098,-102.700006>}
      triangle {<7.162798,-25.511730,-185.842065>,<31.048327,-26.176098,-102.700006>,<7.162798,-26.169918,-185.816186>}
      triangle {<31.048327,-25.517918,-102.625909>,<27.913844,-26.301510,-97.540215>,<27.913844,-26.959690,-97.614343>}
      triangle {<31.048327,-25.517918,-102.625909>,<27.913844,-26.959690,-97.614343>,<31.048327,-26.176098,-102.700006>}
      triangle {<27.913844,-26.301510,-97.540215>,<39.164256,-26.396267,-56.518594>,<39.164256,-27.054447,-56.592690>}
      triangle {<27.913844,-26.301510,-97.540215>,<39.164256,-27.054447,-56.592690>,<27.913844,-26.959690,-97.614343>}
      triangle {<39.164256,-26.396267,-56.518594>,<45.060282,-25.406925,-56.204431>,<45.060282,-26.065113,-56.278558>}
      triangle {<39.164256,-26.396267,-56.518594>,<45.060282,-26.065113,-56.278558>,<39.164256,-27.054447,-56.592690>}
      triangle {<45.060282,-25.406925,-56.204431>,<67.106669,-25.376797,19.781363>,<67.106669,-26.034992,19.707252>}
      triangle {<45.060282,-25.406925,-56.204431>,<67.106669,-26.034992,19.707252>,<45.060282,-26.065113,-56.278558>}
      triangle {<67.106669,-25.376797,19.781363>,<62.565012,-26.361980,24.088080>,<62.565012,-27.020161,24.013984>}
      triangle {<67.106669,-25.376797,19.781363>,<62.565012,-27.020161,24.013984>,<67.106669,-26.034992,19.707252>}
      triangle {<62.565012,-26.361980,24.088080>,<65.484660,-26.317722,33.329917>,<65.484660,-26.975903,33.255805>}
      triangle {<62.565012,-26.361980,24.088080>,<65.484660,-26.975903,33.255805>,<62.565012,-27.020161,24.013984>}
      triangle {<65.484660,-26.317722,33.329917>,<71.323939,-25.308521,33.041938>,<71.323924,-25.966709,32.967841>}
      triangle {<65.484660,-26.317722,33.329917>,<71.323924,-25.966709,32.967841>,<65.484660,-26.975903,33.255805>}
      triangle {<71.323939,-25.308521,33.041938>,<105.292017,-25.337582,151.657020>,<105.292017,-25.995754,151.582908>}
      triangle {<71.323939,-25.308521,33.041938>,<105.292017,-25.995754,151.582908>,<71.323924,-25.966709,32.967841>}
      triangle {<105.292017,-25.337582,151.657020>,<-0.007925,-45.139729,189.491493>,<-0.007925,-45.797932,189.462852>}
      triangle {<105.292017,-25.337582,151.657020>,<-0.007925,-45.797932,189.462852>,<105.292017,-25.995754,151.582908>}
      triangle {<71.323924,-25.966709,32.967841>,<105.292017,-25.995754,151.582908>,<-0.007925,-45.797932,189.462852>}
      triangle {<65.484660,-26.975903,33.255805>,<71.323924,-25.966709,32.967841>,<-0.007925,-45.797932,189.462852>}
      triangle {<45.060282,-26.065113,-56.278558>,<67.106669,-26.034992,19.707252>,<62.565012,-27.020161,24.013984>}
      triangle {<39.164256,-27.054447,-56.592690>,<45.060282,-26.065113,-56.278558>,<62.565012,-27.020161,24.013984>}
      triangle {<7.162798,-26.169918,-185.816186>,<31.048327,-26.176098,-102.700006>,<27.913844,-26.959690,-97.614343>}
      triangle {<-0.007925,-45.797932,189.462852>,<27.913844,-26.959690,-97.614343>,<39.164256,-27.054447,-56.592690>}
      triangle {<-0.007925,-45.797932,189.462852>,<39.164256,-27.054447,-56.592690>,<62.565012,-27.020161,24.013984>}
      triangle {<65.484660,-26.975903,33.255805>,<-0.007925,-45.797932,189.462852>,<62.565012,-27.020161,24.013984>}
      triangle {<-14.923574,-32.677303,-12.731591>,<-0.007925,-45.139729,189.491493>,<-0.007917,-35.221569,-12.731591>}
      triangle {<-14.923574,-30.929371,-48.373254>,<-7.163518,-25.511738,-185.842065>,<-27.914541,-26.301510,-97.540215>}
      triangle {<-0.007917,-33.473507,-48.373254>,<-7.163518,-25.511738,-185.842065>,<-14.923574,-30.929371,-48.373254>}
      triangle {<-7.163518,-25.511738,-185.842065>,<-0.007917,-33.473507,-48.373254>,<-0.007917,-26.553417,-189.468072>}
      triangle {<-0.007917,-26.553417,-189.468072>,<-0.007917,-33.473507,-48.373254>,<7.162798,-25.511730,-185.842065>}
      triangle {<-27.914541,-26.301510,-97.540215>,<-0.007925,-45.139729,189.491493>,<-14.923574,-32.677303,-12.731591>}
      triangle {<-14.923574,-32.677303,-12.731591>,<-14.923574,-30.929371,-48.373254>,<-27.914541,-26.301510,-97.540215>}
      triangle {<-0.007917,-35.881046,-12.731591>,<-0.007925,-45.797932,189.462852>,<-14.923574,-33.337566,-12.731591>}
      triangle {<-0.007917,-34.132961,-48.373254>,<-0.007917,-27.211597,-189.492211>,<7.162798,-26.169918,-185.816186>}
      triangle {<-0.007917,-27.211597,-189.492211>,<-0.007917,-34.132961,-48.373254>,<-7.163518,-26.169918,-185.816186>}
      triangle {<-7.163518,-26.169918,-185.816186>,<-0.007917,-34.132961,-48.373254>,<-27.914541,-26.959690,-97.614343>}
      triangle {<-0.007925,-45.797932,189.462852>,<-27.914541,-26.959690,-97.614343>,<-14.923574,-33.337566,-12.731591>}
      triangle {<-14.923574,-31.589252,-48.373254>,<-27.914541,-26.959690,-97.614343>,<-0.007917,-34.132961,-48.373254>}
      triangle {<-14.923574,-31.589252,-48.373254>,<-14.923574,-33.337566,-12.731591>,<-27.914541,-26.959690,-97.614343>}
      triangle {<-0.007917,-35.221569,-12.731591>,<-0.007925,-45.139729,189.491493>,<14.755175,-32.705021,-12.731591>}
      triangle {<7.162798,-25.511730,-185.842065>,<-0.007917,-33.473507,-48.373254>,<27.913844,-26.301510,-97.540215>}
      triangle {<-0.007925,-45.139729,189.491493>,<27.913844,-26.301510,-97.540215>,<14.755175,-32.705021,-12.731591>}
      triangle {<14.755175,-32.705021,-12.731591>,<27.913844,-26.301510,-97.540215>,<14.755175,-30.957317,-48.373254>}
      triangle {<27.913844,-26.301510,-97.540215>,<-0.007917,-33.473507,-48.373254>,<14.755175,-30.957317,-48.373254>}
      triangle {<-0.007925,-45.797932,189.462852>,<-0.007917,-35.881046,-12.731591>,<14.755175,-33.365253,-12.731591>}
      triangle {<-0.007917,-34.132961,-48.373254>,<7.162798,-26.169918,-185.816186>,<14.755175,-31.617161,-48.373254>}
      triangle {<14.755175,-31.617161,-48.373254>,<7.162798,-26.169918,-185.816186>,<27.913844,-26.959690,-97.614343>}
      triangle {<27.913844,-26.959690,-97.614343>,<-0.007925,-45.797932,189.462852>,<14.755175,-33.365253,-12.731591>}
      triangle {<27.913844,-26.959690,-97.614343>,<14.755175,-33.365253,-12.731591>,<14.755175,-31.617161,-48.373254>}
      triangle {<-14.923574,-33.337566,-12.731591>,<-0.007917,-35.221569,-12.731591>,<-0.007917,-35.881046,-12.731591>}
      triangle {<-0.007917,-35.221569,-12.731591>,<-14.923574,-33.337566,-12.731591>,<-14.923574,-32.677303,-12.731591>}
      triangle {<-0.007917,-33.473507,-48.373254>,<-14.923574,-30.929371,-48.373254>,<-0.007917,-34.132961,-48.373254>}
      triangle {<-14.923574,-32.677303,-12.731591>,<-14.923574,-33.337566,-12.731591>,<-14.923574,-30.929371,-48.373254>}
      triangle {<-0.007917,-34.132961,-48.373254>,<-14.923574,-30.929371,-48.373254>,<-14.923574,-31.589252,-48.373254>}
      triangle {<-14.923574,-30.929371,-48.373254>,<-14.923574,-33.337566,-12.731591>,<-14.923574,-31.589252,-48.373254>}
      triangle {<14.755175,-33.365253,-12.731591>,<-0.007917,-35.221569,-12.731591>,<14.755175,-32.705021,-12.731591>}
      triangle {<-0.007917,-35.221569,-12.731591>,<14.755175,-33.365253,-12.731591>,<-0.007917,-35.881046,-12.731591>}
      triangle {<14.755175,-31.617161,-48.373254>,<-0.007917,-33.473507,-48.373254>,<-0.007917,-34.132961,-48.373254>}
      triangle {<14.755175,-32.705021,-12.731591>,<14.755175,-31.617161,-48.373254>,<14.755175,-33.365253,-12.731591>}
      triangle {<14.755175,-31.617161,-48.373254>,<14.755175,-32.705021,-12.731591>,<14.755175,-30.957317,-48.373254>}
      triangle {<14.755175,-31.617161,-48.373254>,<14.755175,-30.957317,-48.373254>,<-0.007917,-33.473507,-48.373254>}
      triangle {<-84.892690,-28.978878,140.704352>,<-63.095922,-31.645893,113.864493>,<-63.036649,-33.344318,146.634254>}
      triangle {<-84.892690,-28.978878,140.704352>,<-77.655599,-29.117359,117.284575>,<-63.095922,-31.645893,113.864493>}
      triangle {<-84.892690,-28.978878,140.704352>,<-63.036649,-32.848026,146.634254>,<-84.892690,-28.482594,140.704352>}
      triangle {<-84.892690,-28.978878,140.704352>,<-63.036649,-33.344318,146.634254>,<-63.036649,-32.848026,146.634254>}
      triangle {<-63.036649,-33.344318,146.634254>,<-63.095922,-31.149609,113.864493>,<-63.036649,-32.848026,146.634254>}
      triangle {<-63.036649,-33.344318,146.634254>,<-63.095922,-31.645893,113.864493>,<-63.095922,-31.149609,113.864493>}
      triangle {<-63.095922,-31.645893,113.864493>,<-77.655599,-28.621067,117.284575>,<-63.095922,-31.149609,113.864493>}
      triangle {<-63.095922,-31.645893,113.864493>,<-77.655599,-29.117359,117.284575>,<-77.655599,-28.621067,117.284575>}
      triangle {<-77.655599,-29.117359,117.284575>,<-84.892690,-28.482594,140.704352>,<-77.655599,-28.621067,117.284575>}
      triangle {<-77.655599,-29.117359,117.284575>,<-84.892690,-28.978878,140.704352>,<-84.892690,-28.482594,140.704352>}
      triangle {<-84.892690,-28.482594,140.704352>,<-63.095922,-31.149609,113.864493>,<-77.655599,-28.621067,117.284575>}
      triangle {<-84.892690,-28.482594,140.704352>,<-63.036649,-32.848026,146.634254>,<-63.095922,-31.149609,113.864493>}
      triangle {<67.360117,-33.344318,146.634254>,<67.419398,-31.645893,113.864493>,<89.216166,-28.978878,140.704352>}
      triangle {<67.419398,-31.645893,113.864493>,<81.979075,-29.117359,117.284575>,<89.216166,-28.978878,140.704352>}
      triangle {<89.216166,-28.482594,140.704352>,<67.360117,-32.848026,146.634254>,<89.216166,-28.978878,140.704352>}
      triangle {<67.360117,-32.848026,146.634254>,<67.360117,-33.344318,146.634254>,<89.216166,-28.978878,140.704352>}
      triangle {<67.360117,-32.848026,146.634254>,<67.419398,-31.149609,113.864493>,<67.360117,-33.344318,146.634254>}
      triangle {<67.419398,-31.149609,113.864493>,<67.419398,-31.645893,113.864493>,<67.360117,-33.344318,146.634254>}
      triangle {<67.419398,-31.149609,113.864493>,<81.979075,-28.621067,117.284575>,<67.419398,-31.645893,113.864493>}
      triangle {<81.979075,-28.621067,117.284575>,<81.979075,-29.117359,117.284575>,<67.419398,-31.645893,113.864493>}
      triangle {<81.979075,-28.621067,117.284575>,<89.216166,-28.482594,140.704352>,<81.979075,-29.117359,117.284575>}
      triangle {<89.216166,-28.482594,140.704352>,<89.216166,-28.978878,140.704352>,<81.979075,-29.117359,117.284575>}
      triangle {<81.979075,-28.621067,117.284575>,<67.419398,-31.149609,113.864493>,<89.216166,-28.482594,140.704352>}
      triangle {<67.419398,-31.149609,113.864493>,<67.360117,-32.848026,146.634254>,<89.216166,-28.482594,140.704352>}
      triangle {<22.150965,-40.476688,143.906943>,<25.044581,-39.888515,143.135169>,<23.930308,-40.236752,145.894797>}
      triangle {<16.005717,-34.376667,-3.094888>,<21.494723,-33.262005,-4.536782>,<19.769351,-34.547390,14.827613>}
      triangle {<15.286204,-34.733334,1.353156>,<16.005717,-34.376667,-3.094888>,<19.769351,-34.547390,14.827613>}
      triangle {<15.286204,-34.733334,1.353156>,<19.769351,-34.547390,14.827613>,<16.498209,-35.161861,14.679786>}
      triangle {<29.992701,-39.185917,147.947761>,<39.469981,-37.888752,158.147376>,<33.105814,-39.620762,168.711524>}
      triangle {<29.992701,-39.185917,147.947761>,<33.105814,-39.620762,168.711524>,<28.863062,-40.289783,165.931495>}
      triangle {<26.909968,-39.835796,149.240699>,<29.992701,-39.185917,147.947761>,<28.863062,-40.289783,165.931495>}
      triangle {<26.909968,-39.835796,149.240699>,<28.863062,-40.289783,165.931495>,<-0.001516,-45.782574,166.055885>}
      triangle {<23.930308,-40.236752,145.894797>,<26.909968,-39.835796,149.240699>,<-0.001516,-45.782574,166.055885>}
      triangle {<22.150965,-40.476688,143.906943>,<23.930308,-40.236752,145.894797>,<-0.001516,-45.782574,166.055885>}
      triangle {<18.486521,-40.970715,139.810706>,<22.150965,-40.476688,143.906943>,<-0.001516,-45.782574,166.055885>}
      triangle {<-0.001554,-37.640385,1.375983>,<15.286204,-34.733334,1.353156>,<16.498209,-35.161861,14.679786>}
      triangle {<-0.001554,-37.640385,1.375983>,<16.498209,-35.161861,14.679786>,<13.832728,-36.101635,23.440513>}
      triangle {<9.770625,-41.983486,126.786757>,<19.996462,-40.562878,137.367057>,<18.486521,-40.970715,139.810706>}
      triangle {<9.770625,-41.983486,126.786757>,<18.486521,-40.970715,139.810706>,<-0.001516,-45.782574,166.055885>}
      triangle {<9.770625,-41.983486,126.786757>,<-0.001516,-45.782574,166.055885>,<-0.001554,-37.640385,1.375983>}
      triangle {<9.770609,-40.830357,103.463744>,<9.770625,-41.983486,126.786757>,<-0.001554,-37.640385,1.375983>}
      triangle {<13.832728,-36.101635,23.440513>,<16.272616,-35.796749,26.653922>,<9.504740,-38.252575,50.304816>}
      triangle {<9.346354,-38.718189,59.113334>,<17.831881,-37.534260,67.790595>,<17.831881,-38.840351,94.206840>}
      triangle {<9.346354,-38.718189,59.113334>,<17.831881,-38.840351,94.206840>,<9.770609,-40.830357,103.463744>}
      triangle {<9.346354,-38.718189,59.113334>,<9.770609,-40.830357,103.463744>,<-0.001554,-37.640385,1.375983>}
      triangle {<9.504740,-38.252575,50.304816>,<9.346354,-38.718189,59.113334>,<-0.001554,-37.640385,1.375983>}
      triangle {<9.504740,-38.252575,50.304816>,<-0.001554,-37.640385,1.375983>,<13.832728,-36.101635,23.440513>}
      triangle {<15.286204,-33.255566,1.353156>,<15.286204,-34.733334,1.353156>,<-0.001554,-37.640385,1.375983>}
      triangle {<-0.001554,-36.162609,1.375998>,<15.286204,-33.255566,1.353156>,<-0.001554,-37.640385,1.375983>}
      triangle {<16.005717,-32.898891,-3.094857>,<16.005717,-34.376667,-3.094888>,<15.286204,-34.733334,1.353156>}
      triangle {<15.286204,-33.255566,1.353156>,<16.005717,-32.898891,-3.094857>,<15.286204,-34.733334,1.353156>}
      triangle {<21.494730,-31.784237,-4.536782>,<21.494723,-33.262005,-4.536782>,<16.005717,-34.376667,-3.094888>}
      triangle {<16.005717,-32.898891,-3.094857>,<21.494730,-31.784237,-4.536782>,<16.005717,-34.376667,-3.094888>}
      triangle {<19.769351,-33.069622,14.827613>,<19.769351,-34.547390,14.827613>,<21.494723,-33.262005,-4.536782>}
      triangle {<21.494730,-31.784237,-4.536782>,<19.769351,-33.069622,14.827613>,<21.494723,-33.262005,-4.536782>}
      triangle {<16.498209,-33.684078,14.679816>,<16.498209,-35.161861,14.679786>,<19.769351,-34.547390,14.827613>}
      triangle {<19.769351,-33.069622,14.827613>,<16.498209,-33.684078,14.679816>,<19.769351,-34.547390,14.827613>}
      triangle {<13.832728,-34.623867,23.439795>,<13.832728,-36.101635,23.440513>,<16.498209,-35.161861,14.679786>}
      triangle {<16.498209,-33.684078,14.679816>,<13.832728,-34.623867,23.439795>,<16.498209,-35.161861,14.679786>}
      triangle {<16.272616,-34.318981,26.653235>,<16.272616,-35.796749,26.653922>,<13.832728,-36.101635,23.440513>}
      triangle {<13.832728,-34.623867,23.439795>,<16.272616,-34.318981,26.653235>,<13.832728,-36.101635,23.440513>}
      triangle {<9.504740,-36.774807,50.304816>,<9.504740,-38.252575,50.304816>,<16.272616,-35.796749,26.653922>}
      triangle {<16.272616,-34.318981,26.653235>,<9.504740,-36.774807,50.304816>,<16.272616,-35.796749,26.653922>}
      triangle {<9.346354,-37.240414,59.113341>,<9.346354,-38.718189,59.113334>,<9.504740,-38.252575,50.304816>}
      triangle {<9.504740,-36.774807,50.304816>,<9.346354,-37.240414,59.113341>,<9.504740,-38.252575,50.304816>}
      triangle {<17.831881,-36.056492,67.790595>,<17.831881,-37.534260,67.790595>,<9.346354,-38.718189,59.113334>}
      triangle {<9.346354,-37.240414,59.113341>,<17.831881,-36.056492,67.790595>,<9.346354,-38.718189,59.113334>}
      triangle {<17.831881,-37.362583,94.206840>,<17.831881,-38.840351,94.206840>,<17.831881,-37.534260,67.790595>}
      triangle {<17.831881,-36.056492,67.790595>,<17.831881,-37.362583,94.206840>,<17.831881,-37.534260,67.790595>}
      triangle {<9.770609,-39.352581,103.463767>,<9.770609,-40.830357,103.463744>,<17.831881,-38.840351,94.206840>}
      triangle {<17.831881,-37.362583,94.206840>,<9.770609,-39.352581,103.463767>,<17.831881,-38.840351,94.206840>}
      triangle {<9.770625,-40.505711,126.786757>,<9.770625,-41.983486,126.786757>,<9.770609,-40.830357,103.463744>}
      triangle {<9.770609,-39.352581,103.463767>,<9.770625,-40.505711,126.786757>,<9.770609,-40.830357,103.463744>}
      triangle {<19.996462,-39.085102,137.367057>,<19.996462,-40.562878,137.367057>,<9.770625,-41.983486,126.786757>}
      triangle {<9.770625,-40.505711,126.786757>,<19.996462,-39.085102,137.367057>,<9.770625,-41.983486,126.786757>}
      triangle {<18.486529,-39.492939,139.810721>,<18.486521,-40.970715,139.810706>,<19.996462,-40.562878,137.367057>}
      triangle {<19.996462,-39.085102,137.367057>,<18.486529,-39.492939,139.810721>,<19.996462,-40.562878,137.367057>}
      triangle {<22.101748,-39.008282,143.906943>,<22.150965,-40.476688,143.906943>,<18.486521,-40.970715,139.810706>}
      triangle {<18.486529,-39.492939,139.810721>,<22.101748,-39.008282,143.906943>,<18.486521,-40.970715,139.810706>}
      triangle {<25.044581,-38.410740,143.135169>,<25.044581,-39.888515,143.135169>,<22.150965,-40.476688,143.906943>}
      triangle {<22.101748,-39.008282,143.906943>,<25.044581,-38.410740,143.135169>,<22.150965,-40.476688,143.906943>}
      triangle {<23.930308,-38.758976,145.894797>,<23.930308,-40.236752,145.894797>,<25.044581,-39.888515,143.135169>}
      triangle {<25.044581,-38.410740,143.135169>,<23.930308,-38.758976,145.894797>,<25.044581,-39.888515,143.135169>}
      triangle {<26.860743,-38.369808,149.289908>,<26.909968,-39.835796,149.240699>,<23.930308,-40.236752,145.894797>}
      triangle {<23.930308,-38.758976,145.894797>,<26.860743,-38.369808,149.289908>,<23.930308,-40.236752,145.894797>}
      triangle {<29.992701,-37.708141,147.947761>,<29.992701,-39.185917,147.947761>,<26.909968,-39.835796,149.240699>}
      triangle {<26.860743,-38.369808,149.289908>,<29.992701,-37.708141,147.947761>,<26.909968,-39.835796,149.240699>}
      triangle {<39.469981,-36.410992,158.147376>,<39.469981,-37.888752,158.147376>,<29.992701,-39.185917,147.947761>}
      triangle {<29.992701,-37.708141,147.947761>,<39.469981,-36.410992,158.147376>,<29.992701,-39.185917,147.947761>}
      triangle {<33.105814,-38.142994,168.711524>,<33.105814,-39.620762,168.711524>,<39.469981,-37.888752,158.147376>}
      triangle {<39.469981,-36.410992,158.147376>,<33.105814,-38.142994,168.711524>,<39.469981,-37.888752,158.147376>}
      triangle {<28.863062,-38.812023,165.931479>,<28.863062,-40.289783,165.931495>,<33.105814,-39.620762,168.711524>}
      triangle {<33.105814,-38.142994,168.711524>,<28.863062,-38.812023,165.931479>,<33.105814,-39.620762,168.711524>}
      triangle {<-0.001516,-44.304798,166.055885>,<-0.001516,-45.782574,166.055885>,<28.863062,-40.289783,165.931495>}
      triangle {<28.863062,-38.812023,165.931479>,<-0.001516,-44.304798,166.055885>,<28.863062,-40.289783,165.931495>}
      triangle {<-0.001554,-36.162609,1.375998>,<-0.001554,-37.640385,1.375983>,<-0.001516,-45.782574,166.055885>}
      triangle {<-0.001516,-44.304798,166.055885>,<-0.001554,-36.162609,1.375998>,<-0.001516,-45.782574,166.055885>}
      triangle {<23.930308,-38.758976,145.894797>,<25.044581,-38.410740,143.135169>,<22.101748,-39.008282,143.906943>}
      triangle {<19.769351,-33.069622,14.827613>,<21.494730,-31.784237,-4.536782>,<16.005717,-32.898891,-3.094857>}
      triangle {<19.769351,-33.069622,14.827613>,<16.005717,-32.898891,-3.094857>,<15.286204,-33.255566,1.353156>}
      triangle {<16.498209,-33.684078,14.679816>,<19.769351,-33.069622,14.827613>,<15.286204,-33.255566,1.353156>}
      triangle {<33.105814,-38.142994,168.711524>,<39.469981,-36.410992,158.147376>,<29.992701,-37.708141,147.947761>}
      triangle {<28.863062,-38.812023,165.931479>,<33.105814,-38.142994,168.711524>,<29.992701,-37.708141,147.947761>}
      triangle {<28.863062,-38.812023,165.931479>,<29.992701,-37.708141,147.947761>,<26.860743,-38.369808,149.289908>}
      triangle {<-0.001516,-44.304798,166.055885>,<28.863062,-38.812023,165.931479>,<26.860743,-38.369808,149.289908>}
      triangle {<-0.001516,-44.304798,166.055885>,<26.860743,-38.369808,149.289908>,<23.930308,-38.758976,145.894797>}
      triangle {<-0.001516,-44.304798,166.055885>,<23.930308,-38.758976,145.894797>,<22.101748,-39.008282,143.906943>}
      triangle {<-0.001516,-44.304798,166.055885>,<22.101748,-39.008282,143.906943>,<18.486529,-39.492939,139.810721>}
      triangle {<16.498209,-33.684078,14.679816>,<15.286204,-33.255566,1.353156>,<-0.001554,-36.162609,1.375998>}
      triangle {<13.832728,-34.623867,23.439795>,<16.498209,-33.684078,14.679816>,<-0.001554,-36.162609,1.375998>}
      triangle {<18.486529,-39.492939,139.810721>,<19.996462,-39.085102,137.367057>,<9.770625,-40.505711,126.786757>}
      triangle {<-0.001516,-44.304798,166.055885>,<18.486529,-39.492939,139.810721>,<9.770625,-40.505711,126.786757>}
      triangle {<-0.001554,-36.162609,1.375998>,<-0.001516,-44.304798,166.055885>,<9.770625,-40.505711,126.786757>}
      triangle {<-0.001554,-36.162609,1.375998>,<9.770625,-40.505711,126.786757>,<9.770609,-39.352581,103.463767>}
      triangle {<9.504740,-36.774807,50.304816>,<16.272616,-34.318981,26.653235>,<13.832728,-34.623867,23.439795>}
      triangle {<17.831881,-37.362583,94.206840>,<17.831881,-36.056492,67.790595>,<9.346354,-37.240414,59.113341>}
      triangle {<9.770609,-39.352581,103.463767>,<17.831881,-37.362583,94.206840>,<9.346354,-37.240414,59.113341>}
      triangle {<-0.001554,-36.162609,1.375998>,<9.770609,-39.352581,103.463767>,<9.346354,-37.240414,59.113341>}
      triangle {<-0.001554,-36.162609,1.375998>,<9.346354,-37.240414,59.113341>,<9.504740,-36.774807,50.304816>}
      triangle {<13.832728,-34.623867,23.439795>,<-0.001554,-36.162609,1.375998>,<9.504740,-36.774807,50.304816>}
      triangle {<-23.947118,-40.236752,145.894782>,<-25.061391,-39.888515,143.135169>,<-22.167776,-40.476688,143.906943>}
      triangle {<-19.786161,-34.547390,14.827613>,<-21.511533,-33.262005,-4.536782>,<-16.022527,-34.376667,-3.094888>}
      triangle {<-19.786161,-34.547390,14.827613>,<-16.022527,-34.376667,-3.094888>,<-15.303014,-34.733334,1.353171>}
      triangle {<-16.515020,-35.161861,14.679786>,<-19.786161,-34.547390,14.827613>,<-15.303014,-34.733334,1.353171>}
      triangle {<-33.122625,-39.620762,168.711524>,<-39.486791,-37.888752,158.147376>,<-30.009508,-39.185917,147.947761>}
      triangle {<-28.879873,-40.289783,165.931495>,<-33.122625,-39.620762,168.711524>,<-30.009508,-39.185917,147.947761>}
      triangle {<-28.879873,-40.289783,165.931495>,<-30.009508,-39.185917,147.947761>,<-26.926771,-39.835796,149.240684>}
      triangle {<-0.015295,-45.782574,166.055870>,<-28.879873,-40.289783,165.931495>,<-26.926771,-39.835796,149.240684>}
      triangle {<-0.015295,-45.782574,166.055870>,<-26.926771,-39.835796,149.240684>,<-23.947118,-40.236752,145.894782>}
      triangle {<-0.015295,-45.782574,166.055870>,<-23.947118,-40.236752,145.894782>,<-22.167776,-40.476688,143.906943>}
      triangle {<-0.015295,-45.782574,166.055870>,<-22.167776,-40.476688,143.906943>,<-18.503332,-40.970715,139.810706>}
      triangle {<-16.515020,-35.161861,14.679786>,<-15.303014,-34.733334,1.353171>,<-0.015256,-37.640385,1.375983>}
      triangle {<-13.849538,-36.101635,23.440513>,<-16.515020,-35.161861,14.679786>,<-0.015256,-37.640385,1.375983>}
      triangle {<-18.503332,-40.970715,139.810706>,<-20.013273,-40.562878,137.367057>,<-9.787435,-41.983486,126.786750>}
      triangle {<-0.015295,-45.782574,166.055870>,<-18.503332,-40.970715,139.810706>,<-9.787435,-41.983486,126.786750>}
      triangle {<-0.015256,-37.640385,1.375983>,<-0.015295,-45.782574,166.055870>,<-9.787435,-41.983486,126.786750>}
      triangle {<-0.015256,-37.640385,1.375983>,<-9.787435,-41.983486,126.786750>,<-9.787420,-40.830357,103.463744>}
      triangle {<-9.521551,-38.252575,50.304809>,<-16.289426,-35.796749,26.653922>,<-13.849538,-36.101635,23.440513>}
      triangle {<-17.848691,-38.840351,94.206840>,<-17.848691,-37.534260,67.790595>,<-9.363164,-38.718189,59.113326>}
      triangle {<-9.787420,-40.830357,103.463744>,<-17.848691,-38.840351,94.206840>,<-9.363164,-38.718189,59.113326>}
      triangle {<-0.015256,-37.640385,1.375983>,<-9.787420,-40.830357,103.463744>,<-9.363164,-38.718189,59.113326>}
      triangle {<-0.015256,-37.640385,1.375983>,<-9.363164,-38.718189,59.113326>,<-9.521551,-38.252575,50.304809>}
      triangle {<-13.849538,-36.101635,23.440513>,<-0.015256,-37.640385,1.375983>,<-9.521551,-38.252575,50.304809>}
      triangle {<-0.015256,-37.640385,1.375983>,<-15.303014,-34.733334,1.353171>,<-15.303014,-33.255566,1.353171>}
      triangle {<-0.015256,-37.640385,1.375983>,<-15.303014,-33.255566,1.353171>,<-0.015256,-36.162609,1.375998>}
      triangle {<-15.303014,-34.733334,1.353171>,<-16.022527,-34.376667,-3.094888>,<-16.022527,-32.898891,-3.094857>}
      triangle {<-15.303014,-34.733334,1.353171>,<-16.022527,-32.898891,-3.094857>,<-15.303014,-33.255566,1.353171>}
      triangle {<-16.022527,-34.376667,-3.094888>,<-21.511533,-33.262005,-4.536782>,<-21.511541,-31.784237,-4.536782>}
      triangle {<-16.022527,-34.376667,-3.094888>,<-21.511541,-31.784237,-4.536782>,<-16.022527,-32.898891,-3.094857>}
      triangle {<-21.511533,-33.262005,-4.536782>,<-19.786161,-34.547390,14.827613>,<-19.786161,-33.069622,14.827613>}
      triangle {<-21.511533,-33.262005,-4.536782>,<-19.786161,-33.069622,14.827613>,<-21.511541,-31.784237,-4.536782>}
      triangle {<-19.786161,-34.547390,14.827613>,<-16.515020,-35.161861,14.679786>,<-16.515020,-33.684078,14.679816>}
      triangle {<-19.786161,-34.547390,14.827613>,<-16.515020,-33.684078,14.679816>,<-19.786161,-33.069622,14.827613>}
      triangle {<-16.515020,-35.161861,14.679786>,<-13.849538,-36.101635,23.440513>,<-13.849538,-34.623867,23.439795>}
      triangle {<-16.515020,-35.161861,14.679786>,<-13.849538,-34.623867,23.439795>,<-16.515020,-33.684078,14.679816>}
      triangle {<-13.849538,-36.101635,23.440513>,<-16.289426,-35.796749,26.653922>,<-16.289426,-34.318981,26.653235>}
      triangle {<-13.849538,-36.101635,23.440513>,<-16.289426,-34.318981,26.653235>,<-13.849538,-34.623867,23.439795>}
      triangle {<-16.289426,-35.796749,26.653922>,<-9.521551,-38.252575,50.304809>,<-9.521551,-36.774807,50.304809>}
      triangle {<-16.289426,-35.796749,26.653922>,<-9.521551,-36.774807,50.304809>,<-16.289426,-34.318981,26.653235>}
      triangle {<-9.521551,-38.252575,50.304809>,<-9.363164,-38.718189,59.113326>,<-9.363164,-37.240414,59.113334>}
      triangle {<-9.521551,-38.252575,50.304809>,<-9.363164,-37.240414,59.113334>,<-9.521551,-36.774807,50.304809>}
      triangle {<-9.363164,-38.718189,59.113326>,<-17.848691,-37.534260,67.790595>,<-17.848691,-36.056492,67.790595>}
      triangle {<-9.363164,-38.718189,59.113326>,<-17.848691,-36.056492,67.790595>,<-9.363164,-37.240414,59.113334>}
      triangle {<-17.848691,-37.534260,67.790595>,<-17.848691,-38.840351,94.206840>,<-17.848691,-37.362583,94.206840>}
      triangle {<-17.848691,-37.534260,67.790595>,<-17.848691,-37.362583,94.206840>,<-17.848691,-36.056492,67.790595>}
      triangle {<-17.848691,-38.840351,94.206840>,<-9.787420,-40.830357,103.463744>,<-9.787420,-39.352581,103.463767>}
      triangle {<-17.848691,-38.840351,94.206840>,<-9.787420,-39.352581,103.463767>,<-17.848691,-37.362583,94.206840>}
      triangle {<-9.787420,-40.830357,103.463744>,<-9.787435,-41.983486,126.786750>,<-9.787435,-40.505711,126.786750>}
      triangle {<-9.787420,-40.830357,103.463744>,<-9.787435,-40.505711,126.786750>,<-9.787420,-39.352581,103.463767>}
      triangle {<-9.787435,-41.983486,126.786750>,<-20.013273,-40.562878,137.367057>,<-20.013273,-39.085102,137.367057>}
      triangle {<-9.787435,-41.983486,126.786750>,<-20.013273,-39.085102,137.367057>,<-9.787435,-40.505711,126.786750>}
      triangle {<-20.013273,-40.562878,137.367057>,<-18.503332,-40.970715,139.810706>,<-18.503339,-39.492939,139.810706>}
      triangle {<-20.013273,-40.562878,137.367057>,<-18.503339,-39.492939,139.810706>,<-20.013273,-39.085102,137.367057>}
      triangle {<-18.503332,-40.970715,139.810706>,<-22.167776,-40.476688,143.906943>,<-22.118558,-39.008282,143.906943>}
      triangle {<-18.503332,-40.970715,139.810706>,<-22.118558,-39.008282,143.906943>,<-18.503339,-39.492939,139.810706>}
      triangle {<-22.167776,-40.476688,143.906943>,<-25.061391,-39.888515,143.135169>,<-25.061391,-38.410740,143.135169>}
      triangle {<-22.167776,-40.476688,143.906943>,<-25.061391,-38.410740,143.135169>,<-22.118558,-39.008282,143.906943>}
      triangle {<-25.061391,-39.888515,143.135169>,<-23.947118,-40.236752,145.894782>,<-23.947118,-38.758976,145.894797>}
      triangle {<-25.061391,-39.888515,143.135169>,<-23.947118,-38.758976,145.894797>,<-25.061391,-38.410740,143.135169>}
      triangle {<-23.947118,-40.236752,145.894782>,<-26.926771,-39.835796,149.240684>,<-26.877550,-38.369808,149.289908>}
      triangle {<-23.947118,-40.236752,145.894782>,<-26.877550,-38.369808,149.289908>,<-23.947118,-38.758976,145.894797>}
      triangle {<-26.926771,-39.835796,149.240684>,<-30.009508,-39.185917,147.947761>,<-30.009508,-37.708141,147.947761>}
      triangle {<-26.926771,-39.835796,149.240684>,<-30.009508,-37.708141,147.947761>,<-26.877550,-38.369808,149.289908>}
      triangle {<-30.009508,-39.185917,147.947761>,<-39.486791,-37.888752,158.147376>,<-39.486791,-36.410992,158.147376>}
      triangle {<-30.009508,-39.185917,147.947761>,<-39.486791,-36.410992,158.147376>,<-30.009508,-37.708141,147.947761>}
      triangle {<-39.486791,-37.888752,158.147376>,<-33.122625,-39.620762,168.711524>,<-33.122625,-38.142994,168.711524>}
      triangle {<-39.486791,-37.888752,158.147376>,<-33.122625,-38.142994,168.711524>,<-39.486791,-36.410992,158.147376>}
      triangle {<-33.122625,-39.620762,168.711524>,<-28.879873,-40.289783,165.931495>,<-28.879873,-38.812023,165.931479>}
      triangle {<-33.122625,-39.620762,168.711524>,<-28.879873,-38.812023,165.931479>,<-33.122625,-38.142994,168.711524>}
      triangle {<-28.879873,-40.289783,165.931495>,<-0.015295,-45.782574,166.055870>,<-0.015295,-44.304798,166.055870>}
      triangle {<-28.879873,-40.289783,165.931495>,<-0.015295,-44.304798,166.055870>,<-28.879873,-38.812023,165.931479>}
      triangle {<-0.015295,-45.782574,166.055870>,<-0.015256,-37.640385,1.375983>,<-0.015256,-36.162609,1.375998>}
      triangle {<-0.015295,-45.782574,166.055870>,<-0.015256,-36.162609,1.375998>,<-0.015295,-44.304798,166.055870>}
      triangle {<-22.118558,-39.008282,143.906943>,<-25.061391,-38.410740,143.135169>,<-23.947118,-38.758976,145.894797>}
      triangle {<-16.022527,-32.898891,-3.094857>,<-21.511541,-31.784237,-4.536782>,<-19.786161,-33.069622,14.827613>}
      triangle {<-15.303014,-33.255566,1.353171>,<-16.022527,-32.898891,-3.094857>,<-19.786161,-33.069622,14.827613>}
      triangle {<-15.303014,-33.255566,1.353171>,<-19.786161,-33.069622,14.827613>,<-16.515020,-33.684078,14.679816>}
      triangle {<-30.009508,-37.708141,147.947761>,<-39.486791,-36.410992,158.147376>,<-33.122625,-38.142994,168.711524>}
      triangle {<-30.009508,-37.708141,147.947761>,<-33.122625,-38.142994,168.711524>,<-28.879873,-38.812023,165.931479>}
      triangle {<-26.877550,-38.369808,149.289908>,<-30.009508,-37.708141,147.947761>,<-28.879873,-38.812023,165.931479>}
      triangle {<-26.877550,-38.369808,149.289908>,<-28.879873,-38.812023,165.931479>,<-0.015295,-44.304798,166.055870>}
      triangle {<-23.947118,-38.758976,145.894797>,<-26.877550,-38.369808,149.289908>,<-0.015295,-44.304798,166.055870>}
      triangle {<-22.118558,-39.008282,143.906943>,<-23.947118,-38.758976,145.894797>,<-0.015295,-44.304798,166.055870>}
      triangle {<-18.503339,-39.492939,139.810706>,<-22.118558,-39.008282,143.906943>,<-0.015295,-44.304798,166.055870>}
      triangle {<-0.015256,-36.162609,1.375998>,<-15.303014,-33.255566,1.353171>,<-16.515020,-33.684078,14.679816>}
      triangle {<-0.015256,-36.162609,1.375998>,<-16.515020,-33.684078,14.679816>,<-13.849538,-34.623867,23.439795>}
      triangle {<-9.787435,-40.505711,126.786750>,<-20.013273,-39.085102,137.367057>,<-18.503339,-39.492939,139.810706>}
      triangle {<-9.787435,-40.505711,126.786750>,<-18.503339,-39.492939,139.810706>,<-0.015295,-44.304798,166.055870>}
      triangle {<-9.787435,-40.505711,126.786750>,<-0.015295,-44.304798,166.055870>,<-0.015256,-36.162609,1.375998>}
      triangle {<-9.787420,-39.352581,103.463767>,<-9.787435,-40.505711,126.786750>,<-0.015256,-36.162609,1.375998>}
      triangle {<-13.849538,-34.623867,23.439795>,<-16.289426,-34.318981,26.653235>,<-9.521551,-36.774807,50.304809>}
      triangle {<-9.363164,-37.240414,59.113334>,<-17.848691,-36.056492,67.790595>,<-17.848691,-37.362583,94.206840>}
      triangle {<-9.363164,-37.240414,59.113334>,<-17.848691,-37.362583,94.206840>,<-9.787420,-39.352581,103.463767>}
      triangle {<-9.363164,-37.240414,59.113334>,<-9.787420,-39.352581,103.463767>,<-0.015256,-36.162609,1.375998>}
      triangle {<-9.521551,-36.774807,50.304809>,<-9.363164,-37.240414,59.113334>,<-0.015256,-36.162609,1.375998>}
      triangle {<-9.521551,-36.774807,50.304809>,<-0.015256,-36.162609,1.375998>,<-13.849538,-34.623867,23.439795>}
      triangle {<-0.173620,-44.934040,80.769401>,<-5.461355,-44.628231,82.959655>,<-5.897024,-44.528294,80.769401>}
      triangle {<-0.173620,-44.934040,80.769401>,<-4.220670,-44.712948,84.816459>,<-5.461355,-44.628231,82.959655>}
      triangle {<-0.173620,-44.934040,80.769401>,<-2.363874,-44.769550,86.057136>,<-4.220670,-44.712948,84.816459>}
      triangle {<-0.173620,-44.934040,80.769401>,<-0.173620,-44.789433,86.492797>,<-2.363874,-44.769550,86.057136>}
      triangle {<-0.173620,-44.934040,80.769401>,<2.016634,-44.769550,86.057136>,<-0.173620,-44.789433,86.492797>}
      triangle {<-0.173620,-44.934040,80.769401>,<3.873438,-44.712948,84.816451>,<2.016634,-44.769550,86.057136>}
      triangle {<-0.173620,-44.934040,80.769401>,<5.114108,-44.628223,82.959647>,<3.873438,-44.712948,84.816451>}
      triangle {<-0.173620,-44.934040,80.769401>,<5.549784,-44.528294,80.769401>,<5.114108,-44.628223,82.959647>}
      triangle {<-0.173620,-44.934040,80.769401>,<5.114108,-44.428364,78.579146>,<5.549784,-44.528294,80.769401>}
      triangle {<-0.173620,-44.934040,80.769401>,<3.873431,-44.343647,76.722342>,<5.114108,-44.428364,78.579146>}
      triangle {<-0.173620,-44.934040,80.769401>,<2.016627,-44.287045,75.481666>,<3.873431,-44.343647,76.722342>}
      triangle {<-0.173620,-44.934040,80.769401>,<-0.173635,-44.267170,75.046004>,<2.016627,-44.287045,75.481666>}
      triangle {<-0.173620,-44.934040,80.769401>,<-2.363874,-44.287045,75.481673>,<-0.173635,-44.267170,75.046004>}
      triangle {<-0.173620,-44.934040,80.769401>,<-4.220678,-44.343647,76.722358>,<-2.363874,-44.287045,75.481673>}
      triangle {<-0.173620,-44.934040,80.769401>,<-5.461355,-44.428364,78.579162>,<-4.220678,-44.343647,76.722358>}
      triangle {<-0.173620,-44.934040,80.769401>,<-5.897024,-44.528294,80.769401>,<-5.461355,-44.428364,78.579162>}
      triangle {<-5.897024,-44.528294,80.769401>,<-9.944074,-43.557484,84.816459>,<-10.749082,-43.372837,80.769401>}
      triangle {<-5.897024,-44.528294,80.769401>,<-5.461355,-44.628231,82.959655>,<-9.944074,-43.557484,84.816459>}
      triangle {<-5.461355,-44.628231,82.959655>,<-7.651609,-43.714024,88.247382>,<-9.944074,-43.557484,84.816459>}
      triangle {<-5.461355,-44.628231,82.959655>,<-4.220670,-44.712948,84.816459>,<-7.651609,-43.714024,88.247382>}
      triangle {<-4.220670,-44.712948,84.816459>,<-4.220678,-43.818615,90.539855>,<-7.651609,-43.714024,88.247382>}
      triangle {<-4.220670,-44.712948,84.816459>,<-2.363874,-44.769550,86.057136>,<-4.220678,-43.818615,90.539855>}
      triangle {<-2.363874,-44.769550,86.057136>,<-0.173620,-43.855343,91.344863>,<-4.220678,-43.818615,90.539855>}
      triangle {<-2.363874,-44.769550,86.057136>,<-0.173620,-44.789433,86.492797>,<-0.173620,-43.855343,91.344863>}
      triangle {<-0.173620,-44.789433,86.492797>,<3.873438,-43.818615,90.539855>,<-0.173620,-43.855343,91.344863>}
      triangle {<-0.173620,-44.789433,86.492797>,<2.016634,-44.769550,86.057136>,<3.873438,-43.818615,90.539855>}
      triangle {<2.016634,-44.769550,86.057136>,<7.304369,-43.714024,88.247382>,<3.873438,-43.818615,90.539855>}
      triangle {<2.016634,-44.769550,86.057136>,<3.873438,-44.712948,84.816451>,<7.304369,-43.714024,88.247382>}
      triangle {<3.873438,-44.712948,84.816451>,<9.596835,-43.557484,84.816451>,<7.304369,-43.714024,88.247382>}
      triangle {<3.873438,-44.712948,84.816451>,<5.114108,-44.628223,82.959647>,<9.596835,-43.557484,84.816451>}
      triangle {<5.114108,-44.628223,82.959647>,<10.401843,-43.372837,80.769393>,<9.596835,-43.557484,84.816451>}
      triangle {<5.114108,-44.628223,82.959647>,<5.549784,-44.528294,80.769401>,<10.401843,-43.372837,80.769393>}
      triangle {<5.549784,-44.528294,80.769401>,<9.596835,-43.188183,76.722335>,<10.401843,-43.372837,80.769393>}
      triangle {<5.549784,-44.528294,80.769401>,<5.114108,-44.428364,78.579146>,<9.596835,-43.188183,76.722335>}
      triangle {<5.114108,-44.428364,78.579146>,<7.304354,-43.031643,73.291411>,<9.596835,-43.188183,76.722335>}
      triangle {<5.114108,-44.428364,78.579146>,<3.873431,-44.343647,76.722342>,<7.304354,-43.031643,73.291411>}
      triangle {<3.873431,-44.343647,76.722342>,<3.873415,-42.927052,70.998939>,<7.304354,-43.031643,73.291411>}
      triangle {<3.873431,-44.343647,76.722342>,<2.016627,-44.287045,75.481666>,<3.873415,-42.927052,70.998939>}
      triangle {<2.016627,-44.287045,75.481666>,<-0.173635,-42.890324,70.193938>,<3.873415,-42.927052,70.998939>}
      triangle {<2.016627,-44.287045,75.481666>,<-0.173635,-44.267170,75.046004>,<-0.173635,-42.890324,70.193938>}
      triangle {<-0.173635,-44.267170,75.046004>,<-4.220693,-42.927052,70.998954>,<-0.173635,-42.890324,70.193938>}
      triangle {<-0.173635,-44.267170,75.046004>,<-2.363874,-44.287045,75.481673>,<-4.220693,-42.927052,70.998954>}
      triangle {<-2.363874,-44.287045,75.481673>,<-7.651617,-43.031643,73.291427>,<-4.220693,-42.927052,70.998954>}
      triangle {<-2.363874,-44.287045,75.481673>,<-4.220678,-44.343647,76.722358>,<-7.651617,-43.031643,73.291427>}
      triangle {<-4.220678,-44.343647,76.722358>,<-9.944082,-43.188183,76.722365>,<-7.651617,-43.031643,73.291427>}
      triangle {<-4.220678,-44.343647,76.722358>,<-5.461355,-44.428364,78.579162>,<-9.944082,-43.188183,76.722365>}
      triangle {<-5.461355,-44.428364,78.579162>,<-10.749082,-43.372837,80.769401>,<-9.944082,-43.188183,76.722365>}
      triangle {<-5.461355,-44.428364,78.579162>,<-5.897024,-44.528294,80.769401>,<-10.749082,-43.372837,80.769401>}
      triangle {<-10.749082,-43.372837,80.769401>,<-12.939336,-41.884815,86.057136>,<-13.991132,-41.643559,80.769401>}
      triangle {<-10.749082,-43.372837,80.769401>,<-9.944074,-43.557484,84.816459>,<-12.939336,-41.884815,86.057136>}
      triangle {<-9.944074,-43.557484,84.816459>,<-9.944074,-42.089344,90.539855>,<-12.939336,-41.884815,86.057136>}
      triangle {<-9.944074,-43.557484,84.816459>,<-7.651609,-43.714024,88.247382>,<-9.944074,-42.089344,90.539855>}
      triangle {<-7.651609,-43.714024,88.247382>,<-5.461355,-42.226002,93.535117>,<-9.944074,-42.089344,90.539855>}
      triangle {<-7.651609,-43.714024,88.247382>,<-4.220678,-43.818615,90.539855>,<-5.461355,-42.226002,93.535117>}
      triangle {<-4.220678,-43.818615,90.539855>,<-0.173620,-42.273991,94.586913>,<-5.461355,-42.226002,93.535117>}
      triangle {<-4.220678,-43.818615,90.539855>,<-0.173620,-43.855343,91.344863>,<-0.173620,-42.273991,94.586913>}
      triangle {<-0.173620,-43.855343,91.344863>,<5.114108,-42.226002,93.535117>,<-0.173620,-42.273991,94.586913>}
      triangle {<-0.173620,-43.855343,91.344863>,<3.873438,-43.818615,90.539855>,<5.114108,-42.226002,93.535117>}
      triangle {<3.873438,-43.818615,90.539855>,<9.596835,-42.089344,90.539855>,<5.114108,-42.226002,93.535117>}
      triangle {<3.873438,-43.818615,90.539855>,<7.304369,-43.714024,88.247382>,<9.596835,-42.089344,90.539855>}
      triangle {<7.304369,-43.714024,88.247382>,<12.592097,-41.884815,86.057128>,<9.596835,-42.089344,90.539855>}
      triangle {<7.304369,-43.714024,88.247382>,<9.596835,-43.557484,84.816451>,<12.592097,-41.884815,86.057128>}
      triangle {<9.596835,-43.557484,84.816451>,<13.643893,-41.643559,80.769393>,<12.592097,-41.884815,86.057128>}
      triangle {<9.596835,-43.557484,84.816451>,<10.401843,-43.372837,80.769393>,<13.643893,-41.643559,80.769393>}
      triangle {<10.401843,-43.372837,80.769393>,<12.592089,-41.402309,75.481658>,<13.643893,-41.643559,80.769393>}
      triangle {<10.401843,-43.372837,80.769393>,<9.596835,-43.188183,76.722335>,<12.592089,-41.402309,75.481658>}
      triangle {<9.596835,-43.188183,76.722335>,<9.596819,-41.197781,70.998939>,<12.592089,-41.402309,75.481658>}
      triangle {<9.596835,-43.188183,76.722335>,<7.304354,-43.031643,73.291411>,<9.596819,-41.197781,70.998939>}
      triangle {<7.304354,-43.031643,73.291411>,<5.114100,-41.061115,68.003684>,<9.596819,-41.197781,70.998939>}
      triangle {<7.304354,-43.031643,73.291411>,<3.873415,-42.927052,70.998939>,<5.114100,-41.061115,68.003684>}
      triangle {<3.873415,-42.927052,70.998939>,<-0.173643,-41.013126,66.951896>,<5.114100,-41.061115,68.003684>}
      triangle {<3.873415,-42.927052,70.998939>,<-0.173635,-42.890324,70.193938>,<-0.173643,-41.013126,66.951896>}
      triangle {<-0.173635,-42.890324,70.193938>,<-5.461378,-41.061115,68.003692>,<-0.173643,-41.013126,66.951896>}
      triangle {<-0.173635,-42.890324,70.193938>,<-4.220693,-42.927052,70.998954>,<-5.461378,-41.061115,68.003692>}
      triangle {<-4.220693,-42.927052,70.998954>,<-9.944097,-41.197781,70.998961>,<-5.461378,-41.061115,68.003692>}
      triangle {<-4.220693,-42.927052,70.998954>,<-7.651617,-43.031643,73.291427>,<-9.944097,-41.197781,70.998961>}
      triangle {<-7.651617,-43.031643,73.291427>,<-12.939336,-41.402309,75.481696>,<-9.944097,-41.197781,70.998961>}
      triangle {<-7.651617,-43.031643,73.291427>,<-9.944082,-43.188183,76.722365>,<-12.939336,-41.402309,75.481696>}
      triangle {<-9.944082,-43.188183,76.722365>,<-13.991132,-41.643559,80.769401>,<-12.939336,-41.402309,75.481696>}
      triangle {<-9.944082,-43.188183,76.722365>,<-10.749082,-43.372837,80.769401>,<-13.991132,-41.643559,80.769401>}
      triangle {<-13.991132,-41.643559,80.769401>,<-13.991132,-39.864864,86.492797>,<-15.129583,-39.603733,80.769401>}
      triangle {<-13.991132,-41.643559,80.769401>,<-12.939336,-41.884815,86.057136>,<-13.991132,-39.864864,86.492797>}
      triangle {<-12.939336,-41.884815,86.057136>,<-10.749082,-40.086246,91.344863>,<-13.991132,-39.864864,86.492797>}
      triangle {<-12.939336,-41.884815,86.057136>,<-9.944074,-42.089344,90.539855>,<-10.749082,-40.086246,91.344863>}
      triangle {<-9.944074,-42.089344,90.539855>,<-5.897024,-40.234165,94.586913>,<-10.749082,-40.086246,91.344863>}
      triangle {<-9.944074,-42.089344,90.539855>,<-5.461355,-42.226002,93.535117>,<-5.897024,-40.234165,94.586913>}
      triangle {<-5.461355,-42.226002,93.535117>,<-0.173620,-40.286106,95.725364>,<-5.897024,-40.234165,94.586913>}
      triangle {<-5.461355,-42.226002,93.535117>,<-0.173620,-42.273991,94.586913>,<-0.173620,-40.286106,95.725364>}
      triangle {<-0.173620,-42.273991,94.586913>,<5.549784,-40.234165,94.586905>,<-0.173620,-40.286106,95.725364>}
      triangle {<-0.173620,-42.273991,94.586913>,<5.114108,-42.226002,93.535117>,<5.549784,-40.234165,94.586905>}
      triangle {<5.114108,-42.226002,93.535117>,<10.401843,-40.086246,91.344863>,<5.549784,-40.234165,94.586905>}
      triangle {<5.114108,-42.226002,93.535117>,<9.596835,-42.089344,90.539855>,<10.401843,-40.086246,91.344863>}
      triangle {<9.596835,-42.089344,90.539855>,<13.643893,-39.864864,86.492797>,<10.401843,-40.086246,91.344863>}
      triangle {<9.596835,-42.089344,90.539855>,<12.592097,-41.884815,86.057128>,<13.643893,-39.864864,86.492797>}
      triangle {<12.592097,-41.884815,86.057128>,<14.782343,-39.603733,80.769393>,<13.643893,-39.864864,86.492797>}
      triangle {<12.592097,-41.884815,86.057128>,<13.643893,-41.643559,80.769393>,<14.782343,-39.603733,80.769393>}
      triangle {<13.643893,-41.643559,80.769393>,<13.643878,-39.342594,75.045989>,<14.782343,-39.603733,80.769393>}
      triangle {<13.643893,-41.643559,80.769393>,<12.592089,-41.402309,75.481658>,<13.643878,-39.342594,75.045989>}
      triangle {<12.592089,-41.402309,75.481658>,<10.401827,-39.121227,70.193931>,<13.643878,-39.342594,75.045989>}
      triangle {<12.592089,-41.402309,75.481658>,<9.596819,-41.197781,70.998939>,<10.401827,-39.121227,70.193931>}
      triangle {<9.596819,-41.197781,70.998939>,<5.549761,-38.973309,66.951888>,<10.401827,-39.121227,70.193931>}
      triangle {<9.596819,-41.197781,70.998939>,<5.114100,-41.061115,68.003684>,<5.549761,-38.973309,66.951888>}
      triangle {<5.114100,-41.061115,68.003684>,<-0.173643,-38.921368,65.813437>,<5.549761,-38.973309,66.951888>}
      triangle {<5.114100,-41.061115,68.003684>,<-0.173643,-41.013126,66.951896>,<-0.173643,-38.921368,65.813437>}
      triangle {<-0.173643,-41.013126,66.951896>,<-5.897047,-38.973309,66.951896>,<-0.173643,-38.921368,65.813437>}
      triangle {<-0.173643,-41.013126,66.951896>,<-5.461378,-41.061115,68.003692>,<-5.897047,-38.973309,66.951896>}
      triangle {<-5.461378,-41.061115,68.003692>,<-10.749105,-39.121227,70.193954>,<-5.897047,-38.973309,66.951896>}
      triangle {<-5.461378,-41.061115,68.003692>,<-9.944097,-41.197781,70.998961>,<-10.749105,-39.121227,70.193954>}
      triangle {<-9.944097,-41.197781,70.998961>,<-13.991148,-39.342609,75.046027>,<-10.749105,-39.121227,70.193954>}
      triangle {<-9.944097,-41.197781,70.998961>,<-12.939336,-41.402309,75.481696>,<-13.991148,-39.342609,75.046027>}
      triangle {<-12.939336,-41.402309,75.481696>,<-15.129583,-39.603733,80.769401>,<-13.991148,-39.342609,75.046027>}
      triangle {<-12.939336,-41.402309,75.481696>,<-13.991132,-41.643559,80.769401>,<-15.129583,-39.603733,80.769401>}
      triangle {<-15.129583,-39.603733,80.769401>,<-13.991132,-39.864864,86.492797>,<-10.749082,-40.086246,91.344863>}
      triangle {<-15.129583,-39.603733,80.769401>,<-10.749082,-40.086246,91.344863>,<-5.897024,-40.234165,94.586913>}
      triangle {<-15.129583,-39.603733,80.769401>,<-5.897024,-40.234165,94.586913>,<-0.173620,-40.286106,95.725364>}
      triangle {<-15.129583,-39.603733,80.769401>,<-0.173620,-40.286106,95.725364>,<5.549784,-40.234165,94.586905>}
      triangle {<-15.129583,-39.603733,80.769401>,<5.549784,-40.234165,94.586905>,<10.401843,-40.086246,91.344863>}
      triangle {<-15.129583,-39.603733,80.769401>,<10.401843,-40.086246,91.344863>,<13.643893,-39.864864,86.492797>}
      triangle {<-15.129583,-39.603733,80.769401>,<13.643893,-39.864864,86.492797>,<14.782343,-39.603733,80.769393>}
      triangle {<-15.129583,-39.603733,80.769401>,<14.782343,-39.603733,80.769393>,<13.643878,-39.342594,75.045989>}
      triangle {<-15.129583,-39.603733,80.769401>,<13.643878,-39.342594,75.045989>,<10.401827,-39.121227,70.193931>}
      triangle {<-15.129583,-39.603733,80.769401>,<10.401827,-39.121227,70.193931>,<5.549761,-38.973309,66.951888>}
      triangle {<-15.129583,-39.603733,80.769401>,<5.549761,-38.973309,66.951888>,<-0.173643,-38.921368,65.813437>}
      triangle {<-15.129583,-39.603733,80.769401>,<-0.173643,-38.921368,65.813437>,<-5.897047,-38.973309,66.951896>}
      triangle {<-15.129583,-39.603733,80.769401>,<-5.897047,-38.973309,66.951896>,<-10.749105,-39.121227,70.193954>}
      triangle {<-15.129583,-39.603733,80.769401>,<-10.749105,-39.121227,70.193954>,<-13.991148,-39.342609,75.046027>}
      triangle {<-14.888845,-34.714642,-12.587701>,<-0.002790,-36.999485,-12.593438>,<-16.239484,-34.543530,-10.153558>}
      triangle {<9.035082,-35.791805,-7.834802>,<-0.155668,-37.268673,-7.834802>,<14.750666,-34.494831,-12.600442>}
      triangle {<15.928141,-34.408283,-10.153543>,<9.035082,-35.791805,-7.834802>,<14.750666,-34.494831,-12.600442>}
      triangle {<18.225832,-33.346920,-21.747293>,<15.928141,-34.408283,-10.153543>,<14.750666,-34.494831,-12.600442>}
      triangle {<18.225832,-33.346920,-21.747293>,<14.750666,-34.494831,-12.600442>,<14.750163,-32.479443,-48.229135>}
      triangle {<18.225825,-31.761341,-49.572289>,<18.225832,-33.346920,-21.747293>,<14.750163,-32.479443,-48.229135>}
      triangle {<-14.888845,-34.714642,-12.587701>,<-16.239484,-34.543530,-10.153558>,<-18.537168,-33.455387,-21.747308>}
      triangle {<-14.923444,-32.636929,-48.226357>,<-14.888845,-34.714642,-12.587701>,<-18.537168,-33.455387,-21.747308>}
      triangle {<-14.923444,-32.636929,-48.226357>,<-18.537168,-33.455387,-21.747308>,<-18.537168,-31.819660,-49.572305>}
      triangle {<-14.923444,-32.636929,-48.226357>,<-18.537168,-31.819660,-49.572305>,<-4.751043,-33.904255,-54.209802>}
      triangle {<-0.008932,-34.983379,-48.234872>,<-14.923444,-32.636929,-48.226357>,<-4.751043,-33.904255,-54.209802>}
      triangle {<4.439707,-33.939060,-54.209802>,<18.225825,-31.761341,-49.572289>,<14.750163,-32.479443,-48.229135>}
      triangle {<4.439707,-33.939060,-54.209802>,<14.750163,-32.479443,-48.229135>,<-0.008932,-34.983379,-48.234872>}
      triangle {<-0.155668,-34.645390,-54.209802>,<4.439707,-33.939060,-54.209802>,<-0.008932,-34.983379,-48.234872>}
      triangle {<-0.155668,-34.645390,-54.209802>,<-0.008932,-34.983379,-48.234872>,<-4.751043,-33.904255,-54.209802>}
      triangle {<-16.239484,-34.543530,-10.153558>,<-9.346410,-35.848164,-7.834817>,<-10.317022,-33.050533,-5.386041>}
      triangle {<-16.239484,-34.543530,-10.153558>,<-10.317022,-33.050533,-5.386041>,<-17.938039,-31.608540,-7.949670>}
      triangle {<-9.346410,-35.848164,-7.834817>,<-0.155668,-37.268673,-7.834802>,<-0.155668,-34.656330,-5.386041>}
      triangle {<-9.346410,-35.848164,-7.834817>,<-0.155668,-34.656330,-5.386041>,<-10.317022,-33.050533,-5.386041>}
      triangle {<-0.155668,-37.268673,-7.834802>,<9.035082,-35.791805,-7.834802>,<10.005694,-32.965328,-5.386041>}
      triangle {<-0.155668,-37.268673,-7.834802>,<10.005694,-32.965328,-5.386041>,<-0.155668,-34.656330,-5.386041>}
      triangle {<9.035082,-35.791805,-7.834802>,<15.928141,-34.408283,-10.153543>,<17.626711,-31.708630,-7.949655>}
      triangle {<9.035082,-35.791805,-7.834802>,<17.626711,-31.708630,-7.949655>,<10.005694,-32.965328,-5.386041>}
      triangle {<15.928141,-34.408283,-10.153543>,<18.225832,-33.346920,-21.747293>,<20.167056,-30.447216,-20.767800>}
      triangle {<15.928141,-34.408283,-10.153543>,<20.167056,-30.447216,-20.767800>,<17.626711,-31.708630,-7.949655>}
      triangle {<18.225832,-33.346920,-21.747293>,<18.225825,-31.761341,-49.572289>,<20.167048,-28.707027,-51.531320>}
      triangle {<18.225832,-33.346920,-21.747293>,<20.167048,-28.707027,-51.531320>,<20.167056,-30.447216,-20.767800>}
      triangle {<18.225825,-31.761341,-49.572289>,<4.439707,-33.939060,-54.209802>,<4.925005,-30.915485,-56.658563>}
      triangle {<18.225825,-31.761341,-49.572289>,<4.925005,-30.915485,-56.658563>,<20.167048,-28.707027,-51.531320>}
      triangle {<4.439707,-33.939060,-54.209802>,<-0.155668,-34.645390,-54.209802>,<-0.155668,-31.756016,-56.658563>}
      triangle {<4.439707,-33.939060,-54.209802>,<-0.155668,-31.756016,-56.658563>,<4.925005,-30.915485,-56.658563>}
      triangle {<-0.155668,-34.645390,-54.209802>,<-4.751043,-33.904255,-54.209802>,<-5.236349,-31.014881,-56.658563>}
      triangle {<-0.155668,-34.645390,-54.209802>,<-5.236349,-31.014881,-56.658563>,<-0.155668,-31.756016,-56.658563>}
      triangle {<-4.751043,-33.904255,-54.209802>,<-18.537168,-31.819660,-49.572305>,<-20.478391,-28.710934,-51.531320>}
      triangle {<-4.751043,-33.904255,-54.209802>,<-20.478391,-28.710934,-51.531320>,<-5.236349,-31.014881,-56.658563>}
      triangle {<-18.537168,-31.819660,-49.572305>,<-18.537168,-33.455387,-21.747308>,<-20.478384,-30.451122,-20.767800>}
      triangle {<-18.537168,-31.819660,-49.572305>,<-20.478384,-30.451122,-20.767800>,<-20.478391,-28.710934,-51.531320>}
      triangle {<-18.537168,-33.455387,-21.747308>,<-16.239484,-34.543530,-10.153558>,<-17.938039,-31.608540,-7.949670>}
      triangle {<-18.537168,-33.455387,-21.747308>,<-17.938039,-31.608540,-7.949670>,<-20.478384,-30.451122,-20.767800>}
      triangle {<-0.008932,-34.983379,-48.234872>,<14.750163,-32.479443,-48.229135>,<14.753787,-29.808468,-48.224923>}
      triangle {<-0.008932,-34.983379,-48.234872>,<14.753787,-29.808468,-48.224923>,<-0.008932,-32.231525,-48.252328>}
      triangle {<14.750163,-32.479443,-48.229135>,<14.750666,-34.494831,-12.600442>,<14.737872,-31.824123,-12.591500>}
      triangle {<14.750163,-32.479443,-48.229135>,<14.737872,-31.824123,-12.591500>,<14.753787,-29.808468,-48.224923>}
      triangle {<14.750666,-34.494831,-12.600442>,<-0.002790,-36.999485,-12.593438>,<-0.008153,-34.248539,-12.594949>}
      triangle {<14.750666,-34.494831,-12.600442>,<-0.008153,-34.248539,-12.594949>,<14.737872,-31.824123,-12.591500>}
      triangle {<-0.002790,-36.999485,-12.593438>,<-14.888845,-34.714642,-12.587701>,<-14.914518,-31.902782,-12.574410>}
      triangle {<-0.002790,-36.999485,-12.593438>,<-14.914518,-31.902782,-12.574410>,<-0.008153,-34.248539,-12.594949>}
      triangle {<-14.888845,-34.714642,-12.587701>,<-14.923444,-32.636929,-48.226357>,<-14.937841,-29.886158,-48.224816>}
      triangle {<-14.888845,-34.714642,-12.587701>,<-14.937841,-29.886158,-48.224816>,<-14.914518,-31.902782,-12.574410>}
      triangle {<-14.923444,-32.636929,-48.226357>,<-0.008932,-34.983379,-48.234872>,<-0.008932,-32.231525,-48.252328>}
      triangle {<-14.923444,-32.636929,-48.226357>,<-0.008932,-32.231525,-48.252328>,<-14.937841,-29.886158,-48.224816>}
      triangle {<-17.938039,-31.608540,-7.949670>,<14.737872,-31.824123,-12.591500>,<-0.008153,-34.248539,-12.594949>}
      triangle {<-17.938039,-31.608540,-7.949670>,<-0.008153,-34.248539,-12.594949>,<-14.914518,-31.902782,-12.574410>}
      triangle {<14.737872,-31.824123,-12.591500>,<-17.938039,-31.608540,-7.949670>,<-10.317022,-33.050533,-5.386041>}
      triangle {<14.737872,-31.824123,-12.591500>,<-10.317022,-33.050533,-5.386041>,<-0.155668,-34.656330,-5.386041>}
      triangle {<14.737872,-31.824123,-12.591500>,<-0.155668,-34.656330,-5.386041>,<10.005694,-32.965328,-5.386041>}
      triangle {<14.737872,-31.824123,-12.591500>,<10.005694,-32.965328,-5.386041>,<17.626711,-31.708630,-7.949655>}
      triangle {<14.737872,-31.824123,-12.591500>,<17.626711,-31.708630,-7.949655>,<20.167056,-30.447216,-20.767800>}
      triangle {<14.753787,-29.808468,-48.224923>,<14.737872,-31.824123,-12.591500>,<20.167056,-30.447216,-20.767800>}
      triangle {<14.753787,-29.808468,-48.224923>,<20.167056,-30.447216,-20.767800>,<20.167048,-28.707027,-51.531320>}
      triangle {<-20.478384,-30.451122,-20.767800>,<-17.938039,-31.608540,-7.949670>,<-14.914518,-31.902782,-12.574410>}
      triangle {<-20.478384,-30.451122,-20.767800>,<-14.914518,-31.902782,-12.574410>,<-14.937841,-29.886158,-48.224816>}
      triangle {<-20.478391,-28.710934,-51.531320>,<-20.478384,-30.451122,-20.767800>,<-14.937841,-29.886158,-48.224816>}
      triangle {<-5.236349,-31.014881,-56.658563>,<-20.478391,-28.710934,-51.531320>,<-14.937841,-29.886158,-48.224816>}
      triangle {<-5.236349,-31.014881,-56.658563>,<-14.937841,-29.886158,-48.224816>,<-0.008932,-32.231525,-48.252328>}
      triangle {<14.753787,-29.808468,-48.224923>,<20.167048,-28.707027,-51.531320>,<4.925005,-30.915485,-56.658563>}
      triangle {<-0.008932,-32.231525,-48.252328>,<14.753787,-29.808468,-48.224923>,<4.925005,-30.915485,-56.658563>}
      triangle {<-0.008932,-32.231525,-48.252328>,<4.925005,-30.915485,-56.658563>,<-0.155668,-31.756016,-56.658563>}
      triangle {<-5.236349,-31.014881,-56.658563>,<-0.008932,-32.231525,-48.252328>,<-0.155668,-31.756016,-56.658563>}
      triangle {<-0.155668,-37.268673,-7.834802>,<-0.002790,-36.999485,-12.593438>,<14.750666,-34.494831,-12.600442>}
      triangle {<-9.346410,-35.848164,-7.834817>,<-16.239484,-34.543530,-10.153558>,<-0.002790,-36.999485,-12.593438>}
      triangle {<-9.346410,-35.848164,-7.834817>,<-0.002790,-36.999485,-12.593438>,<-0.155668,-37.268673,-7.834802>}
      triangle {<-14.910375,-32.086452,-48.399270>,<-14.910375,-22.417583,-48.399270>,<-14.910375,-34.171299,-12.695382>}
      triangle {<-14.910375,-22.417583,-48.399270>,<-14.910375,-22.417583,-12.695382>,<-14.910375,-34.171299,-12.695382>}
      triangle {<14.635523,-32.097469,-48.399270>,<14.635523,-22.417583,-48.399270>,<-14.910375,-32.086452,-48.399270>}
      triangle {<14.635523,-22.417583,-48.399270>,<-14.910375,-22.417583,-48.399270>,<-14.910375,-32.086452,-48.399270>}
      triangle {<14.635523,-22.417583,-48.399270>,<14.635523,-22.417583,-12.695382>,<-14.910375,-22.417583,-48.399270>}
      triangle {<14.635523,-22.417583,-12.695382>,<-14.910375,-22.417583,-12.695382>,<-14.910375,-22.417583,-48.399270>}
      triangle {<14.635523,-22.417583,-12.695382>,<14.635523,-34.159481,-12.695382>,<-14.910375,-22.417583,-12.695382>}
      triangle {<14.635523,-34.159481,-12.695382>,<-14.910375,-34.171299,-12.695382>,<-14.910375,-22.417583,-12.695382>}
      triangle {<14.635523,-22.417583,-12.695382>,<14.635523,-22.417583,-48.399270>,<14.635523,-34.159481,-12.695382>}
      triangle {<14.635523,-22.417583,-48.399270>,<14.635523,-32.097469,-48.399270>,<14.635523,-34.159481,-12.695382>}
      triangle {<8.243052,-33.422977,-63.054849>,<8.307620,-31.357159,-98.687890>,<22.396014,-31.325184,-63.201043>}
      triangle {<8.307620,-31.357159,-98.687890>,<15.379237,-30.473492,-95.910180>,<22.396014,-31.325184,-63.201043>}
      triangle {<22.396014,-29.668980,-63.201043>,<8.243052,-31.766773,-63.054849>,<22.396014,-31.325184,-63.201043>}
      triangle {<8.243052,-31.766773,-63.054849>,<8.243052,-33.422977,-63.054849>,<22.396014,-31.325184,-63.201043>}
      triangle {<8.243052,-31.766773,-63.054849>,<8.307620,-29.700954,-98.687890>,<8.243052,-33.422977,-63.054849>}
      triangle {<8.307620,-29.700954,-98.687890>,<8.307620,-31.357159,-98.687890>,<8.243052,-33.422977,-63.054849>}
      triangle {<8.307620,-29.700954,-98.687890>,<15.379237,-28.817287,-95.910180>,<8.307620,-31.357159,-98.687890>}
      triangle {<15.379237,-28.817287,-95.910180>,<15.379237,-30.473492,-95.910180>,<8.307620,-31.357159,-98.687890>}
      triangle {<15.379237,-28.817287,-95.910180>,<22.396014,-29.668980,-63.201043>,<15.379237,-30.473492,-95.910180>}
      triangle {<22.396014,-29.668980,-63.201043>,<22.396014,-31.325184,-63.201043>,<15.379237,-30.473492,-95.910180>}
      triangle {<15.379237,-28.817287,-95.910180>,<8.307620,-29.700954,-98.687890>,<22.396014,-29.668980,-63.201043>}
      triangle {<8.307620,-29.700954,-98.687890>,<8.243052,-31.766773,-63.054849>,<22.396014,-29.668980,-63.201043>}
      triangle {<-22.153280,-31.325184,-63.201043>,<-8.064886,-31.357159,-98.687890>,<-8.000318,-33.422977,-63.054849>}
      triangle {<-22.153280,-31.325184,-63.201043>,<-15.136503,-30.473492,-95.910180>,<-8.064886,-31.357159,-98.687890>}
      triangle {<-22.153280,-31.325184,-63.201043>,<-8.000318,-31.766773,-63.054849>,<-22.153280,-29.668980,-63.201043>}
      triangle {<-22.153280,-31.325184,-63.201043>,<-8.000318,-33.422977,-63.054849>,<-8.000318,-31.766773,-63.054849>}
      triangle {<-8.000318,-33.422977,-63.054849>,<-8.064886,-29.700954,-98.687890>,<-8.000318,-31.766773,-63.054849>}
      triangle {<-8.000318,-33.422977,-63.054849>,<-8.064886,-31.357159,-98.687890>,<-8.064886,-29.700954,-98.687890>}
      triangle {<-8.064886,-31.357159,-98.687890>,<-15.136503,-28.817287,-95.910180>,<-8.064886,-29.700954,-98.687890>}
      triangle {<-8.064886,-31.357159,-98.687890>,<-15.136503,-30.473492,-95.910180>,<-15.136503,-28.817287,-95.910180>}
      triangle {<-15.136503,-30.473492,-95.910180>,<-22.153280,-29.668980,-63.201043>,<-15.136503,-28.817287,-95.910180>}
      triangle {<-15.136503,-30.473492,-95.910180>,<-22.153280,-31.325184,-63.201043>,<-22.153280,-29.668980,-63.201043>}
      triangle {<-22.153280,-29.668980,-63.201043>,<-8.064886,-29.700954,-98.687890>,<-15.136503,-28.817287,-95.910180>}
      triangle {<-22.153280,-29.668980,-63.201043>,<-8.000318,-31.766773,-63.054849>,<-8.064886,-29.700954,-98.687890>}
      texture{_HullU01}
    }
    //_Aufbau01
    mesh{
      triangle {<-28.357473,2.328014,68.311599>,<-28.357473,6.336582,160.804332>,<0.759333,12.152576,173.855963>}
      triangle {<0.757113,8.017384,68.311606>,<-28.357473,2.328014,68.311599>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,6.005047,160.804332>,<0.759333,11.821049,173.855963>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,6.336582,160.804332>,<-28.357473,6.005047,160.804332>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,1.996479,68.311599>,<-28.357473,6.005047,160.804332>,<-28.357473,6.336582,160.804332>}
      triangle {<-28.357473,2.328014,68.311599>,<-28.357473,1.996479,68.311599>,<-28.357473,6.336582,160.804332>}
      triangle {<0.757105,7.685848,68.311606>,<-28.357473,1.996479,68.311599>,<-28.357473,2.328014,68.311599>}
      triangle {<0.757113,8.017384,68.311606>,<0.757105,7.685848,68.311606>,<-28.357473,2.328014,68.311599>}
      triangle {<0.759333,11.821049,173.855963>,<0.757105,7.685848,68.311606>,<0.757113,8.017384,68.311606>}
      triangle {<0.759333,12.152576,173.855963>,<0.759333,11.821049,173.855963>,<0.757113,8.017384,68.311606>}
      triangle {<-28.357473,1.996479,68.311599>,<0.757105,7.685848,68.311606>,<0.759333,11.821049,173.855963>}
      triangle {<-28.357473,6.005047,160.804332>,<-28.357473,1.996479,68.311599>,<0.759333,11.821049,173.855963>}
      triangle {<-27.107564,2.274616,69.660987>,<-27.107564,6.164196,158.898986>,<0.758784,11.800510,171.040030>}
      triangle {<0.758784,7.865704,69.721625>,<-27.107564,2.274616,69.660987>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,-1.487278,158.898980>,<0.758784,5.471149,171.040040>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,6.164196,158.898986>,<-27.107564,-1.487278,158.898980>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,-3.323994,69.660979>,<-27.107564,-1.487278,158.898980>,<-27.107564,6.164196,158.898986>}
      triangle {<-27.107564,2.274616,69.660987>,<-27.107564,-3.323994,69.660979>,<-27.107564,6.164196,158.898986>}
      triangle {<0.758784,1.587749,69.718223>,<-27.107564,-3.323994,69.660979>,<-27.107564,2.274616,69.660987>}
      triangle {<0.758784,7.865704,69.721625>,<0.758784,1.587749,69.718223>,<-27.107564,2.274616,69.660987>}
      triangle {<0.758784,5.471149,171.040040>,<0.758784,1.587749,69.718223>,<0.758784,7.865704,69.721625>}
      triangle {<0.758784,11.800510,171.040030>,<0.758784,5.471149,171.040040>,<0.758784,7.865704,69.721625>}
      triangle {<-27.107564,-3.323994,69.660979>,<0.758784,1.587749,69.718223>,<0.758784,5.471149,171.040040>}
      triangle {<-27.107564,-1.487278,158.898980>,<-27.107564,-3.323994,69.660979>,<0.758784,5.471149,171.040040>}
      triangle {<-46.698835,-8.720562,59.728873>,<-46.698835,-4.712002,152.221629>,<-17.582036,1.104008,165.273261>}
      triangle {<-17.584257,-3.031193,59.728873>,<-46.698835,-8.720562,59.728873>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-5.043537,152.221629>,<-17.582036,0.772480,165.273261>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-4.712002,152.221629>,<-46.698835,-5.043537,152.221629>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-9.052097,59.728873>,<-46.698835,-5.043537,152.221629>,<-46.698835,-4.712002,152.221629>}
      triangle {<-46.698835,-8.720562,59.728873>,<-46.698835,-9.052097,59.728873>,<-46.698835,-4.712002,152.221629>}
      triangle {<-17.584264,-3.362728,59.728873>,<-46.698835,-9.052097,59.728873>,<-46.698835,-8.720562,59.728873>}
      triangle {<-17.584257,-3.031193,59.728873>,<-17.584264,-3.362728,59.728873>,<-46.698835,-8.720562,59.728873>}
      triangle {<-17.582036,0.772480,165.273261>,<-17.584264,-3.362728,59.728873>,<-17.584257,-3.031193,59.728873>}
      triangle {<-17.582036,1.104008,165.273261>,<-17.582036,0.772480,165.273261>,<-17.584257,-3.031193,59.728873>}
      triangle {<-46.698835,-9.052097,59.728873>,<-17.584264,-3.362728,59.728873>,<-17.582036,0.772480,165.273261>}
      triangle {<-46.698835,-5.043537,152.221629>,<-46.698835,-9.052097,59.728873>,<-17.582036,0.772480,165.273261>}
      triangle {<-45.448926,-8.773960,61.078254>,<-45.448926,-4.884388,150.316279>,<-17.582586,0.751942,162.457329>}
      triangle {<-17.582586,-3.182873,61.138892>,<-45.448926,-8.773960,61.078254>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-12.535862,150.316281>,<-17.582586,-5.577427,162.457337>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-4.884388,150.316279>,<-45.448926,-12.535862,150.316281>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-14.372570,61.077964>,<-45.448926,-12.535862,150.316281>,<-45.448926,-4.884388,150.316279>}
      triangle {<-45.448926,-8.773960,61.078254>,<-45.448926,-14.372570,61.077964>,<-45.448926,-4.884388,150.316279>}
      triangle {<-17.582586,-9.460827,61.135489>,<-45.448926,-14.372570,61.077964>,<-45.448926,-8.773960,61.078254>}
      triangle {<-17.582586,-3.182873,61.138892>,<-17.582586,-9.460827,61.135489>,<-45.448926,-8.773960,61.078254>}
      triangle {<-17.582586,-5.577427,162.457337>,<-17.582586,-9.460827,61.135489>,<-17.582586,-3.182873,61.138892>}
      triangle {<-17.582586,0.751942,162.457329>,<-17.582586,-5.577427,162.457337>,<-17.582586,-3.182873,61.138892>}
      triangle {<-45.448926,-14.372570,61.077964>,<-17.582586,-9.460827,61.135489>,<-17.582586,-5.577427,162.457337>}
      triangle {<-45.448926,-12.535862,150.316281>,<-45.448926,-14.372570,61.077964>,<-17.582586,-5.577427,162.457337>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-9.520870,20.179862>,<-35.059949,-7.132145,130.862666>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-7.132145,130.862666>,<-0.219495,-0.323864,130.862662>}
      triangle {<-0.216840,-3.575008,4.560859>,<-0.216840,-3.971745,4.560859>,<-35.059949,-9.917606,20.179862>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-9.917606,20.179862>,<-35.059949,-9.520870,20.179862>}
      triangle {<-35.059949,-9.520870,20.179862>,<-35.059949,-9.917606,20.179862>,<-35.059949,-7.528881,130.862666>}
      triangle {<-35.059949,-9.520870,20.179862>,<-35.059949,-7.528881,130.862666>,<-35.059949,-7.132145,130.862666>}
      triangle {<-35.059949,-7.132145,130.862666>,<-35.059949,-7.528881,130.862666>,<-0.219495,-0.720600,130.862662>}
      triangle {<-35.059949,-7.132145,130.862666>,<-0.219495,-0.720600,130.862662>,<-0.219495,-0.323864,130.862662>}
      triangle {<-0.219495,-0.323864,130.862662>,<-0.219495,-0.720600,130.862662>,<-0.216840,-3.971745,4.560859>}
      triangle {<-0.219495,-0.323864,130.862662>,<-0.216840,-3.971745,4.560859>,<-0.216840,-3.575008,4.560859>}
      triangle {<-0.216840,-3.971745,4.560859>,<-0.219495,-0.720600,130.862662>,<-35.059949,-7.528881,130.862666>}
      triangle {<-0.216840,-3.971745,4.560859>,<-35.059949,-7.528881,130.862666>,<-35.059949,-9.917606,20.179862>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-9.579136,22.459937>,<-33.564229,-7.300861,129.247905>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-7.300861,129.247905>,<-0.217489,-0.614918,129.175330>}
      triangle {<-0.217489,-3.777554,7.930594>,<-0.217489,-11.351696,7.931144>,<-33.564229,-18.735401,22.459373>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-18.735401,22.459373>,<-33.564229,-9.579136,22.459937>}
      triangle {<-33.564229,-9.579136,22.459937>,<-33.564229,-18.735401,22.459373>,<-33.564229,-14.000530,129.247905>}
      triangle {<-33.564229,-9.579136,22.459937>,<-33.564229,-14.000530,129.247905>,<-33.564229,-7.300861,129.247905>}
      triangle {<-33.564229,-7.300861,129.247905>,<-33.564229,-14.000530,129.247905>,<-0.217489,-8.127254,129.179423>}
      triangle {<-33.564229,-7.300861,129.247905>,<-0.217489,-8.127254,129.179423>,<-0.217489,-0.614918,129.175330>}
      triangle {<-0.217489,-0.614918,129.175330>,<-0.217489,-8.127254,129.179423>,<-0.217489,-11.351696,7.931144>}
      triangle {<-0.217489,-0.614918,129.175330>,<-0.217489,-11.351696,7.931144>,<-0.217489,-3.777554,7.930594>}
      triangle {<-0.217489,-11.351696,7.931144>,<-0.217489,-8.127254,129.179423>,<-33.564229,-14.000530,129.247905>}
      triangle {<-0.217489,-11.351696,7.931144>,<-33.564229,-14.000530,129.247905>,<-33.564229,-18.735401,22.459373>}
      triangle {<-38.817426,-4.992428,39.511146>,<-38.817426,0.352329,162.834663>,<0.004977,8.106998,180.237017>}
      triangle {<0.002024,2.593403,39.511146>,<-38.817426,-4.992428,39.511146>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,-0.089718,162.834663>,<0.004977,7.664951,180.237017>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,0.352329,162.834663>,<-38.817426,-0.089718,162.834663>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,-5.434475,39.511146>,<-38.817426,-0.089718,162.834663>,<-38.817426,0.352329,162.834663>}
      triangle {<-38.817426,-4.992428,39.511146>,<-38.817426,-5.434475,39.511146>,<-38.817426,0.352329,162.834663>}
      triangle {<0.002017,2.151356,39.511146>,<-38.817426,-5.434475,39.511146>,<-38.817426,-4.992428,39.511146>}
      triangle {<0.002024,2.593403,39.511146>,<0.002017,2.151356,39.511146>,<-38.817426,-4.992428,39.511146>}
      triangle {<0.004977,7.664951,180.237017>,<0.002017,2.151356,39.511146>,<0.002024,2.593403,39.511146>}
      triangle {<0.004977,8.106998,180.237017>,<0.004977,7.664951,180.237017>,<0.002024,2.593403,39.511146>}
      triangle {<-38.817426,-5.434475,39.511146>,<0.002017,2.151356,39.511146>,<0.004977,7.664951,180.237017>}
      triangle {<-38.817426,-0.089718,162.834663>,<-38.817426,-5.434475,39.511146>,<0.004977,7.664951,180.237017>}
      triangle {<-37.150884,-5.063625,41.310325>,<-37.150884,0.122478,160.294198>,<0.004252,7.637569,176.482299>}
      triangle {<0.004252,2.391155,41.391166>,<-37.150884,-5.063625,41.310325>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,-10.079487,160.294200>,<0.004252,-0.801586,176.482309>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,0.122478,160.294198>,<-37.150884,-10.079487,160.294200>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,-12.528431,41.310325>,<-37.150884,-10.079487,160.294200>,<-37.150884,0.122478,160.294198>}
      triangle {<-37.150884,-5.063625,41.310325>,<-37.150884,-12.528431,41.310325>,<-37.150884,0.122478,160.294198>}
      triangle {<0.004252,-5.979443,41.386634>,<-37.150884,-12.528431,41.310325>,<-37.150884,-5.063625,41.310325>}
      triangle {<0.004252,2.391155,41.391166>,<0.004252,-5.979443,41.386634>,<-37.150884,-5.063625,41.310325>}
      triangle {<0.004252,-0.801586,176.482309>,<0.004252,-5.979443,41.386634>,<0.004252,2.391155,41.391166>}
      triangle {<0.004252,7.637569,176.482299>,<0.004252,-0.801586,176.482309>,<0.004252,2.391155,41.391166>}
      triangle {<-37.150884,-12.528431,41.310325>,<0.004252,-5.979443,41.386634>,<0.004252,-0.801586,176.482309>}
      triangle {<-37.150884,-10.079487,160.294200>,<-37.150884,-12.528431,41.310325>,<0.004252,-0.801586,176.482309>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,6.336582,160.804332>,<29.132670,2.328014,68.311599>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,2.328014,68.311599>,<0.018084,8.017384,68.311606>}
      triangle {<0.015864,12.152576,173.855963>,<0.015864,11.821049,173.855963>,<29.132670,6.005047,160.804332>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,6.005047,160.804332>,<29.132670,6.336582,160.804332>}
      triangle {<29.132670,6.336582,160.804332>,<29.132670,6.005047,160.804332>,<29.132670,1.996479,68.311599>}
      triangle {<29.132670,6.336582,160.804332>,<29.132670,1.996479,68.311599>,<29.132670,2.328014,68.311599>}
      triangle {<29.132670,2.328014,68.311599>,<29.132670,1.996479,68.311599>,<0.018092,7.685848,68.311606>}
      triangle {<29.132670,2.328014,68.311599>,<0.018092,7.685848,68.311606>,<0.018084,8.017384,68.311606>}
      triangle {<0.018084,8.017384,68.311606>,<0.018092,7.685848,68.311606>,<0.015864,11.821049,173.855963>}
      triangle {<0.018084,8.017384,68.311606>,<0.015864,11.821049,173.855963>,<0.015864,12.152576,173.855963>}
      triangle {<0.015864,11.821049,173.855963>,<0.018092,7.685848,68.311606>,<29.132670,1.996479,68.311599>}
      triangle {<0.015864,11.821049,173.855963>,<29.132670,1.996479,68.311599>,<29.132670,6.005047,160.804332>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,6.164196,158.898986>,<27.882761,2.274616,69.660987>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,2.274616,69.660987>,<0.016413,7.865704,69.721625>}
      triangle {<0.016413,11.800510,171.040030>,<0.016413,5.471149,171.040040>,<27.882761,-1.487278,158.898980>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,-1.487278,158.898980>,<27.882761,6.164196,158.898986>}
      triangle {<27.882761,6.164196,158.898986>,<27.882761,-1.487278,158.898980>,<27.882761,-3.323994,69.660979>}
      triangle {<27.882761,6.164196,158.898986>,<27.882761,-3.323994,69.660979>,<27.882761,2.274616,69.660987>}
      triangle {<27.882761,2.274616,69.660987>,<27.882761,-3.323994,69.660979>,<0.016413,1.587749,69.718223>}
      triangle {<27.882761,2.274616,69.660987>,<0.016413,1.587749,69.718223>,<0.016413,7.865704,69.721625>}
      triangle {<0.016413,7.865704,69.721625>,<0.016413,1.587749,69.718223>,<0.016413,5.471149,171.040040>}
      triangle {<0.016413,7.865704,69.721625>,<0.016413,5.471149,171.040040>,<0.016413,11.800510,171.040030>}
      triangle {<0.016413,5.471149,171.040040>,<0.016413,1.587749,69.718223>,<27.882761,-3.323994,69.660979>}
      triangle {<0.016413,5.471149,171.040040>,<27.882761,-3.323994,69.660979>,<27.882761,-1.487278,158.898980>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,0.352322,162.834728>,<38.820963,-4.992420,39.511146>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,-4.992420,39.511146>,<0.001513,2.593410,39.511146>}
      triangle {<-0.001440,8.106991,180.237010>,<-0.001440,7.664944,180.237010>,<38.820963,-0.089725,162.834728>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,-0.089725,162.834728>,<38.820963,0.352322,162.834728>}
      triangle {<38.820963,0.352322,162.834728>,<38.820963,-0.089725,162.834728>,<38.820963,-5.434467,39.511146>}
      triangle {<38.820963,0.352322,162.834728>,<38.820963,-5.434467,39.511146>,<38.820963,-4.992420,39.511146>}
      triangle {<38.820963,-4.992420,39.511146>,<38.820963,-5.434467,39.511146>,<0.001521,2.151363,39.511146>}
      triangle {<38.820963,-4.992420,39.511146>,<0.001521,2.151363,39.511146>,<0.001513,2.593410,39.511146>}
      triangle {<0.001513,2.593410,39.511146>,<0.001521,2.151363,39.511146>,<-0.001440,7.664944,180.237010>}
      triangle {<0.001513,2.593410,39.511146>,<-0.001440,7.664944,180.237010>,<-0.001440,8.106991,180.237010>}
      triangle {<-0.001440,7.664944,180.237010>,<0.001521,2.151363,39.511146>,<38.820963,-5.434467,39.511146>}
      triangle {<-0.001440,7.664944,180.237010>,<38.820963,-5.434467,39.511146>,<38.820963,-0.089725,162.834728>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,0.122471,160.294267>,<37.154421,-5.063618,41.310325>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,-5.063618,41.310325>,<-0.000715,2.391163,41.391166>}
      triangle {<-0.000715,7.637562,176.482295>,<-0.000715,-0.801594,176.482305>,<37.154421,-10.079494,160.294227>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,-10.079494,160.294227>,<37.154421,0.122471,160.294267>}
      triangle {<37.154421,0.122471,160.294267>,<37.154421,-10.079494,160.294227>,<37.154421,-12.528423,41.310325>}
      triangle {<37.154421,0.122471,160.294267>,<37.154421,-12.528423,41.310325>,<37.154421,-5.063618,41.310325>}
      triangle {<37.154421,-5.063618,41.310325>,<37.154421,-12.528423,41.310325>,<-0.000715,-5.979435,41.386634>}
      triangle {<37.154421,-5.063618,41.310325>,<-0.000715,-5.979435,41.386634>,<-0.000715,2.391163,41.391166>}
      triangle {<-0.000715,2.391163,41.391166>,<-0.000715,-5.979435,41.386634>,<-0.000715,-0.801594,176.482305>}
      triangle {<-0.000715,2.391163,41.391166>,<-0.000715,-0.801594,176.482305>,<-0.000715,7.637562,176.482295>}
      triangle {<-0.000715,-0.801594,176.482305>,<-0.000715,-5.979435,41.386634>,<37.154421,-12.528423,41.310325>}
      triangle {<-0.000715,-0.801594,176.482305>,<37.154421,-12.528423,41.310325>,<37.154421,-10.079494,160.294227>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-4.712002,152.221629>,<47.437205,-8.720562,59.728873>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-8.720562,59.728873>,<18.322627,-3.031193,59.728873>}
      triangle {<18.320406,1.104008,165.273261>,<18.320406,0.772480,165.273261>,<47.437205,-5.043537,152.221629>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-5.043537,152.221629>,<47.437205,-4.712002,152.221629>}
      triangle {<47.437205,-4.712002,152.221629>,<47.437205,-5.043537,152.221629>,<47.437205,-9.052097,59.728873>}
      triangle {<47.437205,-4.712002,152.221629>,<47.437205,-9.052097,59.728873>,<47.437205,-8.720562,59.728873>}
      triangle {<47.437205,-8.720562,59.728873>,<47.437205,-9.052097,59.728873>,<18.322634,-3.362728,59.728873>}
      triangle {<47.437205,-8.720562,59.728873>,<18.322634,-3.362728,59.728873>,<18.322627,-3.031193,59.728873>}
      triangle {<18.322627,-3.031193,59.728873>,<18.322634,-3.362728,59.728873>,<18.320406,0.772480,165.273261>}
      triangle {<18.322627,-3.031193,59.728873>,<18.320406,0.772480,165.273261>,<18.320406,1.104008,165.273261>}
      triangle {<18.320406,0.772480,165.273261>,<18.322634,-3.362728,59.728873>,<47.437205,-9.052097,59.728873>}
      triangle {<18.320406,0.772480,165.273261>,<47.437205,-9.052097,59.728873>,<47.437205,-5.043537,152.221629>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-4.884388,150.316279>,<46.187296,-8.773960,61.078254>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-8.773960,61.078254>,<18.320956,-3.182873,61.138892>}
      triangle {<18.320956,0.751942,162.457329>,<18.320956,-5.577427,162.457337>,<46.187296,-12.535862,150.316281>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-12.535862,150.316281>,<46.187296,-4.884388,150.316279>}
      triangle {<46.187296,-4.884388,150.316279>,<46.187296,-12.535862,150.316281>,<46.187296,-14.372570,61.077964>}
      triangle {<46.187296,-4.884388,150.316279>,<46.187296,-14.372570,61.077964>,<46.187296,-8.773960,61.078254>}
      triangle {<46.187296,-8.773960,61.078254>,<46.187296,-14.372570,61.077964>,<18.320956,-9.460827,61.135489>}
      triangle {<46.187296,-8.773960,61.078254>,<18.320956,-9.460827,61.135489>,<18.320956,-3.182873,61.138892>}
      triangle {<18.320956,-3.182873,61.138892>,<18.320956,-9.460827,61.135489>,<18.320956,-5.577427,162.457337>}
      triangle {<18.320956,-3.182873,61.138892>,<18.320956,-5.577427,162.457337>,<18.320956,0.751942,162.457329>}
      triangle {<18.320956,-5.577427,162.457337>,<18.320956,-9.460827,61.135489>,<46.187296,-14.372570,61.077964>}
      triangle {<18.320956,-5.577427,162.457337>,<46.187296,-14.372570,61.077964>,<46.187296,-12.535862,150.316281>}
      triangle {<34.801623,-7.132145,130.862666>,<34.801623,-9.520870,20.179862>,<-0.041486,-3.575008,4.560859>}
      triangle {<-0.038831,-0.323864,130.862662>,<34.801623,-7.132145,130.862666>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-9.917606,20.179862>,<-0.041486,-3.971745,4.560859>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-9.520870,20.179862>,<34.801623,-9.917606,20.179862>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-7.528881,130.862666>,<34.801623,-9.917606,20.179862>,<34.801623,-9.520870,20.179862>}
      triangle {<34.801623,-7.132145,130.862666>,<34.801623,-7.528881,130.862666>,<34.801623,-9.520870,20.179862>}
      triangle {<-0.038831,-0.720600,130.862662>,<34.801623,-7.528881,130.862666>,<34.801623,-7.132145,130.862666>}
      triangle {<-0.038831,-0.323864,130.862662>,<-0.038831,-0.720600,130.862662>,<34.801623,-7.132145,130.862666>}
      triangle {<-0.041486,-3.971745,4.560859>,<-0.038831,-0.720600,130.862662>,<-0.038831,-0.323864,130.862662>}
      triangle {<-0.041486,-3.575008,4.560859>,<-0.041486,-3.971745,4.560859>,<-0.038831,-0.323864,130.862662>}
      triangle {<34.801623,-7.528881,130.862666>,<-0.038831,-0.720600,130.862662>,<-0.041486,-3.971745,4.560859>}
      triangle {<34.801623,-9.917606,20.179862>,<34.801623,-7.528881,130.862666>,<-0.041486,-3.971745,4.560859>}
      triangle {<33.305903,-7.300861,129.247905>,<33.305903,-9.579136,22.459937>,<-0.040838,-3.777554,7.930594>}
      triangle {<-0.040838,-0.614918,129.175330>,<33.305903,-7.300861,129.247905>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-18.735401,22.459373>,<-0.040838,-11.351696,7.931144>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-9.579136,22.459937>,<33.305903,-18.735401,22.459373>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-14.000530,129.247905>,<33.305903,-18.735401,22.459373>,<33.305903,-9.579136,22.459937>}
      triangle {<33.305903,-7.300861,129.247905>,<33.305903,-14.000530,129.247905>,<33.305903,-9.579136,22.459937>}
      triangle {<-0.040838,-8.127254,129.179423>,<33.305903,-14.000530,129.247905>,<33.305903,-7.300861,129.247905>}
      triangle {<-0.040838,-0.614918,129.175330>,<-0.040838,-8.127254,129.179423>,<33.305903,-7.300861,129.247905>}
      triangle {<-0.040838,-11.351696,7.931144>,<-0.040838,-8.127254,129.179423>,<-0.040838,-0.614918,129.175330>}
      triangle {<-0.040838,-3.777554,7.930594>,<-0.040838,-11.351696,7.931144>,<-0.040838,-0.614918,129.175330>}
      triangle {<33.305903,-14.000530,129.247905>,<-0.040838,-8.127254,129.179423>,<-0.040838,-11.351696,7.931144>}
      triangle {<33.305903,-18.735401,22.459373>,<33.305903,-14.000530,129.247905>,<-0.040838,-11.351696,7.931144>}
      triangle {<-25.835157,0.380840,46.651084>,<-25.835157,2.931889,105.513358>,<0.708964,8.269398,113.819419>}
      triangle {<0.706942,5.637630,46.651084>,<-25.835157,0.380840,46.651084>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,2.720898,105.513358>,<0.708964,8.058414,113.819415>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,2.931889,105.513358>,<-25.835157,2.720898,105.513358>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,0.169849,46.651084>,<-25.835157,2.720898,105.513358>,<-25.835157,2.931889,105.513358>}
      triangle {<-25.835157,0.380840,46.651084>,<-25.835157,0.169849,46.651084>,<-25.835157,2.931889,105.513358>}
      triangle {<0.706934,5.426640,46.651084>,<-25.835157,0.169849,46.651084>,<-25.835157,0.380840,46.651084>}
      triangle {<0.706942,5.637630,46.651084>,<0.706934,5.426640,46.651084>,<-25.835157,0.380840,46.651084>}
      triangle {<0.708964,8.058414,113.819415>,<0.706934,5.426640,46.651084>,<0.706942,5.637630,46.651084>}
      triangle {<0.708964,8.269398,113.819419>,<0.708964,8.058414,113.819415>,<0.706942,5.637630,46.651084>}
      triangle {<-25.835157,0.169849,46.651084>,<0.706934,5.426640,46.651084>,<0.708964,8.058414,113.819415>}
      triangle {<-25.835157,2.720898,105.513358>,<-25.835157,0.169849,46.651084>,<0.708964,8.058414,113.819415>}
      triangle {<-24.695692,0.417095,47.509849>,<-24.695692,2.892422,104.300788>,<0.708460,8.045307,112.027350>}
      triangle {<0.708460,5.541195,47.548423>,<-24.695692,0.417095,47.509849>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,-1.976978,104.300788>,<0.708460,4.017292,112.027366>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,2.892422,104.300788>,<-24.695692,-1.976978,104.300788>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,-3.145863,47.509849>,<-24.695692,-1.976978,104.300788>,<-24.695692,2.892422,104.300788>}
      triangle {<-24.695692,0.417095,47.509849>,<-24.695692,-3.145863,47.509849>,<-24.695692,2.892422,104.300788>}
      triangle {<0.708460,1.545902,47.546256>,<-24.695692,-3.145863,47.509849>,<-24.695692,0.417095,47.509849>}
      triangle {<0.708460,5.541195,47.548423>,<0.708460,1.545902,47.546256>,<-24.695692,0.417095,47.509849>}
      triangle {<0.708460,4.017292,112.027366>,<0.708460,1.545902,47.546256>,<0.708460,5.541195,47.548423>}
      triangle {<0.708460,8.045307,112.027350>,<0.708460,4.017292,112.027366>,<0.708460,5.541195,47.548423>}
      triangle {<-24.695692,-3.145863,47.509849>,<0.708460,1.545902,47.546256>,<0.708460,4.017292,112.027366>}
      triangle {<-24.695692,-1.976978,104.300788>,<-24.695692,-3.145863,47.509849>,<0.708460,4.017292,112.027366>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,2.931889,105.513358>,<26.610354,0.380840,46.651084>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,0.380840,46.651084>,<0.068255,5.637630,46.651084>}
      triangle {<0.066233,8.269398,113.819419>,<0.066233,8.058414,113.819415>,<26.610354,2.720898,105.513358>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,2.720898,105.513358>,<26.610354,2.931889,105.513358>}
      triangle {<26.610354,2.931889,105.513358>,<26.610354,2.720898,105.513358>,<26.610354,0.169849,46.651084>}
      triangle {<26.610354,2.931889,105.513358>,<26.610354,0.169849,46.651084>,<26.610354,0.380840,46.651084>}
      triangle {<26.610354,0.380840,46.651084>,<26.610354,0.169849,46.651084>,<0.068263,5.426640,46.651084>}
      triangle {<26.610354,0.380840,46.651084>,<0.068263,5.426640,46.651084>,<0.068255,5.637630,46.651084>}
      triangle {<0.068255,5.637630,46.651084>,<0.068263,5.426640,46.651084>,<0.066233,8.058414,113.819415>}
      triangle {<0.068255,5.637630,46.651084>,<0.066233,8.058414,113.819415>,<0.066233,8.269398,113.819419>}
      triangle {<0.066233,8.058414,113.819415>,<0.068263,5.426640,46.651084>,<26.610354,0.169849,46.651084>}
      triangle {<0.066233,8.058414,113.819415>,<26.610354,0.169849,46.651084>,<26.610354,2.720898,105.513358>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,2.892422,104.300788>,<25.470889,0.417095,47.509849>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,0.417095,47.509849>,<0.066737,5.541195,47.548423>}
      triangle {<0.066737,8.045307,112.027350>,<0.066737,4.017292,112.027366>,<25.470889,-1.976978,104.300788>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,-1.976978,104.300788>,<25.470889,2.892422,104.300788>}
      triangle {<25.470889,2.892422,104.300788>,<25.470889,-1.976978,104.300788>,<25.470889,-3.145863,47.509849>}
      triangle {<25.470889,2.892422,104.300788>,<25.470889,-3.145863,47.509849>,<25.470889,0.417095,47.509849>}
      triangle {<25.470889,0.417095,47.509849>,<25.470889,-3.145863,47.509849>,<0.066737,1.545902,47.546256>}
      triangle {<25.470889,0.417095,47.509849>,<0.066737,1.545902,47.546256>,<0.066737,5.541195,47.548423>}
      triangle {<0.066737,5.541195,47.548423>,<0.066737,1.545902,47.546256>,<0.066737,4.017292,112.027366>}
      triangle {<0.066737,5.541195,47.548423>,<0.066737,4.017292,112.027366>,<0.066737,8.045307,112.027350>}
      triangle {<0.066737,4.017292,112.027366>,<0.066737,1.545902,47.546256>,<25.470889,-3.145863,47.509849>}
      triangle {<0.066737,4.017292,112.027366>,<25.470889,-3.145863,47.509849>,<25.470889,-1.976978,104.300788>}
      texture{_Aufbau01}
    }
    //_Aufbau02
    mesh{
      triangle {<-28.357473,2.328014,68.311599>,<-28.357473,6.336582,160.804332>,<0.759333,12.152576,173.855963>}
      triangle {<0.757113,8.017384,68.311606>,<-28.357473,2.328014,68.311599>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,6.005047,160.804332>,<0.759333,11.821049,173.855963>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,6.336582,160.804332>,<-28.357473,6.005047,160.804332>,<0.759333,12.152576,173.855963>}
      triangle {<-28.357473,1.996479,68.311599>,<-28.357473,6.005047,160.804332>,<-28.357473,6.336582,160.804332>}
      triangle {<-28.357473,2.328014,68.311599>,<-28.357473,1.996479,68.311599>,<-28.357473,6.336582,160.804332>}
      triangle {<0.757105,7.685848,68.311606>,<-28.357473,1.996479,68.311599>,<-28.357473,2.328014,68.311599>}
      triangle {<0.757113,8.017384,68.311606>,<0.757105,7.685848,68.311606>,<-28.357473,2.328014,68.311599>}
      triangle {<0.759333,11.821049,173.855963>,<0.757105,7.685848,68.311606>,<0.757113,8.017384,68.311606>}
      triangle {<0.759333,12.152576,173.855963>,<0.759333,11.821049,173.855963>,<0.757113,8.017384,68.311606>}
      triangle {<-28.357473,1.996479,68.311599>,<0.757105,7.685848,68.311606>,<0.759333,11.821049,173.855963>}
      triangle {<-28.357473,6.005047,160.804332>,<-28.357473,1.996479,68.311599>,<0.759333,11.821049,173.855963>}
      triangle {<-27.107564,2.274616,69.660987>,<-27.107564,6.164196,158.898986>,<0.758784,11.800510,171.040030>}
      triangle {<0.758784,7.865704,69.721625>,<-27.107564,2.274616,69.660987>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,-1.487278,158.898980>,<0.758784,5.471149,171.040040>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,6.164196,158.898986>,<-27.107564,-1.487278,158.898980>,<0.758784,11.800510,171.040030>}
      triangle {<-27.107564,-3.323994,69.660979>,<-27.107564,-1.487278,158.898980>,<-27.107564,6.164196,158.898986>}
      triangle {<-27.107564,2.274616,69.660987>,<-27.107564,-3.323994,69.660979>,<-27.107564,6.164196,158.898986>}
      triangle {<0.758784,1.587749,69.718223>,<-27.107564,-3.323994,69.660979>,<-27.107564,2.274616,69.660987>}
      triangle {<0.758784,7.865704,69.721625>,<0.758784,1.587749,69.718223>,<-27.107564,2.274616,69.660987>}
      triangle {<0.758784,5.471149,171.040040>,<0.758784,1.587749,69.718223>,<0.758784,7.865704,69.721625>}
      triangle {<0.758784,11.800510,171.040030>,<0.758784,5.471149,171.040040>,<0.758784,7.865704,69.721625>}
      triangle {<-27.107564,-3.323994,69.660979>,<0.758784,1.587749,69.718223>,<0.758784,5.471149,171.040040>}
      triangle {<-27.107564,-1.487278,158.898980>,<-27.107564,-3.323994,69.660979>,<0.758784,5.471149,171.040040>}
      triangle {<-46.698835,-8.720562,59.728873>,<-46.698835,-4.712002,152.221629>,<-17.582036,1.104008,165.273261>}
      triangle {<-17.584257,-3.031193,59.728873>,<-46.698835,-8.720562,59.728873>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-5.043537,152.221629>,<-17.582036,0.772480,165.273261>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-4.712002,152.221629>,<-46.698835,-5.043537,152.221629>,<-17.582036,1.104008,165.273261>}
      triangle {<-46.698835,-9.052097,59.728873>,<-46.698835,-5.043537,152.221629>,<-46.698835,-4.712002,152.221629>}
      triangle {<-46.698835,-8.720562,59.728873>,<-46.698835,-9.052097,59.728873>,<-46.698835,-4.712002,152.221629>}
      triangle {<-17.584264,-3.362728,59.728873>,<-46.698835,-9.052097,59.728873>,<-46.698835,-8.720562,59.728873>}
      triangle {<-17.584257,-3.031193,59.728873>,<-17.584264,-3.362728,59.728873>,<-46.698835,-8.720562,59.728873>}
      triangle {<-17.582036,0.772480,165.273261>,<-17.584264,-3.362728,59.728873>,<-17.584257,-3.031193,59.728873>}
      triangle {<-17.582036,1.104008,165.273261>,<-17.582036,0.772480,165.273261>,<-17.584257,-3.031193,59.728873>}
      triangle {<-46.698835,-9.052097,59.728873>,<-17.584264,-3.362728,59.728873>,<-17.582036,0.772480,165.273261>}
      triangle {<-46.698835,-5.043537,152.221629>,<-46.698835,-9.052097,59.728873>,<-17.582036,0.772480,165.273261>}
      triangle {<-45.448926,-8.773960,61.078254>,<-45.448926,-4.884388,150.316279>,<-17.582586,0.751942,162.457329>}
      triangle {<-17.582586,-3.182873,61.138892>,<-45.448926,-8.773960,61.078254>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-12.535862,150.316281>,<-17.582586,-5.577427,162.457337>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-4.884388,150.316279>,<-45.448926,-12.535862,150.316281>,<-17.582586,0.751942,162.457329>}
      triangle {<-45.448926,-14.372570,61.077964>,<-45.448926,-12.535862,150.316281>,<-45.448926,-4.884388,150.316279>}
      triangle {<-45.448926,-8.773960,61.078254>,<-45.448926,-14.372570,61.077964>,<-45.448926,-4.884388,150.316279>}
      triangle {<-17.582586,-9.460827,61.135489>,<-45.448926,-14.372570,61.077964>,<-45.448926,-8.773960,61.078254>}
      triangle {<-17.582586,-3.182873,61.138892>,<-17.582586,-9.460827,61.135489>,<-45.448926,-8.773960,61.078254>}
      triangle {<-17.582586,-5.577427,162.457337>,<-17.582586,-9.460827,61.135489>,<-17.582586,-3.182873,61.138892>}
      triangle {<-17.582586,0.751942,162.457329>,<-17.582586,-5.577427,162.457337>,<-17.582586,-3.182873,61.138892>}
      triangle {<-45.448926,-14.372570,61.077964>,<-17.582586,-9.460827,61.135489>,<-17.582586,-5.577427,162.457337>}
      triangle {<-45.448926,-12.535862,150.316281>,<-45.448926,-14.372570,61.077964>,<-17.582586,-5.577427,162.457337>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-9.520870,20.179862>,<-35.059949,-7.132145,130.862666>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-7.132145,130.862666>,<-0.219495,-0.323864,130.862662>}
      triangle {<-0.216840,-3.575008,4.560859>,<-0.216840,-3.971745,4.560859>,<-35.059949,-9.917606,20.179862>}
      triangle {<-0.216840,-3.575008,4.560859>,<-35.059949,-9.917606,20.179862>,<-35.059949,-9.520870,20.179862>}
      triangle {<-35.059949,-9.520870,20.179862>,<-35.059949,-9.917606,20.179862>,<-35.059949,-7.528881,130.862666>}
      triangle {<-35.059949,-9.520870,20.179862>,<-35.059949,-7.528881,130.862666>,<-35.059949,-7.132145,130.862666>}
      triangle {<-35.059949,-7.132145,130.862666>,<-35.059949,-7.528881,130.862666>,<-0.219495,-0.720600,130.862662>}
      triangle {<-35.059949,-7.132145,130.862666>,<-0.219495,-0.720600,130.862662>,<-0.219495,-0.323864,130.862662>}
      triangle {<-0.219495,-0.323864,130.862662>,<-0.219495,-0.720600,130.862662>,<-0.216840,-3.971745,4.560859>}
      triangle {<-0.219495,-0.323864,130.862662>,<-0.216840,-3.971745,4.560859>,<-0.216840,-3.575008,4.560859>}
      triangle {<-0.216840,-3.971745,4.560859>,<-0.219495,-0.720600,130.862662>,<-35.059949,-7.528881,130.862666>}
      triangle {<-0.216840,-3.971745,4.560859>,<-35.059949,-7.528881,130.862666>,<-35.059949,-9.917606,20.179862>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-9.579136,22.459937>,<-33.564229,-7.300861,129.247905>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-7.300861,129.247905>,<-0.217489,-0.614918,129.175330>}
      triangle {<-0.217489,-3.777554,7.930594>,<-0.217489,-11.351696,7.931144>,<-33.564229,-18.735401,22.459373>}
      triangle {<-0.217489,-3.777554,7.930594>,<-33.564229,-18.735401,22.459373>,<-33.564229,-9.579136,22.459937>}
      triangle {<-33.564229,-9.579136,22.459937>,<-33.564229,-18.735401,22.459373>,<-33.564229,-14.000530,129.247905>}
      triangle {<-33.564229,-9.579136,22.459937>,<-33.564229,-14.000530,129.247905>,<-33.564229,-7.300861,129.247905>}
      triangle {<-33.564229,-7.300861,129.247905>,<-33.564229,-14.000530,129.247905>,<-0.217489,-8.127254,129.179423>}
      triangle {<-33.564229,-7.300861,129.247905>,<-0.217489,-8.127254,129.179423>,<-0.217489,-0.614918,129.175330>}
      triangle {<-0.217489,-0.614918,129.175330>,<-0.217489,-8.127254,129.179423>,<-0.217489,-11.351696,7.931144>}
      triangle {<-0.217489,-0.614918,129.175330>,<-0.217489,-11.351696,7.931144>,<-0.217489,-3.777554,7.930594>}
      triangle {<-0.217489,-11.351696,7.931144>,<-0.217489,-8.127254,129.179423>,<-33.564229,-14.000530,129.247905>}
      triangle {<-0.217489,-11.351696,7.931144>,<-33.564229,-14.000530,129.247905>,<-33.564229,-18.735401,22.459373>}
      triangle {<-38.817426,-4.992428,39.511146>,<-38.817426,0.352329,162.834663>,<0.004977,8.106998,180.237017>}
      triangle {<0.002024,2.593403,39.511146>,<-38.817426,-4.992428,39.511146>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,-0.089718,162.834663>,<0.004977,7.664951,180.237017>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,0.352329,162.834663>,<-38.817426,-0.089718,162.834663>,<0.004977,8.106998,180.237017>}
      triangle {<-38.817426,-5.434475,39.511146>,<-38.817426,-0.089718,162.834663>,<-38.817426,0.352329,162.834663>}
      triangle {<-38.817426,-4.992428,39.511146>,<-38.817426,-5.434475,39.511146>,<-38.817426,0.352329,162.834663>}
      triangle {<0.002017,2.151356,39.511146>,<-38.817426,-5.434475,39.511146>,<-38.817426,-4.992428,39.511146>}
      triangle {<0.002024,2.593403,39.511146>,<0.002017,2.151356,39.511146>,<-38.817426,-4.992428,39.511146>}
      triangle {<0.004977,7.664951,180.237017>,<0.002017,2.151356,39.511146>,<0.002024,2.593403,39.511146>}
      triangle {<0.004977,8.106998,180.237017>,<0.004977,7.664951,180.237017>,<0.002024,2.593403,39.511146>}
      triangle {<-38.817426,-5.434475,39.511146>,<0.002017,2.151356,39.511146>,<0.004977,7.664951,180.237017>}
      triangle {<-38.817426,-0.089718,162.834663>,<-38.817426,-5.434475,39.511146>,<0.004977,7.664951,180.237017>}
      triangle {<-37.150884,-5.063625,41.310325>,<-37.150884,0.122478,160.294198>,<0.004252,7.637569,176.482299>}
      triangle {<0.004252,2.391155,41.391166>,<-37.150884,-5.063625,41.310325>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,-10.079487,160.294200>,<0.004252,-0.801586,176.482309>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,0.122478,160.294198>,<-37.150884,-10.079487,160.294200>,<0.004252,7.637569,176.482299>}
      triangle {<-37.150884,-12.528431,41.310325>,<-37.150884,-10.079487,160.294200>,<-37.150884,0.122478,160.294198>}
      triangle {<-37.150884,-5.063625,41.310325>,<-37.150884,-12.528431,41.310325>,<-37.150884,0.122478,160.294198>}
      triangle {<0.004252,-5.979443,41.386634>,<-37.150884,-12.528431,41.310325>,<-37.150884,-5.063625,41.310325>}
      triangle {<0.004252,2.391155,41.391166>,<0.004252,-5.979443,41.386634>,<-37.150884,-5.063625,41.310325>}
      triangle {<0.004252,-0.801586,176.482309>,<0.004252,-5.979443,41.386634>,<0.004252,2.391155,41.391166>}
      triangle {<0.004252,7.637569,176.482299>,<0.004252,-0.801586,176.482309>,<0.004252,2.391155,41.391166>}
      triangle {<-37.150884,-12.528431,41.310325>,<0.004252,-5.979443,41.386634>,<0.004252,-0.801586,176.482309>}
      triangle {<-37.150884,-10.079487,160.294200>,<-37.150884,-12.528431,41.310325>,<0.004252,-0.801586,176.482309>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,6.336582,160.804332>,<29.132670,2.328014,68.311599>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,2.328014,68.311599>,<0.018084,8.017384,68.311606>}
      triangle {<0.015864,12.152576,173.855963>,<0.015864,11.821049,173.855963>,<29.132670,6.005047,160.804332>}
      triangle {<0.015864,12.152576,173.855963>,<29.132670,6.005047,160.804332>,<29.132670,6.336582,160.804332>}
      triangle {<29.132670,6.336582,160.804332>,<29.132670,6.005047,160.804332>,<29.132670,1.996479,68.311599>}
      triangle {<29.132670,6.336582,160.804332>,<29.132670,1.996479,68.311599>,<29.132670,2.328014,68.311599>}
      triangle {<29.132670,2.328014,68.311599>,<29.132670,1.996479,68.311599>,<0.018092,7.685848,68.311606>}
      triangle {<29.132670,2.328014,68.311599>,<0.018092,7.685848,68.311606>,<0.018084,8.017384,68.311606>}
      triangle {<0.018084,8.017384,68.311606>,<0.018092,7.685848,68.311606>,<0.015864,11.821049,173.855963>}
      triangle {<0.018084,8.017384,68.311606>,<0.015864,11.821049,173.855963>,<0.015864,12.152576,173.855963>}
      triangle {<0.015864,11.821049,173.855963>,<0.018092,7.685848,68.311606>,<29.132670,1.996479,68.311599>}
      triangle {<0.015864,11.821049,173.855963>,<29.132670,1.996479,68.311599>,<29.132670,6.005047,160.804332>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,6.164196,158.898986>,<27.882761,2.274616,69.660987>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,2.274616,69.660987>,<0.016413,7.865704,69.721625>}
      triangle {<0.016413,11.800510,171.040030>,<0.016413,5.471149,171.040040>,<27.882761,-1.487278,158.898980>}
      triangle {<0.016413,11.800510,171.040030>,<27.882761,-1.487278,158.898980>,<27.882761,6.164196,158.898986>}
      triangle {<27.882761,6.164196,158.898986>,<27.882761,-1.487278,158.898980>,<27.882761,-3.323994,69.660979>}
      triangle {<27.882761,6.164196,158.898986>,<27.882761,-3.323994,69.660979>,<27.882761,2.274616,69.660987>}
      triangle {<27.882761,2.274616,69.660987>,<27.882761,-3.323994,69.660979>,<0.016413,1.587749,69.718223>}
      triangle {<27.882761,2.274616,69.660987>,<0.016413,1.587749,69.718223>,<0.016413,7.865704,69.721625>}
      triangle {<0.016413,7.865704,69.721625>,<0.016413,1.587749,69.718223>,<0.016413,5.471149,171.040040>}
      triangle {<0.016413,7.865704,69.721625>,<0.016413,5.471149,171.040040>,<0.016413,11.800510,171.040030>}
      triangle {<0.016413,5.471149,171.040040>,<0.016413,1.587749,69.718223>,<27.882761,-3.323994,69.660979>}
      triangle {<0.016413,5.471149,171.040040>,<27.882761,-3.323994,69.660979>,<27.882761,-1.487278,158.898980>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,0.352322,162.834728>,<38.820963,-4.992420,39.511146>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,-4.992420,39.511146>,<0.001513,2.593410,39.511146>}
      triangle {<-0.001440,8.106991,180.237010>,<-0.001440,7.664944,180.237010>,<38.820963,-0.089725,162.834728>}
      triangle {<-0.001440,8.106991,180.237010>,<38.820963,-0.089725,162.834728>,<38.820963,0.352322,162.834728>}
      triangle {<38.820963,0.352322,162.834728>,<38.820963,-0.089725,162.834728>,<38.820963,-5.434467,39.511146>}
      triangle {<38.820963,0.352322,162.834728>,<38.820963,-5.434467,39.511146>,<38.820963,-4.992420,39.511146>}
      triangle {<38.820963,-4.992420,39.511146>,<38.820963,-5.434467,39.511146>,<0.001521,2.151363,39.511146>}
      triangle {<38.820963,-4.992420,39.511146>,<0.001521,2.151363,39.511146>,<0.001513,2.593410,39.511146>}
      triangle {<0.001513,2.593410,39.511146>,<0.001521,2.151363,39.511146>,<-0.001440,7.664944,180.237010>}
      triangle {<0.001513,2.593410,39.511146>,<-0.001440,7.664944,180.237010>,<-0.001440,8.106991,180.237010>}
      triangle {<-0.001440,7.664944,180.237010>,<0.001521,2.151363,39.511146>,<38.820963,-5.434467,39.511146>}
      triangle {<-0.001440,7.664944,180.237010>,<38.820963,-5.434467,39.511146>,<38.820963,-0.089725,162.834728>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,0.122471,160.294267>,<37.154421,-5.063618,41.310325>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,-5.063618,41.310325>,<-0.000715,2.391163,41.391166>}
      triangle {<-0.000715,7.637562,176.482295>,<-0.000715,-0.801594,176.482305>,<37.154421,-10.079494,160.294227>}
      triangle {<-0.000715,7.637562,176.482295>,<37.154421,-10.079494,160.294227>,<37.154421,0.122471,160.294267>}
      triangle {<37.154421,0.122471,160.294267>,<37.154421,-10.079494,160.294227>,<37.154421,-12.528423,41.310325>}
      triangle {<37.154421,0.122471,160.294267>,<37.154421,-12.528423,41.310325>,<37.154421,-5.063618,41.310325>}
      triangle {<37.154421,-5.063618,41.310325>,<37.154421,-12.528423,41.310325>,<-0.000715,-5.979435,41.386634>}
      triangle {<37.154421,-5.063618,41.310325>,<-0.000715,-5.979435,41.386634>,<-0.000715,2.391163,41.391166>}
      triangle {<-0.000715,2.391163,41.391166>,<-0.000715,-5.979435,41.386634>,<-0.000715,-0.801594,176.482305>}
      triangle {<-0.000715,2.391163,41.391166>,<-0.000715,-0.801594,176.482305>,<-0.000715,7.637562,176.482295>}
      triangle {<-0.000715,-0.801594,176.482305>,<-0.000715,-5.979435,41.386634>,<37.154421,-12.528423,41.310325>}
      triangle {<-0.000715,-0.801594,176.482305>,<37.154421,-12.528423,41.310325>,<37.154421,-10.079494,160.294227>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-4.712002,152.221629>,<47.437205,-8.720562,59.728873>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-8.720562,59.728873>,<18.322627,-3.031193,59.728873>}
      triangle {<18.320406,1.104008,165.273261>,<18.320406,0.772480,165.273261>,<47.437205,-5.043537,152.221629>}
      triangle {<18.320406,1.104008,165.273261>,<47.437205,-5.043537,152.221629>,<47.437205,-4.712002,152.221629>}
      triangle {<47.437205,-4.712002,152.221629>,<47.437205,-5.043537,152.221629>,<47.437205,-9.052097,59.728873>}
      triangle {<47.437205,-4.712002,152.221629>,<47.437205,-9.052097,59.728873>,<47.437205,-8.720562,59.728873>}
      triangle {<47.437205,-8.720562,59.728873>,<47.437205,-9.052097,59.728873>,<18.322634,-3.362728,59.728873>}
      triangle {<47.437205,-8.720562,59.728873>,<18.322634,-3.362728,59.728873>,<18.322627,-3.031193,59.728873>}
      triangle {<18.322627,-3.031193,59.728873>,<18.322634,-3.362728,59.728873>,<18.320406,0.772480,165.273261>}
      triangle {<18.322627,-3.031193,59.728873>,<18.320406,0.772480,165.273261>,<18.320406,1.104008,165.273261>}
      triangle {<18.320406,0.772480,165.273261>,<18.322634,-3.362728,59.728873>,<47.437205,-9.052097,59.728873>}
      triangle {<18.320406,0.772480,165.273261>,<47.437205,-9.052097,59.728873>,<47.437205,-5.043537,152.221629>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-4.884388,150.316279>,<46.187296,-8.773960,61.078254>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-8.773960,61.078254>,<18.320956,-3.182873,61.138892>}
      triangle {<18.320956,0.751942,162.457329>,<18.320956,-5.577427,162.457337>,<46.187296,-12.535862,150.316281>}
      triangle {<18.320956,0.751942,162.457329>,<46.187296,-12.535862,150.316281>,<46.187296,-4.884388,150.316279>}
      triangle {<46.187296,-4.884388,150.316279>,<46.187296,-12.535862,150.316281>,<46.187296,-14.372570,61.077964>}
      triangle {<46.187296,-4.884388,150.316279>,<46.187296,-14.372570,61.077964>,<46.187296,-8.773960,61.078254>}
      triangle {<46.187296,-8.773960,61.078254>,<46.187296,-14.372570,61.077964>,<18.320956,-9.460827,61.135489>}
      triangle {<46.187296,-8.773960,61.078254>,<18.320956,-9.460827,61.135489>,<18.320956,-3.182873,61.138892>}
      triangle {<18.320956,-3.182873,61.138892>,<18.320956,-9.460827,61.135489>,<18.320956,-5.577427,162.457337>}
      triangle {<18.320956,-3.182873,61.138892>,<18.320956,-5.577427,162.457337>,<18.320956,0.751942,162.457329>}
      triangle {<18.320956,-5.577427,162.457337>,<18.320956,-9.460827,61.135489>,<46.187296,-14.372570,61.077964>}
      triangle {<18.320956,-5.577427,162.457337>,<46.187296,-14.372570,61.077964>,<46.187296,-12.535862,150.316281>}
      triangle {<34.801623,-7.132145,130.862666>,<34.801623,-9.520870,20.179862>,<-0.041486,-3.575008,4.560859>}
      triangle {<-0.038831,-0.323864,130.862662>,<34.801623,-7.132145,130.862666>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-9.917606,20.179862>,<-0.041486,-3.971745,4.560859>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-9.520870,20.179862>,<34.801623,-9.917606,20.179862>,<-0.041486,-3.575008,4.560859>}
      triangle {<34.801623,-7.528881,130.862666>,<34.801623,-9.917606,20.179862>,<34.801623,-9.520870,20.179862>}
      triangle {<34.801623,-7.132145,130.862666>,<34.801623,-7.528881,130.862666>,<34.801623,-9.520870,20.179862>}
      triangle {<-0.038831,-0.720600,130.862662>,<34.801623,-7.528881,130.862666>,<34.801623,-7.132145,130.862666>}
      triangle {<-0.038831,-0.323864,130.862662>,<-0.038831,-0.720600,130.862662>,<34.801623,-7.132145,130.862666>}
      triangle {<-0.041486,-3.971745,4.560859>,<-0.038831,-0.720600,130.862662>,<-0.038831,-0.323864,130.862662>}
      triangle {<-0.041486,-3.575008,4.560859>,<-0.041486,-3.971745,4.560859>,<-0.038831,-0.323864,130.862662>}
      triangle {<34.801623,-7.528881,130.862666>,<-0.038831,-0.720600,130.862662>,<-0.041486,-3.971745,4.560859>}
      triangle {<34.801623,-9.917606,20.179862>,<34.801623,-7.528881,130.862666>,<-0.041486,-3.971745,4.560859>}
      triangle {<33.305903,-7.300861,129.247905>,<33.305903,-9.579136,22.459937>,<-0.040838,-3.777554,7.930594>}
      triangle {<-0.040838,-0.614918,129.175330>,<33.305903,-7.300861,129.247905>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-18.735401,22.459373>,<-0.040838,-11.351696,7.931144>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-9.579136,22.459937>,<33.305903,-18.735401,22.459373>,<-0.040838,-3.777554,7.930594>}
      triangle {<33.305903,-14.000530,129.247905>,<33.305903,-18.735401,22.459373>,<33.305903,-9.579136,22.459937>}
      triangle {<33.305903,-7.300861,129.247905>,<33.305903,-14.000530,129.247905>,<33.305903,-9.579136,22.459937>}
      triangle {<-0.040838,-8.127254,129.179423>,<33.305903,-14.000530,129.247905>,<33.305903,-7.300861,129.247905>}
      triangle {<-0.040838,-0.614918,129.175330>,<-0.040838,-8.127254,129.179423>,<33.305903,-7.300861,129.247905>}
      triangle {<-0.040838,-11.351696,7.931144>,<-0.040838,-8.127254,129.179423>,<-0.040838,-0.614918,129.175330>}
      triangle {<-0.040838,-3.777554,7.930594>,<-0.040838,-11.351696,7.931144>,<-0.040838,-0.614918,129.175330>}
      triangle {<33.305903,-14.000530,129.247905>,<-0.040838,-8.127254,129.179423>,<-0.040838,-11.351696,7.931144>}
      triangle {<33.305903,-18.735401,22.459373>,<33.305903,-14.000530,129.247905>,<-0.040838,-11.351696,7.931144>}
      triangle {<-25.835157,0.380840,46.651084>,<-25.835157,2.931889,105.513358>,<0.708964,8.269398,113.819419>}
      triangle {<0.706942,5.637630,46.651084>,<-25.835157,0.380840,46.651084>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,2.720898,105.513358>,<0.708964,8.058414,113.819415>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,2.931889,105.513358>,<-25.835157,2.720898,105.513358>,<0.708964,8.269398,113.819419>}
      triangle {<-25.835157,0.169849,46.651084>,<-25.835157,2.720898,105.513358>,<-25.835157,2.931889,105.513358>}
      triangle {<-25.835157,0.380840,46.651084>,<-25.835157,0.169849,46.651084>,<-25.835157,2.931889,105.513358>}
      triangle {<0.706934,5.426640,46.651084>,<-25.835157,0.169849,46.651084>,<-25.835157,0.380840,46.651084>}
      triangle {<0.706942,5.637630,46.651084>,<0.706934,5.426640,46.651084>,<-25.835157,0.380840,46.651084>}
      triangle {<0.708964,8.058414,113.819415>,<0.706934,5.426640,46.651084>,<0.706942,5.637630,46.651084>}
      triangle {<0.708964,8.269398,113.819419>,<0.708964,8.058414,113.819415>,<0.706942,5.637630,46.651084>}
      triangle {<-25.835157,0.169849,46.651084>,<0.706934,5.426640,46.651084>,<0.708964,8.058414,113.819415>}
      triangle {<-25.835157,2.720898,105.513358>,<-25.835157,0.169849,46.651084>,<0.708964,8.058414,113.819415>}
      triangle {<-24.695692,0.417095,47.509849>,<-24.695692,2.892422,104.300788>,<0.708460,8.045307,112.027350>}
      triangle {<0.708460,5.541195,47.548423>,<-24.695692,0.417095,47.509849>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,-1.976978,104.300788>,<0.708460,4.017292,112.027366>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,2.892422,104.300788>,<-24.695692,-1.976978,104.300788>,<0.708460,8.045307,112.027350>}
      triangle {<-24.695692,-3.145863,47.509849>,<-24.695692,-1.976978,104.300788>,<-24.695692,2.892422,104.300788>}
      triangle {<-24.695692,0.417095,47.509849>,<-24.695692,-3.145863,47.509849>,<-24.695692,2.892422,104.300788>}
      triangle {<0.708460,1.545902,47.546256>,<-24.695692,-3.145863,47.509849>,<-24.695692,0.417095,47.509849>}
      triangle {<0.708460,5.541195,47.548423>,<0.708460,1.545902,47.546256>,<-24.695692,0.417095,47.509849>}
      triangle {<0.708460,4.017292,112.027366>,<0.708460,1.545902,47.546256>,<0.708460,5.541195,47.548423>}
      triangle {<0.708460,8.045307,112.027350>,<0.708460,4.017292,112.027366>,<0.708460,5.541195,47.548423>}
      triangle {<-24.695692,-3.145863,47.509849>,<0.708460,1.545902,47.546256>,<0.708460,4.017292,112.027366>}
      triangle {<-24.695692,-1.976978,104.300788>,<-24.695692,-3.145863,47.509849>,<0.708460,4.017292,112.027366>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,2.931889,105.513358>,<26.610354,0.380840,46.651084>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,0.380840,46.651084>,<0.068255,5.637630,46.651084>}
      triangle {<0.066233,8.269398,113.819419>,<0.066233,8.058414,113.819415>,<26.610354,2.720898,105.513358>}
      triangle {<0.066233,8.269398,113.819419>,<26.610354,2.720898,105.513358>,<26.610354,2.931889,105.513358>}
      triangle {<26.610354,2.931889,105.513358>,<26.610354,2.720898,105.513358>,<26.610354,0.169849,46.651084>}
      triangle {<26.610354,2.931889,105.513358>,<26.610354,0.169849,46.651084>,<26.610354,0.380840,46.651084>}
      triangle {<26.610354,0.380840,46.651084>,<26.610354,0.169849,46.651084>,<0.068263,5.426640,46.651084>}
      triangle {<26.610354,0.380840,46.651084>,<0.068263,5.426640,46.651084>,<0.068255,5.637630,46.651084>}
      triangle {<0.068255,5.637630,46.651084>,<0.068263,5.426640,46.651084>,<0.066233,8.058414,113.819415>}
      triangle {<0.068255,5.637630,46.651084>,<0.066233,8.058414,113.819415>,<0.066233,8.269398,113.819419>}
      triangle {<0.066233,8.058414,113.819415>,<0.068263,5.426640,46.651084>,<26.610354,0.169849,46.651084>}
      triangle {<0.066233,8.058414,113.819415>,<26.610354,0.169849,46.651084>,<26.610354,2.720898,105.513358>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,2.892422,104.300788>,<25.470889,0.417095,47.509849>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,0.417095,47.509849>,<0.066737,5.541195,47.548423>}
      triangle {<0.066737,8.045307,112.027350>,<0.066737,4.017292,112.027366>,<25.470889,-1.976978,104.300788>}
      triangle {<0.066737,8.045307,112.027350>,<25.470889,-1.976978,104.300788>,<25.470889,2.892422,104.300788>}
      triangle {<25.470889,2.892422,104.300788>,<25.470889,-1.976978,104.300788>,<25.470889,-3.145863,47.509849>}
      triangle {<25.470889,2.892422,104.300788>,<25.470889,-3.145863,47.509849>,<25.470889,0.417095,47.509849>}
      triangle {<25.470889,0.417095,47.509849>,<25.470889,-3.145863,47.509849>,<0.066737,1.545902,47.546256>}
      triangle {<25.470889,0.417095,47.509849>,<0.066737,1.545902,47.546256>,<0.066737,5.541195,47.548423>}
      triangle {<0.066737,5.541195,47.548423>,<0.066737,1.545902,47.546256>,<0.066737,4.017292,112.027366>}
      triangle {<0.066737,5.541195,47.548423>,<0.066737,4.017292,112.027366>,<0.066737,8.045307,112.027350>}
      triangle {<0.066737,4.017292,112.027366>,<0.066737,1.545902,47.546256>,<25.470889,-3.145863,47.509849>}
      triangle {<0.066737,4.017292,112.027366>,<25.470889,-3.145863,47.509849>,<25.470889,-1.976978,104.300788>}
    scale<1.001,1,1>translate<0,-0.1,-0.1>  texture{_Aufbau02}
    }
    //_Zeug02
    mesh{
      triangle {<94.561045,-26.206982,146.127053>,<2.093073,-26.206982,-181.739434>,<2.093073,-19.584820,-181.739434>}
      triangle {<94.561045,-26.206982,146.127053>,<2.093073,-19.584820,-181.739434>,<94.561045,-19.584820,146.127053>}
      triangle {<94.561045,-26.206982,146.127053>,<92.558054,-26.206982,146.691939>,<0.090052,-26.206982,-181.174523>}
      triangle {<94.561045,-26.206982,146.127053>,<0.090052,-26.206982,-181.174523>,<2.093073,-26.206982,-181.739434>}
      triangle {<2.093073,-26.206982,-181.739434>,<0.090052,-26.206982,-181.174523>,<0.090052,-19.584820,-181.174523>}
      triangle {<2.093073,-26.206982,-181.739434>,<0.090052,-19.584820,-181.174523>,<2.093073,-19.584820,-181.739434>}
      triangle {<2.093073,-19.584820,-181.739434>,<0.090052,-19.584820,-181.174523>,<92.558054,-19.584820,146.691939>}
      triangle {<2.093073,-19.584820,-181.739434>,<92.558054,-19.584820,146.691939>,<94.561045,-19.584820,146.127053>}
      triangle {<94.561045,-19.584820,146.127053>,<92.558054,-19.584820,146.691939>,<92.558054,-26.206982,146.691939>}
      triangle {<94.561045,-19.584820,146.127053>,<92.558054,-26.206982,146.691939>,<94.561045,-26.206982,146.127053>}
      triangle {<92.558054,-26.206982,146.691939>,<92.558054,-19.584820,146.691939>,<0.090052,-19.584820,-181.174523>}
      triangle {<92.558054,-26.206982,146.691939>,<0.090052,-19.584820,-181.174523>,<0.090052,-26.206982,-181.174523>}
      triangle {<31.526522,-25.470264,-85.861016>,<29.416483,-25.470264,-93.342645>,<29.416483,-20.321529,-93.342645>}
      triangle {<31.526522,-25.470264,-85.861016>,<29.416483,-20.321529,-93.342645>,<31.526522,-20.321529,-85.861016>}
      triangle {<31.526522,-25.470264,-85.861016>,<29.523509,-25.470264,-85.296136>,<27.413493,-25.470264,-92.777703>}
      triangle {<31.526522,-25.470264,-85.861016>,<27.413493,-25.470264,-92.777703>,<29.416483,-25.470264,-93.342645>}
      triangle {<29.416483,-25.470264,-93.342645>,<27.413493,-25.470264,-92.777703>,<27.413493,-20.321529,-92.777703>}
      triangle {<29.416483,-25.470264,-93.342645>,<27.413493,-20.321529,-92.777703>,<29.416483,-20.321529,-93.342645>}
      triangle {<29.416483,-20.321529,-93.342645>,<27.413493,-20.321529,-92.777703>,<29.523509,-20.321529,-85.296136>}
      triangle {<29.416483,-20.321529,-93.342645>,<29.523509,-20.321529,-85.296136>,<31.526522,-20.321529,-85.861016>}
      triangle {<31.526522,-20.321529,-85.861016>,<29.523509,-20.321529,-85.296136>,<29.523509,-25.470264,-85.296136>}
      triangle {<31.526522,-20.321529,-85.861016>,<29.523509,-25.470264,-85.296136>,<31.526522,-25.470264,-85.861016>}
      triangle {<29.523509,-25.470264,-85.296136>,<29.523509,-20.321529,-85.296136>,<27.413493,-20.321529,-92.777703>}
      triangle {<29.523509,-25.470264,-85.296136>,<27.413493,-20.321529,-92.777703>,<27.413493,-25.470264,-92.777703>}
      triangle {<19.475016,-25.561321,-128.592431>,<18.300471,-25.561321,-132.757012>,<18.300471,-20.230480,-132.757012>}
      triangle {<19.475016,-25.561321,-128.592431>,<18.300471,-20.230480,-132.757012>,<19.475016,-20.230480,-128.592431>}
      triangle {<19.475016,-25.561321,-128.592431>,<17.472025,-25.561321,-128.027551>,<16.297480,-25.561321,-132.192132>}
      triangle {<19.475016,-25.561321,-128.592431>,<16.297480,-25.561321,-132.192132>,<18.300471,-25.561321,-132.757012>}
      triangle {<18.300471,-25.561321,-132.757012>,<16.297480,-25.561321,-132.192132>,<16.297480,-20.230480,-132.192132>}
      triangle {<18.300471,-25.561321,-132.757012>,<16.297480,-20.230480,-132.192132>,<18.300471,-20.230480,-132.757012>}
      triangle {<18.300471,-20.230480,-132.757012>,<16.297480,-20.230480,-132.192132>,<17.472025,-20.230480,-128.027551>}
      triangle {<18.300471,-20.230480,-132.757012>,<17.472025,-20.230480,-128.027551>,<19.475016,-20.230480,-128.592431>}
      triangle {<19.475016,-20.230480,-128.592431>,<17.472025,-20.230480,-128.027551>,<17.472025,-25.561321,-128.027551>}
      triangle {<19.475016,-20.230480,-128.592431>,<17.472025,-25.561321,-128.027551>,<19.475016,-25.561321,-128.592431>}
      triangle {<17.472025,-25.561321,-128.027551>,<17.472025,-20.230480,-128.027551>,<16.297480,-20.230480,-132.192132>}
      triangle {<17.472025,-25.561321,-128.027551>,<16.297480,-20.230480,-132.192132>,<16.297480,-25.561321,-132.192132>}
      triangle {<20.200793,-26.206982,-121.396691>,<18.059580,-26.206982,-128.988854>,<18.059580,-19.584820,-128.988854>}
      triangle {<20.200793,-26.206982,-121.396691>,<18.059580,-19.584820,-128.988854>,<20.200793,-19.584820,-121.396691>}
      triangle {<20.200793,-26.206982,-121.396691>,<19.314456,-26.206982,-121.146630>,<17.173228,-26.206982,-128.738885>}
      triangle {<20.200793,-26.206982,-121.396691>,<17.173228,-26.206982,-128.738885>,<18.059580,-26.206982,-128.988854>}
      triangle {<18.059580,-26.206982,-128.988854>,<17.173228,-26.206982,-128.738885>,<17.173228,-19.584820,-128.738885>}
      triangle {<18.059580,-26.206982,-128.988854>,<17.173228,-19.584820,-128.738885>,<18.059580,-19.584820,-128.988854>}
      triangle {<18.059580,-19.584820,-128.988854>,<17.173228,-19.584820,-128.738885>,<19.314456,-19.584820,-121.146630>}
      triangle {<18.059580,-19.584820,-128.988854>,<19.314456,-19.584820,-121.146630>,<20.200793,-19.584820,-121.396691>}
      triangle {<20.200793,-19.584820,-121.396691>,<19.314456,-19.584820,-121.146630>,<19.314456,-26.206982,-121.146630>}
      triangle {<20.200793,-19.584820,-121.396691>,<19.314456,-26.206982,-121.146630>,<20.200793,-26.206982,-121.396691>}
      triangle {<19.314456,-26.206982,-121.146630>,<19.314456,-19.584820,-121.146630>,<17.173228,-19.584820,-128.738885>}
      triangle {<19.314456,-26.206982,-121.146630>,<17.173228,-19.584820,-128.738885>,<17.173228,-26.206982,-128.738885>}
      triangle {<22.673846,-24.551434,-117.250237>,<20.594973,-24.551434,-124.621362>,<20.594973,-21.240353,-124.621362>}
      triangle {<22.673846,-24.551434,-117.250237>,<20.594973,-21.240353,-124.621362>,<22.673846,-21.240353,-117.250237>}
      triangle {<22.673846,-24.551434,-117.250237>,<20.670855,-24.551434,-116.685357>,<18.591975,-24.551434,-124.056481>}
      triangle {<22.673846,-24.551434,-117.250237>,<18.591975,-24.551434,-124.056481>,<20.594973,-24.551434,-124.621362>}
      triangle {<20.594973,-24.551434,-124.621362>,<18.591975,-24.551434,-124.056481>,<18.591975,-21.240353,-124.056481>}
      triangle {<20.594973,-24.551434,-124.621362>,<18.591975,-21.240353,-124.056481>,<20.594973,-21.240353,-124.621362>}
      triangle {<20.594973,-21.240353,-124.621362>,<18.591975,-21.240353,-124.056481>,<20.670855,-21.240353,-116.685357>}
      triangle {<20.594973,-21.240353,-124.621362>,<20.670855,-21.240353,-116.685357>,<22.673846,-21.240353,-117.250237>}
      triangle {<22.673846,-21.240353,-117.250237>,<20.670855,-21.240353,-116.685357>,<20.670855,-24.551434,-116.685357>}
      triangle {<22.673846,-21.240353,-117.250237>,<20.670855,-24.551434,-116.685357>,<22.673846,-24.551434,-117.250237>}
      triangle {<20.670855,-24.551434,-116.685357>,<20.670855,-21.240353,-116.685357>,<18.591975,-21.240353,-124.056481>}
      triangle {<20.670855,-24.551434,-116.685357>,<18.591975,-21.240353,-124.056481>,<18.591975,-24.551434,-124.056481>}
      triangle {<24.380488,-26.206982,-106.576531>,<22.239230,-26.206982,-114.168847>,<22.239230,-19.584820,-114.168847>}
      triangle {<24.380488,-26.206982,-106.576531>,<22.239230,-19.584820,-114.168847>,<24.380488,-19.584820,-106.576531>}
      triangle {<24.380488,-26.206982,-106.576531>,<23.494158,-26.206982,-106.326562>,<21.352908,-26.206982,-113.918817>}
      triangle {<24.380488,-26.206982,-106.576531>,<21.352908,-26.206982,-113.918817>,<22.239230,-26.206982,-114.168847>}
      triangle {<22.239230,-26.206982,-114.168847>,<21.352908,-26.206982,-113.918817>,<21.352908,-19.584820,-113.918817>}
      triangle {<22.239230,-26.206982,-114.168847>,<21.352908,-19.584820,-113.918817>,<22.239230,-19.584820,-114.168847>}
      triangle {<22.239230,-19.584820,-114.168847>,<21.352908,-19.584820,-113.918817>,<23.494158,-19.584820,-106.326562>}
      triangle {<22.239230,-19.584820,-114.168847>,<23.494158,-19.584820,-106.326562>,<24.380488,-19.584820,-106.576531>}
      triangle {<24.380488,-19.584820,-106.576531>,<23.494158,-19.584820,-106.326562>,<23.494158,-26.206982,-106.326562>}
      triangle {<24.380488,-19.584820,-106.576531>,<23.494158,-26.206982,-106.326562>,<24.380488,-26.206982,-106.576531>}
      triangle {<23.494158,-26.206982,-106.326562>,<23.494158,-19.584820,-106.326562>,<21.352908,-19.584820,-113.918817>}
      triangle {<23.494158,-26.206982,-106.326562>,<21.352908,-19.584820,-113.918817>,<21.352908,-26.206982,-113.918817>}
      triangle {<28.499651,-24.385891,-96.593560>,<24.341906,-24.385891,-111.335778>,<24.341906,-21.405910,-111.335778>}
      triangle {<28.499651,-24.385891,-96.593560>,<24.341906,-21.405910,-111.335778>,<28.499651,-21.405910,-96.593560>}
      triangle {<28.499651,-24.385891,-96.593560>,<26.496645,-24.385891,-96.028588>,<22.338885,-24.385891,-110.770867>}
      triangle {<28.499651,-24.385891,-96.593560>,<22.338885,-24.385891,-110.770867>,<24.341906,-24.385891,-111.335778>}
      triangle {<24.341906,-24.385891,-111.335778>,<22.338885,-24.385891,-110.770867>,<22.338885,-21.405910,-110.770867>}
      triangle {<24.341906,-24.385891,-111.335778>,<22.338885,-21.405910,-110.770867>,<24.341906,-21.405910,-111.335778>}
      triangle {<24.341906,-21.405910,-111.335778>,<22.338885,-21.405910,-110.770867>,<26.496645,-21.405910,-96.028588>}
      triangle {<24.341906,-21.405910,-111.335778>,<26.496645,-21.405910,-96.028588>,<28.499651,-21.405910,-96.593560>}
      triangle {<28.499651,-21.405910,-96.593560>,<26.496645,-21.405910,-96.028588>,<26.496645,-24.385891,-96.028588>}
      triangle {<28.499651,-21.405910,-96.593560>,<26.496645,-24.385891,-96.028588>,<28.499651,-24.385891,-96.593560>}
      triangle {<26.496645,-24.385891,-96.028588>,<26.496645,-21.405910,-96.028588>,<22.338885,-21.405910,-110.770867>}
      triangle {<26.496645,-24.385891,-96.028588>,<22.338885,-21.405910,-110.770867>,<22.338885,-24.385891,-110.770867>}
      triangle {<28.201937,-26.206982,-93.026727>,<26.060725,-26.206982,-100.618890>,<26.060725,-19.584820,-100.618890>}
      triangle {<28.201937,-26.206982,-93.026727>,<26.060725,-19.584820,-100.618890>,<28.201937,-19.584820,-93.026727>}
      triangle {<28.201937,-26.206982,-93.026727>,<27.315600,-26.206982,-92.776727>,<25.174372,-26.206982,-100.368981>}
      triangle {<28.201937,-26.206982,-93.026727>,<25.174372,-26.206982,-100.368981>,<26.060725,-26.206982,-100.618890>}
      triangle {<26.060725,-26.206982,-100.618890>,<25.174372,-26.206982,-100.368981>,<25.174372,-19.584820,-100.368981>}
      triangle {<26.060725,-26.206982,-100.618890>,<25.174372,-19.584820,-100.368981>,<26.060725,-19.584820,-100.618890>}
      triangle {<26.060725,-19.584820,-100.618890>,<25.174372,-19.584820,-100.368981>,<27.315600,-19.584820,-92.776727>}
      triangle {<26.060725,-19.584820,-100.618890>,<27.315600,-19.584820,-92.776727>,<28.201937,-19.584820,-93.026727>}
      triangle {<28.201937,-19.584820,-93.026727>,<27.315600,-19.584820,-92.776727>,<27.315600,-26.206982,-92.776727>}
      triangle {<28.201937,-19.584820,-93.026727>,<27.315600,-26.206982,-92.776727>,<28.201937,-26.206982,-93.026727>}
      triangle {<27.315600,-26.206982,-92.776727>,<27.315600,-19.584820,-92.776727>,<25.174372,-19.584820,-100.368981>}
      triangle {<27.315600,-26.206982,-92.776727>,<25.174372,-19.584820,-100.368981>,<25.174372,-26.206982,-100.368981>}
      triangle {<17.554377,-25.470264,-135.402551>,<15.444308,-25.470264,-142.884179>,<15.444308,-20.321529,-142.884179>}
      triangle {<17.554377,-25.470264,-135.402551>,<15.444308,-20.321529,-142.884179>,<17.554377,-20.321529,-135.402551>}
      triangle {<17.554377,-25.470264,-135.402551>,<15.551356,-25.470264,-134.837640>,<13.441332,-25.470264,-142.319329>}
      triangle {<17.554377,-25.470264,-135.402551>,<13.441332,-25.470264,-142.319329>,<15.444308,-25.470264,-142.884179>}
      triangle {<15.444308,-25.470264,-142.884179>,<13.441332,-25.470264,-142.319329>,<13.441332,-20.321529,-142.319329>}
      triangle {<15.444308,-25.470264,-142.884179>,<13.441332,-20.321529,-142.319329>,<15.444308,-20.321529,-142.884179>}
      triangle {<15.444308,-20.321529,-142.884179>,<13.441332,-20.321529,-142.319329>,<15.551356,-20.321529,-134.837640>}
      triangle {<15.444308,-20.321529,-142.884179>,<15.551356,-20.321529,-134.837640>,<17.554377,-20.321529,-135.402551>}
      triangle {<17.554377,-20.321529,-135.402551>,<15.551356,-20.321529,-134.837640>,<15.551356,-25.470264,-134.837640>}
      triangle {<17.554377,-20.321529,-135.402551>,<15.551356,-25.470264,-134.837640>,<17.554377,-25.470264,-135.402551>}
      triangle {<15.551356,-25.470264,-134.837640>,<15.551356,-20.321529,-134.837640>,<13.441332,-20.321529,-142.319329>}
      triangle {<15.551356,-25.470264,-134.837640>,<13.441332,-20.321529,-142.319329>,<13.441332,-25.470264,-142.319329>}
      triangle {<5.502894,-25.561321,-178.133843>,<4.328318,-25.561321,-182.298608>,<4.328318,-20.230480,-182.298608>}
      triangle {<5.502894,-25.561321,-178.133843>,<4.328318,-20.230480,-182.298608>,<5.502894,-20.230480,-178.133843>}
      triangle {<5.502894,-25.561321,-178.133843>,<3.499865,-25.561321,-177.568963>,<2.325305,-25.561321,-181.733666>}
      triangle {<5.502894,-25.561321,-178.133843>,<2.325305,-25.561321,-181.733666>,<4.328318,-25.561321,-182.298608>}
      triangle {<4.328318,-25.561321,-182.298608>,<2.325305,-25.561321,-181.733666>,<2.325305,-20.230480,-181.733666>}
      triangle {<4.328318,-25.561321,-182.298608>,<2.325305,-20.230480,-181.733666>,<4.328318,-20.230480,-182.298608>}
      triangle {<4.328318,-20.230480,-182.298608>,<2.325305,-20.230480,-181.733666>,<3.499865,-20.230480,-177.568963>}
      triangle {<4.328318,-20.230480,-182.298608>,<3.499865,-20.230480,-177.568963>,<5.502894,-20.230480,-178.133843>}
      triangle {<5.502894,-20.230480,-178.133843>,<3.499865,-20.230480,-177.568963>,<3.499865,-25.561321,-177.568963>}
      triangle {<5.502894,-20.230480,-178.133843>,<3.499865,-25.561321,-177.568963>,<5.502894,-25.561321,-178.133843>}
      triangle {<3.499865,-25.561321,-177.568963>,<3.499865,-20.230480,-177.568963>,<2.325305,-20.230480,-181.733666>}
      triangle {<3.499865,-25.561321,-177.568963>,<2.325305,-20.230480,-181.733666>,<2.325305,-25.561321,-181.733666>}
      triangle {<6.228632,-26.206982,-170.938165>,<4.087428,-26.206982,-178.530389>,<4.087428,-19.584820,-178.530389>}
      triangle {<6.228632,-26.206982,-170.938165>,<4.087428,-19.584820,-178.530389>,<6.228632,-19.584820,-170.938165>}
      triangle {<6.228632,-26.206982,-170.938165>,<5.342303,-26.206982,-170.688226>,<3.201106,-26.206982,-178.280419>}
      triangle {<6.228632,-26.206982,-170.938165>,<3.201106,-26.206982,-178.280419>,<4.087428,-26.206982,-178.530389>}
      triangle {<4.087428,-26.206982,-178.530389>,<3.201106,-26.206982,-178.280419>,<3.201106,-19.584820,-178.280419>}
      triangle {<4.087428,-26.206982,-178.530389>,<3.201106,-19.584820,-178.280419>,<4.087428,-19.584820,-178.530389>}
      triangle {<4.087428,-19.584820,-178.530389>,<3.201106,-19.584820,-178.280419>,<5.342303,-19.584820,-170.688226>}
      triangle {<4.087428,-19.584820,-178.530389>,<5.342303,-19.584820,-170.688226>,<6.228632,-19.584820,-170.938165>}
      triangle {<6.228632,-19.584820,-170.938165>,<5.342303,-19.584820,-170.688226>,<5.342303,-26.206982,-170.688226>}
      triangle {<6.228632,-19.584820,-170.938165>,<5.342303,-26.206982,-170.688226>,<6.228632,-26.206982,-170.938165>}
      triangle {<5.342303,-26.206982,-170.688226>,<5.342303,-19.584820,-170.688226>,<3.201106,-19.584820,-178.280419>}
      triangle {<5.342303,-26.206982,-170.688226>,<3.201106,-19.584820,-178.280419>,<3.201106,-26.206982,-178.280419>}
      triangle {<8.701693,-24.551434,-166.791711>,<6.622836,-24.551434,-174.162835>,<6.622836,-21.240353,-174.162835>}
      triangle {<8.701693,-24.551434,-166.791711>,<6.622836,-21.240353,-174.162835>,<8.701693,-21.240353,-166.791711>}
      triangle {<8.701693,-24.551434,-166.791711>,<6.698710,-24.551434,-166.226830>,<4.619853,-24.551434,-173.597985>}
      triangle {<8.701693,-24.551434,-166.791711>,<4.619853,-24.551434,-173.597985>,<6.622836,-24.551434,-174.162835>}
      triangle {<6.622836,-24.551434,-174.162835>,<4.619853,-24.551434,-173.597985>,<4.619853,-21.240353,-173.597985>}
      triangle {<6.622836,-24.551434,-174.162835>,<4.619853,-21.240353,-173.597985>,<6.622836,-21.240353,-174.162835>}
      triangle {<6.622836,-21.240353,-174.162835>,<4.619853,-21.240353,-173.597985>,<6.698710,-21.240353,-166.226830>}
      triangle {<6.622836,-21.240353,-174.162835>,<6.698710,-21.240353,-166.226830>,<8.701693,-21.240353,-166.791711>}
      triangle {<8.701693,-21.240353,-166.791711>,<6.698710,-21.240353,-166.226830>,<6.698710,-24.551434,-166.226830>}
      triangle {<8.701693,-21.240353,-166.791711>,<6.698710,-24.551434,-166.226830>,<8.701693,-24.551434,-166.791711>}
      triangle {<6.698710,-24.551434,-166.226830>,<6.698710,-21.240353,-166.226830>,<4.619853,-21.240353,-173.597985>}
      triangle {<6.698710,-24.551434,-166.226830>,<4.619853,-21.240353,-173.597985>,<4.619853,-24.551434,-173.597985>}
      triangle {<10.408343,-26.206982,-156.118035>,<8.267092,-26.206982,-163.710259>,<8.267092,-19.584820,-163.710259>}
      triangle {<10.408343,-26.206982,-156.118035>,<8.267092,-19.584820,-163.710259>,<10.408343,-19.584820,-156.118035>}
      triangle {<10.408343,-26.206982,-156.118035>,<9.522013,-26.206982,-155.868096>,<7.380763,-26.206982,-163.460351>}
      triangle {<10.408343,-26.206982,-156.118035>,<7.380763,-26.206982,-163.460351>,<8.267092,-26.206982,-163.710259>}
      triangle {<8.267092,-26.206982,-163.710259>,<7.380763,-26.206982,-163.460351>,<7.380763,-19.584820,-163.460351>}
      triangle {<8.267092,-26.206982,-163.710259>,<7.380763,-19.584820,-163.460351>,<8.267092,-19.584820,-163.710259>}
      triangle {<8.267092,-19.584820,-163.710259>,<7.380763,-19.584820,-163.460351>,<9.522013,-19.584820,-155.868096>}
      triangle {<8.267092,-19.584820,-163.710259>,<9.522013,-19.584820,-155.868096>,<10.408343,-19.584820,-156.118035>}
      triangle {<10.408343,-19.584820,-156.118035>,<9.522013,-19.584820,-155.868096>,<9.522013,-26.206982,-155.868096>}
      triangle {<10.408343,-19.584820,-156.118035>,<9.522013,-26.206982,-155.868096>,<10.408343,-26.206982,-156.118035>}
      triangle {<9.522013,-26.206982,-155.868096>,<9.522013,-19.584820,-155.868096>,<7.380763,-19.584820,-163.460351>}
      triangle {<9.522013,-26.206982,-155.868096>,<7.380763,-19.584820,-163.460351>,<7.380763,-26.206982,-163.460351>}
      triangle {<14.527506,-24.385891,-146.135095>,<10.369761,-24.385891,-160.877282>,<10.369761,-21.405910,-160.877282>}
      triangle {<14.527506,-24.385891,-146.135095>,<10.369761,-21.405910,-160.877282>,<14.527506,-21.405910,-146.135095>}
      triangle {<14.527506,-24.385891,-146.135095>,<12.524477,-24.385891,-145.570245>,<8.366740,-24.385891,-160.312402>}
      triangle {<14.527506,-24.385891,-146.135095>,<8.366740,-24.385891,-160.312402>,<10.369761,-24.385891,-160.877282>}
      triangle {<10.369761,-24.385891,-160.877282>,<8.366740,-24.385891,-160.312402>,<8.366740,-21.405910,-160.312402>}
      triangle {<10.369761,-24.385891,-160.877282>,<8.366740,-21.405910,-160.312402>,<10.369761,-21.405910,-160.877282>}
      triangle {<10.369761,-21.405910,-160.877282>,<8.366740,-21.405910,-160.312402>,<12.524477,-21.405910,-145.570245>}
      triangle {<10.369761,-21.405910,-160.877282>,<12.524477,-21.405910,-145.570245>,<14.527506,-21.405910,-146.135095>}
      triangle {<14.527506,-21.405910,-146.135095>,<12.524477,-21.405910,-145.570245>,<12.524477,-24.385891,-145.570245>}
      triangle {<14.527506,-21.405910,-146.135095>,<12.524477,-24.385891,-145.570245>,<14.527506,-24.385891,-146.135095>}
      triangle {<12.524477,-24.385891,-145.570245>,<12.524477,-21.405910,-145.570245>,<8.366740,-21.405910,-160.312402>}
      triangle {<12.524477,-24.385891,-145.570245>,<8.366740,-21.405910,-160.312402>,<8.366740,-24.385891,-160.312402>}
      triangle {<14.229769,-26.206982,-142.568200>,<12.088580,-26.206982,-150.160424>,<12.088580,-19.584820,-150.160424>}
      triangle {<14.229769,-26.206982,-142.568200>,<12.088580,-19.584820,-150.160424>,<14.229769,-19.584820,-142.568200>}
      triangle {<14.229769,-26.206982,-142.568200>,<13.343440,-26.206982,-142.318292>,<11.202250,-26.206982,-149.910455>}
      triangle {<14.229769,-26.206982,-142.568200>,<11.202250,-26.206982,-149.910455>,<12.088580,-26.206982,-150.160424>}
      triangle {<12.088580,-26.206982,-150.160424>,<11.202250,-26.206982,-149.910455>,<11.202250,-19.584820,-149.910455>}
      triangle {<12.088580,-26.206982,-150.160424>,<11.202250,-19.584820,-149.910455>,<12.088580,-19.584820,-150.160424>}
      triangle {<12.088580,-19.584820,-150.160424>,<11.202250,-19.584820,-149.910455>,<13.343440,-19.584820,-142.318292>}
      triangle {<12.088580,-19.584820,-150.160424>,<13.343440,-19.584820,-142.318292>,<14.229769,-19.584820,-142.568200>}
      triangle {<14.229769,-19.584820,-142.568200>,<13.343440,-19.584820,-142.318292>,<13.343440,-26.206982,-142.318292>}
      triangle {<14.229769,-19.584820,-142.568200>,<13.343440,-26.206982,-142.318292>,<14.229769,-26.206982,-142.568200>}
      triangle {<13.343440,-26.206982,-142.318292>,<13.343440,-19.584820,-142.318292>,<11.202250,-19.584820,-149.910455>}
      triangle {<13.343440,-26.206982,-142.318292>,<11.202250,-19.584820,-149.910455>,<11.202250,-26.206982,-149.910455>}
      triangle {<59.222788,-25.470264,12.342277>,<57.112742,-25.470264,4.860648>,<57.112742,-20.321529,4.860648>}
      triangle {<59.222788,-25.470264,12.342277>,<57.112742,-20.321529,4.860648>,<59.222788,-20.321529,12.342277>}
      triangle {<59.222788,-25.470264,12.342277>,<57.219767,-25.470264,12.907187>,<55.109721,-25.470264,5.425529>}
      triangle {<59.222788,-25.470264,12.342277>,<55.109721,-25.470264,5.425529>,<57.112742,-25.470264,4.860648>}
      triangle {<57.112742,-25.470264,4.860648>,<55.109721,-25.470264,5.425529>,<55.109721,-20.321529,5.425529>}
      triangle {<57.112742,-25.470264,4.860648>,<55.109721,-20.321529,5.425529>,<57.112742,-20.321529,4.860648>}
      triangle {<57.112742,-20.321529,4.860648>,<55.109721,-20.321529,5.425529>,<57.219767,-20.321529,12.907187>}
      triangle {<57.112742,-20.321529,4.860648>,<57.219767,-20.321529,12.907187>,<59.222788,-20.321529,12.342277>}
      triangle {<59.222788,-20.321529,12.342277>,<57.219767,-20.321529,12.907187>,<57.219767,-25.470264,12.907187>}
      triangle {<59.222788,-20.321529,12.342277>,<57.219767,-25.470264,12.907187>,<59.222788,-25.470264,12.342277>}
      triangle {<57.219767,-25.470264,12.907187>,<57.219767,-20.321529,12.907187>,<55.109721,-20.321529,5.425529>}
      triangle {<57.219767,-25.470264,12.907187>,<55.109721,-20.321529,5.425529>,<55.109721,-25.470264,5.425529>}
      triangle {<47.171275,-25.561321,-30.389016>,<45.996745,-25.561321,-34.553704>,<45.996745,-20.230480,-34.553704>}
      triangle {<47.171275,-25.561321,-30.389016>,<45.996745,-20.230480,-34.553704>,<47.171275,-20.230480,-30.389016>}
      triangle {<47.171275,-25.561321,-30.389016>,<45.168284,-25.561321,-29.824121>,<43.993723,-25.561321,-33.988793>}
      triangle {<47.171275,-25.561321,-30.389016>,<43.993723,-25.561321,-33.988793>,<45.996745,-25.561321,-34.553704>}
      triangle {<45.996745,-25.561321,-34.553704>,<43.993723,-25.561321,-33.988793>,<43.993723,-20.230480,-33.988793>}
      triangle {<45.996745,-25.561321,-34.553704>,<43.993723,-20.230480,-33.988793>,<45.996745,-20.230480,-34.553704>}
      triangle {<45.996745,-20.230480,-34.553704>,<43.993723,-20.230480,-33.988793>,<45.168284,-20.230480,-29.824121>}
      triangle {<45.996745,-20.230480,-34.553704>,<45.168284,-20.230480,-29.824121>,<47.171275,-20.230480,-30.389016>}
      triangle {<47.171275,-20.230480,-30.389016>,<45.168284,-20.230480,-29.824121>,<45.168284,-25.561321,-29.824121>}
      triangle {<47.171275,-20.230480,-30.389016>,<45.168284,-25.561321,-29.824121>,<47.171275,-25.561321,-30.389016>}
      triangle {<45.168284,-25.561321,-29.824121>,<45.168284,-20.230480,-29.824121>,<43.993723,-20.230480,-33.988793>}
      triangle {<45.168284,-25.561321,-29.824121>,<43.993723,-20.230480,-33.988793>,<43.993723,-25.561321,-33.988793>}
      triangle {<47.897013,-26.206982,-23.193261>,<45.755808,-26.206982,-30.785516>,<45.755808,-19.584820,-30.785516>}
      triangle {<47.897013,-26.206982,-23.193261>,<45.755808,-19.584820,-30.785516>,<47.897013,-19.584820,-23.193261>}
      triangle {<47.897013,-26.206982,-23.193261>,<47.010661,-26.206982,-22.943307>,<44.869456,-26.206982,-30.535562>}
      triangle {<47.897013,-26.206982,-23.193261>,<44.869456,-26.206982,-30.535562>,<45.755808,-26.206982,-30.785516>}
      triangle {<45.755808,-26.206982,-30.785516>,<44.869456,-26.206982,-30.535562>,<44.869456,-19.584820,-30.535562>}
      triangle {<45.755808,-26.206982,-30.785516>,<44.869456,-19.584820,-30.535562>,<45.755808,-19.584820,-30.785516>}
      triangle {<45.755808,-19.584820,-30.785516>,<44.869456,-19.584820,-30.535562>,<47.010661,-19.584820,-22.943307>}
      triangle {<45.755808,-19.584820,-30.785516>,<47.010661,-19.584820,-22.943307>,<47.897013,-19.584820,-23.193261>}
      triangle {<47.897013,-19.584820,-23.193261>,<47.010661,-19.584820,-22.943307>,<47.010661,-26.206982,-22.943307>}
      triangle {<47.897013,-19.584820,-23.193261>,<47.010661,-26.206982,-22.943307>,<47.897013,-26.206982,-23.193261>}
      triangle {<47.010661,-26.206982,-22.943307>,<47.010661,-19.584820,-22.943307>,<44.869456,-19.584820,-30.535562>}
      triangle {<47.010661,-26.206982,-22.943307>,<44.869456,-19.584820,-30.535562>,<44.869456,-26.206982,-30.535562>}
      triangle {<50.370097,-24.551434,-19.046945>,<48.291239,-24.551434,-26.417977>,<48.291239,-21.240353,-26.417977>}
      triangle {<50.370097,-24.551434,-19.046945>,<48.291239,-21.240353,-26.417977>,<50.370097,-21.240353,-19.046945>}
      triangle {<50.370097,-24.551434,-19.046945>,<48.367075,-24.551434,-18.482034>,<46.288218,-24.551434,-25.853051>}
      triangle {<50.370097,-24.551434,-19.046945>,<46.288218,-24.551434,-25.853051>,<48.291239,-24.551434,-26.417977>}
      triangle {<48.291239,-24.551434,-26.417977>,<46.288218,-24.551434,-25.853051>,<46.288218,-21.240353,-25.853051>}
      triangle {<48.291239,-24.551434,-26.417977>,<46.288218,-21.240353,-25.853051>,<48.291239,-21.240353,-26.417977>}
      triangle {<48.291239,-21.240353,-26.417977>,<46.288218,-21.240353,-25.853051>,<48.367075,-21.240353,-18.482034>}
      triangle {<48.291239,-21.240353,-26.417977>,<48.367075,-21.240353,-18.482034>,<50.370097,-21.240353,-19.046945>}
      triangle {<50.370097,-21.240353,-19.046945>,<48.367075,-21.240353,-18.482034>,<48.367075,-24.551434,-18.482034>}
      triangle {<50.370097,-21.240353,-19.046945>,<48.367075,-24.551434,-18.482034>,<50.370097,-24.551434,-19.046945>}
      triangle {<48.367075,-24.551434,-18.482034>,<48.367075,-21.240353,-18.482034>,<46.288218,-21.240353,-25.853051>}
      triangle {<48.367075,-24.551434,-18.482034>,<46.288218,-21.240353,-25.853051>,<46.288218,-24.551434,-25.853051>}
      triangle {<52.076731,-26.206982,-8.373269>,<49.935496,-26.206982,-15.965493>,<49.935496,-19.584820,-15.965493>}
      triangle {<52.076731,-26.206982,-8.373269>,<49.935496,-19.584820,-15.965493>,<52.076731,-19.584820,-8.373269>}
      triangle {<52.076731,-26.206982,-8.373269>,<51.190409,-26.206982,-8.123284>,<49.049174,-26.206982,-15.715508>}
      triangle {<52.076731,-26.206982,-8.373269>,<49.049174,-26.206982,-15.715508>,<49.935496,-26.206982,-15.965493>}
      triangle {<49.935496,-26.206982,-15.965493>,<49.049174,-26.206982,-15.715508>,<49.049174,-19.584820,-15.715508>}
      triangle {<49.935496,-26.206982,-15.965493>,<49.049174,-19.584820,-15.715508>,<49.935496,-19.584820,-15.965493>}
      triangle {<49.935496,-19.584820,-15.965493>,<49.049174,-19.584820,-15.715508>,<51.190409,-19.584820,-8.123284>}
      triangle {<49.935496,-19.584820,-15.965493>,<51.190409,-19.584820,-8.123284>,<52.076731,-19.584820,-8.373269>}
      triangle {<52.076731,-19.584820,-8.373269>,<51.190409,-19.584820,-8.123284>,<51.190409,-26.206982,-8.123284>}
      triangle {<52.076731,-19.584820,-8.373269>,<51.190409,-26.206982,-8.123284>,<52.076731,-26.206982,-8.373269>}
      triangle {<51.190409,-26.206982,-8.123284>,<51.190409,-19.584820,-8.123284>,<49.049174,-19.584820,-15.715508>}
      triangle {<51.190409,-26.206982,-8.123284>,<49.049174,-19.584820,-15.715508>,<49.049174,-26.206982,-15.715508>}
      triangle {<56.195872,-24.385891,1.609687>,<52.038126,-24.385891,-13.132546>,<52.038126,-21.405910,-13.132546>}
      triangle {<56.195872,-24.385891,1.609687>,<52.038126,-21.405910,-13.132546>,<56.195872,-21.405910,1.609687>}
      triangle {<56.195872,-24.385891,1.609687>,<54.192851,-24.385891,2.174613>,<50.035136,-24.385891,-12.567636>}
      triangle {<56.195872,-24.385891,1.609687>,<50.035136,-24.385891,-12.567636>,<52.038126,-24.385891,-13.132546>}
      triangle {<52.038126,-24.385891,-13.132546>,<50.035136,-24.385891,-12.567636>,<50.035136,-21.405910,-12.567636>}
      triangle {<52.038126,-24.385891,-13.132546>,<50.035136,-21.405910,-12.567636>,<52.038126,-21.405910,-13.132546>}
      triangle {<52.038126,-21.405910,-13.132546>,<50.035136,-21.405910,-12.567636>,<54.192851,-21.405910,2.174613>}
      triangle {<52.038126,-21.405910,-13.132546>,<54.192851,-21.405910,2.174613>,<56.195872,-21.405910,1.609687>}
      triangle {<56.195872,-21.405910,1.609687>,<54.192851,-21.405910,2.174613>,<54.192851,-24.385891,2.174613>}
      triangle {<56.195872,-21.405910,1.609687>,<54.192851,-24.385891,2.174613>,<56.195872,-24.385891,1.609687>}
      triangle {<54.192851,-24.385891,2.174613>,<54.192851,-21.405910,2.174613>,<50.035136,-21.405910,-12.567636>}
      triangle {<54.192851,-24.385891,2.174613>,<50.035136,-21.405910,-12.567636>,<50.035136,-24.385891,-12.567636>}
      triangle {<55.898173,-26.206982,5.176551>,<53.756938,-26.206982,-2.415704>,<53.756938,-19.584820,-2.415704>}
      triangle {<55.898173,-26.206982,5.176551>,<53.756938,-19.584820,-2.415704>,<55.898173,-19.584820,5.176551>}
      triangle {<55.898173,-26.206982,5.176551>,<55.011851,-26.206982,5.426520>,<52.870585,-26.206982,-2.165734>}
      triangle {<55.898173,-26.206982,5.176551>,<52.870585,-26.206982,-2.165734>,<53.756938,-26.206982,-2.415704>}
      triangle {<53.756938,-26.206982,-2.415704>,<52.870585,-26.206982,-2.165734>,<52.870585,-19.584820,-2.165734>}
      triangle {<53.756938,-26.206982,-2.415704>,<52.870585,-19.584820,-2.165734>,<53.756938,-19.584820,-2.415704>}
      triangle {<53.756938,-19.584820,-2.415704>,<52.870585,-19.584820,-2.165734>,<55.011851,-19.584820,5.426520>}
      triangle {<53.756938,-19.584820,-2.415704>,<55.011851,-19.584820,5.426520>,<55.898173,-19.584820,5.176551>}
      triangle {<55.898173,-19.584820,5.176551>,<55.011851,-19.584820,5.426520>,<55.011851,-26.206982,5.426520>}
      triangle {<55.898173,-19.584820,5.176551>,<55.011851,-26.206982,5.426520>,<55.898173,-26.206982,5.176551>}
      triangle {<55.011851,-26.206982,5.426520>,<55.011851,-19.584820,5.426520>,<52.870585,-19.584820,-2.165734>}
      triangle {<55.011851,-26.206982,5.426520>,<52.870585,-19.584820,-2.165734>,<52.870585,-26.206982,-2.165734>}
      triangle {<45.250590,-25.470264,-37.199212>,<43.140574,-25.470264,-44.680840>,<43.140574,-20.321529,-44.680840>}
      triangle {<45.250590,-25.470264,-37.199212>,<43.140574,-20.321529,-44.680840>,<45.250590,-20.321529,-37.199212>}
      triangle {<45.250590,-25.470264,-37.199212>,<43.247569,-25.470264,-36.634301>,<41.137553,-25.470264,-44.115945>}
      triangle {<45.250590,-25.470264,-37.199212>,<41.137553,-25.470264,-44.115945>,<43.140574,-25.470264,-44.680840>}
      triangle {<43.140574,-25.470264,-44.680840>,<41.137553,-25.470264,-44.115945>,<41.137553,-20.321529,-44.115945>}
      triangle {<43.140574,-25.470264,-44.680840>,<41.137553,-20.321529,-44.115945>,<43.140574,-20.321529,-44.680840>}
      triangle {<43.140574,-20.321529,-44.680840>,<41.137553,-20.321529,-44.115945>,<43.247569,-20.321529,-36.634301>}
      triangle {<43.140574,-20.321529,-44.680840>,<43.247569,-20.321529,-36.634301>,<45.250590,-20.321529,-37.199212>}
      triangle {<45.250590,-20.321529,-37.199212>,<43.247569,-20.321529,-36.634301>,<43.247569,-25.470264,-36.634301>}
      triangle {<45.250590,-20.321529,-37.199212>,<43.247569,-25.470264,-36.634301>,<45.250590,-25.470264,-37.199212>}
      triangle {<43.247569,-25.470264,-36.634301>,<43.247569,-20.321529,-36.634301>,<41.137553,-20.321529,-44.115945>}
      triangle {<43.247569,-25.470264,-36.634301>,<41.137553,-20.321529,-44.115945>,<41.137553,-25.470264,-44.115945>}
      triangle {<33.199099,-25.561321,-79.930566>,<32.024531,-25.561321,-84.095147>,<32.024531,-20.230480,-84.095147>}
      triangle {<33.199099,-25.561321,-79.930566>,<32.024531,-20.230480,-84.095147>,<33.199099,-20.230480,-79.930566>}
      triangle {<33.199099,-25.561321,-79.930566>,<31.196093,-25.561321,-79.365624>,<30.021525,-25.561321,-83.530358>}
      triangle {<33.199099,-25.561321,-79.930566>,<30.021525,-25.561321,-83.530358>,<32.024531,-25.561321,-84.095147>}
      triangle {<32.024531,-25.561321,-84.095147>,<30.021525,-25.561321,-83.530358>,<30.021525,-20.230480,-83.530358>}
      triangle {<32.024531,-25.561321,-84.095147>,<30.021525,-20.230480,-83.530358>,<32.024531,-20.230480,-84.095147>}
      triangle {<32.024531,-20.230480,-84.095147>,<30.021525,-20.230480,-83.530358>,<31.196093,-20.230480,-79.365624>}
      triangle {<32.024531,-20.230480,-84.095147>,<31.196093,-20.230480,-79.365624>,<33.199099,-20.230480,-79.930566>}
      triangle {<33.199099,-20.230480,-79.930566>,<31.196093,-20.230480,-79.365624>,<31.196093,-25.561321,-79.365624>}
      triangle {<33.199099,-20.230480,-79.930566>,<31.196093,-25.561321,-79.365624>,<33.199099,-25.561321,-79.930566>}
      triangle {<31.196093,-25.561321,-79.365624>,<31.196093,-20.230480,-79.365624>,<30.021525,-20.230480,-83.530358>}
      triangle {<31.196093,-25.561321,-79.365624>,<30.021525,-20.230480,-83.530358>,<30.021525,-25.561321,-83.530358>}
      triangle {<33.924845,-26.206982,-72.734811>,<31.783610,-26.206982,-80.327020>,<31.783610,-19.584820,-80.327020>}
      triangle {<33.924845,-26.206982,-72.734811>,<31.783610,-19.584820,-80.327020>,<33.924845,-19.584820,-72.734811>}
      triangle {<33.924845,-26.206982,-72.734811>,<33.038523,-26.206982,-72.484857>,<30.897280,-26.206982,-80.077020>}
      triangle {<33.924845,-26.206982,-72.734811>,<30.897280,-26.206982,-80.077020>,<31.783610,-26.206982,-80.327020>}
      triangle {<31.783610,-26.206982,-80.327020>,<30.897280,-26.206982,-80.077020>,<30.897280,-19.584820,-80.077020>}
      triangle {<31.783610,-26.206982,-80.327020>,<30.897280,-19.584820,-80.077020>,<31.783610,-19.584820,-80.327020>}
      triangle {<31.783610,-19.584820,-80.327020>,<30.897280,-19.584820,-80.077020>,<33.038523,-19.584820,-72.484857>}
      triangle {<31.783610,-19.584820,-80.327020>,<33.038523,-19.584820,-72.484857>,<33.924845,-19.584820,-72.734811>}
      triangle {<33.924845,-19.584820,-72.734811>,<33.038523,-19.584820,-72.484857>,<33.038523,-26.206982,-72.484857>}
      triangle {<33.924845,-19.584820,-72.734811>,<33.038523,-26.206982,-72.484857>,<33.924845,-26.206982,-72.734811>}
      triangle {<33.038523,-26.206982,-72.484857>,<33.038523,-19.584820,-72.484857>,<30.897280,-19.584820,-80.077020>}
      triangle {<33.038523,-26.206982,-72.484857>,<30.897280,-19.584820,-80.077020>,<30.897280,-26.206982,-80.077020>}
      triangle {<36.397906,-24.551434,-68.588418>,<34.319056,-24.551434,-75.959542>,<34.319056,-21.240353,-75.959542>}
      triangle {<36.397906,-24.551434,-68.588418>,<34.319056,-21.240353,-75.959542>,<36.397906,-21.240353,-68.588418>}
      triangle {<36.397906,-24.551434,-68.588418>,<34.394900,-24.551434,-68.023492>,<32.316035,-24.551434,-75.394616>}
      triangle {<36.397906,-24.551434,-68.588418>,<32.316035,-24.551434,-75.394616>,<34.319056,-24.551434,-75.959542>}
      triangle {<34.319056,-24.551434,-75.959542>,<32.316035,-24.551434,-75.394616>,<32.316035,-21.240353,-75.394616>}
      triangle {<34.319056,-24.551434,-75.959542>,<32.316035,-21.240353,-75.394616>,<34.319056,-21.240353,-75.959542>}
      triangle {<34.319056,-21.240353,-75.959542>,<32.316035,-21.240353,-75.394616>,<34.394900,-21.240353,-68.023492>}
      triangle {<34.319056,-21.240353,-75.959542>,<34.394900,-21.240353,-68.023492>,<36.397906,-21.240353,-68.588418>}
      triangle {<36.397906,-21.240353,-68.588418>,<34.394900,-21.240353,-68.023492>,<34.394900,-24.551434,-68.023492>}
      triangle {<36.397906,-21.240353,-68.588418>,<34.394900,-24.551434,-68.023492>,<36.397906,-24.551434,-68.588418>}
      triangle {<34.394900,-24.551434,-68.023492>,<34.394900,-21.240353,-68.023492>,<32.316035,-21.240353,-75.394616>}
      triangle {<34.394900,-24.551434,-68.023492>,<32.316035,-21.240353,-75.394616>,<32.316035,-24.551434,-75.394616>}
      triangle {<38.104563,-26.206982,-57.914712>,<35.963320,-26.206982,-65.506967>,<35.963320,-19.584820,-65.506967>}
      triangle {<38.104563,-26.206982,-57.914712>,<35.963320,-19.584820,-65.506967>,<38.104563,-19.584820,-57.914712>}
      triangle {<38.104563,-26.206982,-57.914712>,<37.218234,-26.206982,-57.664742>,<35.076983,-26.206982,-65.256997>}
      triangle {<38.104563,-26.206982,-57.914712>,<35.076983,-26.206982,-65.256997>,<35.963320,-26.206982,-65.506967>}
      triangle {<35.963320,-26.206982,-65.506967>,<35.076983,-26.206982,-65.256997>,<35.076983,-19.584820,-65.256997>}
      triangle {<35.963320,-26.206982,-65.506967>,<35.076983,-19.584820,-65.256997>,<35.963320,-19.584820,-65.506967>}
      triangle {<35.963320,-19.584820,-65.506967>,<35.076983,-19.584820,-65.256997>,<37.218234,-19.584820,-57.664742>}
      triangle {<35.963320,-19.584820,-65.506967>,<37.218234,-19.584820,-57.664742>,<38.104563,-19.584820,-57.914712>}
      triangle {<38.104563,-19.584820,-57.914712>,<37.218234,-19.584820,-57.664742>,<37.218234,-26.206982,-57.664742>}
      triangle {<38.104563,-19.584820,-57.914712>,<37.218234,-26.206982,-57.664742>,<38.104563,-26.206982,-57.914712>}
      triangle {<37.218234,-26.206982,-57.664742>,<37.218234,-19.584820,-57.664742>,<35.076983,-19.584820,-65.256997>}
      triangle {<37.218234,-26.206982,-57.664742>,<35.076983,-19.584820,-65.256997>,<35.076983,-26.206982,-65.256997>}
      triangle {<42.223734,-24.385891,-47.931741>,<38.065989,-24.385891,-62.673928>,<38.065989,-21.405910,-62.673928>}
      triangle {<42.223734,-24.385891,-47.931741>,<38.065989,-21.405910,-62.673928>,<42.223734,-21.405910,-47.931741>}
      triangle {<42.223734,-24.385891,-47.931741>,<40.220713,-24.385891,-47.366830>,<36.062975,-24.385891,-62.109033>}
      triangle {<42.223734,-24.385891,-47.931741>,<36.062975,-24.385891,-62.109033>,<38.065989,-24.385891,-62.673928>}
      triangle {<38.065989,-24.385891,-62.673928>,<36.062975,-24.385891,-62.109033>,<36.062975,-21.405910,-62.109033>}
      triangle {<38.065989,-24.385891,-62.673928>,<36.062975,-21.405910,-62.109033>,<38.065989,-21.405910,-62.673928>}
      triangle {<38.065989,-21.405910,-62.673928>,<36.062975,-21.405910,-62.109033>,<40.220713,-21.405910,-47.366830>}
      triangle {<38.065989,-21.405910,-62.673928>,<40.220713,-21.405910,-47.366830>,<42.223734,-21.405910,-47.931741>}
      triangle {<42.223734,-21.405910,-47.931741>,<40.220713,-21.405910,-47.366830>,<40.220713,-24.385891,-47.366830>}
      triangle {<42.223734,-21.405910,-47.931741>,<40.220713,-24.385891,-47.366830>,<42.223734,-24.385891,-47.931741>}
      triangle {<40.220713,-24.385891,-47.366830>,<40.220713,-21.405910,-47.366830>,<36.062975,-21.405910,-62.109033>}
      triangle {<40.220713,-24.385891,-47.366830>,<36.062975,-21.405910,-62.109033>,<36.062975,-24.385891,-62.109033>}
      triangle {<41.926005,-26.206982,-44.364907>,<39.784770,-26.206982,-51.957147>,<39.784770,-19.584820,-51.957147>}
      triangle {<41.926005,-26.206982,-44.364907>,<39.784770,-19.584820,-51.957147>,<41.926005,-19.584820,-44.364907>}
      triangle {<41.926005,-26.206982,-44.364907>,<41.039683,-26.206982,-44.114923>,<38.898448,-26.206982,-51.707162>}
      triangle {<41.926005,-26.206982,-44.364907>,<38.898448,-26.206982,-51.707162>,<39.784770,-26.206982,-51.957147>}
      triangle {<39.784770,-26.206982,-51.957147>,<38.898448,-26.206982,-51.707162>,<38.898448,-19.584820,-51.707162>}
      triangle {<39.784770,-26.206982,-51.957147>,<38.898448,-19.584820,-51.707162>,<39.784770,-19.584820,-51.957147>}
      triangle {<39.784770,-19.584820,-51.957147>,<38.898448,-19.584820,-51.707162>,<41.039683,-19.584820,-44.114923>}
      triangle {<39.784770,-19.584820,-51.957147>,<41.039683,-19.584820,-44.114923>,<41.926005,-19.584820,-44.364907>}
      triangle {<41.926005,-19.584820,-44.364907>,<41.039683,-19.584820,-44.114923>,<41.039683,-26.206982,-44.114923>}
      triangle {<41.926005,-19.584820,-44.364907>,<41.039683,-26.206982,-44.114923>,<41.926005,-26.206982,-44.364907>}
      triangle {<41.039683,-26.206982,-44.114923>,<41.039683,-19.584820,-44.114923>,<38.898448,-19.584820,-51.707162>}
      triangle {<41.039683,-26.206982,-44.114923>,<38.898448,-19.584820,-51.707162>,<38.898448,-26.206982,-51.707162>}
      triangle {<87.025431,-25.470264,110.922965>,<84.915415,-25.470264,103.441283>,<84.915415,-20.321529,103.441283>}
      triangle {<87.025431,-25.470264,110.922965>,<84.915415,-20.321529,103.441283>,<87.025431,-20.321529,110.922965>}
      triangle {<87.025431,-25.470264,110.922965>,<85.022440,-25.470264,111.487868>,<82.912394,-25.470264,104.006141>}
      triangle {<87.025431,-25.470264,110.922965>,<82.912394,-25.470264,104.006141>,<84.915415,-25.470264,103.441283>}
      triangle {<84.915415,-25.470264,103.441283>,<82.912394,-25.470264,104.006141>,<82.912394,-20.321529,104.006141>}
      triangle {<84.915415,-25.470264,103.441283>,<82.912394,-20.321529,104.006141>,<84.915415,-20.321529,103.441283>}
      triangle {<84.915415,-20.321529,103.441283>,<82.912394,-20.321529,104.006141>,<85.022440,-20.321529,111.487868>}
      triangle {<84.915415,-20.321529,103.441283>,<85.022440,-20.321529,111.487868>,<87.025431,-20.321529,110.922965>}
      triangle {<87.025431,-20.321529,110.922965>,<85.022440,-20.321529,111.487868>,<85.022440,-25.470264,111.487868>}
      triangle {<87.025431,-20.321529,110.922965>,<85.022440,-25.470264,111.487868>,<87.025431,-25.470264,110.922965>}
      triangle {<85.022440,-25.470264,111.487868>,<85.022440,-20.321529,111.487868>,<82.912394,-20.321529,104.006141>}
      triangle {<85.022440,-25.470264,111.487868>,<82.912394,-20.321529,104.006141>,<82.912394,-25.470264,104.006141>}
      triangle {<74.973917,-25.561321,68.191642>,<73.799357,-25.561321,64.026938>,<73.799357,-20.230480,64.026938>}
      triangle {<74.973917,-25.561321,68.191642>,<73.799357,-20.230480,64.026938>,<74.973917,-20.230480,68.191642>}
      triangle {<74.973917,-25.561321,68.191642>,<72.970927,-25.561321,68.756553>,<71.796366,-25.561321,64.591857>}
      triangle {<74.973917,-25.561321,68.191642>,<71.796366,-25.561321,64.591857>,<73.799357,-25.561321,64.026938>}
      triangle {<73.799357,-25.561321,64.026938>,<71.796366,-25.561321,64.591857>,<71.796366,-20.230480,64.591857>}
      triangle {<73.799357,-25.561321,64.026938>,<71.796366,-20.230480,64.591857>,<73.799357,-20.230480,64.026938>}
      triangle {<73.799357,-20.230480,64.026938>,<71.796366,-20.230480,64.591857>,<72.970927,-20.230480,68.756553>}
      triangle {<73.799357,-20.230480,64.026938>,<72.970927,-20.230480,68.756553>,<74.973917,-20.230480,68.191642>}
      triangle {<74.973917,-20.230480,68.191642>,<72.970927,-20.230480,68.756553>,<72.970927,-25.561321,68.756553>}
      triangle {<74.973917,-20.230480,68.191642>,<72.970927,-25.561321,68.756553>,<74.973917,-25.561321,68.191642>}
      triangle {<72.970927,-25.561321,68.756553>,<72.970927,-20.230480,68.756553>,<71.796366,-20.230480,64.591857>}
      triangle {<72.970927,-25.561321,68.756553>,<71.796366,-20.230480,64.591857>,<71.796366,-25.561321,64.591857>}
      triangle {<75.699656,-26.206982,75.387305>,<73.558421,-26.206982,67.795150>,<73.558421,-19.584820,67.795150>}
      triangle {<75.699656,-26.206982,75.387305>,<73.558421,-19.584820,67.795150>,<75.699656,-19.584820,75.387305>}
      triangle {<75.699656,-26.206982,75.387305>,<74.813334,-26.206982,75.637290>,<72.672099,-26.206982,68.045096>}
      triangle {<75.699656,-26.206982,75.387305>,<72.672099,-26.206982,68.045096>,<73.558421,-26.206982,67.795150>}
      triangle {<73.558421,-26.206982,67.795150>,<72.672099,-26.206982,68.045096>,<72.672099,-19.584820,68.045096>}
      triangle {<73.558421,-26.206982,67.795150>,<72.672099,-19.584820,68.045096>,<73.558421,-19.584820,67.795150>}
      triangle {<73.558421,-19.584820,67.795150>,<72.672099,-19.584820,68.045096>,<74.813334,-19.584820,75.637290>}
      triangle {<73.558421,-19.584820,67.795150>,<74.813334,-19.584820,75.637290>,<75.699656,-19.584820,75.387305>}
      triangle {<75.699656,-19.584820,75.387305>,<74.813334,-19.584820,75.637290>,<74.813334,-26.206982,75.637290>}
      triangle {<75.699656,-19.584820,75.387305>,<74.813334,-26.206982,75.637290>,<75.699656,-26.206982,75.387305>}
      triangle {<74.813334,-26.206982,75.637290>,<74.813334,-19.584820,75.637290>,<72.672099,-19.584820,68.045096>}
      triangle {<74.813334,-26.206982,75.637290>,<72.672099,-19.584820,68.045096>,<72.672099,-26.206982,68.045096>}
      triangle {<78.172740,-24.551434,79.533759>,<76.093852,-24.551434,72.162642>,<76.093852,-21.240353,72.162642>}
      triangle {<78.172740,-24.551434,79.533759>,<76.093852,-21.240353,72.162642>,<78.172740,-21.240353,79.533759>}
      triangle {<78.172740,-24.551434,79.533759>,<76.169749,-24.551434,80.098708>,<74.090861,-24.551434,72.727500>}
      triangle {<78.172740,-24.551434,79.533759>,<74.090861,-24.551434,72.727500>,<76.093852,-24.551434,72.162642>}
      triangle {<76.093852,-24.551434,72.162642>,<74.090861,-24.551434,72.727500>,<74.090861,-21.240353,72.727500>}
      triangle {<76.093852,-24.551434,72.162642>,<74.090861,-21.240353,72.727500>,<76.093852,-21.240353,72.162642>}
      triangle {<76.093852,-21.240353,72.162642>,<74.090861,-21.240353,72.727500>,<76.169749,-21.240353,80.098708>}
      triangle {<76.093852,-21.240353,72.162642>,<76.169749,-21.240353,80.098708>,<78.172740,-21.240353,79.533759>}
      triangle {<78.172740,-21.240353,79.533759>,<76.169749,-21.240353,80.098708>,<76.169749,-24.551434,80.098708>}
      triangle {<78.172740,-21.240353,79.533759>,<76.169749,-24.551434,80.098708>,<78.172740,-24.551434,79.533759>}
      triangle {<76.169749,-24.551434,80.098708>,<76.169749,-21.240353,80.098708>,<74.090861,-21.240353,72.727500>}
      triangle {<76.169749,-24.551434,80.098708>,<74.090861,-21.240353,72.727500>,<74.090861,-24.551434,72.727500>}
      triangle {<79.879374,-26.206982,90.207465>,<77.738169,-26.206982,82.615195>,<77.738169,-19.584820,82.615195>}
      triangle {<79.879374,-26.206982,90.207465>,<77.738169,-19.584820,82.615195>,<79.879374,-19.584820,90.207465>}
      triangle {<79.879374,-26.206982,90.207465>,<78.993052,-26.206982,90.457427>,<76.851847,-26.206982,82.865180>}
      triangle {<79.879374,-26.206982,90.207465>,<76.851847,-26.206982,82.865180>,<77.738169,-26.206982,82.615195>}
      triangle {<77.738169,-26.206982,82.615195>,<76.851847,-26.206982,82.865180>,<76.851847,-19.584820,82.865180>}
      triangle {<77.738169,-26.206982,82.615195>,<76.851847,-19.584820,82.865180>,<77.738169,-19.584820,82.615195>}
      triangle {<77.738169,-19.584820,82.615195>,<76.851847,-19.584820,82.865180>,<78.993052,-19.584820,90.457427>}
      triangle {<77.738169,-19.584820,82.615195>,<78.993052,-19.584820,90.457427>,<79.879374,-19.584820,90.207465>}
      triangle {<79.879374,-19.584820,90.207465>,<78.993052,-19.584820,90.457427>,<78.993052,-26.206982,90.457427>}
      triangle {<79.879374,-19.584820,90.207465>,<78.993052,-26.206982,90.457427>,<79.879374,-26.206982,90.207465>}
      triangle {<78.993052,-26.206982,90.457427>,<78.993052,-19.584820,90.457427>,<76.851847,-19.584820,82.865180>}
      triangle {<78.993052,-26.206982,90.457427>,<76.851847,-19.584820,82.865180>,<76.851847,-26.206982,82.865180>}
      triangle {<83.998545,-24.385891,100.190391>,<79.840800,-24.385891,85.448241>,<79.840800,-21.405910,85.448241>}
      triangle {<83.998545,-24.385891,100.190391>,<79.840800,-21.405910,85.448241>,<83.998545,-21.405910,100.190391>}
      triangle {<83.998545,-24.385891,100.190391>,<81.995554,-24.385891,100.755172>,<77.837779,-24.385891,86.013152>}
      triangle {<83.998545,-24.385891,100.190391>,<77.837779,-24.385891,86.013152>,<79.840800,-24.385891,85.448241>}
      triangle {<79.840800,-24.385891,85.448241>,<77.837779,-24.385891,86.013152>,<77.837779,-21.405910,86.013152>}
      triangle {<79.840800,-24.385891,85.448241>,<77.837779,-21.405910,86.013152>,<79.840800,-21.405910,85.448241>}
      triangle {<79.840800,-21.405910,85.448241>,<77.837779,-21.405910,86.013152>,<81.995554,-21.405910,100.755172>}
      triangle {<79.840800,-21.405910,85.448241>,<81.995554,-21.405910,100.755172>,<83.998545,-21.405910,100.190391>}
      triangle {<83.998545,-21.405910,100.190391>,<81.995554,-21.405910,100.755172>,<81.995554,-24.385891,100.755172>}
      triangle {<83.998545,-21.405910,100.190391>,<81.995554,-24.385891,100.755172>,<83.998545,-24.385891,100.190391>}
      triangle {<81.995554,-24.385891,100.755172>,<81.995554,-21.405910,100.755172>,<77.837779,-21.405910,86.013152>}
      triangle {<81.995554,-24.385891,100.755172>,<77.837779,-21.405910,86.013152>,<77.837779,-24.385891,86.013152>}
      triangle {<83.700846,-26.206982,103.757216>,<81.559580,-26.206982,96.165030>,<81.559580,-19.584820,96.165030>}
      triangle {<83.700846,-26.206982,103.757216>,<81.559580,-19.584820,96.165030>,<83.700846,-19.584820,103.757216>}
      triangle {<83.700846,-26.206982,103.757216>,<82.814524,-26.206982,104.007201>,<80.673258,-26.206982,96.415015>}
      triangle {<83.700846,-26.206982,103.757216>,<80.673258,-26.206982,96.415015>,<81.559580,-26.206982,96.165030>}
      triangle {<81.559580,-26.206982,96.165030>,<80.673258,-26.206982,96.415015>,<80.673258,-19.584820,96.415015>}
      triangle {<81.559580,-26.206982,96.165030>,<80.673258,-19.584820,96.415015>,<81.559580,-19.584820,96.165030>}
      triangle {<81.559580,-19.584820,96.165030>,<80.673258,-19.584820,96.415015>,<82.814524,-19.584820,104.007201>}
      triangle {<81.559580,-19.584820,96.165030>,<82.814524,-19.584820,104.007201>,<83.700846,-19.584820,103.757216>}
      triangle {<83.700846,-19.584820,103.757216>,<82.814524,-19.584820,104.007201>,<82.814524,-26.206982,104.007201>}
      triangle {<83.700846,-19.584820,103.757216>,<82.814524,-26.206982,104.007201>,<83.700846,-26.206982,103.757216>}
      triangle {<82.814524,-26.206982,104.007201>,<82.814524,-19.584820,104.007201>,<80.673258,-19.584820,96.415015>}
      triangle {<82.814524,-26.206982,104.007201>,<80.673258,-19.584820,96.415015>,<80.673258,-26.206982,96.415015>}
      triangle {<73.053263,-25.470264,61.381476>,<70.943217,-25.470264,53.899825>,<70.943217,-20.321529,53.899825>}
      triangle {<73.053263,-25.470264,61.381476>,<70.943217,-20.321529,53.899825>,<73.053263,-20.321529,61.381476>}
      triangle {<73.053263,-25.470264,61.381476>,<71.050242,-25.470264,61.946349>,<68.940196,-25.470264,54.464713>}
      triangle {<73.053263,-25.470264,61.381476>,<68.940196,-25.470264,54.464713>,<70.943217,-25.470264,53.899825>}
      triangle {<70.943217,-25.470264,53.899825>,<68.940196,-25.470264,54.464713>,<68.940196,-20.321529,54.464713>}
      triangle {<70.943217,-25.470264,53.899825>,<68.940196,-20.321529,54.464713>,<70.943217,-20.321529,53.899825>}
      triangle {<70.943217,-20.321529,53.899825>,<68.940196,-20.321529,54.464713>,<71.050242,-20.321529,61.946349>}
      triangle {<70.943217,-20.321529,53.899825>,<71.050242,-20.321529,61.946349>,<73.053263,-20.321529,61.381476>}
      triangle {<73.053263,-20.321529,61.381476>,<71.050242,-20.321529,61.946349>,<71.050242,-25.470264,61.946349>}
      triangle {<73.053263,-20.321529,61.381476>,<71.050242,-25.470264,61.946349>,<73.053263,-25.470264,61.381476>}
      triangle {<71.050242,-25.470264,61.946349>,<71.050242,-20.321529,61.946349>,<68.940196,-20.321529,54.464713>}
      triangle {<71.050242,-25.470264,61.946349>,<68.940196,-20.321529,54.464713>,<68.940196,-25.470264,54.464713>}
      triangle {<61.001780,-25.561321,18.650077>,<59.827219,-25.561321,14.485450>,<59.827219,-20.230480,14.485450>}
      triangle {<61.001780,-25.561321,18.650077>,<59.827219,-20.230480,14.485450>,<61.001780,-20.230480,18.650077>}
      triangle {<61.001780,-25.561321,18.650077>,<58.998759,-25.561321,19.214988>,<57.824198,-25.561321,15.050361>}
      triangle {<61.001780,-25.561321,18.650077>,<57.824198,-25.561321,15.050361>,<59.827219,-25.561321,14.485450>}
      triangle {<59.827219,-25.561321,14.485450>,<57.824198,-25.561321,15.050361>,<57.824198,-20.230480,15.050361>}
      triangle {<59.827219,-25.561321,14.485450>,<57.824198,-20.230480,15.050361>,<59.827219,-20.230480,14.485450>}
      triangle {<59.827219,-20.230480,14.485450>,<57.824198,-20.230480,15.050361>,<58.998759,-20.230480,19.214988>}
      triangle {<59.827219,-20.230480,14.485450>,<58.998759,-20.230480,19.214988>,<61.001780,-20.230480,18.650077>}
      triangle {<61.001780,-20.230480,18.650077>,<58.998759,-20.230480,19.214988>,<58.998759,-25.561321,19.214988>}
      triangle {<61.001780,-20.230480,18.650077>,<58.998759,-25.561321,19.214988>,<61.001780,-25.561321,18.650077>}
      triangle {<58.998759,-25.561321,19.214988>,<58.998759,-20.230480,19.214988>,<57.824198,-20.230480,15.050361>}
      triangle {<58.998759,-25.561321,19.214988>,<57.824198,-20.230480,15.050361>,<57.824198,-25.561321,15.050361>}
      triangle {<61.727519,-26.206982,25.845817>,<59.586283,-26.206982,18.253577>,<59.586283,-19.584820,18.253577>}
      triangle {<61.727519,-26.206982,25.845817>,<59.586283,-19.584820,18.253577>,<61.727519,-19.584820,25.845817>}
      triangle {<61.727519,-26.206982,25.845817>,<60.841197,-26.206982,26.095801>,<58.699961,-26.206982,18.503547>}
      triangle {<61.727519,-26.206982,25.845817>,<58.699961,-26.206982,18.503547>,<59.586283,-26.206982,18.253577>}
      triangle {<59.586283,-26.206982,18.253577>,<58.699961,-26.206982,18.503547>,<58.699961,-19.584820,18.503547>}
      triangle {<59.586283,-26.206982,18.253577>,<58.699961,-19.584820,18.503547>,<59.586283,-19.584820,18.253577>}
      triangle {<59.586283,-19.584820,18.253577>,<58.699961,-19.584820,18.503547>,<60.841197,-19.584820,26.095801>}
      triangle {<59.586283,-19.584820,18.253577>,<60.841197,-19.584820,26.095801>,<61.727519,-19.584820,25.845817>}
      triangle {<61.727519,-19.584820,25.845817>,<60.841197,-19.584820,26.095801>,<60.841197,-26.206982,26.095801>}
      triangle {<61.727519,-19.584820,25.845817>,<60.841197,-26.206982,26.095801>,<61.727519,-26.206982,25.845817>}
      triangle {<60.841197,-26.206982,26.095801>,<60.841197,-19.584820,26.095801>,<58.699961,-19.584820,18.503547>}
      triangle {<60.841197,-26.206982,26.095801>,<58.699961,-19.584820,18.503547>,<58.699961,-26.206982,18.503547>}
      triangle {<64.200572,-24.551434,29.992225>,<62.121714,-24.551434,22.621116>,<62.121714,-21.240353,22.621116>}
      triangle {<64.200572,-24.551434,29.992225>,<62.121714,-21.240353,22.621116>,<64.200572,-21.240353,29.992225>}
      triangle {<64.200572,-24.551434,29.992225>,<62.197581,-24.551434,30.557136>,<60.118723,-24.551434,23.186027>}
      triangle {<64.200572,-24.551434,29.992225>,<60.118723,-24.551434,23.186027>,<62.121714,-24.551434,22.621116>}
      triangle {<62.121714,-24.551434,22.621116>,<60.118723,-24.551434,23.186027>,<60.118723,-21.240353,23.186027>}
      triangle {<62.121714,-24.551434,22.621116>,<60.118723,-21.240353,23.186027>,<62.121714,-21.240353,22.621116>}
      triangle {<62.121714,-21.240353,22.621116>,<60.118723,-21.240353,23.186027>,<62.197581,-21.240353,30.557136>}
      triangle {<62.121714,-21.240353,22.621116>,<62.197581,-21.240353,30.557136>,<64.200572,-21.240353,29.992225>}
      triangle {<64.200572,-21.240353,29.992225>,<62.197581,-21.240353,30.557136>,<62.197581,-24.551434,30.557136>}
      triangle {<64.200572,-21.240353,29.992225>,<62.197581,-24.551434,30.557136>,<64.200572,-24.551434,29.992225>}
      triangle {<62.197581,-24.551434,30.557136>,<62.197581,-21.240353,30.557136>,<60.118723,-21.240353,23.186027>}
      triangle {<62.197581,-24.551434,30.557136>,<60.118723,-21.240353,23.186027>,<60.118723,-24.551434,23.186027>}
      triangle {<65.907237,-26.206982,40.665931>,<63.765971,-26.206982,33.073691>,<63.765971,-19.584820,33.073691>}
      triangle {<65.907237,-26.206982,40.665931>,<63.765971,-19.584820,33.073691>,<65.907237,-19.584820,40.665931>}
      triangle {<65.907237,-26.206982,40.665931>,<65.020915,-26.206982,40.915885>,<62.879649,-26.206982,33.323646>}
      triangle {<65.907237,-26.206982,40.665931>,<62.879649,-26.206982,33.323646>,<63.765971,-26.206982,33.073691>}
      triangle {<63.765971,-26.206982,33.073691>,<62.879649,-26.206982,33.323646>,<62.879649,-19.584820,33.323646>}
      triangle {<63.765971,-26.206982,33.073691>,<62.879649,-19.584820,33.323646>,<63.765971,-19.584820,33.073691>}
      triangle {<63.765971,-19.584820,33.073691>,<62.879649,-19.584820,33.323646>,<65.020915,-19.584820,40.915885>}
      triangle {<63.765971,-19.584820,33.073691>,<65.020915,-19.584820,40.915885>,<65.907237,-19.584820,40.665931>}
      triangle {<65.907237,-19.584820,40.665931>,<65.020915,-19.584820,40.915885>,<65.020915,-26.206982,40.915885>}
      triangle {<65.907237,-19.584820,40.665931>,<65.020915,-26.206982,40.915885>,<65.907237,-26.206982,40.665931>}
      triangle {<65.020915,-26.206982,40.915885>,<65.020915,-19.584820,40.915885>,<62.879649,-19.584820,33.323646>}
      triangle {<65.020915,-26.206982,40.915885>,<62.879649,-19.584820,33.323646>,<62.879649,-26.206982,33.323646>}
      triangle {<70.026377,-24.385891,50.648833>,<65.868632,-24.385891,35.906684>,<65.868632,-21.405910,35.906684>}
      triangle {<70.026377,-24.385891,50.648833>,<65.868632,-21.405910,35.906684>,<70.026377,-21.405910,50.648833>}
      triangle {<70.026377,-24.385891,50.648833>,<68.023356,-24.385891,51.213744>,<63.865611,-24.385891,36.471580>}
      triangle {<70.026377,-24.385891,50.648833>,<63.865611,-24.385891,36.471580>,<65.868632,-24.385891,35.906684>}
      triangle {<65.868632,-24.385891,35.906684>,<63.865611,-24.385891,36.471580>,<63.865611,-21.405910,36.471580>}
      triangle {<65.868632,-24.385891,35.906684>,<63.865611,-21.405910,36.471580>,<65.868632,-21.405910,35.906684>}
      triangle {<65.868632,-21.405910,35.906684>,<63.865611,-21.405910,36.471580>,<68.023356,-21.405910,51.213744>}
      triangle {<65.868632,-21.405910,35.906684>,<68.023356,-21.405910,51.213744>,<70.026377,-21.405910,50.648833>}
      triangle {<70.026377,-21.405910,50.648833>,<68.023356,-21.405910,51.213744>,<68.023356,-24.385891,51.213744>}
      triangle {<70.026377,-21.405910,50.648833>,<68.023356,-24.385891,51.213744>,<70.026377,-24.385891,50.648833>}
      triangle {<68.023356,-24.385891,51.213744>,<68.023356,-21.405910,51.213744>,<63.865611,-21.405910,36.471580>}
      triangle {<68.023356,-24.385891,51.213744>,<63.865611,-21.405910,36.471580>,<63.865611,-24.385891,36.471580>}
      triangle {<69.728678,-26.206982,54.215751>,<67.587443,-26.206982,46.623511>,<67.587443,-19.584820,46.623511>}
      triangle {<69.728678,-26.206982,54.215751>,<67.587443,-19.584820,46.623511>,<69.728678,-19.584820,54.215751>}
      triangle {<69.728678,-26.206982,54.215751>,<68.842326,-26.206982,54.465743>,<66.701121,-26.206982,46.873496>}
      triangle {<69.728678,-26.206982,54.215751>,<66.701121,-26.206982,46.873496>,<67.587443,-26.206982,46.623511>}
      triangle {<67.587443,-26.206982,46.623511>,<66.701121,-26.206982,46.873496>,<66.701121,-19.584820,46.873496>}
      triangle {<67.587443,-26.206982,46.623511>,<66.701121,-19.584820,46.873496>,<67.587443,-19.584820,46.623511>}
      triangle {<67.587443,-19.584820,46.623511>,<66.701121,-19.584820,46.873496>,<68.842326,-19.584820,54.465743>}
      triangle {<67.587443,-19.584820,46.623511>,<68.842326,-19.584820,54.465743>,<69.728678,-19.584820,54.215751>}
      triangle {<69.728678,-19.584820,54.215751>,<68.842326,-19.584820,54.465743>,<68.842326,-26.206982,54.465743>}
      triangle {<69.728678,-19.584820,54.215751>,<68.842326,-26.206982,54.465743>,<69.728678,-26.206982,54.215751>}
      triangle {<68.842326,-26.206982,54.465743>,<68.842326,-19.584820,54.465743>,<66.701121,-19.584820,46.873496>}
      triangle {<68.842326,-26.206982,54.465743>,<66.701121,-19.584820,46.873496>,<66.701121,-26.206982,46.873496>}
      triangle {<88.811533,-25.561321,117.255965>,<87.636973,-25.561321,113.091277>,<87.636973,-20.230480,113.091277>}
      triangle {<88.811533,-25.561321,117.255965>,<87.636973,-20.230480,113.091277>,<88.811533,-20.230480,117.255965>}
      triangle {<88.811533,-25.561321,117.255965>,<86.808512,-25.561321,117.820861>,<85.633952,-25.561321,113.656173>}
      triangle {<88.811533,-25.561321,117.255965>,<85.633952,-25.561321,113.656173>,<87.636973,-25.561321,113.091277>}
      triangle {<87.636973,-25.561321,113.091277>,<85.633952,-25.561321,113.656173>,<85.633952,-20.230480,113.656173>}
      triangle {<87.636973,-25.561321,113.091277>,<85.633952,-20.230480,113.656173>,<87.636973,-20.230480,113.091277>}
      triangle {<87.636973,-20.230480,113.091277>,<85.633952,-20.230480,113.656173>,<86.808512,-20.230480,117.820861>}
      triangle {<87.636973,-20.230480,113.091277>,<86.808512,-20.230480,117.820861>,<88.811533,-20.230480,117.255965>}
      triangle {<88.811533,-20.230480,117.255965>,<86.808512,-20.230480,117.820861>,<86.808512,-25.561321,117.820861>}
      triangle {<88.811533,-20.230480,117.255965>,<86.808512,-25.561321,117.820861>,<88.811533,-25.561321,117.255965>}
      triangle {<86.808512,-25.561321,117.820861>,<86.808512,-20.230480,117.820861>,<85.633952,-20.230480,113.656173>}
      triangle {<86.808512,-25.561321,117.820861>,<85.633952,-20.230480,113.656173>,<85.633952,-25.561321,113.656173>}
      triangle {<89.537272,-26.206982,124.451705>,<87.396037,-26.206982,116.859447>,<87.396037,-19.584820,116.859447>}
      triangle {<89.537272,-26.206982,124.451705>,<87.396037,-19.584820,116.859447>,<89.537272,-19.584820,124.451705>}
      triangle {<89.537272,-26.206982,124.451705>,<88.650950,-26.206982,124.701674>,<86.509715,-26.206982,117.109431>}
      triangle {<89.537272,-26.206982,124.451705>,<86.509715,-26.206982,117.109431>,<87.396037,-26.206982,116.859447>}
      triangle {<87.396037,-26.206982,116.859447>,<86.509715,-26.206982,117.109431>,<86.509715,-19.584820,117.109431>}
      triangle {<87.396037,-26.206982,116.859447>,<86.509715,-19.584820,117.109431>,<87.396037,-19.584820,116.859447>}
      triangle {<87.396037,-19.584820,116.859447>,<86.509715,-19.584820,117.109431>,<88.650950,-19.584820,124.701674>}
      triangle {<87.396037,-19.584820,116.859447>,<88.650950,-19.584820,124.701674>,<89.537272,-19.584820,124.451705>}
      triangle {<89.537272,-19.584820,124.451705>,<88.650950,-19.584820,124.701674>,<88.650950,-26.206982,124.701674>}
      triangle {<89.537272,-19.584820,124.451705>,<88.650950,-26.206982,124.701674>,<89.537272,-26.206982,124.451705>}
      triangle {<88.650950,-26.206982,124.701674>,<88.650950,-19.584820,124.701674>,<86.509715,-19.584820,117.109431>}
      triangle {<88.650950,-26.206982,124.701674>,<86.509715,-19.584820,117.109431>,<86.509715,-26.206982,117.109431>}
      triangle {<92.010325,-24.551434,128.598113>,<89.931468,-24.551434,121.226993>,<89.931468,-21.240353,121.226993>}
      triangle {<92.010325,-24.551434,128.598113>,<89.931468,-21.240353,121.226993>,<92.010325,-21.240353,128.598113>}
      triangle {<92.010325,-24.551434,128.598113>,<90.007334,-24.551434,129.163016>,<87.928477,-24.551434,121.791892>}
      triangle {<92.010325,-24.551434,128.598113>,<87.928477,-24.551434,121.791892>,<89.931468,-24.551434,121.226993>}
      triangle {<89.931468,-24.551434,121.226993>,<87.928477,-24.551434,121.791892>,<87.928477,-21.240353,121.791892>}
      triangle {<89.931468,-24.551434,121.226993>,<87.928477,-21.240353,121.791892>,<89.931468,-21.240353,121.226993>}
      triangle {<89.931468,-21.240353,121.226993>,<87.928477,-21.240353,121.791892>,<90.007334,-21.240353,129.163016>}
      triangle {<89.931468,-21.240353,121.226993>,<90.007334,-21.240353,129.163016>,<92.010325,-21.240353,128.598113>}
      triangle {<92.010325,-21.240353,128.598113>,<90.007334,-21.240353,129.163016>,<90.007334,-24.551434,129.163016>}
      triangle {<92.010325,-21.240353,128.598113>,<90.007334,-24.551434,129.163016>,<92.010325,-24.551434,128.598113>}
      triangle {<90.007334,-24.551434,129.163016>,<90.007334,-21.240353,129.163016>,<87.928477,-21.240353,121.791892>}
      triangle {<90.007334,-24.551434,129.163016>,<87.928477,-21.240353,121.791892>,<87.928477,-24.551434,121.791892>}
      triangle {<93.716959,-26.206982,139.271796>,<91.575724,-26.206982,131.679568>,<91.575724,-19.584820,131.679568>}
      triangle {<93.716959,-26.206982,139.271796>,<91.575724,-19.584820,131.679568>,<93.716959,-19.584820,139.271796>}
      triangle {<93.716959,-26.206982,139.271796>,<92.830637,-26.206982,139.521766>,<90.689402,-26.206982,131.929538>}
      triangle {<93.716959,-26.206982,139.271796>,<90.689402,-26.206982,131.929538>,<91.575724,-26.206982,131.679568>}
      triangle {<91.575724,-26.206982,131.679568>,<90.689402,-26.206982,131.929538>,<90.689402,-19.584820,131.929538>}
      triangle {<91.575724,-26.206982,131.679568>,<90.689402,-19.584820,131.929538>,<91.575724,-19.584820,131.679568>}
      triangle {<91.575724,-19.584820,131.679568>,<90.689402,-19.584820,131.929538>,<92.830637,-19.584820,139.521766>}
      triangle {<91.575724,-19.584820,131.679568>,<92.830637,-19.584820,139.521766>,<93.716959,-19.584820,139.271796>}
      triangle {<93.716959,-19.584820,139.271796>,<92.830637,-19.584820,139.521766>,<92.830637,-26.206982,139.521766>}
      triangle {<93.716959,-19.584820,139.271796>,<92.830637,-26.206982,139.521766>,<93.716959,-26.206982,139.271796>}
      triangle {<92.830637,-26.206982,139.521766>,<92.830637,-19.584820,139.521766>,<90.689402,-19.584820,131.929538>}
      triangle {<92.830637,-26.206982,139.521766>,<90.689402,-19.584820,131.929538>,<90.689402,-26.206982,131.929538>}
      triangle {<97.836100,-24.385891,149.254745>,<93.678416,-24.385891,134.512553>,<93.678416,-21.405910,134.512553>}
      triangle {<97.836100,-24.385891,149.254745>,<93.678416,-21.405910,134.512553>,<97.836100,-21.405910,149.254745>}
      triangle {<97.836100,-24.385891,149.254745>,<95.833109,-24.385891,149.819648>,<91.675395,-24.385891,135.077449>}
      triangle {<97.836100,-24.385891,149.254745>,<91.675395,-24.385891,135.077449>,<93.678416,-24.385891,134.512553>}
      triangle {<93.678416,-24.385891,134.512553>,<91.675395,-24.385891,135.077449>,<91.675395,-21.405910,135.077449>}
      triangle {<93.678416,-24.385891,134.512553>,<91.675395,-21.405910,135.077449>,<93.678416,-21.405910,134.512553>}
      triangle {<93.678416,-21.405910,134.512553>,<91.675395,-21.405910,135.077449>,<95.833109,-21.405910,149.819648>}
      triangle {<93.678416,-21.405910,134.512553>,<95.833109,-21.405910,149.819648>,<97.836100,-21.405910,149.254745>}
      triangle {<97.836100,-21.405910,149.254745>,<95.833109,-21.405910,149.819648>,<95.833109,-24.385891,149.819648>}
      triangle {<97.836100,-21.405910,149.254745>,<95.833109,-24.385891,149.819648>,<97.836100,-24.385891,149.254745>}
      triangle {<95.833109,-24.385891,149.819648>,<95.833109,-21.405910,149.819648>,<91.675395,-21.405910,135.077449>}
      triangle {<95.833109,-24.385891,149.819648>,<91.675395,-21.405910,135.077449>,<91.675395,-24.385891,135.077449>}
      triangle {<97.538432,-26.206982,152.821603>,<95.397196,-26.206982,145.229392>,<95.397196,-19.584820,145.229392>}
      triangle {<97.538432,-26.206982,152.821603>,<95.397196,-19.584820,145.229392>,<97.538432,-19.584820,152.821603>}
      triangle {<97.538432,-26.206982,152.821603>,<96.652079,-26.206982,153.071565>,<94.510874,-26.206982,145.479360>}
      triangle {<97.538432,-26.206982,152.821603>,<94.510874,-26.206982,145.479360>,<95.397196,-26.206982,145.229392>}
      triangle {<95.397196,-26.206982,145.229392>,<94.510874,-26.206982,145.479360>,<94.510874,-19.584820,145.479360>}
      triangle {<95.397196,-26.206982,145.229392>,<94.510874,-19.584820,145.479360>,<95.397196,-19.584820,145.229392>}
      triangle {<95.397196,-19.584820,145.229392>,<94.510874,-19.584820,145.479360>,<96.652079,-19.584820,153.071565>}
      triangle {<95.397196,-19.584820,145.229392>,<96.652079,-19.584820,153.071565>,<97.538432,-19.584820,152.821603>}
      triangle {<97.538432,-19.584820,152.821603>,<96.652079,-19.584820,153.071565>,<96.652079,-26.206982,153.071565>}
      triangle {<97.538432,-19.584820,152.821603>,<96.652079,-26.206982,153.071565>,<97.538432,-26.206982,152.821603>}
      triangle {<96.652079,-26.206982,153.071565>,<96.652079,-19.584820,153.071565>,<94.510874,-19.584820,145.479360>}
      triangle {<96.652079,-26.206982,153.071565>,<94.510874,-19.584820,145.479360>,<94.510874,-26.206982,145.479360>}
      texture{_Zeug02}
    }
    //_Zeug01
    mesh{
      triangle {<-2.225233,-19.584820,-181.042871>,<-2.225233,-26.206982,-181.042871>,<-94.693162,-26.206982,146.823644>}
      triangle {<-94.693162,-19.584820,146.823644>,<-2.225233,-19.584820,-181.042871>,<-94.693162,-26.206982,146.823644>}
      triangle {<-0.222227,-26.206982,-180.477960>,<-92.690156,-26.206982,147.388541>,<-94.693162,-26.206982,146.823644>}
      triangle {<-2.225233,-26.206982,-181.042871>,<-0.222227,-26.206982,-180.477960>,<-94.693162,-26.206982,146.823644>}
      triangle {<-0.222227,-19.584820,-180.477960>,<-0.222227,-26.206982,-180.477960>,<-2.225233,-26.206982,-181.042871>}
      triangle {<-2.225233,-19.584820,-181.042871>,<-0.222227,-19.584820,-180.477960>,<-2.225233,-26.206982,-181.042871>}
      triangle {<-92.690156,-19.584820,147.388541>,<-0.222227,-19.584820,-180.477960>,<-2.225233,-19.584820,-181.042871>}
      triangle {<-94.693162,-19.584820,146.823644>,<-92.690156,-19.584820,147.388541>,<-2.225233,-19.584820,-181.042871>}
      triangle {<-92.690156,-26.206982,147.388541>,<-92.690156,-19.584820,147.388541>,<-94.693162,-19.584820,146.823644>}
      triangle {<-94.693162,-26.206982,146.823644>,<-92.690156,-26.206982,147.388541>,<-94.693162,-19.584820,146.823644>}
      triangle {<-0.222227,-19.584820,-180.477960>,<-92.690156,-19.584820,147.388541>,<-92.690156,-26.206982,147.388541>}
      triangle {<-0.222227,-26.206982,-180.477960>,<-0.222227,-19.584820,-180.477960>,<-92.690156,-26.206982,147.388541>}
      triangle {<-29.548704,-20.321529,-92.646081>,<-29.548704,-25.470264,-92.646081>,<-31.658697,-25.470264,-85.164453>}
      triangle {<-31.658697,-20.321529,-85.164453>,<-29.548704,-20.321529,-92.646081>,<-31.658697,-25.470264,-85.164453>}
      triangle {<-27.545717,-25.470264,-92.081140>,<-29.655691,-25.470264,-84.599572>,<-31.658697,-25.470264,-85.164453>}
      triangle {<-29.548704,-25.470264,-92.646081>,<-27.545717,-25.470264,-92.081140>,<-31.658697,-25.470264,-85.164453>}
      triangle {<-27.545717,-20.321529,-92.081140>,<-27.545717,-25.470264,-92.081140>,<-29.548704,-25.470264,-92.646081>}
      triangle {<-29.548704,-20.321529,-92.646081>,<-27.545717,-20.321529,-92.081140>,<-29.548704,-25.470264,-92.646081>}
      triangle {<-29.655691,-20.321529,-84.599572>,<-27.545717,-20.321529,-92.081140>,<-29.548704,-20.321529,-92.646081>}
      triangle {<-31.658697,-20.321529,-85.164453>,<-29.655691,-20.321529,-84.599572>,<-29.548704,-20.321529,-92.646081>}
      triangle {<-29.655691,-25.470264,-84.599572>,<-29.655691,-20.321529,-84.599572>,<-31.658697,-20.321529,-85.164453>}
      triangle {<-31.658697,-25.470264,-85.164453>,<-29.655691,-25.470264,-84.599572>,<-31.658697,-20.321529,-85.164453>}
      triangle {<-27.545717,-20.321529,-92.081140>,<-29.655691,-20.321529,-84.599572>,<-29.655691,-25.470264,-84.599572>}
      triangle {<-27.545717,-25.470264,-92.081140>,<-27.545717,-20.321529,-92.081140>,<-29.655691,-25.470264,-84.599572>}
      triangle {<-18.432645,-20.230480,-132.060449>,<-18.432645,-25.561321,-132.060449>,<-19.607206,-25.561321,-127.895867>}
      triangle {<-19.607206,-20.230480,-127.895867>,<-18.432645,-20.230480,-132.060449>,<-19.607206,-25.561321,-127.895867>}
      triangle {<-16.429677,-25.561321,-131.495568>,<-17.604185,-25.561321,-127.330987>,<-19.607206,-25.561321,-127.895867>}
      triangle {<-18.432645,-25.561321,-132.060449>,<-16.429677,-25.561321,-131.495568>,<-19.607206,-25.561321,-127.895867>}
      triangle {<-16.429677,-20.230480,-131.495568>,<-16.429677,-25.561321,-131.495568>,<-18.432645,-25.561321,-132.060449>}
      triangle {<-18.432645,-20.230480,-132.060449>,<-16.429677,-20.230480,-131.495568>,<-18.432645,-25.561321,-132.060449>}
      triangle {<-17.604185,-20.230480,-127.330987>,<-16.429677,-20.230480,-131.495568>,<-18.432645,-20.230480,-132.060449>}
      triangle {<-19.607206,-20.230480,-127.895867>,<-17.604185,-20.230480,-127.330987>,<-18.432645,-20.230480,-132.060449>}
      triangle {<-17.604185,-25.561321,-127.330987>,<-17.604185,-20.230480,-127.330987>,<-19.607206,-20.230480,-127.895867>}
      triangle {<-19.607206,-25.561321,-127.895867>,<-17.604185,-25.561321,-127.330987>,<-19.607206,-20.230480,-127.895867>}
      triangle {<-16.429677,-20.230480,-131.495568>,<-17.604185,-20.230480,-127.330987>,<-17.604185,-25.561321,-127.330987>}
      triangle {<-16.429677,-25.561321,-131.495568>,<-16.429677,-20.230480,-131.495568>,<-17.604185,-25.561321,-127.330987>}
      triangle {<-18.191740,-19.584820,-128.292291>,<-18.191740,-26.206982,-128.292291>,<-20.332960,-26.206982,-120.700128>}
      triangle {<-20.332960,-19.584820,-120.700128>,<-18.191740,-19.584820,-128.292291>,<-20.332960,-26.206982,-120.700128>}
      triangle {<-17.305425,-26.206982,-128.042321>,<-19.446676,-26.206982,-120.450067>,<-20.332960,-26.206982,-120.700128>}
      triangle {<-18.191740,-26.206982,-128.292291>,<-17.305425,-26.206982,-128.042321>,<-20.332960,-26.206982,-120.700128>}
      triangle {<-17.305425,-19.584820,-128.042321>,<-17.305425,-26.206982,-128.042321>,<-18.191740,-26.206982,-128.292291>}
      triangle {<-18.191740,-19.584820,-128.292291>,<-17.305425,-19.584820,-128.042321>,<-18.191740,-26.206982,-128.292291>}
      triangle {<-19.446676,-19.584820,-120.450067>,<-17.305425,-19.584820,-128.042321>,<-18.191740,-19.584820,-128.292291>}
      triangle {<-20.332960,-19.584820,-120.700128>,<-19.446676,-19.584820,-120.450067>,<-18.191740,-19.584820,-128.292291>}
      triangle {<-19.446676,-26.206982,-120.450067>,<-19.446676,-19.584820,-120.450067>,<-20.332960,-19.584820,-120.700128>}
      triangle {<-20.332960,-26.206982,-120.700128>,<-19.446676,-26.206982,-120.450067>,<-20.332960,-19.584820,-120.700128>}
      triangle {<-17.305425,-19.584820,-128.042321>,<-19.446676,-19.584820,-120.450067>,<-19.446676,-26.206982,-120.450067>}
      triangle {<-17.305425,-26.206982,-128.042321>,<-17.305425,-19.584820,-128.042321>,<-19.446676,-26.206982,-120.450067>}
      triangle {<-20.727155,-21.240353,-123.924798>,<-20.727155,-24.551434,-123.924798>,<-22.806013,-24.551434,-116.553674>}
      triangle {<-22.806013,-21.240353,-116.553674>,<-20.727155,-21.240353,-123.924798>,<-22.806013,-24.551434,-116.553674>}
      triangle {<-18.724142,-24.551434,-123.359918>,<-20.803030,-24.551434,-115.988793>,<-22.806013,-24.551434,-116.553674>}
      triangle {<-20.727155,-24.551434,-123.924798>,<-18.724142,-24.551434,-123.359918>,<-22.806013,-24.551434,-116.553674>}
      triangle {<-18.724142,-21.240353,-123.359918>,<-18.724142,-24.551434,-123.359918>,<-20.727155,-24.551434,-123.924798>}
      triangle {<-20.727155,-21.240353,-123.924798>,<-18.724142,-21.240353,-123.359918>,<-20.727155,-24.551434,-123.924798>}
      triangle {<-20.803030,-21.240353,-115.988793>,<-18.724142,-21.240353,-123.359918>,<-20.727155,-21.240353,-123.924798>}
      triangle {<-22.806013,-21.240353,-116.553674>,<-20.803030,-21.240353,-115.988793>,<-20.727155,-21.240353,-123.924798>}
      triangle {<-20.803030,-24.551434,-115.988793>,<-20.803030,-21.240353,-115.988793>,<-22.806013,-21.240353,-116.553674>}
      triangle {<-22.806013,-24.551434,-116.553674>,<-20.803030,-24.551434,-115.988793>,<-22.806013,-21.240353,-116.553674>}
      triangle {<-18.724142,-21.240353,-123.359918>,<-20.803030,-21.240353,-115.988793>,<-20.803030,-24.551434,-115.988793>}
      triangle {<-18.724142,-24.551434,-123.359918>,<-18.724142,-21.240353,-123.359918>,<-20.803030,-24.551434,-115.988793>}
      triangle {<-22.371435,-19.584820,-113.472283>,<-22.371435,-26.206982,-113.472283>,<-24.512655,-26.206982,-105.879968>}
      triangle {<-24.512655,-19.584820,-105.879968>,<-22.371435,-19.584820,-113.472283>,<-24.512655,-26.206982,-105.879968>}
      triangle {<-21.485090,-26.206982,-113.222253>,<-23.626356,-26.206982,-105.629998>,<-24.512655,-26.206982,-105.879968>}
      triangle {<-22.371435,-26.206982,-113.472283>,<-21.485090,-26.206982,-113.222253>,<-24.512655,-26.206982,-105.879968>}
      triangle {<-21.485090,-19.584820,-113.222253>,<-21.485090,-26.206982,-113.222253>,<-22.371435,-26.206982,-113.472283>}
      triangle {<-22.371435,-19.584820,-113.472283>,<-21.485090,-19.584820,-113.222253>,<-22.371435,-26.206982,-113.472283>}
      triangle {<-23.626356,-19.584820,-105.629998>,<-21.485090,-19.584820,-113.222253>,<-22.371435,-19.584820,-113.472283>}
      triangle {<-24.512655,-19.584820,-105.879968>,<-23.626356,-19.584820,-105.629998>,<-22.371435,-19.584820,-113.472283>}
      triangle {<-23.626356,-26.206982,-105.629998>,<-23.626356,-19.584820,-105.629998>,<-24.512655,-19.584820,-105.879968>}
      triangle {<-24.512655,-26.206982,-105.879968>,<-23.626356,-26.206982,-105.629998>,<-24.512655,-19.584820,-105.879968>}
      triangle {<-21.485090,-19.584820,-113.222253>,<-23.626356,-19.584820,-105.629998>,<-23.626356,-26.206982,-105.629998>}
      triangle {<-21.485090,-26.206982,-113.222253>,<-21.485090,-19.584820,-113.222253>,<-23.626356,-26.206982,-105.629998>}
      triangle {<-24.474073,-21.405910,-110.639215>,<-24.474073,-24.385891,-110.639215>,<-28.631841,-24.385891,-95.896996>}
      triangle {<-28.631841,-21.405910,-95.896996>,<-24.474073,-21.405910,-110.639215>,<-28.631841,-24.385891,-95.896996>}
      triangle {<-22.471067,-24.385891,-110.074304>,<-26.628873,-24.385891,-95.332025>,<-28.631841,-24.385891,-95.896996>}
      triangle {<-24.474073,-24.385891,-110.639215>,<-22.471067,-24.385891,-110.074304>,<-28.631841,-24.385891,-95.896996>}
      triangle {<-22.471067,-21.405910,-110.074304>,<-22.471067,-24.385891,-110.074304>,<-24.474073,-24.385891,-110.639215>}
      triangle {<-24.474073,-21.405910,-110.639215>,<-22.471067,-21.405910,-110.074304>,<-24.474073,-24.385891,-110.639215>}
      triangle {<-26.628873,-21.405910,-95.332025>,<-22.471067,-21.405910,-110.074304>,<-24.474073,-21.405910,-110.639215>}
      triangle {<-28.631841,-21.405910,-95.896996>,<-26.628873,-21.405910,-95.332025>,<-24.474073,-21.405910,-110.639215>}
      triangle {<-26.628873,-24.385891,-95.332025>,<-26.628873,-21.405910,-95.332025>,<-28.631841,-21.405910,-95.896996>}
      triangle {<-28.631841,-24.385891,-95.896996>,<-26.628873,-24.385891,-95.332025>,<-28.631841,-21.405910,-95.896996>}
      triangle {<-22.471067,-21.405910,-110.074304>,<-26.628873,-21.405910,-95.332025>,<-26.628873,-24.385891,-95.332025>}
      triangle {<-22.471067,-24.385891,-110.074304>,<-22.471067,-21.405910,-110.074304>,<-26.628873,-24.385891,-95.332025>}
      triangle {<-26.192895,-19.584820,-99.922326>,<-26.192895,-26.206982,-99.922326>,<-28.334119,-26.206982,-92.330163>}
      triangle {<-28.334119,-19.584820,-92.330163>,<-26.192895,-19.584820,-99.922326>,<-28.334119,-26.206982,-92.330163>}
      triangle {<-25.306547,-26.206982,-99.672418>,<-27.447820,-26.206982,-92.080163>,<-28.334119,-26.206982,-92.330163>}
      triangle {<-26.192895,-26.206982,-99.922326>,<-25.306547,-26.206982,-99.672418>,<-28.334119,-26.206982,-92.330163>}
      triangle {<-25.306547,-19.584820,-99.672418>,<-25.306547,-26.206982,-99.672418>,<-26.192895,-26.206982,-99.922326>}
      triangle {<-26.192895,-19.584820,-99.922326>,<-25.306547,-19.584820,-99.672418>,<-26.192895,-26.206982,-99.922326>}
      triangle {<-27.447820,-19.584820,-92.080163>,<-25.306547,-19.584820,-99.672418>,<-26.192895,-19.584820,-99.922326>}
      triangle {<-28.334119,-19.584820,-92.330163>,<-27.447820,-19.584820,-92.080163>,<-26.192895,-19.584820,-99.922326>}
      triangle {<-27.447820,-26.206982,-92.080163>,<-27.447820,-19.584820,-92.080163>,<-28.334119,-19.584820,-92.330163>}
      triangle {<-28.334119,-26.206982,-92.330163>,<-27.447820,-26.206982,-92.080163>,<-28.334119,-19.584820,-92.330163>}
      triangle {<-25.306547,-19.584820,-99.672418>,<-27.447820,-19.584820,-92.080163>,<-27.447820,-26.206982,-92.080163>}
      triangle {<-25.306547,-26.206982,-99.672418>,<-25.306547,-19.584820,-99.672418>,<-27.447820,-26.206982,-92.080163>}
      triangle {<-15.576543,-20.321529,-142.187615>,<-15.576543,-25.470264,-142.187615>,<-17.686536,-25.470264,-134.705987>}
      triangle {<-17.686536,-20.321529,-134.705987>,<-15.576543,-20.321529,-142.187615>,<-17.686536,-25.470264,-134.705987>}
      triangle {<-13.573499,-25.470264,-141.622766>,<-15.683546,-25.470264,-134.141076>,<-17.686536,-25.470264,-134.705987>}
      triangle {<-15.576543,-25.470264,-142.187615>,<-13.573499,-25.470264,-141.622766>,<-17.686536,-25.470264,-134.705987>}
      triangle {<-13.573499,-20.321529,-141.622766>,<-13.573499,-25.470264,-141.622766>,<-15.576543,-25.470264,-142.187615>}
      triangle {<-15.576543,-20.321529,-142.187615>,<-13.573499,-20.321529,-141.622766>,<-15.576543,-25.470264,-142.187615>}
      triangle {<-15.683546,-20.321529,-134.141076>,<-13.573499,-20.321529,-141.622766>,<-15.576543,-20.321529,-142.187615>}
      triangle {<-17.686536,-20.321529,-134.705987>,<-15.683546,-20.321529,-134.141076>,<-15.576543,-20.321529,-142.187615>}
      triangle {<-15.683546,-25.470264,-134.141076>,<-15.683546,-20.321529,-134.141076>,<-17.686536,-20.321529,-134.705987>}
      triangle {<-17.686536,-25.470264,-134.705987>,<-15.683546,-25.470264,-134.141076>,<-17.686536,-20.321529,-134.705987>}
      triangle {<-13.573499,-20.321529,-141.622766>,<-15.683546,-20.321529,-134.141076>,<-15.683546,-25.470264,-134.141076>}
      triangle {<-13.573499,-25.470264,-141.622766>,<-13.573499,-20.321529,-141.622766>,<-15.683546,-25.470264,-134.141076>}
      triangle {<-4.460500,-20.230480,-181.602075>,<-4.460500,-25.561321,-181.602075>,<-5.635084,-25.561321,-177.437280>}
      triangle {<-5.635084,-20.230480,-177.437280>,<-4.460500,-20.230480,-181.602075>,<-5.635084,-25.561321,-177.437280>}
      triangle {<-2.457601,-25.561321,-181.037072>,<-3.632101,-25.561321,-176.872399>,<-5.635084,-25.561321,-177.437280>}
      triangle {<-4.460500,-25.561321,-181.602075>,<-2.457601,-25.561321,-181.037072>,<-5.635084,-25.561321,-177.437280>}
      triangle {<-2.457601,-20.230480,-181.037072>,<-2.457601,-25.561321,-181.037072>,<-4.460500,-25.561321,-181.602075>}
      triangle {<-4.460500,-20.230480,-181.602075>,<-2.457601,-20.230480,-181.037072>,<-4.460500,-25.561321,-181.602075>}
      triangle {<-3.632101,-20.230480,-176.872399>,<-2.457601,-20.230480,-181.037072>,<-4.460500,-20.230480,-181.602075>}
      triangle {<-5.635084,-20.230480,-177.437280>,<-3.632101,-20.230480,-176.872399>,<-4.460500,-20.230480,-181.602075>}
      triangle {<-3.632101,-25.561321,-176.872399>,<-3.632101,-20.230480,-176.872399>,<-5.635084,-20.230480,-177.437280>}
      triangle {<-5.635084,-25.561321,-177.437280>,<-3.632101,-25.561321,-176.872399>,<-5.635084,-20.230480,-177.437280>}
      triangle {<-2.457601,-20.230480,-181.037072>,<-3.632101,-20.230480,-176.872399>,<-3.632101,-25.561321,-176.872399>}
      triangle {<-2.457601,-25.561321,-181.037072>,<-2.457601,-20.230480,-181.037072>,<-3.632101,-25.561321,-176.872399>}
      triangle {<-4.219625,-19.584820,-177.833825>,<-4.219625,-26.206982,-177.833825>,<-6.360845,-26.206982,-170.241601>}
      triangle {<-6.360845,-19.584820,-170.241601>,<-4.219625,-19.584820,-177.833825>,<-6.360845,-26.206982,-170.241601>}
      triangle {<-3.333318,-26.206982,-177.583856>,<-5.474523,-26.206982,-169.991662>,<-6.360845,-26.206982,-170.241601>}
      triangle {<-4.219625,-26.206982,-177.833825>,<-3.333318,-26.206982,-177.583856>,<-6.360845,-26.206982,-170.241601>}
      triangle {<-3.333318,-19.584820,-177.583856>,<-3.333318,-26.206982,-177.583856>,<-4.219625,-26.206982,-177.833825>}
      triangle {<-4.219625,-19.584820,-177.833825>,<-3.333318,-19.584820,-177.583856>,<-4.219625,-26.206982,-177.833825>}
      triangle {<-5.474523,-19.584820,-169.991662>,<-3.333318,-19.584820,-177.583856>,<-4.219625,-19.584820,-177.833825>}
      triangle {<-6.360845,-19.584820,-170.241601>,<-5.474523,-19.584820,-169.991662>,<-4.219625,-19.584820,-177.833825>}
      triangle {<-5.474523,-26.206982,-169.991662>,<-5.474523,-19.584820,-169.991662>,<-6.360845,-19.584820,-170.241601>}
      triangle {<-6.360845,-26.206982,-170.241601>,<-5.474523,-26.206982,-169.991662>,<-6.360845,-19.584820,-170.241601>}
      triangle {<-3.333318,-19.584820,-177.583856>,<-5.474523,-19.584820,-169.991662>,<-5.474523,-26.206982,-169.991662>}
      triangle {<-3.333318,-26.206982,-177.583856>,<-3.333318,-19.584820,-177.583856>,<-5.474523,-26.206982,-169.991662>}
      triangle {<-6.755041,-21.240353,-173.466271>,<-6.755041,-24.551434,-173.466271>,<-8.833890,-24.551434,-166.095086>}
      triangle {<-8.833890,-21.240353,-166.095086>,<-6.755041,-21.240353,-173.466271>,<-8.833890,-24.551434,-166.095086>}
      triangle {<-4.752126,-24.551434,-172.901361>,<-6.830892,-24.551434,-165.530297>,<-8.833890,-24.551434,-166.095086>}
      triangle {<-6.755041,-24.551434,-173.466271>,<-4.752126,-24.551434,-172.901361>,<-8.833890,-24.551434,-166.095086>}
      triangle {<-4.752126,-21.240353,-172.901361>,<-4.752126,-24.551434,-172.901361>,<-6.755041,-24.551434,-173.466271>}
      triangle {<-6.755041,-21.240353,-173.466271>,<-4.752126,-21.240353,-172.901361>,<-6.755041,-24.551434,-173.466271>}
      triangle {<-6.830892,-21.240353,-165.530297>,<-4.752126,-21.240353,-172.901361>,<-6.755041,-21.240353,-173.466271>}
      triangle {<-8.833890,-21.240353,-166.095086>,<-6.830892,-21.240353,-165.530297>,<-6.755041,-21.240353,-173.466271>}
      triangle {<-6.830892,-24.551434,-165.530297>,<-6.830892,-21.240353,-165.530297>,<-8.833890,-21.240353,-166.095086>}
      triangle {<-8.833890,-24.551434,-166.095086>,<-6.830892,-24.551434,-165.530297>,<-8.833890,-21.240353,-166.095086>}
      triangle {<-4.752126,-21.240353,-172.901361>,<-6.830892,-21.240353,-165.530297>,<-6.830892,-24.551434,-165.530297>}
      triangle {<-4.752126,-24.551434,-172.901361>,<-4.752126,-21.240353,-172.901361>,<-6.830892,-24.551434,-165.530297>}
      triangle {<-8.399297,-19.584820,-163.013696>,<-8.399297,-26.206982,-163.013696>,<-10.540548,-26.206982,-155.421472>}
      triangle {<-10.540548,-19.584820,-155.421472>,<-8.399297,-19.584820,-163.013696>,<-10.540548,-26.206982,-155.421472>}
      triangle {<-7.512975,-26.206982,-162.763787>,<-9.654211,-26.206982,-155.171533>,<-10.540548,-26.206982,-155.421472>}
      triangle {<-8.399297,-26.206982,-163.013696>,<-7.512975,-26.206982,-162.763787>,<-10.540548,-26.206982,-155.421472>}
      triangle {<-7.512975,-19.584820,-162.763787>,<-7.512975,-26.206982,-162.763787>,<-8.399297,-26.206982,-163.013696>}
      triangle {<-8.399297,-19.584820,-163.013696>,<-7.512975,-19.584820,-162.763787>,<-8.399297,-26.206982,-163.013696>}
      triangle {<-9.654211,-19.584820,-155.171533>,<-7.512975,-19.584820,-162.763787>,<-8.399297,-19.584820,-163.013696>}
      triangle {<-10.540548,-19.584820,-155.421472>,<-9.654211,-19.584820,-155.171533>,<-8.399297,-19.584820,-163.013696>}
      triangle {<-9.654211,-26.206982,-155.171533>,<-9.654211,-19.584820,-155.171533>,<-10.540548,-19.584820,-155.421472>}
      triangle {<-10.540548,-26.206982,-155.421472>,<-9.654211,-26.206982,-155.171533>,<-10.540548,-19.584820,-155.421472>}
      triangle {<-7.512975,-19.584820,-162.763787>,<-9.654211,-19.584820,-155.171533>,<-9.654211,-26.206982,-155.171533>}
      triangle {<-7.512975,-26.206982,-162.763787>,<-7.512975,-19.584820,-162.763787>,<-9.654211,-26.206982,-155.171533>}
      triangle {<-10.501958,-21.405910,-160.180718>,<-10.501958,-24.385891,-160.180718>,<-14.659673,-24.385891,-145.438531>}
      triangle {<-14.659673,-21.405910,-145.438531>,<-10.501958,-21.405910,-160.180718>,<-14.659673,-24.385891,-145.438531>}
      triangle {<-8.498930,-24.385891,-159.615838>,<-12.656744,-24.385891,-144.873681>,<-14.659673,-24.385891,-145.438531>}
      triangle {<-10.501958,-24.385891,-160.180718>,<-8.498930,-24.385891,-159.615838>,<-14.659673,-24.385891,-145.438531>}
      triangle {<-8.498930,-21.405910,-159.615838>,<-8.498930,-24.385891,-159.615838>,<-10.501958,-24.385891,-160.180718>}
      triangle {<-10.501958,-21.405910,-160.180718>,<-8.498930,-21.405910,-159.615838>,<-10.501958,-24.385891,-160.180718>}
      triangle {<-12.656744,-21.405910,-144.873681>,<-8.498930,-21.405910,-159.615838>,<-10.501958,-21.405910,-160.180718>}
      triangle {<-14.659673,-21.405910,-145.438531>,<-12.656744,-21.405910,-144.873681>,<-10.501958,-21.405910,-160.180718>}
      triangle {<-12.656744,-24.385891,-144.873681>,<-12.656744,-21.405910,-144.873681>,<-14.659673,-21.405910,-145.438531>}
      triangle {<-14.659673,-24.385891,-145.438531>,<-12.656744,-24.385891,-144.873681>,<-14.659673,-21.405910,-145.438531>}
      triangle {<-8.498930,-21.405910,-159.615838>,<-12.656744,-21.405910,-144.873681>,<-12.656744,-24.385891,-144.873681>}
      triangle {<-8.498930,-24.385891,-159.615838>,<-8.498930,-21.405910,-159.615838>,<-12.656744,-24.385891,-144.873681>}
      triangle {<-12.220769,-19.584820,-149.463861>,<-12.220769,-26.206982,-149.463861>,<-14.361989,-26.206982,-141.871636>}
      triangle {<-14.361989,-19.584820,-141.871636>,<-12.220769,-19.584820,-149.463861>,<-14.361989,-26.206982,-141.871636>}
      triangle {<-11.334447,-26.206982,-149.213891>,<-13.475637,-26.206982,-141.621728>,<-14.361989,-26.206982,-141.871636>}
      triangle {<-12.220769,-26.206982,-149.463861>,<-11.334447,-26.206982,-149.213891>,<-14.361989,-26.206982,-141.871636>}
      triangle {<-11.334447,-19.584820,-149.213891>,<-11.334447,-26.206982,-149.213891>,<-12.220769,-26.206982,-149.463861>}
      triangle {<-12.220769,-19.584820,-149.463861>,<-11.334447,-19.584820,-149.213891>,<-12.220769,-26.206982,-149.463861>}
      triangle {<-13.475637,-19.584820,-141.621728>,<-11.334447,-19.584820,-149.213891>,<-12.220769,-19.584820,-149.463861>}
      triangle {<-14.361989,-19.584820,-141.871636>,<-13.475637,-19.584820,-141.621728>,<-12.220769,-19.584820,-149.463861>}
      triangle {<-13.475637,-26.206982,-141.621728>,<-13.475637,-19.584820,-141.621728>,<-14.361989,-19.584820,-141.871636>}
      triangle {<-14.361989,-26.206982,-141.871636>,<-13.475637,-26.206982,-141.621728>,<-14.361989,-19.584820,-141.871636>}
      triangle {<-11.334447,-19.584820,-149.213891>,<-13.475637,-19.584820,-141.621728>,<-13.475637,-26.206982,-141.621728>}
      triangle {<-11.334447,-26.206982,-149.213891>,<-11.334447,-19.584820,-149.213891>,<-13.475637,-26.206982,-141.621728>}
      triangle {<-57.244951,-20.321529,5.557288>,<-57.244951,-25.470264,5.557288>,<-59.354970,-25.470264,13.038917>}
      triangle {<-59.354970,-20.321529,13.038917>,<-57.244951,-20.321529,5.557288>,<-59.354970,-25.470264,13.038917>}
      triangle {<-55.241945,-25.470264,6.122169>,<-57.351915,-25.470264,13.603827>,<-59.354970,-25.470264,13.038917>}
      triangle {<-57.244951,-25.470264,5.557288>,<-55.241945,-25.470264,6.122169>,<-59.354970,-25.470264,13.038917>}
      triangle {<-55.241945,-20.321529,6.122169>,<-55.241945,-25.470264,6.122169>,<-57.244951,-25.470264,5.557288>}
      triangle {<-57.244951,-20.321529,5.557288>,<-55.241945,-20.321529,6.122169>,<-57.244951,-25.470264,5.557288>}
      triangle {<-57.351915,-20.321529,13.603827>,<-55.241945,-20.321529,6.122169>,<-57.244951,-20.321529,5.557288>}
      triangle {<-59.354970,-20.321529,13.038917>,<-57.351915,-20.321529,13.603827>,<-57.244951,-20.321529,5.557288>}
      triangle {<-57.351915,-25.470264,13.603827>,<-57.351915,-20.321529,13.603827>,<-59.354970,-20.321529,13.038917>}
      triangle {<-59.354970,-25.470264,13.038917>,<-57.351915,-25.470264,13.603827>,<-59.354970,-20.321529,13.038917>}
      triangle {<-55.241945,-20.321529,6.122169>,<-57.351915,-20.321529,13.603827>,<-57.351915,-25.470264,13.603827>}
      triangle {<-55.241945,-25.470264,6.122169>,<-55.241945,-20.321529,6.122169>,<-57.351915,-25.470264,13.603827>}
      triangle {<-46.128908,-20.230480,-33.857141>,<-46.128908,-25.561321,-33.857141>,<-47.303503,-25.561321,-29.692452>}
      triangle {<-47.303503,-20.230480,-29.692452>,<-46.128908,-20.230480,-33.857141>,<-47.303503,-25.561321,-29.692452>}
      triangle {<-44.126028,-25.561321,-33.292230>,<-45.300527,-25.561321,-29.127557>,<-47.303503,-25.561321,-29.692452>}
      triangle {<-46.128908,-25.561321,-33.857141>,<-44.126028,-25.561321,-33.292230>,<-47.303503,-25.561321,-29.692452>}
      triangle {<-44.126028,-20.230480,-33.292230>,<-44.126028,-25.561321,-33.292230>,<-46.128908,-25.561321,-33.857141>}
      triangle {<-46.128908,-20.230480,-33.857141>,<-44.126028,-20.230480,-33.292230>,<-46.128908,-25.561321,-33.857141>}
      triangle {<-45.300527,-20.230480,-29.127557>,<-44.126028,-20.230480,-33.292230>,<-46.128908,-20.230480,-33.857141>}
      triangle {<-47.303503,-20.230480,-29.692452>,<-45.300527,-20.230480,-29.127557>,<-46.128908,-20.230480,-33.857141>}
      triangle {<-45.300527,-25.561321,-29.127557>,<-45.300527,-20.230480,-29.127557>,<-47.303503,-20.230480,-29.692452>}
      triangle {<-47.303503,-25.561321,-29.692452>,<-45.300527,-25.561321,-29.127557>,<-47.303503,-20.230480,-29.692452>}
      triangle {<-44.126028,-20.230480,-33.292230>,<-45.300527,-20.230480,-29.127557>,<-45.300527,-25.561321,-29.127557>}
      triangle {<-44.126028,-25.561321,-33.292230>,<-44.126028,-20.230480,-33.292230>,<-45.300527,-25.561321,-29.127557>}
      triangle {<-45.888006,-19.584820,-30.088952>,<-45.888006,-26.206982,-30.088952>,<-48.029329,-26.206982,-22.496697>}
      triangle {<-48.029329,-19.584820,-22.496697>,<-45.888006,-19.584820,-30.088952>,<-48.029329,-26.206982,-22.496697>}
      triangle {<-45.001691,-26.206982,-29.838998>,<-47.142976,-26.206982,-22.246743>,<-48.029329,-26.206982,-22.496697>}
      triangle {<-45.888006,-26.206982,-30.088952>,<-45.001691,-26.206982,-29.838998>,<-48.029329,-26.206982,-22.496697>}
      triangle {<-45.001691,-19.584820,-29.838998>,<-45.001691,-26.206982,-29.838998>,<-45.888006,-26.206982,-30.088952>}
      triangle {<-45.888006,-19.584820,-30.088952>,<-45.001691,-19.584820,-29.838998>,<-45.888006,-26.206982,-30.088952>}
      triangle {<-47.142976,-19.584820,-22.246743>,<-45.001691,-19.584820,-29.838998>,<-45.888006,-19.584820,-30.088952>}
      triangle {<-48.029329,-19.584820,-22.496697>,<-47.142976,-19.584820,-22.246743>,<-45.888006,-19.584820,-30.088952>}
      triangle {<-47.142976,-26.206982,-22.246743>,<-47.142976,-19.584820,-22.246743>,<-48.029329,-19.584820,-22.496697>}
      triangle {<-48.029329,-26.206982,-22.496697>,<-47.142976,-26.206982,-22.246743>,<-48.029329,-19.584820,-22.496697>}
      triangle {<-45.001691,-19.584820,-29.838998>,<-47.142976,-19.584820,-22.246743>,<-47.142976,-26.206982,-22.246743>}
      triangle {<-45.001691,-26.206982,-29.838998>,<-45.001691,-19.584820,-29.838998>,<-47.142976,-26.206982,-22.246743>}
      triangle {<-48.423540,-21.240353,-25.721414>,<-48.423540,-24.551434,-25.721414>,<-50.502267,-24.551434,-18.350305>}
      triangle {<-50.502267,-21.240353,-18.350305>,<-48.423540,-21.240353,-25.721414>,<-50.502267,-24.551434,-18.350305>}
      triangle {<-46.420534,-24.551434,-25.156487>,<-48.499391,-24.551434,-17.785394>,<-50.502267,-24.551434,-18.350305>}
      triangle {<-48.423540,-24.551434,-25.721414>,<-46.420534,-24.551434,-25.156487>,<-50.502267,-24.551434,-18.350305>}
      triangle {<-46.420534,-21.240353,-25.156487>,<-46.420534,-24.551434,-25.156487>,<-48.423540,-24.551434,-25.721414>}
      triangle {<-48.423540,-21.240353,-25.721414>,<-46.420534,-21.240353,-25.156487>,<-48.423540,-24.551434,-25.721414>}
      triangle {<-48.499391,-21.240353,-17.785394>,<-46.420534,-21.240353,-25.156487>,<-48.423540,-21.240353,-25.721414>}
      triangle {<-50.502267,-21.240353,-18.350305>,<-48.499391,-21.240353,-17.785394>,<-48.423540,-21.240353,-25.721414>}
      triangle {<-48.499391,-24.551434,-17.785394>,<-48.499391,-21.240353,-17.785394>,<-50.502267,-21.240353,-18.350305>}
      triangle {<-50.502267,-24.551434,-18.350305>,<-48.499391,-24.551434,-17.785394>,<-50.502267,-21.240353,-18.350305>}
      triangle {<-46.420534,-21.240353,-25.156487>,<-48.499391,-21.240353,-17.785394>,<-48.499391,-24.551434,-17.785394>}
      triangle {<-46.420534,-24.551434,-25.156487>,<-46.420534,-21.240353,-25.156487>,<-48.499391,-24.551434,-17.785394>}
      triangle {<-50.067796,-19.584820,-15.268853>,<-50.067796,-26.206982,-15.268853>,<-52.208887,-26.206982,-7.676629>}
      triangle {<-52.208887,-19.584820,-7.676629>,<-50.067796,-19.584820,-15.268853>,<-52.208887,-26.206982,-7.676629>}
      triangle {<-49.181474,-26.206982,-15.018868>,<-51.322580,-26.206982,-7.426644>,<-52.208887,-26.206982,-7.676629>}
      triangle {<-50.067796,-26.206982,-15.268853>,<-49.181474,-26.206982,-15.018868>,<-52.208887,-26.206982,-7.676629>}
      triangle {<-49.181474,-19.584820,-15.018868>,<-49.181474,-26.206982,-15.018868>,<-50.067796,-26.206982,-15.268853>}
      triangle {<-50.067796,-19.584820,-15.268853>,<-49.181474,-19.584820,-15.018868>,<-50.067796,-26.206982,-15.268853>}
      triangle {<-51.322580,-19.584820,-7.426644>,<-49.181474,-19.584820,-15.018868>,<-50.067796,-19.584820,-15.268853>}
      triangle {<-52.208887,-19.584820,-7.676629>,<-51.322580,-19.584820,-7.426644>,<-50.067796,-19.584820,-15.268853>}
      triangle {<-51.322580,-26.206982,-7.426644>,<-51.322580,-19.584820,-7.426644>,<-52.208887,-19.584820,-7.676629>}
      triangle {<-52.208887,-26.206982,-7.676629>,<-51.322580,-26.206982,-7.426644>,<-52.208887,-19.584820,-7.676629>}
      triangle {<-49.181474,-19.584820,-15.018868>,<-51.322580,-19.584820,-7.426644>,<-51.322580,-26.206982,-7.426644>}
      triangle {<-49.181474,-26.206982,-15.018868>,<-49.181474,-19.584820,-15.018868>,<-51.322580,-26.206982,-7.426644>}
      triangle {<-52.170297,-21.405910,-12.435906>,<-52.170297,-24.385891,-12.435906>,<-56.328096,-24.385891,2.306327>}
      triangle {<-56.328096,-21.405910,2.306327>,<-52.170297,-21.405910,-12.435906>,<-56.328096,-24.385891,2.306327>}
      triangle {<-50.167390,-24.385891,-11.870996>,<-54.325021,-24.385891,2.871253>,<-56.328096,-24.385891,2.306327>}
      triangle {<-52.170297,-24.385891,-12.435906>,<-50.167390,-24.385891,-11.870996>,<-56.328096,-24.385891,2.306327>}
      triangle {<-50.167390,-21.405910,-11.870996>,<-50.167390,-24.385891,-11.870996>,<-52.170297,-24.385891,-12.435906>}
      triangle {<-52.170297,-21.405910,-12.435906>,<-50.167390,-21.405910,-11.870996>,<-52.170297,-24.385891,-12.435906>}
      triangle {<-54.325021,-21.405910,2.871253>,<-50.167390,-21.405910,-11.870996>,<-52.170297,-21.405910,-12.435906>}
      triangle {<-56.328096,-21.405910,2.306327>,<-54.325021,-21.405910,2.871253>,<-52.170297,-21.405910,-12.435906>}
      triangle {<-54.325021,-24.385891,2.871253>,<-54.325021,-21.405910,2.871253>,<-56.328096,-21.405910,2.306327>}
      triangle {<-56.328096,-24.385891,2.306327>,<-54.325021,-24.385891,2.871253>,<-56.328096,-21.405910,2.306327>}
      triangle {<-50.167390,-21.405910,-11.870996>,<-54.325021,-21.405910,2.871253>,<-54.325021,-24.385891,2.871253>}
      triangle {<-50.167390,-24.385891,-11.870996>,<-50.167390,-21.405910,-11.870996>,<-54.325021,-24.385891,2.871253>}
      triangle {<-53.889089,-19.584820,-1.719064>,<-53.889089,-26.206982,-1.719064>,<-56.030397,-26.206982,5.873191>}
      triangle {<-56.030397,-19.584820,5.873191>,<-53.889089,-19.584820,-1.719064>,<-56.030397,-26.206982,5.873191>}
      triangle {<-53.002752,-26.206982,-1.469094>,<-55.144002,-26.206982,6.123160>,<-56.030397,-26.206982,5.873191>}
      triangle {<-53.889089,-26.206982,-1.719064>,<-53.002752,-26.206982,-1.469094>,<-56.030397,-26.206982,5.873191>}
      triangle {<-53.002752,-19.584820,-1.469094>,<-53.002752,-26.206982,-1.469094>,<-53.889089,-26.206982,-1.719064>}
      triangle {<-53.889089,-19.584820,-1.719064>,<-53.002752,-19.584820,-1.469094>,<-53.889089,-26.206982,-1.719064>}
      triangle {<-55.144002,-19.584820,6.123160>,<-53.002752,-19.584820,-1.469094>,<-53.889089,-19.584820,-1.719064>}
      triangle {<-56.030397,-19.584820,5.873191>,<-55.144002,-19.584820,6.123160>,<-53.889089,-19.584820,-1.719064>}
      triangle {<-55.144002,-26.206982,6.123160>,<-55.144002,-19.584820,6.123160>,<-56.030397,-19.584820,5.873191>}
      triangle {<-56.030397,-26.206982,5.873191>,<-55.144002,-26.206982,6.123160>,<-56.030397,-19.584820,5.873191>}
      triangle {<-53.002752,-19.584820,-1.469094>,<-55.144002,-19.584820,6.123160>,<-55.144002,-26.206982,6.123160>}
      triangle {<-53.002752,-26.206982,-1.469094>,<-53.002752,-19.584820,-1.469094>,<-55.144002,-26.206982,6.123160>}
      triangle {<-43.272752,-20.321529,-43.984277>,<-43.272752,-25.470264,-43.984277>,<-45.382749,-25.470264,-36.502633>}
      triangle {<-45.382749,-20.321529,-36.502633>,<-43.272752,-20.321529,-43.984277>,<-45.382749,-25.470264,-36.502633>}
      triangle {<-41.269742,-25.470264,-43.419381>,<-43.379743,-25.470264,-35.937722>,<-45.382749,-25.470264,-36.502633>}
      triangle {<-43.272752,-25.470264,-43.984277>,<-41.269742,-25.470264,-43.419381>,<-45.382749,-25.470264,-36.502633>}
      triangle {<-41.269742,-20.321529,-43.419381>,<-41.269742,-25.470264,-43.419381>,<-43.272752,-25.470264,-43.984277>}
      triangle {<-43.272752,-20.321529,-43.984277>,<-41.269742,-20.321529,-43.419381>,<-43.272752,-25.470264,-43.984277>}
      triangle {<-43.379743,-20.321529,-35.937722>,<-41.269742,-20.321529,-43.419381>,<-43.272752,-20.321529,-43.984277>}
      triangle {<-45.382749,-20.321529,-36.502633>,<-43.379743,-20.321529,-35.937722>,<-43.272752,-20.321529,-43.984277>}
      triangle {<-43.379743,-25.470264,-35.937722>,<-43.379743,-20.321529,-35.937722>,<-45.382749,-20.321529,-36.502633>}
      triangle {<-45.382749,-25.470264,-36.502633>,<-43.379743,-25.470264,-35.937722>,<-45.382749,-20.321529,-36.502633>}
      triangle {<-41.269742,-20.321529,-43.419381>,<-43.379743,-20.321529,-35.937722>,<-43.379743,-25.470264,-35.937722>}
      triangle {<-41.269742,-25.470264,-43.419381>,<-41.269742,-20.321529,-43.419381>,<-43.379743,-25.470264,-35.937722>}
      triangle {<-32.156759,-20.230480,-83.398583>,<-32.156759,-25.561321,-83.398583>,<-33.331289,-25.561321,-79.234002>}
      triangle {<-33.331289,-20.230480,-79.234002>,<-32.156759,-20.230480,-83.398583>,<-33.331289,-25.561321,-79.234002>}
      triangle {<-30.153715,-25.561321,-82.833795>,<-31.328329,-25.561321,-78.669061>,<-33.331289,-25.561321,-79.234002>}
      triangle {<-32.156759,-25.561321,-83.398583>,<-30.153715,-25.561321,-82.833795>,<-33.331289,-25.561321,-79.234002>}
      triangle {<-30.153715,-20.230480,-82.833795>,<-30.153715,-25.561321,-82.833795>,<-32.156759,-25.561321,-83.398583>}
      triangle {<-32.156759,-20.230480,-83.398583>,<-30.153715,-20.230480,-82.833795>,<-32.156759,-25.561321,-83.398583>}
      triangle {<-31.328329,-20.230480,-78.669061>,<-30.153715,-20.230480,-82.833795>,<-32.156759,-20.230480,-83.398583>}
      triangle {<-33.331289,-20.230480,-79.234002>,<-31.328329,-20.230480,-78.669061>,<-32.156759,-20.230480,-83.398583>}
      triangle {<-31.328329,-25.561321,-78.669061>,<-31.328329,-20.230480,-78.669061>,<-33.331289,-20.230480,-79.234002>}
      triangle {<-33.331289,-25.561321,-79.234002>,<-31.328329,-25.561321,-78.669061>,<-33.331289,-20.230480,-79.234002>}
      triangle {<-30.153715,-20.230480,-82.833795>,<-31.328329,-20.230480,-78.669061>,<-31.328329,-25.561321,-78.669061>}
      triangle {<-30.153715,-25.561321,-82.833795>,<-30.153715,-20.230480,-82.833795>,<-31.328329,-25.561321,-78.669061>}
      triangle {<-31.915845,-19.584820,-79.630456>,<-31.915845,-26.206982,-79.630456>,<-34.057081,-26.206982,-72.038186>}
      triangle {<-34.057081,-19.584820,-72.038186>,<-31.915845,-19.584820,-79.630456>,<-34.057081,-26.206982,-72.038186>}
      triangle {<-31.029470,-26.206982,-79.380456>,<-33.170705,-26.206982,-71.788293>,<-34.057081,-26.206982,-72.038186>}
      triangle {<-31.915845,-26.206982,-79.630456>,<-31.029470,-26.206982,-79.380456>,<-34.057081,-26.206982,-72.038186>}
      triangle {<-31.029470,-19.584820,-79.380456>,<-31.029470,-26.206982,-79.380456>,<-31.915845,-26.206982,-79.630456>}
      triangle {<-31.915845,-19.584820,-79.630456>,<-31.029470,-19.584820,-79.380456>,<-31.915845,-26.206982,-79.630456>}
      triangle {<-33.170705,-19.584820,-71.788293>,<-31.029470,-19.584820,-79.380456>,<-31.915845,-19.584820,-79.630456>}
      triangle {<-34.057081,-19.584820,-72.038186>,<-33.170705,-19.584820,-71.788293>,<-31.915845,-19.584820,-79.630456>}
      triangle {<-33.170705,-26.206982,-71.788293>,<-33.170705,-19.584820,-71.788293>,<-34.057081,-19.584820,-72.038186>}
      triangle {<-34.057081,-26.206982,-72.038186>,<-33.170705,-26.206982,-71.788293>,<-34.057081,-19.584820,-72.038186>}
      triangle {<-31.029470,-19.584820,-79.380456>,<-33.170705,-19.584820,-71.788293>,<-33.170705,-26.206982,-71.788293>}
      triangle {<-31.029470,-26.206982,-79.380456>,<-31.029470,-19.584820,-79.380456>,<-33.170705,-26.206982,-71.788293>}
      triangle {<-34.451280,-21.240353,-75.262918>,<-34.451280,-24.551434,-75.262918>,<-36.530077,-24.551434,-67.891854>}
      triangle {<-36.530077,-21.240353,-67.891854>,<-34.451280,-21.240353,-75.262918>,<-36.530077,-24.551434,-67.891854>}
      triangle {<-32.448267,-24.551434,-74.698022>,<-34.527078,-24.551434,-67.326928>,<-36.530077,-24.551434,-67.891854>}
      triangle {<-34.451280,-24.551434,-75.262918>,<-32.448267,-24.551434,-74.698022>,<-36.530077,-24.551434,-67.891854>}
      triangle {<-32.448267,-21.240353,-74.698022>,<-32.448267,-24.551434,-74.698022>,<-34.451280,-24.551434,-75.262918>}
      triangle {<-34.451280,-21.240353,-75.262918>,<-32.448267,-21.240353,-74.698022>,<-34.451280,-24.551434,-75.262918>}
      triangle {<-34.527078,-21.240353,-67.326928>,<-32.448267,-21.240353,-74.698022>,<-34.451280,-21.240353,-75.262918>}
      triangle {<-36.530077,-21.240353,-67.891854>,<-34.527078,-21.240353,-67.326928>,<-34.451280,-21.240353,-75.262918>}
      triangle {<-34.527078,-24.551434,-67.326928>,<-34.527078,-21.240353,-67.326928>,<-36.530077,-21.240353,-67.891854>}
      triangle {<-36.530077,-24.551434,-67.891854>,<-34.527078,-24.551434,-67.326928>,<-36.530077,-21.240353,-67.891854>}
      triangle {<-32.448267,-21.240353,-74.698022>,<-34.527078,-21.240353,-67.326928>,<-34.527078,-24.551434,-67.326928>}
      triangle {<-32.448267,-24.551434,-74.698022>,<-32.448267,-21.240353,-74.698022>,<-34.527078,-24.551434,-67.326928>}
      triangle {<-36.095514,-19.584820,-64.810388>,<-36.095514,-26.206982,-64.810388>,<-38.236757,-26.206982,-57.218148>}
      triangle {<-38.236757,-19.584820,-57.218148>,<-36.095514,-19.584820,-64.810388>,<-38.236757,-26.206982,-57.218148>}
      triangle {<-35.209165,-26.206982,-64.560433>,<-37.350416,-26.206982,-56.968179>,<-38.236757,-26.206982,-57.218148>}
      triangle {<-36.095514,-26.206982,-64.810388>,<-35.209165,-26.206982,-64.560433>,<-38.236757,-26.206982,-57.218148>}
      triangle {<-35.209165,-19.584820,-64.560433>,<-35.209165,-26.206982,-64.560433>,<-36.095514,-26.206982,-64.810388>}
      triangle {<-36.095514,-19.584820,-64.810388>,<-35.209165,-19.584820,-64.560433>,<-36.095514,-26.206982,-64.810388>}
      triangle {<-37.350416,-19.584820,-56.968179>,<-35.209165,-19.584820,-64.560433>,<-36.095514,-19.584820,-64.810388>}
      triangle {<-38.236757,-19.584820,-57.218148>,<-37.350416,-19.584820,-56.968179>,<-36.095514,-19.584820,-64.810388>}
      triangle {<-37.350416,-26.206982,-56.968179>,<-37.350416,-19.584820,-56.968179>,<-38.236757,-19.584820,-57.218148>}
      triangle {<-38.236757,-26.206982,-57.218148>,<-37.350416,-26.206982,-56.968179>,<-38.236757,-19.584820,-57.218148>}
      triangle {<-35.209165,-19.584820,-64.560433>,<-37.350416,-19.584820,-56.968179>,<-37.350416,-26.206982,-56.968179>}
      triangle {<-35.209165,-26.206982,-64.560433>,<-35.209165,-19.584820,-64.560433>,<-37.350416,-26.206982,-56.968179>}
      triangle {<-38.198164,-21.405910,-61.977365>,<-38.198164,-24.385891,-61.977365>,<-42.355901,-24.385891,-47.235177>}
      triangle {<-42.355901,-21.405910,-47.235177>,<-38.198164,-21.405910,-61.977365>,<-42.355901,-24.385891,-47.235177>}
      triangle {<-36.195150,-24.385891,-61.412469>,<-40.352922,-24.385891,-46.670266>,<-42.355901,-24.385891,-47.235177>}
      triangle {<-38.198164,-24.385891,-61.977365>,<-36.195150,-24.385891,-61.412469>,<-42.355901,-24.385891,-47.235177>}
      triangle {<-36.195150,-21.405910,-61.412469>,<-36.195150,-24.385891,-61.412469>,<-38.198164,-24.385891,-61.977365>}
      triangle {<-38.198164,-21.405910,-61.977365>,<-36.195150,-21.405910,-61.412469>,<-38.198164,-24.385891,-61.977365>}
      triangle {<-40.352922,-21.405910,-46.670266>,<-36.195150,-21.405910,-61.412469>,<-38.198164,-21.405910,-61.977365>}
      triangle {<-42.355901,-21.405910,-47.235177>,<-40.352922,-21.405910,-46.670266>,<-38.198164,-21.405910,-61.977365>}
      triangle {<-40.352922,-24.385891,-46.670266>,<-40.352922,-21.405910,-46.670266>,<-42.355901,-21.405910,-47.235177>}
      triangle {<-42.355901,-24.385891,-47.235177>,<-40.352922,-24.385891,-46.670266>,<-42.355901,-21.405910,-47.235177>}
      triangle {<-36.195150,-21.405910,-61.412469>,<-40.352922,-21.405910,-46.670266>,<-40.352922,-24.385891,-46.670266>}
      triangle {<-36.195150,-24.385891,-61.412469>,<-36.195150,-21.405910,-61.412469>,<-40.352922,-24.385891,-46.670266>}
      triangle {<-39.916959,-19.584820,-51.260568>,<-39.916959,-26.206982,-51.260568>,<-42.058191,-26.206982,-43.668328>}
      triangle {<-42.058191,-19.584820,-43.668328>,<-39.916959,-19.584820,-51.260568>,<-42.058191,-26.206982,-43.668328>}
      triangle {<-39.030626,-26.206982,-51.010583>,<-41.171873,-26.206982,-43.418359>,<-42.058191,-26.206982,-43.668328>}
      triangle {<-39.916959,-26.206982,-51.260568>,<-39.030626,-26.206982,-51.010583>,<-42.058191,-26.206982,-43.668328>}
      triangle {<-39.030626,-19.584820,-51.010583>,<-39.030626,-26.206982,-51.010583>,<-39.916959,-26.206982,-51.260568>}
      triangle {<-39.916959,-19.584820,-51.260568>,<-39.030626,-19.584820,-51.010583>,<-39.916959,-26.206982,-51.260568>}
      triangle {<-41.171873,-19.584820,-43.418359>,<-39.030626,-19.584820,-51.010583>,<-39.916959,-19.584820,-51.260568>}
      triangle {<-42.058191,-19.584820,-43.668328>,<-41.171873,-19.584820,-43.418359>,<-39.916959,-19.584820,-51.260568>}
      triangle {<-41.171873,-26.206982,-43.418359>,<-41.171873,-19.584820,-43.418359>,<-42.058191,-19.584820,-43.668328>}
      triangle {<-42.058191,-26.206982,-43.668328>,<-41.171873,-26.206982,-43.418359>,<-42.058191,-19.584820,-43.668328>}
      triangle {<-39.030626,-19.584820,-51.010583>,<-41.171873,-19.584820,-43.418359>,<-41.171873,-26.206982,-43.418359>}
      triangle {<-39.030626,-26.206982,-51.010583>,<-39.030626,-19.584820,-51.010583>,<-41.171873,-26.206982,-43.418359>}
      triangle {<-85.047521,-20.321529,104.137916>,<-85.047521,-25.470264,104.137916>,<-87.157541,-25.470264,111.619582>}
      triangle {<-87.157541,-20.321529,111.619582>,<-85.047521,-20.321529,104.137916>,<-87.157541,-25.470264,111.619582>}
      triangle {<-83.044504,-25.470264,104.702849>,<-85.154538,-25.470264,112.184501>,<-87.157541,-25.470264,111.619582>}
      triangle {<-85.047521,-25.470264,104.137916>,<-83.044504,-25.470264,104.702849>,<-87.157541,-25.470264,111.619582>}
      triangle {<-83.044504,-20.321529,104.702849>,<-83.044504,-25.470264,104.702849>,<-85.047521,-25.470264,104.137916>}
      triangle {<-85.047521,-20.321529,104.137916>,<-83.044504,-20.321529,104.702849>,<-85.047521,-25.470264,104.137916>}
      triangle {<-85.154538,-20.321529,112.184501>,<-83.044504,-20.321529,104.702849>,<-85.047521,-20.321529,104.137916>}
      triangle {<-87.157541,-20.321529,111.619582>,<-85.154538,-20.321529,112.184501>,<-85.047521,-20.321529,104.137916>}
      triangle {<-85.154538,-25.470264,112.184501>,<-85.154538,-20.321529,112.184501>,<-87.157541,-20.321529,111.619582>}
      triangle {<-87.157541,-25.470264,111.619582>,<-85.154538,-25.470264,112.184501>,<-87.157541,-20.321529,111.619582>}
      triangle {<-83.044504,-20.321529,104.702849>,<-85.154538,-20.321529,112.184501>,<-85.154538,-25.470264,112.184501>}
      triangle {<-83.044504,-25.470264,104.702849>,<-83.044504,-20.321529,104.702849>,<-85.154538,-25.470264,112.184501>}
      triangle {<-73.931489,-20.230480,64.723533>,<-73.931489,-25.561321,64.723533>,<-75.106034,-25.561321,68.888228>}
      triangle {<-75.106034,-20.230480,68.888228>,<-73.931489,-20.230480,64.723533>,<-75.106034,-25.561321,68.888228>}
      triangle {<-71.928483,-25.561321,65.288428>,<-73.103050,-25.561321,69.453132>,<-75.106034,-25.561321,68.888228>}
      triangle {<-73.931489,-25.561321,64.723533>,<-71.928483,-25.561321,65.288428>,<-75.106034,-25.561321,68.888228>}
      triangle {<-71.928483,-20.230480,65.288428>,<-71.928483,-25.561321,65.288428>,<-73.931489,-25.561321,64.723533>}
      triangle {<-73.931489,-20.230480,64.723533>,<-71.928483,-20.230480,65.288428>,<-73.931489,-25.561321,64.723533>}
      triangle {<-73.103050,-20.230480,69.453132>,<-71.928483,-20.230480,65.288428>,<-73.931489,-20.230480,64.723533>}
      triangle {<-75.106034,-20.230480,68.888228>,<-73.103050,-20.230480,69.453132>,<-73.931489,-20.230480,64.723533>}
      triangle {<-73.103050,-25.561321,69.453132>,<-73.103050,-20.230480,69.453132>,<-75.106034,-20.230480,68.888228>}
      triangle {<-75.106034,-25.561321,68.888228>,<-73.103050,-25.561321,69.453132>,<-75.106034,-20.230480,68.888228>}
      triangle {<-71.928483,-20.230480,65.288428>,<-73.103050,-20.230480,69.453132>,<-73.103050,-25.561321,69.453132>}
      triangle {<-71.928483,-25.561321,65.288428>,<-71.928483,-20.230480,65.288428>,<-73.103050,-25.561321,69.453132>}
      triangle {<-73.690555,-19.584820,68.491721>,<-73.690555,-26.206982,68.491721>,<-75.831792,-26.206982,76.083953>}
      triangle {<-75.831792,-19.584820,76.083953>,<-73.690555,-19.584820,68.491721>,<-75.831792,-26.206982,76.083953>}
      triangle {<-72.804235,-26.206982,68.741691>,<-74.945465,-26.206982,76.333922>,<-75.831792,-26.206982,76.083953>}
      triangle {<-73.690555,-26.206982,68.491721>,<-72.804235,-26.206982,68.741691>,<-75.831792,-26.206982,76.083953>}
      triangle {<-72.804235,-19.584820,68.741691>,<-72.804235,-26.206982,68.741691>,<-73.690555,-26.206982,68.491721>}
      triangle {<-73.690555,-19.584820,68.491721>,<-72.804235,-19.584820,68.741691>,<-73.690555,-26.206982,68.491721>}
      triangle {<-74.945465,-19.584820,76.333922>,<-72.804235,-19.584820,68.741691>,<-73.690555,-19.584820,68.491721>}
      triangle {<-75.831792,-19.584820,76.083953>,<-74.945465,-19.584820,76.333922>,<-73.690555,-19.584820,68.491721>}
      triangle {<-74.945465,-26.206982,76.333922>,<-74.945465,-19.584820,76.333922>,<-75.831792,-19.584820,76.083953>}
      triangle {<-75.831792,-26.206982,76.083953>,<-74.945465,-26.206982,76.333922>,<-75.831792,-19.584820,76.083953>}
      triangle {<-72.804235,-19.584820,68.741691>,<-74.945465,-19.584820,76.333922>,<-74.945465,-26.206982,76.333922>}
      triangle {<-72.804235,-26.206982,68.741691>,<-72.804235,-19.584820,68.741691>,<-74.945465,-26.206982,76.333922>}
      triangle {<-76.225989,-21.240353,72.859252>,<-76.225989,-24.551434,72.859252>,<-78.304873,-24.551434,80.230376>}
      triangle {<-78.304873,-21.240353,80.230376>,<-76.225989,-21.240353,72.859252>,<-78.304873,-24.551434,80.230376>}
      triangle {<-74.223004,-24.551434,73.424170>,<-76.301866,-24.551434,80.795287>,<-78.304873,-24.551434,80.230376>}
      triangle {<-76.225989,-24.551434,72.859252>,<-74.223004,-24.551434,73.424170>,<-78.304873,-24.551434,80.230376>}
      triangle {<-74.223004,-21.240353,73.424170>,<-74.223004,-24.551434,73.424170>,<-76.225989,-24.551434,72.859252>}
      triangle {<-76.225989,-21.240353,72.859252>,<-74.223004,-21.240353,73.424170>,<-76.225989,-24.551434,72.859252>}
      triangle {<-76.301866,-21.240353,80.795287>,<-74.223004,-21.240353,73.424170>,<-76.225989,-21.240353,72.859252>}
      triangle {<-78.304873,-21.240353,80.230376>,<-76.301866,-21.240353,80.795287>,<-76.225989,-21.240353,72.859252>}
      triangle {<-76.301866,-24.551434,80.795287>,<-76.301866,-21.240353,80.795287>,<-78.304873,-21.240353,80.230376>}
      triangle {<-78.304873,-24.551434,80.230376>,<-76.301866,-24.551434,80.795287>,<-78.304873,-21.240353,80.230376>}
      triangle {<-74.223004,-21.240353,73.424170>,<-76.301866,-21.240353,80.795287>,<-76.301866,-24.551434,80.795287>}
      triangle {<-74.223004,-24.551434,73.424170>,<-74.223004,-21.240353,73.424170>,<-76.301866,-24.551434,80.795287>}
      triangle {<-77.870283,-19.584820,83.311835>,<-77.870283,-26.206982,83.311835>,<-80.011487,-26.206982,90.904067>}
      triangle {<-80.011487,-19.584820,90.904067>,<-77.870283,-19.584820,83.311835>,<-80.011487,-26.206982,90.904067>}
      triangle {<-76.983966,-26.206982,83.561790>,<-79.125169,-26.206982,91.154021>,<-80.011487,-26.206982,90.904067>}
      triangle {<-77.870283,-26.206982,83.311835>,<-76.983966,-26.206982,83.561790>,<-80.011487,-26.206982,90.904067>}
      triangle {<-76.983966,-19.584820,83.561790>,<-76.983966,-26.206982,83.561790>,<-77.870283,-26.206982,83.311835>}
      triangle {<-77.870283,-19.584820,83.311835>,<-76.983966,-19.584820,83.561790>,<-77.870283,-26.206982,83.311835>}
      triangle {<-79.125169,-19.584820,91.154021>,<-76.983966,-19.584820,83.561790>,<-77.870283,-19.584820,83.311835>}
      triangle {<-80.011487,-19.584820,90.904067>,<-79.125169,-19.584820,91.154021>,<-77.870283,-19.584820,83.311835>}
      triangle {<-79.125169,-26.206982,91.154021>,<-79.125169,-19.584820,91.154021>,<-80.011487,-19.584820,90.904067>}
      triangle {<-80.011487,-26.206982,90.904067>,<-79.125169,-26.206982,91.154021>,<-80.011487,-19.584820,90.904067>}
      triangle {<-76.983966,-19.584820,83.561790>,<-79.125169,-19.584820,91.154021>,<-79.125169,-26.206982,91.154021>}
      triangle {<-76.983966,-26.206982,83.561790>,<-76.983966,-19.584820,83.561790>,<-79.125169,-26.206982,91.154021>}
      triangle {<-79.972931,-21.405910,86.144828>,<-79.972931,-24.385891,86.144828>,<-84.130660,-24.385891,100.887015>}
      triangle {<-84.130660,-21.405910,100.887015>,<-79.972931,-21.405910,86.144828>,<-84.130660,-24.385891,100.887015>}
      triangle {<-77.969907,-24.385891,86.709731>,<-82.127656,-24.385891,101.451911>,<-84.130660,-24.385891,100.887015>}
      triangle {<-79.972931,-24.385891,86.144828>,<-77.969907,-24.385891,86.709731>,<-84.130660,-24.385891,100.887015>}
      triangle {<-77.969907,-21.405910,86.709731>,<-77.969907,-24.385891,86.709731>,<-79.972931,-24.385891,86.144828>}
      triangle {<-79.972931,-21.405910,86.144828>,<-77.969907,-21.405910,86.709731>,<-79.972931,-24.385891,86.144828>}
      triangle {<-82.127656,-21.405910,101.451911>,<-77.969907,-21.405910,86.709731>,<-79.972931,-21.405910,86.144828>}
      triangle {<-84.130660,-21.405910,100.887015>,<-82.127656,-21.405910,101.451911>,<-79.972931,-21.405910,86.144828>}
      triangle {<-82.127656,-24.385891,101.451911>,<-82.127656,-21.405910,101.451911>,<-84.130660,-21.405910,100.887015>}
      triangle {<-84.130660,-24.385891,100.887015>,<-82.127656,-24.385891,101.451911>,<-84.130660,-21.405910,100.887015>}
      triangle {<-77.969907,-21.405910,86.709731>,<-82.127656,-21.405910,101.451911>,<-82.127656,-24.385891,101.451911>}
      triangle {<-77.969907,-24.385891,86.709731>,<-77.969907,-21.405910,86.709731>,<-82.127656,-24.385891,101.451911>}
      triangle {<-81.691695,-19.584820,96.861648>,<-81.691695,-26.206982,96.861648>,<-83.832945,-26.206982,104.453887>}
      triangle {<-83.832945,-19.584820,104.453887>,<-81.691695,-19.584820,96.861648>,<-83.832945,-26.206982,104.453887>}
      triangle {<-80.805369,-26.206982,97.111625>,<-82.946620,-26.206982,104.703864>,<-83.832945,-26.206982,104.453887>}
      triangle {<-81.691695,-26.206982,96.861648>,<-80.805369,-26.206982,97.111625>,<-83.832945,-26.206982,104.453887>}
      triangle {<-80.805369,-19.584820,97.111625>,<-80.805369,-26.206982,97.111625>,<-81.691695,-26.206982,96.861648>}
      triangle {<-81.691695,-19.584820,96.861648>,<-80.805369,-19.584820,97.111625>,<-81.691695,-26.206982,96.861648>}
      triangle {<-82.946620,-19.584820,104.703864>,<-80.805369,-19.584820,97.111625>,<-81.691695,-19.584820,96.861648>}
      triangle {<-83.832945,-19.584820,104.453887>,<-82.946620,-19.584820,104.703864>,<-81.691695,-19.584820,96.861648>}
      triangle {<-82.946620,-26.206982,104.703864>,<-82.946620,-19.584820,104.703864>,<-83.832945,-19.584820,104.453887>}
      triangle {<-83.832945,-26.206982,104.453887>,<-82.946620,-26.206982,104.703864>,<-83.832945,-19.584820,104.453887>}
      triangle {<-80.805369,-19.584820,97.111625>,<-82.946620,-19.584820,104.703864>,<-82.946620,-26.206982,104.703864>}
      triangle {<-80.805369,-26.206982,97.111625>,<-80.805369,-19.584820,97.111625>,<-82.946620,-26.206982,104.703864>}
      triangle {<-71.075338,-20.321529,54.596396>,<-71.075338,-25.470264,54.596396>,<-73.185380,-25.470264,62.078063>}
      triangle {<-73.185380,-20.321529,62.078063>,<-71.075338,-20.321529,54.596396>,<-73.185380,-25.470264,62.078063>}
      triangle {<-69.072332,-25.470264,55.161307>,<-71.182390,-25.470264,62.642989>,<-73.185380,-25.470264,62.078063>}
      triangle {<-71.075338,-25.470264,54.596396>,<-69.072332,-25.470264,55.161307>,<-73.185380,-25.470264,62.078063>}
      triangle {<-69.072332,-20.321529,55.161307>,<-69.072332,-25.470264,55.161307>,<-71.075338,-25.470264,54.596396>}
      triangle {<-71.075338,-20.321529,54.596396>,<-69.072332,-20.321529,55.161307>,<-71.075338,-25.470264,54.596396>}
      triangle {<-71.182390,-20.321529,62.642989>,<-69.072332,-20.321529,55.161307>,<-71.075338,-20.321529,54.596396>}
      triangle {<-73.185380,-20.321529,62.078063>,<-71.182390,-20.321529,62.642989>,<-71.075338,-20.321529,54.596396>}
      triangle {<-71.182390,-25.470264,62.642989>,<-71.182390,-20.321529,62.642989>,<-73.185380,-20.321529,62.078063>}
      triangle {<-73.185380,-25.470264,62.078063>,<-71.182390,-25.470264,62.642989>,<-73.185380,-20.321529,62.078063>}
      triangle {<-69.072332,-20.321529,55.161307>,<-71.182390,-20.321529,62.642989>,<-71.182390,-25.470264,62.642989>}
      triangle {<-69.072332,-25.470264,55.161307>,<-69.072332,-20.321529,55.161307>,<-71.182390,-25.470264,62.642989>}
      triangle {<-59.959396,-20.230480,15.182014>,<-59.959396,-25.561321,15.182014>,<-61.133934,-25.561321,19.346732>}
      triangle {<-61.133934,-20.230480,19.346732>,<-59.959396,-20.230480,15.182014>,<-61.133934,-25.561321,19.346732>}
      triangle {<-57.956422,-25.561321,15.746924>,<-59.130926,-25.561321,19.911628>,<-61.133934,-25.561321,19.346732>}
      triangle {<-59.959396,-25.561321,15.182014>,<-57.956422,-25.561321,15.746924>,<-61.133934,-25.561321,19.346732>}
      triangle {<-57.956422,-20.230480,15.746924>,<-57.956422,-25.561321,15.746924>,<-59.959396,-25.561321,15.182014>}
      triangle {<-59.959396,-20.230480,15.182014>,<-57.956422,-20.230480,15.746924>,<-59.959396,-25.561321,15.182014>}
      triangle {<-59.130926,-20.230480,19.911628>,<-57.956422,-20.230480,15.746924>,<-59.959396,-20.230480,15.182014>}
      triangle {<-61.133934,-20.230480,19.346732>,<-59.130926,-20.230480,19.911628>,<-59.959396,-20.230480,15.182014>}
      triangle {<-59.130926,-25.561321,19.911628>,<-59.130926,-20.230480,19.911628>,<-61.133934,-20.230480,19.346732>}
      triangle {<-61.133934,-25.561321,19.346732>,<-59.130926,-25.561321,19.911628>,<-61.133934,-20.230480,19.346732>}
      triangle {<-57.956422,-20.230480,15.746924>,<-59.130926,-20.230480,19.911628>,<-59.130926,-25.561321,19.911628>}
      triangle {<-57.956422,-25.561321,15.746924>,<-57.956422,-20.230480,15.746924>,<-59.130926,-25.561321,19.911628>}
      triangle {<-59.718477,-19.584820,18.950217>,<-59.718477,-26.206982,18.950217>,<-61.859684,-26.206982,26.542457>}
      triangle {<-61.859684,-19.584820,26.542457>,<-59.718477,-19.584820,18.950217>,<-61.859684,-26.206982,26.542457>}
      triangle {<-58.832134,-26.206982,19.200187>,<-60.973384,-26.206982,26.792426>,<-61.859684,-26.206982,26.542457>}
      triangle {<-59.718477,-26.206982,18.950217>,<-58.832134,-26.206982,19.200187>,<-61.859684,-26.206982,26.542457>}
      triangle {<-58.832134,-19.584820,19.200187>,<-58.832134,-26.206982,19.200187>,<-59.718477,-26.206982,18.950217>}
      triangle {<-59.718477,-19.584820,18.950217>,<-58.832134,-19.584820,19.200187>,<-59.718477,-26.206982,18.950217>}
      triangle {<-60.973384,-19.584820,26.792426>,<-58.832134,-19.584820,19.200187>,<-59.718477,-19.584820,18.950217>}
      triangle {<-61.859684,-19.584820,26.542457>,<-60.973384,-19.584820,26.792426>,<-59.718477,-19.584820,18.950217>}
      triangle {<-60.973384,-26.206982,26.792426>,<-60.973384,-19.584820,26.792426>,<-61.859684,-19.584820,26.542457>}
      triangle {<-61.859684,-26.206982,26.542457>,<-60.973384,-26.206982,26.792426>,<-61.859684,-19.584820,26.542457>}
      triangle {<-58.832134,-19.584820,19.200187>,<-60.973384,-19.584820,26.792426>,<-60.973384,-26.206982,26.792426>}
      triangle {<-58.832134,-26.206982,19.200187>,<-58.832134,-19.584820,19.200187>,<-60.973384,-26.206982,26.792426>}
      triangle {<-62.253881,-21.240353,23.317756>,<-62.253881,-24.551434,23.317756>,<-64.332721,-24.551434,30.688865>}
      triangle {<-64.332721,-21.240353,30.688865>,<-62.253881,-21.240353,23.317756>,<-64.332721,-24.551434,30.688865>}
      triangle {<-60.250879,-24.551434,23.882667>,<-62.329713,-24.551434,31.253776>,<-64.332721,-24.551434,30.688865>}
      triangle {<-62.253881,-24.551434,23.317756>,<-60.250879,-24.551434,23.882667>,<-64.332721,-24.551434,30.688865>}
      triangle {<-60.250879,-21.240353,23.882667>,<-60.250879,-24.551434,23.882667>,<-62.253881,-24.551434,23.317756>}
      triangle {<-62.253881,-21.240353,23.317756>,<-60.250879,-21.240353,23.882667>,<-62.253881,-24.551434,23.317756>}
      triangle {<-62.329713,-21.240353,31.253776>,<-60.250879,-21.240353,23.882667>,<-62.253881,-21.240353,23.317756>}
      triangle {<-64.332721,-21.240353,30.688865>,<-62.329713,-21.240353,31.253776>,<-62.253881,-21.240353,23.317756>}
      triangle {<-62.329713,-24.551434,31.253776>,<-62.329713,-21.240353,31.253776>,<-64.332721,-21.240353,30.688865>}
      triangle {<-64.332721,-24.551434,30.688865>,<-62.329713,-24.551434,31.253776>,<-64.332721,-21.240353,30.688865>}
      triangle {<-60.250879,-21.240353,23.882667>,<-62.329713,-21.240353,31.253776>,<-62.329713,-24.551434,31.253776>}
      triangle {<-60.250879,-24.551434,23.882667>,<-60.250879,-21.240353,23.882667>,<-62.329713,-24.551434,31.253776>}
      triangle {<-63.898159,-19.584820,33.770347>,<-63.898159,-26.206982,33.770347>,<-66.039375,-26.206982,41.362556>}
      triangle {<-66.039375,-19.584820,41.362556>,<-63.898159,-19.584820,33.770347>,<-66.039375,-26.206982,41.362556>}
      triangle {<-63.011796,-26.206982,34.020270>,<-65.153055,-26.206982,41.612525>,<-66.039375,-26.206982,41.362556>}
      triangle {<-63.898159,-26.206982,33.770347>,<-63.011796,-26.206982,34.020270>,<-66.039375,-26.206982,41.362556>}
      triangle {<-63.011796,-19.584820,34.020270>,<-63.011796,-26.206982,34.020270>,<-63.898159,-26.206982,33.770347>}
      triangle {<-63.898159,-19.584820,33.770347>,<-63.011796,-19.584820,34.020270>,<-63.898159,-26.206982,33.770347>}
      triangle {<-65.153055,-19.584820,41.612525>,<-63.011796,-19.584820,34.020270>,<-63.898159,-19.584820,33.770347>}
      triangle {<-66.039375,-19.584820,41.362556>,<-65.153055,-19.584820,41.612525>,<-63.898159,-19.584820,33.770347>}
      triangle {<-65.153055,-26.206982,41.612525>,<-65.153055,-19.584820,41.612525>,<-66.039375,-19.584820,41.362556>}
      triangle {<-66.039375,-26.206982,41.362556>,<-65.153055,-26.206982,41.612525>,<-66.039375,-19.584820,41.362556>}
      triangle {<-63.011796,-19.584820,34.020270>,<-65.153055,-19.584820,41.612525>,<-65.153055,-26.206982,41.612525>}
      triangle {<-63.011796,-26.206982,34.020270>,<-63.011796,-19.584820,34.020270>,<-65.153055,-26.206982,41.612525>}
      triangle {<-66.000762,-21.405910,36.603339>,<-66.000762,-24.385891,36.603339>,<-70.158502,-24.385891,51.345473>}
      triangle {<-70.158502,-21.405910,51.345473>,<-66.000762,-21.405910,36.603339>,<-70.158502,-24.385891,51.345473>}
      triangle {<-63.997762,-24.385891,37.168204>,<-68.155481,-24.385891,51.910384>,<-70.158502,-24.385891,51.345473>}
      triangle {<-66.000762,-24.385891,36.603339>,<-63.997762,-24.385891,37.168204>,<-70.158502,-24.385891,51.345473>}
      triangle {<-63.997762,-21.405910,37.168204>,<-63.997762,-24.385891,37.168204>,<-66.000762,-24.385891,36.603339>}
      triangle {<-66.000762,-21.405910,36.603339>,<-63.997762,-21.405910,37.168204>,<-66.000762,-24.385891,36.603339>}
      triangle {<-68.155481,-21.405910,51.910384>,<-63.997762,-21.405910,37.168204>,<-66.000762,-21.405910,36.603339>}
      triangle {<-70.158502,-21.405910,51.345473>,<-68.155481,-21.405910,51.910384>,<-66.000762,-21.405910,36.603339>}
      triangle {<-68.155481,-24.385891,51.910384>,<-68.155481,-21.405910,51.910384>,<-70.158502,-21.405910,51.345473>}
      triangle {<-70.158502,-24.385891,51.345473>,<-68.155481,-24.385891,51.910384>,<-70.158502,-21.405910,51.345473>}
      triangle {<-63.997762,-21.405910,37.168204>,<-68.155481,-21.405910,51.910384>,<-68.155481,-24.385891,51.910384>}
      triangle {<-63.997762,-24.385891,37.168204>,<-63.997762,-21.405910,37.168204>,<-68.155481,-24.385891,51.910384>}
      triangle {<-67.719573,-19.584820,47.320136>,<-67.719573,-26.206982,47.320136>,<-69.860813,-26.206982,54.912353>}
      triangle {<-69.860813,-19.584820,54.912353>,<-67.719573,-19.584820,47.320136>,<-69.860813,-26.206982,54.912353>}
      triangle {<-66.833251,-26.206982,47.570151>,<-68.974451,-26.206982,55.162314>,<-69.860813,-26.206982,54.912353>}
      triangle {<-67.719573,-26.206982,47.320136>,<-66.833251,-26.206982,47.570151>,<-69.860813,-26.206982,54.912353>}
      triangle {<-66.833251,-19.584820,47.570151>,<-66.833251,-26.206982,47.570151>,<-67.719573,-26.206982,47.320136>}
      triangle {<-67.719573,-19.584820,47.320136>,<-66.833251,-19.584820,47.570151>,<-67.719573,-26.206982,47.320136>}
      triangle {<-68.974451,-19.584820,55.162314>,<-66.833251,-19.584820,47.570151>,<-67.719573,-19.584820,47.320136>}
      triangle {<-69.860813,-19.584820,54.912353>,<-68.974451,-19.584820,55.162314>,<-67.719573,-19.584820,47.320136>}
      triangle {<-68.974451,-26.206982,55.162314>,<-68.974451,-19.584820,55.162314>,<-69.860813,-19.584820,54.912353>}
      triangle {<-69.860813,-26.206982,54.912353>,<-68.974451,-26.206982,55.162314>,<-69.860813,-19.584820,54.912353>}
      triangle {<-66.833251,-19.584820,47.570151>,<-68.974451,-19.584820,55.162314>,<-68.974451,-26.206982,55.162314>}
      triangle {<-66.833251,-26.206982,47.570151>,<-66.833251,-19.584820,47.570151>,<-68.974451,-26.206982,55.162314>}
      triangle {<-87.769066,-20.230480,113.787890>,<-87.769066,-25.561321,113.787890>,<-88.943627,-25.561321,117.952571>}
      triangle {<-88.943627,-20.230480,117.952571>,<-87.769066,-20.230480,113.787890>,<-88.943627,-25.561321,117.952571>}
      triangle {<-85.766059,-25.561321,114.352790>,<-86.940626,-25.561321,118.517478>,<-88.943627,-25.561321,117.952571>}
      triangle {<-87.769066,-25.561321,113.787890>,<-85.766059,-25.561321,114.352790>,<-88.943627,-25.561321,117.952571>}
      triangle {<-85.766059,-20.230480,114.352790>,<-85.766059,-25.561321,114.352790>,<-87.769066,-25.561321,113.787890>}
      triangle {<-87.769066,-20.230480,113.787890>,<-85.766059,-20.230480,114.352790>,<-87.769066,-25.561321,113.787890>}
      triangle {<-86.940626,-20.230480,118.517478>,<-85.766059,-20.230480,114.352790>,<-87.769066,-20.230480,113.787890>}
      triangle {<-88.943627,-20.230480,117.952571>,<-86.940626,-20.230480,118.517478>,<-87.769066,-20.230480,113.787890>}
      triangle {<-86.940626,-25.561321,118.517478>,<-86.940626,-20.230480,118.517478>,<-88.943627,-20.230480,117.952571>}
      triangle {<-88.943627,-25.561321,117.952571>,<-86.940626,-25.561321,118.517478>,<-88.943627,-20.230480,117.952571>}
      triangle {<-85.766059,-20.230480,114.352790>,<-86.940626,-20.230480,118.517478>,<-86.940626,-25.561321,118.517478>}
      triangle {<-85.766059,-25.561321,114.352790>,<-85.766059,-20.230480,114.352790>,<-86.940626,-25.561321,118.517478>}
      triangle {<-87.528128,-19.584820,117.556075>,<-87.528128,-26.206982,117.556075>,<-89.669379,-26.206982,125.148330>}
      triangle {<-89.669379,-19.584820,125.148330>,<-87.528128,-19.584820,117.556075>,<-89.669379,-26.206982,125.148330>}
      triangle {<-86.641812,-26.206982,117.806048>,<-88.783057,-26.206982,125.398295>,<-89.669379,-26.206982,125.148330>}
      triangle {<-87.528128,-26.206982,117.556075>,<-86.641812,-26.206982,117.806048>,<-89.669379,-26.206982,125.148330>}
      triangle {<-86.641812,-19.584820,117.806048>,<-86.641812,-26.206982,117.806048>,<-87.528128,-26.206982,117.556075>}
      triangle {<-87.528128,-19.584820,117.556075>,<-86.641812,-19.584820,117.806048>,<-87.528128,-26.206982,117.556075>}
      triangle {<-88.783057,-19.584820,125.398295>,<-86.641812,-19.584820,117.806048>,<-87.528128,-19.584820,117.556075>}
      triangle {<-89.669379,-19.584820,125.148330>,<-88.783057,-19.584820,125.398295>,<-87.528128,-19.584820,117.556075>}
      triangle {<-88.783057,-26.206982,125.398295>,<-88.783057,-19.584820,125.398295>,<-89.669379,-19.584820,125.148330>}
      triangle {<-89.669379,-26.206982,125.148330>,<-88.783057,-26.206982,125.398295>,<-89.669379,-19.584820,125.148330>}
      triangle {<-86.641812,-19.584820,117.806048>,<-88.783057,-19.584820,125.398295>,<-88.783057,-26.206982,125.398295>}
      triangle {<-86.641812,-26.206982,117.806048>,<-86.641812,-19.584820,117.806048>,<-88.783057,-26.206982,125.398295>}
      triangle {<-90.063578,-21.240353,121.923621>,<-90.063578,-24.551434,121.923621>,<-92.142443,-24.551434,129.294700>}
      triangle {<-92.142443,-21.240353,129.294700>,<-90.063578,-21.240353,121.923621>,<-92.142443,-24.551434,129.294700>}
      triangle {<-88.060571,-24.551434,122.488521>,<-90.139432,-24.551434,129.859614>,<-92.142443,-24.551434,129.294700>}
      triangle {<-90.063578,-24.551434,121.923621>,<-88.060571,-24.551434,122.488521>,<-92.142443,-24.551434,129.294700>}
      triangle {<-88.060571,-21.240353,122.488521>,<-88.060571,-24.551434,122.488521>,<-90.063578,-24.551434,121.923621>}
      triangle {<-90.063578,-21.240353,121.923621>,<-88.060571,-21.240353,122.488521>,<-90.063578,-24.551434,121.923621>}
      triangle {<-90.139432,-21.240353,129.859614>,<-88.060571,-21.240353,122.488521>,<-90.063578,-21.240353,121.923621>}
      triangle {<-92.142443,-21.240353,129.294700>,<-90.139432,-21.240353,129.859614>,<-90.063578,-21.240353,121.923621>}
      triangle {<-90.139432,-24.551434,129.859614>,<-90.139432,-21.240353,129.859614>,<-92.142443,-21.240353,129.294700>}
      triangle {<-92.142443,-24.551434,129.294700>,<-90.139432,-24.551434,129.859614>,<-92.142443,-21.240353,129.294700>}
      triangle {<-88.060571,-21.240353,122.488521>,<-90.139432,-21.240353,129.859614>,<-90.139432,-24.551434,129.859614>}
      triangle {<-88.060571,-24.551434,122.488521>,<-88.060571,-21.240353,122.488521>,<-90.139432,-24.551434,129.859614>}
      triangle {<-91.707843,-19.584820,132.376166>,<-91.707843,-26.206982,132.376166>,<-93.849079,-26.206982,139.968387>}
      triangle {<-93.849079,-19.584820,139.968387>,<-91.707843,-19.584820,132.376166>,<-93.849079,-26.206982,139.968387>}
      triangle {<-90.821519,-26.206982,132.626136>,<-92.962756,-26.206982,140.218356>,<-93.849079,-26.206982,139.968387>}
      triangle {<-91.707843,-26.206982,132.376166>,<-90.821519,-26.206982,132.626136>,<-93.849079,-26.206982,139.968387>}
      triangle {<-90.821519,-19.584820,132.626136>,<-90.821519,-26.206982,132.626136>,<-91.707843,-26.206982,132.376166>}
      triangle {<-91.707843,-19.584820,132.376166>,<-90.821519,-19.584820,132.626136>,<-91.707843,-26.206982,132.376166>}
      triangle {<-92.962756,-19.584820,140.218356>,<-90.821519,-19.584820,132.626136>,<-91.707843,-19.584820,132.376166>}
      triangle {<-93.849079,-19.584820,139.968387>,<-92.962756,-19.584820,140.218356>,<-91.707843,-19.584820,132.376166>}
      triangle {<-92.962756,-26.206982,140.218356>,<-92.962756,-19.584820,140.218356>,<-93.849079,-19.584820,139.968387>}
      triangle {<-93.849079,-26.206982,139.968387>,<-92.962756,-26.206982,140.218356>,<-93.849079,-19.584820,139.968387>}
      triangle {<-90.821519,-19.584820,132.626136>,<-92.962756,-19.584820,140.218356>,<-92.962756,-26.206982,140.218356>}
      triangle {<-90.821519,-26.206982,132.626136>,<-90.821519,-19.584820,132.626136>,<-92.962756,-26.206982,140.218356>}
      triangle {<-93.810522,-21.405910,135.209136>,<-93.810522,-24.385891,135.209136>,<-97.968213,-24.385891,149.951346>}
      triangle {<-97.968213,-21.405910,149.951346>,<-93.810522,-21.405910,135.209136>,<-97.968213,-24.385891,149.951346>}
      triangle {<-91.807496,-24.385891,135.774043>,<-95.965207,-24.385891,150.516246>,<-97.968213,-24.385891,149.951346>}
      triangle {<-93.810522,-24.385891,135.209136>,<-91.807496,-24.385891,135.774043>,<-97.968213,-24.385891,149.951346>}
      triangle {<-91.807496,-21.405910,135.774043>,<-91.807496,-24.385891,135.774043>,<-93.810522,-24.385891,135.209136>}
      triangle {<-93.810522,-21.405910,135.209136>,<-91.807496,-21.405910,135.774043>,<-93.810522,-24.385891,135.209136>}
      triangle {<-95.965207,-21.405910,150.516246>,<-91.807496,-21.405910,135.774043>,<-93.810522,-21.405910,135.209136>}
      triangle {<-97.968213,-21.405910,149.951346>,<-95.965207,-21.405910,150.516246>,<-93.810522,-21.405910,135.209136>}
      triangle {<-95.965207,-24.385891,150.516246>,<-95.965207,-21.405910,150.516246>,<-97.968213,-21.405910,149.951346>}
      triangle {<-97.968213,-24.385891,149.951346>,<-95.965207,-24.385891,150.516246>,<-97.968213,-21.405910,149.951346>}
      triangle {<-91.807496,-21.405910,135.774043>,<-95.965207,-21.405910,150.516246>,<-95.965207,-24.385891,150.516246>}
      triangle {<-91.807496,-24.385891,135.774043>,<-91.807496,-21.405910,135.774043>,<-95.965207,-24.385891,150.516246>}
      triangle {<-95.529295,-19.584820,145.925990>,<-95.529295,-26.206982,145.925990>,<-97.670532,-26.206982,153.518209>}
      triangle {<-97.670532,-19.584820,153.518209>,<-95.529295,-19.584820,145.925990>,<-97.670532,-26.206982,153.518209>}
      triangle {<-94.642976,-26.206982,146.175946>,<-96.784179,-26.206982,153.768172>,<-97.670532,-26.206982,153.518209>}
      triangle {<-95.529295,-26.206982,145.925990>,<-94.642976,-26.206982,146.175946>,<-97.670532,-26.206982,153.518209>}
      triangle {<-94.642976,-19.584820,146.175946>,<-94.642976,-26.206982,146.175946>,<-95.529295,-26.206982,145.925990>}
      triangle {<-95.529295,-19.584820,145.925990>,<-94.642976,-19.584820,146.175946>,<-95.529295,-26.206982,145.925990>}
      triangle {<-96.784179,-19.584820,153.768172>,<-94.642976,-19.584820,146.175946>,<-95.529295,-19.584820,145.925990>}
      triangle {<-97.670532,-19.584820,153.518209>,<-96.784179,-19.584820,153.768172>,<-95.529295,-19.584820,145.925990>}
      triangle {<-96.784179,-26.206982,153.768172>,<-96.784179,-19.584820,153.768172>,<-97.670532,-19.584820,153.518209>}
      triangle {<-97.670532,-26.206982,153.518209>,<-96.784179,-26.206982,153.768172>,<-97.670532,-19.584820,153.518209>}
      triangle {<-94.642976,-19.584820,146.175946>,<-96.784179,-19.584820,153.768172>,<-96.784179,-26.206982,153.768172>}
      triangle {<-94.642976,-26.206982,146.175946>,<-94.642976,-19.584820,146.175946>,<-96.784179,-26.206982,153.768172>}
      texture{_Zeug01}
    }
    //_Bridge01
    mesh{
      triangle {<25.761782,26.049488,134.700770>,<25.804789,33.510227,134.700770>,<25.804789,33.510227,153.840560>}
      triangle {<25.761782,26.049488,134.700770>,<25.804789,33.510227,153.840560>,<25.761782,26.049488,160.162976>}
      triangle {<25.804789,33.510227,134.700770>,<0.322527,37.171665,134.700770>,<0.322527,37.171665,156.057612>}
      triangle {<25.804789,33.510227,134.700770>,<0.322527,37.171665,156.057612>,<25.804789,33.510227,153.840560>}
      triangle {<0.322527,37.171665,134.700770>,<-25.202779,33.372456,134.700770>,<-25.202779,33.372456,153.646729>}
      triangle {<0.322527,37.171665,134.700770>,<-25.202779,33.372456,153.646729>,<0.322527,37.171665,156.057612>}
      triangle {<-25.202779,33.372456,134.700770>,<-25.245809,25.911701,134.700770>,<-25.245809,25.911701,159.960467>}
      triangle {<-25.202779,33.372456,134.700770>,<-25.245809,25.911701,159.960467>,<-25.202779,33.372456,153.646729>}
      triangle {<-25.245809,25.911701,134.700770>,<0.236453,22.250233,134.700770>,<0.236453,22.250233,165.952445>}
      triangle {<-25.245809,25.911701,134.700770>,<0.236453,22.250233,165.952445>,<-25.245809,25.911701,159.960467>}
      triangle {<0.236453,22.250233,134.700770>,<25.761782,26.049488,134.700770>,<25.761782,26.049488,160.162976>}
      triangle {<0.236453,22.250233,134.700770>,<25.761782,26.049488,160.162976>,<0.236453,22.250233,165.952445>}
      triangle {<25.804789,33.510227,134.700770>,<25.761782,26.049488,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<0.322527,37.171665,134.700770>,<25.804789,33.510227,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<-25.202779,33.372456,134.700770>,<0.322527,37.171665,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<-25.245809,25.911701,134.700770>,<-25.202779,33.372456,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<0.236453,22.250233,134.700770>,<-25.245809,25.911701,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<25.761782,26.049488,134.700770>,<0.236453,22.250233,134.700770>,<0.279505,29.710926,134.700770>}
      triangle {<25.761782,26.049488,160.162976>,<25.804789,33.510227,153.840560>,<0.279505,29.710926,160.953825>}
      triangle {<25.804789,33.510227,153.840560>,<0.322527,37.171665,156.057612>,<0.279505,29.710926,160.953825>}
      triangle {<0.322527,37.171665,156.057612>,<-25.202779,33.372456,153.646729>,<0.279505,29.710926,160.953825>}
      triangle {<-25.202779,33.372456,153.646729>,<-25.245809,25.911701,159.960467>,<0.279505,29.710926,160.953825>}
      triangle {<-25.245809,25.911701,159.960467>,<0.236453,22.250233,165.952445>,<0.279505,29.710926,160.953825>}
      triangle {<0.236453,22.250233,165.952445>,<25.761782,26.049488,160.162976>,<0.279505,29.710926,160.953825>}
      texture{_Bridge01}
    }
    //_Bridge02
    mesh{
      triangle {<-4.893598,-0.886753,185.157022>,<-4.893598,34.979572,140.397704>,<-4.893590,-0.886753,135.853831>}
      triangle {<-4.893598,-0.886753,185.157022>,<-4.893598,34.979572,165.534409>,<-4.893598,34.979572,140.397704>}
      triangle {<-4.893598,-0.886753,185.157022>,<4.976229,-0.886753,135.845359>,<4.976229,-0.886753,185.157024>}
      triangle {<-4.893598,-0.886753,185.157022>,<-4.893590,-0.886753,135.853831>,<4.976229,-0.886753,135.845359>}
      triangle {<-4.893590,-0.886753,135.853831>,<4.976229,34.979572,140.397708>,<4.976229,-0.886753,135.845359>}
      triangle {<-4.893590,-0.886753,135.853831>,<-4.893598,34.979572,140.397704>,<4.976229,34.979572,140.397708>}
      triangle {<-4.893598,34.979572,140.397704>,<4.976229,34.979572,165.534410>,<4.976229,34.979572,140.397708>}
      triangle {<-4.893598,34.979572,140.397704>,<-4.893598,34.979572,165.534409>,<4.976229,34.979572,165.534410>}
      triangle {<-4.893598,34.979572,165.534409>,<4.976229,-0.886753,185.157024>,<4.976229,34.979572,165.534410>}
      triangle {<-4.893598,34.979572,165.534409>,<-4.893598,-0.886753,185.157022>,<4.976229,-0.886753,185.157024>}
      triangle {<4.976229,-0.886753,185.157024>,<4.976229,34.979572,140.397708>,<4.976229,34.979572,165.534410>}
      triangle {<4.976229,-0.886753,185.157024>,<4.976229,-0.886753,135.845359>,<4.976229,34.979572,140.397708>}
      triangle {<3.651255,-0.425785,186.129123>,<3.651255,34.371479,165.295438>,<3.651255,-0.466595,184.793245>}
      triangle {<3.651255,-0.425785,186.129123>,<3.651255,34.412296,166.631309>,<3.651255,34.371479,165.295438>}
      triangle {<3.651255,-0.425785,186.129123>,<4.388400,-0.466595,184.793243>,<4.388400,-0.425785,186.129124>}
      triangle {<3.651255,-0.425785,186.129123>,<3.651255,-0.466595,184.793245>,<4.388400,-0.466595,184.793243>}
      triangle {<3.651255,-0.466595,184.793245>,<4.388400,34.371479,165.295429>,<4.388400,-0.466595,184.793243>}
      triangle {<3.651255,-0.466595,184.793245>,<3.651255,34.371479,165.295438>,<4.388400,34.371479,165.295429>}
      triangle {<3.651255,34.371479,165.295438>,<4.388400,34.412296,166.631309>,<4.388400,34.371479,165.295429>}
      triangle {<3.651255,34.371479,165.295438>,<3.651255,34.412296,166.631309>,<4.388400,34.412296,166.631309>}
      triangle {<3.651255,34.412296,166.631309>,<4.388400,-0.425785,186.129124>,<4.388400,34.412296,166.631309>}
      triangle {<3.651255,34.412296,166.631309>,<3.651255,-0.425785,186.129123>,<4.388400,-0.425785,186.129124>}
      triangle {<4.388400,-0.425785,186.129124>,<4.388400,34.371479,165.295429>,<4.388400,34.412296,166.631309>}
      triangle {<4.388400,-0.425785,186.129124>,<4.388400,-0.466595,184.793243>,<4.388400,34.371479,165.295429>}
      triangle {<-4.411748,-0.425785,186.129124>,<-4.411748,34.371479,165.295431>,<-4.411748,-0.466595,184.793245>}
      triangle {<-4.411748,-0.425785,186.129124>,<-4.411748,34.412296,166.631313>,<-4.411748,34.371479,165.295431>}
      triangle {<-4.411748,-0.425785,186.129124>,<-3.674604,-0.466595,184.793244>,<-3.674604,-0.425785,186.129126>}
      triangle {<-4.411748,-0.425785,186.129124>,<-4.411748,-0.466595,184.793245>,<-3.674604,-0.466595,184.793244>}
      triangle {<-4.411748,-0.466595,184.793245>,<-3.674604,34.371479,165.295440>,<-3.674604,-0.466595,184.793244>}
      triangle {<-4.411748,-0.466595,184.793245>,<-4.411748,34.371479,165.295431>,<-3.674604,34.371479,165.295440>}
      triangle {<-4.411748,34.371479,165.295431>,<-3.674604,34.412296,166.631313>,<-3.674604,34.371479,165.295440>}
      triangle {<-4.411748,34.371479,165.295431>,<-4.411748,34.412296,166.631313>,<-3.674604,34.412296,166.631313>}
      triangle {<-4.411748,34.412296,166.631313>,<-3.674604,-0.425785,186.129126>,<-3.674604,34.412296,166.631313>}
      triangle {<-4.411748,34.412296,166.631313>,<-4.411748,-0.425785,186.129124>,<-3.674604,-0.425785,186.129126>}
      triangle {<-3.674604,-0.425785,186.129126>,<-3.674604,34.371479,165.295440>,<-3.674604,34.412296,166.631313>}
      triangle {<-3.674604,-0.425785,186.129126>,<-3.674604,-0.466595,184.793244>,<-3.674604,34.371479,165.295440>}
      texture{_Bridge02}
    }
    //_Shield02
    mesh{
      triangle {<22.574702,38.356342,139.680160>,<21.920680,38.356342,138.101203>,<20.341715,38.356342,139.680160>}
      triangle {<21.920680,38.356342,138.101203>,<20.341715,38.356342,137.447177>,<20.341715,38.356342,139.680160>}
      triangle {<20.341715,38.356342,137.447177>,<18.762759,38.356342,138.101203>,<20.341715,38.356342,139.680160>}
      triangle {<18.762759,38.356342,138.101203>,<18.108737,38.356342,139.680160>,<20.341715,38.356342,139.680160>}
      triangle {<18.108737,38.356342,139.680160>,<18.762759,38.356342,141.259116>,<20.341715,38.356342,139.680160>}
      triangle {<18.762759,38.356342,141.259116>,<20.341715,38.356342,141.913142>,<20.341715,38.356342,139.680160>}
      triangle {<20.341715,38.356342,141.913142>,<21.920680,38.356342,141.259116>,<20.341715,38.356342,139.680160>}
      triangle {<21.920680,38.356342,141.259116>,<22.574702,38.356342,139.680160>,<20.341715,38.356342,139.680160>}
      triangle {<22.574702,38.356342,139.680160>,<23.319026,33.637165,139.680163>,<22.446993,33.637165,137.574885>}
      triangle {<22.574702,38.356342,139.680160>,<22.446993,33.637165,137.574885>,<21.920680,38.356342,138.101203>}
      triangle {<21.920680,38.356342,138.101203>,<22.446993,33.637165,137.574885>,<20.341715,33.637165,136.702853>}
      triangle {<21.920680,38.356342,138.101203>,<20.341715,33.637165,136.702853>,<20.341715,38.356342,137.447177>}
      triangle {<20.341715,38.356342,137.447177>,<20.341715,33.637165,136.702853>,<18.236445,33.637165,137.574885>}
      triangle {<20.341715,38.356342,137.447177>,<18.236445,33.637165,137.574885>,<18.762759,38.356342,138.101203>}
      triangle {<18.762759,38.356342,138.101203>,<18.236445,33.637165,137.574885>,<17.364405,33.637165,139.680163>}
      triangle {<18.762759,38.356342,138.101203>,<17.364405,33.637165,139.680163>,<18.108737,38.356342,139.680160>}
      triangle {<18.108737,38.356342,139.680160>,<17.364405,33.637165,139.680163>,<18.236445,33.637165,141.785438>}
      triangle {<18.108737,38.356342,139.680160>,<18.236445,33.637165,141.785438>,<18.762759,38.356342,141.259116>}
      triangle {<18.762759,38.356342,141.259116>,<18.236445,33.637165,141.785438>,<20.341715,33.637165,142.657470>}
      triangle {<18.762759,38.356342,141.259116>,<20.341715,33.637165,142.657470>,<20.341715,38.356342,141.913142>}
      triangle {<20.341715,38.356342,141.913142>,<20.341715,33.637165,142.657470>,<22.446993,33.637165,141.785438>}
      triangle {<20.341715,38.356342,141.913142>,<22.446993,33.637165,141.785438>,<21.920680,38.356342,141.259116>}
      triangle {<21.920680,38.356342,141.259116>,<22.446993,33.637165,141.785438>,<23.319026,33.637165,139.680163>}
      triangle {<21.920680,38.356342,141.259116>,<23.319026,33.637165,139.680163>,<22.574702,38.356342,139.680160>}
      triangle {<23.319026,33.637165,139.680163>,<20.341715,33.637165,139.680163>,<22.446993,33.637165,137.574885>}
      triangle {<22.446993,33.637165,137.574885>,<20.341715,33.637165,139.680163>,<20.341715,33.637165,136.702853>}
      triangle {<20.341715,33.637165,136.702853>,<20.341715,33.637165,139.680163>,<18.236445,33.637165,137.574885>}
      triangle {<18.236445,33.637165,137.574885>,<20.341715,33.637165,139.680163>,<17.364405,33.637165,139.680163>}
      triangle {<17.364405,33.637165,139.680163>,<20.341715,33.637165,139.680163>,<18.236445,33.637165,141.785438>}
      triangle {<18.236445,33.637165,141.785438>,<20.341715,33.637165,139.680163>,<20.341715,33.637165,142.657470>}
      triangle {<20.341715,33.637165,142.657470>,<20.341715,33.637165,139.680163>,<22.446993,33.637165,141.785438>}
      triangle {<22.446993,33.637165,141.785438>,<20.341715,33.637165,139.680163>,<23.319026,33.637165,139.680163>}
      triangle {<20.154047,45.797916,139.596248>,<19.330256,45.479237,141.023093>,<21.801623,45.479237,139.596248>}
      triangle {<19.330256,45.479237,141.023093>,<18.625300,44.569172,142.244109>,<21.108866,45.363911,141.250056>}
      triangle {<19.330256,45.479237,141.023093>,<21.108866,45.363911,141.250056>,<21.801623,45.479237,139.596248>}
      triangle {<21.801623,45.479237,139.596248>,<21.108866,45.363911,141.250056>,<23.211527,44.569172,139.596248>}
      triangle {<18.625300,44.569172,142.244109>,<18.140872,43.199009,143.083282>,<20.575961,44.207005,142.965140>}
      triangle {<18.625300,44.569172,142.244109>,<20.575961,44.207005,142.965140>,<21.108866,45.363911,141.250056>}
      triangle {<21.108866,45.363911,141.250056>,<20.575961,44.207005,142.965140>,<22.860629,44.207005,141.646087>}
      triangle {<21.108866,45.363911,141.250056>,<22.860629,44.207005,141.646087>,<23.211527,44.569172,139.596248>}
      triangle {<23.211527,44.569172,139.596248>,<22.860629,44.207005,141.646087>,<24.180384,43.199009,139.596248>}
      triangle {<18.140872,43.199009,143.083282>,<17.946848,41.566380,143.419223>,<20.150645,41.702396,144.002894>}
      triangle {<18.140872,43.199009,143.083282>,<20.150645,41.702396,144.002894>,<20.575961,44.207005,142.965140>}
      triangle {<20.575961,44.207005,142.965140>,<20.150645,41.702396,144.002894>,<22.355349,41.752186,143.409011>}
      triangle {<20.575961,44.207005,142.965140>,<22.355349,41.752186,143.409011>,<22.860629,44.207005,141.646087>}
      triangle {<22.860629,44.207005,141.646087>,<22.355349,41.752186,143.409011>,<23.971911,41.702396,141.796569>}
      triangle {<22.860629,44.207005,141.646087>,<23.971911,41.702396,141.796569>,<24.180384,43.199009,139.596248>}
      triangle {<24.180384,43.199009,139.596248>,<23.971911,41.702396,141.796569>,<24.568438,41.566380,139.596248>}
      triangle {<17.946848,41.566380,143.419223>,<18.071215,39.906788,143.203807>,<19.594424,39.236347,143.419341>}
      triangle {<17.946848,41.566380,143.419223>,<19.594424,39.236347,143.419341>,<20.150645,41.702396,144.002894>}
      triangle {<20.150645,41.702396,144.002894>,<19.594424,39.236347,143.419341>,<21.198359,38.875065,143.083163>}
      triangle {<20.150645,41.702396,144.002894>,<21.198359,38.875065,143.083163>,<22.355349,41.752186,143.409011>}
      triangle {<22.355349,41.752186,143.409011>,<21.198359,38.875065,143.083163>,<22.651644,38.875065,142.244109>}
      triangle {<22.355349,41.752186,143.409011>,<22.651644,38.875065,142.244109>,<23.971911,41.702396,141.796569>}
      triangle {<23.971911,41.702396,141.796569>,<22.651644,38.875065,142.244109>,<23.744647,39.236347,141.023093>}
      triangle {<23.971911,41.702396,141.796569>,<23.744647,39.236347,141.023093>,<24.568438,41.566380,139.596248>}
      triangle {<24.568438,41.566380,139.596248>,<23.744647,39.236347,141.023093>,<24.319689,39.906788,139.596251>}
      triangle {<20.154047,45.797916,139.596248>,<21.801623,45.479237,139.596248>,<19.330256,45.479237,138.169406>}
      triangle {<21.801623,45.479237,139.596248>,<23.211527,44.569172,139.596248>,<21.108866,45.363911,137.942439>}
      triangle {<21.801623,45.479237,139.596248>,<21.108866,45.363911,137.942439>,<19.330256,45.479237,138.169406>}
      triangle {<19.330256,45.479237,138.169406>,<21.108866,45.363911,137.942439>,<18.625300,44.569172,136.948390>}
      triangle {<23.211527,44.569172,139.596248>,<24.180384,43.199009,139.596248>,<22.860629,44.207005,137.546412>}
      triangle {<23.211527,44.569172,139.596248>,<22.860629,44.207005,137.546412>,<21.108866,45.363911,137.942439>}
      triangle {<21.108866,45.363911,137.942439>,<22.860629,44.207005,137.546412>,<20.575961,44.207005,136.227359>}
      triangle {<21.108866,45.363911,137.942439>,<20.575961,44.207005,136.227359>,<18.625300,44.569172,136.948390>}
      triangle {<18.625300,44.569172,136.948390>,<20.575961,44.207005,136.227359>,<18.140872,43.199009,136.109336>}
      triangle {<24.180384,43.199009,139.596248>,<24.568438,41.566380,139.596248>,<23.971911,41.702396,137.395926>}
      triangle {<24.180384,43.199009,139.596248>,<23.971911,41.702396,137.395926>,<22.860629,44.207005,137.546412>}
      triangle {<22.860629,44.207005,137.546412>,<23.971911,41.702396,137.395926>,<22.355349,41.752186,135.783484>}
      triangle {<22.860629,44.207005,137.546412>,<22.355349,41.752186,135.783484>,<20.575961,44.207005,136.227359>}
      triangle {<20.575961,44.207005,136.227359>,<22.355349,41.752186,135.783484>,<20.150645,41.702396,135.189727>}
      triangle {<20.575961,44.207005,136.227359>,<20.150645,41.702396,135.189727>,<18.140872,43.199009,136.109336>}
      triangle {<18.140872,43.199009,136.109336>,<20.150645,41.702396,135.189727>,<17.946848,41.566380,135.773276>}
      triangle {<24.568438,41.566380,139.596248>,<24.319689,39.906788,139.596251>,<23.744647,39.236347,138.169410>}
      triangle {<24.568438,41.566380,139.596248>,<23.744647,39.236347,138.169410>,<23.971911,41.702396,137.395926>}
      triangle {<23.971911,41.702396,137.395926>,<23.744647,39.236347,138.169410>,<22.651652,38.875065,136.948394>}
      triangle {<23.971911,41.702396,137.395926>,<22.651652,38.875065,136.948394>,<22.355349,41.752186,135.783484>}
      triangle {<22.355349,41.752186,135.783484>,<22.651652,38.875065,136.948394>,<21.198359,38.875065,136.109340>}
      triangle {<22.355349,41.752186,135.783484>,<21.198359,38.875065,136.109340>,<20.150645,41.702396,135.189727>}
      triangle {<20.150645,41.702396,135.189727>,<21.198359,38.875065,136.109340>,<19.594424,39.236347,135.773280>}
      triangle {<20.150645,41.702396,135.189727>,<19.594424,39.236347,135.773280>,<17.946848,41.566380,135.773276>}
      triangle {<17.946848,41.566380,135.773276>,<19.594424,39.236347,135.773280>,<18.071215,39.906788,135.988692>}
      triangle {<20.154047,45.797916,139.596248>,<19.330256,45.479237,138.169406>,<19.330256,45.479237,141.023093>}
      triangle {<19.330256,45.479237,138.169406>,<18.625300,44.569172,136.948390>,<18.244395,45.363911,139.596248>}
      triangle {<19.330256,45.479237,138.169406>,<18.244395,45.363911,139.596248>,<19.330256,45.479237,141.023093>}
      triangle {<19.330256,45.479237,141.023093>,<18.244395,45.363911,139.596248>,<18.625300,44.569172,142.244109>}
      triangle {<18.625300,44.569172,136.948390>,<18.140872,43.199009,136.109336>,<17.025538,44.207005,138.277194>}
      triangle {<18.625300,44.569172,136.948390>,<17.025538,44.207005,138.277194>,<18.244395,45.363911,139.596248>}
      triangle {<18.244395,45.363911,139.596248>,<17.025538,44.207005,138.277194>,<17.025538,44.207005,140.915305>}
      triangle {<18.244395,45.363911,139.596248>,<17.025538,44.207005,140.915305>,<18.625300,44.569172,142.244109>}
      triangle {<18.625300,44.569172,142.244109>,<17.025538,44.207005,140.915305>,<18.140872,43.199009,143.083282>}
      triangle {<18.140872,43.199009,136.109336>,<17.946848,41.566380,135.773276>,<16.339571,41.702396,137.390040>}
      triangle {<18.140872,43.199009,136.109336>,<16.339571,41.702396,137.390040>,<17.025538,44.207005,138.277194>}
      triangle {<17.025538,44.207005,138.277194>,<16.339571,41.702396,137.390040>,<15.751444,41.752186,139.596248>}
      triangle {<17.025538,44.207005,138.277194>,<15.751444,41.752186,139.596248>,<17.025538,44.207005,140.915305>}
      triangle {<17.025538,44.207005,140.915305>,<15.751444,41.752186,139.596248>,<16.339571,41.702396,141.802459>}
      triangle {<17.025538,44.207005,140.915305>,<16.339571,41.702396,141.802459>,<18.140872,43.199009,143.083282>}
      triangle {<18.140872,43.199009,143.083282>,<16.339571,41.702396,141.802459>,<17.946848,41.566380,143.419223>}
      triangle {<17.946848,41.566380,135.773276>,<18.071215,39.906788,135.988692>,<17.123057,39.236347,137.200122>}
      triangle {<17.946848,41.566380,135.773276>,<17.123057,39.236347,137.200122>,<16.339571,41.702396,137.390040>}
      triangle {<16.339571,41.702396,137.390040>,<17.123057,39.236347,137.200122>,<16.612132,38.875065,138.757197>}
      triangle {<16.339571,41.702396,137.390040>,<16.612132,38.875065,138.757197>,<15.751444,41.752186,139.596248>}
      triangle {<15.751444,41.752186,139.596248>,<16.612132,38.875065,138.757197>,<16.612132,38.875065,140.435306>}
      triangle {<15.751444,41.752186,139.596248>,<16.612132,38.875065,140.435306>,<16.339571,41.702396,141.802459>}
      triangle {<16.339571,41.702396,141.802459>,<16.612132,38.875065,140.435306>,<17.123057,39.236347,141.992377>}
      triangle {<16.339571,41.702396,141.802459>,<17.123057,39.236347,141.992377>,<17.946848,41.566380,143.419223>}
      triangle {<17.946848,41.566380,143.419223>,<17.123057,39.236347,141.992377>,<18.071215,39.906788,143.203807>}
      triangle {<18.071215,39.906788,143.203807>,<17.123057,39.236347,141.992377>,<19.594424,39.236347,143.419341>}
      triangle {<17.123057,39.236347,141.992377>,<16.612132,38.875065,140.435306>,<18.594088,38.251026,142.298301>}
      triangle {<17.123057,39.236347,141.992377>,<18.594088,38.251026,142.298301>,<19.594424,39.236347,143.419341>}
      triangle {<19.594424,39.236347,143.419341>,<18.594088,38.251026,142.298301>,<21.198359,38.875065,143.083163>}
      triangle {<16.612132,38.875065,140.435306>,<16.612132,38.875065,138.757197>,<18.200266,37.487522,140.342181>}
      triangle {<16.612132,38.875065,140.435306>,<18.200266,37.487522,140.342181>,<18.594088,38.251026,142.298301>}
      triangle {<18.594088,38.251026,142.298301>,<18.200266,37.487522,140.342181>,<20.484942,37.487522,141.661235>}
      triangle {<18.594088,38.251026,142.298301>,<20.484942,37.487522,141.661235>,<21.198359,38.875065,143.083163>}
      triangle {<21.198359,38.875065,143.083163>,<20.484942,37.487522,141.661235>,<22.651644,38.875065,142.244109>}
      triangle {<16.612132,38.875065,138.757197>,<17.123057,39.236347,137.200122>,<18.726977,37.675663,137.655589>}
      triangle {<16.612132,38.875065,138.757197>,<18.726977,37.675663,137.655589>,<18.200266,37.487522,140.342181>}
      triangle {<18.200266,37.487522,140.342181>,<18.726977,37.675663,137.655589>,<20.712176,37.104557,138.629550>}
      triangle {<18.200266,37.487522,140.342181>,<20.712176,37.104557,138.629550>,<20.484942,37.487522,141.661235>}
      triangle {<20.484942,37.487522,141.661235>,<20.712176,37.104557,138.629550>,<22.548243,37.675663,139.861796>}
      triangle {<20.484942,37.487522,141.661235>,<22.548243,37.675663,139.861796>,<22.651644,38.875065,142.244109>}
      triangle {<22.651644,38.875065,142.244109>,<22.548243,37.675663,139.861796>,<23.744647,39.236347,141.023093>}
      triangle {<17.123057,39.236347,137.200122>,<18.071215,39.906788,135.988692>,<19.594424,39.236347,135.773280>}
      triangle {<17.123057,39.236347,137.200122>,<19.594424,39.236347,135.773280>,<18.726977,37.675663,137.655589>}
      triangle {<18.726977,37.675663,137.655589>,<19.594424,39.236347,135.773280>,<21.198359,38.875065,136.109340>}
      triangle {<18.726977,37.675663,137.655589>,<21.198359,38.875065,136.109340>,<20.712176,37.104557,138.629550>}
      triangle {<20.712176,37.104557,138.629550>,<21.198359,38.875065,136.109340>,<22.651652,38.875065,136.948394>}
      triangle {<20.712176,37.104557,138.629550>,<22.651652,38.875065,136.948394>,<22.548243,37.675663,139.861796>}
      triangle {<22.548243,37.675663,139.861796>,<22.651652,38.875065,136.948394>,<23.744647,39.236347,138.169410>}
      triangle {<22.548243,37.675663,139.861796>,<23.744647,39.236347,138.169410>,<23.744647,39.236347,141.023093>}
      triangle {<23.744647,39.236347,141.023093>,<23.744647,39.236347,138.169410>,<24.319689,39.906788,139.596251>}
      texture{_Shield02}
    }
    //_Shield01
    mesh{
      triangle {<-17.535757,38.356342,139.680160>,<-18.189779,38.356342,138.101203>,<-19.768743,38.356342,139.680160>}
      triangle {<-18.189779,38.356342,138.101203>,<-19.768743,38.356342,137.447177>,<-19.768743,38.356342,139.680160>}
      triangle {<-19.768743,38.356342,137.447177>,<-21.347700,38.356342,138.101203>,<-19.768743,38.356342,139.680160>}
      triangle {<-21.347700,38.356342,138.101203>,<-22.001722,38.356342,139.680160>,<-19.768743,38.356342,139.680160>}
      triangle {<-22.001722,38.356342,139.680160>,<-21.347700,38.356342,141.259116>,<-19.768743,38.356342,139.680160>}
      triangle {<-21.347700,38.356342,141.259116>,<-19.768743,38.356342,141.913142>,<-19.768743,38.356342,139.680160>}
      triangle {<-19.768743,38.356342,141.913142>,<-18.189779,38.356342,141.259116>,<-19.768743,38.356342,139.680160>}
      triangle {<-18.189779,38.356342,141.259116>,<-17.535757,38.356342,139.680160>,<-19.768743,38.356342,139.680160>}
      triangle {<-17.535757,38.356342,139.680160>,<-16.791433,33.637165,139.680163>,<-17.663465,33.637165,137.574885>}
      triangle {<-17.535757,38.356342,139.680160>,<-17.663465,33.637165,137.574885>,<-18.189779,38.356342,138.101203>}
      triangle {<-18.189779,38.356342,138.101203>,<-17.663465,33.637165,137.574885>,<-19.768743,33.637165,136.702853>}
      triangle {<-18.189779,38.356342,138.101203>,<-19.768743,33.637165,136.702853>,<-19.768743,38.356342,137.447177>}
      triangle {<-19.768743,38.356342,137.447177>,<-19.768743,33.637165,136.702853>,<-21.874013,33.637165,137.574885>}
      triangle {<-19.768743,38.356342,137.447177>,<-21.874013,33.637165,137.574885>,<-21.347700,38.356342,138.101203>}
      triangle {<-21.347700,38.356342,138.101203>,<-21.874013,33.637165,137.574885>,<-22.746053,33.637165,139.680163>}
      triangle {<-21.347700,38.356342,138.101203>,<-22.746053,33.637165,139.680163>,<-22.001722,38.356342,139.680160>}
      triangle {<-22.001722,38.356342,139.680160>,<-22.746053,33.637165,139.680163>,<-21.874013,33.637165,141.785438>}
      triangle {<-22.001722,38.356342,139.680160>,<-21.874013,33.637165,141.785438>,<-21.347700,38.356342,141.259116>}
      triangle {<-21.347700,38.356342,141.259116>,<-21.874013,33.637165,141.785438>,<-19.768743,33.637165,142.657470>}
      triangle {<-21.347700,38.356342,141.259116>,<-19.768743,33.637165,142.657470>,<-19.768743,38.356342,141.913142>}
      triangle {<-19.768743,38.356342,141.913142>,<-19.768743,33.637165,142.657470>,<-17.663465,33.637165,141.785438>}
      triangle {<-19.768743,38.356342,141.913142>,<-17.663465,33.637165,141.785438>,<-18.189779,38.356342,141.259116>}
      triangle {<-18.189779,38.356342,141.259116>,<-17.663465,33.637165,141.785438>,<-16.791433,33.637165,139.680163>}
      triangle {<-18.189779,38.356342,141.259116>,<-16.791433,33.637165,139.680163>,<-17.535757,38.356342,139.680160>}
      triangle {<-16.791433,33.637165,139.680163>,<-19.768743,33.637165,139.680163>,<-17.663465,33.637165,137.574885>}
      triangle {<-17.663465,33.637165,137.574885>,<-19.768743,33.637165,139.680163>,<-19.768743,33.637165,136.702853>}
      triangle {<-19.768743,33.637165,136.702853>,<-19.768743,33.637165,139.680163>,<-21.874013,33.637165,137.574885>}
      triangle {<-21.874013,33.637165,137.574885>,<-19.768743,33.637165,139.680163>,<-22.746053,33.637165,139.680163>}
      triangle {<-22.746053,33.637165,139.680163>,<-19.768743,33.637165,139.680163>,<-21.874013,33.637165,141.785438>}
      triangle {<-21.874013,33.637165,141.785438>,<-19.768743,33.637165,139.680163>,<-19.768743,33.637165,142.657470>}
      triangle {<-19.768743,33.637165,142.657470>,<-19.768743,33.637165,139.680163>,<-17.663465,33.637165,141.785438>}
      triangle {<-17.663465,33.637165,141.785438>,<-19.768743,33.637165,139.680163>,<-16.791433,33.637165,139.680163>}
      triangle {<-19.684835,45.797932,139.596248>,<-20.508626,45.479252,141.023093>,<-18.037260,45.479252,139.596248>}
      triangle {<-20.508626,45.479252,141.023093>,<-21.213583,44.569187,142.244109>,<-18.730016,45.363926,141.250056>}
      triangle {<-20.508626,45.479252,141.023093>,<-18.730016,45.363926,141.250056>,<-18.037260,45.479252,139.596248>}
      triangle {<-18.037260,45.479252,139.596248>,<-18.730016,45.363926,141.250056>,<-16.627355,44.569187,139.596248>}
      triangle {<-21.213583,44.569187,142.244109>,<-21.698011,43.199024,143.083282>,<-19.262922,44.207020,142.965140>}
      triangle {<-21.213583,44.569187,142.244109>,<-19.262922,44.207020,142.965140>,<-18.730016,45.363926,141.250056>}
      triangle {<-18.730016,45.363926,141.250056>,<-19.262922,44.207020,142.965140>,<-16.978254,44.207020,141.646087>}
      triangle {<-18.730016,45.363926,141.250056>,<-16.978254,44.207020,141.646087>,<-16.627355,44.569187,139.596248>}
      triangle {<-16.627355,44.569187,139.596248>,<-16.978254,44.207020,141.646087>,<-15.658498,43.199024,139.596248>}
      triangle {<-21.698011,43.199024,143.083282>,<-21.892034,41.566395,143.419223>,<-19.688238,41.702412,144.002894>}
      triangle {<-21.698011,43.199024,143.083282>,<-19.688238,41.702412,144.002894>,<-19.262922,44.207020,142.965140>}
      triangle {<-19.262922,44.207020,142.965140>,<-19.688238,41.702412,144.002894>,<-17.483533,41.752201,143.409011>}
      triangle {<-19.262922,44.207020,142.965140>,<-17.483533,41.752201,143.409011>,<-16.978254,44.207020,141.646087>}
      triangle {<-16.978254,44.207020,141.646087>,<-17.483533,41.752201,143.409011>,<-15.866971,41.702412,141.796569>}
      triangle {<-16.978254,44.207020,141.646087>,<-15.866971,41.702412,141.796569>,<-15.658498,43.199024,139.596248>}
      triangle {<-15.658498,43.199024,139.596248>,<-15.866971,41.702412,141.796569>,<-15.270444,41.566395,139.596248>}
      triangle {<-21.892034,41.566395,143.419223>,<-21.767667,39.906803,143.203807>,<-20.244459,39.236362,143.419341>}
      triangle {<-21.892034,41.566395,143.419223>,<-20.244459,39.236362,143.419341>,<-19.688238,41.702412,144.002894>}
      triangle {<-19.688238,41.702412,144.002894>,<-20.244459,39.236362,143.419341>,<-18.640523,38.875080,143.083163>}
      triangle {<-19.688238,41.702412,144.002894>,<-18.640523,38.875080,143.083163>,<-17.483533,41.752201,143.409011>}
      triangle {<-17.483533,41.752201,143.409011>,<-18.640523,38.875080,143.083163>,<-17.187238,38.875080,142.244109>}
      triangle {<-17.483533,41.752201,143.409011>,<-17.187238,38.875080,142.244109>,<-15.866971,41.702412,141.796569>}
      triangle {<-15.866971,41.702412,141.796569>,<-17.187238,38.875080,142.244109>,<-16.094236,39.236362,141.023093>}
      triangle {<-15.866971,41.702412,141.796569>,<-16.094236,39.236362,141.023093>,<-15.270444,41.566395,139.596248>}
      triangle {<-15.270444,41.566395,139.596248>,<-16.094236,39.236362,141.023093>,<-15.519193,39.906803,139.596251>}
      triangle {<-19.684835,45.797932,139.596248>,<-18.037260,45.479252,139.596248>,<-20.508626,45.479252,138.169406>}
      triangle {<-18.037260,45.479252,139.596248>,<-16.627355,44.569187,139.596248>,<-18.730016,45.363926,137.942439>}
      triangle {<-18.037260,45.479252,139.596248>,<-18.730016,45.363926,137.942439>,<-20.508626,45.479252,138.169406>}
      triangle {<-20.508626,45.479252,138.169406>,<-18.730016,45.363926,137.942439>,<-21.213583,44.569187,136.948390>}
      triangle {<-16.627355,44.569187,139.596248>,<-15.658498,43.199024,139.596248>,<-16.978254,44.207020,137.546412>}
      triangle {<-16.627355,44.569187,139.596248>,<-16.978254,44.207020,137.546412>,<-18.730016,45.363926,137.942439>}
      triangle {<-18.730016,45.363926,137.942439>,<-16.978254,44.207020,137.546412>,<-19.262922,44.207020,136.227359>}
      triangle {<-18.730016,45.363926,137.942439>,<-19.262922,44.207020,136.227359>,<-21.213583,44.569187,136.948390>}
      triangle {<-21.213583,44.569187,136.948390>,<-19.262922,44.207020,136.227359>,<-21.698011,43.199024,136.109336>}
      triangle {<-15.658498,43.199024,139.596248>,<-15.270444,41.566395,139.596248>,<-15.866971,41.702412,137.395926>}
      triangle {<-15.658498,43.199024,139.596248>,<-15.866971,41.702412,137.395926>,<-16.978254,44.207020,137.546412>}
      triangle {<-16.978254,44.207020,137.546412>,<-15.866971,41.702412,137.395926>,<-17.483533,41.752201,135.783484>}
      triangle {<-16.978254,44.207020,137.546412>,<-17.483533,41.752201,135.783484>,<-19.262922,44.207020,136.227359>}
      triangle {<-19.262922,44.207020,136.227359>,<-17.483533,41.752201,135.783484>,<-19.688238,41.702412,135.189727>}
      triangle {<-19.262922,44.207020,136.227359>,<-19.688238,41.702412,135.189727>,<-21.698011,43.199024,136.109336>}
      triangle {<-21.698011,43.199024,136.109336>,<-19.688238,41.702412,135.189727>,<-21.892034,41.566395,135.773276>}
      triangle {<-15.270444,41.566395,139.596248>,<-15.519193,39.906803,139.596251>,<-16.094236,39.236362,138.169410>}
      triangle {<-15.270444,41.566395,139.596248>,<-16.094236,39.236362,138.169410>,<-15.866971,41.702412,137.395926>}
      triangle {<-15.866971,41.702412,137.395926>,<-16.094236,39.236362,138.169410>,<-17.187231,38.875080,136.948394>}
      triangle {<-15.866971,41.702412,137.395926>,<-17.187231,38.875080,136.948394>,<-17.483533,41.752201,135.783484>}
      triangle {<-17.483533,41.752201,135.783484>,<-17.187231,38.875080,136.948394>,<-18.640523,38.875080,136.109340>}
      triangle {<-17.483533,41.752201,135.783484>,<-18.640523,38.875080,136.109340>,<-19.688238,41.702412,135.189727>}
      triangle {<-19.688238,41.702412,135.189727>,<-18.640523,38.875080,136.109340>,<-20.244459,39.236362,135.773280>}
      triangle {<-19.688238,41.702412,135.189727>,<-20.244459,39.236362,135.773280>,<-21.892034,41.566395,135.773276>}
      triangle {<-21.892034,41.566395,135.773276>,<-20.244459,39.236362,135.773280>,<-21.767667,39.906803,135.988692>}
      triangle {<-19.684835,45.797932,139.596248>,<-20.508626,45.479252,138.169406>,<-20.508626,45.479252,141.023093>}
      triangle {<-20.508626,45.479252,138.169406>,<-21.213583,44.569187,136.948390>,<-21.594488,45.363926,139.596248>}
      triangle {<-20.508626,45.479252,138.169406>,<-21.594488,45.363926,139.596248>,<-20.508626,45.479252,141.023093>}
      triangle {<-20.508626,45.479252,141.023093>,<-21.594488,45.363926,139.596248>,<-21.213583,44.569187,142.244109>}
      triangle {<-21.213583,44.569187,136.948390>,<-21.698011,43.199024,136.109336>,<-22.813344,44.207020,138.277194>}
      triangle {<-21.213583,44.569187,136.948390>,<-22.813344,44.207020,138.277194>,<-21.594488,45.363926,139.596248>}
      triangle {<-21.594488,45.363926,139.596248>,<-22.813344,44.207020,138.277194>,<-22.813344,44.207020,140.915305>}
      triangle {<-21.594488,45.363926,139.596248>,<-22.813344,44.207020,140.915305>,<-21.213583,44.569187,142.244109>}
      triangle {<-21.213583,44.569187,142.244109>,<-22.813344,44.207020,140.915305>,<-21.698011,43.199024,143.083282>}
      triangle {<-21.698011,43.199024,136.109336>,<-21.892034,41.566395,135.773276>,<-23.499311,41.702412,137.390040>}
      triangle {<-21.698011,43.199024,136.109336>,<-23.499311,41.702412,137.390040>,<-22.813344,44.207020,138.277194>}
      triangle {<-22.813344,44.207020,138.277194>,<-23.499311,41.702412,137.390040>,<-24.087438,41.752201,139.596248>}
      triangle {<-22.813344,44.207020,138.277194>,<-24.087438,41.752201,139.596248>,<-22.813344,44.207020,140.915305>}
      triangle {<-22.813344,44.207020,140.915305>,<-24.087438,41.752201,139.596248>,<-23.499311,41.702412,141.802459>}
      triangle {<-22.813344,44.207020,140.915305>,<-23.499311,41.702412,141.802459>,<-21.698011,43.199024,143.083282>}
      triangle {<-21.698011,43.199024,143.083282>,<-23.499311,41.702412,141.802459>,<-21.892034,41.566395,143.419223>}
      triangle {<-21.892034,41.566395,135.773276>,<-21.767667,39.906803,135.988692>,<-22.715826,39.236362,137.200122>}
      triangle {<-21.892034,41.566395,135.773276>,<-22.715826,39.236362,137.200122>,<-23.499311,41.702412,137.390040>}
      triangle {<-23.499311,41.702412,137.390040>,<-22.715826,39.236362,137.200122>,<-23.226751,38.875080,138.757197>}
      triangle {<-23.499311,41.702412,137.390040>,<-23.226751,38.875080,138.757197>,<-24.087438,41.752201,139.596248>}
      triangle {<-24.087438,41.752201,139.596248>,<-23.226751,38.875080,138.757197>,<-23.226751,38.875080,140.435306>}
      triangle {<-24.087438,41.752201,139.596248>,<-23.226751,38.875080,140.435306>,<-23.499311,41.702412,141.802459>}
      triangle {<-23.499311,41.702412,141.802459>,<-23.226751,38.875080,140.435306>,<-22.715826,39.236362,141.992377>}
      triangle {<-23.499311,41.702412,141.802459>,<-22.715826,39.236362,141.992377>,<-21.892034,41.566395,143.419223>}
      triangle {<-21.892034,41.566395,143.419223>,<-22.715826,39.236362,141.992377>,<-21.767667,39.906803,143.203807>}
      triangle {<-21.767667,39.906803,143.203807>,<-22.715826,39.236362,141.992377>,<-20.244459,39.236362,143.419341>}
      triangle {<-22.715826,39.236362,141.992377>,<-23.226751,38.875080,140.435306>,<-21.244794,38.251041,142.298301>}
      triangle {<-22.715826,39.236362,141.992377>,<-21.244794,38.251041,142.298301>,<-20.244459,39.236362,143.419341>}
      triangle {<-20.244459,39.236362,143.419341>,<-21.244794,38.251041,142.298301>,<-18.640523,38.875080,143.083163>}
      triangle {<-23.226751,38.875080,140.435306>,<-23.226751,38.875080,138.757197>,<-21.638616,37.487537,140.342181>}
      triangle {<-23.226751,38.875080,140.435306>,<-21.638616,37.487537,140.342181>,<-21.244794,38.251041,142.298301>}
      triangle {<-21.244794,38.251041,142.298301>,<-21.638616,37.487537,140.342181>,<-19.353940,37.487537,141.661235>}
      triangle {<-21.244794,38.251041,142.298301>,<-19.353940,37.487537,141.661235>,<-18.640523,38.875080,143.083163>}
      triangle {<-18.640523,38.875080,143.083163>,<-19.353940,37.487537,141.661235>,<-17.187238,38.875080,142.244109>}
      triangle {<-23.226751,38.875080,138.757197>,<-22.715826,39.236362,137.200122>,<-21.111906,37.675678,137.655589>}
      triangle {<-23.226751,38.875080,138.757197>,<-21.111906,37.675678,137.655589>,<-21.638616,37.487537,140.342181>}
      triangle {<-21.638616,37.487537,140.342181>,<-21.111906,37.675678,137.655589>,<-19.126707,37.104572,138.629550>}
      triangle {<-21.638616,37.487537,140.342181>,<-19.126707,37.104572,138.629550>,<-19.353940,37.487537,141.661235>}
      triangle {<-19.353940,37.487537,141.661235>,<-19.126707,37.104572,138.629550>,<-17.290639,37.675678,139.861796>}
      triangle {<-19.353940,37.487537,141.661235>,<-17.290639,37.675678,139.861796>,<-17.187238,38.875080,142.244109>}
      triangle {<-17.187238,38.875080,142.244109>,<-17.290639,37.675678,139.861796>,<-16.094236,39.236362,141.023093>}
      triangle {<-22.715826,39.236362,137.200122>,<-21.767667,39.906803,135.988692>,<-20.244459,39.236362,135.773280>}
      triangle {<-22.715826,39.236362,137.200122>,<-20.244459,39.236362,135.773280>,<-21.111906,37.675678,137.655589>}
      triangle {<-21.111906,37.675678,137.655589>,<-20.244459,39.236362,135.773280>,<-18.640523,38.875080,136.109340>}
      triangle {<-21.111906,37.675678,137.655589>,<-18.640523,38.875080,136.109340>,<-19.126707,37.104572,138.629550>}
      triangle {<-19.126707,37.104572,138.629550>,<-18.640523,38.875080,136.109340>,<-17.187231,38.875080,136.948394>}
      triangle {<-19.126707,37.104572,138.629550>,<-17.187231,38.875080,136.948394>,<-17.290639,37.675678,139.861796>}
      triangle {<-17.290639,37.675678,139.861796>,<-17.187231,38.875080,136.948394>,<-16.094236,39.236362,138.169410>}
      triangle {<-17.290639,37.675678,139.861796>,<-16.094236,39.236362,138.169410>,<-16.094236,39.236362,141.023093>}
      triangle {<-16.094236,39.236362,141.023093>,<-16.094236,39.236362,138.169410>,<-15.519193,39.906803,139.596251>}
      texture{_Shield01}
    }
    //_BrTop01
    mesh{
      triangle {<5.154879,35.566685,149.849893>,<5.154879,41.287205,136.502448>,<5.154879,35.566685,136.320220>}
      triangle {<5.154879,35.566685,149.849893>,<5.154879,41.287205,142.523154>,<5.154879,41.287205,136.502448>}
      triangle {<5.154879,41.287205,142.523154>,<5.154879,35.566685,149.849893>,<9.319193,35.566685,149.849893>}
      triangle {<5.154879,35.566685,149.849893>,<9.319193,35.566685,137.673064>,<9.319193,35.566685,149.849893>}
      triangle {<9.319193,35.566685,137.673064>,<5.154879,35.566685,149.849893>,<7.242877,35.566685,137.673156>}
      triangle {<5.154879,35.566685,149.849893>,<5.154879,35.566685,136.320220>,<7.242877,35.566685,137.673156>}
      triangle {<5.154879,35.566685,136.320220>,<7.242877,35.566685,136.320220>,<7.242877,35.566685,137.673156>}
      triangle {<7.242877,41.287205,136.502448>,<5.154879,35.566685,136.320220>,<5.154879,41.287205,136.502448>}
      triangle {<5.154879,41.287205,136.502448>,<5.154879,41.287205,142.523154>,<7.242877,41.287205,136.502448>}
      triangle {<5.154879,41.287205,142.523154>,<7.242877,41.287205,142.523154>,<7.242877,41.287205,136.502448>}
      triangle {<7.242877,39.678318,144.583785>,<9.319193,35.566685,149.849893>,<9.319193,39.678318,144.583785>}
      triangle {<5.154879,41.287205,142.523154>,<9.319193,35.566685,149.849893>,<7.242877,39.678318,144.583785>}
      triangle {<7.242877,41.287205,142.523154>,<5.154879,41.287205,142.523154>,<7.242877,39.678318,144.583785>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,136.451194>,<5.154879,35.566685,136.320220>}
      triangle {<7.242877,39.678318,136.451194>,<7.242877,35.566685,136.320220>,<5.154879,35.566685,136.320220>}
      triangle {<9.319193,35.566685,149.849893>,<9.319193,39.678318,137.673064>,<9.319193,39.678318,144.583785>}
      triangle {<9.319193,39.678318,137.673064>,<9.319193,35.566685,149.849893>,<9.319193,35.566685,137.673064>}
      triangle {<9.319193,39.678318,137.673064>,<9.319193,35.566685,137.673064>,<7.242877,35.566685,137.673156>}
      triangle {<7.242877,39.678318,137.673057>,<9.319193,39.678318,137.673064>,<7.242877,35.566685,137.673156>}
      triangle {<7.242877,39.678318,137.673057>,<7.242877,35.566685,137.673156>,<7.242877,35.566685,136.320220>}
      triangle {<7.242877,39.678318,137.923980>,<7.242877,35.566685,136.320220>,<7.242877,39.678318,136.451194>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,137.923980>,<7.242877,39.678318,136.451194>}
      triangle {<7.242877,39.678318,138.041282>,<7.242877,35.566685,136.320220>,<7.242877,39.678318,137.923980>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,138.041282>,<7.242877,39.678318,137.923980>}
      triangle {<7.242877,39.678318,138.176047>,<7.242877,35.566685,136.320220>,<7.242877,39.678318,138.041282>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,138.176047>,<7.242877,39.678318,138.041282>}
      triangle {<7.242877,39.678318,138.212325>,<7.242877,35.566685,136.320220>,<7.242877,39.678318,138.176047>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,138.212325>,<7.242877,39.678318,138.176047>}
      triangle {<7.242877,39.678318,138.463210>,<7.242877,35.566685,136.320220>,<7.242877,39.678318,138.212325>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,138.463210>,<7.242877,39.678318,138.212325>}
      triangle {<7.242877,39.678318,138.463210>,<7.242877,41.287205,136.502448>,<7.242877,39.678318,137.673057>}
      triangle {<7.242877,35.566685,136.320220>,<7.242877,39.678318,138.463210>,<7.242877,39.678318,137.673057>}
      triangle {<7.242877,39.678318,144.583785>,<7.242877,41.287205,136.502448>,<7.242877,41.287205,142.523154>}
      triangle {<7.242877,39.678318,144.583785>,<9.319193,39.678318,144.583785>,<9.319193,39.678318,137.673064>}
      triangle {<7.242877,39.678318,137.673057>,<7.242877,39.678318,144.583785>,<9.319193,39.678318,137.673064>}
      triangle {<7.242877,41.287205,136.502448>,<7.242877,39.678318,144.583785>,<7.242877,39.678318,137.673057>}
      triangle {<10.560992,35.080738,146.773904>,<12.776019,34.689915,146.773904>,<12.341769,35.867039,146.263062>}
      triangle {<10.560992,35.080738,146.773904>,<12.341769,35.867039,146.263062>,<10.995242,36.104633,146.263062>}
      triangle {<10.560992,35.080738,146.773904>,<10.560992,35.080738,144.174319>,<12.776019,34.689915,144.174319>}
      triangle {<10.560992,35.080738,146.773904>,<12.776019,34.689915,144.174319>,<12.776019,34.689915,146.773904>}
      triangle {<12.776019,34.689915,146.773904>,<12.776019,34.689915,144.174319>,<12.341769,35.867039,144.685166>}
      triangle {<12.776019,34.689915,146.773904>,<12.341769,35.867039,144.685166>,<12.341769,35.867039,146.263062>}
      triangle {<12.341769,35.867039,146.263062>,<12.341769,35.867039,144.685166>,<10.995242,36.104633,144.685166>}
      triangle {<12.341769,35.867039,146.263062>,<10.995242,36.104633,144.685166>,<10.995242,36.104633,146.263062>}
      triangle {<10.995242,36.104633,146.263062>,<10.995242,36.104633,144.685166>,<10.560992,35.080738,144.174319>}
      triangle {<10.995242,36.104633,146.263062>,<10.560992,35.080738,144.174319>,<10.560992,35.080738,146.773904>}
      triangle {<10.560992,35.080738,144.174319>,<10.995242,36.104633,144.685166>,<12.341769,35.867039,144.685166>}
      triangle {<10.560992,35.080738,144.174319>,<12.341769,35.867039,144.685166>,<12.776019,34.689915,144.174319>}
      triangle {<9.363650,35.464375,147.024659>,<11.227351,35.464375,147.024659>,<11.227351,37.131824,147.024659>}
      triangle {<9.363650,35.464375,147.024659>,<11.227351,37.131824,147.024659>,<9.363650,37.131824,147.024659>}
      triangle {<9.363650,35.464375,147.024659>,<9.363650,35.464375,139.224883>,<11.227351,35.464375,139.224883>}
      triangle {<9.363650,35.464375,147.024659>,<11.227351,35.464375,139.224883>,<11.227351,35.464375,147.024659>}
      triangle {<11.227351,35.464375,147.024659>,<11.227351,35.464375,139.224883>,<11.227351,37.131824,139.224883>}
      triangle {<11.227351,35.464375,147.024659>,<11.227351,37.131824,139.224883>,<11.227351,37.131824,147.024659>}
      triangle {<11.227351,37.131824,147.024659>,<11.227351,37.131824,139.224883>,<9.363650,37.131824,139.224883>}
      triangle {<11.227351,37.131824,147.024659>,<9.363650,37.131824,139.224883>,<9.363650,37.131824,147.024659>}
      triangle {<9.363650,37.131824,147.024659>,<9.363650,37.131824,139.224883>,<9.363650,35.464375,139.224883>}
      triangle {<9.363650,37.131824,147.024659>,<9.363650,35.464375,139.224883>,<9.363650,35.464375,147.024659>}
      triangle {<9.363650,35.464375,139.224883>,<9.363650,37.131824,139.224883>,<11.227351,37.131824,139.224883>}
      triangle {<9.363650,35.464375,139.224883>,<11.227351,37.131824,139.224883>,<11.227351,35.464375,139.224883>}
      triangle {<10.560992,35.080738,142.205752>,<12.776019,34.689915,142.205752>,<12.341769,35.867039,141.694900>}
      triangle {<10.560992,35.080738,142.205752>,<12.341769,35.867039,141.694900>,<10.995242,36.104633,141.694900>}
      triangle {<10.560992,35.080738,142.205752>,<10.560992,35.080738,139.606166>,<12.776019,34.689915,139.606166>}
      triangle {<10.560992,35.080738,142.205752>,<12.776019,34.689915,139.606166>,<12.776019,34.689915,142.205752>}
      triangle {<12.776019,34.689915,142.205752>,<12.776019,34.689915,139.606166>,<12.341769,35.867039,140.117003>}
      triangle {<12.776019,34.689915,142.205752>,<12.341769,35.867039,140.117003>,<12.341769,35.867039,141.694900>}
      triangle {<12.341769,35.867039,141.694900>,<12.341769,35.867039,140.117003>,<10.995242,36.104633,140.117003>}
      triangle {<12.341769,35.867039,141.694900>,<10.995242,36.104633,140.117003>,<10.995242,36.104633,141.694900>}
      triangle {<10.995242,36.104633,141.694900>,<10.995242,36.104633,140.117003>,<10.560992,35.080738,139.606166>}
      triangle {<10.995242,36.104633,141.694900>,<10.560992,35.080738,139.606166>,<10.560992,35.080738,142.205752>}
      triangle {<10.560992,35.080738,139.606166>,<10.995242,36.104633,140.117003>,<12.341769,35.867039,140.117003>}
      triangle {<10.560992,35.080738,139.606166>,<12.341769,35.867039,140.117003>,<12.776019,34.689915,139.606166>}
      triangle {<-4.396230,35.566685,136.320220>,<-4.396230,41.287205,136.502448>,<-4.396230,35.566685,149.849893>}
      triangle {<-4.396230,41.287205,136.502448>,<-4.396230,41.287205,142.523154>,<-4.396230,35.566685,149.849893>}
      triangle {<-8.560544,35.566685,149.849893>,<-4.396230,35.566685,149.849893>,<-4.396230,41.287205,142.523154>}
      triangle {<-8.560544,35.566685,149.849893>,<-8.560544,35.566685,137.673064>,<-4.396230,35.566685,149.849893>}
      triangle {<-6.484228,35.566685,137.673156>,<-4.396230,35.566685,149.849893>,<-8.560544,35.566685,137.673064>}
      triangle {<-6.484228,35.566685,137.673156>,<-4.396230,35.566685,136.320220>,<-4.396230,35.566685,149.849893>}
      triangle {<-6.484228,35.566685,137.673156>,<-6.484228,35.566685,136.320220>,<-4.396230,35.566685,136.320220>}
      triangle {<-4.396230,41.287205,136.502448>,<-4.396230,35.566685,136.320220>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,41.287205,136.502448>,<-4.396230,41.287205,142.523154>,<-4.396230,41.287205,136.502448>}
      triangle {<-6.484228,41.287205,136.502448>,<-6.484228,41.287205,142.523154>,<-4.396230,41.287205,142.523154>}
      triangle {<-8.560544,39.678318,144.583785>,<-8.560544,35.566685,149.849893>,<-6.484228,39.678318,144.583785>}
      triangle {<-6.484228,39.678318,144.583785>,<-8.560544,35.566685,149.849893>,<-4.396230,41.287205,142.523154>}
      triangle {<-6.484228,39.678318,144.583785>,<-4.396230,41.287205,142.523154>,<-6.484228,41.287205,142.523154>}
      triangle {<-4.396230,35.566685,136.320220>,<-6.484228,39.678318,136.451194>,<-6.484228,41.287205,136.502448>}
      triangle {<-4.396230,35.566685,136.320220>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,136.451194>}
      triangle {<-8.560544,39.678318,144.583785>,<-8.560544,39.678318,137.673064>,<-8.560544,35.566685,149.849893>}
      triangle {<-8.560544,35.566685,137.673064>,<-8.560544,35.566685,149.849893>,<-8.560544,39.678318,137.673064>}
      triangle {<-6.484228,35.566685,137.673156>,<-8.560544,35.566685,137.673064>,<-8.560544,39.678318,137.673064>}
      triangle {<-6.484228,35.566685,137.673156>,<-8.560544,39.678318,137.673064>,<-6.484228,39.678318,137.673057>}
      triangle {<-6.484228,35.566685,136.320220>,<-6.484228,35.566685,137.673156>,<-6.484228,39.678318,137.673057>}
      triangle {<-6.484228,39.678318,136.451194>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,137.923980>}
      triangle {<-6.484228,39.678318,136.451194>,<-6.484228,39.678318,137.923980>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,39.678318,137.923980>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,138.041282>}
      triangle {<-6.484228,39.678318,137.923980>,<-6.484228,39.678318,138.041282>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,39.678318,138.041282>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,138.176047>}
      triangle {<-6.484228,39.678318,138.041282>,<-6.484228,39.678318,138.176047>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,39.678318,138.176047>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,138.212325>}
      triangle {<-6.484228,39.678318,138.176047>,<-6.484228,39.678318,138.212325>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,39.678318,138.212325>,<-6.484228,35.566685,136.320220>,<-6.484228,39.678318,138.463210>}
      triangle {<-6.484228,39.678318,138.212325>,<-6.484228,39.678318,138.463210>,<-6.484228,41.287205,136.502448>}
      triangle {<-6.484228,39.678318,137.673057>,<-6.484228,41.287205,136.502448>,<-6.484228,39.678318,138.463210>}
      triangle {<-6.484228,39.678318,137.673057>,<-6.484228,39.678318,138.463210>,<-6.484228,35.566685,136.320220>}
      triangle {<-6.484228,41.287205,142.523154>,<-6.484228,41.287205,136.502448>,<-6.484228,39.678318,144.583785>}
      triangle {<-8.560544,39.678318,137.673064>,<-8.560544,39.678318,144.583785>,<-6.484228,39.678318,144.583785>}
      triangle {<-8.560544,39.678318,137.673064>,<-6.484228,39.678318,144.583785>,<-6.484228,39.678318,137.673057>}
      triangle {<-6.484228,39.678318,137.673057>,<-6.484228,39.678318,144.583785>,<-6.484228,41.287205,136.502448>}
      triangle {<-11.583120,35.867039,146.263062>,<-12.017370,34.689915,146.773904>,<-9.802343,35.080738,146.773904>}
      triangle {<-10.236593,36.104633,146.263062>,<-11.583120,35.867039,146.263062>,<-9.802343,35.080738,146.773904>}
      triangle {<-12.017370,34.689915,144.174319>,<-9.802343,35.080738,144.174319>,<-9.802343,35.080738,146.773904>}
      triangle {<-12.017370,34.689915,146.773904>,<-12.017370,34.689915,144.174319>,<-9.802343,35.080738,146.773904>}
      triangle {<-11.583120,35.867039,144.685166>,<-12.017370,34.689915,144.174319>,<-12.017370,34.689915,146.773904>}
      triangle {<-11.583120,35.867039,146.263062>,<-11.583120,35.867039,144.685166>,<-12.017370,34.689915,146.773904>}
      triangle {<-10.236593,36.104633,144.685166>,<-11.583120,35.867039,144.685166>,<-11.583120,35.867039,146.263062>}
      triangle {<-10.236593,36.104633,146.263062>,<-10.236593,36.104633,144.685166>,<-11.583120,35.867039,146.263062>}
      triangle {<-9.802343,35.080738,144.174319>,<-10.236593,36.104633,144.685166>,<-10.236593,36.104633,146.263062>}
      triangle {<-9.802343,35.080738,146.773904>,<-9.802343,35.080738,144.174319>,<-10.236593,36.104633,146.263062>}
      triangle {<-11.583120,35.867039,144.685166>,<-10.236593,36.104633,144.685166>,<-9.802343,35.080738,144.174319>}
      triangle {<-12.017370,34.689915,144.174319>,<-11.583120,35.867039,144.685166>,<-9.802343,35.080738,144.174319>}
      triangle {<-10.468702,37.131824,147.024659>,<-10.468702,35.464375,147.024659>,<-8.605001,35.464375,147.024659>}
      triangle {<-8.605001,37.131824,147.024659>,<-10.468702,37.131824,147.024659>,<-8.605001,35.464375,147.024659>}
      triangle {<-10.468702,35.464375,139.224883>,<-8.605001,35.464375,139.224883>,<-8.605001,35.464375,147.024659>}
      triangle {<-10.468702,35.464375,147.024659>,<-10.468702,35.464375,139.224883>,<-8.605001,35.464375,147.024659>}
      triangle {<-10.468702,37.131824,139.224883>,<-10.468702,35.464375,139.224883>,<-10.468702,35.464375,147.024659>}
      triangle {<-10.468702,37.131824,147.024659>,<-10.468702,37.131824,139.224883>,<-10.468702,35.464375,147.024659>}
      triangle {<-8.605001,37.131824,139.224883>,<-10.468702,37.131824,139.224883>,<-10.468702,37.131824,147.024659>}
      triangle {<-8.605001,37.131824,147.024659>,<-8.605001,37.131824,139.224883>,<-10.468702,37.131824,147.024659>}
      triangle {<-8.605001,35.464375,139.224883>,<-8.605001,37.131824,139.224883>,<-8.605001,37.131824,147.024659>}
      triangle {<-8.605001,35.464375,147.024659>,<-8.605001,35.464375,139.224883>,<-8.605001,37.131824,147.024659>}
      triangle {<-10.468702,37.131824,139.224883>,<-8.605001,37.131824,139.224883>,<-8.605001,35.464375,139.224883>}
      triangle {<-10.468702,35.464375,139.224883>,<-10.468702,37.131824,139.224883>,<-8.605001,35.464375,139.224883>}
      triangle {<-11.583120,35.867039,141.694900>,<-12.017370,34.689915,142.205752>,<-9.802343,35.080738,142.205752>}
      triangle {<-10.236593,36.104633,141.694900>,<-11.583120,35.867039,141.694900>,<-9.802343,35.080738,142.205752>}
      triangle {<-12.017370,34.689915,139.606166>,<-9.802343,35.080738,139.606166>,<-9.802343,35.080738,142.205752>}
      triangle {<-12.017370,34.689915,142.205752>,<-12.017370,34.689915,139.606166>,<-9.802343,35.080738,142.205752>}
      triangle {<-11.583120,35.867039,140.117003>,<-12.017370,34.689915,139.606166>,<-12.017370,34.689915,142.205752>}
      triangle {<-11.583120,35.867039,141.694900>,<-11.583120,35.867039,140.117003>,<-12.017370,34.689915,142.205752>}
      triangle {<-10.236593,36.104633,140.117003>,<-11.583120,35.867039,140.117003>,<-11.583120,35.867039,141.694900>}
      triangle {<-10.236593,36.104633,141.694900>,<-10.236593,36.104633,140.117003>,<-11.583120,35.867039,141.694900>}
      triangle {<-9.802343,35.080738,139.606166>,<-10.236593,36.104633,140.117003>,<-10.236593,36.104633,141.694900>}
      triangle {<-9.802343,35.080738,142.205752>,<-9.802343,35.080738,139.606166>,<-10.236593,36.104633,141.694900>}
      triangle {<-11.583120,35.867039,140.117003>,<-10.236593,36.104633,140.117003>,<-9.802343,35.080738,139.606166>}
      triangle {<-12.017370,34.689915,139.606166>,<-11.583120,35.867039,140.117003>,<-9.802343,35.080738,139.606166>}
      triangle {<5.571627,42.203419,142.604255>,<-4.812421,42.203434,142.604255>,<9.997347,42.203434,143.255210>}
      triangle {<-9.180761,42.203434,143.255202>,<9.997347,42.203434,143.255210>,<-4.812421,42.203434,142.604255>}
      triangle {<2.886317,42.203419,138.698562>,<-2.032514,42.203434,138.698562>,<2.886317,42.203419,140.651404>}
      triangle {<-2.127103,42.203434,140.651404>,<2.886317,42.203419,140.651404>,<-2.032514,42.203434,138.698562>}
      triangle {<9.997347,42.203434,143.255210>,<9.997347,42.203419,142.604255>,<7.046870,42.203419,142.604255>}
      triangle {<5.571627,42.203419,142.604255>,<9.997347,42.203434,143.255210>,<7.046870,42.203419,142.604255>}
      triangle {<5.571627,42.203419,142.604255>,<7.046870,42.203419,142.604255>,<3.358767,42.203419,140.000457>}
      triangle {<2.886317,42.203419,140.651404>,<5.571627,42.203419,142.604255>,<3.358767,42.203419,140.000457>}
      triangle {<2.886317,42.203419,138.698562>,<2.886317,42.203419,140.651404>,<3.358767,42.203419,140.000457>}
      triangle {<3.358767,42.203419,140.000457>,<4.834010,42.203419,140.000457>,<4.834010,42.203419,139.349509>}
      triangle {<3.358767,42.203419,140.000457>,<4.834010,42.203419,139.349509>,<3.358767,42.203419,139.349509>}
      triangle {<2.886317,42.203419,138.698562>,<3.358767,42.203419,140.000457>,<3.358767,42.203419,139.349509>}
      triangle {<2.886317,42.203419,138.698562>,<3.358767,42.203419,139.349509>,<7.046870,42.203419,136.745711>}
      triangle {<5.571627,42.203419,136.745711>,<2.886317,42.203419,138.698562>,<7.046870,42.203419,136.745711>}
      triangle {<7.046870,42.203419,136.745711>,<9.997347,42.203419,136.745711>,<9.997347,42.203419,136.094764>}
      triangle {<7.046870,42.203419,136.745711>,<9.997347,42.203419,136.094764>,<-9.180761,42.203434,136.094764>}
      triangle {<5.571627,42.203419,136.745711>,<7.046870,42.203419,136.745711>,<-9.180761,42.203434,136.094764>}
      triangle {<-4.717824,42.203434,136.745711>,<5.571627,42.203419,136.745711>,<-9.180761,42.203434,136.094764>}
      triangle {<-9.180761,42.203434,136.094764>,<-9.180761,42.203434,136.745711>,<-6.230283,42.203434,136.745711>}
      triangle {<-4.717824,42.203434,136.745711>,<-9.180761,42.203434,136.094764>,<-6.230283,42.203434,136.745711>}
      triangle {<-4.717824,42.203434,136.745711>,<-6.230283,42.203434,136.745711>,<-2.542188,42.203434,139.349509>}
      triangle {<-2.032514,42.203434,138.698562>,<-4.717824,42.203434,136.745711>,<-2.542188,42.203434,139.349509>}
      triangle {<-2.127103,42.203434,140.651404>,<-2.032514,42.203434,138.698562>,<-2.542188,42.203434,139.349509>}
      triangle {<-2.542188,42.203434,139.349509>,<-4.017431,42.203434,139.349509>,<-4.017431,42.203434,140.000457>}
      triangle {<-2.542188,42.203434,139.349509>,<-4.017431,42.203434,140.000457>,<-2.542188,42.203434,140.000457>}
      triangle {<-2.127103,42.203434,140.651404>,<-2.542188,42.203434,139.349509>,<-2.542188,42.203434,140.000457>}
      triangle {<-2.127103,42.203434,140.651404>,<-2.542188,42.203434,140.000457>,<-6.230283,42.203434,142.604255>}
      triangle {<-4.812421,42.203434,142.604255>,<-2.127103,42.203434,140.651404>,<-6.230283,42.203434,142.604255>}
      triangle {<-9.180761,42.203434,143.255202>,<-4.812421,42.203434,142.604255>,<-6.230283,42.203434,142.604255>}
      triangle {<-9.180761,42.203434,143.255202>,<-6.230283,42.203434,142.604255>,<-9.180761,42.203434,142.604255>}
      triangle {<9.997347,42.203434,143.255210>,<-9.180761,42.203434,143.255202>,<-9.180761,41.226078,143.255202>}
      triangle {<9.997347,42.203434,143.255210>,<-9.180761,41.226078,143.255202>,<9.997347,41.226093,143.255210>}
      triangle {<-9.180761,42.203434,143.255202>,<-9.180761,42.203434,142.604255>,<-9.180761,41.226078,142.604255>}
      triangle {<-9.180761,42.203434,143.255202>,<-9.180761,41.226078,142.604255>,<-9.180761,41.226078,143.255202>}
      triangle {<-9.180761,42.203434,142.604255>,<-6.230283,42.203434,142.604255>,<-6.230283,41.226078,142.604255>}
      triangle {<-9.180761,42.203434,142.604255>,<-6.230283,41.226078,142.604255>,<-9.180761,41.226078,142.604255>}
      triangle {<-6.230283,42.203434,142.604255>,<-2.542188,42.203434,140.000457>,<-2.542188,41.226078,140.000457>}
      triangle {<-6.230283,42.203434,142.604255>,<-2.542188,41.226078,140.000457>,<-6.230283,41.226078,142.604255>}
      triangle {<-2.542188,42.203434,140.000457>,<-4.017431,42.203434,140.000457>,<-4.017431,41.226078,140.000457>}
      triangle {<-2.542188,42.203434,140.000457>,<-4.017431,41.226078,140.000457>,<-2.542188,41.226078,140.000457>}
      triangle {<-4.017431,42.203434,140.000457>,<-4.017431,42.203434,139.349509>,<-4.017431,41.226078,139.349509>}
      triangle {<-4.017431,42.203434,140.000457>,<-4.017431,41.226078,139.349509>,<-4.017431,41.226078,140.000457>}
      triangle {<-4.017431,42.203434,139.349509>,<-2.542188,42.203434,139.349509>,<-2.542188,41.226078,139.349509>}
      triangle {<-4.017431,42.203434,139.349509>,<-2.542188,41.226078,139.349509>,<-4.017431,41.226078,139.349509>}
      triangle {<-2.542188,42.203434,139.349509>,<-6.230283,42.203434,136.745711>,<-6.230283,41.226078,136.745711>}
      triangle {<-2.542188,42.203434,139.349509>,<-6.230283,41.226078,136.745711>,<-2.542188,41.226078,139.349509>}
      triangle {<-6.230283,42.203434,136.745711>,<-9.180761,42.203434,136.745711>,<-9.180761,41.226078,136.745711>}
      triangle {<-6.230283,42.203434,136.745711>,<-9.180761,41.226078,136.745711>,<-6.230283,41.226078,136.745711>}
      triangle {<-9.180761,42.203434,136.745711>,<-9.180761,42.203434,136.094764>,<-9.180761,41.226078,136.094764>}
      triangle {<-9.180761,42.203434,136.745711>,<-9.180761,41.226078,136.094764>,<-9.180761,41.226078,136.745711>}
      triangle {<-9.180761,42.203434,136.094764>,<9.997347,42.203419,136.094764>,<9.997347,41.226078,136.094764>}
      triangle {<-9.180761,42.203434,136.094764>,<9.997347,41.226078,136.094764>,<-9.180761,41.226078,136.094764>}
      triangle {<9.997347,42.203419,136.094764>,<9.997347,42.203419,136.745711>,<9.997347,41.226078,136.745711>}
      triangle {<9.997347,42.203419,136.094764>,<9.997347,41.226078,136.745711>,<9.997347,41.226078,136.094764>}
      triangle {<9.997347,42.203419,136.745711>,<7.046870,42.203419,136.745711>,<7.046870,41.226078,136.745711>}
      triangle {<9.997347,42.203419,136.745711>,<7.046870,41.226078,136.745711>,<9.997347,41.226078,136.745711>}
      triangle {<7.046870,42.203419,136.745711>,<3.358767,42.203419,139.349509>,<3.358767,41.226078,139.349509>}
      triangle {<7.046870,42.203419,136.745711>,<3.358767,41.226078,139.349509>,<7.046870,41.226078,136.745711>}
      triangle {<3.358767,42.203419,139.349509>,<4.834010,42.203419,139.349509>,<4.834010,41.226078,139.349509>}
      triangle {<3.358767,42.203419,139.349509>,<4.834010,41.226078,139.349509>,<3.358767,41.226078,139.349509>}
      triangle {<4.834010,42.203419,139.349509>,<4.834010,42.203419,140.000457>,<4.834010,41.226078,140.000457>}
      triangle {<4.834010,42.203419,139.349509>,<4.834010,41.226078,140.000457>,<4.834010,41.226078,139.349509>}
      triangle {<4.834010,42.203419,140.000457>,<3.358767,42.203419,140.000457>,<3.358767,41.226078,140.000457>}
      triangle {<4.834010,42.203419,140.000457>,<3.358767,41.226078,140.000457>,<4.834010,41.226078,140.000457>}
      triangle {<3.358767,42.203419,140.000457>,<7.046870,42.203419,142.604255>,<7.046870,41.226078,142.604255>}
      triangle {<3.358767,42.203419,140.000457>,<7.046870,41.226078,142.604255>,<3.358767,41.226078,140.000457>}
      triangle {<7.046870,42.203419,142.604255>,<9.997347,42.203419,142.604255>,<9.997347,41.226078,142.604255>}
      triangle {<7.046870,42.203419,142.604255>,<9.997347,41.226078,142.604255>,<7.046870,41.226078,142.604255>}
      triangle {<9.997347,42.203419,142.604255>,<9.997347,42.203434,143.255210>,<9.997347,41.226093,143.255210>}
      triangle {<9.997347,42.203419,142.604255>,<9.997347,41.226093,143.255210>,<9.997347,41.226078,142.604255>}
      triangle {<-2.032514,42.203434,138.698562>,<2.886317,42.203419,138.698562>,<2.886317,41.226078,138.698562>}
      triangle {<-2.032514,42.203434,138.698562>,<2.886317,41.226078,138.698562>,<-2.032522,41.226078,138.698562>}
      triangle {<2.886317,42.203419,138.698562>,<5.571627,42.203419,136.745711>,<5.571627,41.226078,136.745711>}
      triangle {<2.886317,42.203419,138.698562>,<5.571627,41.226078,136.745711>,<2.886317,41.226078,138.698562>}
      triangle {<5.571627,42.203419,136.745711>,<-4.717824,42.203434,136.745711>,<-4.717824,41.226078,136.745711>}
      triangle {<5.571627,42.203419,136.745711>,<-4.717824,41.226078,136.745711>,<5.571627,41.226078,136.745711>}
      triangle {<-4.717824,42.203434,136.745711>,<-2.032514,42.203434,138.698562>,<-2.032522,41.226078,138.698562>}
      triangle {<-4.717824,42.203434,136.745711>,<-2.032522,41.226078,138.698562>,<-4.717824,41.226078,136.745711>}
      triangle {<-4.812421,42.203434,142.604255>,<5.571627,42.203419,142.604255>,<5.571627,41.226078,142.604255>}
      triangle {<-4.812421,42.203434,142.604255>,<5.571627,41.226078,142.604255>,<-4.812421,41.226078,142.604255>}
      triangle {<5.571627,42.203419,142.604255>,<2.886317,42.203419,140.651404>,<2.886317,41.226078,140.651404>}
      triangle {<5.571627,42.203419,142.604255>,<2.886317,41.226078,140.651404>,<5.571627,41.226078,142.604255>}
      triangle {<2.886317,42.203419,140.651404>,<-2.127103,42.203434,140.651404>,<-2.127103,41.226078,140.651404>}
      triangle {<2.886317,42.203419,140.651404>,<-2.127103,41.226078,140.651404>,<2.886317,41.226078,140.651404>}
      triangle {<-2.127103,42.203434,140.651404>,<-4.812421,42.203434,142.604255>,<-4.812421,41.226078,142.604255>}
      triangle {<-2.127103,42.203434,140.651404>,<-4.812421,41.226078,142.604255>,<-2.127103,41.226078,140.651404>}
      triangle {<9.997347,41.226093,143.255210>,<-4.812421,41.226078,142.604255>,<5.571627,41.226078,142.604255>}
      triangle {<-4.812421,41.226078,142.604255>,<9.997347,41.226093,143.255210>,<-9.180761,41.226078,143.255202>}
      triangle {<2.886317,41.226078,140.651404>,<-2.032522,41.226078,138.698562>,<2.886317,41.226078,138.698562>}
      triangle {<-2.032522,41.226078,138.698562>,<2.886317,41.226078,140.651404>,<-2.127103,41.226078,140.651404>}
      triangle {<7.046870,41.226078,142.604255>,<9.997347,41.226078,142.604255>,<9.997347,41.226093,143.255210>}
      triangle {<7.046870,41.226078,142.604255>,<9.997347,41.226093,143.255210>,<5.571627,41.226078,142.604255>}
      triangle {<3.358767,41.226078,140.000457>,<7.046870,41.226078,142.604255>,<5.571627,41.226078,142.604255>}
      triangle {<3.358767,41.226078,140.000457>,<5.571627,41.226078,142.604255>,<2.886317,41.226078,140.651404>}
      triangle {<3.358767,41.226078,140.000457>,<2.886317,41.226078,140.651404>,<2.886317,41.226078,138.698562>}
      triangle {<4.834010,41.226078,139.349509>,<4.834010,41.226078,140.000457>,<3.358767,41.226078,140.000457>}
      triangle {<3.358767,41.226078,139.349509>,<4.834010,41.226078,139.349509>,<3.358767,41.226078,140.000457>}
      triangle {<3.358767,41.226078,139.349509>,<3.358767,41.226078,140.000457>,<2.886317,41.226078,138.698562>}
      triangle {<7.046870,41.226078,136.745711>,<3.358767,41.226078,139.349509>,<2.886317,41.226078,138.698562>}
      triangle {<7.046870,41.226078,136.745711>,<2.886317,41.226078,138.698562>,<5.571627,41.226078,136.745711>}
      triangle {<9.997347,41.226078,136.094764>,<9.997347,41.226078,136.745711>,<7.046870,41.226078,136.745711>}
      triangle {<-9.180761,41.226078,136.094764>,<9.997347,41.226078,136.094764>,<7.046870,41.226078,136.745711>}
      triangle {<-9.180761,41.226078,136.094764>,<7.046870,41.226078,136.745711>,<5.571627,41.226078,136.745711>}
      triangle {<-9.180761,41.226078,136.094764>,<5.571627,41.226078,136.745711>,<-4.717824,41.226078,136.745711>}
      triangle {<-6.230283,41.226078,136.745711>,<-9.180761,41.226078,136.745711>,<-9.180761,41.226078,136.094764>}
      triangle {<-6.230283,41.226078,136.745711>,<-9.180761,41.226078,136.094764>,<-4.717824,41.226078,136.745711>}
      triangle {<-2.542188,41.226078,139.349509>,<-6.230283,41.226078,136.745711>,<-4.717824,41.226078,136.745711>}
      triangle {<-2.542188,41.226078,139.349509>,<-4.717824,41.226078,136.745711>,<-2.032522,41.226078,138.698562>}
      triangle {<-2.542188,41.226078,139.349509>,<-2.032522,41.226078,138.698562>,<-2.127103,41.226078,140.651404>}
      triangle {<-4.017431,41.226078,140.000457>,<-4.017431,41.226078,139.349509>,<-2.542188,41.226078,139.349509>}
      triangle {<-2.542188,41.226078,140.000457>,<-4.017431,41.226078,140.000457>,<-2.542188,41.226078,139.349509>}
      triangle {<-2.542188,41.226078,140.000457>,<-2.542188,41.226078,139.349509>,<-2.127103,41.226078,140.651404>}
      triangle {<-6.230283,41.226078,142.604255>,<-2.542188,41.226078,140.000457>,<-2.127103,41.226078,140.651404>}
      triangle {<-6.230283,41.226078,142.604255>,<-2.127103,41.226078,140.651404>,<-4.812421,41.226078,142.604255>}
      triangle {<-6.230283,41.226078,142.604255>,<-4.812421,41.226078,142.604255>,<-9.180761,41.226078,143.255202>}
      triangle {<-9.180761,41.226078,142.604255>,<-6.230283,41.226078,142.604255>,<-9.180761,41.226078,143.255202>}
      texture{_BrTop01}
    }
    //_Heck03
    mesh{
      triangle {<-92.727777,-28.496571,155.262097>,<-92.727777,-17.232342,154.663972>,<-92.727777,-28.496571,154.663972>}
      triangle {<-92.727777,-28.496571,155.262097>,<-92.727777,-17.232342,155.262097>,<-92.727777,-17.232342,154.663972>}
      triangle {<-92.727777,-28.496571,155.262097>,<92.451701,-28.496571,154.664001>,<92.451701,-28.496571,155.262126>}
      triangle {<-92.727777,-28.496571,155.262097>,<-92.727777,-28.496571,154.663972>,<92.451701,-28.496571,154.664001>}
      triangle {<-92.727777,-28.496571,154.663972>,<92.451701,-17.232342,154.664001>,<92.451701,-28.496571,154.664001>}
      triangle {<-92.727777,-28.496571,154.663972>,<-92.727777,-17.232342,154.663972>,<92.451701,-17.232342,154.664001>}
      triangle {<-92.727777,-17.232342,154.663972>,<92.451701,-17.232342,155.262126>,<92.451701,-17.232342,154.664001>}
      triangle {<-92.727777,-17.232342,154.663972>,<-92.727777,-17.232342,155.262097>,<92.451701,-17.232342,155.262126>}
      triangle {<-92.727777,-17.232342,155.262097>,<92.451701,-28.496571,155.262126>,<92.451701,-17.232342,155.262126>}
      triangle {<-92.727777,-17.232342,155.262097>,<-92.727777,-28.496571,155.262097>,<92.451701,-28.496571,155.262126>}
      triangle {<92.451701,-28.496571,155.262126>,<92.451701,-17.232342,154.664001>,<92.451701,-17.232342,155.262126>}
      triangle {<92.451701,-28.496571,155.262126>,<92.451701,-28.496571,154.664001>,<92.451701,-17.232342,154.664001>}
      triangle {<92.451701,-28.496571,155.262126>,<-92.727777,-28.496571,155.262097>,<-0.138044,-44.798428,186.233806>}
      triangle {<92.451701,-28.496571,154.664001>,<92.451701,-28.496571,155.262126>,<-0.138044,-44.798428,186.233806>}
      triangle {<-0.138044,-44.798428,185.635680>,<92.451701,-28.496571,154.664001>,<-0.138044,-44.798428,186.233806>}
      triangle {<-92.727777,-28.496571,154.663972>,<-92.727777,-28.496571,155.262097>,<92.451701,-28.496571,155.262126>}
      triangle {<92.451701,-28.496571,154.664001>,<-92.727777,-28.496571,154.663972>,<92.451701,-28.496571,155.262126>}
      triangle {<-0.138044,-44.798428,185.635680>,<-0.138044,-44.798428,186.233806>,<-92.727777,-28.496571,155.262097>}
      triangle {<-92.727777,-28.496571,154.663972>,<-0.138044,-44.798428,185.635680>,<-92.727777,-28.496571,155.262097>}
      triangle {<-0.138044,-44.798428,185.635680>,<-92.727777,-28.496571,154.663972>,<92.451701,-28.496571,154.664001>}
      triangle {<-0.138044,-0.930485,186.233806>,<-92.727777,-17.232342,155.262097>,<92.451701,-17.232342,155.262126>}
      triangle {<-0.138044,-0.930485,186.233806>,<92.451701,-17.232342,155.262126>,<92.451701,-17.232342,154.664001>}
      triangle {<-0.138044,-0.930485,186.233806>,<92.451701,-17.232342,154.664001>,<-0.138044,-0.930485,185.635680>}
      triangle {<-92.727777,-17.232342,155.262097>,<-0.138044,-0.930485,186.233806>,<-0.138044,-0.930485,185.635680>}
      triangle {<-92.727777,-17.232342,155.262097>,<-0.138044,-0.930485,185.635680>,<-92.727777,-17.232342,154.663972>}
      triangle {<92.451701,-17.232342,154.664001>,<-92.727777,-17.232342,154.663972>,<-0.138044,-0.930485,185.635680>}
      triangle {<-15.646566,-4.230434,179.860580>,<-39.491544,-9.280987,171.360110>,<-39.491544,-20.204411,162.411388>}
      triangle {<-15.646566,-4.230434,179.860580>,<-39.491544,-20.204411,162.411388>,<-15.646566,-20.028873,170.185778>}
      triangle {<-15.646566,-4.230434,179.860580>,<-15.646566,-4.230434,154.023940>,<-39.491544,-9.279751,154.054235>}
      triangle {<-15.646566,-4.230434,179.860580>,<-39.491544,-9.279751,154.054235>,<-39.491544,-9.280987,171.360110>}
      triangle {<-39.491544,-9.280987,171.360110>,<-39.491544,-9.279751,154.054235>,<-39.491544,-20.204411,154.015864>}
      triangle {<-39.491544,-9.280987,171.360110>,<-39.491544,-20.204411,154.015864>,<-39.491544,-20.204411,162.411388>}
      triangle {<-39.491544,-20.204411,162.411388>,<-39.491544,-20.204411,154.015864>,<-15.646566,-20.028873,154.019822>}
      triangle {<-39.491544,-20.204411,162.411388>,<-15.646566,-20.028873,154.019822>,<-15.646566,-20.028873,170.185778>}
      triangle {<-15.646566,-20.028873,170.185778>,<-15.646566,-20.028873,154.019822>,<-15.646566,-4.230434,154.023940>}
      triangle {<-15.646566,-20.028873,170.185778>,<-15.646566,-4.230434,154.023940>,<-15.646566,-4.230434,179.860580>}
      triangle {<-15.646566,-4.230434,154.023940>,<-15.646566,-20.028873,154.019822>,<-39.491544,-20.204411,154.015864>}
      triangle {<-15.646566,-4.230434,154.023940>,<-39.491544,-20.204411,154.015864>,<-39.491544,-9.279751,154.054235>}
      triangle {<-39.445310,-8.250935,169.314221>,<-41.170732,-8.283100,169.273619>,<-41.170732,-19.253849,169.272210>}
      triangle {<-39.445310,-8.250935,169.314221>,<-41.170732,-19.253849,169.272210>,<-39.445310,-19.231197,169.314220>}
      triangle {<-39.445310,-8.250935,169.314221>,<-39.445310,-8.250919,154.544749>,<-41.170732,-8.283108,154.525344>}
      triangle {<-39.445310,-8.250935,169.314221>,<-41.170732,-8.283108,154.525344>,<-41.170732,-8.283100,169.273619>}
      triangle {<-41.170732,-8.283100,169.273619>,<-41.170732,-8.283108,154.525344>,<-41.170732,-19.253849,154.525348>}
      triangle {<-41.170732,-8.283100,169.273619>,<-41.170732,-19.253849,154.525348>,<-41.170732,-19.253849,169.272210>}
      triangle {<-41.170732,-19.253849,169.272210>,<-41.170732,-19.253849,154.525348>,<-39.445310,-19.231197,154.544745>}
      triangle {<-41.170732,-19.253849,169.272210>,<-39.445310,-19.231197,154.544745>,<-39.445310,-19.231197,169.314220>}
      triangle {<-39.445310,-19.231197,169.314220>,<-39.445310,-19.231197,154.544745>,<-39.445310,-8.250919,154.544749>}
      triangle {<-39.445310,-19.231197,169.314220>,<-39.445310,-8.250919,154.544749>,<-39.445310,-8.250935,169.314221>}
      triangle {<-39.445310,-8.250919,154.544749>,<-39.445310,-19.231197,154.544745>,<-41.170732,-19.253849,154.525348>}
      triangle {<-39.445310,-8.250919,154.544749>,<-41.170732,-19.253849,154.525348>,<-41.170732,-8.283108,154.525344>}
      triangle {<-13.386770,-3.535030,178.017906>,<-15.652044,-3.649685,178.050569>,<-15.652044,-18.134823,169.131299>}
      triangle {<-13.386770,-3.535030,178.017906>,<-15.652044,-18.134823,169.131299>,<-13.386770,-18.101078,169.148538>}
      triangle {<-13.386770,-3.535030,178.017906>,<-13.386770,-3.535030,154.332170>,<-15.652044,-3.649685,154.359942>}
      triangle {<-13.386770,-3.535030,178.017906>,<-15.652044,-3.649685,154.359942>,<-15.652044,-3.649685,178.050569>}
      triangle {<-15.652044,-3.649685,178.050569>,<-15.652044,-3.649685,154.359942>,<-15.652044,-18.134823,154.324767>}
      triangle {<-15.652044,-3.649685,178.050569>,<-15.652044,-18.134823,154.324767>,<-15.652044,-18.134823,169.131299>}
      triangle {<-15.652044,-18.134823,169.131299>,<-15.652044,-18.134823,154.324767>,<-13.386770,-18.101078,154.328395>}
      triangle {<-15.652044,-18.134823,169.131299>,<-13.386770,-18.101078,154.328395>,<-13.386770,-18.101078,169.148538>}
      triangle {<-13.386770,-18.101078,169.148538>,<-13.386770,-18.101078,154.328395>,<-13.386770,-3.535030,154.332170>}
      triangle {<-13.386770,-18.101078,169.148538>,<-13.386770,-3.535030,154.332170>,<-13.386770,-3.535030,178.017906>}
      triangle {<-13.386770,-3.535030,154.332170>,<-13.386770,-18.101078,154.328395>,<-15.652044,-18.134823,154.324767>}
      triangle {<-13.386770,-3.535030,154.332170>,<-15.652044,-18.134823,154.324767>,<-15.652044,-3.649685,154.359942>}
      triangle {<-15.646566,-4.230434,170.581470>,<-39.491544,-8.203243,170.535622>,<-39.491544,-20.204411,170.534028>}
      triangle {<-15.646566,-4.230434,170.581470>,<-39.491544,-20.204411,170.534028>,<-15.646566,-20.028873,170.581468>}
      triangle {<-15.646566,-4.230434,170.581470>,<-15.646566,-4.230434,153.892802>,<-39.491544,-8.203251,153.870875>}
      triangle {<-15.646566,-4.230434,170.581470>,<-39.491544,-8.203251,153.870875>,<-39.491544,-8.203243,170.535622>}
      triangle {<-39.491544,-8.203243,170.535622>,<-39.491544,-8.203251,153.870875>,<-39.491544,-20.204411,153.870879>}
      triangle {<-39.491544,-8.203243,170.535622>,<-39.491544,-20.204411,153.870879>,<-39.491544,-20.204411,170.534028>}
      triangle {<-39.491544,-20.204411,170.534028>,<-39.491544,-20.204411,153.870879>,<-15.646566,-20.028873,153.892798>}
      triangle {<-39.491544,-20.204411,170.534028>,<-15.646566,-20.028873,153.892798>,<-15.646566,-20.028873,170.581468>}
      triangle {<-15.646566,-20.028873,170.581468>,<-15.646566,-20.028873,153.892798>,<-15.646566,-4.230434,153.892802>}
      triangle {<-15.646566,-20.028873,170.581468>,<-15.646566,-4.230434,153.892802>,<-15.646566,-4.230434,170.581470>}
      triangle {<-15.646566,-4.230434,153.892802>,<-15.646566,-20.028873,153.892798>,<-39.491544,-20.204411,153.870879>}
      triangle {<-15.646566,-4.230434,153.892802>,<-39.491544,-20.204411,153.870879>,<-39.491544,-8.203251,153.870875>}
      triangle {<-39.491544,-25.515316,162.411388>,<-39.491544,-36.438732,171.360110>,<-15.646566,-41.489300,179.860578>}
      triangle {<-15.646566,-25.690853,170.185779>,<-39.491544,-25.515316,162.411388>,<-15.646566,-41.489300,179.860578>}
      triangle {<-39.491544,-36.439968,154.054235>,<-15.646566,-41.489300,154.023940>,<-15.646566,-41.489300,179.860578>}
      triangle {<-39.491544,-36.438732,171.360110>,<-39.491544,-36.439968,154.054235>,<-15.646566,-41.489300,179.860578>}
      triangle {<-39.491544,-25.515316,154.015864>,<-39.491544,-36.439968,154.054235>,<-39.491544,-36.438732,171.360110>}
      triangle {<-39.491544,-25.515316,162.411388>,<-39.491544,-25.515316,154.015864>,<-39.491544,-36.438732,171.360110>}
      triangle {<-15.646566,-25.690853,154.019822>,<-39.491544,-25.515316,154.015864>,<-39.491544,-25.515316,162.411388>}
      triangle {<-15.646566,-25.690853,170.185779>,<-15.646566,-25.690853,154.019822>,<-39.491544,-25.515316,162.411388>}
      triangle {<-15.646566,-41.489300,154.023940>,<-15.646566,-25.690853,154.019822>,<-15.646566,-25.690853,170.185779>}
      triangle {<-15.646566,-41.489300,179.860578>,<-15.646566,-41.489300,154.023940>,<-15.646566,-25.690853,170.185779>}
      triangle {<-39.491544,-25.515316,154.015864>,<-15.646566,-25.690853,154.019822>,<-15.646566,-41.489300,154.023940>}
      triangle {<-39.491544,-36.439968,154.054235>,<-39.491544,-25.515316,154.015864>,<-15.646566,-41.489300,154.023940>}
      triangle {<-41.170732,-26.465878,169.272210>,<-41.170732,-37.436626,169.273619>,<-39.445310,-37.468792,169.314221>}
      triangle {<-39.445310,-26.488529,169.314220>,<-41.170732,-26.465878,169.272210>,<-39.445310,-37.468792,169.314221>}
      triangle {<-41.170732,-37.436619,154.525344>,<-39.445310,-37.468807,154.544749>,<-39.445310,-37.468792,169.314221>}
      triangle {<-41.170732,-37.436626,169.273619>,<-41.170732,-37.436619,154.525344>,<-39.445310,-37.468792,169.314221>}
      triangle {<-41.170732,-26.465878,154.525348>,<-41.170732,-37.436619,154.525344>,<-41.170732,-37.436626,169.273619>}
      triangle {<-41.170732,-26.465878,169.272210>,<-41.170732,-26.465878,154.525348>,<-41.170732,-37.436626,169.273619>}
      triangle {<-39.445310,-26.488529,154.544745>,<-41.170732,-26.465878,154.525348>,<-41.170732,-26.465878,169.272210>}
      triangle {<-39.445310,-26.488529,169.314220>,<-39.445310,-26.488529,154.544745>,<-41.170732,-26.465878,169.272210>}
      triangle {<-39.445310,-37.468807,154.544749>,<-39.445310,-26.488529,154.544745>,<-39.445310,-26.488529,169.314220>}
      triangle {<-39.445310,-37.468792,169.314221>,<-39.445310,-37.468807,154.544749>,<-39.445310,-26.488529,169.314220>}
      triangle {<-41.170732,-26.465878,154.525348>,<-39.445310,-26.488529,154.544745>,<-39.445310,-37.468807,154.544749>}
      triangle {<-41.170732,-37.436619,154.525344>,<-41.170732,-26.465878,154.525348>,<-39.445310,-37.468807,154.544749>}
      triangle {<-15.652044,-27.584904,169.131299>,<-15.652044,-42.070034,178.050569>,<-13.386770,-42.184696,178.017906>}
      triangle {<-13.386770,-27.618649,169.148538>,<-15.652044,-27.584904,169.131299>,<-13.386770,-42.184696,178.017906>}
      triangle {<-15.652044,-42.070034,154.359942>,<-13.386770,-42.184696,154.332170>,<-13.386770,-42.184696,178.017906>}
      triangle {<-15.652044,-42.070034,178.050569>,<-15.652044,-42.070034,154.359942>,<-13.386770,-42.184696,178.017906>}
      triangle {<-15.652044,-27.584904,154.324767>,<-15.652044,-42.070034,154.359942>,<-15.652044,-42.070034,178.050569>}
      triangle {<-15.652044,-27.584904,169.131299>,<-15.652044,-27.584904,154.324767>,<-15.652044,-42.070034,178.050569>}
      triangle {<-13.386770,-27.618649,154.328395>,<-15.652044,-27.584904,154.324767>,<-15.652044,-27.584904,169.131299>}
      triangle {<-13.386770,-27.618649,169.148538>,<-13.386770,-27.618649,154.328395>,<-15.652044,-27.584904,169.131299>}
      triangle {<-13.386770,-42.184696,154.332170>,<-13.386770,-27.618649,154.328395>,<-13.386770,-27.618649,169.148538>}
      triangle {<-13.386770,-42.184696,178.017906>,<-13.386770,-42.184696,154.332170>,<-13.386770,-27.618649,169.148538>}
      triangle {<-15.652044,-27.584904,154.324767>,<-13.386770,-27.618649,154.328395>,<-13.386770,-42.184696,154.332170>}
      triangle {<-15.652044,-42.070034,154.359942>,<-15.652044,-27.584904,154.324767>,<-13.386770,-42.184696,154.332170>}
      triangle {<-39.491544,-25.515316,170.534028>,<-39.491544,-37.516483,170.535622>,<-15.646566,-41.489300,170.581470>}
      triangle {<-15.646566,-25.690853,170.581469>,<-39.491544,-25.515316,170.534028>,<-15.646566,-41.489300,170.581470>}
      triangle {<-39.491544,-37.516476,153.870875>,<-15.646566,-41.489300,153.892802>,<-15.646566,-41.489300,170.581470>}
      triangle {<-39.491544,-37.516483,170.535622>,<-39.491544,-37.516476,153.870875>,<-15.646566,-41.489300,170.581470>}
      triangle {<-39.491544,-25.515316,153.870879>,<-39.491544,-37.516476,153.870875>,<-39.491544,-37.516483,170.535622>}
      triangle {<-39.491544,-25.515316,170.534028>,<-39.491544,-25.515316,153.870879>,<-39.491544,-37.516483,170.535622>}
      triangle {<-15.646566,-25.690853,153.892798>,<-39.491544,-25.515316,153.870879>,<-39.491544,-25.515316,170.534028>}
      triangle {<-15.646566,-25.690853,170.581469>,<-15.646566,-25.690853,153.892798>,<-39.491544,-25.515316,170.534028>}
      triangle {<-15.646566,-41.489300,153.892802>,<-15.646566,-25.690853,153.892798>,<-15.646566,-25.690853,170.581469>}
      triangle {<-15.646566,-41.489300,170.581470>,<-15.646566,-41.489300,153.892802>,<-15.646566,-25.690853,170.581469>}
      triangle {<-39.491544,-25.515316,153.870879>,<-15.646566,-25.690853,153.892798>,<-15.646566,-41.489300,153.892802>}
      triangle {<-39.491544,-37.516476,153.870875>,<-39.491544,-25.515316,153.870879>,<-15.646566,-41.489300,153.892802>}
      triangle {<39.105875,-20.204411,162.411388>,<39.105875,-9.280987,171.360112>,<15.260890,-4.230434,179.860578>}
      triangle {<15.260890,-20.028873,170.185779>,<39.105875,-20.204411,162.411388>,<15.260890,-4.230434,179.860578>}
      triangle {<39.105875,-9.279751,154.054235>,<15.260890,-4.230434,154.023940>,<15.260890,-4.230434,179.860578>}
      triangle {<39.105875,-9.280987,171.360112>,<39.105875,-9.279751,154.054235>,<15.260890,-4.230434,179.860578>}
      triangle {<39.105875,-20.204411,154.015864>,<39.105875,-9.279751,154.054235>,<39.105875,-9.280987,171.360112>}
      triangle {<39.105875,-20.204411,162.411388>,<39.105875,-20.204411,154.015864>,<39.105875,-9.280987,171.360112>}
      triangle {<15.260890,-20.028873,154.019822>,<39.105875,-20.204411,154.015864>,<39.105875,-20.204411,162.411388>}
      triangle {<15.260890,-20.028873,170.185779>,<15.260890,-20.028873,154.019822>,<39.105875,-20.204411,162.411388>}
      triangle {<15.260890,-4.230434,154.023940>,<15.260890,-20.028873,154.019822>,<15.260890,-20.028873,170.185779>}
      triangle {<15.260890,-4.230434,179.860578>,<15.260890,-4.230434,154.023940>,<15.260890,-20.028873,170.185779>}
      triangle {<39.105875,-20.204411,154.015864>,<15.260890,-20.028873,154.019822>,<15.260890,-4.230434,154.023940>}
      triangle {<39.105875,-9.279751,154.054235>,<39.105875,-20.204411,154.015864>,<15.260890,-4.230434,154.023940>}
      triangle {<40.785044,-19.253849,169.272238>,<40.785044,-8.283100,169.273646>,<39.059641,-8.250935,169.314221>}
      triangle {<39.059641,-19.231197,169.314220>,<40.785044,-19.253849,169.272238>,<39.059641,-8.250935,169.314221>}
      triangle {<40.785044,-8.283108,154.525344>,<39.059641,-8.250919,154.544749>,<39.059641,-8.250935,169.314221>}
      triangle {<40.785044,-8.283100,169.273646>,<40.785044,-8.283108,154.525344>,<39.059641,-8.250935,169.314221>}
      triangle {<40.785044,-19.253849,154.525348>,<40.785044,-8.283108,154.525344>,<40.785044,-8.283100,169.273646>}
      triangle {<40.785044,-19.253849,169.272238>,<40.785044,-19.253849,154.525348>,<40.785044,-8.283100,169.273646>}
      triangle {<39.059641,-19.231197,154.544745>,<40.785044,-19.253849,154.525348>,<40.785044,-19.253849,169.272238>}
      triangle {<39.059641,-19.231197,169.314220>,<39.059641,-19.231197,154.544745>,<40.785044,-19.253849,169.272238>}
      triangle {<39.059641,-8.250919,154.544749>,<39.059641,-19.231197,154.544745>,<39.059641,-19.231197,169.314220>}
      triangle {<39.059641,-8.250935,169.314221>,<39.059641,-8.250919,154.544749>,<39.059641,-19.231197,169.314220>}
      triangle {<40.785044,-19.253849,154.525348>,<39.059641,-19.231197,154.544745>,<39.059641,-8.250919,154.544749>}
      triangle {<40.785044,-8.283108,154.525344>,<40.785044,-19.253849,154.525348>,<39.059641,-8.250919,154.544749>}
      triangle {<15.266367,-18.134823,169.131271>,<15.266367,-3.649685,178.050570>,<13.001093,-3.535030,178.017906>}
      triangle {<13.001093,-18.101078,169.148565>,<15.266367,-18.134823,169.131271>,<13.001093,-3.535030,178.017906>}
      triangle {<15.266367,-3.649685,154.359942>,<13.001093,-3.535030,154.332170>,<13.001093,-3.535030,178.017906>}
      triangle {<15.266367,-3.649685,178.050570>,<15.266367,-3.649685,154.359942>,<13.001093,-3.535030,178.017906>}
      triangle {<15.266367,-18.134823,154.324767>,<15.266367,-3.649685,154.359942>,<15.266367,-3.649685,178.050570>}
      triangle {<15.266367,-18.134823,169.131271>,<15.266367,-18.134823,154.324767>,<15.266367,-3.649685,178.050570>}
      triangle {<13.001093,-18.101078,154.328395>,<15.266367,-18.134823,154.324767>,<15.266367,-18.134823,169.131271>}
      triangle {<13.001093,-18.101078,169.148565>,<13.001093,-18.101078,154.328395>,<15.266367,-18.134823,169.131271>}
      triangle {<13.001093,-3.535030,154.332170>,<13.001093,-18.101078,154.328395>,<13.001093,-18.101078,169.148565>}
      triangle {<13.001093,-3.535030,178.017906>,<13.001093,-3.535030,154.332170>,<13.001093,-18.101078,169.148565>}
      triangle {<15.266367,-18.134823,154.324767>,<13.001093,-18.101078,154.328395>,<13.001093,-3.535030,154.332170>}
      triangle {<15.266367,-3.649685,154.359942>,<15.266367,-18.134823,154.324767>,<13.001093,-3.535030,154.332170>}
      triangle {<39.105875,-20.204411,170.534028>,<39.105875,-8.203243,170.535622>,<15.260890,-4.230434,170.581470>}
      triangle {<15.260890,-20.028873,170.581469>,<39.105875,-20.204411,170.534028>,<15.260890,-4.230434,170.581470>}
      triangle {<39.105875,-8.203251,153.870875>,<15.260890,-4.230434,153.892802>,<15.260890,-4.230434,170.581470>}
      triangle {<39.105875,-8.203243,170.535622>,<39.105875,-8.203251,153.870875>,<15.260890,-4.230434,170.581470>}
      triangle {<39.105875,-20.204411,153.870879>,<39.105875,-8.203251,153.870875>,<39.105875,-8.203243,170.535622>}
      triangle {<39.105875,-20.204411,170.534028>,<39.105875,-20.204411,153.870879>,<39.105875,-8.203243,170.535622>}
      triangle {<15.260890,-20.028873,153.892798>,<39.105875,-20.204411,153.870879>,<39.105875,-20.204411,170.534028>}
      triangle {<15.260890,-20.028873,170.581469>,<15.260890,-20.028873,153.892798>,<39.105875,-20.204411,170.534028>}
      triangle {<15.260890,-4.230434,153.892802>,<15.260890,-20.028873,153.892798>,<15.260890,-20.028873,170.581469>}
      triangle {<15.260890,-4.230434,170.581470>,<15.260890,-4.230434,153.892802>,<15.260890,-20.028873,170.581469>}
      triangle {<39.105875,-20.204411,153.870879>,<15.260890,-20.028873,153.892798>,<15.260890,-4.230434,153.892802>}
      triangle {<39.105875,-8.203251,153.870875>,<39.105875,-20.204411,153.870879>,<15.260890,-4.230434,153.892802>}
      triangle {<15.260890,-41.489300,179.860578>,<39.105875,-36.438732,171.360112>,<39.105875,-25.515316,162.411388>}
      triangle {<15.260890,-41.489300,179.860578>,<39.105875,-25.515316,162.411388>,<15.260890,-25.690853,170.185779>}
      triangle {<15.260890,-41.489300,179.860578>,<15.260890,-41.489300,154.023940>,<39.105875,-36.439968,154.054235>}
      triangle {<15.260890,-41.489300,179.860578>,<39.105875,-36.439968,154.054235>,<39.105875,-36.438732,171.360112>}
      triangle {<39.105875,-36.438732,171.360112>,<39.105875,-36.439968,154.054235>,<39.105875,-25.515316,154.015864>}
      triangle {<39.105875,-36.438732,171.360112>,<39.105875,-25.515316,154.015864>,<39.105875,-25.515316,162.411388>}
      triangle {<39.105875,-25.515316,162.411388>,<39.105875,-25.515316,154.015864>,<15.260890,-25.690853,154.019822>}
      triangle {<39.105875,-25.515316,162.411388>,<15.260890,-25.690853,154.019822>,<15.260890,-25.690853,170.185779>}
      triangle {<15.260890,-25.690853,170.185779>,<15.260890,-25.690853,154.019822>,<15.260890,-41.489300,154.023940>}
      triangle {<15.260890,-25.690853,170.185779>,<15.260890,-41.489300,154.023940>,<15.260890,-41.489300,179.860578>}
      triangle {<15.260890,-41.489300,154.023940>,<15.260890,-25.690853,154.019822>,<39.105875,-25.515316,154.015864>}
      triangle {<15.260890,-41.489300,154.023940>,<39.105875,-25.515316,154.015864>,<39.105875,-36.439968,154.054235>}
      triangle {<39.059641,-37.468792,169.314221>,<40.785044,-37.436626,169.273646>,<40.785044,-26.465878,169.272238>}
      triangle {<39.059641,-37.468792,169.314221>,<40.785044,-26.465878,169.272238>,<39.059641,-26.488529,169.314220>}
      triangle {<39.059641,-37.468792,169.314221>,<39.059641,-37.468807,154.544749>,<40.785044,-37.436619,154.525344>}
      triangle {<39.059641,-37.468792,169.314221>,<40.785044,-37.436619,154.525344>,<40.785044,-37.436626,169.273646>}
      triangle {<40.785044,-37.436626,169.273646>,<40.785044,-37.436619,154.525344>,<40.785044,-26.465878,154.525348>}
      triangle {<40.785044,-37.436626,169.273646>,<40.785044,-26.465878,154.525348>,<40.785044,-26.465878,169.272238>}
      triangle {<40.785044,-26.465878,169.272238>,<40.785044,-26.465878,154.525348>,<39.059641,-26.488529,154.544745>}
      triangle {<40.785044,-26.465878,169.272238>,<39.059641,-26.488529,154.544745>,<39.059641,-26.488529,169.314220>}
      triangle {<39.059641,-26.488529,169.314220>,<39.059641,-26.488529,154.544745>,<39.059641,-37.468807,154.544749>}
      triangle {<39.059641,-26.488529,169.314220>,<39.059641,-37.468807,154.544749>,<39.059641,-37.468792,169.314221>}
      triangle {<39.059641,-37.468807,154.544749>,<39.059641,-26.488529,154.544745>,<40.785044,-26.465878,154.525348>}
      triangle {<39.059641,-37.468807,154.544749>,<40.785044,-26.465878,154.525348>,<40.785044,-37.436619,154.525344>}
      triangle {<13.001093,-42.184696,178.017906>,<15.266367,-42.070034,178.050570>,<15.266367,-27.584904,169.131271>}
      triangle {<13.001093,-42.184696,178.017906>,<15.266367,-27.584904,169.131271>,<13.001093,-27.618649,169.148565>}
      triangle {<13.001093,-42.184696,178.017906>,<13.001093,-42.184696,154.332170>,<15.266367,-42.070034,154.359942>}
      triangle {<13.001093,-42.184696,178.017906>,<15.266367,-42.070034,154.359942>,<15.266367,-42.070034,178.050570>}
      triangle {<15.266367,-42.070034,178.050570>,<15.266367,-42.070034,154.359942>,<15.266367,-27.584904,154.324767>}
      triangle {<15.266367,-42.070034,178.050570>,<15.266367,-27.584904,154.324767>,<15.266367,-27.584904,169.131271>}
      triangle {<15.266367,-27.584904,169.131271>,<15.266367,-27.584904,154.324767>,<13.001093,-27.618649,154.328395>}
      triangle {<15.266367,-27.584904,169.131271>,<13.001093,-27.618649,154.328395>,<13.001093,-27.618649,169.148565>}
      triangle {<13.001093,-27.618649,169.148565>,<13.001093,-27.618649,154.328395>,<13.001093,-42.184696,154.332170>}
      triangle {<13.001093,-27.618649,169.148565>,<13.001093,-42.184696,154.332170>,<13.001093,-42.184696,178.017906>}
      triangle {<13.001093,-42.184696,154.332170>,<13.001093,-27.618649,154.328395>,<15.266367,-27.584904,154.324767>}
      triangle {<13.001093,-42.184696,154.332170>,<15.266367,-27.584904,154.324767>,<15.266367,-42.070034,154.359942>}
      triangle {<15.260890,-41.489300,170.581470>,<39.105875,-37.516483,170.535622>,<39.105875,-25.515316,170.534028>}
      triangle {<15.260890,-41.489300,170.581470>,<39.105875,-25.515316,170.534028>,<15.260890,-25.690853,170.581469>}
      triangle {<15.260890,-41.489300,170.581470>,<15.260890,-41.489300,153.892802>,<39.105875,-37.516476,153.870875>}
      triangle {<15.260890,-41.489300,170.581470>,<39.105875,-37.516476,153.870875>,<39.105875,-37.516483,170.535622>}
      triangle {<39.105875,-37.516483,170.535622>,<39.105875,-37.516476,153.870875>,<39.105875,-25.515316,153.870879>}
      triangle {<39.105875,-37.516483,170.535622>,<39.105875,-25.515316,153.870879>,<39.105875,-25.515316,170.534028>}
      triangle {<39.105875,-25.515316,170.534028>,<39.105875,-25.515316,153.870879>,<15.260890,-25.690853,153.892798>}
      triangle {<39.105875,-25.515316,170.534028>,<15.260890,-25.690853,153.892798>,<15.260890,-25.690853,170.581469>}
      triangle {<15.260890,-25.690853,170.581469>,<15.260890,-25.690853,153.892798>,<15.260890,-41.489300,153.892802>}
      triangle {<15.260890,-25.690853,170.581469>,<15.260890,-41.489300,153.892802>,<15.260890,-41.489300,170.581470>}
      triangle {<15.260890,-41.489300,153.892802>,<15.260890,-25.690853,153.892798>,<39.105875,-25.515316,153.870879>}
      triangle {<15.260890,-41.489300,153.892802>,<39.105875,-25.515316,153.870879>,<39.105875,-37.516476,153.870875>}
      triangle {<-8.123022,-42.695805,182.172968>,<-7.232030,-41.788326,182.650416>,<-7.232030,-27.249920,155.017426>}
      triangle {<-8.123022,-42.695805,182.172968>,<-7.232030,-27.249920,155.017426>,<-8.123022,-28.157398,154.539979>}
      triangle {<-7.232030,-41.788326,182.650416>,<-5.450033,-41.788326,182.650416>,<-5.450033,-27.249920,155.017426>}
      triangle {<-7.232030,-41.788326,182.650416>,<-5.450033,-27.249920,155.017426>,<-7.232030,-27.249920,155.017426>}
      triangle {<-5.450033,-41.788326,182.650416>,<-4.559049,-42.695805,182.172969>,<-4.559049,-28.157398,154.539979>}
      triangle {<-5.450033,-41.788326,182.650416>,<-4.559049,-28.157398,154.539979>,<-5.450033,-27.249920,155.017426>}
      triangle {<-8.550184,-42.196941,183.678516>,<-4.176664,-42.196941,183.678515>,<-4.176664,-41.676525,182.689373>}
      triangle {<-8.550184,-42.196941,183.678516>,<-4.176664,-41.676525,182.689373>,<-8.550184,-41.676525,182.689373>}
      triangle {<-8.550184,-42.196941,183.678516>,<-8.550184,-43.186085,183.158104>,<-4.176664,-43.186085,183.158104>}
      triangle {<-8.550184,-42.196941,183.678516>,<-4.176664,-43.186085,183.158104>,<-4.176664,-42.196941,183.678515>}
      triangle {<-4.176664,-42.196941,183.678515>,<-4.176664,-43.186085,183.158104>,<-4.176664,-42.665668,182.168962>}
      triangle {<-4.176664,-42.196941,183.678515>,<-4.176664,-42.665668,182.168962>,<-4.176664,-41.676525,182.689373>}
      triangle {<-4.176664,-41.676525,182.689373>,<-4.176664,-42.665668,182.168962>,<-8.550184,-42.665668,182.168961>}
      triangle {<-4.176664,-41.676525,182.689373>,<-8.550184,-42.665668,182.168961>,<-8.550184,-41.676525,182.689373>}
      triangle {<-8.550184,-41.676525,182.689373>,<-8.550184,-42.665668,182.168961>,<-8.550184,-43.186085,183.158104>}
      triangle {<-8.550184,-41.676525,182.689373>,<-8.550184,-43.186085,183.158104>,<-8.550184,-42.196941,183.678516>}
      triangle {<-8.550184,-43.186085,183.158104>,<-8.550184,-42.665668,182.168961>,<-4.176664,-42.665668,182.168962>}
      triangle {<-8.550184,-43.186085,183.158104>,<-4.176664,-42.665668,182.168962>,<-4.176664,-43.186085,183.158104>}
      triangle {<3.353816,-42.695805,182.172968>,<4.241839,-41.788326,182.650415>,<4.241839,-27.249920,155.017426>}
      triangle {<3.353816,-42.695805,182.172968>,<4.241839,-27.249920,155.017426>,<3.353816,-28.157398,154.539979>}
      triangle {<4.241839,-41.788326,182.650415>,<6.017916,-41.788326,182.650415>,<6.017916,-27.249920,155.017426>}
      triangle {<4.241839,-41.788326,182.650415>,<6.017916,-27.249920,155.017426>,<4.241839,-27.249920,155.017426>}
      triangle {<6.017916,-41.788326,182.650415>,<6.905940,-42.695805,182.172968>,<6.905940,-28.157398,154.539979>}
      triangle {<6.017916,-41.788326,182.650415>,<6.905940,-28.157398,154.539979>,<6.017916,-27.249920,155.017426>}
      triangle {<2.928065,-42.196941,183.678516>,<7.287058,-42.196941,183.678516>,<7.287058,-41.676525,182.689373>}
      triangle {<2.928065,-42.196941,183.678516>,<7.287058,-41.676525,182.689373>,<2.928065,-41.676525,182.689374>}
      triangle {<2.928065,-42.196941,183.678516>,<2.928065,-43.186085,183.158105>,<7.287058,-43.186085,183.158104>}
      triangle {<2.928065,-42.196941,183.678516>,<7.287058,-43.186085,183.158104>,<7.287058,-42.196941,183.678516>}
      triangle {<7.287058,-42.196941,183.678516>,<7.287058,-43.186085,183.158104>,<7.287058,-42.665668,182.168961>}
      triangle {<7.287058,-42.196941,183.678516>,<7.287058,-42.665668,182.168961>,<7.287058,-41.676525,182.689373>}
      triangle {<7.287058,-41.676525,182.689373>,<7.287058,-42.665668,182.168961>,<2.928065,-42.665668,182.168961>}
      triangle {<7.287058,-41.676525,182.689373>,<2.928065,-42.665668,182.168961>,<2.928065,-41.676525,182.689374>}
      triangle {<2.928065,-41.676525,182.689374>,<2.928065,-42.665668,182.168961>,<2.928065,-43.186085,183.158105>}
      triangle {<2.928065,-41.676525,182.689374>,<2.928065,-43.186085,183.158105>,<2.928065,-42.196941,183.678516>}
      triangle {<2.928065,-43.186085,183.158105>,<2.928065,-42.665668,182.168961>,<7.287058,-42.665668,182.168961>}
      triangle {<2.928065,-43.186085,183.158105>,<7.287058,-42.665668,182.168961>,<7.287058,-43.186085,183.158104>}
      triangle {<4.241839,-18.270618,155.017426>,<4.241839,-3.732204,182.650410>,<3.353816,-2.824726,182.172962>}
      triangle {<3.353816,-17.363140,154.539979>,<4.241839,-18.270618,155.017426>,<3.353816,-2.824726,182.172962>}
      triangle {<6.017916,-18.270618,155.017426>,<6.017916,-3.732204,182.650410>,<4.241839,-3.732204,182.650410>}
      triangle {<4.241839,-18.270618,155.017426>,<6.017916,-18.270618,155.017426>,<4.241839,-3.732204,182.650410>}
      triangle {<6.905940,-17.363140,154.539979>,<6.905940,-2.824726,182.172963>,<6.017916,-3.732204,182.650410>}
      triangle {<6.017916,-18.270618,155.017426>,<6.905940,-17.363140,154.539979>,<6.017916,-3.732204,182.650410>}
      triangle {<7.287058,-3.844006,182.689370>,<7.287058,-3.323589,183.678511>,<2.928065,-3.323589,183.678510>}
      triangle {<2.928065,-3.844006,182.689369>,<7.287058,-3.844006,182.689370>,<2.928065,-3.323589,183.678510>}
      triangle {<7.287058,-2.334446,183.158099>,<2.928065,-2.334446,183.158100>,<2.928065,-3.323589,183.678510>}
      triangle {<7.287058,-3.323589,183.678511>,<7.287058,-2.334446,183.158099>,<2.928065,-3.323589,183.678510>}
      triangle {<7.287058,-2.854862,182.168955>,<7.287058,-2.334446,183.158099>,<7.287058,-3.323589,183.678511>}
      triangle {<7.287058,-3.844006,182.689370>,<7.287058,-2.854862,182.168955>,<7.287058,-3.323589,183.678511>}
      triangle {<2.928065,-2.854862,182.168957>,<7.287058,-2.854862,182.168955>,<7.287058,-3.844006,182.689370>}
      triangle {<2.928065,-3.844006,182.689369>,<2.928065,-2.854862,182.168957>,<7.287058,-3.844006,182.689370>}
      triangle {<2.928065,-2.334446,183.158100>,<2.928065,-2.854862,182.168957>,<2.928065,-3.844006,182.689369>}
      triangle {<2.928065,-3.323589,183.678510>,<2.928065,-2.334446,183.158100>,<2.928065,-3.844006,182.689369>}
      triangle {<7.287058,-2.854862,182.168955>,<2.928065,-2.854862,182.168957>,<2.928065,-2.334446,183.158100>}
      triangle {<7.287058,-2.334446,183.158099>,<7.287058,-2.854862,182.168955>,<2.928065,-2.334446,183.158100>}
      triangle {<-7.229146,-18.270618,155.017426>,<-7.229146,-3.732204,182.650410>,<-8.117170,-2.824726,182.172963>}
      triangle {<-8.117170,-17.363140,154.539979>,<-7.229146,-18.270618,155.017426>,<-8.117170,-2.824726,182.172963>}
      triangle {<-5.453069,-18.270618,155.017426>,<-5.453069,-3.732204,182.650410>,<-7.229146,-3.732204,182.650410>}
      triangle {<-7.229146,-18.270618,155.017426>,<-5.453069,-18.270618,155.017426>,<-7.229146,-3.732204,182.650410>}
      triangle {<-4.565038,-17.363140,154.539979>,<-4.565038,-2.824726,182.172963>,<-5.453069,-3.732204,182.650410>}
      triangle {<-5.453069,-18.270618,155.017426>,<-4.565038,-17.363140,154.539979>,<-5.453069,-3.732204,182.650410>}
      triangle {<-4.183927,-3.844006,182.689370>,<-4.183927,-3.323589,183.678511>,<-8.542913,-3.323589,183.678511>}
      triangle {<-8.542913,-3.844006,182.689369>,<-4.183927,-3.844006,182.689370>,<-8.542913,-3.323589,183.678511>}
      triangle {<-4.183927,-2.334446,183.158099>,<-8.542913,-2.334446,183.158098>,<-8.542913,-3.323589,183.678511>}
      triangle {<-4.183927,-3.323589,183.678511>,<-4.183927,-2.334446,183.158099>,<-8.542913,-3.323589,183.678511>}
      triangle {<-4.183927,-2.854862,182.168956>,<-4.183927,-2.334446,183.158099>,<-4.183927,-3.323589,183.678511>}
      triangle {<-4.183927,-3.844006,182.689370>,<-4.183927,-2.854862,182.168956>,<-4.183927,-3.323589,183.678511>}
      triangle {<-8.542913,-2.854862,182.168955>,<-4.183927,-2.854862,182.168956>,<-4.183927,-3.844006,182.689370>}
      triangle {<-8.542913,-3.844006,182.689369>,<-8.542913,-2.854862,182.168955>,<-4.183927,-3.844006,182.689370>}
      triangle {<-8.542913,-2.334446,183.158098>,<-8.542913,-2.854862,182.168955>,<-8.542913,-3.844006,182.689369>}
      triangle {<-8.542913,-3.323589,183.678511>,<-8.542913,-2.334446,183.158098>,<-8.542913,-3.844006,182.689369>}
      triangle {<-4.183927,-2.854862,182.168956>,<-8.542913,-2.854862,182.168955>,<-8.542913,-2.334446,183.158098>}
      triangle {<-4.183927,-2.334446,183.158099>,<-4.183927,-2.854862,182.168956>,<-8.542913,-2.334446,183.158098>}
      triangle {<91.858607,-27.301517,155.468070>,<91.858607,-23.452602,155.468070>,<66.675807,-24.579403,158.232106>}
      triangle {<66.675807,-30.153149,158.232106>,<91.858607,-27.301517,155.468070>,<66.675807,-24.579403,158.232106>}
      triangle {<91.858607,-23.452602,154.434594>,<66.675807,-24.579403,154.561810>,<66.675807,-24.579403,158.232106>}
      triangle {<91.858607,-23.452602,155.468070>,<91.858607,-23.452602,154.434594>,<66.675807,-24.579403,158.232106>}
      triangle {<91.858607,-27.301517,154.434594>,<91.858607,-23.452602,154.434594>,<91.858607,-23.452602,155.468070>}
      triangle {<91.858607,-27.301517,155.468070>,<91.858607,-27.301517,154.434594>,<91.858607,-23.452602,155.468070>}
      triangle {<66.675807,-30.153149,154.561810>,<91.858607,-27.301517,154.434594>,<91.858607,-27.301517,155.468070>}
      triangle {<66.675807,-30.153149,158.232106>,<66.675807,-30.153149,154.561810>,<91.858607,-27.301517,155.468070>}
      triangle {<66.675807,-24.579403,154.561810>,<66.675807,-30.153149,154.561810>,<66.675807,-30.153149,158.232106>}
      triangle {<66.675807,-24.579403,158.232106>,<66.675807,-24.579403,154.561810>,<66.675807,-30.153149,158.232106>}
      triangle {<91.858607,-27.301517,154.434594>,<66.675807,-30.153149,154.561810>,<66.675807,-24.579403,154.561810>}
      triangle {<91.858607,-23.452602,154.434594>,<91.858607,-27.301517,154.434594>,<66.675807,-24.579403,154.561810>}
      triangle {<66.675807,-21.528927,158.232106>,<91.858607,-22.655720,155.468070>,<91.858607,-18.806812,155.468070>}
      triangle {<66.675807,-21.528927,158.232106>,<91.858607,-18.806812,155.468070>,<66.675807,-15.955181,158.232106>}
      triangle {<66.675807,-21.528927,158.232106>,<66.675807,-21.528927,154.561810>,<91.858607,-22.655720,154.434596>}
      triangle {<66.675807,-21.528927,158.232106>,<91.858607,-22.655720,154.434596>,<91.858607,-22.655720,155.468070>}
      triangle {<91.858607,-22.655720,155.468070>,<91.858607,-22.655720,154.434596>,<91.858607,-18.806812,154.434594>}
      triangle {<91.858607,-22.655720,155.468070>,<91.858607,-18.806812,154.434594>,<91.858607,-18.806812,155.468070>}
      triangle {<91.858607,-18.806812,155.468070>,<91.858607,-18.806812,154.434594>,<66.675807,-15.955181,154.561810>}
      triangle {<91.858607,-18.806812,155.468070>,<66.675807,-15.955181,154.561810>,<66.675807,-15.955181,158.232106>}
      triangle {<66.675807,-15.955181,158.232106>,<66.675807,-15.955181,154.561810>,<66.675807,-21.528927,154.561810>}
      triangle {<66.675807,-15.955181,158.232106>,<66.675807,-21.528927,154.561810>,<66.675807,-21.528927,158.232106>}
      triangle {<66.675807,-21.528927,154.561810>,<66.675807,-15.955181,154.561810>,<91.858607,-18.806812,154.434594>}
      triangle {<66.675807,-21.528927,154.561810>,<91.858607,-18.806812,154.434594>,<91.858607,-22.655720,154.434596>}
      triangle {<-66.799329,-24.579403,158.232106>,<-91.982126,-23.452602,155.468070>,<-91.982126,-27.301517,155.468070>}
      triangle {<-66.799329,-24.579403,158.232106>,<-91.982126,-27.301517,155.468070>,<-66.799329,-30.153149,158.232106>}
      triangle {<-66.799329,-24.579403,158.232106>,<-66.799329,-24.579403,154.561810>,<-91.982126,-23.452602,154.434594>}
      triangle {<-66.799329,-24.579403,158.232106>,<-91.982126,-23.452602,154.434594>,<-91.982126,-23.452602,155.468070>}
      triangle {<-91.982126,-23.452602,155.468070>,<-91.982126,-23.452602,154.434594>,<-91.982126,-27.301517,154.434594>}
      triangle {<-91.982126,-23.452602,155.468070>,<-91.982126,-27.301517,154.434594>,<-91.982126,-27.301517,155.468070>}
      triangle {<-91.982126,-27.301517,155.468070>,<-91.982126,-27.301517,154.434594>,<-66.799329,-30.153149,154.561810>}
      triangle {<-91.982126,-27.301517,155.468070>,<-66.799329,-30.153149,154.561810>,<-66.799329,-30.153149,158.232106>}
      triangle {<-66.799329,-30.153149,158.232106>,<-66.799329,-30.153149,154.561810>,<-66.799329,-24.579403,154.561810>}
      triangle {<-66.799329,-30.153149,158.232106>,<-66.799329,-24.579403,154.561810>,<-66.799329,-24.579403,158.232106>}
      triangle {<-66.799329,-24.579403,154.561810>,<-66.799329,-30.153149,154.561810>,<-91.982126,-27.301517,154.434594>}
      triangle {<-66.799329,-24.579403,154.561810>,<-91.982126,-27.301517,154.434594>,<-91.982126,-23.452602,154.434594>}
      triangle {<-91.982126,-18.806812,155.468070>,<-91.982126,-22.655720,155.468070>,<-66.799329,-21.528927,158.232106>}
      triangle {<-66.799329,-15.955181,158.232106>,<-91.982126,-18.806812,155.468070>,<-66.799329,-21.528927,158.232106>}
      triangle {<-91.982126,-22.655720,154.434596>,<-66.799329,-21.528927,154.561810>,<-66.799329,-21.528927,158.232106>}
      triangle {<-91.982126,-22.655720,155.468070>,<-91.982126,-22.655720,154.434596>,<-66.799329,-21.528927,158.232106>}
      triangle {<-91.982126,-18.806812,154.434594>,<-91.982126,-22.655720,154.434596>,<-91.982126,-22.655720,155.468070>}
      triangle {<-91.982126,-18.806812,155.468070>,<-91.982126,-18.806812,154.434594>,<-91.982126,-22.655720,155.468070>}
      triangle {<-66.799329,-15.955181,154.561810>,<-91.982126,-18.806812,154.434594>,<-91.982126,-18.806812,155.468070>}
      triangle {<-66.799329,-15.955181,158.232106>,<-66.799329,-15.955181,154.561810>,<-91.982126,-18.806812,155.468070>}
      triangle {<-66.799329,-21.528927,154.561810>,<-66.799329,-15.955181,154.561810>,<-66.799329,-15.955181,158.232106>}
      triangle {<-66.799329,-21.528927,158.232106>,<-66.799329,-21.528927,154.561810>,<-66.799329,-15.955181,158.232106>}
      triangle {<-91.982126,-18.806812,154.434594>,<-66.799329,-15.955181,154.561810>,<-66.799329,-21.528927,154.561810>}
      triangle {<-91.982126,-22.655720,154.434596>,<-91.982126,-18.806812,154.434594>,<-66.799329,-21.528927,154.561810>}
      triangle {<92.017207,-17.550961,156.251847>,<93.544779,-17.870869,155.833127>,<93.544779,-17.870869,149.543099>}
      triangle {<92.017207,-17.550961,156.251847>,<93.544779,-17.870869,149.543099>,<92.017207,-17.550961,149.961820>}
      triangle {<92.017207,-17.550961,156.251847>,<92.017207,-28.214497,156.251849>,<93.544779,-27.894588,155.833129>}
      triangle {<92.017207,-17.550961,156.251847>,<93.544779,-27.894588,155.833129>,<93.544779,-17.870869,155.833127>}
      triangle {<93.544779,-17.870869,155.833127>,<93.544779,-27.894588,155.833129>,<93.544779,-27.894588,149.543101>}
      triangle {<93.544779,-17.870869,155.833127>,<93.544779,-27.894588,149.543101>,<93.544779,-17.870869,149.543099>}
      triangle {<93.544779,-17.870869,149.543099>,<93.544779,-27.894588,149.543101>,<92.017207,-28.214497,149.961822>}
      triangle {<93.544779,-17.870869,149.543099>,<92.017207,-28.214497,149.961822>,<92.017207,-17.550961,149.961820>}
      triangle {<92.017207,-17.550961,149.961820>,<92.017207,-28.214497,149.961822>,<92.017207,-28.214497,156.251849>}
      triangle {<92.017207,-17.550961,149.961820>,<92.017207,-28.214497,156.251849>,<92.017207,-17.550961,156.251847>}
      triangle {<92.017207,-28.214497,156.251849>,<92.017207,-28.214497,149.961822>,<93.544779,-27.894588,149.543101>}
      triangle {<92.017207,-28.214497,156.251849>,<93.544779,-27.894588,149.543101>,<93.544779,-27.894588,155.833129>}
      triangle {<-93.341775,-17.794598,149.543099>,<-93.341776,-17.794598,155.833127>,<-91.814203,-17.555187,156.251847>}
      triangle {<-91.814202,-17.555187,149.961820>,<-93.341775,-17.794598,149.543099>,<-91.814203,-17.555187,156.251847>}
      triangle {<-93.341776,-27.970852,155.833129>,<-91.814203,-28.210262,156.251849>,<-91.814203,-17.555187,156.251847>}
      triangle {<-93.341776,-17.794598,155.833127>,<-93.341776,-27.970852,155.833129>,<-91.814203,-17.555187,156.251847>}
      triangle {<-93.341775,-27.970852,149.543101>,<-93.341776,-27.970852,155.833129>,<-93.341776,-17.794598,155.833127>}
      triangle {<-93.341775,-17.794598,149.543099>,<-93.341775,-27.970852,149.543101>,<-93.341776,-17.794598,155.833127>}
      triangle {<-91.814202,-28.210262,149.961822>,<-93.341775,-27.970852,149.543101>,<-93.341775,-17.794598,149.543099>}
      triangle {<-91.814202,-17.555187,149.961820>,<-91.814202,-28.210262,149.961822>,<-93.341775,-17.794598,149.543099>}
      triangle {<-91.814203,-28.210262,156.251849>,<-91.814202,-28.210262,149.961822>,<-91.814202,-17.555187,149.961820>}
      triangle {<-91.814203,-17.555187,156.251847>,<-91.814203,-28.210262,156.251849>,<-91.814202,-17.555187,149.961820>}
      triangle {<-93.341775,-27.970852,149.543101>,<-91.814202,-28.210262,149.961822>,<-91.814203,-28.210262,156.251849>}
      triangle {<-93.341776,-27.970852,155.833129>,<-93.341775,-27.970852,149.543101>,<-91.814203,-28.210262,156.251849>}
      triangle {<93.076029,-19.642887,151.939094>,<99.286265,-19.642887,151.939094>,<99.286265,-19.642887,149.824958>}
      triangle {<93.076029,-19.642887,151.939094>,<99.286265,-19.642887,149.824958>,<93.076029,-19.642887,149.824958>}
      triangle {<93.076029,-19.642887,151.939094>,<93.076029,-26.176189,151.939094>,<99.286265,-26.176189,151.939094>}
      triangle {<93.076029,-19.642887,151.939094>,<99.286265,-26.176189,151.939094>,<99.286265,-19.642887,151.939094>}
      triangle {<99.286265,-19.642887,151.939094>,<99.286265,-26.176189,151.939094>,<99.286265,-26.176189,149.824958>}
      triangle {<99.286265,-19.642887,151.939094>,<99.286265,-26.176189,149.824958>,<99.286265,-19.642887,149.824958>}
      triangle {<99.286265,-19.642887,149.824958>,<99.286265,-26.176189,149.824958>,<93.076029,-26.176189,149.824958>}
      triangle {<99.286265,-19.642887,149.824958>,<93.076029,-26.176189,149.824958>,<93.076029,-19.642887,149.824958>}
      triangle {<93.076029,-19.642887,149.824958>,<93.076029,-26.176189,149.824958>,<93.076029,-26.176189,151.939094>}
      triangle {<93.076029,-19.642887,149.824958>,<93.076029,-26.176189,151.939094>,<93.076029,-19.642887,151.939094>}
      triangle {<93.076029,-26.176189,151.939094>,<93.076029,-26.176189,149.824958>,<99.286265,-26.176189,149.824958>}
      triangle {<93.076029,-26.176189,151.939094>,<99.286265,-26.176189,149.824958>,<99.286265,-26.176189,151.939094>}
      triangle {<-99.577683,-19.642887,151.939094>,<-93.367425,-19.642887,151.939094>,<-93.367433,-19.642887,149.824958>}
      triangle {<-99.577683,-19.642887,151.939094>,<-93.367433,-19.642887,149.824958>,<-99.577683,-19.642887,149.824958>}
      triangle {<-99.577683,-19.642887,151.939094>,<-99.577683,-26.176189,151.939094>,<-93.367425,-26.176189,151.939094>}
      triangle {<-99.577683,-19.642887,151.939094>,<-93.367425,-26.176189,151.939094>,<-93.367425,-19.642887,151.939094>}
      triangle {<-93.367425,-19.642887,151.939094>,<-93.367425,-26.176189,151.939094>,<-93.367433,-26.176189,149.824958>}
      triangle {<-93.367425,-19.642887,151.939094>,<-93.367433,-26.176189,149.824958>,<-93.367433,-19.642887,149.824958>}
      triangle {<-93.367433,-19.642887,149.824958>,<-93.367433,-26.176189,149.824958>,<-99.577683,-26.176189,149.824958>}
      triangle {<-93.367433,-19.642887,149.824958>,<-99.577683,-26.176189,149.824958>,<-99.577683,-19.642887,149.824958>}
      triangle {<-99.577683,-19.642887,149.824958>,<-99.577683,-26.176189,149.824958>,<-99.577683,-26.176189,151.939094>}
      triangle {<-99.577683,-19.642887,149.824958>,<-99.577683,-26.176189,151.939094>,<-99.577683,-19.642887,151.939094>}
      triangle {<-99.577683,-26.176189,151.939094>,<-99.577683,-26.176189,149.824958>,<-93.367433,-26.176189,149.824958>}
      triangle {<-99.577683,-26.176189,151.939094>,<-93.367433,-26.176189,149.824958>,<-93.367425,-26.176189,151.939094>}
      texture{_Heck03}
    }
    //_Heck04
    mesh{
      triangle {<3.385584,-22.934208,155.274646>,<3.385584,-22.934216,161.851264>,<3.183611,-24.209354,161.851296>}
      triangle {<3.385584,-22.934208,155.274646>,<3.183611,-24.209354,161.851296>,<3.183611,-24.209354,155.274646>}
      triangle {<3.385584,-22.934216,161.851264>,<4.869380,-22.934216,163.100008>,<4.594790,-24.667873,163.100009>}
      triangle {<3.385584,-22.934216,161.851264>,<4.594790,-24.667873,163.100009>,<3.183611,-24.209354,161.851296>}
      triangle {<4.869380,-22.934216,163.100008>,<5.956210,-22.934216,165.433195>,<5.628420,-25.003727,165.433195>}
      triangle {<4.869380,-22.934216,163.100008>,<5.628420,-25.003727,165.433195>,<4.594790,-24.667873,163.100009>}
      triangle {<5.956210,-22.934216,165.433195>,<6.702799,-22.934216,168.402772>,<6.338465,-25.234440,168.402773>}
      triangle {<5.956210,-22.934216,165.433195>,<6.338465,-25.234440,168.402773>,<5.628420,-25.003727,165.433195>}
      triangle {<6.702799,-22.934216,168.402772>,<7.165843,-22.934216,171.560601>,<6.778857,-25.377522,171.560617>}
      triangle {<6.702799,-22.934216,168.402772>,<6.778857,-25.377522,171.560617>,<6.338465,-25.234440,168.402773>}
      triangle {<7.165843,-22.934216,171.560601>,<7.402079,-22.934216,174.458659>,<7.003527,-25.450527,174.458659>}
      triangle {<7.165843,-22.934216,171.560601>,<7.003527,-25.450527,174.458659>,<6.778857,-25.377522,171.560617>}
      triangle {<7.402079,-22.934216,174.458659>,<7.468234,-22.934216,176.648767>,<7.066439,-25.470966,176.648766>}
      triangle {<7.402079,-22.934216,174.458659>,<7.066439,-25.470966,176.648766>,<7.003527,-25.450527,174.458659>}
      triangle {<7.468234,-22.934216,176.648767>,<7.051226,-22.934216,176.648767>,<6.669848,-25.342113,176.648766>}
      triangle {<7.468234,-22.934216,176.648767>,<6.669848,-25.342113,176.648766>,<7.066439,-25.470966,176.648766>}
      triangle {<7.051226,-22.934216,176.648767>,<6.941660,-22.934216,173.645401>,<6.565646,-25.308254,173.645400>}
      triangle {<7.051226,-22.934216,176.648767>,<6.565646,-25.308254,173.645400>,<6.669848,-25.342113,176.648766>}
      triangle {<6.941660,-22.934216,173.645401>,<6.642222,-22.934216,170.428505>,<6.280863,-25.215710,170.428522>}
      triangle {<6.941660,-22.934216,173.645401>,<6.280863,-25.215710,170.428522>,<6.565646,-25.308254,173.645400>}
      triangle {<6.642222,-22.934216,170.428505>,<6.092585,-22.934216,167.371029>,<5.758120,-25.045864,167.371029>}
      triangle {<6.642222,-22.934216,170.428505>,<5.758120,-25.045864,167.371029>,<6.280863,-25.215710,170.428522>}
      triangle {<6.092585,-22.934216,167.371029>,<5.232409,-22.934216,164.845853>,<4.940051,-24.780056,164.845853>}
      triangle {<6.092585,-22.934216,167.371029>,<4.940051,-24.780056,164.845853>,<5.758120,-25.045864,167.371029>}
      triangle {<5.232409,-22.934216,164.845853>,<4.001383,-22.934216,163.225939>,<3.769274,-24.399647,163.225940>}
      triangle {<5.232409,-22.934216,164.845853>,<3.769274,-24.399647,163.225940>,<4.940051,-24.780056,164.845853>}
      triangle {<4.001383,-22.934216,163.225939>,<2.339167,-22.934216,162.884232>,<2.188410,-23.885998,162.884232>}
      triangle {<4.001383,-22.934216,163.225939>,<2.188410,-23.885998,162.884232>,<3.769274,-24.399647,163.225940>}
      triangle {<2.339167,-22.934216,162.884232>,<2.364916,-22.934208,155.274646>,<2.212908,-23.893948,155.274646>}
      triangle {<2.339167,-22.934216,162.884232>,<2.212908,-23.893948,155.274646>,<2.188410,-23.885998,162.884232>}
      triangle {<2.364916,-22.934208,155.274646>,<3.385584,-22.934208,155.274646>,<3.183611,-24.209354,155.274646>}
      triangle {<2.364916,-22.934208,155.274646>,<3.183611,-24.209354,155.274646>,<2.212908,-23.893948,155.274646>}
      triangle {<3.183611,-24.209354,155.274646>,<3.183611,-24.209354,161.851296>,<2.597498,-25.359692,161.851296>}
      triangle {<3.183611,-24.209354,155.274646>,<2.597498,-25.359692,161.851296>,<2.597498,-25.359692,155.274646>}
      triangle {<3.183611,-24.209354,161.851296>,<4.594790,-24.667873,163.100009>,<3.797907,-26.231846,163.100008>}
      triangle {<3.183611,-24.209354,161.851296>,<3.797907,-26.231846,163.100008>,<2.597498,-25.359692,161.851296>}
      triangle {<4.594790,-24.667873,163.100009>,<5.628420,-25.003727,165.433195>,<4.677180,-26.870663,165.433195>}
      triangle {<4.594790,-24.667873,163.100009>,<4.677180,-26.870663,165.433195>,<3.797907,-26.231846,163.100008>}
      triangle {<5.628420,-25.003727,165.433195>,<6.338465,-25.234440,168.402773>,<5.281184,-27.309498,168.402772>}
      triangle {<5.628420,-25.003727,165.433195>,<5.281184,-27.309498,168.402772>,<4.677180,-26.870663,165.433195>}
      triangle {<6.338465,-25.234440,168.402773>,<6.778857,-25.377522,171.560617>,<5.655795,-27.581669,171.560601>}
      triangle {<6.338465,-25.234440,168.402773>,<5.655795,-27.581669,171.560601>,<5.281184,-27.309498,168.402772>}
      triangle {<6.778857,-25.377522,171.560617>,<7.003527,-25.450527,174.458659>,<5.846911,-27.720531,174.458649>}
      triangle {<6.778857,-25.377522,171.560617>,<5.846911,-27.720531,174.458649>,<5.655795,-27.581669,171.560601>}
      triangle {<7.003527,-25.450527,174.458659>,<7.066439,-25.470966,176.648766>,<5.900424,-27.759411,176.648766>}
      triangle {<7.003527,-25.450527,174.458659>,<5.900424,-27.759411,176.648766>,<5.846911,-27.720531,174.458649>}
      triangle {<7.066439,-25.470966,176.648766>,<6.669848,-25.342113,176.648766>,<5.563067,-27.514301,176.648766>}
      triangle {<7.066439,-25.470966,176.648766>,<5.563067,-27.514301,176.648766>,<5.900424,-27.759411,176.648766>}
      triangle {<6.669848,-25.342113,176.648766>,<6.565646,-25.308254,173.645400>,<5.474421,-27.449894,173.645400>}
      triangle {<6.669848,-25.342113,176.648766>,<5.474421,-27.449894,173.645400>,<5.563067,-27.514301,176.648766>}
      triangle {<6.565646,-25.308254,173.645400>,<6.280863,-25.215710,170.428522>,<5.232172,-27.273891,170.428505>}
      triangle {<6.565646,-25.308254,173.645400>,<5.232172,-27.273891,170.428505>,<5.474421,-27.449894,173.645400>}
      triangle {<6.280863,-25.215710,170.428522>,<5.758120,-25.045864,167.371029>,<4.787501,-26.950817,167.371017>}
      triangle {<6.280863,-25.215710,170.428522>,<4.787501,-26.950817,167.371017>,<5.232172,-27.273891,170.428505>}
      triangle {<5.758120,-25.045864,167.371029>,<4.940051,-24.780056,164.845853>,<4.091616,-26.445225,164.845853>}
      triangle {<5.758120,-25.045864,167.371029>,<4.091616,-26.445225,164.845853>,<4.787501,-26.950817,167.371017>}
      triangle {<4.940051,-24.780056,164.845853>,<3.769274,-24.399647,163.225940>,<3.095690,-25.721645,163.225939>}
      triangle {<4.940051,-24.780056,164.845853>,<3.095690,-25.721645,163.225939>,<4.091616,-26.445225,164.845853>}
      triangle {<3.769274,-24.399647,163.225940>,<2.188410,-23.885998,162.884232>,<1.750926,-24.744625,162.884233>}
      triangle {<3.769274,-24.399647,163.225940>,<1.750926,-24.744625,162.884233>,<3.095690,-25.721645,163.225939>}
      triangle {<2.188410,-23.885998,162.884232>,<2.212908,-23.893948,155.274646>,<1.771769,-24.759754,155.274646>}
      triangle {<2.188410,-23.885998,162.884232>,<1.771769,-24.759754,155.274646>,<1.750926,-24.744625,162.884233>}
      triangle {<2.212908,-23.893948,155.274646>,<3.183611,-24.209354,155.274646>,<2.597498,-25.359692,155.274646>}
      triangle {<2.212908,-23.893948,155.274646>,<2.597498,-25.359692,155.274646>,<1.771769,-24.759754,155.274646>}
      triangle {<2.597498,-25.359692,155.274646>,<2.597498,-25.359692,161.851296>,<1.684588,-26.272587,161.851297>}
      triangle {<2.597498,-25.359692,155.274646>,<1.684588,-26.272587,161.851297>,<1.684588,-26.272587,155.274646>}
      triangle {<2.597498,-25.359692,161.851296>,<3.797907,-26.231846,163.100008>,<2.556742,-27.473003,163.100008>}
      triangle {<2.597498,-25.359692,161.851296>,<2.556742,-27.473003,163.100008>,<1.684588,-26.272587,161.851297>}
      triangle {<3.797907,-26.231846,163.100008>,<4.677180,-26.870663,165.433195>,<3.195567,-28.352268,165.433195>}
      triangle {<3.797907,-26.231846,163.100008>,<3.195567,-28.352268,165.433195>,<2.556742,-27.473003,163.100008>}
      triangle {<4.677180,-26.870663,165.433195>,<5.281184,-27.309498,168.402772>,<3.634394,-28.956264,168.402772>}
      triangle {<4.677180,-26.870663,165.433195>,<3.634394,-28.956264,168.402772>,<3.195567,-28.352268,165.433195>}
      triangle {<5.281184,-27.309498,168.402772>,<5.655795,-27.581669,171.560601>,<3.906573,-29.330891,171.560617>}
      triangle {<5.281184,-27.309498,168.402772>,<3.906573,-29.330891,171.560617>,<3.634394,-28.956264,168.402772>}
      triangle {<5.655795,-27.581669,171.560601>,<5.846911,-27.720531,174.458649>,<4.045428,-29.522007,174.458649>}
      triangle {<5.655795,-27.581669,171.560601>,<4.045428,-29.522007,174.458649>,<3.906573,-29.330891,171.560617>}
      triangle {<5.846911,-27.720531,174.458649>,<5.900424,-27.759411,176.648766>,<4.084307,-29.575520,176.648767>}
      triangle {<5.846911,-27.720531,174.458649>,<4.084307,-29.575520,176.648767>,<4.045428,-29.522007,174.458649>}
      triangle {<5.900424,-27.759411,176.648766>,<5.563067,-27.514301,176.648766>,<3.839198,-29.238163,176.648767>}
      triangle {<5.900424,-27.759411,176.648766>,<3.839198,-29.238163,176.648767>,<4.084307,-29.575520,176.648767>}
      triangle {<5.563067,-27.514301,176.648766>,<5.474421,-27.449894,173.645400>,<3.774798,-29.149517,173.645417>}
      triangle {<5.563067,-27.514301,176.648766>,<3.774798,-29.149517,173.645417>,<3.839198,-29.238163,176.648767>}
      triangle {<5.474421,-27.449894,173.645400>,<5.232172,-27.273891,170.428505>,<3.598795,-28.907261,170.428522>}
      triangle {<5.474421,-27.449894,173.645400>,<3.598795,-28.907261,170.428522>,<3.774798,-29.149517,173.645417>}
      triangle {<5.232172,-27.273891,170.428505>,<4.787501,-26.950817,167.371017>,<3.275721,-28.462589,167.371017>}
      triangle {<5.232172,-27.273891,170.428505>,<3.275721,-28.462589,167.371017>,<3.598795,-28.907261,170.428522>}
      triangle {<4.787501,-26.950817,167.371017>,<4.091616,-26.445225,164.845853>,<2.770121,-27.766705,164.845853>}
      triangle {<4.787501,-26.950817,167.371017>,<2.770121,-27.766705,164.845853>,<3.275721,-28.462589,167.371017>}
      triangle {<4.091616,-26.445225,164.845853>,<3.095690,-25.721645,163.225939>,<2.046542,-26.770779,163.225939>}
      triangle {<4.091616,-26.445225,164.845853>,<2.046542,-26.770779,163.225939>,<2.770121,-27.766705,164.845853>}
      triangle {<3.095690,-25.721645,163.225939>,<1.750926,-24.744625,162.884233>,<1.069521,-25.426022,162.884233>}
      triangle {<3.095690,-25.721645,163.225939>,<1.069521,-25.426022,162.884233>,<2.046542,-26.770779,163.225939>}
      triangle {<1.750926,-24.744625,162.884233>,<1.771769,-24.759754,155.274646>,<1.084658,-25.446850,155.274646>}
      triangle {<1.750926,-24.744625,162.884233>,<1.084658,-25.446850,155.274646>,<1.069521,-25.426022,162.884233>}
      triangle {<1.771769,-24.759754,155.274646>,<2.597498,-25.359692,155.274646>,<1.684588,-26.272587,155.274646>}
      triangle {<1.771769,-24.759754,155.274646>,<1.684588,-26.272587,155.274646>,<1.084658,-25.446850,155.274646>}
      triangle {<1.684588,-26.272587,155.274646>,<1.684588,-26.272587,161.851297>,<0.534266,-26.858707,161.851297>}
      triangle {<1.684588,-26.272587,155.274646>,<0.534266,-26.858707,161.851297>,<0.534266,-26.858707,155.274646>}
      triangle {<1.684588,-26.272587,161.851297>,<2.556742,-27.473003,163.100008>,<0.992785,-28.269886,163.100008>}
      triangle {<1.684588,-26.272587,161.851297>,<0.992785,-28.269886,163.100008>,<0.534266,-26.858707,161.851297>}
      triangle {<2.556742,-27.473003,163.100008>,<3.195567,-28.352268,165.433195>,<1.328631,-29.303524,165.433195>}
      triangle {<2.556742,-27.473003,163.100008>,<1.328631,-29.303524,165.433195>,<0.992785,-28.269886,163.100008>}
      triangle {<3.195567,-28.352268,165.433195>,<3.634394,-28.956264,168.402772>,<1.559336,-30.013569,168.402772>}
      triangle {<3.195567,-28.352268,165.433195>,<1.559336,-30.013569,168.402772>,<1.328631,-29.303524,165.433195>}
      triangle {<3.634394,-28.956264,168.402772>,<3.906573,-29.330891,171.560617>,<1.702433,-30.453960,171.560617>}
      triangle {<3.634394,-28.956264,168.402772>,<1.702433,-30.453960,171.560617>,<1.559336,-30.013569,168.402772>}
      triangle {<3.906573,-29.330891,171.560617>,<4.045428,-29.522007,174.458649>,<1.775439,-30.678638,174.458649>}
      triangle {<3.906573,-29.330891,171.560617>,<1.775439,-30.678638,174.458649>,<1.702433,-30.453960,171.560617>}
      triangle {<4.045428,-29.522007,174.458649>,<4.084307,-29.575520,176.648767>,<1.795870,-30.741543,176.648767>}
      triangle {<4.045428,-29.522007,174.458649>,<1.795870,-30.741543,176.648767>,<1.775439,-30.678638,174.458649>}
      triangle {<4.084307,-29.575520,176.648767>,<3.839198,-29.238163,176.648767>,<1.667010,-30.344944,176.648767>}
      triangle {<4.084307,-29.575520,176.648767>,<1.667010,-30.344944,176.648767>,<1.795870,-30.741543,176.648767>}
      triangle {<3.839198,-29.238163,176.648767>,<3.774798,-29.149517,173.645417>,<1.633151,-30.240749,173.645400>}
      triangle {<3.839198,-29.238163,176.648767>,<1.633151,-30.240749,173.645400>,<1.667010,-30.344944,176.648767>}
      triangle {<3.774798,-29.149517,173.645417>,<3.598795,-28.907261,170.428522>,<1.540621,-29.955959,170.428522>}
      triangle {<3.774798,-29.149517,173.645417>,<1.540621,-29.955959,170.428522>,<1.633151,-30.240749,173.645400>}
      triangle {<3.598795,-28.907261,170.428522>,<3.275721,-28.462589,167.371017>,<1.370768,-29.433216,167.371017>}
      triangle {<3.598795,-28.907261,170.428522>,<1.370768,-29.433216,167.371017>,<1.540621,-29.955959,170.428522>}
      triangle {<3.275721,-28.462589,167.371017>,<2.770121,-27.766705,164.845853>,<1.104968,-28.615147,164.845853>}
      triangle {<3.275721,-28.462589,167.371017>,<1.104968,-28.615147,164.845853>,<1.370768,-29.433216,167.371017>}
      triangle {<2.770121,-27.766705,164.845853>,<2.046542,-26.770779,163.225939>,<0.724558,-27.444378,163.225939>}
      triangle {<2.770121,-27.766705,164.845853>,<0.724558,-27.444378,163.225939>,<1.104968,-28.615147,164.845853>}
      triangle {<2.046542,-26.770779,163.225939>,<1.069521,-25.426022,162.884233>,<0.210909,-25.863522,162.884232>}
      triangle {<2.046542,-26.770779,163.225939>,<0.210909,-25.863522,162.884232>,<0.724558,-27.444378,163.225939>}
      triangle {<1.069521,-25.426022,162.884233>,<1.084658,-25.446850,155.274646>,<0.218867,-25.888004,155.274646>}
      triangle {<1.069521,-25.426022,162.884233>,<0.218867,-25.888004,155.274646>,<0.210909,-25.863522,162.884232>}
      triangle {<1.084658,-25.446850,155.274646>,<1.684588,-26.272587,155.274646>,<0.534266,-26.858707,155.274646>}
      triangle {<1.084658,-25.446850,155.274646>,<0.534266,-26.858707,155.274646>,<0.218867,-25.888004,155.274646>}
      triangle {<0.534266,-26.858707,155.274646>,<0.534266,-26.858707,161.851297>,<-0.740888,-27.060673,161.851297>}
      triangle {<0.534266,-26.858707,155.274646>,<-0.740888,-27.060673,161.851297>,<-0.740888,-27.060673,155.274646>}
      triangle {<0.534266,-26.858707,161.851297>,<0.992785,-28.269886,163.100008>,<-0.740888,-28.544468,163.100008>}
      triangle {<0.534266,-26.858707,161.851297>,<-0.740888,-28.544468,163.100008>,<-0.740888,-27.060673,161.851297>}
      triangle {<0.992785,-28.269886,163.100008>,<1.328631,-29.303524,165.433195>,<-0.740888,-29.631290,165.433195>}
      triangle {<0.992785,-28.269886,163.100008>,<-0.740888,-29.631290,165.433195>,<-0.740888,-28.544468,163.100008>}
      triangle {<1.328631,-29.303524,165.433195>,<1.559336,-30.013569,168.402772>,<-0.740888,-30.377880,168.402763>}
      triangle {<1.328631,-29.303524,165.433195>,<-0.740888,-30.377880,168.402763>,<-0.740888,-29.631290,165.433195>}
      triangle {<1.559336,-30.013569,168.402772>,<1.702433,-30.453960,171.560617>,<-0.740888,-30.840939,171.560600>}
      triangle {<1.559336,-30.013569,168.402772>,<-0.740888,-30.840939,171.560600>,<-0.740888,-30.377880,168.402763>}
      triangle {<1.702433,-30.453960,171.560617>,<1.775439,-30.678638,174.458649>,<-0.740888,-31.077175,174.458649>}
      triangle {<1.702433,-30.453960,171.560617>,<-0.740888,-31.077175,174.458649>,<-0.740888,-30.840939,171.560600>}
      triangle {<1.775439,-30.678638,174.458649>,<1.795870,-30.741543,176.648767>,<-0.740888,-31.143314,176.648767>}
      triangle {<1.775439,-30.678638,174.458649>,<-0.740888,-31.143314,176.648767>,<-0.740888,-31.077175,174.458649>}
      triangle {<1.795870,-30.741543,176.648767>,<1.667010,-30.344944,176.648767>,<-0.740888,-30.726322,176.648767>}
      triangle {<1.795870,-30.741543,176.648767>,<-0.740888,-30.726322,176.648767>,<-0.740888,-31.143314,176.648767>}
      triangle {<1.667010,-30.344944,176.648767>,<1.633151,-30.240749,173.645400>,<-0.740888,-30.616749,173.645400>}
      triangle {<1.667010,-30.344944,176.648767>,<-0.740888,-30.616749,173.645400>,<-0.740888,-30.726322,176.648767>}
      triangle {<1.633151,-30.240749,173.645400>,<1.540621,-29.955959,170.428522>,<-0.740888,-30.317303,170.428522>}
      triangle {<1.633151,-30.240749,173.645400>,<-0.740888,-30.317303,170.428522>,<-0.740888,-30.616749,173.645400>}
      triangle {<1.540621,-29.955959,170.428522>,<1.370768,-29.433216,167.371017>,<-0.740888,-29.767666,167.371017>}
      triangle {<1.540621,-29.955959,170.428522>,<-0.740888,-29.767666,167.371017>,<-0.740888,-30.317303,170.428522>}
      triangle {<1.370768,-29.433216,167.371017>,<1.104968,-28.615147,164.845853>,<-0.740888,-28.907497,164.845853>}
      triangle {<1.370768,-29.433216,167.371017>,<-0.740888,-28.907497,164.845853>,<-0.740888,-29.767666,167.371017>}
      triangle {<1.104968,-28.615147,164.845853>,<0.724558,-27.444378,163.225939>,<-0.740888,-27.676472,163.225940>}
      triangle {<1.104968,-28.615147,164.845853>,<-0.740888,-27.676472,163.225940>,<-0.740888,-28.907497,164.845853>}
      triangle {<0.724558,-27.444378,163.225939>,<0.210909,-25.863522,162.884232>,<-0.740888,-26.014263,162.884232>}
      triangle {<0.724558,-27.444378,163.225939>,<-0.740888,-26.014263,162.884232>,<-0.740888,-27.676472,163.225940>}
      triangle {<0.210909,-25.863522,162.884232>,<0.218867,-25.888004,155.274646>,<-0.740888,-26.040005,155.274646>}
      triangle {<0.210909,-25.863522,162.884232>,<-0.740888,-26.040005,155.274646>,<-0.740888,-26.014263,162.884232>}
      triangle {<0.218867,-25.888004,155.274646>,<0.534266,-26.858707,155.274646>,<-0.740888,-27.060673,155.274646>}
      triangle {<0.218867,-25.888004,155.274646>,<-0.740888,-27.060673,155.274646>,<-0.740888,-26.040005,155.274646>}
      triangle {<-0.740888,-27.060673,155.274646>,<-0.740888,-27.060673,161.851297>,<-2.016027,-26.858707,161.851297>}
      triangle {<-0.740888,-27.060673,155.274646>,<-2.016027,-26.858707,161.851297>,<-2.016027,-26.858707,155.274646>}
      triangle {<-0.740888,-27.060673,161.851297>,<-0.740888,-28.544468,163.100008>,<-2.474546,-28.269886,163.100008>}
      triangle {<-0.740888,-27.060673,161.851297>,<-2.474546,-28.269886,163.100008>,<-2.016027,-26.858707,161.851297>}
      triangle {<-0.740888,-28.544468,163.100008>,<-0.740888,-29.631290,165.433195>,<-2.810400,-29.303524,165.433195>}
      triangle {<-0.740888,-28.544468,163.100008>,<-2.810400,-29.303524,165.433195>,<-2.474546,-28.269886,163.100008>}
      triangle {<-0.740888,-29.631290,165.433195>,<-0.740888,-30.377880,168.402763>,<-3.041105,-30.013569,168.402772>}
      triangle {<-0.740888,-29.631290,165.433195>,<-3.041105,-30.013569,168.402772>,<-2.810400,-29.303524,165.433195>}
      triangle {<-0.740888,-30.377880,168.402763>,<-0.740888,-30.840939,171.560600>,<-3.184194,-30.453953,171.560617>}
      triangle {<-0.740888,-30.377880,168.402763>,<-3.184194,-30.453953,171.560617>,<-3.041105,-30.013569,168.402772>}
      triangle {<-0.740888,-30.840939,171.560600>,<-0.740888,-31.077175,174.458649>,<-3.257200,-30.678638,174.458649>}
      triangle {<-0.740888,-30.840939,171.560600>,<-3.257200,-30.678638,174.458649>,<-3.184194,-30.453953,171.560617>}
      triangle {<-0.740888,-31.077175,174.458649>,<-0.740888,-31.143314,176.648767>,<-3.277639,-30.741535,176.648767>}
      triangle {<-0.740888,-31.077175,174.458649>,<-3.277639,-30.741535,176.648767>,<-3.257200,-30.678638,174.458649>}
      triangle {<-0.740888,-31.143314,176.648767>,<-0.740888,-30.726322,176.648767>,<-3.148778,-30.344944,176.648767>}
      triangle {<-0.740888,-31.143314,176.648767>,<-3.148778,-30.344944,176.648767>,<-3.277639,-30.741535,176.648767>}
      triangle {<-0.740888,-30.726322,176.648767>,<-0.740888,-30.616749,173.645400>,<-3.114919,-30.240749,173.645400>}
      triangle {<-0.740888,-30.726322,176.648767>,<-3.114919,-30.240749,173.645400>,<-3.148778,-30.344944,176.648767>}
      triangle {<-0.740888,-30.616749,173.645400>,<-0.740888,-30.317303,170.428522>,<-3.022390,-29.955959,170.428522>}
      triangle {<-0.740888,-30.616749,173.645400>,<-3.022390,-29.955959,170.428522>,<-3.114919,-30.240749,173.645400>}
      triangle {<-0.740888,-30.317303,170.428522>,<-0.740888,-29.767666,167.371017>,<-2.852537,-29.433216,167.371017>}
      triangle {<-0.740888,-30.317303,170.428522>,<-2.852537,-29.433216,167.371017>,<-3.022390,-29.955959,170.428522>}
      triangle {<-0.740888,-29.767666,167.371017>,<-0.740888,-28.907497,164.845853>,<-2.586736,-28.615147,164.845853>}
      triangle {<-0.740888,-29.767666,167.371017>,<-2.586736,-28.615147,164.845853>,<-2.852537,-29.433216,167.371017>}
      triangle {<-0.740888,-28.907497,164.845853>,<-0.740888,-27.676472,163.225940>,<-2.206319,-27.444378,163.225939>}
      triangle {<-0.740888,-28.907497,164.845853>,<-2.206319,-27.444378,163.225939>,<-2.586736,-28.615147,164.845853>}
      triangle {<-0.740888,-27.676472,163.225940>,<-0.740888,-26.014263,162.884232>,<-1.692670,-25.863522,162.884232>}
      triangle {<-0.740888,-27.676472,163.225940>,<-1.692670,-25.863522,162.884232>,<-2.206319,-27.444378,163.225939>}
      triangle {<-0.740888,-26.014263,162.884232>,<-0.740888,-26.040005,155.274646>,<-1.700628,-25.888004,155.274646>}
      triangle {<-0.740888,-26.014263,162.884232>,<-1.700628,-25.888004,155.274646>,<-1.692670,-25.863522,162.884232>}
      triangle {<-0.740888,-26.040005,155.274646>,<-0.740888,-27.060673,155.274646>,<-2.016027,-26.858707,155.274646>}
      triangle {<-0.740888,-26.040005,155.274646>,<-2.016027,-26.858707,155.274646>,<-1.700628,-25.888004,155.274646>}
      triangle {<-2.016027,-26.858707,155.274646>,<-2.016027,-26.858707,161.851297>,<-3.166357,-26.272587,161.851297>}
      triangle {<-2.016027,-26.858707,155.274646>,<-3.166357,-26.272587,161.851297>,<-3.166357,-26.272587,155.274646>}
      triangle {<-2.016027,-26.858707,161.851297>,<-2.474546,-28.269886,163.100008>,<-4.038511,-27.473003,163.100008>}
      triangle {<-2.016027,-26.858707,161.851297>,<-4.038511,-27.473003,163.100008>,<-3.166357,-26.272587,161.851297>}
      triangle {<-2.474546,-28.269886,163.100008>,<-2.810400,-29.303524,165.433195>,<-4.677335,-28.352268,165.433195>}
      triangle {<-2.474546,-28.269886,163.100008>,<-4.677335,-28.352268,165.433195>,<-4.038511,-27.473003,163.100008>}
      triangle {<-2.810400,-29.303524,165.433195>,<-3.041105,-30.013569,168.402772>,<-5.116163,-28.956264,168.402772>}
      triangle {<-2.810400,-29.303524,165.433195>,<-5.116163,-28.956264,168.402772>,<-4.677335,-28.352268,165.433195>}
      triangle {<-3.041105,-30.013569,168.402772>,<-3.184194,-30.453953,171.560617>,<-5.388341,-29.330891,171.560617>}
      triangle {<-3.041105,-30.013569,168.402772>,<-5.388341,-29.330891,171.560617>,<-5.116163,-28.956264,168.402772>}
      triangle {<-3.184194,-30.453953,171.560617>,<-3.257200,-30.678638,174.458649>,<-5.527196,-29.522007,174.458649>}
      triangle {<-3.184194,-30.453953,171.560617>,<-5.527196,-29.522007,174.458649>,<-5.388341,-29.330891,171.560617>}
      triangle {<-3.257200,-30.678638,174.458649>,<-3.277639,-30.741535,176.648767>,<-5.566076,-29.575520,176.648767>}
      triangle {<-3.257200,-30.678638,174.458649>,<-5.566076,-29.575520,176.648767>,<-5.527196,-29.522007,174.458649>}
      triangle {<-3.277639,-30.741535,176.648767>,<-3.148778,-30.344944,176.648767>,<-5.320966,-29.238163,176.648767>}
      triangle {<-3.277639,-30.741535,176.648767>,<-5.320966,-29.238163,176.648767>,<-5.566076,-29.575520,176.648767>}
      triangle {<-3.148778,-30.344944,176.648767>,<-3.114919,-30.240749,173.645400>,<-5.256567,-29.149517,173.645417>}
      triangle {<-3.148778,-30.344944,176.648767>,<-5.256567,-29.149517,173.645417>,<-5.320966,-29.238163,176.648767>}
      triangle {<-3.114919,-30.240749,173.645400>,<-3.022390,-29.955959,170.428522>,<-5.080556,-28.907261,170.428522>}
      triangle {<-3.114919,-30.240749,173.645400>,<-5.080556,-28.907261,170.428522>,<-5.256567,-29.149517,173.645417>}
      triangle {<-3.022390,-29.955959,170.428522>,<-2.852537,-29.433216,167.371017>,<-4.757490,-28.462589,167.371017>}
      triangle {<-3.022390,-29.955959,170.428522>,<-4.757490,-28.462589,167.371017>,<-5.080556,-28.907261,170.428522>}
      triangle {<-2.852537,-29.433216,167.371017>,<-2.586736,-28.615147,164.845853>,<-4.251897,-27.766705,164.845853>}
      triangle {<-2.852537,-29.433216,167.371017>,<-4.251897,-27.766705,164.845853>,<-4.757490,-28.462589,167.371017>}
      triangle {<-2.586736,-28.615147,164.845853>,<-2.206319,-27.444378,163.225939>,<-3.528310,-26.770786,163.225939>}
      triangle {<-2.586736,-28.615147,164.845853>,<-3.528310,-26.770786,163.225939>,<-4.251897,-27.766705,164.845853>}
      triangle {<-2.206319,-27.444378,163.225939>,<-1.692670,-25.863522,162.884232>,<-2.551290,-25.426022,162.884233>}
      triangle {<-2.206319,-27.444378,163.225939>,<-2.551290,-25.426022,162.884233>,<-3.528310,-26.770786,163.225939>}
      triangle {<-1.692670,-25.863522,162.884232>,<-1.700628,-25.888004,155.274646>,<-2.566419,-25.446857,155.274646>}
      triangle {<-1.692670,-25.863522,162.884232>,<-2.566419,-25.446857,155.274646>,<-2.551290,-25.426022,162.884233>}
      triangle {<-1.700628,-25.888004,155.274646>,<-2.016027,-26.858707,155.274646>,<-3.166357,-26.272587,155.274646>}
      triangle {<-1.700628,-25.888004,155.274646>,<-3.166357,-26.272587,155.274646>,<-2.566419,-25.446857,155.274646>}
      triangle {<-3.166357,-26.272587,155.274646>,<-3.166357,-26.272587,161.851297>,<-4.079259,-25.359692,161.851296>}
      triangle {<-3.166357,-26.272587,155.274646>,<-4.079259,-25.359692,161.851296>,<-4.079259,-25.359692,155.274646>}
      triangle {<-3.166357,-26.272587,161.851297>,<-4.038511,-27.473003,163.100008>,<-5.279684,-26.231846,163.100008>}
      triangle {<-3.166357,-26.272587,161.851297>,<-5.279684,-26.231846,163.100008>,<-4.079259,-25.359692,161.851296>}
      triangle {<-4.038511,-27.473003,163.100008>,<-4.677335,-28.352268,165.433195>,<-6.158948,-26.870663,165.433195>}
      triangle {<-4.038511,-27.473003,163.100008>,<-6.158948,-26.870663,165.433195>,<-5.279684,-26.231846,163.100008>}
      triangle {<-4.677335,-28.352268,165.433195>,<-5.116163,-28.956264,168.402772>,<-6.762945,-27.309490,168.402772>}
      triangle {<-4.677335,-28.352268,165.433195>,<-6.762945,-27.309490,168.402772>,<-6.158948,-26.870663,165.433195>}
      triangle {<-5.116163,-28.956264,168.402772>,<-5.388341,-29.330891,171.560617>,<-7.137563,-27.581669,171.560601>}
      triangle {<-5.116163,-28.956264,168.402772>,<-7.137563,-27.581669,171.560601>,<-6.762945,-27.309490,168.402772>}
      triangle {<-5.388341,-29.330891,171.560617>,<-5.527196,-29.522007,174.458649>,<-7.328680,-27.720524,174.458649>}
      triangle {<-5.388341,-29.330891,171.560617>,<-7.328680,-27.720524,174.458649>,<-7.137563,-27.581669,171.560601>}
      triangle {<-5.527196,-29.522007,174.458649>,<-5.566076,-29.575520,176.648767>,<-7.382192,-27.759403,176.648766>}
      triangle {<-5.527196,-29.522007,174.458649>,<-7.382192,-27.759403,176.648766>,<-7.328680,-27.720524,174.458649>}
      triangle {<-5.566076,-29.575520,176.648767>,<-5.320966,-29.238163,176.648767>,<-7.044836,-27.514301,176.648766>}
      triangle {<-5.566076,-29.575520,176.648767>,<-7.044836,-27.514301,176.648766>,<-7.382192,-27.759403,176.648766>}
      triangle {<-5.320966,-29.238163,176.648767>,<-5.256567,-29.149517,173.645417>,<-6.956190,-27.449894,173.645400>}
      triangle {<-5.320966,-29.238163,176.648767>,<-6.956190,-27.449894,173.645400>,<-7.044836,-27.514301,176.648766>}
      triangle {<-5.256567,-29.149517,173.645417>,<-5.080556,-28.907261,170.428522>,<-6.713941,-27.273891,170.428505>}
      triangle {<-5.256567,-29.149517,173.645417>,<-6.713941,-27.273891,170.428505>,<-6.956190,-27.449894,173.645400>}
      triangle {<-5.080556,-28.907261,170.428522>,<-4.757490,-28.462589,167.371017>,<-6.269269,-26.950817,167.371017>}
      triangle {<-5.080556,-28.907261,170.428522>,<-6.269269,-26.950817,167.371017>,<-6.713941,-27.273891,170.428505>}
      triangle {<-4.757490,-28.462589,167.371017>,<-4.251897,-27.766705,164.845853>,<-5.573377,-26.445225,164.845853>}
      triangle {<-4.757490,-28.462589,167.371017>,<-5.573377,-26.445225,164.845853>,<-6.269269,-26.950817,167.371017>}
      triangle {<-4.251897,-27.766705,164.845853>,<-3.528310,-26.770786,163.225939>,<-4.577459,-25.721645,163.225939>}
      triangle {<-4.251897,-27.766705,164.845853>,<-4.577459,-25.721645,163.225939>,<-5.573377,-26.445225,164.845853>}
      triangle {<-3.528310,-26.770786,163.225939>,<-2.551290,-25.426022,162.884233>,<-3.232694,-24.744625,162.884233>}
      triangle {<-3.528310,-26.770786,163.225939>,<-3.232694,-24.744625,162.884233>,<-4.577459,-25.721645,163.225939>}
      triangle {<-2.551290,-25.426022,162.884233>,<-2.566419,-25.446857,155.274646>,<-3.253522,-24.759754,155.274646>}
      triangle {<-2.551290,-25.426022,162.884233>,<-3.253522,-24.759754,155.274646>,<-3.232694,-24.744625,162.884233>}
      triangle {<-2.566419,-25.446857,155.274646>,<-3.166357,-26.272587,155.274646>,<-4.079259,-25.359692,155.274646>}
      triangle {<-2.566419,-25.446857,155.274646>,<-4.079259,-25.359692,155.274646>,<-3.253522,-24.759754,155.274646>}
      triangle {<-4.079259,-25.359692,155.274646>,<-4.079259,-25.359692,161.851296>,<-4.665380,-24.209354,161.851296>}
      triangle {<-4.079259,-25.359692,155.274646>,<-4.665380,-24.209354,161.851296>,<-4.665380,-24.209354,155.274646>}
      triangle {<-4.079259,-25.359692,161.851296>,<-5.279684,-26.231846,163.100008>,<-6.076559,-24.667873,163.100009>}
      triangle {<-4.079259,-25.359692,161.851296>,<-6.076559,-24.667873,163.100009>,<-4.665380,-24.209354,161.851296>}
      triangle {<-5.279684,-26.231846,163.100008>,<-6.158948,-26.870663,165.433195>,<-7.110197,-25.003727,165.433195>}
      triangle {<-5.279684,-26.231846,163.100008>,<-7.110197,-25.003727,165.433195>,<-6.076559,-24.667873,163.100009>}
      triangle {<-6.158948,-26.870663,165.433195>,<-6.762945,-27.309490,168.402772>,<-7.820234,-25.234440,168.402773>}
      triangle {<-6.158948,-26.870663,165.433195>,<-7.820234,-25.234440,168.402773>,<-7.110197,-25.003727,165.433195>}
      triangle {<-6.762945,-27.309490,168.402772>,<-7.137563,-27.581669,171.560601>,<-8.260625,-25.377514,171.560617>}
      triangle {<-6.762945,-27.309490,168.402772>,<-8.260625,-25.377514,171.560617>,<-7.820234,-25.234440,168.402773>}
      triangle {<-7.137563,-27.581669,171.560601>,<-7.328680,-27.720524,174.458649>,<-8.485303,-25.450520,174.458659>}
      triangle {<-7.137563,-27.581669,171.560601>,<-8.485303,-25.450520,174.458659>,<-8.260625,-25.377514,171.560617>}
      triangle {<-7.328680,-27.720524,174.458649>,<-7.382192,-27.759403,176.648766>,<-8.548208,-25.470966,176.648766>}
      triangle {<-7.328680,-27.720524,174.458649>,<-8.548208,-25.470966,176.648766>,<-8.485303,-25.450520,174.458659>}
      triangle {<-7.382192,-27.759403,176.648766>,<-7.044836,-27.514301,176.648766>,<-8.151624,-25.342106,176.648766>}
      triangle {<-7.382192,-27.759403,176.648766>,<-8.151624,-25.342106,176.648766>,<-8.548208,-25.470966,176.648766>}
      triangle {<-7.044836,-27.514301,176.648766>,<-6.956190,-27.449894,173.645400>,<-8.047414,-25.308247,173.645400>}
      triangle {<-7.044836,-27.514301,176.648766>,<-8.047414,-25.308247,173.645400>,<-8.151624,-25.342106,176.648766>}
      triangle {<-6.956190,-27.449894,173.645400>,<-6.713941,-27.273891,170.428505>,<-7.762624,-25.215710,170.428522>}
      triangle {<-6.956190,-27.449894,173.645400>,<-7.762624,-25.215710,170.428522>,<-8.047414,-25.308247,173.645400>}
      triangle {<-6.713941,-27.273891,170.428505>,<-6.269269,-26.950817,167.371017>,<-7.239881,-25.045864,167.371029>}
      triangle {<-6.713941,-27.273891,170.428505>,<-7.239881,-25.045864,167.371029>,<-7.762624,-25.215710,170.428522>}
      triangle {<-6.269269,-26.950817,167.371017>,<-5.573377,-26.445225,164.845853>,<-6.421819,-24.780056,164.845853>}
      triangle {<-6.269269,-26.950817,167.371017>,<-6.421819,-24.780056,164.845853>,<-7.239881,-25.045864,167.371029>}
      triangle {<-5.573377,-26.445225,164.845853>,<-4.577459,-25.721645,163.225939>,<-5.251035,-24.399647,163.225940>}
      triangle {<-5.573377,-26.445225,164.845853>,<-5.251035,-24.399647,163.225940>,<-6.421819,-24.780056,164.845853>}
      triangle {<-4.577459,-25.721645,163.225939>,<-3.232694,-24.744625,162.884233>,<-3.670179,-23.885998,162.884232>}
      triangle {<-4.577459,-25.721645,163.225939>,<-3.670179,-23.885998,162.884232>,<-5.251035,-24.399647,163.225940>}
      triangle {<-3.232694,-24.744625,162.884233>,<-3.253522,-24.759754,155.274646>,<-3.694669,-23.893948,155.274646>}
      triangle {<-3.232694,-24.744625,162.884233>,<-3.694669,-23.893948,155.274646>,<-3.670179,-23.885998,162.884232>}
      triangle {<-3.253522,-24.759754,155.274646>,<-4.079259,-25.359692,155.274646>,<-4.665380,-24.209354,155.274646>}
      triangle {<-3.253522,-24.759754,155.274646>,<-4.665380,-24.209354,155.274646>,<-3.694669,-23.893948,155.274646>}
      triangle {<-4.665380,-24.209354,155.274646>,<-4.665380,-24.209354,161.851296>,<-4.867345,-22.934216,161.851264>}
      triangle {<-4.665380,-24.209354,155.274646>,<-4.867345,-22.934216,161.851264>,<-4.867345,-22.934216,155.274646>}
      triangle {<-4.665380,-24.209354,161.851296>,<-6.076559,-24.667873,163.100009>,<-6.351148,-22.934216,163.100008>}
      triangle {<-4.665380,-24.209354,161.851296>,<-6.351148,-22.934216,163.100008>,<-4.867345,-22.934216,161.851264>}
      triangle {<-6.076559,-24.667873,163.100009>,<-7.110197,-25.003727,165.433195>,<-7.437971,-22.934216,165.433195>}
      triangle {<-6.076559,-24.667873,163.100009>,<-7.437971,-22.934216,165.433195>,<-6.351148,-22.934216,163.100008>}
      triangle {<-7.110197,-25.003727,165.433195>,<-7.820234,-25.234440,168.402773>,<-8.184560,-22.934216,168.402772>}
      triangle {<-7.110197,-25.003727,165.433195>,<-8.184560,-22.934216,168.402772>,<-7.437971,-22.934216,165.433195>}
      triangle {<-7.820234,-25.234440,168.402773>,<-8.260625,-25.377514,171.560617>,<-8.647611,-22.934216,171.560601>}
      triangle {<-7.820234,-25.234440,168.402773>,<-8.647611,-22.934216,171.560601>,<-8.184560,-22.934216,168.402772>}
      triangle {<-8.260625,-25.377514,171.560617>,<-8.485303,-25.450520,174.458659>,<-8.883855,-22.934216,174.458659>}
      triangle {<-8.260625,-25.377514,171.560617>,<-8.883855,-22.934216,174.458659>,<-8.647611,-22.934216,171.560601>}
      triangle {<-8.485303,-25.450520,174.458659>,<-8.548208,-25.470966,176.648766>,<-8.949995,-22.934216,176.648767>}
      triangle {<-8.485303,-25.450520,174.458659>,<-8.949995,-22.934216,176.648767>,<-8.883855,-22.934216,174.458659>}
      triangle {<-8.548208,-25.470966,176.648766>,<-8.151624,-25.342106,176.648766>,<-8.532995,-22.934216,176.648767>}
      triangle {<-8.548208,-25.470966,176.648766>,<-8.532995,-22.934216,176.648767>,<-8.949995,-22.934216,176.648767>}
      triangle {<-8.151624,-25.342106,176.648766>,<-8.047414,-25.308247,173.645400>,<-8.423421,-22.934216,173.645401>}
      triangle {<-8.151624,-25.342106,176.648766>,<-8.423421,-22.934216,173.645401>,<-8.532995,-22.934216,176.648767>}
      triangle {<-8.047414,-25.308247,173.645400>,<-7.762624,-25.215710,170.428522>,<-8.123983,-22.934216,170.428505>}
      triangle {<-8.047414,-25.308247,173.645400>,<-8.123983,-22.934216,170.428505>,<-8.423421,-22.934216,173.645401>}
      triangle {<-7.762624,-25.215710,170.428522>,<-7.239881,-25.045864,167.371029>,<-7.574346,-22.934216,167.371029>}
      triangle {<-7.762624,-25.215710,170.428522>,<-7.574346,-22.934216,167.371029>,<-8.123983,-22.934216,170.428505>}
      triangle {<-7.239881,-25.045864,167.371029>,<-6.421819,-24.780056,164.845853>,<-6.714178,-22.934216,164.845853>}
      triangle {<-7.239881,-25.045864,167.371029>,<-6.714178,-22.934216,164.845853>,<-7.574346,-22.934216,167.371029>}
      triangle {<-6.421819,-24.780056,164.845853>,<-5.251035,-24.399647,163.225940>,<-5.483152,-22.934216,163.225939>}
      triangle {<-6.421819,-24.780056,164.845853>,<-5.483152,-22.934216,163.225939>,<-6.714178,-22.934216,164.845853>}
      triangle {<-5.251035,-24.399647,163.225940>,<-3.670179,-23.885998,162.884232>,<-3.820936,-22.934216,162.884232>}
      triangle {<-5.251035,-24.399647,163.225940>,<-3.820936,-22.934216,162.884232>,<-5.483152,-22.934216,163.225939>}
      triangle {<-3.670179,-23.885998,162.884232>,<-3.694669,-23.893948,155.274646>,<-3.846685,-22.934216,155.274646>}
      triangle {<-3.670179,-23.885998,162.884232>,<-3.846685,-22.934216,155.274646>,<-3.820936,-22.934216,162.884232>}
      triangle {<-3.694669,-23.893948,155.274646>,<-4.665380,-24.209354,155.274646>,<-4.867345,-22.934216,155.274646>}
      triangle {<-3.694669,-23.893948,155.274646>,<-4.867345,-22.934216,155.274646>,<-3.846685,-22.934216,155.274646>}
      triangle {<-4.867345,-22.934216,155.274646>,<-4.867345,-22.934216,161.851264>,<-4.665380,-21.659061,161.851297>}
      triangle {<-4.867345,-22.934216,155.274646>,<-4.665380,-21.659061,161.851297>,<-4.665380,-21.659061,155.274646>}
      triangle {<-4.867345,-22.934216,161.851264>,<-6.351148,-22.934216,163.100008>,<-6.076559,-21.200542,163.100009>}
      triangle {<-4.867345,-22.934216,161.851264>,<-6.076559,-21.200542,163.100009>,<-4.665380,-21.659061,161.851297>}
      triangle {<-6.351148,-22.934216,163.100008>,<-7.437971,-22.934216,165.433195>,<-7.110197,-20.864697,165.433196>}
      triangle {<-6.351148,-22.934216,163.100008>,<-7.110197,-20.864697,165.433196>,<-6.076559,-21.200542,163.100009>}
      triangle {<-7.437971,-22.934216,165.433195>,<-8.184560,-22.934216,168.402772>,<-7.820234,-20.633991,168.402772>}
      triangle {<-7.437971,-22.934216,165.433195>,<-7.820234,-20.633991,168.402772>,<-7.110197,-20.864697,165.433196>}
      triangle {<-8.184560,-22.934216,168.402772>,<-8.647611,-22.934216,171.560601>,<-8.260625,-20.490902,171.560601>}
      triangle {<-8.184560,-22.934216,168.402772>,<-8.260625,-20.490902,171.560601>,<-7.820234,-20.633991,168.402772>}
      triangle {<-8.647611,-22.934216,171.560601>,<-8.883855,-22.934216,174.458659>,<-8.485303,-20.417896,174.458659>}
      triangle {<-8.647611,-22.934216,171.560601>,<-8.485303,-20.417896,174.458659>,<-8.260625,-20.490902,171.560601>}
      triangle {<-8.883855,-22.934216,174.458659>,<-8.949995,-22.934216,176.648767>,<-8.548208,-20.397457,176.648767>}
      triangle {<-8.883855,-22.934216,174.458659>,<-8.548208,-20.397457,176.648767>,<-8.485303,-20.417896,174.458659>}
      triangle {<-8.949995,-22.934216,176.648767>,<-8.532995,-22.934216,176.648767>,<-8.151624,-20.526318,176.648767>}
      triangle {<-8.949995,-22.934216,176.648767>,<-8.151624,-20.526318,176.648767>,<-8.548208,-20.397457,176.648767>}
      triangle {<-8.532995,-22.934216,176.648767>,<-8.423421,-22.934216,173.645401>,<-8.047414,-20.560177,173.645400>}
      triangle {<-8.532995,-22.934216,176.648767>,<-8.047414,-20.560177,173.645400>,<-8.151624,-20.526318,176.648767>}
      triangle {<-8.423421,-22.934216,173.645401>,<-8.123983,-22.934216,170.428505>,<-7.762624,-20.652706,170.428505>}
      triangle {<-8.423421,-22.934216,173.645401>,<-7.762624,-20.652706,170.428505>,<-8.047414,-20.560177,173.645400>}
      triangle {<-8.123983,-22.934216,170.428505>,<-7.574346,-22.934216,167.371029>,<-7.239881,-20.822552,167.371030>}
      triangle {<-8.123983,-22.934216,170.428505>,<-7.239881,-20.822552,167.371030>,<-7.762624,-20.652706,170.428505>}
      triangle {<-7.574346,-22.934216,167.371029>,<-6.714178,-22.934216,164.845853>,<-6.421819,-21.088360,164.845854>}
      triangle {<-7.574346,-22.934216,167.371029>,<-6.421819,-21.088360,164.845854>,<-7.239881,-20.822552,167.371030>}
      triangle {<-6.714178,-22.934216,164.845853>,<-5.483152,-22.934216,163.225939>,<-5.251035,-21.468777,163.225940>}
      triangle {<-6.714178,-22.934216,164.845853>,<-5.251035,-21.468777,163.225940>,<-6.421819,-21.088360,164.845854>}
      triangle {<-5.483152,-22.934216,163.225939>,<-3.820936,-22.934216,162.884232>,<-3.670179,-21.982426,162.884233>}
      triangle {<-5.483152,-22.934216,163.225939>,<-3.670179,-21.982426,162.884233>,<-5.251035,-21.468777,163.225940>}
      triangle {<-3.820936,-22.934216,162.884232>,<-3.846685,-22.934216,155.274646>,<-3.694669,-21.974468,155.274646>}
      triangle {<-3.820936,-22.934216,162.884232>,<-3.694669,-21.974468,155.274646>,<-3.670179,-21.982426,162.884233>}
      triangle {<-3.846685,-22.934216,155.274646>,<-4.867345,-22.934216,155.274646>,<-4.665380,-21.659061,155.274646>}
      triangle {<-3.846685,-22.934216,155.274646>,<-4.665380,-21.659061,155.274646>,<-3.694669,-21.974468,155.274646>}
      triangle {<-4.665380,-21.659061,155.274646>,<-4.665380,-21.659061,161.851297>,<-4.079259,-20.508739,161.851297>}
      triangle {<-4.665380,-21.659061,155.274646>,<-4.079259,-20.508739,161.851297>,<-4.079259,-20.508739,155.274646>}
      triangle {<-4.665380,-21.659061,161.851297>,<-6.076559,-21.200542,163.100009>,<-5.279676,-19.636585,163.100009>}
      triangle {<-4.665380,-21.659061,161.851297>,<-5.279676,-19.636585,163.100009>,<-4.079259,-20.508739,161.851297>}
      triangle {<-6.076559,-21.200542,163.100009>,<-7.110197,-20.864697,165.433196>,<-6.158948,-18.997761,165.433196>}
      triangle {<-6.076559,-21.200542,163.100009>,<-6.158948,-18.997761,165.433196>,<-5.279676,-19.636585,163.100009>}
      triangle {<-7.110197,-20.864697,165.433196>,<-7.820234,-20.633991,168.402772>,<-6.762945,-18.558933,168.402773>}
      triangle {<-7.110197,-20.864697,165.433196>,<-6.762945,-18.558933,168.402773>,<-6.158948,-18.997761,165.433196>}
      triangle {<-7.820234,-20.633991,168.402772>,<-8.260625,-20.490902,171.560601>,<-7.137556,-18.286755,171.560601>}
      triangle {<-7.820234,-20.633991,168.402772>,<-7.137556,-18.286755,171.560601>,<-6.762945,-18.558933,168.402773>}
      triangle {<-8.260625,-20.490902,171.560601>,<-8.485303,-20.417896,174.458659>,<-7.328680,-18.147900,174.458660>}
      triangle {<-8.260625,-20.490902,171.560601>,<-7.328680,-18.147900,174.458660>,<-7.137556,-18.286755,171.560601>}
      triangle {<-8.485303,-20.417896,174.458659>,<-8.548208,-20.397457,176.648767>,<-7.382192,-18.109013,176.648767>}
      triangle {<-8.485303,-20.417896,174.458659>,<-7.382192,-18.109013,176.648767>,<-7.328680,-18.147900,174.458660>}
      triangle {<-8.548208,-20.397457,176.648767>,<-8.151624,-20.526318,176.648767>,<-7.044836,-18.354122,176.648767>}
      triangle {<-8.548208,-20.397457,176.648767>,<-7.044836,-18.354122,176.648767>,<-7.382192,-18.109013,176.648767>}
      triangle {<-8.151624,-20.526318,176.648767>,<-8.047414,-20.560177,173.645400>,<-6.956190,-18.418522,173.645417>}
      triangle {<-8.151624,-20.526318,176.648767>,<-6.956190,-18.418522,173.645417>,<-7.044836,-18.354122,176.648767>}
      triangle {<-8.047414,-20.560177,173.645400>,<-7.762624,-20.652706,170.428505>,<-6.713941,-18.594532,170.428522>}
      triangle {<-8.047414,-20.560177,173.645400>,<-6.713941,-18.594532,170.428522>,<-6.956190,-18.418522,173.645417>}
      triangle {<-7.762624,-20.652706,170.428505>,<-7.239881,-20.822552,167.371030>,<-6.269269,-18.917599,167.371030>}
      triangle {<-7.762624,-20.652706,170.428505>,<-6.269269,-18.917599,167.371030>,<-6.713941,-18.594532,170.428522>}
      triangle {<-7.239881,-20.822552,167.371030>,<-6.421819,-21.088360,164.845854>,<-5.573377,-19.423199,164.845854>}
      triangle {<-7.239881,-20.822552,167.371030>,<-5.573377,-19.423199,164.845854>,<-6.269269,-18.917599,167.371030>}
      triangle {<-6.421819,-21.088360,164.845854>,<-5.251035,-21.468777,163.225940>,<-4.577459,-20.146786,163.225940>}
      triangle {<-6.421819,-21.088360,164.845854>,<-4.577459,-20.146786,163.225940>,<-5.573377,-19.423199,164.845854>}
      triangle {<-5.251035,-21.468777,163.225940>,<-3.670179,-21.982426,162.884233>,<-3.232694,-21.123798,162.884232>}
      triangle {<-5.251035,-21.468777,163.225940>,<-3.232694,-21.123798,162.884232>,<-4.577459,-20.146786,163.225940>}
      triangle {<-3.670179,-21.982426,162.884233>,<-3.694669,-21.974468,155.274646>,<-3.253530,-21.108662,155.274646>}
      triangle {<-3.670179,-21.982426,162.884233>,<-3.253530,-21.108662,155.274646>,<-3.232694,-21.123798,162.884232>}
      triangle {<-3.694669,-21.974468,155.274646>,<-4.665380,-21.659061,155.274646>,<-4.079259,-20.508739,155.274646>}
      triangle {<-3.694669,-21.974468,155.274646>,<-4.079259,-20.508739,155.274646>,<-3.253530,-21.108662,155.274646>}
      triangle {<-4.079259,-20.508739,155.274646>,<-4.079259,-20.508739,161.851297>,<-3.166357,-19.595837,161.851297>}
      triangle {<-4.079259,-20.508739,155.274646>,<-3.166357,-19.595837,161.851297>,<-3.166357,-19.595837,155.274646>}
      triangle {<-4.079259,-20.508739,161.851297>,<-5.279676,-19.636585,163.100009>,<-4.038511,-18.395420,163.100009>}
      triangle {<-4.079259,-20.508739,161.851297>,<-4.038511,-18.395420,163.100009>,<-3.166357,-19.595837,161.851297>}
      triangle {<-5.279676,-19.636585,163.100009>,<-6.158948,-18.997761,165.433196>,<-4.677335,-17.516155,165.433196>}
      triangle {<-5.279676,-19.636585,163.100009>,<-4.677335,-17.516155,165.433196>,<-4.038511,-18.395420,163.100009>}
      triangle {<-6.158948,-18.997761,165.433196>,<-6.762945,-18.558933,168.402773>,<-5.116163,-16.912151,168.402773>}
      triangle {<-6.158948,-18.997761,165.433196>,<-5.116163,-16.912151,168.402773>,<-4.677335,-17.516155,165.433196>}
      triangle {<-6.762945,-18.558933,168.402773>,<-7.137556,-18.286755,171.560601>,<-5.388341,-16.537533,171.560601>}
      triangle {<-6.762945,-18.558933,168.402773>,<-5.388341,-16.537533,171.560601>,<-5.116163,-16.912151,168.402773>}
      triangle {<-7.137556,-18.286755,171.560601>,<-7.328680,-18.147900,174.458660>,<-5.527189,-16.346416,174.458659>}
      triangle {<-7.137556,-18.286755,171.560601>,<-5.527189,-16.346416,174.458659>,<-5.388341,-16.537533,171.560601>}
      triangle {<-7.328680,-18.147900,174.458660>,<-7.382192,-18.109013,176.648767>,<-5.566076,-16.292904,176.648778>}
      triangle {<-7.328680,-18.147900,174.458660>,<-5.566076,-16.292904,176.648778>,<-5.527189,-16.346416,174.458659>}
      triangle {<-7.382192,-18.109013,176.648767>,<-7.044836,-18.354122,176.648767>,<-5.320966,-16.630268,176.648779>}
      triangle {<-7.382192,-18.109013,176.648767>,<-5.320966,-16.630268,176.648779>,<-5.566076,-16.292904,176.648778>}
      triangle {<-7.044836,-18.354122,176.648767>,<-6.956190,-18.418522,173.645417>,<-5.256567,-16.718906,173.645401>}
      triangle {<-7.044836,-18.354122,176.648767>,<-5.256567,-16.718906,173.645401>,<-5.320966,-16.630268,176.648779>}
      triangle {<-6.956190,-18.418522,173.645417>,<-6.713941,-18.594532,170.428522>,<-5.080556,-16.961163,170.428505>}
      triangle {<-6.956190,-18.418522,173.645417>,<-5.080556,-16.961163,170.428505>,<-5.256567,-16.718906,173.645401>}
      triangle {<-6.713941,-18.594532,170.428522>,<-6.269269,-18.917599,167.371030>,<-4.757490,-17.405834,167.371030>}
      triangle {<-6.713941,-18.594532,170.428522>,<-4.757490,-17.405834,167.371030>,<-5.080556,-16.961163,170.428505>}
      triangle {<-6.269269,-18.917599,167.371030>,<-5.573377,-19.423199,164.845854>,<-4.251897,-18.101719,164.845854>}
      triangle {<-6.269269,-18.917599,167.371030>,<-4.251897,-18.101719,164.845854>,<-4.757490,-17.405834,167.371030>}
      triangle {<-5.573377,-19.423199,164.845854>,<-4.577459,-20.146786,163.225940>,<-3.528318,-19.097645,163.225940>}
      triangle {<-5.573377,-19.423199,164.845854>,<-3.528318,-19.097645,163.225940>,<-4.251897,-18.101719,164.845854>}
      triangle {<-4.577459,-20.146786,163.225940>,<-3.232694,-21.123798,162.884232>,<-2.551290,-20.442402,162.884232>}
      triangle {<-4.577459,-20.146786,163.225940>,<-2.551290,-20.442402,162.884232>,<-3.528318,-19.097645,163.225940>}
      triangle {<-3.232694,-21.123798,162.884232>,<-3.253530,-21.108662,155.274646>,<-2.566419,-20.421566,155.274646>}
      triangle {<-3.232694,-21.123798,162.884232>,<-2.566419,-20.421566,155.274646>,<-2.551290,-20.442402,162.884232>}
      triangle {<-3.253530,-21.108662,155.274646>,<-4.079259,-20.508739,155.274646>,<-3.166357,-19.595837,155.274646>}
      triangle {<-3.253530,-21.108662,155.274646>,<-3.166357,-19.595837,155.274646>,<-2.566419,-20.421566,155.274646>}
      triangle {<-3.166357,-19.595837,155.274646>,<-3.166357,-19.595837,161.851297>,<-2.016027,-19.009708,161.851296>}
      triangle {<-3.166357,-19.595837,155.274646>,<-2.016027,-19.009708,161.851296>,<-2.016027,-19.009708,155.274646>}
      triangle {<-3.166357,-19.595837,161.851297>,<-4.038511,-18.395420,163.100009>,<-2.474546,-17.598537,163.100009>}
      triangle {<-3.166357,-19.595837,161.851297>,<-2.474546,-17.598537,163.100009>,<-2.016027,-19.009708,161.851296>}
      triangle {<-4.038511,-18.395420,163.100009>,<-4.677335,-17.516155,165.433196>,<-2.810400,-16.564899,165.433196>}
      triangle {<-4.038511,-18.395420,163.100009>,<-2.810400,-16.564899,165.433196>,<-2.474546,-17.598537,163.100009>}
      triangle {<-4.677335,-17.516155,165.433196>,<-5.116163,-16.912151,168.402773>,<-3.041105,-15.854855,168.402773>}
      triangle {<-4.677335,-17.516155,165.433196>,<-3.041105,-15.854855,168.402773>,<-2.810400,-16.564899,165.433196>}
      triangle {<-5.116163,-16.912151,168.402773>,<-5.388341,-16.537533,171.560601>,<-3.184194,-15.414471,171.560601>}
      triangle {<-5.116163,-16.912151,168.402773>,<-3.184194,-15.414471,171.560601>,<-3.041105,-15.854855,168.402773>}
      triangle {<-5.388341,-16.537533,171.560601>,<-5.527189,-16.346416,174.458659>,<-3.257200,-15.189793,174.458659>}
      triangle {<-5.388341,-16.537533,171.560601>,<-3.257200,-15.189793,174.458659>,<-3.184194,-15.414471,171.560601>}
      triangle {<-5.527189,-16.346416,174.458659>,<-5.566076,-16.292904,176.648778>,<-3.277631,-15.126881,176.648778>}
      triangle {<-5.527189,-16.346416,174.458659>,<-3.277631,-15.126881,176.648778>,<-3.257200,-15.189793,174.458659>}
      triangle {<-5.566076,-16.292904,176.648778>,<-5.320966,-16.630268,176.648779>,<-3.148778,-15.523472,176.648778>}
      triangle {<-5.566076,-16.292904,176.648778>,<-3.148778,-15.523472,176.648778>,<-3.277631,-15.126881,176.648778>}
      triangle {<-5.320966,-16.630268,176.648779>,<-5.256567,-16.718906,173.645401>,<-3.114919,-15.627682,173.645400>}
      triangle {<-5.320966,-16.630268,176.648779>,<-3.114919,-15.627682,173.645400>,<-3.148778,-15.523472,176.648778>}
      triangle {<-5.256567,-16.718906,173.645401>,<-5.080556,-16.961163,170.428505>,<-3.022382,-15.912464,170.428505>}
      triangle {<-5.256567,-16.718906,173.645401>,<-3.022382,-15.912464,170.428505>,<-3.114919,-15.627682,173.645400>}
      triangle {<-5.080556,-16.961163,170.428505>,<-4.757490,-17.405834,167.371030>,<-2.852537,-16.435200,167.371030>}
      triangle {<-5.080556,-16.961163,170.428505>,<-2.852537,-16.435200,167.371030>,<-3.022382,-15.912464,170.428505>}
      triangle {<-4.757490,-17.405834,167.371030>,<-4.251897,-18.101719,164.845854>,<-2.586736,-17.253277,164.845854>}
      triangle {<-4.757490,-17.405834,167.371030>,<-2.586736,-17.253277,164.845854>,<-2.852537,-16.435200,167.371030>}
      triangle {<-4.251897,-18.101719,164.845854>,<-3.528318,-19.097645,163.225940>,<-2.206319,-18.424046,163.225940>}
      triangle {<-4.251897,-18.101719,164.845854>,<-2.206319,-18.424046,163.225940>,<-2.586736,-17.253277,164.845854>}
      triangle {<-3.528318,-19.097645,163.225940>,<-2.551290,-20.442402,162.884232>,<-1.692670,-20.004910,162.884233>}
      triangle {<-3.528318,-19.097645,163.225940>,<-1.692670,-20.004910,162.884233>,<-2.206319,-18.424046,163.225940>}
      triangle {<-2.551290,-20.442402,162.884232>,<-2.566419,-20.421566,155.274646>,<-1.700628,-19.980419,155.274646>}
      triangle {<-2.551290,-20.442402,162.884232>,<-1.700628,-19.980419,155.274646>,<-1.692670,-20.004910,162.884233>}
      triangle {<-2.566419,-20.421566,155.274646>,<-3.166357,-19.595837,155.274646>,<-2.016027,-19.009708,155.274646>}
      triangle {<-2.566419,-20.421566,155.274646>,<-2.016027,-19.009708,155.274646>,<-1.700628,-19.980419,155.274646>}
      triangle {<-2.016027,-19.009708,155.274646>,<-2.016027,-19.009708,161.851296>,<-0.740888,-18.807751,161.851296>}
      triangle {<-2.016027,-19.009708,155.274646>,<-0.740888,-18.807751,161.851296>,<-0.740888,-18.807751,155.274646>}
      triangle {<-2.016027,-19.009708,161.851296>,<-2.474546,-17.598537,163.100009>,<-0.740888,-17.323956,163.100009>}
      triangle {<-2.016027,-19.009708,161.851296>,<-0.740888,-17.323956,163.100009>,<-0.740888,-18.807751,161.851296>}
      triangle {<-2.474546,-17.598537,163.100009>,<-2.810400,-16.564899,165.433196>,<-0.740888,-16.237125,165.433196>}
      triangle {<-2.474546,-17.598537,163.100009>,<-0.740888,-16.237125,165.433196>,<-0.740888,-17.323956,163.100009>}
      triangle {<-2.810400,-16.564899,165.433196>,<-3.041105,-15.854855,168.402773>,<-0.740888,-15.490543,168.402773>}
      triangle {<-2.810400,-16.564899,165.433196>,<-0.740888,-15.490543,168.402773>,<-0.740888,-16.237125,165.433196>}
      triangle {<-3.041105,-15.854855,168.402773>,<-3.184194,-15.414471,171.560601>,<-0.740888,-15.027485,171.560617>}
      triangle {<-3.041105,-15.854855,168.402773>,<-0.740888,-15.027485,171.560617>,<-0.740888,-15.490543,168.402773>}
      triangle {<-3.184194,-15.414471,171.560601>,<-3.257200,-15.189793,174.458659>,<-0.740888,-14.791248,174.458659>}
      triangle {<-3.184194,-15.414471,171.560601>,<-0.740888,-14.791248,174.458659>,<-0.740888,-15.027485,171.560617>}
      triangle {<-3.257200,-15.189793,174.458659>,<-3.277631,-15.126881,176.648778>,<-0.740888,-14.725109,176.648778>}
      triangle {<-3.257200,-15.189793,174.458659>,<-0.740888,-14.725109,176.648778>,<-0.740888,-14.791248,174.458659>}
      triangle {<-3.277631,-15.126881,176.648778>,<-3.148778,-15.523472,176.648778>,<-0.740888,-15.142109,176.648778>}
      triangle {<-3.277631,-15.126881,176.648778>,<-0.740888,-15.142109,176.648778>,<-0.740888,-14.725109,176.648778>}
      triangle {<-3.148778,-15.523472,176.648778>,<-3.114919,-15.627682,173.645400>,<-0.740888,-15.251667,173.645400>}
      triangle {<-3.148778,-15.523472,176.648778>,<-0.740888,-15.251667,173.645400>,<-0.740888,-15.142109,176.648778>}
      triangle {<-3.114919,-15.627682,173.645400>,<-3.022382,-15.912464,170.428505>,<-0.740888,-15.551113,170.428505>}
      triangle {<-3.114919,-15.627682,173.645400>,<-0.740888,-15.551113,170.428505>,<-0.740888,-15.251667,173.645400>}
      triangle {<-3.022382,-15.912464,170.428505>,<-2.852537,-16.435200,167.371030>,<-0.740888,-16.100758,167.371030>}
      triangle {<-3.022382,-15.912464,170.428505>,<-0.740888,-16.100758,167.371030>,<-0.740888,-15.551113,170.428505>}
      triangle {<-2.852537,-16.435200,167.371030>,<-2.586736,-17.253277,164.845854>,<-0.740888,-16.960926,164.845854>}
      triangle {<-2.852537,-16.435200,167.371030>,<-0.740888,-16.960926,164.845854>,<-0.740888,-16.100758,167.371030>}
      triangle {<-2.586736,-17.253277,164.845854>,<-2.206319,-18.424046,163.225940>,<-0.740888,-18.191959,163.225940>}
      triangle {<-2.586736,-17.253277,164.845854>,<-0.740888,-18.191959,163.225940>,<-0.740888,-16.960926,164.845854>}
      triangle {<-2.206319,-18.424046,163.225940>,<-1.692670,-20.004910,162.884233>,<-0.740888,-19.854160,162.884233>}
      triangle {<-2.206319,-18.424046,163.225940>,<-0.740888,-19.854160,162.884233>,<-0.740888,-18.191959,163.225940>}
      triangle {<-1.692670,-20.004910,162.884233>,<-1.700628,-19.980419,155.274646>,<-0.740888,-19.828411,155.274646>}
      triangle {<-1.692670,-20.004910,162.884233>,<-0.740888,-19.828411,155.274646>,<-0.740888,-19.854160,162.884233>}
      triangle {<-1.700628,-19.980419,155.274646>,<-2.016027,-19.009708,155.274646>,<-0.740888,-18.807751,155.274646>}
      triangle {<-1.700628,-19.980419,155.274646>,<-0.740888,-18.807751,155.274646>,<-0.740888,-19.828411,155.274646>}
      triangle {<-0.740888,-18.807751,155.274646>,<-0.740888,-18.807751,161.851296>,<0.534266,-19.009708,161.851296>}
      triangle {<-0.740888,-18.807751,155.274646>,<0.534266,-19.009708,161.851296>,<0.534266,-19.009708,155.274646>}
      triangle {<-0.740888,-18.807751,161.851296>,<-0.740888,-17.323956,163.100009>,<0.992785,-17.598537,163.100009>}
      triangle {<-0.740888,-18.807751,161.851296>,<0.992785,-17.598537,163.100009>,<0.534266,-19.009708,161.851296>}
      triangle {<-0.740888,-17.323956,163.100009>,<-0.740888,-16.237125,165.433196>,<1.328631,-16.564899,165.433196>}
      triangle {<-0.740888,-17.323956,163.100009>,<1.328631,-16.564899,165.433196>,<0.992785,-17.598537,163.100009>}
      triangle {<-0.740888,-16.237125,165.433196>,<-0.740888,-15.490543,168.402773>,<1.559336,-15.854855,168.402773>}
      triangle {<-0.740888,-16.237125,165.433196>,<1.559336,-15.854855,168.402773>,<1.328631,-16.564899,165.433196>}
      triangle {<-0.740888,-15.490543,168.402773>,<-0.740888,-15.027485,171.560617>,<1.702433,-15.414471,171.560601>}
      triangle {<-0.740888,-15.490543,168.402773>,<1.702433,-15.414471,171.560601>,<1.559336,-15.854855,168.402773>}
      triangle {<-0.740888,-15.027485,171.560617>,<-0.740888,-14.791248,174.458659>,<1.775439,-15.189793,174.458659>}
      triangle {<-0.740888,-15.027485,171.560617>,<1.775439,-15.189793,174.458659>,<1.702433,-15.414471,171.560601>}
      triangle {<-0.740888,-14.791248,174.458659>,<-0.740888,-14.725109,176.648778>,<1.795878,-15.126881,176.648778>}
      triangle {<-0.740888,-14.791248,174.458659>,<1.795878,-15.126881,176.648778>,<1.775439,-15.189793,174.458659>}
      triangle {<-0.740888,-14.725109,176.648778>,<-0.740888,-15.142109,176.648778>,<1.667010,-15.523472,176.648778>}
      triangle {<-0.740888,-14.725109,176.648778>,<1.667010,-15.523472,176.648778>,<1.795878,-15.126881,176.648778>}
      triangle {<-0.740888,-15.142109,176.648778>,<-0.740888,-15.251667,173.645400>,<1.633151,-15.627682,173.645400>}
      triangle {<-0.740888,-15.142109,176.648778>,<1.633151,-15.627682,173.645400>,<1.667010,-15.523472,176.648778>}
      triangle {<-0.740888,-15.251667,173.645400>,<-0.740888,-15.551113,170.428505>,<1.540629,-15.912464,170.428505>}
      triangle {<-0.740888,-15.251667,173.645400>,<1.540629,-15.912464,170.428505>,<1.633151,-15.627682,173.645400>}
      triangle {<-0.740888,-15.551113,170.428505>,<-0.740888,-16.100758,167.371030>,<1.370776,-16.435200,167.371030>}
      triangle {<-0.740888,-15.551113,170.428505>,<1.370776,-16.435200,167.371030>,<1.540629,-15.912464,170.428505>}
      triangle {<-0.740888,-16.100758,167.371030>,<-0.740888,-16.960926,164.845854>,<1.104968,-17.253277,164.845854>}
      triangle {<-0.740888,-16.100758,167.371030>,<1.104968,-17.253277,164.845854>,<1.370776,-16.435200,167.371030>}
      triangle {<-0.740888,-16.960926,164.845854>,<-0.740888,-18.191959,163.225940>,<0.724558,-18.424046,163.225940>}
      triangle {<-0.740888,-16.960926,164.845854>,<0.724558,-18.424046,163.225940>,<1.104968,-17.253277,164.845854>}
      triangle {<-0.740888,-18.191959,163.225940>,<-0.740888,-19.854160,162.884233>,<0.210909,-20.004910,162.884233>}
      triangle {<-0.740888,-18.191959,163.225940>,<0.210909,-20.004910,162.884233>,<0.724558,-18.424046,163.225940>}
      triangle {<-0.740888,-19.854160,162.884233>,<-0.740888,-19.828411,155.274646>,<0.218867,-19.980412,155.274646>}
      triangle {<-0.740888,-19.854160,162.884233>,<0.218867,-19.980412,155.274646>,<0.210909,-20.004910,162.884233>}
      triangle {<-0.740888,-19.828411,155.274646>,<-0.740888,-18.807751,155.274646>,<0.534266,-19.009708,155.274646>}
      triangle {<-0.740888,-19.828411,155.274646>,<0.534266,-19.009708,155.274646>,<0.218867,-19.980412,155.274646>}
      triangle {<0.534266,-19.009708,155.274646>,<0.534266,-19.009708,161.851296>,<1.684588,-19.595837,161.851297>}
      triangle {<0.534266,-19.009708,155.274646>,<1.684588,-19.595837,161.851297>,<1.684588,-19.595829,155.274646>}
      triangle {<0.534266,-19.009708,161.851296>,<0.992785,-17.598537,163.100009>,<2.556742,-18.395420,163.100009>}
      triangle {<0.534266,-19.009708,161.851296>,<2.556742,-18.395420,163.100009>,<1.684588,-19.595837,161.851297>}
      triangle {<0.992785,-17.598537,163.100009>,<1.328631,-16.564899,165.433196>,<3.195567,-17.516163,165.433196>}
      triangle {<0.992785,-17.598537,163.100009>,<3.195567,-17.516163,165.433196>,<2.556742,-18.395420,163.100009>}
      triangle {<1.328631,-16.564899,165.433196>,<1.559336,-15.854855,168.402773>,<3.634402,-16.912159,168.402773>}
      triangle {<1.328631,-16.564899,165.433196>,<3.634402,-16.912159,168.402773>,<3.195567,-17.516163,165.433196>}
      triangle {<1.559336,-15.854855,168.402773>,<1.702433,-15.414471,171.560601>,<3.906573,-16.537533,171.560601>}
      triangle {<1.559336,-15.854855,168.402773>,<3.906573,-16.537533,171.560601>,<3.634402,-16.912159,168.402773>}
      triangle {<1.702433,-15.414471,171.560601>,<1.775439,-15.189793,174.458659>,<4.045435,-16.346416,174.458659>}
      triangle {<1.702433,-15.414471,171.560601>,<4.045435,-16.346416,174.458659>,<3.906573,-16.537533,171.560601>}
      triangle {<1.775439,-15.189793,174.458659>,<1.795878,-15.126881,176.648778>,<4.084307,-16.292904,176.648778>}
      triangle {<1.775439,-15.189793,174.458659>,<4.084307,-16.292904,176.648778>,<4.045435,-16.346416,174.458659>}
      triangle {<1.795878,-15.126881,176.648778>,<1.667010,-15.523472,176.648778>,<3.839198,-16.630268,176.648779>}
      triangle {<1.795878,-15.126881,176.648778>,<3.839198,-16.630268,176.648779>,<4.084307,-16.292904,176.648778>}
      triangle {<1.667010,-15.523472,176.648778>,<1.633151,-15.627682,173.645400>,<3.774798,-16.718914,173.645401>}
      triangle {<1.667010,-15.523472,176.648778>,<3.774798,-16.718914,173.645401>,<3.839198,-16.630268,176.648779>}
      triangle {<1.633151,-15.627682,173.645400>,<1.540629,-15.912464,170.428505>,<3.598795,-16.961163,170.428505>}
      triangle {<1.633151,-15.627682,173.645400>,<3.598795,-16.961163,170.428505>,<3.774798,-16.718914,173.645401>}
      triangle {<1.540629,-15.912464,170.428505>,<1.370776,-16.435200,167.371030>,<3.275721,-17.405834,167.371030>}
      triangle {<1.540629,-15.912464,170.428505>,<3.275721,-17.405834,167.371030>,<3.598795,-16.961163,170.428505>}
      triangle {<1.370776,-16.435200,167.371030>,<1.104968,-17.253277,164.845854>,<2.770121,-18.101719,164.845854>}
      triangle {<1.370776,-16.435200,167.371030>,<2.770121,-18.101719,164.845854>,<3.275721,-17.405834,167.371030>}
      triangle {<1.104968,-17.253277,164.845854>,<0.724558,-18.424046,163.225940>,<2.046549,-19.097645,163.225940>}
      triangle {<1.104968,-17.253277,164.845854>,<2.046549,-19.097645,163.225940>,<2.770121,-18.101719,164.845854>}
      triangle {<0.724558,-18.424046,163.225940>,<0.210909,-20.004910,162.884233>,<1.069521,-20.442402,162.884232>}
      triangle {<0.724558,-18.424046,163.225940>,<1.069521,-20.442402,162.884232>,<2.046549,-19.097645,163.225940>}
      triangle {<0.210909,-20.004910,162.884233>,<0.218867,-19.980412,155.274646>,<1.084658,-20.421566,155.274646>}
      triangle {<0.210909,-20.004910,162.884233>,<1.084658,-20.421566,155.274646>,<1.069521,-20.442402,162.884232>}
      triangle {<0.218867,-19.980412,155.274646>,<0.534266,-19.009708,155.274646>,<1.684588,-19.595829,155.274646>}
      triangle {<0.218867,-19.980412,155.274646>,<1.684588,-19.595829,155.274646>,<1.084658,-20.421566,155.274646>}
      triangle {<1.684588,-19.595829,155.274646>,<1.684588,-19.595837,161.851297>,<2.597498,-20.508739,161.851297>}
      triangle {<1.684588,-19.595829,155.274646>,<2.597498,-20.508739,161.851297>,<2.597498,-20.508739,155.274646>}
      triangle {<1.684588,-19.595837,161.851297>,<2.556742,-18.395420,163.100009>,<3.797915,-19.636593,163.100009>}
      triangle {<1.684588,-19.595837,161.851297>,<3.797915,-19.636593,163.100009>,<2.597498,-20.508739,161.851297>}
      triangle {<2.556742,-18.395420,163.100009>,<3.195567,-17.516163,165.433196>,<4.677180,-18.997768,165.433196>}
      triangle {<2.556742,-18.395420,163.100009>,<4.677180,-18.997768,165.433196>,<3.797915,-19.636593,163.100009>}
      triangle {<3.195567,-17.516163,165.433196>,<3.634402,-16.912159,168.402773>,<5.281184,-18.558933,168.402773>}
      triangle {<3.195567,-17.516163,165.433196>,<5.281184,-18.558933,168.402773>,<4.677180,-18.997768,165.433196>}
      triangle {<3.634402,-16.912159,168.402773>,<3.906573,-16.537533,171.560601>,<5.655795,-18.286755,171.560601>}
      triangle {<3.634402,-16.912159,168.402773>,<5.655795,-18.286755,171.560601>,<5.281184,-18.558933,168.402773>}
      triangle {<3.906573,-16.537533,171.560601>,<4.045435,-16.346416,174.458659>,<5.846919,-18.147900,174.458660>}
      triangle {<3.906573,-16.537533,171.560601>,<5.846919,-18.147900,174.458660>,<5.655795,-18.286755,171.560601>}
      triangle {<4.045435,-16.346416,174.458659>,<4.084307,-16.292904,176.648778>,<5.900431,-18.109020,176.648767>}
      triangle {<4.045435,-16.346416,174.458659>,<5.900431,-18.109020,176.648767>,<5.846919,-18.147900,174.458660>}
      triangle {<4.084307,-16.292904,176.648778>,<3.839198,-16.630268,176.648779>,<5.563067,-18.354122,176.648767>}
      triangle {<4.084307,-16.292904,176.648778>,<5.563067,-18.354122,176.648767>,<5.900431,-18.109020,176.648767>}
      triangle {<3.839198,-16.630268,176.648779>,<3.774798,-16.718914,173.645401>,<5.474421,-18.418530,173.645417>}
      triangle {<3.839198,-16.630268,176.648779>,<5.474421,-18.418530,173.645417>,<5.563067,-18.354122,176.648767>}
      triangle {<3.774798,-16.718914,173.645401>,<3.598795,-16.961163,170.428505>,<5.232172,-18.594532,170.428522>}
      triangle {<3.774798,-16.718914,173.645401>,<5.232172,-18.594532,170.428522>,<5.474421,-18.418530,173.645417>}
      triangle {<3.598795,-16.961163,170.428505>,<3.275721,-17.405834,167.371030>,<4.787501,-18.917606,167.371030>}
      triangle {<3.598795,-16.961163,170.428505>,<4.787501,-18.917606,167.371030>,<5.232172,-18.594532,170.428522>}
      triangle {<3.275721,-17.405834,167.371030>,<2.770121,-18.101719,164.845854>,<4.091616,-19.423199,164.845854>}
      triangle {<3.275721,-17.405834,167.371030>,<4.091616,-19.423199,164.845854>,<4.787501,-18.917606,167.371030>}
      triangle {<2.770121,-18.101719,164.845854>,<2.046549,-19.097645,163.225940>,<3.095690,-20.146786,163.225940>}
      triangle {<2.770121,-18.101719,164.845854>,<3.095690,-20.146786,163.225940>,<4.091616,-19.423199,164.845854>}
      triangle {<2.046549,-19.097645,163.225940>,<1.069521,-20.442402,162.884232>,<1.750933,-21.123806,162.884232>}
      triangle {<2.046549,-19.097645,163.225940>,<1.750933,-21.123806,162.884232>,<3.095690,-20.146786,163.225940>}
      triangle {<1.069521,-20.442402,162.884232>,<1.084658,-20.421566,155.274646>,<1.771769,-21.108662,155.274646>}
      triangle {<1.069521,-20.442402,162.884232>,<1.771769,-21.108662,155.274646>,<1.750933,-21.123806,162.884232>}
      triangle {<1.084658,-20.421566,155.274646>,<1.684588,-19.595829,155.274646>,<2.597498,-20.508739,155.274646>}
      triangle {<1.084658,-20.421566,155.274646>,<2.597498,-20.508739,155.274646>,<1.771769,-21.108662,155.274646>}
      triangle {<2.597498,-20.508739,155.274646>,<2.597498,-20.508739,161.851297>,<3.183611,-21.659061,161.851297>}
      triangle {<2.597498,-20.508739,155.274646>,<3.183611,-21.659061,161.851297>,<3.183611,-21.659061,155.274646>}
      triangle {<2.597498,-20.508739,161.851297>,<3.797915,-19.636593,163.100009>,<4.594790,-21.200542,163.100009>}
      triangle {<2.597498,-20.508739,161.851297>,<4.594790,-21.200542,163.100009>,<3.183611,-21.659061,161.851297>}
      triangle {<3.797915,-19.636593,163.100009>,<4.677180,-18.997768,165.433196>,<5.628420,-20.864697,165.433196>}
      triangle {<3.797915,-19.636593,163.100009>,<5.628420,-20.864697,165.433196>,<4.594790,-21.200542,163.100009>}
      triangle {<4.677180,-18.997768,165.433196>,<5.281184,-18.558933,168.402773>,<6.338465,-20.633991,168.402772>}
      triangle {<4.677180,-18.997768,165.433196>,<6.338465,-20.633991,168.402772>,<5.628420,-20.864697,165.433196>}
      triangle {<5.281184,-18.558933,168.402773>,<5.655795,-18.286755,171.560601>,<6.778857,-20.490902,171.560601>}
      triangle {<5.281184,-18.558933,168.402773>,<6.778857,-20.490902,171.560601>,<6.338465,-20.633991,168.402772>}
      triangle {<5.655795,-18.286755,171.560601>,<5.846919,-18.147900,174.458660>,<7.003527,-20.417896,174.458659>}
      triangle {<5.655795,-18.286755,171.560601>,<7.003527,-20.417896,174.458659>,<6.778857,-20.490902,171.560601>}
      triangle {<5.846919,-18.147900,174.458660>,<5.900431,-18.109020,176.648767>,<7.066439,-20.397457,176.648767>}
      triangle {<5.846919,-18.147900,174.458660>,<7.066439,-20.397457,176.648767>,<7.003527,-20.417896,174.458659>}
      triangle {<5.900431,-18.109020,176.648767>,<5.563067,-18.354122,176.648767>,<6.669848,-20.526318,176.648767>}
      triangle {<5.900431,-18.109020,176.648767>,<6.669848,-20.526318,176.648767>,<7.066439,-20.397457,176.648767>}
      triangle {<5.563067,-18.354122,176.648767>,<5.474421,-18.418530,173.645417>,<6.565646,-20.560177,173.645400>}
      triangle {<5.563067,-18.354122,176.648767>,<6.565646,-20.560177,173.645400>,<6.669848,-20.526318,176.648767>}
      triangle {<5.474421,-18.418530,173.645417>,<5.232172,-18.594532,170.428522>,<6.280863,-20.652714,170.428505>}
      triangle {<5.474421,-18.418530,173.645417>,<6.280863,-20.652714,170.428505>,<6.565646,-20.560177,173.645400>}
      triangle {<5.232172,-18.594532,170.428522>,<4.787501,-18.917606,167.371030>,<5.758120,-20.822559,167.371030>}
      triangle {<5.232172,-18.594532,170.428522>,<5.758120,-20.822559,167.371030>,<6.280863,-20.652714,170.428505>}
      triangle {<4.787501,-18.917606,167.371030>,<4.091616,-19.423199,164.845854>,<4.940051,-21.088360,164.845854>}
      triangle {<4.787501,-18.917606,167.371030>,<4.940051,-21.088360,164.845854>,<5.758120,-20.822559,167.371030>}
      triangle {<4.091616,-19.423199,164.845854>,<3.095690,-20.146786,163.225940>,<3.769274,-21.468777,163.225940>}
      triangle {<4.091616,-19.423199,164.845854>,<3.769274,-21.468777,163.225940>,<4.940051,-21.088360,164.845854>}
      triangle {<3.095690,-20.146786,163.225940>,<1.750933,-21.123806,162.884232>,<2.188410,-21.982426,162.884233>}
      triangle {<3.095690,-20.146786,163.225940>,<2.188410,-21.982426,162.884233>,<3.769274,-21.468777,163.225940>}
      triangle {<1.750933,-21.123806,162.884232>,<1.771769,-21.108662,155.274646>,<2.212908,-21.974468,155.274646>}
      triangle {<1.750933,-21.123806,162.884232>,<2.212908,-21.974468,155.274646>,<2.188410,-21.982426,162.884233>}
      triangle {<1.771769,-21.108662,155.274646>,<2.597498,-20.508739,155.274646>,<3.183611,-21.659061,155.274646>}
      triangle {<1.771769,-21.108662,155.274646>,<3.183611,-21.659061,155.274646>,<2.212908,-21.974468,155.274646>}
      triangle {<3.183611,-21.659061,155.274646>,<3.183611,-21.659061,161.851297>,<3.385584,-22.934216,161.851264>}
      triangle {<3.183611,-21.659061,155.274646>,<3.385584,-22.934216,161.851264>,<3.385584,-22.934208,155.274646>}
      triangle {<3.183611,-21.659061,161.851297>,<4.594790,-21.200542,163.100009>,<4.869380,-22.934216,163.100008>}
      triangle {<3.183611,-21.659061,161.851297>,<4.869380,-22.934216,163.100008>,<3.385584,-22.934216,161.851264>}
      triangle {<4.594790,-21.200542,163.100009>,<5.628420,-20.864697,165.433196>,<5.956210,-22.934216,165.433195>}
      triangle {<4.594790,-21.200542,163.100009>,<5.956210,-22.934216,165.433195>,<4.869380,-22.934216,163.100008>}
      triangle {<5.628420,-20.864697,165.433196>,<6.338465,-20.633991,168.402772>,<6.702799,-22.934216,168.402772>}
      triangle {<5.628420,-20.864697,165.433196>,<6.702799,-22.934216,168.402772>,<5.956210,-22.934216,165.433195>}
      triangle {<6.338465,-20.633991,168.402772>,<6.778857,-20.490902,171.560601>,<7.165843,-22.934216,171.560601>}
      triangle {<6.338465,-20.633991,168.402772>,<7.165843,-22.934216,171.560601>,<6.702799,-22.934216,168.402772>}
      triangle {<6.778857,-20.490902,171.560601>,<7.003527,-20.417896,174.458659>,<7.402079,-22.934216,174.458659>}
      triangle {<6.778857,-20.490902,171.560601>,<7.402079,-22.934216,174.458659>,<7.165843,-22.934216,171.560601>}
      triangle {<7.003527,-20.417896,174.458659>,<7.066439,-20.397457,176.648767>,<7.468234,-22.934216,176.648767>}
      triangle {<7.003527,-20.417896,174.458659>,<7.468234,-22.934216,176.648767>,<7.402079,-22.934216,174.458659>}
      triangle {<7.066439,-20.397457,176.648767>,<6.669848,-20.526318,176.648767>,<7.051226,-22.934216,176.648767>}
      triangle {<7.066439,-20.397457,176.648767>,<7.051226,-22.934216,176.648767>,<7.468234,-22.934216,176.648767>}
      triangle {<6.669848,-20.526318,176.648767>,<6.565646,-20.560177,173.645400>,<6.941660,-22.934216,173.645401>}
      triangle {<6.669848,-20.526318,176.648767>,<6.941660,-22.934216,173.645401>,<7.051226,-22.934216,176.648767>}
      triangle {<6.565646,-20.560177,173.645400>,<6.280863,-20.652714,170.428505>,<6.642222,-22.934216,170.428505>}
      triangle {<6.565646,-20.560177,173.645400>,<6.642222,-22.934216,170.428505>,<6.941660,-22.934216,173.645401>}
      triangle {<6.280863,-20.652714,170.428505>,<5.758120,-20.822559,167.371030>,<6.092585,-22.934216,167.371029>}
      triangle {<6.280863,-20.652714,170.428505>,<6.092585,-22.934216,167.371029>,<6.642222,-22.934216,170.428505>}
      triangle {<5.758120,-20.822559,167.371030>,<4.940051,-21.088360,164.845854>,<5.232409,-22.934216,164.845853>}
      triangle {<5.758120,-20.822559,167.371030>,<5.232409,-22.934216,164.845853>,<6.092585,-22.934216,167.371029>}
      triangle {<4.940051,-21.088360,164.845854>,<3.769274,-21.468777,163.225940>,<4.001383,-22.934216,163.225939>}
      triangle {<4.940051,-21.088360,164.845854>,<4.001383,-22.934216,163.225939>,<5.232409,-22.934216,164.845853>}
      triangle {<3.769274,-21.468777,163.225940>,<2.188410,-21.982426,162.884233>,<2.339167,-22.934216,162.884232>}
      triangle {<3.769274,-21.468777,163.225940>,<2.339167,-22.934216,162.884232>,<4.001383,-22.934216,163.225939>}
      triangle {<2.188410,-21.982426,162.884233>,<2.212908,-21.974468,155.274646>,<2.364916,-22.934208,155.274646>}
      triangle {<2.188410,-21.982426,162.884233>,<2.364916,-22.934208,155.274646>,<2.339167,-22.934216,162.884232>}
      triangle {<2.212908,-21.974468,155.274646>,<3.183611,-21.659061,155.274646>,<3.385584,-22.934208,155.274646>}
      triangle {<2.212908,-21.974468,155.274646>,<3.385584,-22.934208,155.274646>,<2.364916,-22.934208,155.274646>}
      texture{_Heck04}
    }
    //_Heck09
    mesh{
      triangle {<58.180048,-22.934208,155.274646>,<58.180048,-22.934216,161.851264>,<57.978068,-24.209354,161.851296>}
      triangle {<58.180048,-22.934208,155.274646>,<57.978068,-24.209354,161.851296>,<57.978068,-24.209354,155.274646>}
      triangle {<58.180048,-22.934216,161.851264>,<59.663844,-22.934216,163.100008>,<59.389262,-24.667873,163.100009>}
      triangle {<58.180048,-22.934216,161.851264>,<59.389262,-24.667873,163.100009>,<57.978068,-24.209354,161.851296>}
      triangle {<59.663844,-22.934216,163.100008>,<60.750681,-22.934216,165.433195>,<60.422892,-25.003727,165.433195>}
      triangle {<59.663844,-22.934216,163.100008>,<60.422892,-25.003727,165.433195>,<59.389262,-24.667873,163.100009>}
      triangle {<60.750681,-22.934216,165.433195>,<61.497263,-22.934216,168.402772>,<61.132929,-25.234440,168.402773>}
      triangle {<60.750681,-22.934216,165.433195>,<61.132929,-25.234440,168.402773>,<60.422892,-25.003727,165.433195>}
      triangle {<61.497263,-22.934216,168.402772>,<61.960307,-22.934216,171.560601>,<61.573313,-25.377522,171.560617>}
      triangle {<61.497263,-22.934216,168.402772>,<61.573313,-25.377522,171.560617>,<61.132929,-25.234440,168.402773>}
      triangle {<61.960307,-22.934216,171.560601>,<62.196543,-22.934216,174.458659>,<61.797984,-25.450527,174.458659>}
      triangle {<61.960307,-22.934216,171.560601>,<61.797984,-25.450527,174.458659>,<61.573313,-25.377522,171.560617>}
      triangle {<62.196543,-22.934216,174.458659>,<62.262705,-22.934216,176.648767>,<61.860911,-25.470966,176.648766>}
      triangle {<62.196543,-22.934216,174.458659>,<61.860911,-25.470966,176.648766>,<61.797984,-25.450527,174.458659>}
      triangle {<62.262705,-22.934216,176.648767>,<61.845683,-22.934216,176.648767>,<61.464304,-25.342113,176.648766>}
      triangle {<62.262705,-22.934216,176.648767>,<61.464304,-25.342113,176.648766>,<61.860911,-25.470966,176.648766>}
      triangle {<61.845683,-22.934216,176.648767>,<61.736125,-22.934216,173.645401>,<61.360117,-25.308254,173.645400>}
      triangle {<61.845683,-22.934216,176.648767>,<61.360117,-25.308254,173.645400>,<61.464304,-25.342113,176.648766>}
      triangle {<61.736125,-22.934216,173.645401>,<61.436686,-22.934216,170.428505>,<61.075327,-25.215710,170.428522>}
      triangle {<61.736125,-22.934216,173.645401>,<61.075327,-25.215710,170.428522>,<61.360117,-25.308254,173.645400>}
      triangle {<61.436686,-22.934216,170.428505>,<60.887049,-22.934216,167.371029>,<60.552592,-25.045864,167.371029>}
      triangle {<61.436686,-22.934216,170.428505>,<60.552592,-25.045864,167.371029>,<61.075327,-25.215710,170.428522>}
      triangle {<60.887049,-22.934216,167.371029>,<60.026865,-22.934216,164.845853>,<59.734507,-24.780056,164.845853>}
      triangle {<60.887049,-22.934216,167.371029>,<59.734507,-24.780056,164.845853>,<60.552592,-25.045864,167.371029>}
      triangle {<60.026865,-22.934216,164.845853>,<58.795847,-22.934216,163.225939>,<58.563731,-24.399647,163.225940>}
      triangle {<60.026865,-22.934216,164.845853>,<58.563731,-24.399647,163.225940>,<59.734507,-24.780056,164.845853>}
      triangle {<58.795847,-22.934216,163.225939>,<57.133631,-22.934216,162.884232>,<56.982874,-23.885998,162.884232>}
      triangle {<58.795847,-22.934216,163.225939>,<56.982874,-23.885998,162.884232>,<58.563731,-24.399647,163.225940>}
      triangle {<57.133631,-22.934216,162.884232>,<57.159373,-22.934208,155.274646>,<57.007365,-23.893948,155.274646>}
      triangle {<57.133631,-22.934216,162.884232>,<57.007365,-23.893948,155.274646>,<56.982874,-23.885998,162.884232>}
      triangle {<57.159373,-22.934208,155.274646>,<58.180048,-22.934208,155.274646>,<57.978068,-24.209354,155.274646>}
      triangle {<57.159373,-22.934208,155.274646>,<57.978068,-24.209354,155.274646>,<57.007365,-23.893948,155.274646>}
      triangle {<57.978068,-24.209354,155.274646>,<57.978068,-24.209354,161.851296>,<57.391963,-25.359692,161.851296>}
      triangle {<57.978068,-24.209354,155.274646>,<57.391963,-25.359692,161.851296>,<57.391963,-25.359692,155.274646>}
      triangle {<57.978068,-24.209354,161.851296>,<59.389262,-24.667873,163.100009>,<58.592371,-26.231846,163.100008>}
      triangle {<57.978068,-24.209354,161.851296>,<58.592371,-26.231846,163.100008>,<57.391963,-25.359692,161.851296>}
      triangle {<59.389262,-24.667873,163.100009>,<60.422892,-25.003727,165.433195>,<59.471644,-26.870663,165.433195>}
      triangle {<59.389262,-24.667873,163.100009>,<59.471644,-26.870663,165.433195>,<58.592371,-26.231846,163.100008>}
      triangle {<60.422892,-25.003727,165.433195>,<61.132929,-25.234440,168.402773>,<60.075648,-27.309498,168.402772>}
      triangle {<60.422892,-25.003727,165.433195>,<60.075648,-27.309498,168.402772>,<59.471644,-26.870663,165.433195>}
      triangle {<61.132929,-25.234440,168.402773>,<61.573313,-25.377522,171.560617>,<60.450266,-27.581669,171.560601>}
      triangle {<61.132929,-25.234440,168.402773>,<60.450266,-27.581669,171.560601>,<60.075648,-27.309498,168.402772>}
      triangle {<61.573313,-25.377522,171.560617>,<61.797984,-25.450527,174.458659>,<60.641367,-27.720531,174.458649>}
      triangle {<61.573313,-25.377522,171.560617>,<60.641367,-27.720531,174.458649>,<60.450266,-27.581669,171.560601>}
      triangle {<61.797984,-25.450527,174.458659>,<61.860911,-25.470966,176.648766>,<60.694895,-27.759411,176.648766>}
      triangle {<61.797984,-25.450527,174.458659>,<60.694895,-27.759411,176.648766>,<60.641367,-27.720531,174.458649>}
      triangle {<61.860911,-25.470966,176.648766>,<61.464304,-25.342113,176.648766>,<60.357523,-27.514301,176.648766>}
      triangle {<61.860911,-25.470966,176.648766>,<60.357523,-27.514301,176.648766>,<60.694895,-27.759411,176.648766>}
      triangle {<61.464304,-25.342113,176.648766>,<61.360117,-25.308254,173.645400>,<60.268885,-27.449894,173.645400>}
      triangle {<61.464304,-25.342113,176.648766>,<60.268885,-27.449894,173.645400>,<60.357523,-27.514301,176.648766>}
      triangle {<61.360117,-25.308254,173.645400>,<61.075327,-25.215710,170.428522>,<60.026637,-27.273891,170.428505>}
      triangle {<61.360117,-25.308254,173.645400>,<60.026637,-27.273891,170.428505>,<60.268885,-27.449894,173.645400>}
      triangle {<61.075327,-25.215710,170.428522>,<60.552592,-25.045864,167.371029>,<59.581965,-26.950817,167.371017>}
      triangle {<61.075327,-25.215710,170.428522>,<59.581965,-26.950817,167.371017>,<60.026637,-27.273891,170.428505>}
      triangle {<60.552592,-25.045864,167.371029>,<59.734507,-24.780056,164.845853>,<58.886088,-26.445225,164.845853>}
      triangle {<60.552592,-25.045864,167.371029>,<58.886088,-26.445225,164.845853>,<59.581965,-26.950817,167.371017>}
      triangle {<59.734507,-24.780056,164.845853>,<58.563731,-24.399647,163.225940>,<57.890147,-25.721645,163.225939>}
      triangle {<59.734507,-24.780056,164.845853>,<57.890147,-25.721645,163.225939>,<58.886088,-26.445225,164.845853>}
      triangle {<58.563731,-24.399647,163.225940>,<56.982874,-23.885998,162.884232>,<56.545390,-24.744625,162.884233>}
      triangle {<58.563731,-24.399647,163.225940>,<56.545390,-24.744625,162.884233>,<57.890147,-25.721645,163.225939>}
      triangle {<56.982874,-23.885998,162.884232>,<57.007365,-23.893948,155.274646>,<56.566233,-24.759754,155.274646>}
      triangle {<56.982874,-23.885998,162.884232>,<56.566233,-24.759754,155.274646>,<56.545390,-24.744625,162.884233>}
      triangle {<57.007365,-23.893948,155.274646>,<57.978068,-24.209354,155.274646>,<57.391963,-25.359692,155.274646>}
      triangle {<57.007365,-23.893948,155.274646>,<57.391963,-25.359692,155.274646>,<56.566233,-24.759754,155.274646>}
      triangle {<57.391963,-25.359692,155.274646>,<57.391963,-25.359692,161.851296>,<56.479044,-26.272587,161.851297>}
      triangle {<57.391963,-25.359692,155.274646>,<56.479044,-26.272587,161.851297>,<56.479044,-26.272587,155.274646>}
      triangle {<57.391963,-25.359692,161.851296>,<58.592371,-26.231846,163.100008>,<57.351206,-27.473003,163.100008>}
      triangle {<57.391963,-25.359692,161.851296>,<57.351206,-27.473003,163.100008>,<56.479044,-26.272587,161.851297>}
      triangle {<58.592371,-26.231846,163.100008>,<59.471644,-26.870663,165.433195>,<57.990031,-28.352268,165.433195>}
      triangle {<58.592371,-26.231846,163.100008>,<57.990031,-28.352268,165.433195>,<57.351206,-27.473003,163.100008>}
      triangle {<59.471644,-26.870663,165.433195>,<60.075648,-27.309498,168.402772>,<58.428858,-28.956264,168.402772>}
      triangle {<59.471644,-26.870663,165.433195>,<58.428858,-28.956264,168.402772>,<57.990031,-28.352268,165.433195>}
      triangle {<60.075648,-27.309498,168.402772>,<60.450266,-27.581669,171.560601>,<58.701029,-29.330891,171.560617>}
      triangle {<60.075648,-27.309498,168.402772>,<58.701029,-29.330891,171.560617>,<58.428858,-28.956264,168.402772>}
      triangle {<60.450266,-27.581669,171.560601>,<60.641367,-27.720531,174.458649>,<58.839884,-29.522007,174.458649>}
      triangle {<60.450266,-27.581669,171.560601>,<58.839884,-29.522007,174.458649>,<58.701029,-29.330891,171.560617>}
      triangle {<60.641367,-27.720531,174.458649>,<60.694895,-27.759411,176.648766>,<58.878764,-29.575520,176.648767>}
      triangle {<60.641367,-27.720531,174.458649>,<58.878764,-29.575520,176.648767>,<58.839884,-29.522007,174.458649>}
      triangle {<60.694895,-27.759411,176.648766>,<60.357523,-27.514301,176.648766>,<58.633662,-29.238163,176.648767>}
      triangle {<60.694895,-27.759411,176.648766>,<58.633662,-29.238163,176.648767>,<58.878764,-29.575520,176.648767>}
      triangle {<60.357523,-27.514301,176.648766>,<60.268885,-27.449894,173.645400>,<58.569254,-29.149517,173.645417>}
      triangle {<60.357523,-27.514301,176.648766>,<58.569254,-29.149517,173.645417>,<58.633662,-29.238163,176.648767>}
      triangle {<60.268885,-27.449894,173.645400>,<60.026637,-27.273891,170.428505>,<58.393260,-28.907261,170.428522>}
      triangle {<60.268885,-27.449894,173.645400>,<58.393260,-28.907261,170.428522>,<58.569254,-29.149517,173.645417>}
      triangle {<60.026637,-27.273891,170.428505>,<59.581965,-26.950817,167.371017>,<58.070185,-28.462589,167.371017>}
      triangle {<60.026637,-27.273891,170.428505>,<58.070185,-28.462589,167.371017>,<58.393260,-28.907261,170.428522>}
      triangle {<59.581965,-26.950817,167.371017>,<58.886088,-26.445225,164.845853>,<57.564585,-27.766705,164.845853>}
      triangle {<59.581965,-26.950817,167.371017>,<57.564585,-27.766705,164.845853>,<58.070185,-28.462589,167.371017>}
      triangle {<58.886088,-26.445225,164.845853>,<57.890147,-25.721645,163.225939>,<56.841013,-26.770779,163.225939>}
      triangle {<58.886088,-26.445225,164.845853>,<56.841013,-26.770779,163.225939>,<57.564585,-27.766705,164.845853>}
      triangle {<57.890147,-25.721645,163.225939>,<56.545390,-24.744625,162.884233>,<55.863993,-25.426022,162.884233>}
      triangle {<57.890147,-25.721645,163.225939>,<55.863993,-25.426022,162.884233>,<56.841013,-26.770779,163.225939>}
      triangle {<56.545390,-24.744625,162.884233>,<56.566233,-24.759754,155.274646>,<55.879130,-25.446850,155.274646>}
      triangle {<56.545390,-24.744625,162.884233>,<55.879130,-25.446850,155.274646>,<55.863993,-25.426022,162.884233>}
      triangle {<56.566233,-24.759754,155.274646>,<57.391963,-25.359692,155.274646>,<56.479044,-26.272587,155.274646>}
      triangle {<56.566233,-24.759754,155.274646>,<56.479044,-26.272587,155.274646>,<55.879130,-25.446850,155.274646>}
      triangle {<56.479044,-26.272587,155.274646>,<56.479044,-26.272587,161.851297>,<55.328730,-26.858707,161.851297>}
      triangle {<56.479044,-26.272587,155.274646>,<55.328730,-26.858707,161.851297>,<55.328730,-26.858707,155.274646>}
      triangle {<56.479044,-26.272587,161.851297>,<57.351206,-27.473003,163.100008>,<55.787241,-28.269886,163.100008>}
      triangle {<56.479044,-26.272587,161.851297>,<55.787241,-28.269886,163.100008>,<55.328730,-26.858707,161.851297>}
      triangle {<57.351206,-27.473003,163.100008>,<57.990031,-28.352268,165.433195>,<56.123087,-29.303524,165.433195>}
      triangle {<57.351206,-27.473003,163.100008>,<56.123087,-29.303524,165.433195>,<55.787241,-28.269886,163.100008>}
      triangle {<57.990031,-28.352268,165.433195>,<58.428858,-28.956264,168.402772>,<56.353800,-30.013569,168.402772>}
      triangle {<57.990031,-28.352268,165.433195>,<56.353800,-30.013569,168.402772>,<56.123087,-29.303524,165.433195>}
      triangle {<58.428858,-28.956264,168.402772>,<58.701029,-29.330891,171.560617>,<56.496897,-30.453960,171.560617>}
      triangle {<58.428858,-28.956264,168.402772>,<56.496897,-30.453960,171.560617>,<56.353800,-30.013569,168.402772>}
      triangle {<58.701029,-29.330891,171.560617>,<58.839884,-29.522007,174.458649>,<56.569895,-30.678638,174.458649>}
      triangle {<58.701029,-29.330891,171.560617>,<56.569895,-30.678638,174.458649>,<56.496897,-30.453960,171.560617>}
      triangle {<58.839884,-29.522007,174.458649>,<58.878764,-29.575520,176.648767>,<56.590342,-30.741543,176.648767>}
      triangle {<58.839884,-29.522007,174.458649>,<56.590342,-30.741543,176.648767>,<56.569895,-30.678638,174.458649>}
      triangle {<58.878764,-29.575520,176.648767>,<58.633662,-29.238163,176.648767>,<56.461466,-30.344944,176.648767>}
      triangle {<58.878764,-29.575520,176.648767>,<56.461466,-30.344944,176.648767>,<56.590342,-30.741543,176.648767>}
      triangle {<58.633662,-29.238163,176.648767>,<58.569254,-29.149517,173.645417>,<56.427622,-30.240749,173.645400>}
      triangle {<58.633662,-29.238163,176.648767>,<56.427622,-30.240749,173.645400>,<56.461466,-30.344944,176.648767>}
      triangle {<58.569254,-29.149517,173.645417>,<58.393260,-28.907261,170.428522>,<56.335093,-29.955959,170.428522>}
      triangle {<58.569254,-29.149517,173.645417>,<56.335093,-29.955959,170.428522>,<56.427622,-30.240749,173.645400>}
      triangle {<58.393260,-28.907261,170.428522>,<58.070185,-28.462589,167.371017>,<56.165232,-29.433216,167.371017>}
      triangle {<58.393260,-28.907261,170.428522>,<56.165232,-29.433216,167.371017>,<56.335093,-29.955959,170.428522>}
      triangle {<58.070185,-28.462589,167.371017>,<57.564585,-27.766705,164.845853>,<55.899424,-28.615147,164.845853>}
      triangle {<58.070185,-28.462589,167.371017>,<55.899424,-28.615147,164.845853>,<56.165232,-29.433216,167.371017>}
      triangle {<57.564585,-27.766705,164.845853>,<56.841013,-26.770779,163.225939>,<55.519022,-27.444378,163.225939>}
      triangle {<57.564585,-27.766705,164.845853>,<55.519022,-27.444378,163.225939>,<55.899424,-28.615147,164.845853>}
      triangle {<56.841013,-26.770779,163.225939>,<55.863993,-25.426022,162.884233>,<55.005381,-25.863522,162.884232>}
      triangle {<56.841013,-26.770779,163.225939>,<55.005381,-25.863522,162.884232>,<55.519022,-27.444378,163.225939>}
      triangle {<55.863993,-25.426022,162.884233>,<55.879130,-25.446850,155.274646>,<55.013331,-25.888004,155.274646>}
      triangle {<55.863993,-25.426022,162.884233>,<55.013331,-25.888004,155.274646>,<55.005381,-25.863522,162.884232>}
      triangle {<55.879130,-25.446850,155.274646>,<56.479044,-26.272587,155.274646>,<55.328730,-26.858707,155.274646>}
      triangle {<55.879130,-25.446850,155.274646>,<55.328730,-26.858707,155.274646>,<55.013331,-25.888004,155.274646>}
      triangle {<55.328730,-26.858707,155.274646>,<55.328730,-26.858707,161.851297>,<54.053568,-27.060673,161.851297>}
      triangle {<55.328730,-26.858707,155.274646>,<54.053568,-27.060673,161.851297>,<54.053568,-27.060673,155.274646>}
      triangle {<55.328730,-26.858707,161.851297>,<55.787241,-28.269886,163.100008>,<54.053568,-28.544468,163.100008>}
      triangle {<55.328730,-26.858707,161.851297>,<54.053568,-28.544468,163.100008>,<54.053568,-27.060673,161.851297>}
      triangle {<55.787241,-28.269886,163.100008>,<56.123087,-29.303524,165.433195>,<54.053568,-29.631290,165.433195>}
      triangle {<55.787241,-28.269886,163.100008>,<54.053568,-29.631290,165.433195>,<54.053568,-28.544468,163.100008>}
      triangle {<56.123087,-29.303524,165.433195>,<56.353800,-30.013569,168.402772>,<54.053568,-30.377880,168.402763>}
      triangle {<56.123087,-29.303524,165.433195>,<54.053568,-30.377880,168.402763>,<54.053568,-29.631290,165.433195>}
      triangle {<56.353800,-30.013569,168.402772>,<56.496897,-30.453960,171.560617>,<54.053568,-30.840939,171.560600>}
      triangle {<56.353800,-30.013569,168.402772>,<54.053568,-30.840939,171.560600>,<54.053568,-30.377880,168.402763>}
      triangle {<56.496897,-30.453960,171.560617>,<56.569895,-30.678638,174.458649>,<54.053568,-31.077175,174.458649>}
      triangle {<56.496897,-30.453960,171.560617>,<54.053568,-31.077175,174.458649>,<54.053568,-30.840939,171.560600>}
      triangle {<56.569895,-30.678638,174.458649>,<56.590342,-30.741543,176.648767>,<54.053568,-31.143314,176.648767>}
      triangle {<56.569895,-30.678638,174.458649>,<54.053568,-31.143314,176.648767>,<54.053568,-31.077175,174.458649>}
      triangle {<56.590342,-30.741543,176.648767>,<56.461466,-30.344944,176.648767>,<54.053568,-30.726322,176.648767>}
      triangle {<56.590342,-30.741543,176.648767>,<54.053568,-30.726322,176.648767>,<54.053568,-31.143314,176.648767>}
      triangle {<56.461466,-30.344944,176.648767>,<56.427622,-30.240749,173.645400>,<54.053568,-30.616749,173.645400>}
      triangle {<56.461466,-30.344944,176.648767>,<54.053568,-30.616749,173.645400>,<54.053568,-30.726322,176.648767>}
      triangle {<56.427622,-30.240749,173.645400>,<56.335093,-29.955959,170.428522>,<54.053568,-30.317303,170.428522>}
      triangle {<56.427622,-30.240749,173.645400>,<54.053568,-30.317303,170.428522>,<54.053568,-30.616749,173.645400>}
      triangle {<56.335093,-29.955959,170.428522>,<56.165232,-29.433216,167.371017>,<54.053568,-29.767666,167.371017>}
      triangle {<56.335093,-29.955959,170.428522>,<54.053568,-29.767666,167.371017>,<54.053568,-30.317303,170.428522>}
      triangle {<56.165232,-29.433216,167.371017>,<55.899424,-28.615147,164.845853>,<54.053568,-28.907497,164.845853>}
      triangle {<56.165232,-29.433216,167.371017>,<54.053568,-28.907497,164.845853>,<54.053568,-29.767666,167.371017>}
      triangle {<55.899424,-28.615147,164.845853>,<55.519022,-27.444378,163.225939>,<54.053568,-27.676472,163.225940>}
      triangle {<55.899424,-28.615147,164.845853>,<54.053568,-27.676472,163.225940>,<54.053568,-28.907497,164.845853>}
      triangle {<55.519022,-27.444378,163.225939>,<55.005381,-25.863522,162.884232>,<54.053568,-26.014263,162.884232>}
      triangle {<55.519022,-27.444378,163.225939>,<54.053568,-26.014263,162.884232>,<54.053568,-27.676472,163.225940>}
      triangle {<55.005381,-25.863522,162.884232>,<55.013331,-25.888004,155.274646>,<54.053568,-26.040005,155.274646>}
      triangle {<55.005381,-25.863522,162.884232>,<54.053568,-26.040005,155.274646>,<54.053568,-26.014263,162.884232>}
      triangle {<55.013331,-25.888004,155.274646>,<55.328730,-26.858707,155.274646>,<54.053568,-27.060673,155.274646>}
      triangle {<55.013331,-25.888004,155.274646>,<54.053568,-27.060673,155.274646>,<54.053568,-26.040005,155.274646>}
      triangle {<54.053568,-27.060673,155.274646>,<54.053568,-27.060673,161.851297>,<52.778437,-26.858707,161.851297>}
      triangle {<54.053568,-27.060673,155.274646>,<52.778437,-26.858707,161.851297>,<52.778437,-26.858707,155.274646>}
      triangle {<54.053568,-27.060673,161.851297>,<54.053568,-28.544468,163.100008>,<52.319926,-28.269886,163.100008>}
      triangle {<54.053568,-27.060673,161.851297>,<52.319926,-28.269886,163.100008>,<52.778437,-26.858707,161.851297>}
      triangle {<54.053568,-28.544468,163.100008>,<54.053568,-29.631290,165.433195>,<51.984065,-29.303524,165.433195>}
      triangle {<54.053568,-28.544468,163.100008>,<51.984065,-29.303524,165.433195>,<52.319926,-28.269886,163.100008>}
      triangle {<54.053568,-29.631290,165.433195>,<54.053568,-30.377880,168.402763>,<51.753367,-30.013569,168.402772>}
      triangle {<54.053568,-29.631290,165.433195>,<51.753367,-30.013569,168.402772>,<51.984065,-29.303524,165.433195>}
      triangle {<54.053568,-30.377880,168.402763>,<54.053568,-30.840939,171.560600>,<51.610270,-30.453953,171.560617>}
      triangle {<54.053568,-30.377880,168.402763>,<51.610270,-30.453953,171.560617>,<51.753367,-30.013569,168.402772>}
      triangle {<54.053568,-30.840939,171.560600>,<54.053568,-31.077175,174.458649>,<51.537272,-30.678638,174.458649>}
      triangle {<54.053568,-30.840939,171.560600>,<51.537272,-30.678638,174.458649>,<51.610270,-30.453953,171.560617>}
      triangle {<54.053568,-31.077175,174.458649>,<54.053568,-31.143314,176.648767>,<51.516825,-30.741535,176.648767>}
      triangle {<54.053568,-31.077175,174.458649>,<51.516825,-30.741535,176.648767>,<51.537272,-30.678638,174.458649>}
      triangle {<54.053568,-31.143314,176.648767>,<54.053568,-30.726322,176.648767>,<51.645686,-30.344944,176.648767>}
      triangle {<54.053568,-31.143314,176.648767>,<51.645686,-30.344944,176.648767>,<51.516825,-30.741535,176.648767>}
      triangle {<54.053568,-30.726322,176.648767>,<54.053568,-30.616749,173.645400>,<51.679545,-30.240749,173.645400>}
      triangle {<54.053568,-30.726322,176.648767>,<51.679545,-30.240749,173.645400>,<51.645686,-30.344944,176.648767>}
      triangle {<54.053568,-30.616749,173.645400>,<54.053568,-30.317303,170.428522>,<51.772074,-29.955959,170.428522>}
      triangle {<54.053568,-30.616749,173.645400>,<51.772074,-29.955959,170.428522>,<51.679545,-30.240749,173.645400>}
      triangle {<54.053568,-30.317303,170.428522>,<54.053568,-29.767666,167.371017>,<51.941935,-29.433216,167.371017>}
      triangle {<54.053568,-30.317303,170.428522>,<51.941935,-29.433216,167.371017>,<51.772074,-29.955959,170.428522>}
      triangle {<54.053568,-29.767666,167.371017>,<54.053568,-28.907497,164.845853>,<52.207728,-28.615147,164.845853>}
      triangle {<54.053568,-29.767666,167.371017>,<52.207728,-28.615147,164.845853>,<51.941935,-29.433216,167.371017>}
      triangle {<54.053568,-28.907497,164.845853>,<54.053568,-27.676472,163.225940>,<52.588145,-27.444378,163.225939>}
      triangle {<54.053568,-28.907497,164.845853>,<52.588145,-27.444378,163.225939>,<52.207728,-28.615147,164.845853>}
      triangle {<54.053568,-27.676472,163.225940>,<54.053568,-26.014263,162.884232>,<53.101786,-25.863522,162.884232>}
      triangle {<54.053568,-27.676472,163.225940>,<53.101786,-25.863522,162.884232>,<52.588145,-27.444378,163.225939>}
      triangle {<54.053568,-26.014263,162.884232>,<54.053568,-26.040005,155.274646>,<53.093836,-25.888004,155.274646>}
      triangle {<54.053568,-26.014263,162.884232>,<53.093836,-25.888004,155.274646>,<53.101786,-25.863522,162.884232>}
      triangle {<54.053568,-26.040005,155.274646>,<54.053568,-27.060673,155.274646>,<52.778437,-26.858707,155.274646>}
      triangle {<54.053568,-26.040005,155.274646>,<52.778437,-26.858707,155.274646>,<53.093836,-25.888004,155.274646>}
      triangle {<52.778437,-26.858707,155.274646>,<52.778437,-26.858707,161.851297>,<51.628108,-26.272587,161.851297>}
      triangle {<52.778437,-26.858707,155.274646>,<51.628108,-26.272587,161.851297>,<51.628108,-26.272587,155.274646>}
      triangle {<52.778437,-26.858707,161.851297>,<52.319926,-28.269886,163.100008>,<50.755961,-27.473003,163.100008>}
      triangle {<52.778437,-26.858707,161.851297>,<50.755961,-27.473003,163.100008>,<51.628108,-26.272587,161.851297>}
      triangle {<52.319926,-28.269886,163.100008>,<51.984065,-29.303524,165.433195>,<50.117136,-28.352268,165.433195>}
      triangle {<52.319926,-28.269886,163.100008>,<50.117136,-28.352268,165.433195>,<50.755961,-27.473003,163.100008>}
      triangle {<51.984065,-29.303524,165.433195>,<51.753367,-30.013569,168.402772>,<49.678294,-28.956264,168.402772>}
      triangle {<51.984065,-29.303524,165.433195>,<49.678294,-28.956264,168.402772>,<50.117136,-28.352268,165.433195>}
      triangle {<51.753367,-30.013569,168.402772>,<51.610270,-30.453953,171.560617>,<49.406123,-29.330891,171.560617>}
      triangle {<51.753367,-30.013569,168.402772>,<49.406123,-29.330891,171.560617>,<49.678294,-28.956264,168.402772>}
      triangle {<51.610270,-30.453953,171.560617>,<51.537272,-30.678638,174.458649>,<49.267268,-29.522007,174.458649>}
      triangle {<51.610270,-30.453953,171.560617>,<49.267268,-29.522007,174.458649>,<49.406123,-29.330891,171.560617>}
      triangle {<51.537272,-30.678638,174.458649>,<51.516825,-30.741535,176.648767>,<49.228388,-29.575520,176.648767>}
      triangle {<51.537272,-30.678638,174.458649>,<49.228388,-29.575520,176.648767>,<49.267268,-29.522007,174.458649>}
      triangle {<51.516825,-30.741535,176.648767>,<51.645686,-30.344944,176.648767>,<49.473490,-29.238163,176.648767>}
      triangle {<51.516825,-30.741535,176.648767>,<49.473490,-29.238163,176.648767>,<49.228388,-29.575520,176.648767>}
      triangle {<51.645686,-30.344944,176.648767>,<51.679545,-30.240749,173.645400>,<49.537898,-29.149517,173.645417>}
      triangle {<51.645686,-30.344944,176.648767>,<49.537898,-29.149517,173.645417>,<49.473490,-29.238163,176.648767>}
      triangle {<51.679545,-30.240749,173.645400>,<51.772074,-29.955959,170.428522>,<49.713908,-28.907261,170.428522>}
      triangle {<51.679545,-30.240749,173.645400>,<49.713908,-28.907261,170.428522>,<49.537898,-29.149517,173.645417>}
      triangle {<51.772074,-29.955959,170.428522>,<51.941935,-29.433216,167.371017>,<50.036967,-28.462589,167.371017>}
      triangle {<51.772074,-29.955959,170.428522>,<50.036967,-28.462589,167.371017>,<49.713908,-28.907261,170.428522>}
      triangle {<51.941935,-29.433216,167.371017>,<52.207728,-28.615147,164.845853>,<50.542567,-27.766705,164.845853>}
      triangle {<51.941935,-29.433216,167.371017>,<50.542567,-27.766705,164.845853>,<50.036967,-28.462589,167.371017>}
      triangle {<52.207728,-28.615147,164.845853>,<52.588145,-27.444378,163.225939>,<51.266154,-26.770786,163.225939>}
      triangle {<52.207728,-28.615147,164.845853>,<51.266154,-26.770786,163.225939>,<50.542567,-27.766705,164.845853>}
      triangle {<52.588145,-27.444378,163.225939>,<53.101786,-25.863522,162.884232>,<52.243174,-25.426022,162.884233>}
      triangle {<52.588145,-27.444378,163.225939>,<52.243174,-25.426022,162.884233>,<51.266154,-26.770786,163.225939>}
      triangle {<53.101786,-25.863522,162.884232>,<53.093836,-25.888004,155.274646>,<52.228037,-25.446857,155.274646>}
      triangle {<53.101786,-25.863522,162.884232>,<52.228037,-25.446857,155.274646>,<52.243174,-25.426022,162.884233>}
      triangle {<53.093836,-25.888004,155.274646>,<52.778437,-26.858707,155.274646>,<51.628108,-26.272587,155.274646>}
      triangle {<53.093836,-25.888004,155.274646>,<51.628108,-26.272587,155.274646>,<52.228037,-25.446857,155.274646>}
      triangle {<51.628108,-26.272587,155.274646>,<51.628108,-26.272587,161.851297>,<50.715205,-25.359692,161.851296>}
      triangle {<51.628108,-26.272587,155.274646>,<50.715205,-25.359692,161.851296>,<50.715205,-25.359692,155.274646>}
      triangle {<51.628108,-26.272587,161.851297>,<50.755961,-27.473003,163.100008>,<49.514781,-26.231846,163.100008>}
      triangle {<51.628108,-26.272587,161.851297>,<49.514781,-26.231846,163.100008>,<50.715205,-25.359692,161.851296>}
      triangle {<50.755961,-27.473003,163.100008>,<50.117136,-28.352268,165.433195>,<48.635508,-26.870663,165.433195>}
      triangle {<50.755961,-27.473003,163.100008>,<48.635508,-26.870663,165.433195>,<49.514781,-26.231846,163.100008>}
      triangle {<50.117136,-28.352268,165.433195>,<49.678294,-28.956264,168.402772>,<48.031519,-27.309490,168.402772>}
      triangle {<50.117136,-28.352268,165.433195>,<48.031519,-27.309490,168.402772>,<48.635508,-26.870663,165.433195>}
      triangle {<49.678294,-28.956264,168.402772>,<49.406123,-29.330891,171.560617>,<47.656901,-27.581669,171.560601>}
      triangle {<49.678294,-28.956264,168.402772>,<47.656901,-27.581669,171.560601>,<48.031519,-27.309490,168.402772>}
      triangle {<49.406123,-29.330891,171.560617>,<49.267268,-29.522007,174.458649>,<47.465785,-27.720524,174.458649>}
      triangle {<49.406123,-29.330891,171.560617>,<47.465785,-27.720524,174.458649>,<47.656901,-27.581669,171.560601>}
      triangle {<49.267268,-29.522007,174.458649>,<49.228388,-29.575520,176.648767>,<47.412272,-27.759403,176.648766>}
      triangle {<49.267268,-29.522007,174.458649>,<47.412272,-27.759403,176.648766>,<47.465785,-27.720524,174.458649>}
      triangle {<49.228388,-29.575520,176.648767>,<49.473490,-29.238163,176.648767>,<47.749629,-27.514301,176.648766>}
      triangle {<49.228388,-29.575520,176.648767>,<47.749629,-27.514301,176.648766>,<47.412272,-27.759403,176.648766>}
      triangle {<49.473490,-29.238163,176.648767>,<49.537898,-29.149517,173.645417>,<47.838267,-27.449894,173.645400>}
      triangle {<49.473490,-29.238163,176.648767>,<47.838267,-27.449894,173.645400>,<47.749629,-27.514301,176.648766>}
      triangle {<49.537898,-29.149517,173.645417>,<49.713908,-28.907261,170.428522>,<48.080515,-27.273891,170.428505>}
      triangle {<49.537898,-29.149517,173.645417>,<48.080515,-27.273891,170.428505>,<47.838267,-27.449894,173.645400>}
      triangle {<49.713908,-28.907261,170.428522>,<50.036967,-28.462589,167.371017>,<48.525187,-26.950817,167.371017>}
      triangle {<49.713908,-28.907261,170.428522>,<48.525187,-26.950817,167.371017>,<48.080515,-27.273891,170.428505>}
      triangle {<50.036967,-28.462589,167.371017>,<50.542567,-27.766705,164.845853>,<49.221079,-26.445225,164.845853>}
      triangle {<50.036967,-28.462589,167.371017>,<49.221079,-26.445225,164.845853>,<48.525187,-26.950817,167.371017>}
      triangle {<50.542567,-27.766705,164.845853>,<51.266154,-26.770786,163.225939>,<50.217005,-25.721645,163.225939>}
      triangle {<50.542567,-27.766705,164.845853>,<50.217005,-25.721645,163.225939>,<49.221079,-26.445225,164.845853>}
      triangle {<51.266154,-26.770786,163.225939>,<52.243174,-25.426022,162.884233>,<51.561778,-24.744625,162.884233>}
      triangle {<51.266154,-26.770786,163.225939>,<51.561778,-24.744625,162.884233>,<50.217005,-25.721645,163.225939>}
      triangle {<52.243174,-25.426022,162.884233>,<52.228037,-25.446857,155.274646>,<51.540934,-24.759754,155.274646>}
      triangle {<52.243174,-25.426022,162.884233>,<51.540934,-24.759754,155.274646>,<51.561778,-24.744625,162.884233>}
      triangle {<52.228037,-25.446857,155.274646>,<51.628108,-26.272587,155.274646>,<50.715205,-25.359692,155.274646>}
      triangle {<52.228037,-25.446857,155.274646>,<50.715205,-25.359692,155.274646>,<51.540934,-24.759754,155.274646>}
      triangle {<50.715205,-25.359692,155.274646>,<50.715205,-25.359692,161.851296>,<50.129084,-24.209354,161.851296>}
      triangle {<50.715205,-25.359692,155.274646>,<50.129084,-24.209354,161.851296>,<50.129084,-24.209354,155.274646>}
      triangle {<50.715205,-25.359692,161.851296>,<49.514781,-26.231846,163.100008>,<48.717906,-24.667873,163.100009>}
      triangle {<50.715205,-25.359692,161.851296>,<48.717906,-24.667873,163.100009>,<50.129084,-24.209354,161.851296>}
      triangle {<49.514781,-26.231846,163.100008>,<48.635508,-26.870663,165.433195>,<47.684275,-25.003727,165.433195>}
      triangle {<49.514781,-26.231846,163.100008>,<47.684275,-25.003727,165.433195>,<48.717906,-24.667873,163.100009>}
      triangle {<48.635508,-26.870663,165.433195>,<48.031519,-27.309490,168.402772>,<46.974223,-25.234440,168.402773>}
      triangle {<48.635508,-26.870663,165.433195>,<46.974223,-25.234440,168.402773>,<47.684275,-25.003727,165.433195>}
      triangle {<48.031519,-27.309490,168.402772>,<47.656901,-27.581669,171.560601>,<46.533839,-25.377514,171.560617>}
      triangle {<48.031519,-27.309490,168.402772>,<46.533839,-25.377514,171.560617>,<46.974223,-25.234440,168.402773>}
      triangle {<47.656901,-27.581669,171.560601>,<47.465785,-27.720524,174.458649>,<46.309153,-25.450520,174.458659>}
      triangle {<47.656901,-27.581669,171.560601>,<46.309153,-25.450520,174.458659>,<46.533839,-25.377514,171.560617>}
      triangle {<47.465785,-27.720524,174.458649>,<47.412272,-27.759403,176.648766>,<46.246256,-25.470966,176.648766>}
      triangle {<47.465785,-27.720524,174.458649>,<46.246256,-25.470966,176.648766>,<46.309153,-25.450520,174.458659>}
      triangle {<47.412272,-27.759403,176.648766>,<47.749629,-27.514301,176.648766>,<46.642832,-25.342106,176.648766>}
      triangle {<47.412272,-27.759403,176.648766>,<46.642832,-25.342106,176.648766>,<46.246256,-25.470966,176.648766>}
      triangle {<47.749629,-27.514301,176.648766>,<47.838267,-27.449894,173.645400>,<46.747050,-25.308247,173.645400>}
      triangle {<47.749629,-27.514301,176.648766>,<46.747050,-25.308247,173.645400>,<46.642832,-25.342106,176.648766>}
      triangle {<47.838267,-27.449894,173.645400>,<48.080515,-27.273891,170.428505>,<47.031840,-25.215710,170.428522>}
      triangle {<47.838267,-27.449894,173.645400>,<47.031840,-25.215710,170.428522>,<46.747050,-25.308247,173.645400>}
      triangle {<48.080515,-27.273891,170.428505>,<48.525187,-26.950817,167.371017>,<47.554575,-25.045864,167.371029>}
      triangle {<48.080515,-27.273891,170.428505>,<47.554575,-25.045864,167.371029>,<47.031840,-25.215710,170.428522>}
      triangle {<48.525187,-26.950817,167.371017>,<49.221079,-26.445225,164.845853>,<48.372645,-24.780056,164.845853>}
      triangle {<48.525187,-26.950817,167.371017>,<48.372645,-24.780056,164.845853>,<47.554575,-25.045864,167.371029>}
      triangle {<49.221079,-26.445225,164.845853>,<50.217005,-25.721645,163.225939>,<49.543437,-24.399647,163.225940>}
      triangle {<49.221079,-26.445225,164.845853>,<49.543437,-24.399647,163.225940>,<48.372645,-24.780056,164.845853>}
      triangle {<50.217005,-25.721645,163.225939>,<51.561778,-24.744625,162.884233>,<51.124278,-23.885998,162.884232>}
      triangle {<50.217005,-25.721645,163.225939>,<51.124278,-23.885998,162.884232>,<49.543437,-24.399647,163.225940>}
      triangle {<51.561778,-24.744625,162.884233>,<51.540934,-24.759754,155.274646>,<51.099802,-23.893948,155.274646>}
      triangle {<51.561778,-24.744625,162.884233>,<51.099802,-23.893948,155.274646>,<51.124278,-23.885998,162.884232>}
      triangle {<51.540934,-24.759754,155.274646>,<50.715205,-25.359692,155.274646>,<50.129084,-24.209354,155.274646>}
      triangle {<51.540934,-24.759754,155.274646>,<50.129084,-24.209354,155.274646>,<51.099802,-23.893948,155.274646>}
      triangle {<50.129084,-24.209354,155.274646>,<50.129084,-24.209354,161.851296>,<49.927119,-22.934216,161.851264>}
      triangle {<50.129084,-24.209354,155.274646>,<49.927119,-22.934216,161.851264>,<49.927119,-22.934216,155.274646>}
      triangle {<50.129084,-24.209354,161.851296>,<48.717906,-24.667873,163.100009>,<48.443308,-22.934216,163.100008>}
      triangle {<50.129084,-24.209354,161.851296>,<48.443308,-22.934216,163.100008>,<49.927119,-22.934216,161.851264>}
      triangle {<48.717906,-24.667873,163.100009>,<47.684275,-25.003727,165.433195>,<47.356486,-22.934216,165.433195>}
      triangle {<48.717906,-24.667873,163.100009>,<47.356486,-22.934216,165.433195>,<48.443308,-22.934216,163.100008>}
      triangle {<47.684275,-25.003727,165.433195>,<46.974223,-25.234440,168.402773>,<46.609904,-22.934216,168.402772>}
      triangle {<47.684275,-25.003727,165.433195>,<46.609904,-22.934216,168.402772>,<47.356486,-22.934216,165.433195>}
      triangle {<46.974223,-25.234440,168.402773>,<46.533839,-25.377514,171.560617>,<46.146861,-22.934216,171.560601>}
      triangle {<46.974223,-25.234440,168.402773>,<46.146861,-22.934216,171.560601>,<46.609904,-22.934216,168.402772>}
      triangle {<46.533839,-25.377514,171.560617>,<46.309153,-25.450520,174.458659>,<45.910609,-22.934216,174.458659>}
      triangle {<46.533839,-25.377514,171.560617>,<45.910609,-22.934216,174.458659>,<46.146861,-22.934216,171.560601>}
      triangle {<46.309153,-25.450520,174.458659>,<46.246256,-25.470966,176.648766>,<45.844462,-22.934216,176.648767>}
      triangle {<46.309153,-25.450520,174.458659>,<45.844462,-22.934216,176.648767>,<45.910609,-22.934216,174.458659>}
      triangle {<46.246256,-25.470966,176.648766>,<46.642832,-25.342106,176.648766>,<46.261469,-22.934216,176.648767>}
      triangle {<46.246256,-25.470966,176.648766>,<46.261469,-22.934216,176.648767>,<45.844462,-22.934216,176.648767>}
      triangle {<46.642832,-25.342106,176.648766>,<46.747050,-25.308247,173.645400>,<46.371043,-22.934216,173.645401>}
      triangle {<46.642832,-25.342106,176.648766>,<46.371043,-22.934216,173.645401>,<46.261469,-22.934216,176.648767>}
      triangle {<46.747050,-25.308247,173.645400>,<47.031840,-25.215710,170.428522>,<46.670481,-22.934216,170.428505>}
      triangle {<46.747050,-25.308247,173.645400>,<46.670481,-22.934216,170.428505>,<46.371043,-22.934216,173.645401>}
      triangle {<47.031840,-25.215710,170.428522>,<47.554575,-25.045864,167.371029>,<47.220118,-22.934216,167.371029>}
      triangle {<47.031840,-25.215710,170.428522>,<47.220118,-22.934216,167.371029>,<46.670481,-22.934216,170.428505>}
      triangle {<47.554575,-25.045864,167.371029>,<48.372645,-24.780056,164.845853>,<48.080287,-22.934216,164.845853>}
      triangle {<47.554575,-25.045864,167.371029>,<48.080287,-22.934216,164.845853>,<47.220118,-22.934216,167.371029>}
      triangle {<48.372645,-24.780056,164.845853>,<49.543437,-24.399647,163.225940>,<49.311320,-22.934216,163.225939>}
      triangle {<48.372645,-24.780056,164.845853>,<49.311320,-22.934216,163.225939>,<48.080287,-22.934216,164.845853>}
      triangle {<49.543437,-24.399647,163.225940>,<51.124278,-23.885998,162.884232>,<50.973521,-22.934216,162.884232>}
      triangle {<49.543437,-24.399647,163.225940>,<50.973521,-22.934216,162.884232>,<49.311320,-22.934216,163.225939>}
      triangle {<51.124278,-23.885998,162.884232>,<51.099802,-23.893948,155.274646>,<50.947779,-22.934216,155.274646>}
      triangle {<51.124278,-23.885998,162.884232>,<50.947779,-22.934216,155.274646>,<50.973521,-22.934216,162.884232>}
      triangle {<51.099802,-23.893948,155.274646>,<50.129084,-24.209354,155.274646>,<49.927119,-22.934216,155.274646>}
      triangle {<51.099802,-23.893948,155.274646>,<49.927119,-22.934216,155.274646>,<50.947779,-22.934216,155.274646>}
      triangle {<49.927119,-22.934216,155.274646>,<49.927119,-22.934216,161.851264>,<50.129084,-21.659061,161.851297>}
      triangle {<49.927119,-22.934216,155.274646>,<50.129084,-21.659061,161.851297>,<50.129084,-21.659061,155.274646>}
      triangle {<49.927119,-22.934216,161.851264>,<48.443308,-22.934216,163.100008>,<48.717906,-21.200542,163.100009>}
      triangle {<49.927119,-22.934216,161.851264>,<48.717906,-21.200542,163.100009>,<50.129084,-21.659061,161.851297>}
      triangle {<48.443308,-22.934216,163.100008>,<47.356486,-22.934216,165.433195>,<47.684275,-20.864697,165.433196>}
      triangle {<48.443308,-22.934216,163.100008>,<47.684275,-20.864697,165.433196>,<48.717906,-21.200542,163.100009>}
      triangle {<47.356486,-22.934216,165.433195>,<46.609904,-22.934216,168.402772>,<46.974223,-20.633991,168.402772>}
      triangle {<47.356486,-22.934216,165.433195>,<46.974223,-20.633991,168.402772>,<47.684275,-20.864697,165.433196>}
      triangle {<46.609904,-22.934216,168.402772>,<46.146861,-22.934216,171.560601>,<46.533839,-20.490902,171.560601>}
      triangle {<46.609904,-22.934216,168.402772>,<46.533839,-20.490902,171.560601>,<46.974223,-20.633991,168.402772>}
      triangle {<46.146861,-22.934216,171.560601>,<45.910609,-22.934216,174.458659>,<46.309153,-20.417896,174.458659>}
      triangle {<46.146861,-22.934216,171.560601>,<46.309153,-20.417896,174.458659>,<46.533839,-20.490902,171.560601>}
      triangle {<45.910609,-22.934216,174.458659>,<45.844462,-22.934216,176.648767>,<46.246256,-20.397457,176.648767>}
      triangle {<45.910609,-22.934216,174.458659>,<46.246256,-20.397457,176.648767>,<46.309153,-20.417896,174.458659>}
      triangle {<45.844462,-22.934216,176.648767>,<46.261469,-22.934216,176.648767>,<46.642832,-20.526318,176.648767>}
      triangle {<45.844462,-22.934216,176.648767>,<46.642832,-20.526318,176.648767>,<46.246256,-20.397457,176.648767>}
      triangle {<46.261469,-22.934216,176.648767>,<46.371043,-22.934216,173.645401>,<46.747050,-20.560177,173.645400>}
      triangle {<46.261469,-22.934216,176.648767>,<46.747050,-20.560177,173.645400>,<46.642832,-20.526318,176.648767>}
      triangle {<46.371043,-22.934216,173.645401>,<46.670481,-22.934216,170.428505>,<47.031840,-20.652706,170.428505>}
      triangle {<46.371043,-22.934216,173.645401>,<47.031840,-20.652706,170.428505>,<46.747050,-20.560177,173.645400>}
      triangle {<46.670481,-22.934216,170.428505>,<47.220118,-22.934216,167.371029>,<47.554575,-20.822552,167.371030>}
      triangle {<46.670481,-22.934216,170.428505>,<47.554575,-20.822552,167.371030>,<47.031840,-20.652706,170.428505>}
      triangle {<47.220118,-22.934216,167.371029>,<48.080287,-22.934216,164.845853>,<48.372645,-21.088360,164.845854>}
      triangle {<47.220118,-22.934216,167.371029>,<48.372645,-21.088360,164.845854>,<47.554575,-20.822552,167.371030>}
      triangle {<48.080287,-22.934216,164.845853>,<49.311320,-22.934216,163.225939>,<49.543437,-21.468777,163.225940>}
      triangle {<48.080287,-22.934216,164.845853>,<49.543437,-21.468777,163.225940>,<48.372645,-21.088360,164.845854>}
      triangle {<49.311320,-22.934216,163.225939>,<50.973521,-22.934216,162.884232>,<51.124278,-21.982426,162.884233>}
      triangle {<49.311320,-22.934216,163.225939>,<51.124278,-21.982426,162.884233>,<49.543437,-21.468777,163.225940>}
      triangle {<50.973521,-22.934216,162.884232>,<50.947779,-22.934216,155.274646>,<51.099802,-21.974468,155.274646>}
      triangle {<50.973521,-22.934216,162.884232>,<51.099802,-21.974468,155.274646>,<51.124278,-21.982426,162.884233>}
      triangle {<50.947779,-22.934216,155.274646>,<49.927119,-22.934216,155.274646>,<50.129084,-21.659061,155.274646>}
      triangle {<50.947779,-22.934216,155.274646>,<50.129084,-21.659061,155.274646>,<51.099802,-21.974468,155.274646>}
      triangle {<50.129084,-21.659061,155.274646>,<50.129084,-21.659061,161.851297>,<50.715205,-20.508739,161.851297>}
      triangle {<50.129084,-21.659061,155.274646>,<50.715205,-20.508739,161.851297>,<50.715205,-20.508739,155.274646>}
      triangle {<50.129084,-21.659061,161.851297>,<48.717906,-21.200542,163.100009>,<49.514781,-19.636585,163.100009>}
      triangle {<50.129084,-21.659061,161.851297>,<49.514781,-19.636585,163.100009>,<50.715205,-20.508739,161.851297>}
      triangle {<48.717906,-21.200542,163.100009>,<47.684275,-20.864697,165.433196>,<48.635508,-18.997761,165.433196>}
      triangle {<48.717906,-21.200542,163.100009>,<48.635508,-18.997761,165.433196>,<49.514781,-19.636585,163.100009>}
      triangle {<47.684275,-20.864697,165.433196>,<46.974223,-20.633991,168.402772>,<48.031519,-18.558933,168.402773>}
      triangle {<47.684275,-20.864697,165.433196>,<48.031519,-18.558933,168.402773>,<48.635508,-18.997761,165.433196>}
      triangle {<46.974223,-20.633991,168.402772>,<46.533839,-20.490902,171.560601>,<47.656901,-18.286755,171.560601>}
      triangle {<46.974223,-20.633991,168.402772>,<47.656901,-18.286755,171.560601>,<48.031519,-18.558933,168.402773>}
      triangle {<46.533839,-20.490902,171.560601>,<46.309153,-20.417896,174.458659>,<47.465785,-18.147900,174.458660>}
      triangle {<46.533839,-20.490902,171.560601>,<47.465785,-18.147900,174.458660>,<47.656901,-18.286755,171.560601>}
      triangle {<46.309153,-20.417896,174.458659>,<46.246256,-20.397457,176.648767>,<47.412272,-18.109013,176.648767>}
      triangle {<46.309153,-20.417896,174.458659>,<47.412272,-18.109013,176.648767>,<47.465785,-18.147900,174.458660>}
      triangle {<46.246256,-20.397457,176.648767>,<46.642832,-20.526318,176.648767>,<47.749629,-18.354122,176.648767>}
      triangle {<46.246256,-20.397457,176.648767>,<47.749629,-18.354122,176.648767>,<47.412272,-18.109013,176.648767>}
      triangle {<46.642832,-20.526318,176.648767>,<46.747050,-20.560177,173.645400>,<47.838267,-18.418522,173.645417>}
      triangle {<46.642832,-20.526318,176.648767>,<47.838267,-18.418522,173.645417>,<47.749629,-18.354122,176.648767>}
      triangle {<46.747050,-20.560177,173.645400>,<47.031840,-20.652706,170.428505>,<48.080515,-18.594532,170.428522>}
      triangle {<46.747050,-20.560177,173.645400>,<48.080515,-18.594532,170.428522>,<47.838267,-18.418522,173.645417>}
      triangle {<47.031840,-20.652706,170.428505>,<47.554575,-20.822552,167.371030>,<48.525187,-18.917599,167.371030>}
      triangle {<47.031840,-20.652706,170.428505>,<48.525187,-18.917599,167.371030>,<48.080515,-18.594532,170.428522>}
      triangle {<47.554575,-20.822552,167.371030>,<48.372645,-21.088360,164.845854>,<49.221079,-19.423199,164.845854>}
      triangle {<47.554575,-20.822552,167.371030>,<49.221079,-19.423199,164.845854>,<48.525187,-18.917599,167.371030>}
      triangle {<48.372645,-21.088360,164.845854>,<49.543437,-21.468777,163.225940>,<50.217005,-20.146786,163.225940>}
      triangle {<48.372645,-21.088360,164.845854>,<50.217005,-20.146786,163.225940>,<49.221079,-19.423199,164.845854>}
      triangle {<49.543437,-21.468777,163.225940>,<51.124278,-21.982426,162.884233>,<51.561778,-21.123798,162.884232>}
      triangle {<49.543437,-21.468777,163.225940>,<51.561778,-21.123798,162.884232>,<50.217005,-20.146786,163.225940>}
      triangle {<51.124278,-21.982426,162.884233>,<51.099802,-21.974468,155.274646>,<51.540934,-21.108662,155.274646>}
      triangle {<51.124278,-21.982426,162.884233>,<51.540934,-21.108662,155.274646>,<51.561778,-21.123798,162.884232>}
      triangle {<51.099802,-21.974468,155.274646>,<50.129084,-21.659061,155.274646>,<50.715205,-20.508739,155.274646>}
      triangle {<51.099802,-21.974468,155.274646>,<50.715205,-20.508739,155.274646>,<51.540934,-21.108662,155.274646>}
      triangle {<50.715205,-20.508739,155.274646>,<50.715205,-20.508739,161.851297>,<51.628108,-19.595837,161.851297>}
      triangle {<50.715205,-20.508739,155.274646>,<51.628108,-19.595837,161.851297>,<51.628108,-19.595837,155.274646>}
      triangle {<50.715205,-20.508739,161.851297>,<49.514781,-19.636585,163.100009>,<50.755961,-18.395420,163.100009>}
      triangle {<50.715205,-20.508739,161.851297>,<50.755961,-18.395420,163.100009>,<51.628108,-19.595837,161.851297>}
      triangle {<49.514781,-19.636585,163.100009>,<48.635508,-18.997761,165.433196>,<50.117136,-17.516155,165.433196>}
      triangle {<49.514781,-19.636585,163.100009>,<50.117136,-17.516155,165.433196>,<50.755961,-18.395420,163.100009>}
      triangle {<48.635508,-18.997761,165.433196>,<48.031519,-18.558933,168.402773>,<49.678294,-16.912151,168.402773>}
      triangle {<48.635508,-18.997761,165.433196>,<49.678294,-16.912151,168.402773>,<50.117136,-17.516155,165.433196>}
      triangle {<48.031519,-18.558933,168.402773>,<47.656901,-18.286755,171.560601>,<49.406123,-16.537533,171.560601>}
      triangle {<48.031519,-18.558933,168.402773>,<49.406123,-16.537533,171.560601>,<49.678294,-16.912151,168.402773>}
      triangle {<47.656901,-18.286755,171.560601>,<47.465785,-18.147900,174.458660>,<49.267283,-16.346416,174.458659>}
      triangle {<47.656901,-18.286755,171.560601>,<49.267283,-16.346416,174.458659>,<49.406123,-16.537533,171.560601>}
      triangle {<47.465785,-18.147900,174.458660>,<47.412272,-18.109013,176.648767>,<49.228388,-16.292904,176.648778>}
      triangle {<47.465785,-18.147900,174.458660>,<49.228388,-16.292904,176.648778>,<49.267283,-16.346416,174.458659>}
      triangle {<47.412272,-18.109013,176.648767>,<47.749629,-18.354122,176.648767>,<49.473490,-16.630268,176.648779>}
      triangle {<47.412272,-18.109013,176.648767>,<49.473490,-16.630268,176.648779>,<49.228388,-16.292904,176.648778>}
      triangle {<47.749629,-18.354122,176.648767>,<47.838267,-18.418522,173.645417>,<49.537898,-16.718906,173.645401>}
      triangle {<47.749629,-18.354122,176.648767>,<49.537898,-16.718906,173.645401>,<49.473490,-16.630268,176.648779>}
      triangle {<47.838267,-18.418522,173.645417>,<48.080515,-18.594532,170.428522>,<49.713908,-16.961163,170.428505>}
      triangle {<47.838267,-18.418522,173.645417>,<49.713908,-16.961163,170.428505>,<49.537898,-16.718906,173.645401>}
      triangle {<48.080515,-18.594532,170.428522>,<48.525187,-18.917599,167.371030>,<50.036967,-17.405834,167.371030>}
      triangle {<48.080515,-18.594532,170.428522>,<50.036967,-17.405834,167.371030>,<49.713908,-16.961163,170.428505>}
      triangle {<48.525187,-18.917599,167.371030>,<49.221079,-19.423199,164.845854>,<50.542567,-18.101719,164.845854>}
      triangle {<48.525187,-18.917599,167.371030>,<50.542567,-18.101719,164.845854>,<50.036967,-17.405834,167.371030>}
      triangle {<49.221079,-19.423199,164.845854>,<50.217005,-20.146786,163.225940>,<51.266154,-19.097645,163.225940>}
      triangle {<49.221079,-19.423199,164.845854>,<51.266154,-19.097645,163.225940>,<50.542567,-18.101719,164.845854>}
      triangle {<50.217005,-20.146786,163.225940>,<51.561778,-21.123798,162.884232>,<52.243174,-20.442402,162.884232>}
      triangle {<50.217005,-20.146786,163.225940>,<52.243174,-20.442402,162.884232>,<51.266154,-19.097645,163.225940>}
      triangle {<51.561778,-21.123798,162.884232>,<51.540934,-21.108662,155.274646>,<52.228037,-20.421566,155.274646>}
      triangle {<51.561778,-21.123798,162.884232>,<52.228037,-20.421566,155.274646>,<52.243174,-20.442402,162.884232>}
      triangle {<51.540934,-21.108662,155.274646>,<50.715205,-20.508739,155.274646>,<51.628108,-19.595837,155.274646>}
      triangle {<51.540934,-21.108662,155.274646>,<51.628108,-19.595837,155.274646>,<52.228037,-20.421566,155.274646>}
      triangle {<51.628108,-19.595837,155.274646>,<51.628108,-19.595837,161.851297>,<52.778437,-19.009708,161.851296>}
      triangle {<51.628108,-19.595837,155.274646>,<52.778437,-19.009708,161.851296>,<52.778437,-19.009708,155.274646>}
      triangle {<51.628108,-19.595837,161.851297>,<50.755961,-18.395420,163.100009>,<52.319926,-17.598537,163.100009>}
      triangle {<51.628108,-19.595837,161.851297>,<52.319926,-17.598537,163.100009>,<52.778437,-19.009708,161.851296>}
      triangle {<50.755961,-18.395420,163.100009>,<50.117136,-17.516155,165.433196>,<51.984065,-16.564899,165.433196>}
      triangle {<50.755961,-18.395420,163.100009>,<51.984065,-16.564899,165.433196>,<52.319926,-17.598537,163.100009>}
      triangle {<50.117136,-17.516155,165.433196>,<49.678294,-16.912151,168.402773>,<51.753367,-15.854855,168.402773>}
      triangle {<50.117136,-17.516155,165.433196>,<51.753367,-15.854855,168.402773>,<51.984065,-16.564899,165.433196>}
      triangle {<49.678294,-16.912151,168.402773>,<49.406123,-16.537533,171.560601>,<51.610270,-15.414471,171.560601>}
      triangle {<49.678294,-16.912151,168.402773>,<51.610270,-15.414471,171.560601>,<51.753367,-15.854855,168.402773>}
      triangle {<49.406123,-16.537533,171.560601>,<49.267283,-16.346416,174.458659>,<51.537272,-15.189793,174.458659>}
      triangle {<49.406123,-16.537533,171.560601>,<51.537272,-15.189793,174.458659>,<51.610270,-15.414471,171.560601>}
      triangle {<49.267283,-16.346416,174.458659>,<49.228388,-16.292904,176.648778>,<51.516825,-15.126881,176.648778>}
      triangle {<49.267283,-16.346416,174.458659>,<51.516825,-15.126881,176.648778>,<51.537272,-15.189793,174.458659>}
      triangle {<49.228388,-16.292904,176.648778>,<49.473490,-16.630268,176.648779>,<51.645686,-15.523472,176.648778>}
      triangle {<49.228388,-16.292904,176.648778>,<51.645686,-15.523472,176.648778>,<51.516825,-15.126881,176.648778>}
      triangle {<49.473490,-16.630268,176.648779>,<49.537898,-16.718906,173.645401>,<51.679545,-15.627682,173.645400>}
      triangle {<49.473490,-16.630268,176.648779>,<51.679545,-15.627682,173.645400>,<51.645686,-15.523472,176.648778>}
      triangle {<49.537898,-16.718906,173.645401>,<49.713908,-16.961163,170.428505>,<51.772074,-15.912464,170.428505>}
      triangle {<49.537898,-16.718906,173.645401>,<51.772074,-15.912464,170.428505>,<51.679545,-15.627682,173.645400>}
      triangle {<49.713908,-16.961163,170.428505>,<50.036967,-17.405834,167.371030>,<51.941935,-16.435200,167.371030>}
      triangle {<49.713908,-16.961163,170.428505>,<51.941935,-16.435200,167.371030>,<51.772074,-15.912464,170.428505>}
      triangle {<50.036967,-17.405834,167.371030>,<50.542567,-18.101719,164.845854>,<52.207728,-17.253277,164.845854>}
      triangle {<50.036967,-17.405834,167.371030>,<52.207728,-17.253277,164.845854>,<51.941935,-16.435200,167.371030>}
      triangle {<50.542567,-18.101719,164.845854>,<51.266154,-19.097645,163.225940>,<52.588145,-18.424046,163.225940>}
      triangle {<50.542567,-18.101719,164.845854>,<52.588145,-18.424046,163.225940>,<52.207728,-17.253277,164.845854>}
      triangle {<51.266154,-19.097645,163.225940>,<52.243174,-20.442402,162.884232>,<53.101786,-20.004910,162.884233>}
      triangle {<51.266154,-19.097645,163.225940>,<53.101786,-20.004910,162.884233>,<52.588145,-18.424046,163.225940>}
      triangle {<52.243174,-20.442402,162.884232>,<52.228037,-20.421566,155.274646>,<53.093836,-19.980419,155.274646>}
      triangle {<52.243174,-20.442402,162.884232>,<53.093836,-19.980419,155.274646>,<53.101786,-20.004910,162.884233>}
      triangle {<52.228037,-20.421566,155.274646>,<51.628108,-19.595837,155.274646>,<52.778437,-19.009708,155.274646>}
      triangle {<52.228037,-20.421566,155.274646>,<52.778437,-19.009708,155.274646>,<53.093836,-19.980419,155.274646>}
      triangle {<52.778437,-19.009708,155.274646>,<52.778437,-19.009708,161.851296>,<54.053568,-18.807751,161.851296>}
      triangle {<52.778437,-19.009708,155.274646>,<54.053568,-18.807751,161.851296>,<54.053568,-18.807751,155.274646>}
      triangle {<52.778437,-19.009708,161.851296>,<52.319926,-17.598537,163.100009>,<54.053568,-17.323956,163.100009>}
      triangle {<52.778437,-19.009708,161.851296>,<54.053568,-17.323956,163.100009>,<54.053568,-18.807751,161.851296>}
      triangle {<52.319926,-17.598537,163.100009>,<51.984065,-16.564899,165.433196>,<54.053568,-16.237125,165.433196>}
      triangle {<52.319926,-17.598537,163.100009>,<54.053568,-16.237125,165.433196>,<54.053568,-17.323956,163.100009>}
      triangle {<51.984065,-16.564899,165.433196>,<51.753367,-15.854855,168.402773>,<54.053568,-15.490543,168.402773>}
      triangle {<51.984065,-16.564899,165.433196>,<54.053568,-15.490543,168.402773>,<54.053568,-16.237125,165.433196>}
      triangle {<51.753367,-15.854855,168.402773>,<51.610270,-15.414471,171.560601>,<54.053568,-15.027485,171.560617>}
      triangle {<51.753367,-15.854855,168.402773>,<54.053568,-15.027485,171.560617>,<54.053568,-15.490543,168.402773>}
      triangle {<51.610270,-15.414471,171.560601>,<51.537272,-15.189793,174.458659>,<54.053568,-14.791248,174.458659>}
      triangle {<51.610270,-15.414471,171.560601>,<54.053568,-14.791248,174.458659>,<54.053568,-15.027485,171.560617>}
      triangle {<51.537272,-15.189793,174.458659>,<51.516825,-15.126881,176.648778>,<54.053568,-14.725109,176.648778>}
      triangle {<51.537272,-15.189793,174.458659>,<54.053568,-14.725109,176.648778>,<54.053568,-14.791248,174.458659>}
      triangle {<51.516825,-15.126881,176.648778>,<51.645686,-15.523472,176.648778>,<54.053568,-15.142109,176.648778>}
      triangle {<51.516825,-15.126881,176.648778>,<54.053568,-15.142109,176.648778>,<54.053568,-14.725109,176.648778>}
      triangle {<51.645686,-15.523472,176.648778>,<51.679545,-15.627682,173.645400>,<54.053568,-15.251667,173.645400>}
      triangle {<51.645686,-15.523472,176.648778>,<54.053568,-15.251667,173.645400>,<54.053568,-15.142109,176.648778>}
      triangle {<51.679545,-15.627682,173.645400>,<51.772074,-15.912464,170.428505>,<54.053568,-15.551113,170.428505>}
      triangle {<51.679545,-15.627682,173.645400>,<54.053568,-15.551113,170.428505>,<54.053568,-15.251667,173.645400>}
      triangle {<51.772074,-15.912464,170.428505>,<51.941935,-16.435200,167.371030>,<54.053568,-16.100758,167.371030>}
      triangle {<51.772074,-15.912464,170.428505>,<54.053568,-16.100758,167.371030>,<54.053568,-15.551113,170.428505>}
      triangle {<51.941935,-16.435200,167.371030>,<52.207728,-17.253277,164.845854>,<54.053568,-16.960926,164.845854>}
      triangle {<51.941935,-16.435200,167.371030>,<54.053568,-16.960926,164.845854>,<54.053568,-16.100758,167.371030>}
      triangle {<52.207728,-17.253277,164.845854>,<52.588145,-18.424046,163.225940>,<54.053568,-18.191959,163.225940>}
      triangle {<52.207728,-17.253277,164.845854>,<54.053568,-18.191959,163.225940>,<54.053568,-16.960926,164.845854>}
      triangle {<52.588145,-18.424046,163.225940>,<53.101786,-20.004910,162.884233>,<54.053568,-19.854160,162.884233>}
      triangle {<52.588145,-18.424046,163.225940>,<54.053568,-19.854160,162.884233>,<54.053568,-18.191959,163.225940>}
      triangle {<53.101786,-20.004910,162.884233>,<53.093836,-19.980419,155.274646>,<54.053568,-19.828411,155.274646>}
      triangle {<53.101786,-20.004910,162.884233>,<54.053568,-19.828411,155.274646>,<54.053568,-19.854160,162.884233>}
      triangle {<53.093836,-19.980419,155.274646>,<52.778437,-19.009708,155.274646>,<54.053568,-18.807751,155.274646>}
      triangle {<53.093836,-19.980419,155.274646>,<54.053568,-18.807751,155.274646>,<54.053568,-19.828411,155.274646>}
      triangle {<54.053568,-18.807751,155.274646>,<54.053568,-18.807751,161.851296>,<55.328730,-19.009708,161.851296>}
      triangle {<54.053568,-18.807751,155.274646>,<55.328730,-19.009708,161.851296>,<55.328730,-19.009708,155.274646>}
      triangle {<54.053568,-18.807751,161.851296>,<54.053568,-17.323956,163.100009>,<55.787241,-17.598537,163.100009>}
      triangle {<54.053568,-18.807751,161.851296>,<55.787241,-17.598537,163.100009>,<55.328730,-19.009708,161.851296>}
      triangle {<54.053568,-17.323956,163.100009>,<54.053568,-16.237125,165.433196>,<56.123087,-16.564899,165.433196>}
      triangle {<54.053568,-17.323956,163.100009>,<56.123087,-16.564899,165.433196>,<55.787241,-17.598537,163.100009>}
      triangle {<54.053568,-16.237125,165.433196>,<54.053568,-15.490543,168.402773>,<56.353800,-15.854855,168.402773>}
      triangle {<54.053568,-16.237125,165.433196>,<56.353800,-15.854855,168.402773>,<56.123087,-16.564899,165.433196>}
      triangle {<54.053568,-15.490543,168.402773>,<54.053568,-15.027485,171.560617>,<56.496897,-15.414471,171.560601>}
      triangle {<54.053568,-15.490543,168.402773>,<56.496897,-15.414471,171.560601>,<56.353800,-15.854855,168.402773>}
      triangle {<54.053568,-15.027485,171.560617>,<54.053568,-14.791248,174.458659>,<56.569895,-15.189793,174.458659>}
      triangle {<54.053568,-15.027485,171.560617>,<56.569895,-15.189793,174.458659>,<56.496897,-15.414471,171.560601>}
      triangle {<54.053568,-14.791248,174.458659>,<54.053568,-14.725109,176.648778>,<56.590342,-15.126881,176.648778>}
      triangle {<54.053568,-14.791248,174.458659>,<56.590342,-15.126881,176.648778>,<56.569895,-15.189793,174.458659>}
      triangle {<54.053568,-14.725109,176.648778>,<54.053568,-15.142109,176.648778>,<56.461466,-15.523472,176.648778>}
      triangle {<54.053568,-14.725109,176.648778>,<56.461466,-15.523472,176.648778>,<56.590342,-15.126881,176.648778>}
      triangle {<54.053568,-15.142109,176.648778>,<54.053568,-15.251667,173.645400>,<56.427622,-15.627682,173.645400>}
      triangle {<54.053568,-15.142109,176.648778>,<56.427622,-15.627682,173.645400>,<56.461466,-15.523472,176.648778>}
      triangle {<54.053568,-15.251667,173.645400>,<54.053568,-15.551113,170.428505>,<56.335093,-15.912464,170.428505>}
      triangle {<54.053568,-15.251667,173.645400>,<56.335093,-15.912464,170.428505>,<56.427622,-15.627682,173.645400>}
      triangle {<54.053568,-15.551113,170.428505>,<54.053568,-16.100758,167.371030>,<56.165232,-16.435200,167.371030>}
      triangle {<54.053568,-15.551113,170.428505>,<56.165232,-16.435200,167.371030>,<56.335093,-15.912464,170.428505>}
      triangle {<54.053568,-16.100758,167.371030>,<54.053568,-16.960926,164.845854>,<55.899424,-17.253277,164.845854>}
      triangle {<54.053568,-16.100758,167.371030>,<55.899424,-17.253277,164.845854>,<56.165232,-16.435200,167.371030>}
      triangle {<54.053568,-16.960926,164.845854>,<54.053568,-18.191959,163.225940>,<55.519022,-18.424046,163.225940>}
      triangle {<54.053568,-16.960926,164.845854>,<55.519022,-18.424046,163.225940>,<55.899424,-17.253277,164.845854>}
      triangle {<54.053568,-18.191959,163.225940>,<54.053568,-19.854160,162.884233>,<55.005381,-20.004910,162.884233>}
      triangle {<54.053568,-18.191959,163.225940>,<55.005381,-20.004910,162.884233>,<55.519022,-18.424046,163.225940>}
      triangle {<54.053568,-19.854160,162.884233>,<54.053568,-19.828411,155.274646>,<55.013331,-19.980412,155.274646>}
      triangle {<54.053568,-19.854160,162.884233>,<55.013331,-19.980412,155.274646>,<55.005381,-20.004910,162.884233>}
      triangle {<54.053568,-19.828411,155.274646>,<54.053568,-18.807751,155.274646>,<55.328730,-19.009708,155.274646>}
      triangle {<54.053568,-19.828411,155.274646>,<55.328730,-19.009708,155.274646>,<55.013331,-19.980412,155.274646>}
      triangle {<55.328730,-19.009708,155.274646>,<55.328730,-19.009708,161.851296>,<56.479044,-19.595837,161.851297>}
      triangle {<55.328730,-19.009708,155.274646>,<56.479044,-19.595837,161.851297>,<56.479044,-19.595829,155.274646>}
      triangle {<55.328730,-19.009708,161.851296>,<55.787241,-17.598537,163.100009>,<57.351206,-18.395420,163.100009>}
      triangle {<55.328730,-19.009708,161.851296>,<57.351206,-18.395420,163.100009>,<56.479044,-19.595837,161.851297>}
      triangle {<55.787241,-17.598537,163.100009>,<56.123087,-16.564899,165.433196>,<57.990031,-17.516163,165.433196>}
      triangle {<55.787241,-17.598537,163.100009>,<57.990031,-17.516163,165.433196>,<57.351206,-18.395420,163.100009>}
      triangle {<56.123087,-16.564899,165.433196>,<56.353800,-15.854855,168.402773>,<58.428874,-16.912159,168.402773>}
      triangle {<56.123087,-16.564899,165.433196>,<58.428874,-16.912159,168.402773>,<57.990031,-17.516163,165.433196>}
      triangle {<56.353800,-15.854855,168.402773>,<56.496897,-15.414471,171.560601>,<58.701029,-16.537533,171.560601>}
      triangle {<56.353800,-15.854855,168.402773>,<58.701029,-16.537533,171.560601>,<58.428874,-16.912159,168.402773>}
      triangle {<56.496897,-15.414471,171.560601>,<56.569895,-15.189793,174.458659>,<58.839900,-16.346416,174.458659>}
      triangle {<56.496897,-15.414471,171.560601>,<58.839900,-16.346416,174.458659>,<58.701029,-16.537533,171.560601>}
      triangle {<56.569895,-15.189793,174.458659>,<56.590342,-15.126881,176.648778>,<58.878764,-16.292904,176.648778>}
      triangle {<56.569895,-15.189793,174.458659>,<58.878764,-16.292904,176.648778>,<58.839900,-16.346416,174.458659>}
      triangle {<56.590342,-15.126881,176.648778>,<56.461466,-15.523472,176.648778>,<58.633662,-16.630268,176.648779>}
      triangle {<56.590342,-15.126881,176.648778>,<58.633662,-16.630268,176.648779>,<58.878764,-16.292904,176.648778>}
      triangle {<56.461466,-15.523472,176.648778>,<56.427622,-15.627682,173.645400>,<58.569254,-16.718914,173.645401>}
      triangle {<56.461466,-15.523472,176.648778>,<58.569254,-16.718914,173.645401>,<58.633662,-16.630268,176.648779>}
      triangle {<56.427622,-15.627682,173.645400>,<56.335093,-15.912464,170.428505>,<58.393260,-16.961163,170.428505>}
      triangle {<56.427622,-15.627682,173.645400>,<58.393260,-16.961163,170.428505>,<58.569254,-16.718914,173.645401>}
      triangle {<56.335093,-15.912464,170.428505>,<56.165232,-16.435200,167.371030>,<58.070185,-17.405834,167.371030>}
      triangle {<56.335093,-15.912464,170.428505>,<58.070185,-17.405834,167.371030>,<58.393260,-16.961163,170.428505>}
      triangle {<56.165232,-16.435200,167.371030>,<55.899424,-17.253277,164.845854>,<57.564585,-18.101719,164.845854>}
      triangle {<56.165232,-16.435200,167.371030>,<57.564585,-18.101719,164.845854>,<58.070185,-17.405834,167.371030>}
      triangle {<55.899424,-17.253277,164.845854>,<55.519022,-18.424046,163.225940>,<56.841013,-19.097645,163.225940>}
      triangle {<55.899424,-17.253277,164.845854>,<56.841013,-19.097645,163.225940>,<57.564585,-18.101719,164.845854>}
      triangle {<55.519022,-18.424046,163.225940>,<55.005381,-20.004910,162.884233>,<55.863993,-20.442402,162.884232>}
      triangle {<55.519022,-18.424046,163.225940>,<55.863993,-20.442402,162.884232>,<56.841013,-19.097645,163.225940>}
      triangle {<55.005381,-20.004910,162.884233>,<55.013331,-19.980412,155.274646>,<55.879130,-20.421566,155.274646>}
      triangle {<55.005381,-20.004910,162.884233>,<55.879130,-20.421566,155.274646>,<55.863993,-20.442402,162.884232>}
      triangle {<55.013331,-19.980412,155.274646>,<55.328730,-19.009708,155.274646>,<56.479044,-19.595829,155.274646>}
      triangle {<55.013331,-19.980412,155.274646>,<56.479044,-19.595829,155.274646>,<55.879130,-20.421566,155.274646>}
      triangle {<56.479044,-19.595829,155.274646>,<56.479044,-19.595837,161.851297>,<57.391963,-20.508739,161.851297>}
      triangle {<56.479044,-19.595829,155.274646>,<57.391963,-20.508739,161.851297>,<57.391963,-20.508739,155.274646>}
      triangle {<56.479044,-19.595837,161.851297>,<57.351206,-18.395420,163.100009>,<58.592387,-19.636593,163.100009>}
      triangle {<56.479044,-19.595837,161.851297>,<58.592387,-19.636593,163.100009>,<57.391963,-20.508739,161.851297>}
      triangle {<57.351206,-18.395420,163.100009>,<57.990031,-17.516163,165.433196>,<59.471644,-18.997768,165.433196>}
      triangle {<57.351206,-18.395420,163.100009>,<59.471644,-18.997768,165.433196>,<58.592387,-19.636593,163.100009>}
      triangle {<57.990031,-17.516163,165.433196>,<58.428874,-16.912159,168.402773>,<60.075648,-18.558933,168.402773>}
      triangle {<57.990031,-17.516163,165.433196>,<60.075648,-18.558933,168.402773>,<59.471644,-18.997768,165.433196>}
      triangle {<58.428874,-16.912159,168.402773>,<58.701029,-16.537533,171.560601>,<60.450266,-18.286755,171.560601>}
      triangle {<58.428874,-16.912159,168.402773>,<60.450266,-18.286755,171.560601>,<60.075648,-18.558933,168.402773>}
      triangle {<58.701029,-16.537533,171.560601>,<58.839900,-16.346416,174.458659>,<60.641383,-18.147900,174.458660>}
      triangle {<58.701029,-16.537533,171.560601>,<60.641383,-18.147900,174.458660>,<60.450266,-18.286755,171.560601>}
      triangle {<58.839900,-16.346416,174.458659>,<58.878764,-16.292904,176.648778>,<60.694895,-18.109020,176.648767>}
      triangle {<58.839900,-16.346416,174.458659>,<60.694895,-18.109020,176.648767>,<60.641383,-18.147900,174.458660>}
      triangle {<58.878764,-16.292904,176.648778>,<58.633662,-16.630268,176.648779>,<60.357523,-18.354122,176.648767>}
      triangle {<58.878764,-16.292904,176.648778>,<60.357523,-18.354122,176.648767>,<60.694895,-18.109020,176.648767>}
      triangle {<58.633662,-16.630268,176.648779>,<58.569254,-16.718914,173.645401>,<60.268885,-18.418530,173.645417>}
      triangle {<58.633662,-16.630268,176.648779>,<60.268885,-18.418530,173.645417>,<60.357523,-18.354122,176.648767>}
      triangle {<58.569254,-16.718914,173.645401>,<58.393260,-16.961163,170.428505>,<60.026637,-18.594532,170.428522>}
      triangle {<58.569254,-16.718914,173.645401>,<60.026637,-18.594532,170.428522>,<60.268885,-18.418530,173.645417>}
      triangle {<58.393260,-16.961163,170.428505>,<58.070185,-17.405834,167.371030>,<59.581965,-18.917606,167.371030>}
      triangle {<58.393260,-16.961163,170.428505>,<59.581965,-18.917606,167.371030>,<60.026637,-18.594532,170.428522>}
      triangle {<58.070185,-17.405834,167.371030>,<57.564585,-18.101719,164.845854>,<58.886088,-19.423199,164.845854>}
      triangle {<58.070185,-17.405834,167.371030>,<58.886088,-19.423199,164.845854>,<59.581965,-18.917606,167.371030>}
      triangle {<57.564585,-18.101719,164.845854>,<56.841013,-19.097645,163.225940>,<57.890147,-20.146786,163.225940>}
      triangle {<57.564585,-18.101719,164.845854>,<57.890147,-20.146786,163.225940>,<58.886088,-19.423199,164.845854>}
      triangle {<56.841013,-19.097645,163.225940>,<55.863993,-20.442402,162.884232>,<56.545390,-21.123806,162.884232>}
      triangle {<56.841013,-19.097645,163.225940>,<56.545390,-21.123806,162.884232>,<57.890147,-20.146786,163.225940>}
      triangle {<55.863993,-20.442402,162.884232>,<55.879130,-20.421566,155.274646>,<56.566233,-21.108662,155.274646>}
      triangle {<55.863993,-20.442402,162.884232>,<56.566233,-21.108662,155.274646>,<56.545390,-21.123806,162.884232>}
      triangle {<55.879130,-20.421566,155.274646>,<56.479044,-19.595829,155.274646>,<57.391963,-20.508739,155.274646>}
      triangle {<55.879130,-20.421566,155.274646>,<57.391963,-20.508739,155.274646>,<56.566233,-21.108662,155.274646>}
      triangle {<57.391963,-20.508739,155.274646>,<57.391963,-20.508739,161.851297>,<57.978068,-21.659061,161.851297>}
      triangle {<57.391963,-20.508739,155.274646>,<57.978068,-21.659061,161.851297>,<57.978068,-21.659061,155.274646>}
      triangle {<57.391963,-20.508739,161.851297>,<58.592387,-19.636593,163.100009>,<59.389262,-21.200542,163.100009>}
      triangle {<57.391963,-20.508739,161.851297>,<59.389262,-21.200542,163.100009>,<57.978068,-21.659061,161.851297>}
      triangle {<58.592387,-19.636593,163.100009>,<59.471644,-18.997768,165.433196>,<60.422892,-20.864697,165.433196>}
      triangle {<58.592387,-19.636593,163.100009>,<60.422892,-20.864697,165.433196>,<59.389262,-21.200542,163.100009>}
      triangle {<59.471644,-18.997768,165.433196>,<60.075648,-18.558933,168.402773>,<61.132929,-20.633991,168.402772>}
      triangle {<59.471644,-18.997768,165.433196>,<61.132929,-20.633991,168.402772>,<60.422892,-20.864697,165.433196>}
      triangle {<60.075648,-18.558933,168.402773>,<60.450266,-18.286755,171.560601>,<61.573313,-20.490902,171.560601>}
      triangle {<60.075648,-18.558933,168.402773>,<61.573313,-20.490902,171.560601>,<61.132929,-20.633991,168.402772>}
      triangle {<60.450266,-18.286755,171.560601>,<60.641383,-18.147900,174.458660>,<61.797984,-20.417896,174.458659>}
      triangle {<60.450266,-18.286755,171.560601>,<61.797984,-20.417896,174.458659>,<61.573313,-20.490902,171.560601>}
      triangle {<60.641383,-18.147900,174.458660>,<60.694895,-18.109020,176.648767>,<61.860911,-20.397457,176.648767>}
      triangle {<60.641383,-18.147900,174.458660>,<61.860911,-20.397457,176.648767>,<61.797984,-20.417896,174.458659>}
      triangle {<60.694895,-18.109020,176.648767>,<60.357523,-18.354122,176.648767>,<61.464304,-20.526318,176.648767>}
      triangle {<60.694895,-18.109020,176.648767>,<61.464304,-20.526318,176.648767>,<61.860911,-20.397457,176.648767>}
      triangle {<60.357523,-18.354122,176.648767>,<60.268885,-18.418530,173.645417>,<61.360117,-20.560177,173.645400>}
      triangle {<60.357523,-18.354122,176.648767>,<61.360117,-20.560177,173.645400>,<61.464304,-20.526318,176.648767>}
      triangle {<60.268885,-18.418530,173.645417>,<60.026637,-18.594532,170.428522>,<61.075327,-20.652714,170.428505>}
      triangle {<60.268885,-18.418530,173.645417>,<61.075327,-20.652714,170.428505>,<61.360117,-20.560177,173.645400>}
      triangle {<60.026637,-18.594532,170.428522>,<59.581965,-18.917606,167.371030>,<60.552592,-20.822559,167.371030>}
      triangle {<60.026637,-18.594532,170.428522>,<60.552592,-20.822559,167.371030>,<61.075327,-20.652714,170.428505>}
      triangle {<59.581965,-18.917606,167.371030>,<58.886088,-19.423199,164.845854>,<59.734507,-21.088360,164.845854>}
      triangle {<59.581965,-18.917606,167.371030>,<59.734507,-21.088360,164.845854>,<60.552592,-20.822559,167.371030>}
      triangle {<58.886088,-19.423199,164.845854>,<57.890147,-20.146786,163.225940>,<58.563731,-21.468777,163.225940>}
      triangle {<58.886088,-19.423199,164.845854>,<58.563731,-21.468777,163.225940>,<59.734507,-21.088360,164.845854>}
      triangle {<57.890147,-20.146786,163.225940>,<56.545390,-21.123806,162.884232>,<56.982874,-21.982426,162.884233>}
      triangle {<57.890147,-20.146786,163.225940>,<56.982874,-21.982426,162.884233>,<58.563731,-21.468777,163.225940>}
      triangle {<56.545390,-21.123806,162.884232>,<56.566233,-21.108662,155.274646>,<57.007365,-21.974468,155.274646>}
      triangle {<56.545390,-21.123806,162.884232>,<57.007365,-21.974468,155.274646>,<56.982874,-21.982426,162.884233>}
      triangle {<56.566233,-21.108662,155.274646>,<57.391963,-20.508739,155.274646>,<57.978068,-21.659061,155.274646>}
      triangle {<56.566233,-21.108662,155.274646>,<57.978068,-21.659061,155.274646>,<57.007365,-21.974468,155.274646>}
      triangle {<57.978068,-21.659061,155.274646>,<57.978068,-21.659061,161.851297>,<58.180048,-22.934216,161.851264>}
      triangle {<57.978068,-21.659061,155.274646>,<58.180048,-22.934216,161.851264>,<58.180048,-22.934208,155.274646>}
      triangle {<57.978068,-21.659061,161.851297>,<59.389262,-21.200542,163.100009>,<59.663844,-22.934216,163.100008>}
      triangle {<57.978068,-21.659061,161.851297>,<59.663844,-22.934216,163.100008>,<58.180048,-22.934216,161.851264>}
      triangle {<59.389262,-21.200542,163.100009>,<60.422892,-20.864697,165.433196>,<60.750681,-22.934216,165.433195>}
      triangle {<59.389262,-21.200542,163.100009>,<60.750681,-22.934216,165.433195>,<59.663844,-22.934216,163.100008>}
      triangle {<60.422892,-20.864697,165.433196>,<61.132929,-20.633991,168.402772>,<61.497263,-22.934216,168.402772>}
      triangle {<60.422892,-20.864697,165.433196>,<61.497263,-22.934216,168.402772>,<60.750681,-22.934216,165.433195>}
      triangle {<61.132929,-20.633991,168.402772>,<61.573313,-20.490902,171.560601>,<61.960307,-22.934216,171.560601>}
      triangle {<61.132929,-20.633991,168.402772>,<61.960307,-22.934216,171.560601>,<61.497263,-22.934216,168.402772>}
      triangle {<61.573313,-20.490902,171.560601>,<61.797984,-20.417896,174.458659>,<62.196543,-22.934216,174.458659>}
      triangle {<61.573313,-20.490902,171.560601>,<62.196543,-22.934216,174.458659>,<61.960307,-22.934216,171.560601>}
      triangle {<61.797984,-20.417896,174.458659>,<61.860911,-20.397457,176.648767>,<62.262705,-22.934216,176.648767>}
      triangle {<61.797984,-20.417896,174.458659>,<62.262705,-22.934216,176.648767>,<62.196543,-22.934216,174.458659>}
      triangle {<61.860911,-20.397457,176.648767>,<61.464304,-20.526318,176.648767>,<61.845683,-22.934216,176.648767>}
      triangle {<61.860911,-20.397457,176.648767>,<61.845683,-22.934216,176.648767>,<62.262705,-22.934216,176.648767>}
      triangle {<61.464304,-20.526318,176.648767>,<61.360117,-20.560177,173.645400>,<61.736125,-22.934216,173.645401>}
      triangle {<61.464304,-20.526318,176.648767>,<61.736125,-22.934216,173.645401>,<61.845683,-22.934216,176.648767>}
      triangle {<61.360117,-20.560177,173.645400>,<61.075327,-20.652714,170.428505>,<61.436686,-22.934216,170.428505>}
      triangle {<61.360117,-20.560177,173.645400>,<61.436686,-22.934216,170.428505>,<61.736125,-22.934216,173.645401>}
      triangle {<61.075327,-20.652714,170.428505>,<60.552592,-20.822559,167.371030>,<60.887049,-22.934216,167.371029>}
      triangle {<61.075327,-20.652714,170.428505>,<60.887049,-22.934216,167.371029>,<61.436686,-22.934216,170.428505>}
      triangle {<60.552592,-20.822559,167.371030>,<59.734507,-21.088360,164.845854>,<60.026865,-22.934216,164.845853>}
      triangle {<60.552592,-20.822559,167.371030>,<60.026865,-22.934216,164.845853>,<60.887049,-22.934216,167.371029>}
      triangle {<59.734507,-21.088360,164.845854>,<58.563731,-21.468777,163.225940>,<58.795847,-22.934216,163.225939>}
      triangle {<59.734507,-21.088360,164.845854>,<58.795847,-22.934216,163.225939>,<60.026865,-22.934216,164.845853>}
      triangle {<58.563731,-21.468777,163.225940>,<56.982874,-21.982426,162.884233>,<57.133631,-22.934216,162.884232>}
      triangle {<58.563731,-21.468777,163.225940>,<57.133631,-22.934216,162.884232>,<58.795847,-22.934216,163.225939>}
      triangle {<56.982874,-21.982426,162.884233>,<57.007365,-21.974468,155.274646>,<57.159373,-22.934208,155.274646>}
      triangle {<56.982874,-21.982426,162.884233>,<57.159373,-22.934208,155.274646>,<57.133631,-22.934216,162.884232>}
      triangle {<57.007365,-21.974468,155.274646>,<57.978068,-21.659061,155.274646>,<58.180048,-22.934208,155.274646>}
      triangle {<57.007365,-21.974468,155.274646>,<58.180048,-22.934208,155.274646>,<57.159373,-22.934208,155.274646>}
      texture{_Heck09}
    }
    //_Heck11
    mesh{
      triangle {<-49.427152,-22.934208,155.274646>,<-49.427152,-22.934216,161.851264>,<-49.629125,-24.209354,161.851296>}
      triangle {<-49.427152,-22.934208,155.274646>,<-49.629125,-24.209354,161.851296>,<-49.629125,-24.209354,155.274646>}
      triangle {<-49.427152,-22.934216,161.851264>,<-47.943357,-22.934216,163.100008>,<-48.217947,-24.667873,163.100009>}
      triangle {<-49.427152,-22.934216,161.851264>,<-48.217947,-24.667873,163.100009>,<-49.629125,-24.209354,161.851296>}
      triangle {<-47.943357,-22.934216,163.100008>,<-46.856527,-22.934216,165.433195>,<-47.184316,-25.003727,165.433195>}
      triangle {<-47.943357,-22.934216,163.100008>,<-47.184316,-25.003727,165.433195>,<-48.217947,-24.667873,163.100009>}
      triangle {<-46.856527,-22.934216,165.433195>,<-46.109937,-22.934216,168.402772>,<-46.474271,-25.234440,168.402773>}
      triangle {<-46.856527,-22.934216,165.433195>,<-46.474271,-25.234440,168.402773>,<-47.184316,-25.003727,165.433195>}
      triangle {<-46.109937,-22.934216,168.402772>,<-45.646894,-22.934216,171.560601>,<-46.033880,-25.377522,171.560617>}
      triangle {<-46.109937,-22.934216,168.402772>,<-46.033880,-25.377522,171.560617>,<-46.474271,-25.234440,168.402773>}
      triangle {<-45.646894,-22.934216,171.560601>,<-45.410657,-22.934216,174.458659>,<-45.809209,-25.450527,174.458659>}
      triangle {<-45.646894,-22.934216,171.560601>,<-45.809209,-25.450527,174.458659>,<-46.033880,-25.377522,171.560617>}
      triangle {<-45.410657,-22.934216,174.458659>,<-45.344503,-22.934216,176.648767>,<-45.746297,-25.470966,176.648766>}
      triangle {<-45.410657,-22.934216,174.458659>,<-45.746297,-25.470966,176.648766>,<-45.809209,-25.450527,174.458659>}
      triangle {<-45.344503,-22.934216,176.648767>,<-45.761510,-22.934216,176.648767>,<-46.142889,-25.342113,176.648766>}
      triangle {<-45.344503,-22.934216,176.648767>,<-46.142889,-25.342113,176.648766>,<-45.746297,-25.470966,176.648766>}
      triangle {<-45.761510,-22.934216,176.648767>,<-45.871076,-22.934216,173.645401>,<-46.247091,-25.308254,173.645400>}
      triangle {<-45.761510,-22.934216,176.648767>,<-46.247091,-25.308254,173.645400>,<-46.142889,-25.342113,176.648766>}
      triangle {<-45.871076,-22.934216,173.645401>,<-46.170515,-22.934216,170.428505>,<-46.531873,-25.215710,170.428522>}
      triangle {<-45.871076,-22.934216,173.645401>,<-46.531873,-25.215710,170.428522>,<-46.247091,-25.308254,173.645400>}
      triangle {<-46.170515,-22.934216,170.428505>,<-46.720151,-22.934216,167.371029>,<-47.054616,-25.045864,167.371029>}
      triangle {<-46.170515,-22.934216,170.428505>,<-47.054616,-25.045864,167.371029>,<-46.531873,-25.215710,170.428522>}
      triangle {<-46.720151,-22.934216,167.371029>,<-47.580328,-22.934216,164.845853>,<-47.872686,-24.780056,164.845853>}
      triangle {<-46.720151,-22.934216,167.371029>,<-47.872686,-24.780056,164.845853>,<-47.054616,-25.045864,167.371029>}
      triangle {<-47.580328,-22.934216,164.845853>,<-48.811353,-22.934216,163.225939>,<-49.043462,-24.399647,163.225940>}
      triangle {<-47.580328,-22.934216,164.845853>,<-49.043462,-24.399647,163.225940>,<-47.872686,-24.780056,164.845853>}
      triangle {<-48.811353,-22.934216,163.225939>,<-50.473569,-22.934216,162.884232>,<-50.624326,-23.885998,162.884232>}
      triangle {<-48.811353,-22.934216,163.225939>,<-50.624326,-23.885998,162.884232>,<-49.043462,-24.399647,163.225940>}
      triangle {<-50.473569,-22.934216,162.884232>,<-50.447820,-22.934208,155.274646>,<-50.599828,-23.893948,155.274646>}
      triangle {<-50.473569,-22.934216,162.884232>,<-50.599828,-23.893948,155.274646>,<-50.624326,-23.885998,162.884232>}
      triangle {<-50.447820,-22.934208,155.274646>,<-49.427152,-22.934208,155.274646>,<-49.629125,-24.209354,155.274646>}
      triangle {<-50.447820,-22.934208,155.274646>,<-49.629125,-24.209354,155.274646>,<-50.599828,-23.893948,155.274646>}
      triangle {<-49.629125,-24.209354,155.274646>,<-49.629125,-24.209354,161.851296>,<-50.215238,-25.359692,161.851296>}
      triangle {<-49.629125,-24.209354,155.274646>,<-50.215238,-25.359692,161.851296>,<-50.215238,-25.359692,155.274646>}
      triangle {<-49.629125,-24.209354,161.851296>,<-48.217947,-24.667873,163.100009>,<-49.014829,-26.231846,163.100008>}
      triangle {<-49.629125,-24.209354,161.851296>,<-49.014829,-26.231846,163.100008>,<-50.215238,-25.359692,161.851296>}
      triangle {<-48.217947,-24.667873,163.100009>,<-47.184316,-25.003727,165.433195>,<-48.135557,-26.870663,165.433195>}
      triangle {<-48.217947,-24.667873,163.100009>,<-48.135557,-26.870663,165.433195>,<-49.014829,-26.231846,163.100008>}
      triangle {<-47.184316,-25.003727,165.433195>,<-46.474271,-25.234440,168.402773>,<-47.531553,-27.309498,168.402772>}
      triangle {<-47.184316,-25.003727,165.433195>,<-47.531553,-27.309498,168.402772>,<-48.135557,-26.870663,165.433195>}
      triangle {<-46.474271,-25.234440,168.402773>,<-46.033880,-25.377522,171.560617>,<-47.156942,-27.581669,171.560601>}
      triangle {<-46.474271,-25.234440,168.402773>,<-47.156942,-27.581669,171.560601>,<-47.531553,-27.309498,168.402772>}
      triangle {<-46.033880,-25.377522,171.560617>,<-45.809209,-25.450527,174.458659>,<-46.965826,-27.720531,174.458649>}
      triangle {<-46.033880,-25.377522,171.560617>,<-46.965826,-27.720531,174.458649>,<-47.156942,-27.581669,171.560601>}
      triangle {<-45.809209,-25.450527,174.458659>,<-45.746297,-25.470966,176.648766>,<-46.912313,-27.759411,176.648766>}
      triangle {<-45.809209,-25.450527,174.458659>,<-46.912313,-27.759411,176.648766>,<-46.965826,-27.720531,174.458649>}
      triangle {<-45.746297,-25.470966,176.648766>,<-46.142889,-25.342113,176.648766>,<-47.249670,-27.514301,176.648766>}
      triangle {<-45.746297,-25.470966,176.648766>,<-47.249670,-27.514301,176.648766>,<-46.912313,-27.759411,176.648766>}
      triangle {<-46.142889,-25.342113,176.648766>,<-46.247091,-25.308254,173.645400>,<-47.338315,-27.449894,173.645400>}
      triangle {<-46.142889,-25.342113,176.648766>,<-47.338315,-27.449894,173.645400>,<-47.249670,-27.514301,176.648766>}
      triangle {<-46.247091,-25.308254,173.645400>,<-46.531873,-25.215710,170.428522>,<-47.580564,-27.273891,170.428505>}
      triangle {<-46.247091,-25.308254,173.645400>,<-47.580564,-27.273891,170.428505>,<-47.338315,-27.449894,173.645400>}
      triangle {<-46.531873,-25.215710,170.428522>,<-47.054616,-25.045864,167.371029>,<-48.025236,-26.950817,167.371017>}
      triangle {<-46.531873,-25.215710,170.428522>,<-48.025236,-26.950817,167.371017>,<-47.580564,-27.273891,170.428505>}
      triangle {<-47.054616,-25.045864,167.371029>,<-47.872686,-24.780056,164.845853>,<-48.721120,-26.445225,164.845853>}
      triangle {<-47.054616,-25.045864,167.371029>,<-48.721120,-26.445225,164.845853>,<-48.025236,-26.950817,167.371017>}
      triangle {<-47.872686,-24.780056,164.845853>,<-49.043462,-24.399647,163.225940>,<-49.717046,-25.721645,163.225939>}
      triangle {<-47.872686,-24.780056,164.845853>,<-49.717046,-25.721645,163.225939>,<-48.721120,-26.445225,164.845853>}
      triangle {<-49.043462,-24.399647,163.225940>,<-50.624326,-23.885998,162.884232>,<-51.061811,-24.744625,162.884233>}
      triangle {<-49.043462,-24.399647,163.225940>,<-51.061811,-24.744625,162.884233>,<-49.717046,-25.721645,163.225939>}
      triangle {<-50.624326,-23.885998,162.884232>,<-50.599828,-23.893948,155.274646>,<-51.040967,-24.759754,155.274646>}
      triangle {<-50.624326,-23.885998,162.884232>,<-51.040967,-24.759754,155.274646>,<-51.061811,-24.744625,162.884233>}
      triangle {<-50.599828,-23.893948,155.274646>,<-49.629125,-24.209354,155.274646>,<-50.215238,-25.359692,155.274646>}
      triangle {<-50.599828,-23.893948,155.274646>,<-50.215238,-25.359692,155.274646>,<-51.040967,-24.759754,155.274646>}
      triangle {<-50.215238,-25.359692,155.274646>,<-50.215238,-25.359692,161.851296>,<-51.128149,-26.272587,161.851297>}
      triangle {<-50.215238,-25.359692,155.274646>,<-51.128149,-26.272587,161.851297>,<-51.128149,-26.272587,155.274646>}
      triangle {<-50.215238,-25.359692,161.851296>,<-49.014829,-26.231846,163.100008>,<-50.255994,-27.473003,163.100008>}
      triangle {<-50.215238,-25.359692,161.851296>,<-50.255994,-27.473003,163.100008>,<-51.128149,-26.272587,161.851297>}
      triangle {<-49.014829,-26.231846,163.100008>,<-48.135557,-26.870663,165.433195>,<-49.617170,-28.352268,165.433195>}
      triangle {<-49.014829,-26.231846,163.100008>,<-49.617170,-28.352268,165.433195>,<-50.255994,-27.473003,163.100008>}
      triangle {<-48.135557,-26.870663,165.433195>,<-47.531553,-27.309498,168.402772>,<-49.178342,-28.956264,168.402772>}
      triangle {<-48.135557,-26.870663,165.433195>,<-49.178342,-28.956264,168.402772>,<-49.617170,-28.352268,165.433195>}
      triangle {<-47.531553,-27.309498,168.402772>,<-47.156942,-27.581669,171.560601>,<-48.906164,-29.330891,171.560617>}
      triangle {<-47.531553,-27.309498,168.402772>,<-48.906164,-29.330891,171.560617>,<-49.178342,-28.956264,168.402772>}
      triangle {<-47.156942,-27.581669,171.560601>,<-46.965826,-27.720531,174.458649>,<-48.767309,-29.522007,174.458649>}
      triangle {<-47.156942,-27.581669,171.560601>,<-48.767309,-29.522007,174.458649>,<-48.906164,-29.330891,171.560617>}
      triangle {<-46.965826,-27.720531,174.458649>,<-46.912313,-27.759411,176.648766>,<-48.728429,-29.575520,176.648767>}
      triangle {<-46.965826,-27.720531,174.458649>,<-48.728429,-29.575520,176.648767>,<-48.767309,-29.522007,174.458649>}
      triangle {<-46.912313,-27.759411,176.648766>,<-47.249670,-27.514301,176.648766>,<-48.973539,-29.238163,176.648767>}
      triangle {<-46.912313,-27.759411,176.648766>,<-48.973539,-29.238163,176.648767>,<-48.728429,-29.575520,176.648767>}
      triangle {<-47.249670,-27.514301,176.648766>,<-47.338315,-27.449894,173.645400>,<-49.037939,-29.149517,173.645417>}
      triangle {<-47.249670,-27.514301,176.648766>,<-49.037939,-29.149517,173.645417>,<-48.973539,-29.238163,176.648767>}
      triangle {<-47.338315,-27.449894,173.645400>,<-47.580564,-27.273891,170.428505>,<-49.213941,-28.907261,170.428522>}
      triangle {<-47.338315,-27.449894,173.645400>,<-49.213941,-28.907261,170.428522>,<-49.037939,-29.149517,173.645417>}
      triangle {<-47.580564,-27.273891,170.428505>,<-48.025236,-26.950817,167.371017>,<-49.537015,-28.462589,167.371017>}
      triangle {<-47.580564,-27.273891,170.428505>,<-49.537015,-28.462589,167.371017>,<-49.213941,-28.907261,170.428522>}
      triangle {<-48.025236,-26.950817,167.371017>,<-48.721120,-26.445225,164.845853>,<-50.042615,-27.766705,164.845853>}
      triangle {<-48.025236,-26.950817,167.371017>,<-50.042615,-27.766705,164.845853>,<-49.537015,-28.462589,167.371017>}
      triangle {<-48.721120,-26.445225,164.845853>,<-49.717046,-25.721645,163.225939>,<-50.766195,-26.770779,163.225939>}
      triangle {<-48.721120,-26.445225,164.845853>,<-50.766195,-26.770779,163.225939>,<-50.042615,-27.766705,164.845853>}
      triangle {<-49.717046,-25.721645,163.225939>,<-51.061811,-24.744625,162.884233>,<-51.743215,-25.426022,162.884233>}
      triangle {<-49.717046,-25.721645,163.225939>,<-51.743215,-25.426022,162.884233>,<-50.766195,-26.770779,163.225939>}
      triangle {<-51.061811,-24.744625,162.884233>,<-51.040967,-24.759754,155.274646>,<-51.728078,-25.446850,155.274646>}
      triangle {<-51.061811,-24.744625,162.884233>,<-51.728078,-25.446850,155.274646>,<-51.743215,-25.426022,162.884233>}
      triangle {<-51.040967,-24.759754,155.274646>,<-50.215238,-25.359692,155.274646>,<-51.128149,-26.272587,155.274646>}
      triangle {<-51.040967,-24.759754,155.274646>,<-51.128149,-26.272587,155.274646>,<-51.728078,-25.446850,155.274646>}
      triangle {<-51.128149,-26.272587,155.274646>,<-51.128149,-26.272587,161.851297>,<-52.278471,-26.858707,161.851297>}
      triangle {<-51.128149,-26.272587,155.274646>,<-52.278471,-26.858707,161.851297>,<-52.278471,-26.858707,155.274646>}
      triangle {<-51.128149,-26.272587,161.851297>,<-50.255994,-27.473003,163.100008>,<-51.819952,-28.269886,163.100008>}
      triangle {<-51.128149,-26.272587,161.851297>,<-51.819952,-28.269886,163.100008>,<-52.278471,-26.858707,161.851297>}
      triangle {<-50.255994,-27.473003,163.100008>,<-49.617170,-28.352268,165.433195>,<-51.484106,-29.303524,165.433195>}
      triangle {<-50.255994,-27.473003,163.100008>,<-51.484106,-29.303524,165.433195>,<-51.819952,-28.269886,163.100008>}
      triangle {<-49.617170,-28.352268,165.433195>,<-49.178342,-28.956264,168.402772>,<-51.253400,-30.013569,168.402772>}
      triangle {<-49.617170,-28.352268,165.433195>,<-51.253400,-30.013569,168.402772>,<-51.484106,-29.303524,165.433195>}
      triangle {<-49.178342,-28.956264,168.402772>,<-48.906164,-29.330891,171.560617>,<-51.110303,-30.453960,171.560617>}
      triangle {<-49.178342,-28.956264,168.402772>,<-51.110303,-30.453960,171.560617>,<-51.253400,-30.013569,168.402772>}
      triangle {<-48.906164,-29.330891,171.560617>,<-48.767309,-29.522007,174.458649>,<-51.037298,-30.678638,174.458649>}
      triangle {<-48.906164,-29.330891,171.560617>,<-51.037298,-30.678638,174.458649>,<-51.110303,-30.453960,171.560617>}
      triangle {<-48.767309,-29.522007,174.458649>,<-48.728429,-29.575520,176.648767>,<-51.016866,-30.741543,176.648767>}
      triangle {<-48.767309,-29.522007,174.458649>,<-51.016866,-30.741543,176.648767>,<-51.037298,-30.678638,174.458649>}
      triangle {<-48.728429,-29.575520,176.648767>,<-48.973539,-29.238163,176.648767>,<-51.145727,-30.344944,176.648767>}
      triangle {<-48.728429,-29.575520,176.648767>,<-51.145727,-30.344944,176.648767>,<-51.016866,-30.741543,176.648767>}
      triangle {<-48.973539,-29.238163,176.648767>,<-49.037939,-29.149517,173.645417>,<-51.179586,-30.240749,173.645400>}
      triangle {<-48.973539,-29.238163,176.648767>,<-51.179586,-30.240749,173.645400>,<-51.145727,-30.344944,176.648767>}
      triangle {<-49.037939,-29.149517,173.645417>,<-49.213941,-28.907261,170.428522>,<-51.272115,-29.955959,170.428522>}
      triangle {<-49.037939,-29.149517,173.645417>,<-51.272115,-29.955959,170.428522>,<-51.179586,-30.240749,173.645400>}
      triangle {<-49.213941,-28.907261,170.428522>,<-49.537015,-28.462589,167.371017>,<-51.441968,-29.433216,167.371017>}
      triangle {<-49.213941,-28.907261,170.428522>,<-51.441968,-29.433216,167.371017>,<-51.272115,-29.955959,170.428522>}
      triangle {<-49.537015,-28.462589,167.371017>,<-50.042615,-27.766705,164.845853>,<-51.707769,-28.615147,164.845853>}
      triangle {<-49.537015,-28.462589,167.371017>,<-51.707769,-28.615147,164.845853>,<-51.441968,-29.433216,167.371017>}
      triangle {<-50.042615,-27.766705,164.845853>,<-50.766195,-26.770779,163.225939>,<-52.088178,-27.444378,163.225939>}
      triangle {<-50.042615,-27.766705,164.845853>,<-52.088178,-27.444378,163.225939>,<-51.707769,-28.615147,164.845853>}
      triangle {<-50.766195,-26.770779,163.225939>,<-51.743215,-25.426022,162.884233>,<-52.601827,-25.863522,162.884232>}
      triangle {<-50.766195,-26.770779,163.225939>,<-52.601827,-25.863522,162.884232>,<-52.088178,-27.444378,163.225939>}
      triangle {<-51.743215,-25.426022,162.884233>,<-51.728078,-25.446850,155.274646>,<-52.593870,-25.888004,155.274646>}
      triangle {<-51.743215,-25.426022,162.884233>,<-52.593870,-25.888004,155.274646>,<-52.601827,-25.863522,162.884232>}
      triangle {<-51.728078,-25.446850,155.274646>,<-51.128149,-26.272587,155.274646>,<-52.278471,-26.858707,155.274646>}
      triangle {<-51.728078,-25.446850,155.274646>,<-52.278471,-26.858707,155.274646>,<-52.593870,-25.888004,155.274646>}
      triangle {<-52.278471,-26.858707,155.274646>,<-52.278471,-26.858707,161.851297>,<-53.553625,-27.060673,161.851297>}
      triangle {<-52.278471,-26.858707,155.274646>,<-53.553625,-27.060673,161.851297>,<-53.553625,-27.060673,155.274646>}
      triangle {<-52.278471,-26.858707,161.851297>,<-51.819952,-28.269886,163.100008>,<-53.553625,-28.544468,163.100008>}
      triangle {<-52.278471,-26.858707,161.851297>,<-53.553625,-28.544468,163.100008>,<-53.553625,-27.060673,161.851297>}
      triangle {<-51.819952,-28.269886,163.100008>,<-51.484106,-29.303524,165.433195>,<-53.553625,-29.631290,165.433195>}
      triangle {<-51.819952,-28.269886,163.100008>,<-53.553625,-29.631290,165.433195>,<-53.553625,-28.544468,163.100008>}
      triangle {<-51.484106,-29.303524,165.433195>,<-51.253400,-30.013569,168.402772>,<-53.553625,-30.377880,168.402763>}
      triangle {<-51.484106,-29.303524,165.433195>,<-53.553625,-30.377880,168.402763>,<-53.553625,-29.631290,165.433195>}
      triangle {<-51.253400,-30.013569,168.402772>,<-51.110303,-30.453960,171.560617>,<-53.553625,-30.840939,171.560600>}
      triangle {<-51.253400,-30.013569,168.402772>,<-53.553625,-30.840939,171.560600>,<-53.553625,-30.377880,168.402763>}
      triangle {<-51.110303,-30.453960,171.560617>,<-51.037298,-30.678638,174.458649>,<-53.553625,-31.077175,174.458649>}
      triangle {<-51.110303,-30.453960,171.560617>,<-53.553625,-31.077175,174.458649>,<-53.553625,-30.840939,171.560600>}
      triangle {<-51.037298,-30.678638,174.458649>,<-51.016866,-30.741543,176.648767>,<-53.553625,-31.143314,176.648767>}
      triangle {<-51.037298,-30.678638,174.458649>,<-53.553625,-31.143314,176.648767>,<-53.553625,-31.077175,174.458649>}
      triangle {<-51.016866,-30.741543,176.648767>,<-51.145727,-30.344944,176.648767>,<-53.553625,-30.726322,176.648767>}
      triangle {<-51.016866,-30.741543,176.648767>,<-53.553625,-30.726322,176.648767>,<-53.553625,-31.143314,176.648767>}
      triangle {<-51.145727,-30.344944,176.648767>,<-51.179586,-30.240749,173.645400>,<-53.553625,-30.616749,173.645400>}
      triangle {<-51.145727,-30.344944,176.648767>,<-53.553625,-30.616749,173.645400>,<-53.553625,-30.726322,176.648767>}
      triangle {<-51.179586,-30.240749,173.645400>,<-51.272115,-29.955959,170.428522>,<-53.553625,-30.317303,170.428522>}
      triangle {<-51.179586,-30.240749,173.645400>,<-53.553625,-30.317303,170.428522>,<-53.553625,-30.616749,173.645400>}
      triangle {<-51.272115,-29.955959,170.428522>,<-51.441968,-29.433216,167.371017>,<-53.553625,-29.767666,167.371017>}
      triangle {<-51.272115,-29.955959,170.428522>,<-53.553625,-29.767666,167.371017>,<-53.553625,-30.317303,170.428522>}
      triangle {<-51.441968,-29.433216,167.371017>,<-51.707769,-28.615147,164.845853>,<-53.553625,-28.907497,164.845853>}
      triangle {<-51.441968,-29.433216,167.371017>,<-53.553625,-28.907497,164.845853>,<-53.553625,-29.767666,167.371017>}
      triangle {<-51.707769,-28.615147,164.845853>,<-52.088178,-27.444378,163.225939>,<-53.553625,-27.676472,163.225940>}
      triangle {<-51.707769,-28.615147,164.845853>,<-53.553625,-27.676472,163.225940>,<-53.553625,-28.907497,164.845853>}
      triangle {<-52.088178,-27.444378,163.225939>,<-52.601827,-25.863522,162.884232>,<-53.553625,-26.014263,162.884232>}
      triangle {<-52.088178,-27.444378,163.225939>,<-53.553625,-26.014263,162.884232>,<-53.553625,-27.676472,163.225940>}
      triangle {<-52.601827,-25.863522,162.884232>,<-52.593870,-25.888004,155.274646>,<-53.553625,-26.040005,155.274646>}
      triangle {<-52.601827,-25.863522,162.884232>,<-53.553625,-26.040005,155.274646>,<-53.553625,-26.014263,162.884232>}
      triangle {<-52.593870,-25.888004,155.274646>,<-52.278471,-26.858707,155.274646>,<-53.553625,-27.060673,155.274646>}
      triangle {<-52.593870,-25.888004,155.274646>,<-53.553625,-27.060673,155.274646>,<-53.553625,-26.040005,155.274646>}
      triangle {<-53.553625,-27.060673,155.274646>,<-53.553625,-27.060673,161.851297>,<-54.828763,-26.858707,161.851297>}
      triangle {<-53.553625,-27.060673,155.274646>,<-54.828763,-26.858707,161.851297>,<-54.828763,-26.858707,155.274646>}
      triangle {<-53.553625,-27.060673,161.851297>,<-53.553625,-28.544468,163.100008>,<-55.287282,-28.269886,163.100008>}
      triangle {<-53.553625,-27.060673,161.851297>,<-55.287282,-28.269886,163.100008>,<-54.828763,-26.858707,161.851297>}
      triangle {<-53.553625,-28.544468,163.100008>,<-53.553625,-29.631290,165.433195>,<-55.623136,-29.303524,165.433195>}
      triangle {<-53.553625,-28.544468,163.100008>,<-55.623136,-29.303524,165.433195>,<-55.287282,-28.269886,163.100008>}
      triangle {<-53.553625,-29.631290,165.433195>,<-53.553625,-30.377880,168.402763>,<-55.853841,-30.013569,168.402772>}
      triangle {<-53.553625,-29.631290,165.433195>,<-55.853841,-30.013569,168.402772>,<-55.623136,-29.303524,165.433195>}
      triangle {<-53.553625,-30.377880,168.402763>,<-53.553625,-30.840939,171.560600>,<-55.996931,-30.453953,171.560617>}
      triangle {<-53.553625,-30.377880,168.402763>,<-55.996931,-30.453953,171.560617>,<-55.853841,-30.013569,168.402772>}
      triangle {<-53.553625,-30.840939,171.560600>,<-53.553625,-31.077175,174.458649>,<-56.069936,-30.678638,174.458649>}
      triangle {<-53.553625,-30.840939,171.560600>,<-56.069936,-30.678638,174.458649>,<-55.996931,-30.453953,171.560617>}
      triangle {<-53.553625,-31.077175,174.458649>,<-53.553625,-31.143314,176.648767>,<-56.090375,-30.741535,176.648767>}
      triangle {<-53.553625,-31.077175,174.458649>,<-56.090375,-30.741535,176.648767>,<-56.069936,-30.678638,174.458649>}
      triangle {<-53.553625,-31.143314,176.648767>,<-53.553625,-30.726322,176.648767>,<-55.961515,-30.344944,176.648767>}
      triangle {<-53.553625,-31.143314,176.648767>,<-55.961515,-30.344944,176.648767>,<-56.090375,-30.741535,176.648767>}
      triangle {<-53.553625,-30.726322,176.648767>,<-53.553625,-30.616749,173.645400>,<-55.927656,-30.240749,173.645400>}
      triangle {<-53.553625,-30.726322,176.648767>,<-55.927656,-30.240749,173.645400>,<-55.961515,-30.344944,176.648767>}
      triangle {<-53.553625,-30.616749,173.645400>,<-53.553625,-30.317303,170.428522>,<-55.835126,-29.955959,170.428522>}
      triangle {<-53.553625,-30.616749,173.645400>,<-55.835126,-29.955959,170.428522>,<-55.927656,-30.240749,173.645400>}
      triangle {<-53.553625,-30.317303,170.428522>,<-53.553625,-29.767666,167.371017>,<-55.665273,-29.433216,167.371017>}
      triangle {<-53.553625,-30.317303,170.428522>,<-55.665273,-29.433216,167.371017>,<-55.835126,-29.955959,170.428522>}
      triangle {<-53.553625,-29.767666,167.371017>,<-53.553625,-28.907497,164.845853>,<-55.399473,-28.615147,164.845853>}
      triangle {<-53.553625,-29.767666,167.371017>,<-55.399473,-28.615147,164.845853>,<-55.665273,-29.433216,167.371017>}
      triangle {<-53.553625,-28.907497,164.845853>,<-53.553625,-27.676472,163.225940>,<-55.019056,-27.444378,163.225939>}
      triangle {<-53.553625,-28.907497,164.845853>,<-55.019056,-27.444378,163.225939>,<-55.399473,-28.615147,164.845853>}
      triangle {<-53.553625,-27.676472,163.225940>,<-53.553625,-26.014263,162.884232>,<-54.505407,-25.863522,162.884232>}
      triangle {<-53.553625,-27.676472,163.225940>,<-54.505407,-25.863522,162.884232>,<-55.019056,-27.444378,163.225939>}
      triangle {<-53.553625,-26.014263,162.884232>,<-53.553625,-26.040005,155.274646>,<-54.513364,-25.888004,155.274646>}
      triangle {<-53.553625,-26.014263,162.884232>,<-54.513364,-25.888004,155.274646>,<-54.505407,-25.863522,162.884232>}
      triangle {<-53.553625,-26.040005,155.274646>,<-53.553625,-27.060673,155.274646>,<-54.828763,-26.858707,155.274646>}
      triangle {<-53.553625,-26.040005,155.274646>,<-54.828763,-26.858707,155.274646>,<-54.513364,-25.888004,155.274646>}
      triangle {<-54.828763,-26.858707,155.274646>,<-54.828763,-26.858707,161.851297>,<-55.979093,-26.272587,161.851297>}
      triangle {<-54.828763,-26.858707,155.274646>,<-55.979093,-26.272587,161.851297>,<-55.979093,-26.272587,155.274646>}
      triangle {<-54.828763,-26.858707,161.851297>,<-55.287282,-28.269886,163.100008>,<-56.851247,-27.473003,163.100008>}
      triangle {<-54.828763,-26.858707,161.851297>,<-56.851247,-27.473003,163.100008>,<-55.979093,-26.272587,161.851297>}
      triangle {<-55.287282,-28.269886,163.100008>,<-55.623136,-29.303524,165.433195>,<-57.490072,-28.352268,165.433195>}
      triangle {<-55.287282,-28.269886,163.100008>,<-57.490072,-28.352268,165.433195>,<-56.851247,-27.473003,163.100008>}
      triangle {<-55.623136,-29.303524,165.433195>,<-55.853841,-30.013569,168.402772>,<-57.928899,-28.956264,168.402772>}
      triangle {<-55.623136,-29.303524,165.433195>,<-57.928899,-28.956264,168.402772>,<-57.490072,-28.352268,165.433195>}
      triangle {<-55.853841,-30.013569,168.402772>,<-55.996931,-30.453953,171.560617>,<-58.201078,-29.330891,171.560617>}
      triangle {<-55.853841,-30.013569,168.402772>,<-58.201078,-29.330891,171.560617>,<-57.928899,-28.956264,168.402772>}
      triangle {<-55.996931,-30.453953,171.560617>,<-56.069936,-30.678638,174.458649>,<-58.339933,-29.522007,174.458649>}
      triangle {<-55.996931,-30.453953,171.560617>,<-58.339933,-29.522007,174.458649>,<-58.201078,-29.330891,171.560617>}
      triangle {<-56.069936,-30.678638,174.458649>,<-56.090375,-30.741535,176.648767>,<-58.378812,-29.575520,176.648767>}
      triangle {<-56.069936,-30.678638,174.458649>,<-58.378812,-29.575520,176.648767>,<-58.339933,-29.522007,174.458649>}
      triangle {<-56.090375,-30.741535,176.648767>,<-55.961515,-30.344944,176.648767>,<-58.133703,-29.238163,176.648767>}
      triangle {<-56.090375,-30.741535,176.648767>,<-58.133703,-29.238163,176.648767>,<-58.378812,-29.575520,176.648767>}
      triangle {<-55.961515,-30.344944,176.648767>,<-55.927656,-30.240749,173.645400>,<-58.069303,-29.149517,173.645417>}
      triangle {<-55.961515,-30.344944,176.648767>,<-58.069303,-29.149517,173.645417>,<-58.133703,-29.238163,176.648767>}
      triangle {<-55.927656,-30.240749,173.645400>,<-55.835126,-29.955959,170.428522>,<-57.893293,-28.907261,170.428522>}
      triangle {<-55.927656,-30.240749,173.645400>,<-57.893293,-28.907261,170.428522>,<-58.069303,-29.149517,173.645417>}
      triangle {<-55.835126,-29.955959,170.428522>,<-55.665273,-29.433216,167.371017>,<-57.570226,-28.462589,167.371017>}
      triangle {<-55.835126,-29.955959,170.428522>,<-57.570226,-28.462589,167.371017>,<-57.893293,-28.907261,170.428522>}
      triangle {<-55.665273,-29.433216,167.371017>,<-55.399473,-28.615147,164.845853>,<-57.064634,-27.766705,164.845853>}
      triangle {<-55.665273,-29.433216,167.371017>,<-57.064634,-27.766705,164.845853>,<-57.570226,-28.462589,167.371017>}
      triangle {<-55.399473,-28.615147,164.845853>,<-55.019056,-27.444378,163.225939>,<-56.341047,-26.770786,163.225939>}
      triangle {<-55.399473,-28.615147,164.845853>,<-56.341047,-26.770786,163.225939>,<-57.064634,-27.766705,164.845853>}
      triangle {<-55.019056,-27.444378,163.225939>,<-54.505407,-25.863522,162.884232>,<-55.364027,-25.426022,162.884233>}
      triangle {<-55.019056,-27.444378,163.225939>,<-55.364027,-25.426022,162.884233>,<-56.341047,-26.770786,163.225939>}
      triangle {<-54.505407,-25.863522,162.884232>,<-54.513364,-25.888004,155.274646>,<-55.379156,-25.446857,155.274646>}
      triangle {<-54.505407,-25.863522,162.884232>,<-55.379156,-25.446857,155.274646>,<-55.364027,-25.426022,162.884233>}
      triangle {<-54.513364,-25.888004,155.274646>,<-54.828763,-26.858707,155.274646>,<-55.979093,-26.272587,155.274646>}
      triangle {<-54.513364,-25.888004,155.274646>,<-55.979093,-26.272587,155.274646>,<-55.379156,-25.446857,155.274646>}
      triangle {<-55.979093,-26.272587,155.274646>,<-55.979093,-26.272587,161.851297>,<-56.891996,-25.359692,161.851296>}
      triangle {<-55.979093,-26.272587,155.274646>,<-56.891996,-25.359692,161.851296>,<-56.891996,-25.359692,155.274646>}
      triangle {<-55.979093,-26.272587,161.851297>,<-56.851247,-27.473003,163.100008>,<-58.092420,-26.231846,163.100008>}
      triangle {<-55.979093,-26.272587,161.851297>,<-58.092420,-26.231846,163.100008>,<-56.891996,-25.359692,161.851296>}
      triangle {<-56.851247,-27.473003,163.100008>,<-57.490072,-28.352268,165.433195>,<-58.971685,-26.870663,165.433195>}
      triangle {<-56.851247,-27.473003,163.100008>,<-58.971685,-26.870663,165.433195>,<-58.092420,-26.231846,163.100008>}
      triangle {<-57.490072,-28.352268,165.433195>,<-57.928899,-28.956264,168.402772>,<-59.575681,-27.309490,168.402772>}
      triangle {<-57.490072,-28.352268,165.433195>,<-59.575681,-27.309490,168.402772>,<-58.971685,-26.870663,165.433195>}
      triangle {<-57.928899,-28.956264,168.402772>,<-58.201078,-29.330891,171.560617>,<-59.950300,-27.581669,171.560601>}
      triangle {<-57.928899,-28.956264,168.402772>,<-59.950300,-27.581669,171.560601>,<-59.575681,-27.309490,168.402772>}
      triangle {<-58.201078,-29.330891,171.560617>,<-58.339933,-29.522007,174.458649>,<-60.141416,-27.720524,174.458649>}
      triangle {<-58.201078,-29.330891,171.560617>,<-60.141416,-27.720524,174.458649>,<-59.950300,-27.581669,171.560601>}
      triangle {<-58.339933,-29.522007,174.458649>,<-58.378812,-29.575520,176.648767>,<-60.194929,-27.759403,176.648766>}
      triangle {<-58.339933,-29.522007,174.458649>,<-60.194929,-27.759403,176.648766>,<-60.141416,-27.720524,174.458649>}
      triangle {<-58.378812,-29.575520,176.648767>,<-58.133703,-29.238163,176.648767>,<-59.857572,-27.514301,176.648766>}
      triangle {<-58.378812,-29.575520,176.648767>,<-59.857572,-27.514301,176.648766>,<-60.194929,-27.759403,176.648766>}
      triangle {<-58.133703,-29.238163,176.648767>,<-58.069303,-29.149517,173.645417>,<-59.768926,-27.449894,173.645400>}
      triangle {<-58.133703,-29.238163,176.648767>,<-59.768926,-27.449894,173.645400>,<-59.857572,-27.514301,176.648766>}
      triangle {<-58.069303,-29.149517,173.645417>,<-57.893293,-28.907261,170.428522>,<-59.526678,-27.273891,170.428505>}
      triangle {<-58.069303,-29.149517,173.645417>,<-59.526678,-27.273891,170.428505>,<-59.768926,-27.449894,173.645400>}
      triangle {<-57.893293,-28.907261,170.428522>,<-57.570226,-28.462589,167.371017>,<-59.082006,-26.950817,167.371017>}
      triangle {<-57.893293,-28.907261,170.428522>,<-59.082006,-26.950817,167.371017>,<-59.526678,-27.273891,170.428505>}
      triangle {<-57.570226,-28.462589,167.371017>,<-57.064634,-27.766705,164.845853>,<-58.386114,-26.445225,164.845853>}
      triangle {<-57.570226,-28.462589,167.371017>,<-58.386114,-26.445225,164.845853>,<-59.082006,-26.950817,167.371017>}
      triangle {<-57.064634,-27.766705,164.845853>,<-56.341047,-26.770786,163.225939>,<-57.390195,-25.721645,163.225939>}
      triangle {<-57.064634,-27.766705,164.845853>,<-57.390195,-25.721645,163.225939>,<-58.386114,-26.445225,164.845853>}
      triangle {<-56.341047,-26.770786,163.225939>,<-55.364027,-25.426022,162.884233>,<-56.045431,-24.744625,162.884233>}
      triangle {<-56.341047,-26.770786,163.225939>,<-56.045431,-24.744625,162.884233>,<-57.390195,-25.721645,163.225939>}
      triangle {<-55.364027,-25.426022,162.884233>,<-55.379156,-25.446857,155.274646>,<-56.066259,-24.759754,155.274646>}
      triangle {<-55.364027,-25.426022,162.884233>,<-56.066259,-24.759754,155.274646>,<-56.045431,-24.744625,162.884233>}
      triangle {<-55.379156,-25.446857,155.274646>,<-55.979093,-26.272587,155.274646>,<-56.891996,-25.359692,155.274646>}
      triangle {<-55.379156,-25.446857,155.274646>,<-56.891996,-25.359692,155.274646>,<-56.066259,-24.759754,155.274646>}
      triangle {<-56.891996,-25.359692,155.274646>,<-56.891996,-25.359692,161.851296>,<-57.478117,-24.209354,161.851296>}
      triangle {<-56.891996,-25.359692,155.274646>,<-57.478117,-24.209354,161.851296>,<-57.478117,-24.209354,155.274646>}
      triangle {<-56.891996,-25.359692,161.851296>,<-58.092420,-26.231846,163.100008>,<-58.889295,-24.667873,163.100009>}
      triangle {<-56.891996,-25.359692,161.851296>,<-58.889295,-24.667873,163.100009>,<-57.478117,-24.209354,161.851296>}
      triangle {<-58.092420,-26.231846,163.100008>,<-58.971685,-26.870663,165.433195>,<-59.922933,-25.003727,165.433195>}
      triangle {<-58.092420,-26.231846,163.100008>,<-59.922933,-25.003727,165.433195>,<-58.889295,-24.667873,163.100009>}
      triangle {<-58.971685,-26.870663,165.433195>,<-59.575681,-27.309490,168.402772>,<-60.632970,-25.234440,168.402773>}
      triangle {<-58.971685,-26.870663,165.433195>,<-60.632970,-25.234440,168.402773>,<-59.922933,-25.003727,165.433195>}
      triangle {<-59.575681,-27.309490,168.402772>,<-59.950300,-27.581669,171.560601>,<-61.073362,-25.377514,171.560617>}
      triangle {<-59.575681,-27.309490,168.402772>,<-61.073362,-25.377514,171.560617>,<-60.632970,-25.234440,168.402773>}
      triangle {<-59.950300,-27.581669,171.560601>,<-60.141416,-27.720524,174.458649>,<-61.298040,-25.450520,174.458659>}
      triangle {<-59.950300,-27.581669,171.560601>,<-61.298040,-25.450520,174.458659>,<-61.073362,-25.377514,171.560617>}
      triangle {<-60.141416,-27.720524,174.458649>,<-60.194929,-27.759403,176.648766>,<-61.360944,-25.470966,176.648766>}
      triangle {<-60.141416,-27.720524,174.458649>,<-61.360944,-25.470966,176.648766>,<-61.298040,-25.450520,174.458659>}
      triangle {<-60.194929,-27.759403,176.648766>,<-59.857572,-27.514301,176.648766>,<-60.964361,-25.342106,176.648766>}
      triangle {<-60.194929,-27.759403,176.648766>,<-60.964361,-25.342106,176.648766>,<-61.360944,-25.470966,176.648766>}
      triangle {<-59.857572,-27.514301,176.648766>,<-59.768926,-27.449894,173.645400>,<-60.860151,-25.308247,173.645400>}
      triangle {<-59.857572,-27.514301,176.648766>,<-60.860151,-25.308247,173.645400>,<-60.964361,-25.342106,176.648766>}
      triangle {<-59.768926,-27.449894,173.645400>,<-59.526678,-27.273891,170.428505>,<-60.575361,-25.215710,170.428522>}
      triangle {<-59.768926,-27.449894,173.645400>,<-60.575361,-25.215710,170.428522>,<-60.860151,-25.308247,173.645400>}
      triangle {<-59.526678,-27.273891,170.428505>,<-59.082006,-26.950817,167.371017>,<-60.052618,-25.045864,167.371029>}
      triangle {<-59.526678,-27.273891,170.428505>,<-60.052618,-25.045864,167.371029>,<-60.575361,-25.215710,170.428522>}
      triangle {<-59.082006,-26.950817,167.371017>,<-58.386114,-26.445225,164.845853>,<-59.234556,-24.780056,164.845853>}
      triangle {<-59.082006,-26.950817,167.371017>,<-59.234556,-24.780056,164.845853>,<-60.052618,-25.045864,167.371029>}
      triangle {<-58.386114,-26.445225,164.845853>,<-57.390195,-25.721645,163.225939>,<-58.063772,-24.399647,163.225940>}
      triangle {<-58.386114,-26.445225,164.845853>,<-58.063772,-24.399647,163.225940>,<-59.234556,-24.780056,164.845853>}
      triangle {<-57.390195,-25.721645,163.225939>,<-56.045431,-24.744625,162.884233>,<-56.482915,-23.885998,162.884232>}
      triangle {<-57.390195,-25.721645,163.225939>,<-56.482915,-23.885998,162.884232>,<-58.063772,-24.399647,163.225940>}
      triangle {<-56.045431,-24.744625,162.884233>,<-56.066259,-24.759754,155.274646>,<-56.507406,-23.893948,155.274646>}
      triangle {<-56.045431,-24.744625,162.884233>,<-56.507406,-23.893948,155.274646>,<-56.482915,-23.885998,162.884232>}
      triangle {<-56.066259,-24.759754,155.274646>,<-56.891996,-25.359692,155.274646>,<-57.478117,-24.209354,155.274646>}
      triangle {<-56.066259,-24.759754,155.274646>,<-57.478117,-24.209354,155.274646>,<-56.507406,-23.893948,155.274646>}
      triangle {<-57.478117,-24.209354,155.274646>,<-57.478117,-24.209354,161.851296>,<-57.680082,-22.934216,161.851264>}
      triangle {<-57.478117,-24.209354,155.274646>,<-57.680082,-22.934216,161.851264>,<-57.680082,-22.934216,155.274646>}
      triangle {<-57.478117,-24.209354,161.851296>,<-58.889295,-24.667873,163.100009>,<-59.163885,-22.934216,163.100008>}
      triangle {<-57.478117,-24.209354,161.851296>,<-59.163885,-22.934216,163.100008>,<-57.680082,-22.934216,161.851264>}
      triangle {<-58.889295,-24.667873,163.100009>,<-59.922933,-25.003727,165.433195>,<-60.250707,-22.934216,165.433195>}
      triangle {<-58.889295,-24.667873,163.100009>,<-60.250707,-22.934216,165.433195>,<-59.163885,-22.934216,163.100008>}
      triangle {<-59.922933,-25.003727,165.433195>,<-60.632970,-25.234440,168.402773>,<-60.997297,-22.934216,168.402772>}
      triangle {<-59.922933,-25.003727,165.433195>,<-60.997297,-22.934216,168.402772>,<-60.250707,-22.934216,165.433195>}
      triangle {<-60.632970,-25.234440,168.402773>,<-61.073362,-25.377514,171.560617>,<-61.460348,-22.934216,171.560601>}
      triangle {<-60.632970,-25.234440,168.402773>,<-61.460348,-22.934216,171.560601>,<-60.997297,-22.934216,168.402772>}
      triangle {<-61.073362,-25.377514,171.560617>,<-61.298040,-25.450520,174.458659>,<-61.696592,-22.934216,174.458659>}
      triangle {<-61.073362,-25.377514,171.560617>,<-61.696592,-22.934216,174.458659>,<-61.460348,-22.934216,171.560601>}
      triangle {<-61.298040,-25.450520,174.458659>,<-61.360944,-25.470966,176.648766>,<-61.762731,-22.934216,176.648767>}
      triangle {<-61.298040,-25.450520,174.458659>,<-61.762731,-22.934216,176.648767>,<-61.696592,-22.934216,174.458659>}
      triangle {<-61.360944,-25.470966,176.648766>,<-60.964361,-25.342106,176.648766>,<-61.345731,-22.934216,176.648767>}
      triangle {<-61.360944,-25.470966,176.648766>,<-61.345731,-22.934216,176.648767>,<-61.762731,-22.934216,176.648767>}
      triangle {<-60.964361,-25.342106,176.648766>,<-60.860151,-25.308247,173.645400>,<-61.236158,-22.934216,173.645401>}
      triangle {<-60.964361,-25.342106,176.648766>,<-61.236158,-22.934216,173.645401>,<-61.345731,-22.934216,176.648767>}
      triangle {<-60.860151,-25.308247,173.645400>,<-60.575361,-25.215710,170.428522>,<-60.936719,-22.934216,170.428505>}
      triangle {<-60.860151,-25.308247,173.645400>,<-60.936719,-22.934216,170.428505>,<-61.236158,-22.934216,173.645401>}
      triangle {<-60.575361,-25.215710,170.428522>,<-60.052618,-25.045864,167.371029>,<-60.387083,-22.934216,167.371029>}
      triangle {<-60.575361,-25.215710,170.428522>,<-60.387083,-22.934216,167.371029>,<-60.936719,-22.934216,170.428505>}
      triangle {<-60.052618,-25.045864,167.371029>,<-59.234556,-24.780056,164.845853>,<-59.526914,-22.934216,164.845853>}
      triangle {<-60.052618,-25.045864,167.371029>,<-59.526914,-22.934216,164.845853>,<-60.387083,-22.934216,167.371029>}
      triangle {<-59.234556,-24.780056,164.845853>,<-58.063772,-24.399647,163.225940>,<-58.295888,-22.934216,163.225939>}
      triangle {<-59.234556,-24.780056,164.845853>,<-58.295888,-22.934216,163.225939>,<-59.526914,-22.934216,164.845853>}
      triangle {<-58.063772,-24.399647,163.225940>,<-56.482915,-23.885998,162.884232>,<-56.633672,-22.934216,162.884232>}
      triangle {<-58.063772,-24.399647,163.225940>,<-56.633672,-22.934216,162.884232>,<-58.295888,-22.934216,163.225939>}
      triangle {<-56.482915,-23.885998,162.884232>,<-56.507406,-23.893948,155.274646>,<-56.659421,-22.934216,155.274646>}
      triangle {<-56.482915,-23.885998,162.884232>,<-56.659421,-22.934216,155.274646>,<-56.633672,-22.934216,162.884232>}
      triangle {<-56.507406,-23.893948,155.274646>,<-57.478117,-24.209354,155.274646>,<-57.680082,-22.934216,155.274646>}
      triangle {<-56.507406,-23.893948,155.274646>,<-57.680082,-22.934216,155.274646>,<-56.659421,-22.934216,155.274646>}
      triangle {<-57.680082,-22.934216,155.274646>,<-57.680082,-22.934216,161.851264>,<-57.478117,-21.659061,161.851297>}
      triangle {<-57.680082,-22.934216,155.274646>,<-57.478117,-21.659061,161.851297>,<-57.478117,-21.659061,155.274646>}
      triangle {<-57.680082,-22.934216,161.851264>,<-59.163885,-22.934216,163.100008>,<-58.889295,-21.200542,163.100009>}
      triangle {<-57.680082,-22.934216,161.851264>,<-58.889295,-21.200542,163.100009>,<-57.478117,-21.659061,161.851297>}
      triangle {<-59.163885,-22.934216,163.100008>,<-60.250707,-22.934216,165.433195>,<-59.922933,-20.864697,165.433196>}
      triangle {<-59.163885,-22.934216,163.100008>,<-59.922933,-20.864697,165.433196>,<-58.889295,-21.200542,163.100009>}
      triangle {<-60.250707,-22.934216,165.433195>,<-60.997297,-22.934216,168.402772>,<-60.632970,-20.633991,168.402772>}
      triangle {<-60.250707,-22.934216,165.433195>,<-60.632970,-20.633991,168.402772>,<-59.922933,-20.864697,165.433196>}
      triangle {<-60.997297,-22.934216,168.402772>,<-61.460348,-22.934216,171.560601>,<-61.073362,-20.490902,171.560601>}
      triangle {<-60.997297,-22.934216,168.402772>,<-61.073362,-20.490902,171.560601>,<-60.632970,-20.633991,168.402772>}
      triangle {<-61.460348,-22.934216,171.560601>,<-61.696592,-22.934216,174.458659>,<-61.298040,-20.417896,174.458659>}
      triangle {<-61.460348,-22.934216,171.560601>,<-61.298040,-20.417896,174.458659>,<-61.073362,-20.490902,171.560601>}
      triangle {<-61.696592,-22.934216,174.458659>,<-61.762731,-22.934216,176.648767>,<-61.360944,-20.397457,176.648767>}
      triangle {<-61.696592,-22.934216,174.458659>,<-61.360944,-20.397457,176.648767>,<-61.298040,-20.417896,174.458659>}
      triangle {<-61.762731,-22.934216,176.648767>,<-61.345731,-22.934216,176.648767>,<-60.964361,-20.526318,176.648767>}
      triangle {<-61.762731,-22.934216,176.648767>,<-60.964361,-20.526318,176.648767>,<-61.360944,-20.397457,176.648767>}
      triangle {<-61.345731,-22.934216,176.648767>,<-61.236158,-22.934216,173.645401>,<-60.860151,-20.560177,173.645400>}
      triangle {<-61.345731,-22.934216,176.648767>,<-60.860151,-20.560177,173.645400>,<-60.964361,-20.526318,176.648767>}
      triangle {<-61.236158,-22.934216,173.645401>,<-60.936719,-22.934216,170.428505>,<-60.575361,-20.652706,170.428505>}
      triangle {<-61.236158,-22.934216,173.645401>,<-60.575361,-20.652706,170.428505>,<-60.860151,-20.560177,173.645400>}
      triangle {<-60.936719,-22.934216,170.428505>,<-60.387083,-22.934216,167.371029>,<-60.052618,-20.822552,167.371030>}
      triangle {<-60.936719,-22.934216,170.428505>,<-60.052618,-20.822552,167.371030>,<-60.575361,-20.652706,170.428505>}
      triangle {<-60.387083,-22.934216,167.371029>,<-59.526914,-22.934216,164.845853>,<-59.234556,-21.088360,164.845854>}
      triangle {<-60.387083,-22.934216,167.371029>,<-59.234556,-21.088360,164.845854>,<-60.052618,-20.822552,167.371030>}
      triangle {<-59.526914,-22.934216,164.845853>,<-58.295888,-22.934216,163.225939>,<-58.063772,-21.468777,163.225940>}
      triangle {<-59.526914,-22.934216,164.845853>,<-58.063772,-21.468777,163.225940>,<-59.234556,-21.088360,164.845854>}
      triangle {<-58.295888,-22.934216,163.225939>,<-56.633672,-22.934216,162.884232>,<-56.482915,-21.982426,162.884233>}
      triangle {<-58.295888,-22.934216,163.225939>,<-56.482915,-21.982426,162.884233>,<-58.063772,-21.468777,163.225940>}
      triangle {<-56.633672,-22.934216,162.884232>,<-56.659421,-22.934216,155.274646>,<-56.507406,-21.974468,155.274646>}
      triangle {<-56.633672,-22.934216,162.884232>,<-56.507406,-21.974468,155.274646>,<-56.482915,-21.982426,162.884233>}
      triangle {<-56.659421,-22.934216,155.274646>,<-57.680082,-22.934216,155.274646>,<-57.478117,-21.659061,155.274646>}
      triangle {<-56.659421,-22.934216,155.274646>,<-57.478117,-21.659061,155.274646>,<-56.507406,-21.974468,155.274646>}
      triangle {<-57.478117,-21.659061,155.274646>,<-57.478117,-21.659061,161.851297>,<-56.891996,-20.508739,161.851297>}
      triangle {<-57.478117,-21.659061,155.274646>,<-56.891996,-20.508739,161.851297>,<-56.891996,-20.508739,155.274646>}
      triangle {<-57.478117,-21.659061,161.851297>,<-58.889295,-21.200542,163.100009>,<-58.092412,-19.636585,163.100009>}
      triangle {<-57.478117,-21.659061,161.851297>,<-58.092412,-19.636585,163.100009>,<-56.891996,-20.508739,161.851297>}
      triangle {<-58.889295,-21.200542,163.100009>,<-59.922933,-20.864697,165.433196>,<-58.971685,-18.997761,165.433196>}
      triangle {<-58.889295,-21.200542,163.100009>,<-58.971685,-18.997761,165.433196>,<-58.092412,-19.636585,163.100009>}
      triangle {<-59.922933,-20.864697,165.433196>,<-60.632970,-20.633991,168.402772>,<-59.575681,-18.558933,168.402773>}
      triangle {<-59.922933,-20.864697,165.433196>,<-59.575681,-18.558933,168.402773>,<-58.971685,-18.997761,165.433196>}
      triangle {<-60.632970,-20.633991,168.402772>,<-61.073362,-20.490902,171.560601>,<-59.950292,-18.286755,171.560601>}
      triangle {<-60.632970,-20.633991,168.402772>,<-59.950292,-18.286755,171.560601>,<-59.575681,-18.558933,168.402773>}
      triangle {<-61.073362,-20.490902,171.560601>,<-61.298040,-20.417896,174.458659>,<-60.141416,-18.147900,174.458660>}
      triangle {<-61.073362,-20.490902,171.560601>,<-60.141416,-18.147900,174.458660>,<-59.950292,-18.286755,171.560601>}
      triangle {<-61.298040,-20.417896,174.458659>,<-61.360944,-20.397457,176.648767>,<-60.194929,-18.109013,176.648767>}
      triangle {<-61.298040,-20.417896,174.458659>,<-60.194929,-18.109013,176.648767>,<-60.141416,-18.147900,174.458660>}
      triangle {<-61.360944,-20.397457,176.648767>,<-60.964361,-20.526318,176.648767>,<-59.857572,-18.354122,176.648767>}
      triangle {<-61.360944,-20.397457,176.648767>,<-59.857572,-18.354122,176.648767>,<-60.194929,-18.109013,176.648767>}
      triangle {<-60.964361,-20.526318,176.648767>,<-60.860151,-20.560177,173.645400>,<-59.768926,-18.418522,173.645417>}
      triangle {<-60.964361,-20.526318,176.648767>,<-59.768926,-18.418522,173.645417>,<-59.857572,-18.354122,176.648767>}
      triangle {<-60.860151,-20.560177,173.645400>,<-60.575361,-20.652706,170.428505>,<-59.526678,-18.594532,170.428522>}
      triangle {<-60.860151,-20.560177,173.645400>,<-59.526678,-18.594532,170.428522>,<-59.768926,-18.418522,173.645417>}
      triangle {<-60.575361,-20.652706,170.428505>,<-60.052618,-20.822552,167.371030>,<-59.082006,-18.917599,167.371030>}
      triangle {<-60.575361,-20.652706,170.428505>,<-59.082006,-18.917599,167.371030>,<-59.526678,-18.594532,170.428522>}
      triangle {<-60.052618,-20.822552,167.371030>,<-59.234556,-21.088360,164.845854>,<-58.386114,-19.423199,164.845854>}
      triangle {<-60.052618,-20.822552,167.371030>,<-58.386114,-19.423199,164.845854>,<-59.082006,-18.917599,167.371030>}
      triangle {<-59.234556,-21.088360,164.845854>,<-58.063772,-21.468777,163.225940>,<-57.390195,-20.146786,163.225940>}
      triangle {<-59.234556,-21.088360,164.845854>,<-57.390195,-20.146786,163.225940>,<-58.386114,-19.423199,164.845854>}
      triangle {<-58.063772,-21.468777,163.225940>,<-56.482915,-21.982426,162.884233>,<-56.045431,-21.123798,162.884232>}
      triangle {<-58.063772,-21.468777,163.225940>,<-56.045431,-21.123798,162.884232>,<-57.390195,-20.146786,163.225940>}
      triangle {<-56.482915,-21.982426,162.884233>,<-56.507406,-21.974468,155.274646>,<-56.066267,-21.108662,155.274646>}
      triangle {<-56.482915,-21.982426,162.884233>,<-56.066267,-21.108662,155.274646>,<-56.045431,-21.123798,162.884232>}
      triangle {<-56.507406,-21.974468,155.274646>,<-57.478117,-21.659061,155.274646>,<-56.891996,-20.508739,155.274646>}
      triangle {<-56.507406,-21.974468,155.274646>,<-56.891996,-20.508739,155.274646>,<-56.066267,-21.108662,155.274646>}
      triangle {<-56.891996,-20.508739,155.274646>,<-56.891996,-20.508739,161.851297>,<-55.979093,-19.595837,161.851297>}
      triangle {<-56.891996,-20.508739,155.274646>,<-55.979093,-19.595837,161.851297>,<-55.979093,-19.595837,155.274646>}
      triangle {<-56.891996,-20.508739,161.851297>,<-58.092412,-19.636585,163.100009>,<-56.851247,-18.395420,163.100009>}
      triangle {<-56.891996,-20.508739,161.851297>,<-56.851247,-18.395420,163.100009>,<-55.979093,-19.595837,161.851297>}
      triangle {<-58.092412,-19.636585,163.100009>,<-58.971685,-18.997761,165.433196>,<-57.490072,-17.516155,165.433196>}
      triangle {<-58.092412,-19.636585,163.100009>,<-57.490072,-17.516155,165.433196>,<-56.851247,-18.395420,163.100009>}
      triangle {<-58.971685,-18.997761,165.433196>,<-59.575681,-18.558933,168.402773>,<-57.928899,-16.912151,168.402773>}
      triangle {<-58.971685,-18.997761,165.433196>,<-57.928899,-16.912151,168.402773>,<-57.490072,-17.516155,165.433196>}
      triangle {<-59.575681,-18.558933,168.402773>,<-59.950292,-18.286755,171.560601>,<-58.201078,-16.537533,171.560601>}
      triangle {<-59.575681,-18.558933,168.402773>,<-58.201078,-16.537533,171.560601>,<-57.928899,-16.912151,168.402773>}
      triangle {<-59.950292,-18.286755,171.560601>,<-60.141416,-18.147900,174.458660>,<-58.339925,-16.346416,174.458659>}
      triangle {<-59.950292,-18.286755,171.560601>,<-58.339925,-16.346416,174.458659>,<-58.201078,-16.537533,171.560601>}
      triangle {<-60.141416,-18.147900,174.458660>,<-60.194929,-18.109013,176.648767>,<-58.378812,-16.292904,176.648778>}
      triangle {<-60.141416,-18.147900,174.458660>,<-58.378812,-16.292904,176.648778>,<-58.339925,-16.346416,174.458659>}
      triangle {<-60.194929,-18.109013,176.648767>,<-59.857572,-18.354122,176.648767>,<-58.133703,-16.630268,176.648779>}
      triangle {<-60.194929,-18.109013,176.648767>,<-58.133703,-16.630268,176.648779>,<-58.378812,-16.292904,176.648778>}
      triangle {<-59.857572,-18.354122,176.648767>,<-59.768926,-18.418522,173.645417>,<-58.069303,-16.718906,173.645401>}
      triangle {<-59.857572,-18.354122,176.648767>,<-58.069303,-16.718906,173.645401>,<-58.133703,-16.630268,176.648779>}
      triangle {<-59.768926,-18.418522,173.645417>,<-59.526678,-18.594532,170.428522>,<-57.893293,-16.961163,170.428505>}
      triangle {<-59.768926,-18.418522,173.645417>,<-57.893293,-16.961163,170.428505>,<-58.069303,-16.718906,173.645401>}
      triangle {<-59.526678,-18.594532,170.428522>,<-59.082006,-18.917599,167.371030>,<-57.570226,-17.405834,167.371030>}
      triangle {<-59.526678,-18.594532,170.428522>,<-57.570226,-17.405834,167.371030>,<-57.893293,-16.961163,170.428505>}
      triangle {<-59.082006,-18.917599,167.371030>,<-58.386114,-19.423199,164.845854>,<-57.064634,-18.101719,164.845854>}
      triangle {<-59.082006,-18.917599,167.371030>,<-57.064634,-18.101719,164.845854>,<-57.570226,-17.405834,167.371030>}
      triangle {<-58.386114,-19.423199,164.845854>,<-57.390195,-20.146786,163.225940>,<-56.341054,-19.097645,163.225940>}
      triangle {<-58.386114,-19.423199,164.845854>,<-56.341054,-19.097645,163.225940>,<-57.064634,-18.101719,164.845854>}
      triangle {<-57.390195,-20.146786,163.225940>,<-56.045431,-21.123798,162.884232>,<-55.364027,-20.442402,162.884232>}
      triangle {<-57.390195,-20.146786,163.225940>,<-55.364027,-20.442402,162.884232>,<-56.341054,-19.097645,163.225940>}
      triangle {<-56.045431,-21.123798,162.884232>,<-56.066267,-21.108662,155.274646>,<-55.379156,-20.421566,155.274646>}
      triangle {<-56.045431,-21.123798,162.884232>,<-55.379156,-20.421566,155.274646>,<-55.364027,-20.442402,162.884232>}
      triangle {<-56.066267,-21.108662,155.274646>,<-56.891996,-20.508739,155.274646>,<-55.979093,-19.595837,155.274646>}
      triangle {<-56.066267,-21.108662,155.274646>,<-55.979093,-19.595837,155.274646>,<-55.379156,-20.421566,155.274646>}
      triangle {<-55.979093,-19.595837,155.274646>,<-55.979093,-19.595837,161.851297>,<-54.828763,-19.009708,161.851296>}
      triangle {<-55.979093,-19.595837,155.274646>,<-54.828763,-19.009708,161.851296>,<-54.828763,-19.009708,155.274646>}
      triangle {<-55.979093,-19.595837,161.851297>,<-56.851247,-18.395420,163.100009>,<-55.287282,-17.598537,163.100009>}
      triangle {<-55.979093,-19.595837,161.851297>,<-55.287282,-17.598537,163.100009>,<-54.828763,-19.009708,161.851296>}
      triangle {<-56.851247,-18.395420,163.100009>,<-57.490072,-17.516155,165.433196>,<-55.623136,-16.564899,165.433196>}
      triangle {<-56.851247,-18.395420,163.100009>,<-55.623136,-16.564899,165.433196>,<-55.287282,-17.598537,163.100009>}
      triangle {<-57.490072,-17.516155,165.433196>,<-57.928899,-16.912151,168.402773>,<-55.853841,-15.854855,168.402773>}
      triangle {<-57.490072,-17.516155,165.433196>,<-55.853841,-15.854855,168.402773>,<-55.623136,-16.564899,165.433196>}
      triangle {<-57.928899,-16.912151,168.402773>,<-58.201078,-16.537533,171.560601>,<-55.996931,-15.414471,171.560601>}
      triangle {<-57.928899,-16.912151,168.402773>,<-55.996931,-15.414471,171.560601>,<-55.853841,-15.854855,168.402773>}
      triangle {<-58.201078,-16.537533,171.560601>,<-58.339925,-16.346416,174.458659>,<-56.069936,-15.189793,174.458659>}
      triangle {<-58.201078,-16.537533,171.560601>,<-56.069936,-15.189793,174.458659>,<-55.996931,-15.414471,171.560601>}
      triangle {<-58.339925,-16.346416,174.458659>,<-58.378812,-16.292904,176.648778>,<-56.090368,-15.126881,176.648778>}
      triangle {<-58.339925,-16.346416,174.458659>,<-56.090368,-15.126881,176.648778>,<-56.069936,-15.189793,174.458659>}
      triangle {<-58.378812,-16.292904,176.648778>,<-58.133703,-16.630268,176.648779>,<-55.961515,-15.523472,176.648778>}
      triangle {<-58.378812,-16.292904,176.648778>,<-55.961515,-15.523472,176.648778>,<-56.090368,-15.126881,176.648778>}
      triangle {<-58.133703,-16.630268,176.648779>,<-58.069303,-16.718906,173.645401>,<-55.927656,-15.627682,173.645400>}
      triangle {<-58.133703,-16.630268,176.648779>,<-55.927656,-15.627682,173.645400>,<-55.961515,-15.523472,176.648778>}
      triangle {<-58.069303,-16.718906,173.645401>,<-57.893293,-16.961163,170.428505>,<-55.835119,-15.912464,170.428505>}
      triangle {<-58.069303,-16.718906,173.645401>,<-55.835119,-15.912464,170.428505>,<-55.927656,-15.627682,173.645400>}
      triangle {<-57.893293,-16.961163,170.428505>,<-57.570226,-17.405834,167.371030>,<-55.665273,-16.435200,167.371030>}
      triangle {<-57.893293,-16.961163,170.428505>,<-55.665273,-16.435200,167.371030>,<-55.835119,-15.912464,170.428505>}
      triangle {<-57.570226,-17.405834,167.371030>,<-57.064634,-18.101719,164.845854>,<-55.399473,-17.253277,164.845854>}
      triangle {<-57.570226,-17.405834,167.371030>,<-55.399473,-17.253277,164.845854>,<-55.665273,-16.435200,167.371030>}
      triangle {<-57.064634,-18.101719,164.845854>,<-56.341054,-19.097645,163.225940>,<-55.019056,-18.424046,163.225940>}
      triangle {<-57.064634,-18.101719,164.845854>,<-55.019056,-18.424046,163.225940>,<-55.399473,-17.253277,164.845854>}
      triangle {<-56.341054,-19.097645,163.225940>,<-55.364027,-20.442402,162.884232>,<-54.505407,-20.004910,162.884233>}
      triangle {<-56.341054,-19.097645,163.225940>,<-54.505407,-20.004910,162.884233>,<-55.019056,-18.424046,163.225940>}
      triangle {<-55.364027,-20.442402,162.884232>,<-55.379156,-20.421566,155.274646>,<-54.513364,-19.980419,155.274646>}
      triangle {<-55.364027,-20.442402,162.884232>,<-54.513364,-19.980419,155.274646>,<-54.505407,-20.004910,162.884233>}
      triangle {<-55.379156,-20.421566,155.274646>,<-55.979093,-19.595837,155.274646>,<-54.828763,-19.009708,155.274646>}
      triangle {<-55.379156,-20.421566,155.274646>,<-54.828763,-19.009708,155.274646>,<-54.513364,-19.980419,155.274646>}
      triangle {<-54.828763,-19.009708,155.274646>,<-54.828763,-19.009708,161.851296>,<-53.553625,-18.807751,161.851296>}
      triangle {<-54.828763,-19.009708,155.274646>,<-53.553625,-18.807751,161.851296>,<-53.553625,-18.807751,155.274646>}
      triangle {<-54.828763,-19.009708,161.851296>,<-55.287282,-17.598537,163.100009>,<-53.553625,-17.323956,163.100009>}
      triangle {<-54.828763,-19.009708,161.851296>,<-53.553625,-17.323956,163.100009>,<-53.553625,-18.807751,161.851296>}
      triangle {<-55.287282,-17.598537,163.100009>,<-55.623136,-16.564899,165.433196>,<-53.553625,-16.237125,165.433196>}
      triangle {<-55.287282,-17.598537,163.100009>,<-53.553625,-16.237125,165.433196>,<-53.553625,-17.323956,163.100009>}
      triangle {<-55.623136,-16.564899,165.433196>,<-55.853841,-15.854855,168.402773>,<-53.553625,-15.490543,168.402773>}
      triangle {<-55.623136,-16.564899,165.433196>,<-53.553625,-15.490543,168.402773>,<-53.553625,-16.237125,165.433196>}
      triangle {<-55.853841,-15.854855,168.402773>,<-55.996931,-15.414471,171.560601>,<-53.553625,-15.027485,171.560617>}
      triangle {<-55.853841,-15.854855,168.402773>,<-53.553625,-15.027485,171.560617>,<-53.553625,-15.490543,168.402773>}
      triangle {<-55.996931,-15.414471,171.560601>,<-56.069936,-15.189793,174.458659>,<-53.553625,-14.791248,174.458659>}
      triangle {<-55.996931,-15.414471,171.560601>,<-53.553625,-14.791248,174.458659>,<-53.553625,-15.027485,171.560617>}
      triangle {<-56.069936,-15.189793,174.458659>,<-56.090368,-15.126881,176.648778>,<-53.553625,-14.725109,176.648778>}
      triangle {<-56.069936,-15.189793,174.458659>,<-53.553625,-14.725109,176.648778>,<-53.553625,-14.791248,174.458659>}
      triangle {<-56.090368,-15.126881,176.648778>,<-55.961515,-15.523472,176.648778>,<-53.553625,-15.142109,176.648778>}
      triangle {<-56.090368,-15.126881,176.648778>,<-53.553625,-15.142109,176.648778>,<-53.553625,-14.725109,176.648778>}
      triangle {<-55.961515,-15.523472,176.648778>,<-55.927656,-15.627682,173.645400>,<-53.553625,-15.251667,173.645400>}
      triangle {<-55.961515,-15.523472,176.648778>,<-53.553625,-15.251667,173.645400>,<-53.553625,-15.142109,176.648778>}
      triangle {<-55.927656,-15.627682,173.645400>,<-55.835119,-15.912464,170.428505>,<-53.553625,-15.551113,170.428505>}
      triangle {<-55.927656,-15.627682,173.645400>,<-53.553625,-15.551113,170.428505>,<-53.553625,-15.251667,173.645400>}
      triangle {<-55.835119,-15.912464,170.428505>,<-55.665273,-16.435200,167.371030>,<-53.553625,-16.100758,167.371030>}
      triangle {<-55.835119,-15.912464,170.428505>,<-53.553625,-16.100758,167.371030>,<-53.553625,-15.551113,170.428505>}
      triangle {<-55.665273,-16.435200,167.371030>,<-55.399473,-17.253277,164.845854>,<-53.553625,-16.960926,164.845854>}
      triangle {<-55.665273,-16.435200,167.371030>,<-53.553625,-16.960926,164.845854>,<-53.553625,-16.100758,167.371030>}
      triangle {<-55.399473,-17.253277,164.845854>,<-55.019056,-18.424046,163.225940>,<-53.553625,-18.191959,163.225940>}
      triangle {<-55.399473,-17.253277,164.845854>,<-53.553625,-18.191959,163.225940>,<-53.553625,-16.960926,164.845854>}
      triangle {<-55.019056,-18.424046,163.225940>,<-54.505407,-20.004910,162.884233>,<-53.553625,-19.854160,162.884233>}
      triangle {<-55.019056,-18.424046,163.225940>,<-53.553625,-19.854160,162.884233>,<-53.553625,-18.191959,163.225940>}
      triangle {<-54.505407,-20.004910,162.884233>,<-54.513364,-19.980419,155.274646>,<-53.553625,-19.828411,155.274646>}
      triangle {<-54.505407,-20.004910,162.884233>,<-53.553625,-19.828411,155.274646>,<-53.553625,-19.854160,162.884233>}
      triangle {<-54.513364,-19.980419,155.274646>,<-54.828763,-19.009708,155.274646>,<-53.553625,-18.807751,155.274646>}
      triangle {<-54.513364,-19.980419,155.274646>,<-53.553625,-18.807751,155.274646>,<-53.553625,-19.828411,155.274646>}
      triangle {<-53.553625,-18.807751,155.274646>,<-53.553625,-18.807751,161.851296>,<-52.278471,-19.009708,161.851296>}
      triangle {<-53.553625,-18.807751,155.274646>,<-52.278471,-19.009708,161.851296>,<-52.278471,-19.009708,155.274646>}
      triangle {<-53.553625,-18.807751,161.851296>,<-53.553625,-17.323956,163.100009>,<-51.819952,-17.598537,163.100009>}
      triangle {<-53.553625,-18.807751,161.851296>,<-51.819952,-17.598537,163.100009>,<-52.278471,-19.009708,161.851296>}
      triangle {<-53.553625,-17.323956,163.100009>,<-53.553625,-16.237125,165.433196>,<-51.484106,-16.564899,165.433196>}
      triangle {<-53.553625,-17.323956,163.100009>,<-51.484106,-16.564899,165.433196>,<-51.819952,-17.598537,163.100009>}
      triangle {<-53.553625,-16.237125,165.433196>,<-53.553625,-15.490543,168.402773>,<-51.253400,-15.854855,168.402773>}
      triangle {<-53.553625,-16.237125,165.433196>,<-51.253400,-15.854855,168.402773>,<-51.484106,-16.564899,165.433196>}
      triangle {<-53.553625,-15.490543,168.402773>,<-53.553625,-15.027485,171.560617>,<-51.110303,-15.414471,171.560601>}
      triangle {<-53.553625,-15.490543,168.402773>,<-51.110303,-15.414471,171.560601>,<-51.253400,-15.854855,168.402773>}
      triangle {<-53.553625,-15.027485,171.560617>,<-53.553625,-14.791248,174.458659>,<-51.037298,-15.189793,174.458659>}
      triangle {<-53.553625,-15.027485,171.560617>,<-51.037298,-15.189793,174.458659>,<-51.110303,-15.414471,171.560601>}
      triangle {<-53.553625,-14.791248,174.458659>,<-53.553625,-14.725109,176.648778>,<-51.016859,-15.126881,176.648778>}
      triangle {<-53.553625,-14.791248,174.458659>,<-51.016859,-15.126881,176.648778>,<-51.037298,-15.189793,174.458659>}
      triangle {<-53.553625,-14.725109,176.648778>,<-53.553625,-15.142109,176.648778>,<-51.145727,-15.523472,176.648778>}
      triangle {<-53.553625,-14.725109,176.648778>,<-51.145727,-15.523472,176.648778>,<-51.016859,-15.126881,176.648778>}
      triangle {<-53.553625,-15.142109,176.648778>,<-53.553625,-15.251667,173.645400>,<-51.179586,-15.627682,173.645400>}
      triangle {<-53.553625,-15.142109,176.648778>,<-51.179586,-15.627682,173.645400>,<-51.145727,-15.523472,176.648778>}
      triangle {<-53.553625,-15.251667,173.645400>,<-53.553625,-15.551113,170.428505>,<-51.272108,-15.912464,170.428505>}
      triangle {<-53.553625,-15.251667,173.645400>,<-51.272108,-15.912464,170.428505>,<-51.179586,-15.627682,173.645400>}
      triangle {<-53.553625,-15.551113,170.428505>,<-53.553625,-16.100758,167.371030>,<-51.441961,-16.435200,167.371030>}
      triangle {<-53.553625,-15.551113,170.428505>,<-51.441961,-16.435200,167.371030>,<-51.272108,-15.912464,170.428505>}
      triangle {<-53.553625,-16.100758,167.371030>,<-53.553625,-16.960926,164.845854>,<-51.707769,-17.253277,164.845854>}
      triangle {<-53.553625,-16.100758,167.371030>,<-51.707769,-17.253277,164.845854>,<-51.441961,-16.435200,167.371030>}
      triangle {<-53.553625,-16.960926,164.845854>,<-53.553625,-18.191959,163.225940>,<-52.088178,-18.424046,163.225940>}
      triangle {<-53.553625,-16.960926,164.845854>,<-52.088178,-18.424046,163.225940>,<-51.707769,-17.253277,164.845854>}
      triangle {<-53.553625,-18.191959,163.225940>,<-53.553625,-19.854160,162.884233>,<-52.601827,-20.004910,162.884233>}
      triangle {<-53.553625,-18.191959,163.225940>,<-52.601827,-20.004910,162.884233>,<-52.088178,-18.424046,163.225940>}
      triangle {<-53.553625,-19.854160,162.884233>,<-53.553625,-19.828411,155.274646>,<-52.593870,-19.980412,155.274646>}
      triangle {<-53.553625,-19.854160,162.884233>,<-52.593870,-19.980412,155.274646>,<-52.601827,-20.004910,162.884233>}
      triangle {<-53.553625,-19.828411,155.274646>,<-53.553625,-18.807751,155.274646>,<-52.278471,-19.009708,155.274646>}
      triangle {<-53.553625,-19.828411,155.274646>,<-52.278471,-19.009708,155.274646>,<-52.593870,-19.980412,155.274646>}
      triangle {<-52.278471,-19.009708,155.274646>,<-52.278471,-19.009708,161.851296>,<-51.128149,-19.595837,161.851297>}
      triangle {<-52.278471,-19.009708,155.274646>,<-51.128149,-19.595837,161.851297>,<-51.128149,-19.595829,155.274646>}
      triangle {<-52.278471,-19.009708,161.851296>,<-51.819952,-17.598537,163.100009>,<-50.255994,-18.395420,163.100009>}
      triangle {<-52.278471,-19.009708,161.851296>,<-50.255994,-18.395420,163.100009>,<-51.128149,-19.595837,161.851297>}
      triangle {<-51.819952,-17.598537,163.100009>,<-51.484106,-16.564899,165.433196>,<-49.617170,-17.516163,165.433196>}
      triangle {<-51.819952,-17.598537,163.100009>,<-49.617170,-17.516163,165.433196>,<-50.255994,-18.395420,163.100009>}
      triangle {<-51.484106,-16.564899,165.433196>,<-51.253400,-15.854855,168.402773>,<-49.178335,-16.912159,168.402773>}
      triangle {<-51.484106,-16.564899,165.433196>,<-49.178335,-16.912159,168.402773>,<-49.617170,-17.516163,165.433196>}
      triangle {<-51.253400,-15.854855,168.402773>,<-51.110303,-15.414471,171.560601>,<-48.906164,-16.537533,171.560601>}
      triangle {<-51.253400,-15.854855,168.402773>,<-48.906164,-16.537533,171.560601>,<-49.178335,-16.912159,168.402773>}
      triangle {<-51.110303,-15.414471,171.560601>,<-51.037298,-15.189793,174.458659>,<-48.767301,-16.346416,174.458659>}
      triangle {<-51.110303,-15.414471,171.560601>,<-48.767301,-16.346416,174.458659>,<-48.906164,-16.537533,171.560601>}
      triangle {<-51.037298,-15.189793,174.458659>,<-51.016859,-15.126881,176.648778>,<-48.728429,-16.292904,176.648778>}
      triangle {<-51.037298,-15.189793,174.458659>,<-48.728429,-16.292904,176.648778>,<-48.767301,-16.346416,174.458659>}
      triangle {<-51.016859,-15.126881,176.648778>,<-51.145727,-15.523472,176.648778>,<-48.973539,-16.630268,176.648779>}
      triangle {<-51.016859,-15.126881,176.648778>,<-48.973539,-16.630268,176.648779>,<-48.728429,-16.292904,176.648778>}
      triangle {<-51.145727,-15.523472,176.648778>,<-51.179586,-15.627682,173.645400>,<-49.037939,-16.718914,173.645401>}
      triangle {<-51.145727,-15.523472,176.648778>,<-49.037939,-16.718914,173.645401>,<-48.973539,-16.630268,176.648779>}
      triangle {<-51.179586,-15.627682,173.645400>,<-51.272108,-15.912464,170.428505>,<-49.213941,-16.961163,170.428505>}
      triangle {<-51.179586,-15.627682,173.645400>,<-49.213941,-16.961163,170.428505>,<-49.037939,-16.718914,173.645401>}
      triangle {<-51.272108,-15.912464,170.428505>,<-51.441961,-16.435200,167.371030>,<-49.537015,-17.405834,167.371030>}
      triangle {<-51.272108,-15.912464,170.428505>,<-49.537015,-17.405834,167.371030>,<-49.213941,-16.961163,170.428505>}
      triangle {<-51.441961,-16.435200,167.371030>,<-51.707769,-17.253277,164.845854>,<-50.042615,-18.101719,164.845854>}
      triangle {<-51.441961,-16.435200,167.371030>,<-50.042615,-18.101719,164.845854>,<-49.537015,-17.405834,167.371030>}
      triangle {<-51.707769,-17.253277,164.845854>,<-52.088178,-18.424046,163.225940>,<-50.766187,-19.097645,163.225940>}
      triangle {<-51.707769,-17.253277,164.845854>,<-50.766187,-19.097645,163.225940>,<-50.042615,-18.101719,164.845854>}
      triangle {<-52.088178,-18.424046,163.225940>,<-52.601827,-20.004910,162.884233>,<-51.743215,-20.442402,162.884232>}
      triangle {<-52.088178,-18.424046,163.225940>,<-51.743215,-20.442402,162.884232>,<-50.766187,-19.097645,163.225940>}
      triangle {<-52.601827,-20.004910,162.884233>,<-52.593870,-19.980412,155.274646>,<-51.728078,-20.421566,155.274646>}
      triangle {<-52.601827,-20.004910,162.884233>,<-51.728078,-20.421566,155.274646>,<-51.743215,-20.442402,162.884232>}
      triangle {<-52.593870,-19.980412,155.274646>,<-52.278471,-19.009708,155.274646>,<-51.128149,-19.595829,155.274646>}
      triangle {<-52.593870,-19.980412,155.274646>,<-51.128149,-19.595829,155.274646>,<-51.728078,-20.421566,155.274646>}
      triangle {<-51.128149,-19.595829,155.274646>,<-51.128149,-19.595837,161.851297>,<-50.215238,-20.508739,161.851297>}
      triangle {<-51.128149,-19.595829,155.274646>,<-50.215238,-20.508739,161.851297>,<-50.215238,-20.508739,155.274646>}
      triangle {<-51.128149,-19.595837,161.851297>,<-50.255994,-18.395420,163.100009>,<-49.014822,-19.636593,163.100009>}
      triangle {<-51.128149,-19.595837,161.851297>,<-49.014822,-19.636593,163.100009>,<-50.215238,-20.508739,161.851297>}
      triangle {<-50.255994,-18.395420,163.100009>,<-49.617170,-17.516163,165.433196>,<-48.135557,-18.997768,165.433196>}
      triangle {<-50.255994,-18.395420,163.100009>,<-48.135557,-18.997768,165.433196>,<-49.014822,-19.636593,163.100009>}
      triangle {<-49.617170,-17.516163,165.433196>,<-49.178335,-16.912159,168.402773>,<-47.531553,-18.558933,168.402773>}
      triangle {<-49.617170,-17.516163,165.433196>,<-47.531553,-18.558933,168.402773>,<-48.135557,-18.997768,165.433196>}
      triangle {<-49.178335,-16.912159,168.402773>,<-48.906164,-16.537533,171.560601>,<-47.156942,-18.286755,171.560601>}
      triangle {<-49.178335,-16.912159,168.402773>,<-47.156942,-18.286755,171.560601>,<-47.531553,-18.558933,168.402773>}
      triangle {<-48.906164,-16.537533,171.560601>,<-48.767301,-16.346416,174.458659>,<-46.965818,-18.147900,174.458660>}
      triangle {<-48.906164,-16.537533,171.560601>,<-46.965818,-18.147900,174.458660>,<-47.156942,-18.286755,171.560601>}
      triangle {<-48.767301,-16.346416,174.458659>,<-48.728429,-16.292904,176.648778>,<-46.912305,-18.109020,176.648767>}
      triangle {<-48.767301,-16.346416,174.458659>,<-46.912305,-18.109020,176.648767>,<-46.965818,-18.147900,174.458660>}
      triangle {<-48.728429,-16.292904,176.648778>,<-48.973539,-16.630268,176.648779>,<-47.249670,-18.354122,176.648767>}
      triangle {<-48.728429,-16.292904,176.648778>,<-47.249670,-18.354122,176.648767>,<-46.912305,-18.109020,176.648767>}
      triangle {<-48.973539,-16.630268,176.648779>,<-49.037939,-16.718914,173.645401>,<-47.338315,-18.418530,173.645417>}
      triangle {<-48.973539,-16.630268,176.648779>,<-47.338315,-18.418530,173.645417>,<-47.249670,-18.354122,176.648767>}
      triangle {<-49.037939,-16.718914,173.645401>,<-49.213941,-16.961163,170.428505>,<-47.580564,-18.594532,170.428522>}
      triangle {<-49.037939,-16.718914,173.645401>,<-47.580564,-18.594532,170.428522>,<-47.338315,-18.418530,173.645417>}
      triangle {<-49.213941,-16.961163,170.428505>,<-49.537015,-17.405834,167.371030>,<-48.025236,-18.917606,167.371030>}
      triangle {<-49.213941,-16.961163,170.428505>,<-48.025236,-18.917606,167.371030>,<-47.580564,-18.594532,170.428522>}
      triangle {<-49.537015,-17.405834,167.371030>,<-50.042615,-18.101719,164.845854>,<-48.721120,-19.423199,164.845854>}
      triangle {<-49.537015,-17.405834,167.371030>,<-48.721120,-19.423199,164.845854>,<-48.025236,-18.917606,167.371030>}
      triangle {<-50.042615,-18.101719,164.845854>,<-50.766187,-19.097645,163.225940>,<-49.717046,-20.146786,163.225940>}
      triangle {<-50.042615,-18.101719,164.845854>,<-49.717046,-20.146786,163.225940>,<-48.721120,-19.423199,164.845854>}
      triangle {<-50.766187,-19.097645,163.225940>,<-51.743215,-20.442402,162.884232>,<-51.061803,-21.123806,162.884232>}
      triangle {<-50.766187,-19.097645,163.225940>,<-51.061803,-21.123806,162.884232>,<-49.717046,-20.146786,163.225940>}
      triangle {<-51.743215,-20.442402,162.884232>,<-51.728078,-20.421566,155.274646>,<-51.040967,-21.108662,155.274646>}
      triangle {<-51.743215,-20.442402,162.884232>,<-51.040967,-21.108662,155.274646>,<-51.061803,-21.123806,162.884232>}
      triangle {<-51.728078,-20.421566,155.274646>,<-51.128149,-19.595829,155.274646>,<-50.215238,-20.508739,155.274646>}
      triangle {<-51.728078,-20.421566,155.274646>,<-50.215238,-20.508739,155.274646>,<-51.040967,-21.108662,155.274646>}
      triangle {<-50.215238,-20.508739,155.274646>,<-50.215238,-20.508739,161.851297>,<-49.629125,-21.659061,161.851297>}
      triangle {<-50.215238,-20.508739,155.274646>,<-49.629125,-21.659061,161.851297>,<-49.629125,-21.659061,155.274646>}
      triangle {<-50.215238,-20.508739,161.851297>,<-49.014822,-19.636593,163.100009>,<-48.217947,-21.200542,163.100009>}
      triangle {<-50.215238,-20.508739,161.851297>,<-48.217947,-21.200542,163.100009>,<-49.629125,-21.659061,161.851297>}
      triangle {<-49.014822,-19.636593,163.100009>,<-48.135557,-18.997768,165.433196>,<-47.184316,-20.864697,165.433196>}
      triangle {<-49.014822,-19.636593,163.100009>,<-47.184316,-20.864697,165.433196>,<-48.217947,-21.200542,163.100009>}
      triangle {<-48.135557,-18.997768,165.433196>,<-47.531553,-18.558933,168.402773>,<-46.474271,-20.633991,168.402772>}
      triangle {<-48.135557,-18.997768,165.433196>,<-46.474271,-20.633991,168.402772>,<-47.184316,-20.864697,165.433196>}
      triangle {<-47.531553,-18.558933,168.402773>,<-47.156942,-18.286755,171.560601>,<-46.033880,-20.490902,171.560601>}
      triangle {<-47.531553,-18.558933,168.402773>,<-46.033880,-20.490902,171.560601>,<-46.474271,-20.633991,168.402772>}
      triangle {<-47.156942,-18.286755,171.560601>,<-46.965818,-18.147900,174.458660>,<-45.809209,-20.417896,174.458659>}
      triangle {<-47.156942,-18.286755,171.560601>,<-45.809209,-20.417896,174.458659>,<-46.033880,-20.490902,171.560601>}
      triangle {<-46.965818,-18.147900,174.458660>,<-46.912305,-18.109020,176.648767>,<-45.746297,-20.397457,176.648767>}
      triangle {<-46.965818,-18.147900,174.458660>,<-45.746297,-20.397457,176.648767>,<-45.809209,-20.417896,174.458659>}
      triangle {<-46.912305,-18.109020,176.648767>,<-47.249670,-18.354122,176.648767>,<-46.142889,-20.526318,176.648767>}
      triangle {<-46.912305,-18.109020,176.648767>,<-46.142889,-20.526318,176.648767>,<-45.746297,-20.397457,176.648767>}
      triangle {<-47.249670,-18.354122,176.648767>,<-47.338315,-18.418530,173.645417>,<-46.247091,-20.560177,173.645400>}
      triangle {<-47.249670,-18.354122,176.648767>,<-46.247091,-20.560177,173.645400>,<-46.142889,-20.526318,176.648767>}
      triangle {<-47.338315,-18.418530,173.645417>,<-47.580564,-18.594532,170.428522>,<-46.531873,-20.652714,170.428505>}
      triangle {<-47.338315,-18.418530,173.645417>,<-46.531873,-20.652714,170.428505>,<-46.247091,-20.560177,173.645400>}
      triangle {<-47.580564,-18.594532,170.428522>,<-48.025236,-18.917606,167.371030>,<-47.054616,-20.822559,167.371030>}
      triangle {<-47.580564,-18.594532,170.428522>,<-47.054616,-20.822559,167.371030>,<-46.531873,-20.652714,170.428505>}
      triangle {<-48.025236,-18.917606,167.371030>,<-48.721120,-19.423199,164.845854>,<-47.872686,-21.088360,164.845854>}
      triangle {<-48.025236,-18.917606,167.371030>,<-47.872686,-21.088360,164.845854>,<-47.054616,-20.822559,167.371030>}
      triangle {<-48.721120,-19.423199,164.845854>,<-49.717046,-20.146786,163.225940>,<-49.043462,-21.468777,163.225940>}
      triangle {<-48.721120,-19.423199,164.845854>,<-49.043462,-21.468777,163.225940>,<-47.872686,-21.088360,164.845854>}
      triangle {<-49.717046,-20.146786,163.225940>,<-51.061803,-21.123806,162.884232>,<-50.624326,-21.982426,162.884233>}
      triangle {<-49.717046,-20.146786,163.225940>,<-50.624326,-21.982426,162.884233>,<-49.043462,-21.468777,163.225940>}
      triangle {<-51.061803,-21.123806,162.884232>,<-51.040967,-21.108662,155.274646>,<-50.599828,-21.974468,155.274646>}
      triangle {<-51.061803,-21.123806,162.884232>,<-50.599828,-21.974468,155.274646>,<-50.624326,-21.982426,162.884233>}
      triangle {<-51.040967,-21.108662,155.274646>,<-50.215238,-20.508739,155.274646>,<-49.629125,-21.659061,155.274646>}
      triangle {<-51.040967,-21.108662,155.274646>,<-49.629125,-21.659061,155.274646>,<-50.599828,-21.974468,155.274646>}
      triangle {<-49.629125,-21.659061,155.274646>,<-49.629125,-21.659061,161.851297>,<-49.427152,-22.934216,161.851264>}
      triangle {<-49.629125,-21.659061,155.274646>,<-49.427152,-22.934216,161.851264>,<-49.427152,-22.934208,155.274646>}
      triangle {<-49.629125,-21.659061,161.851297>,<-48.217947,-21.200542,163.100009>,<-47.943357,-22.934216,163.100008>}
      triangle {<-49.629125,-21.659061,161.851297>,<-47.943357,-22.934216,163.100008>,<-49.427152,-22.934216,161.851264>}
      triangle {<-48.217947,-21.200542,163.100009>,<-47.184316,-20.864697,165.433196>,<-46.856527,-22.934216,165.433195>}
      triangle {<-48.217947,-21.200542,163.100009>,<-46.856527,-22.934216,165.433195>,<-47.943357,-22.934216,163.100008>}
      triangle {<-47.184316,-20.864697,165.433196>,<-46.474271,-20.633991,168.402772>,<-46.109937,-22.934216,168.402772>}
      triangle {<-47.184316,-20.864697,165.433196>,<-46.109937,-22.934216,168.402772>,<-46.856527,-22.934216,165.433195>}
      triangle {<-46.474271,-20.633991,168.402772>,<-46.033880,-20.490902,171.560601>,<-45.646894,-22.934216,171.560601>}
      triangle {<-46.474271,-20.633991,168.402772>,<-45.646894,-22.934216,171.560601>,<-46.109937,-22.934216,168.402772>}
      triangle {<-46.033880,-20.490902,171.560601>,<-45.809209,-20.417896,174.458659>,<-45.410657,-22.934216,174.458659>}
      triangle {<-46.033880,-20.490902,171.560601>,<-45.410657,-22.934216,174.458659>,<-45.646894,-22.934216,171.560601>}
      triangle {<-45.809209,-20.417896,174.458659>,<-45.746297,-20.397457,176.648767>,<-45.344503,-22.934216,176.648767>}
      triangle {<-45.809209,-20.417896,174.458659>,<-45.344503,-22.934216,176.648767>,<-45.410657,-22.934216,174.458659>}
      triangle {<-45.746297,-20.397457,176.648767>,<-46.142889,-20.526318,176.648767>,<-45.761510,-22.934216,176.648767>}
      triangle {<-45.746297,-20.397457,176.648767>,<-45.761510,-22.934216,176.648767>,<-45.344503,-22.934216,176.648767>}
      triangle {<-46.142889,-20.526318,176.648767>,<-46.247091,-20.560177,173.645400>,<-45.871076,-22.934216,173.645401>}
      triangle {<-46.142889,-20.526318,176.648767>,<-45.871076,-22.934216,173.645401>,<-45.761510,-22.934216,176.648767>}
      triangle {<-46.247091,-20.560177,173.645400>,<-46.531873,-20.652714,170.428505>,<-46.170515,-22.934216,170.428505>}
      triangle {<-46.247091,-20.560177,173.645400>,<-46.170515,-22.934216,170.428505>,<-45.871076,-22.934216,173.645401>}
      triangle {<-46.531873,-20.652714,170.428505>,<-47.054616,-20.822559,167.371030>,<-46.720151,-22.934216,167.371029>}
      triangle {<-46.531873,-20.652714,170.428505>,<-46.720151,-22.934216,167.371029>,<-46.170515,-22.934216,170.428505>}
      triangle {<-47.054616,-20.822559,167.371030>,<-47.872686,-21.088360,164.845854>,<-47.580328,-22.934216,164.845853>}
      triangle {<-47.054616,-20.822559,167.371030>,<-47.580328,-22.934216,164.845853>,<-46.720151,-22.934216,167.371029>}
      triangle {<-47.872686,-21.088360,164.845854>,<-49.043462,-21.468777,163.225940>,<-48.811353,-22.934216,163.225939>}
      triangle {<-47.872686,-21.088360,164.845854>,<-48.811353,-22.934216,163.225939>,<-47.580328,-22.934216,164.845853>}
      triangle {<-49.043462,-21.468777,163.225940>,<-50.624326,-21.982426,162.884233>,<-50.473569,-22.934216,162.884232>}
      triangle {<-49.043462,-21.468777,163.225940>,<-50.473569,-22.934216,162.884232>,<-48.811353,-22.934216,163.225939>}
      triangle {<-50.624326,-21.982426,162.884233>,<-50.599828,-21.974468,155.274646>,<-50.447820,-22.934208,155.274646>}
      triangle {<-50.624326,-21.982426,162.884233>,<-50.447820,-22.934208,155.274646>,<-50.473569,-22.934216,162.884232>}
      triangle {<-50.599828,-21.974468,155.274646>,<-49.629125,-21.659061,155.274646>,<-49.427152,-22.934208,155.274646>}
      triangle {<-50.599828,-21.974468,155.274646>,<-49.427152,-22.934208,155.274646>,<-50.447820,-22.934208,155.274646>}
      texture{_Heck11}
    }
    //_Duse02
    mesh{
      triangle {<29.781481,-13.864025,170.550524>,<29.532183,-12.610722,170.550524>,<30.288622,-12.297390,176.300127>}
      triangle {<29.781481,-13.864025,170.550524>,<30.288622,-12.297390,176.300127>,<30.600237,-13.864025,176.300128>}
      triangle {<29.532183,-12.610722,170.550524>,<28.822245,-11.548222,170.550524>,<29.401194,-10.969265,176.300127>}
      triangle {<29.532183,-12.610722,170.550524>,<29.401194,-10.969265,176.300127>,<30.288622,-12.297390,176.300127>}
      triangle {<28.822245,-11.548222,170.550524>,<27.759745,-10.838276,170.550523>,<28.073069,-10.081844,176.300127>}
      triangle {<28.822245,-11.548222,170.550524>,<28.073069,-10.081844,176.300127>,<29.401194,-10.969265,176.300127>}
      triangle {<27.759745,-10.838276,170.550523>,<26.506434,-10.588985,170.550523>,<26.506434,-9.770222,176.300127>}
      triangle {<27.759745,-10.838276,170.550523>,<26.506434,-9.770222,176.300127>,<28.073069,-10.081844,176.300127>}
      triangle {<26.506434,-10.588985,170.550523>,<25.253130,-10.838276,170.550523>,<24.939806,-10.081844,176.300127>}
      triangle {<26.506434,-10.588985,170.550523>,<24.939806,-10.081844,176.300127>,<26.506434,-9.770222,176.300127>}
      triangle {<25.253130,-10.838276,170.550523>,<24.190630,-11.548222,170.550524>,<23.611681,-10.969265,176.300127>}
      triangle {<25.253130,-10.838276,170.550523>,<23.611681,-10.969265,176.300127>,<24.939806,-10.081844,176.300127>}
      triangle {<24.190630,-11.548222,170.550524>,<23.480692,-12.610722,170.550524>,<22.724253,-12.297390,176.300127>}
      triangle {<24.190630,-11.548222,170.550524>,<22.724253,-12.297390,176.300127>,<23.611681,-10.969265,176.300127>}
      triangle {<23.480692,-12.610722,170.550524>,<23.231394,-13.864025,170.550524>,<22.412631,-13.864025,176.300128>}
      triangle {<23.480692,-12.610722,170.550524>,<22.412631,-13.864025,176.300128>,<22.724253,-12.297390,176.300127>}
      triangle {<23.231394,-13.864025,170.550524>,<23.480692,-15.117329,170.550524>,<22.724253,-15.430660,176.300128>}
      triangle {<23.231394,-13.864025,170.550524>,<22.724253,-15.430660,176.300128>,<22.412631,-13.864025,176.300128>}
      triangle {<23.480692,-15.117329,170.550524>,<24.190630,-16.179829,170.550524>,<23.611681,-16.758778,176.300128>}
      triangle {<23.480692,-15.117329,170.550524>,<23.611681,-16.758778,176.300128>,<22.724253,-15.430660,176.300128>}
      triangle {<24.190630,-16.179829,170.550524>,<25.253130,-16.889774,170.550524>,<24.939806,-17.646206,176.300128>}
      triangle {<24.190630,-16.179829,170.550524>,<24.939806,-17.646206,176.300128>,<23.611681,-16.758778,176.300128>}
      triangle {<25.253130,-16.889774,170.550524>,<26.506434,-17.139065,170.550524>,<26.506434,-17.957829,176.300128>}
      triangle {<25.253130,-16.889774,170.550524>,<26.506434,-17.957829,176.300128>,<24.939806,-17.646206,176.300128>}
      triangle {<26.506434,-17.139065,170.550524>,<27.759745,-16.889774,170.550524>,<28.073069,-17.646206,176.300128>}
      triangle {<26.506434,-17.139065,170.550524>,<28.073069,-17.646206,176.300128>,<26.506434,-17.957829,176.300128>}
      triangle {<27.759745,-16.889774,170.550524>,<28.822245,-16.179829,170.550524>,<29.401194,-16.758778,176.300128>}
      triangle {<27.759745,-16.889774,170.550524>,<29.401194,-16.758778,176.300128>,<28.073069,-17.646206,176.300128>}
      triangle {<28.822245,-16.179829,170.550524>,<29.532183,-15.117329,170.550524>,<30.288622,-15.430653,176.300128>}
      triangle {<28.822245,-16.179829,170.550524>,<30.288622,-15.430653,176.300128>,<29.401194,-16.758778,176.300128>}
      triangle {<29.532183,-15.117329,170.550524>,<29.781481,-13.864025,170.550524>,<30.600237,-13.864025,176.300128>}
      triangle {<29.532183,-15.117329,170.550524>,<30.600237,-13.864025,176.300128>,<30.288622,-15.430653,176.300128>}
      triangle {<29.502749,-13.864025,170.550524>,<29.966731,-12.430721,176.300127>,<29.274668,-12.717388,170.550524>}
      triangle {<29.502749,-13.864025,170.550524>,<30.251833,-13.864025,176.300128>,<29.966731,-12.430721,176.300127>}
      triangle {<29.274668,-12.717388,170.550524>,<29.154833,-11.215626,176.300127>,<28.625147,-11.745312,170.550524>}
      triangle {<29.274668,-12.717388,170.550524>,<29.966731,-12.430721,176.300127>,<29.154833,-11.215626,176.300127>}
      triangle {<28.625147,-11.745312,170.550524>,<27.939738,-10.403736,176.300127>,<27.653079,-11.095783,170.550523>}
      triangle {<28.625147,-11.745312,170.550524>,<29.154833,-11.215626,176.300127>,<27.939738,-10.403736,176.300127>}
      triangle {<27.653079,-11.095783,170.550523>,<26.506434,-10.118633,176.300127>,<26.506434,-10.867710,170.550523>}
      triangle {<27.653079,-11.095783,170.550523>,<27.939738,-10.403736,176.300127>,<26.506434,-10.118633,176.300127>}
      triangle {<26.506434,-10.867710,170.550523>,<25.073138,-10.403736,176.300127>,<25.359797,-11.095783,170.550523>}
      triangle {<26.506434,-10.867710,170.550523>,<26.506434,-10.118633,176.300127>,<25.073138,-10.403736,176.300127>}
      triangle {<25.359797,-11.095783,170.550523>,<23.858042,-11.215626,176.300127>,<24.387721,-11.745312,170.550524>}
      triangle {<25.359797,-11.095783,170.550523>,<25.073138,-10.403736,176.300127>,<23.858042,-11.215626,176.300127>}
      triangle {<24.387721,-11.745312,170.550524>,<23.046137,-12.430721,176.300127>,<23.738207,-12.717388,170.550524>}
      triangle {<24.387721,-11.745312,170.550524>,<23.858042,-11.215626,176.300127>,<23.046137,-12.430721,176.300127>}
      triangle {<23.738207,-12.717388,170.550524>,<22.761042,-13.864025,176.300128>,<23.510119,-13.864025,170.550524>}
      triangle {<23.738207,-12.717388,170.550524>,<23.046137,-12.430721,176.300127>,<22.761042,-13.864025,176.300128>}
      triangle {<23.510119,-13.864025,170.550524>,<23.046137,-15.297321,176.300128>,<23.738207,-15.010662,170.550524>}
      triangle {<23.510119,-13.864025,170.550524>,<22.761042,-13.864025,176.300128>,<23.046137,-15.297321,176.300128>}
      triangle {<23.738207,-15.010662,170.550524>,<23.858042,-16.512417,176.300128>,<24.387721,-15.982738,170.550524>}
      triangle {<23.738207,-15.010662,170.550524>,<23.046137,-15.297321,176.300128>,<23.858042,-16.512417,176.300128>}
      triangle {<24.387721,-15.982738,170.550524>,<25.073138,-17.324314,176.300128>,<25.359797,-16.632259,170.550524>}
      triangle {<24.387721,-15.982738,170.550524>,<23.858042,-16.512417,176.300128>,<25.073138,-17.324314,176.300128>}
      triangle {<25.359797,-16.632259,170.550524>,<26.506434,-17.609417,176.300128>,<26.506434,-16.860340,170.550524>}
      triangle {<25.359797,-16.632259,170.550524>,<25.073138,-17.324314,176.300128>,<26.506434,-17.609417,176.300128>}
      triangle {<26.506434,-16.860340,170.550524>,<27.939738,-17.324314,176.300128>,<27.653079,-16.632259,170.550524>}
      triangle {<26.506434,-16.860340,170.550524>,<26.506434,-17.609417,176.300128>,<27.939738,-17.324314,176.300128>}
      triangle {<27.653079,-16.632259,170.550524>,<29.154833,-16.512417,176.300128>,<28.625147,-15.982738,170.550524>}
      triangle {<27.653079,-16.632259,170.550524>,<27.939738,-17.324314,176.300128>,<29.154833,-16.512417,176.300128>}
      triangle {<28.625147,-15.982738,170.550524>,<29.966731,-15.297321,176.300128>,<29.274676,-15.010662,170.550524>}
      triangle {<28.625147,-15.982738,170.550524>,<29.154833,-16.512417,176.300128>,<29.966731,-15.297321,176.300128>}
      triangle {<29.274676,-15.010662,170.550524>,<30.251833,-13.864025,176.300128>,<29.502749,-13.864025,170.550524>}
      triangle {<29.274676,-15.010662,170.550524>,<29.966731,-15.297321,176.300128>,<30.251833,-13.864025,176.300128>}
      triangle {<29.781481,-13.864025,170.550524>,<29.502749,-13.864025,170.550524>,<29.274668,-12.717388,170.550524>}
      triangle {<29.781481,-13.864025,170.550524>,<29.274668,-12.717388,170.550524>,<29.532183,-12.610722,170.550524>}
      triangle {<29.532183,-12.610722,170.550524>,<29.274668,-12.717388,170.550524>,<28.625147,-11.745312,170.550524>}
      triangle {<29.532183,-12.610722,170.550524>,<28.625147,-11.745312,170.550524>,<28.822245,-11.548222,170.550524>}
      triangle {<28.822245,-11.548222,170.550524>,<28.625147,-11.745312,170.550524>,<27.653079,-11.095783,170.550523>}
      triangle {<28.822245,-11.548222,170.550524>,<27.653079,-11.095783,170.550523>,<27.759745,-10.838276,170.550523>}
      triangle {<27.759745,-10.838276,170.550523>,<27.653079,-11.095783,170.550523>,<26.506434,-10.867710,170.550523>}
      triangle {<27.759745,-10.838276,170.550523>,<26.506434,-10.867710,170.550523>,<26.506434,-10.588985,170.550523>}
      triangle {<26.506434,-10.588985,170.550523>,<26.506434,-10.867710,170.550523>,<25.359797,-11.095783,170.550523>}
      triangle {<26.506434,-10.588985,170.550523>,<25.359797,-11.095783,170.550523>,<25.253130,-10.838276,170.550523>}
      triangle {<25.253130,-10.838276,170.550523>,<25.359797,-11.095783,170.550523>,<24.387721,-11.745312,170.550524>}
      triangle {<25.253130,-10.838276,170.550523>,<24.387721,-11.745312,170.550524>,<24.190630,-11.548222,170.550524>}
      triangle {<24.190630,-11.548222,170.550524>,<24.387721,-11.745312,170.550524>,<23.738207,-12.717388,170.550524>}
      triangle {<24.190630,-11.548222,170.550524>,<23.738207,-12.717388,170.550524>,<23.480692,-12.610722,170.550524>}
      triangle {<23.480692,-12.610722,170.550524>,<23.738207,-12.717388,170.550524>,<23.510119,-13.864025,170.550524>}
      triangle {<23.480692,-12.610722,170.550524>,<23.510119,-13.864025,170.550524>,<23.231394,-13.864025,170.550524>}
      triangle {<23.231394,-13.864025,170.550524>,<23.510119,-13.864025,170.550524>,<23.738207,-15.010662,170.550524>}
      triangle {<23.231394,-13.864025,170.550524>,<23.738207,-15.010662,170.550524>,<23.480692,-15.117329,170.550524>}
      triangle {<23.480692,-15.117329,170.550524>,<23.738207,-15.010662,170.550524>,<24.387721,-15.982738,170.550524>}
      triangle {<23.480692,-15.117329,170.550524>,<24.387721,-15.982738,170.550524>,<24.190630,-16.179829,170.550524>}
      triangle {<24.190630,-16.179829,170.550524>,<24.387721,-15.982738,170.550524>,<25.359797,-16.632259,170.550524>}
      triangle {<24.190630,-16.179829,170.550524>,<25.359797,-16.632259,170.550524>,<25.253130,-16.889774,170.550524>}
      triangle {<25.253130,-16.889774,170.550524>,<25.359797,-16.632259,170.550524>,<26.506434,-16.860340,170.550524>}
      triangle {<25.253130,-16.889774,170.550524>,<26.506434,-16.860340,170.550524>,<26.506434,-17.139065,170.550524>}
      triangle {<26.506434,-17.139065,170.550524>,<26.506434,-16.860340,170.550524>,<27.653079,-16.632259,170.550524>}
      triangle {<26.506434,-17.139065,170.550524>,<27.653079,-16.632259,170.550524>,<27.759745,-16.889774,170.550524>}
      triangle {<27.759745,-16.889774,170.550524>,<27.653079,-16.632259,170.550524>,<28.625147,-15.982738,170.550524>}
      triangle {<27.759745,-16.889774,170.550524>,<28.625147,-15.982738,170.550524>,<28.822245,-16.179829,170.550524>}
      triangle {<28.822245,-16.179829,170.550524>,<28.625147,-15.982738,170.550524>,<29.274676,-15.010662,170.550524>}
      triangle {<28.822245,-16.179829,170.550524>,<29.274676,-15.010662,170.550524>,<29.532183,-15.117329,170.550524>}
      triangle {<29.532183,-15.117329,170.550524>,<29.274676,-15.010662,170.550524>,<29.502749,-13.864025,170.550524>}
      triangle {<29.532183,-15.117329,170.550524>,<29.502749,-13.864025,170.550524>,<29.781481,-13.864025,170.550524>}
      triangle {<30.600237,-13.864025,176.300128>,<30.288622,-12.297390,176.300127>,<29.966731,-12.430721,176.300127>}
      triangle {<30.600237,-13.864025,176.300128>,<29.966731,-12.430721,176.300127>,<30.251833,-13.864025,176.300128>}
      triangle {<30.288622,-12.297390,176.300127>,<29.401194,-10.969265,176.300127>,<29.154833,-11.215626,176.300127>}
      triangle {<30.288622,-12.297390,176.300127>,<29.154833,-11.215626,176.300127>,<29.966731,-12.430721,176.300127>}
      triangle {<29.401194,-10.969265,176.300127>,<28.073069,-10.081844,176.300127>,<27.939738,-10.403736,176.300127>}
      triangle {<29.401194,-10.969265,176.300127>,<27.939738,-10.403736,176.300127>,<29.154833,-11.215626,176.300127>}
      triangle {<28.073069,-10.081844,176.300127>,<26.506434,-9.770222,176.300127>,<26.506434,-10.118633,176.300127>}
      triangle {<28.073069,-10.081844,176.300127>,<26.506434,-10.118633,176.300127>,<27.939738,-10.403736,176.300127>}
      triangle {<26.506434,-9.770222,176.300127>,<24.939806,-10.081844,176.300127>,<25.073138,-10.403736,176.300127>}
      triangle {<26.506434,-9.770222,176.300127>,<25.073138,-10.403736,176.300127>,<26.506434,-10.118633,176.300127>}
      triangle {<24.939806,-10.081844,176.300127>,<23.611681,-10.969265,176.300127>,<23.858042,-11.215626,176.300127>}
      triangle {<24.939806,-10.081844,176.300127>,<23.858042,-11.215626,176.300127>,<25.073138,-10.403736,176.300127>}
      triangle {<23.611681,-10.969265,176.300127>,<22.724253,-12.297390,176.300127>,<23.046137,-12.430721,176.300127>}
      triangle {<23.611681,-10.969265,176.300127>,<23.046137,-12.430721,176.300127>,<23.858042,-11.215626,176.300127>}
      triangle {<22.724253,-12.297390,176.300127>,<22.412631,-13.864025,176.300128>,<22.761042,-13.864025,176.300128>}
      triangle {<22.724253,-12.297390,176.300127>,<22.761042,-13.864025,176.300128>,<23.046137,-12.430721,176.300127>}
      triangle {<22.412631,-13.864025,176.300128>,<22.724253,-15.430660,176.300128>,<23.046137,-15.297321,176.300128>}
      triangle {<22.412631,-13.864025,176.300128>,<23.046137,-15.297321,176.300128>,<22.761042,-13.864025,176.300128>}
      triangle {<22.724253,-15.430660,176.300128>,<23.611681,-16.758778,176.300128>,<23.858042,-16.512417,176.300128>}
      triangle {<22.724253,-15.430660,176.300128>,<23.858042,-16.512417,176.300128>,<23.046137,-15.297321,176.300128>}
      triangle {<23.611681,-16.758778,176.300128>,<24.939806,-17.646206,176.300128>,<25.073138,-17.324314,176.300128>}
      triangle {<23.611681,-16.758778,176.300128>,<25.073138,-17.324314,176.300128>,<23.858042,-16.512417,176.300128>}
      triangle {<24.939806,-17.646206,176.300128>,<26.506434,-17.957829,176.300128>,<26.506434,-17.609417,176.300128>}
      triangle {<24.939806,-17.646206,176.300128>,<26.506434,-17.609417,176.300128>,<25.073138,-17.324314,176.300128>}
      triangle {<26.506434,-17.957829,176.300128>,<28.073069,-17.646206,176.300128>,<27.939738,-17.324314,176.300128>}
      triangle {<26.506434,-17.957829,176.300128>,<27.939738,-17.324314,176.300128>,<26.506434,-17.609417,176.300128>}
      triangle {<28.073069,-17.646206,176.300128>,<29.401194,-16.758778,176.300128>,<29.154833,-16.512417,176.300128>}
      triangle {<28.073069,-17.646206,176.300128>,<29.154833,-16.512417,176.300128>,<27.939738,-17.324314,176.300128>}
      triangle {<29.401194,-16.758778,176.300128>,<30.288622,-15.430653,176.300128>,<29.966731,-15.297321,176.300128>}
      triangle {<29.401194,-16.758778,176.300128>,<29.966731,-15.297321,176.300128>,<29.154833,-16.512417,176.300128>}
      triangle {<30.288622,-15.430653,176.300128>,<30.600237,-13.864025,176.300128>,<30.251833,-13.864025,176.300128>}
      triangle {<30.288622,-15.430653,176.300128>,<30.251833,-13.864025,176.300128>,<29.966731,-15.297321,176.300128>}
      triangle {<29.866313,-12.472317,174.875943>,<27.999712,-13.245487,175.600393>,<28.122744,-13.864025,175.600393>}
      triangle {<30.143130,-13.864025,174.875943>,<29.866313,-12.472317,174.875943>,<28.122744,-13.864025,175.600393>}
      triangle {<29.077960,-11.292484,174.875943>,<27.649340,-12.721127,175.600393>,<27.999712,-13.245487,175.600393>}
      triangle {<29.866313,-12.472317,174.875943>,<29.077960,-11.292484,174.875943>,<27.999712,-13.245487,175.600393>}
      triangle {<27.898127,-10.504154,174.875943>,<27.124972,-12.370754,175.600393>,<27.649340,-12.721127,175.600393>}
      triangle {<29.077960,-11.292484,174.875943>,<27.898127,-10.504154,174.875943>,<27.649340,-12.721127,175.600393>}
      triangle {<26.506434,-10.227329,174.875942>,<26.506434,-12.247715,175.600393>,<27.124972,-12.370754,175.600393>}
      triangle {<27.898127,-10.504154,174.875943>,<26.506434,-10.227329,174.875942>,<27.124972,-12.370754,175.600393>}
      triangle {<25.114726,-10.504154,174.875943>,<25.887888,-12.370754,175.600393>,<26.506434,-12.247715,175.600393>}
      triangle {<26.506434,-10.227329,174.875942>,<25.114726,-10.504154,174.875943>,<26.506434,-12.247715,175.600393>}
      triangle {<23.934893,-11.292484,174.875943>,<25.363535,-12.721127,175.600393>,<25.887888,-12.370754,175.600393>}
      triangle {<25.114726,-10.504154,174.875943>,<23.934893,-11.292484,174.875943>,<25.887888,-12.370754,175.600393>}
      triangle {<23.146548,-12.472317,174.875943>,<25.013163,-13.245487,175.600393>,<25.363535,-12.721127,175.600393>}
      triangle {<23.934893,-11.292484,174.875943>,<23.146548,-12.472317,174.875943>,<25.363535,-12.721127,175.600393>}
      triangle {<22.869730,-13.864025,174.875943>,<24.890116,-13.864025,175.600393>,<25.013163,-13.245487,175.600393>}
      triangle {<23.146548,-12.472317,174.875943>,<22.869730,-13.864025,174.875943>,<25.013163,-13.245487,175.600393>}
      triangle {<23.146548,-15.255749,174.875943>,<25.013163,-14.482563,175.600393>,<24.890116,-13.864025,175.600393>}
      triangle {<22.869730,-13.864025,174.875943>,<23.146548,-15.255749,174.875943>,<24.890116,-13.864025,175.600393>}
      triangle {<23.934893,-16.435551,174.875943>,<25.363535,-15.006924,175.600393>,<25.013163,-14.482563,175.600393>}
      triangle {<23.146548,-15.255749,174.875943>,<23.934893,-16.435551,174.875943>,<25.013163,-14.482563,175.600393>}
      triangle {<25.114726,-17.223896,174.875943>,<25.887888,-15.357296,175.600393>,<25.363535,-15.006924,175.600393>}
      triangle {<23.934893,-16.435551,174.875943>,<25.114726,-17.223896,174.875943>,<25.363535,-15.006924,175.600393>}
      triangle {<26.506434,-17.500713,174.875943>,<26.506434,-15.480335,175.600393>,<25.887888,-15.357296,175.600393>}
      triangle {<25.114726,-17.223896,174.875943>,<26.506434,-17.500713,174.875943>,<25.887888,-15.357296,175.600393>}
      triangle {<27.898127,-17.223896,174.875943>,<27.124972,-15.357296,175.600393>,<26.506434,-15.480335,175.600393>}
      triangle {<26.506434,-17.500713,174.875943>,<27.898127,-17.223896,174.875943>,<26.506434,-15.480335,175.600393>}
      triangle {<29.077960,-16.435551,174.875943>,<27.649340,-15.006924,175.600393>,<27.124972,-15.357296,175.600393>}
      triangle {<27.898127,-17.223896,174.875943>,<29.077960,-16.435551,174.875943>,<27.124972,-15.357296,175.600393>}
      triangle {<29.866313,-15.255718,174.875943>,<27.999712,-14.482563,175.600393>,<27.649340,-15.006924,175.600393>}
      triangle {<29.077960,-16.435551,174.875943>,<29.866313,-15.255718,174.875943>,<27.649340,-15.006924,175.600393>}
      triangle {<30.143130,-13.864025,174.875943>,<28.122744,-13.864025,175.600393>,<27.999712,-14.482563,175.600393>}
      triangle {<29.866313,-15.255718,174.875943>,<30.143130,-13.864025,174.875943>,<27.999712,-14.482563,175.600393>}
      triangle {<27.872622,-13.298130,175.600393>,<29.580363,-12.590763,174.875943>,<27.985186,-13.864025,175.600393>}
      triangle {<29.580363,-12.590763,174.875943>,<29.833621,-13.864025,174.875943>,<27.985186,-13.864025,175.600393>}
      triangle {<27.552065,-12.818386,175.600393>,<28.859118,-11.511341,174.875943>,<27.872622,-13.298130,175.600393>}
      triangle {<28.859118,-11.511341,174.875943>,<29.580363,-12.590763,174.875943>,<27.872622,-13.298130,175.600393>}
      triangle {<27.072329,-12.497822,175.600393>,<27.779696,-10.790104,174.875943>,<27.552065,-12.818386,175.600393>}
      triangle {<27.779696,-10.790104,174.875943>,<28.859118,-11.511341,174.875943>,<27.552065,-12.818386,175.600393>}
      triangle {<26.506434,-12.385273,175.600393>,<26.506434,-10.536839,174.875943>,<27.072329,-12.497822,175.600393>}
      triangle {<26.506434,-10.536839,174.875943>,<27.779696,-10.790104,174.875943>,<27.072329,-12.497822,175.600393>}
      triangle {<25.940539,-12.497822,175.600393>,<25.233180,-10.790104,174.875943>,<26.506434,-12.385273,175.600393>}
      triangle {<25.233180,-10.790104,174.875943>,<26.506434,-10.536839,174.875943>,<26.506434,-12.385273,175.600393>}
      triangle {<25.460795,-12.818386,175.600393>,<24.153750,-11.511341,174.875943>,<25.940539,-12.497822,175.600393>}
      triangle {<24.153750,-11.511341,174.875943>,<25.233180,-10.790104,174.875943>,<25.940539,-12.497822,175.600393>}
      triangle {<25.140246,-13.298130,175.600393>,<23.432490,-12.590763,174.875943>,<25.460795,-12.818386,175.600393>}
      triangle {<23.432490,-12.590763,174.875943>,<24.153750,-11.511341,174.875943>,<25.460795,-12.818386,175.600393>}
      triangle {<25.027682,-13.864025,175.600393>,<23.179232,-13.864025,174.875943>,<25.140246,-13.298130,175.600393>}
      triangle {<23.179232,-13.864025,174.875943>,<23.432490,-12.590763,174.875943>,<25.140246,-13.298130,175.600393>}
      triangle {<25.140246,-14.429920,175.600393>,<23.432490,-15.137287,174.875943>,<25.027682,-13.864025,175.600393>}
      triangle {<23.432490,-15.137287,174.875943>,<23.179232,-13.864025,174.875943>,<25.027682,-13.864025,175.600393>}
      triangle {<25.460795,-14.909664,175.600393>,<24.153750,-16.216709,174.875943>,<25.140246,-14.429920,175.600393>}
      triangle {<24.153750,-16.216709,174.875943>,<23.432490,-15.137287,174.875943>,<25.140246,-14.429920,175.600393>}
      triangle {<25.940539,-15.230221,175.600393>,<25.233180,-16.937954,174.875943>,<25.460795,-14.909664,175.600393>}
      triangle {<25.233180,-16.937954,174.875943>,<24.153750,-16.216709,174.875943>,<25.460795,-14.909664,175.600393>}
      triangle {<26.506434,-15.342770,175.600393>,<26.506434,-17.191212,174.875943>,<25.940539,-15.230221,175.600393>}
      triangle {<26.506434,-17.191212,174.875943>,<25.233180,-16.937954,174.875943>,<25.940539,-15.230221,175.600393>}
      triangle {<27.072329,-15.230221,175.600393>,<27.779696,-16.937954,174.875943>,<26.506434,-15.342770,175.600393>}
      triangle {<27.779696,-16.937954,174.875943>,<26.506434,-17.191212,174.875943>,<26.506434,-15.342770,175.600393>}
      triangle {<27.552065,-14.909664,175.600393>,<28.859118,-16.216709,174.875943>,<27.072329,-15.230221,175.600393>}
      triangle {<28.859118,-16.216709,174.875943>,<27.779696,-16.937954,174.875943>,<27.072329,-15.230221,175.600393>}
      triangle {<27.872622,-14.429920,175.600393>,<29.580363,-15.137287,174.875943>,<27.552065,-14.909664,175.600393>}
      triangle {<29.580363,-15.137287,174.875943>,<28.859118,-16.216709,174.875943>,<27.552065,-14.909664,175.600393>}
      triangle {<27.985186,-13.864025,175.600393>,<29.833621,-13.864025,174.875943>,<27.872622,-14.429920,175.600393>}
      triangle {<29.833621,-13.864025,174.875943>,<29.580363,-15.137287,174.875943>,<27.872622,-14.429920,175.600393>}
      triangle {<27.872622,-13.298130,175.600393>,<27.985186,-13.864025,175.600393>,<28.122744,-13.864025,175.600393>}
      triangle {<27.999712,-13.245487,175.600393>,<27.872622,-13.298130,175.600393>,<28.122744,-13.864025,175.600393>}
      triangle {<27.552065,-12.818386,175.600393>,<27.872622,-13.298130,175.600393>,<27.999712,-13.245487,175.600393>}
      triangle {<27.649340,-12.721127,175.600393>,<27.552065,-12.818386,175.600393>,<27.999712,-13.245487,175.600393>}
      triangle {<27.072329,-12.497822,175.600393>,<27.552065,-12.818386,175.600393>,<27.649340,-12.721127,175.600393>}
      triangle {<27.124972,-12.370754,175.600393>,<27.072329,-12.497822,175.600393>,<27.649340,-12.721127,175.600393>}
      triangle {<26.506434,-12.385273,175.600393>,<27.072329,-12.497822,175.600393>,<27.124972,-12.370754,175.600393>}
      triangle {<26.506434,-12.247715,175.600393>,<26.506434,-12.385273,175.600393>,<27.124972,-12.370754,175.600393>}
      triangle {<25.940539,-12.497822,175.600393>,<26.506434,-12.385273,175.600393>,<26.506434,-12.247715,175.600393>}
      triangle {<25.887888,-12.370754,175.600393>,<25.940539,-12.497822,175.600393>,<26.506434,-12.247715,175.600393>}
      triangle {<25.460795,-12.818386,175.600393>,<25.940539,-12.497822,175.600393>,<25.887888,-12.370754,175.600393>}
      triangle {<25.363535,-12.721127,175.600393>,<25.460795,-12.818386,175.600393>,<25.887888,-12.370754,175.600393>}
      triangle {<25.140246,-13.298130,175.600393>,<25.460795,-12.818386,175.600393>,<25.363535,-12.721127,175.600393>}
      triangle {<25.013163,-13.245487,175.600393>,<25.140246,-13.298130,175.600393>,<25.363535,-12.721127,175.600393>}
      triangle {<25.027682,-13.864025,175.600393>,<25.140246,-13.298130,175.600393>,<25.013163,-13.245487,175.600393>}
      triangle {<24.890116,-13.864025,175.600393>,<25.027682,-13.864025,175.600393>,<25.013163,-13.245487,175.600393>}
      triangle {<25.140246,-14.429920,175.600393>,<25.027682,-13.864025,175.600393>,<24.890116,-13.864025,175.600393>}
      triangle {<25.013163,-14.482563,175.600393>,<25.140246,-14.429920,175.600393>,<24.890116,-13.864025,175.600393>}
      triangle {<25.460795,-14.909664,175.600393>,<25.140246,-14.429920,175.600393>,<25.013163,-14.482563,175.600393>}
      triangle {<25.363535,-15.006924,175.600393>,<25.460795,-14.909664,175.600393>,<25.013163,-14.482563,175.600393>}
      triangle {<25.940539,-15.230221,175.600393>,<25.460795,-14.909664,175.600393>,<25.363535,-15.006924,175.600393>}
      triangle {<25.887888,-15.357296,175.600393>,<25.940539,-15.230221,175.600393>,<25.363535,-15.006924,175.600393>}
      triangle {<26.506434,-15.342770,175.600393>,<25.940539,-15.230221,175.600393>,<25.887888,-15.357296,175.600393>}
      triangle {<26.506434,-15.480335,175.600393>,<26.506434,-15.342770,175.600393>,<25.887888,-15.357296,175.600393>}
      triangle {<27.072329,-15.230221,175.600393>,<26.506434,-15.342770,175.600393>,<26.506434,-15.480335,175.600393>}
      triangle {<27.124972,-15.357296,175.600393>,<27.072329,-15.230221,175.600393>,<26.506434,-15.480335,175.600393>}
      triangle {<27.552065,-14.909664,175.600393>,<27.072329,-15.230221,175.600393>,<27.124972,-15.357296,175.600393>}
      triangle {<27.649340,-15.006924,175.600393>,<27.552065,-14.909664,175.600393>,<27.124972,-15.357296,175.600393>}
      triangle {<27.872622,-14.429920,175.600393>,<27.552065,-14.909664,175.600393>,<27.649340,-15.006924,175.600393>}
      triangle {<27.999712,-14.482563,175.600393>,<27.872622,-14.429920,175.600393>,<27.649340,-15.006924,175.600393>}
      triangle {<27.985186,-13.864025,175.600393>,<27.872622,-14.429920,175.600393>,<27.999712,-14.482563,175.600393>}
      triangle {<28.122744,-13.864025,175.600393>,<27.985186,-13.864025,175.600393>,<27.999712,-14.482563,175.600393>}
      triangle {<29.580363,-12.590763,174.875943>,<29.866313,-12.472317,174.875943>,<30.143130,-13.864025,174.875943>}
      triangle {<29.833621,-13.864025,174.875943>,<29.580363,-12.590763,174.875943>,<30.143130,-13.864025,174.875943>}
      triangle {<28.859118,-11.511341,174.875943>,<29.077960,-11.292484,174.875943>,<29.866313,-12.472317,174.875943>}
      triangle {<29.580363,-12.590763,174.875943>,<28.859118,-11.511341,174.875943>,<29.866313,-12.472317,174.875943>}
      triangle {<27.779696,-10.790104,174.875943>,<27.898127,-10.504154,174.875943>,<29.077960,-11.292484,174.875943>}
      triangle {<28.859118,-11.511341,174.875943>,<27.779696,-10.790104,174.875943>,<29.077960,-11.292484,174.875943>}
      triangle {<26.506434,-10.536839,174.875943>,<26.506434,-10.227329,174.875942>,<27.898127,-10.504154,174.875943>}
      triangle {<27.779696,-10.790104,174.875943>,<26.506434,-10.536839,174.875943>,<27.898127,-10.504154,174.875943>}
      triangle {<25.233180,-10.790104,174.875943>,<25.114726,-10.504154,174.875943>,<26.506434,-10.227329,174.875942>}
      triangle {<26.506434,-10.536839,174.875943>,<25.233180,-10.790104,174.875943>,<26.506434,-10.227329,174.875942>}
      triangle {<24.153750,-11.511341,174.875943>,<23.934893,-11.292484,174.875943>,<25.114726,-10.504154,174.875943>}
      triangle {<25.233180,-10.790104,174.875943>,<24.153750,-11.511341,174.875943>,<25.114726,-10.504154,174.875943>}
      triangle {<23.432490,-12.590763,174.875943>,<23.146548,-12.472317,174.875943>,<23.934893,-11.292484,174.875943>}
      triangle {<24.153750,-11.511341,174.875943>,<23.432490,-12.590763,174.875943>,<23.934893,-11.292484,174.875943>}
      triangle {<23.179232,-13.864025,174.875943>,<22.869730,-13.864025,174.875943>,<23.146548,-12.472317,174.875943>}
      triangle {<23.432490,-12.590763,174.875943>,<23.179232,-13.864025,174.875943>,<23.146548,-12.472317,174.875943>}
      triangle {<23.432490,-15.137287,174.875943>,<23.146548,-15.255749,174.875943>,<22.869730,-13.864025,174.875943>}
      triangle {<23.179232,-13.864025,174.875943>,<23.432490,-15.137287,174.875943>,<22.869730,-13.864025,174.875943>}
      triangle {<24.153750,-16.216709,174.875943>,<23.934893,-16.435551,174.875943>,<23.146548,-15.255749,174.875943>}
      triangle {<23.432490,-15.137287,174.875943>,<24.153750,-16.216709,174.875943>,<23.146548,-15.255749,174.875943>}
      triangle {<25.233180,-16.937954,174.875943>,<25.114726,-17.223896,174.875943>,<23.934893,-16.435551,174.875943>}
      triangle {<24.153750,-16.216709,174.875943>,<25.233180,-16.937954,174.875943>,<23.934893,-16.435551,174.875943>}
      triangle {<26.506434,-17.191212,174.875943>,<26.506434,-17.500713,174.875943>,<25.114726,-17.223896,174.875943>}
      triangle {<25.233180,-16.937954,174.875943>,<26.506434,-17.191212,174.875943>,<25.114726,-17.223896,174.875943>}
      triangle {<27.779696,-16.937954,174.875943>,<27.898127,-17.223896,174.875943>,<26.506434,-17.500713,174.875943>}
      triangle {<26.506434,-17.191212,174.875943>,<27.779696,-16.937954,174.875943>,<26.506434,-17.500713,174.875943>}
      triangle {<28.859118,-16.216709,174.875943>,<29.077960,-16.435551,174.875943>,<27.898127,-17.223896,174.875943>}
      triangle {<27.779696,-16.937954,174.875943>,<28.859118,-16.216709,174.875943>,<27.898127,-17.223896,174.875943>}
      triangle {<29.580363,-15.137287,174.875943>,<29.866313,-15.255718,174.875943>,<29.077960,-16.435551,174.875943>}
      triangle {<28.859118,-16.216709,174.875943>,<29.580363,-15.137287,174.875943>,<29.077960,-16.435551,174.875943>}
      triangle {<29.833621,-13.864025,174.875943>,<30.143130,-13.864025,174.875943>,<29.866313,-15.255718,174.875943>}
      triangle {<29.580363,-15.137287,174.875943>,<29.833621,-13.864025,174.875943>,<29.866313,-15.255718,174.875943>}
      triangle {<28.244700,-13.857006,174.520843>,<28.013407,-12.993801,174.520843>,<28.013407,-12.993801,176.301447>}
      triangle {<28.244700,-13.857006,174.520843>,<28.013407,-12.993801,176.301447>,<28.244700,-13.857006,176.301447>}
      triangle {<28.013407,-12.993801,174.520843>,<27.381495,-12.361889,174.520843>,<27.381495,-12.361889,176.301447>}
      triangle {<28.013407,-12.993801,174.520843>,<27.381495,-12.361889,176.301447>,<28.013407,-12.993801,176.301447>}
      triangle {<27.381495,-12.361889,174.520843>,<26.518290,-12.130596,174.520843>,<26.518290,-12.130596,176.301447>}
      triangle {<27.381495,-12.361889,174.520843>,<26.518290,-12.130596,176.301447>,<27.381495,-12.361889,176.301447>}
      triangle {<26.518290,-12.130596,174.520843>,<25.655085,-12.361889,174.520843>,<25.655085,-12.361889,176.301447>}
      triangle {<26.518290,-12.130596,174.520843>,<25.655085,-12.361889,176.301447>,<26.518290,-12.130596,176.301447>}
      triangle {<25.655085,-12.361889,174.520843>,<25.023173,-12.993801,174.520843>,<25.023173,-12.993801,176.301447>}
      triangle {<25.655085,-12.361889,174.520843>,<25.023173,-12.993801,176.301447>,<25.655085,-12.361889,176.301447>}
      triangle {<25.023173,-12.993801,174.520843>,<24.791880,-13.857006,174.520843>,<24.791880,-13.857006,176.301447>}
      triangle {<25.023173,-12.993801,174.520843>,<24.791880,-13.857006,176.301447>,<25.023173,-12.993801,176.301447>}
      triangle {<24.791880,-13.857006,174.520843>,<25.023173,-14.720211,174.520843>,<25.023173,-14.720211,176.301447>}
      triangle {<24.791880,-13.857006,174.520843>,<25.023173,-14.720211,176.301447>,<24.791880,-13.857006,176.301447>}
      triangle {<25.023173,-14.720211,174.520843>,<25.655085,-15.352123,174.520843>,<25.655085,-15.352123,176.301448>}
      triangle {<25.023173,-14.720211,174.520843>,<25.655085,-15.352123,176.301448>,<25.023173,-14.720211,176.301447>}
      triangle {<25.655085,-15.352123,174.520843>,<26.518290,-15.583416,174.520843>,<26.518290,-15.583416,176.301448>}
      triangle {<25.655085,-15.352123,174.520843>,<26.518290,-15.583416,176.301448>,<25.655085,-15.352123,176.301448>}
      triangle {<26.518290,-15.583416,174.520843>,<27.381495,-15.352123,174.520843>,<27.381495,-15.352123,176.301448>}
      triangle {<26.518290,-15.583416,174.520843>,<27.381495,-15.352123,176.301448>,<26.518290,-15.583416,176.301448>}
      triangle {<27.381495,-15.352123,174.520843>,<28.013407,-14.720211,174.520843>,<28.013407,-14.720211,176.301447>}
      triangle {<27.381495,-15.352123,174.520843>,<28.013407,-14.720211,176.301447>,<27.381495,-15.352123,176.301448>}
      triangle {<28.013407,-14.720211,174.520843>,<28.244700,-13.857006,174.520843>,<28.244700,-13.857006,176.301447>}
      triangle {<28.013407,-14.720211,174.520843>,<28.244700,-13.857006,176.301447>,<28.013407,-14.720211,176.301447>}
      triangle {<27.814814,-13.857006,174.520843>,<27.641108,-13.208744,176.301447>,<27.641108,-13.208744,174.520843>}
      triangle {<27.814814,-13.857006,174.520843>,<27.814814,-13.857006,176.301447>,<27.641108,-13.208744,176.301447>}
      triangle {<27.641108,-13.208744,174.520843>,<27.166552,-12.734188,176.301447>,<27.166552,-12.734188,174.520843>}
      triangle {<27.641108,-13.208744,174.520843>,<27.641108,-13.208744,176.301447>,<27.166552,-12.734188,176.301447>}
      triangle {<27.166552,-12.734188,174.520843>,<26.518290,-12.560482,176.301447>,<26.518290,-12.560482,174.520843>}
      triangle {<27.166552,-12.734188,174.520843>,<27.166552,-12.734188,176.301447>,<26.518290,-12.560482,176.301447>}
      triangle {<26.518290,-12.560482,174.520843>,<25.870028,-12.734188,176.301447>,<25.870028,-12.734188,174.520843>}
      triangle {<26.518290,-12.560482,174.520843>,<26.518290,-12.560482,176.301447>,<25.870028,-12.734188,176.301447>}
      triangle {<25.870028,-12.734188,174.520843>,<25.395472,-13.208744,176.301447>,<25.395472,-13.208744,174.520843>}
      triangle {<25.870028,-12.734188,174.520843>,<25.870028,-12.734188,176.301447>,<25.395472,-13.208744,176.301447>}
      triangle {<25.395472,-13.208744,174.520843>,<25.221766,-13.857006,176.301447>,<25.221766,-13.857006,174.520843>}
      triangle {<25.395472,-13.208744,174.520843>,<25.395472,-13.208744,176.301447>,<25.221766,-13.857006,176.301447>}
      triangle {<25.221766,-13.857006,174.520843>,<25.395472,-14.505268,176.301447>,<25.395472,-14.505268,174.520843>}
      triangle {<25.221766,-13.857006,174.520843>,<25.221766,-13.857006,176.301447>,<25.395472,-14.505268,176.301447>}
      triangle {<25.395472,-14.505268,174.520843>,<25.870028,-14.979824,176.301447>,<25.870028,-14.979824,174.520843>}
      triangle {<25.395472,-14.505268,174.520843>,<25.395472,-14.505268,176.301447>,<25.870028,-14.979824,176.301447>}
      triangle {<25.870028,-14.979824,174.520843>,<26.518290,-15.153530,176.301448>,<26.518290,-15.153530,174.520843>}
      triangle {<25.870028,-14.979824,174.520843>,<25.870028,-14.979824,176.301447>,<26.518290,-15.153530,176.301448>}
      triangle {<26.518290,-15.153530,174.520843>,<27.166552,-14.979824,176.301447>,<27.166552,-14.979824,174.520843>}
      triangle {<26.518290,-15.153530,174.520843>,<26.518290,-15.153530,176.301448>,<27.166552,-14.979824,176.301447>}
      triangle {<27.166552,-14.979824,174.520843>,<27.641108,-14.505268,176.301447>,<27.641108,-14.505268,174.520843>}
      triangle {<27.166552,-14.979824,174.520843>,<27.166552,-14.979824,176.301447>,<27.641108,-14.505268,176.301447>}
      triangle {<27.641108,-14.505268,174.520843>,<27.814814,-13.857006,176.301447>,<27.814814,-13.857006,174.520843>}
      triangle {<27.641108,-14.505268,174.520843>,<27.641108,-14.505268,176.301447>,<27.814814,-13.857006,176.301447>}
      triangle {<28.244700,-13.857006,174.520843>,<27.814814,-13.857006,174.520843>,<27.641108,-13.208744,174.520843>}
      triangle {<28.244700,-13.857006,174.520843>,<27.641108,-13.208744,174.520843>,<28.013407,-12.993801,174.520843>}
      triangle {<28.013407,-12.993801,174.520843>,<27.641108,-13.208744,174.520843>,<27.166552,-12.734188,174.520843>}
      triangle {<28.013407,-12.993801,174.520843>,<27.166552,-12.734188,174.520843>,<27.381495,-12.361889,174.520843>}
      triangle {<27.381495,-12.361889,174.520843>,<27.166552,-12.734188,174.520843>,<26.518290,-12.560482,174.520843>}
      triangle {<27.381495,-12.361889,174.520843>,<26.518290,-12.560482,174.520843>,<26.518290,-12.130596,174.520843>}
      triangle {<26.518290,-12.130596,174.520843>,<26.518290,-12.560482,174.520843>,<25.870028,-12.734188,174.520843>}
      triangle {<26.518290,-12.130596,174.520843>,<25.870028,-12.734188,174.520843>,<25.655085,-12.361889,174.520843>}
      triangle {<25.655085,-12.361889,174.520843>,<25.870028,-12.734188,174.520843>,<25.395472,-13.208744,174.520843>}
      triangle {<25.655085,-12.361889,174.520843>,<25.395472,-13.208744,174.520843>,<25.023173,-12.993801,174.520843>}
      triangle {<25.023173,-12.993801,174.520843>,<25.395472,-13.208744,174.520843>,<25.221766,-13.857006,174.520843>}
      triangle {<25.023173,-12.993801,174.520843>,<25.221766,-13.857006,174.520843>,<24.791880,-13.857006,174.520843>}
      triangle {<24.791880,-13.857006,174.520843>,<25.221766,-13.857006,174.520843>,<25.395472,-14.505268,174.520843>}
      triangle {<24.791880,-13.857006,174.520843>,<25.395472,-14.505268,174.520843>,<25.023173,-14.720211,174.520843>}
      triangle {<25.023173,-14.720211,174.520843>,<25.395472,-14.505268,174.520843>,<25.870028,-14.979824,174.520843>}
      triangle {<25.023173,-14.720211,174.520843>,<25.870028,-14.979824,174.520843>,<25.655085,-15.352123,174.520843>}
      triangle {<25.655085,-15.352123,174.520843>,<25.870028,-14.979824,174.520843>,<26.518290,-15.153530,174.520843>}
      triangle {<25.655085,-15.352123,174.520843>,<26.518290,-15.153530,174.520843>,<26.518290,-15.583416,174.520843>}
      triangle {<26.518290,-15.583416,174.520843>,<26.518290,-15.153530,174.520843>,<27.166552,-14.979824,174.520843>}
      triangle {<26.518290,-15.583416,174.520843>,<27.166552,-14.979824,174.520843>,<27.381495,-15.352123,174.520843>}
      triangle {<27.381495,-15.352123,174.520843>,<27.166552,-14.979824,174.520843>,<27.641108,-14.505268,174.520843>}
      triangle {<27.381495,-15.352123,174.520843>,<27.641108,-14.505268,174.520843>,<28.013407,-14.720211,174.520843>}
      triangle {<28.013407,-14.720211,174.520843>,<27.641108,-14.505268,174.520843>,<27.814814,-13.857006,174.520843>}
      triangle {<28.013407,-14.720211,174.520843>,<27.814814,-13.857006,174.520843>,<28.244700,-13.857006,174.520843>}
      triangle {<28.244700,-13.857006,176.301447>,<28.013407,-12.993801,176.301447>,<27.641108,-13.208744,176.301447>}
      triangle {<28.244700,-13.857006,176.301447>,<27.641108,-13.208744,176.301447>,<27.814814,-13.857006,176.301447>}
      triangle {<28.013407,-12.993801,176.301447>,<27.381495,-12.361889,176.301447>,<27.166552,-12.734188,176.301447>}
      triangle {<28.013407,-12.993801,176.301447>,<27.166552,-12.734188,176.301447>,<27.641108,-13.208744,176.301447>}
      triangle {<27.381495,-12.361889,176.301447>,<26.518290,-12.130596,176.301447>,<26.518290,-12.560482,176.301447>}
      triangle {<27.381495,-12.361889,176.301447>,<26.518290,-12.560482,176.301447>,<27.166552,-12.734188,176.301447>}
      triangle {<26.518290,-12.130596,176.301447>,<25.655085,-12.361889,176.301447>,<25.870028,-12.734188,176.301447>}
      triangle {<26.518290,-12.130596,176.301447>,<25.870028,-12.734188,176.301447>,<26.518290,-12.560482,176.301447>}
      triangle {<25.655085,-12.361889,176.301447>,<25.023173,-12.993801,176.301447>,<25.395472,-13.208744,176.301447>}
      triangle {<25.655085,-12.361889,176.301447>,<25.395472,-13.208744,176.301447>,<25.870028,-12.734188,176.301447>}
      triangle {<25.023173,-12.993801,176.301447>,<24.791880,-13.857006,176.301447>,<25.221766,-13.857006,176.301447>}
      triangle {<25.023173,-12.993801,176.301447>,<25.221766,-13.857006,176.301447>,<25.395472,-13.208744,176.301447>}
      triangle {<24.791880,-13.857006,176.301447>,<25.023173,-14.720211,176.301447>,<25.395472,-14.505268,176.301447>}
      triangle {<24.791880,-13.857006,176.301447>,<25.395472,-14.505268,176.301447>,<25.221766,-13.857006,176.301447>}
      triangle {<25.023173,-14.720211,176.301447>,<25.655085,-15.352123,176.301448>,<25.870028,-14.979824,176.301447>}
      triangle {<25.023173,-14.720211,176.301447>,<25.870028,-14.979824,176.301447>,<25.395472,-14.505268,176.301447>}
      triangle {<25.655085,-15.352123,176.301448>,<26.518290,-15.583416,176.301448>,<26.518290,-15.153530,176.301448>}
      triangle {<25.655085,-15.352123,176.301448>,<26.518290,-15.153530,176.301448>,<25.870028,-14.979824,176.301447>}
      triangle {<26.518290,-15.583416,176.301448>,<27.381495,-15.352123,176.301448>,<27.166552,-14.979824,176.301447>}
      triangle {<26.518290,-15.583416,176.301448>,<27.166552,-14.979824,176.301447>,<26.518290,-15.153530,176.301448>}
      triangle {<27.381495,-15.352123,176.301448>,<28.013407,-14.720211,176.301447>,<27.641108,-14.505268,176.301447>}
      triangle {<27.381495,-15.352123,176.301448>,<27.641108,-14.505268,176.301447>,<27.166552,-14.979824,176.301447>}
      triangle {<28.013407,-14.720211,176.301447>,<28.244700,-13.857006,176.301447>,<27.814814,-13.857006,176.301447>}
      triangle {<28.013407,-14.720211,176.301447>,<27.814814,-13.857006,176.301447>,<27.641108,-14.505268,176.301447>}
      texture{_Duse02}
    }
    //_Duse01
    mesh{
      triangle {<29.781481,-32.189785,170.550524>,<29.532183,-30.936481,170.550524>,<30.288622,-30.623150,176.300127>}
      triangle {<29.781481,-32.189785,170.550524>,<30.288622,-30.623150,176.300127>,<30.600237,-32.189785,176.300128>}
      triangle {<29.532183,-30.936481,170.550524>,<28.822245,-29.873981,170.550524>,<29.401194,-29.295025,176.300127>}
      triangle {<29.532183,-30.936481,170.550524>,<29.401194,-29.295025,176.300127>,<30.288622,-30.623150,176.300127>}
      triangle {<28.822245,-29.873981,170.550524>,<27.759745,-29.164036,170.550523>,<28.073069,-28.407604,176.300127>}
      triangle {<28.822245,-29.873981,170.550524>,<28.073069,-28.407604,176.300127>,<29.401194,-29.295025,176.300127>}
      triangle {<27.759745,-29.164036,170.550523>,<26.506434,-28.914745,170.550523>,<26.506434,-28.095982,176.300127>}
      triangle {<27.759745,-29.164036,170.550523>,<26.506434,-28.095982,176.300127>,<28.073069,-28.407604,176.300127>}
      triangle {<26.506434,-28.914745,170.550523>,<25.253130,-29.164036,170.550523>,<24.939806,-28.407604,176.300127>}
      triangle {<26.506434,-28.914745,170.550523>,<24.939806,-28.407604,176.300127>,<26.506434,-28.095982,176.300127>}
      triangle {<25.253130,-29.164036,170.550523>,<24.190630,-29.873981,170.550524>,<23.611681,-29.295025,176.300127>}
      triangle {<25.253130,-29.164036,170.550523>,<23.611681,-29.295025,176.300127>,<24.939806,-28.407604,176.300127>}
      triangle {<24.190630,-29.873981,170.550524>,<23.480692,-30.936481,170.550524>,<22.724253,-30.623150,176.300127>}
      triangle {<24.190630,-29.873981,170.550524>,<22.724253,-30.623150,176.300127>,<23.611681,-29.295025,176.300127>}
      triangle {<23.480692,-30.936481,170.550524>,<23.231394,-32.189785,170.550524>,<22.412631,-32.189785,176.300128>}
      triangle {<23.480692,-30.936481,170.550524>,<22.412631,-32.189785,176.300128>,<22.724253,-30.623150,176.300127>}
      triangle {<23.231394,-32.189785,170.550524>,<23.480692,-33.443089,170.550524>,<22.724253,-33.756420,176.300128>}
      triangle {<23.231394,-32.189785,170.550524>,<22.724253,-33.756420,176.300128>,<22.412631,-32.189785,176.300128>}
      triangle {<23.480692,-33.443089,170.550524>,<24.190630,-34.505589,170.550524>,<23.611681,-35.084538,176.300128>}
      triangle {<23.480692,-33.443089,170.550524>,<23.611681,-35.084538,176.300128>,<22.724253,-33.756420,176.300128>}
      triangle {<24.190630,-34.505589,170.550524>,<25.253130,-35.215534,170.550524>,<24.939806,-35.971966,176.300128>}
      triangle {<24.190630,-34.505589,170.550524>,<24.939806,-35.971966,176.300128>,<23.611681,-35.084538,176.300128>}
      triangle {<25.253130,-35.215534,170.550524>,<26.506434,-35.464825,170.550524>,<26.506434,-36.283588,176.300128>}
      triangle {<25.253130,-35.215534,170.550524>,<26.506434,-36.283588,176.300128>,<24.939806,-35.971966,176.300128>}
      triangle {<26.506434,-35.464825,170.550524>,<27.759745,-35.215534,170.550524>,<28.073069,-35.971966,176.300128>}
      triangle {<26.506434,-35.464825,170.550524>,<28.073069,-35.971966,176.300128>,<26.506434,-36.283588,176.300128>}
      triangle {<27.759745,-35.215534,170.550524>,<28.822245,-34.505589,170.550524>,<29.401194,-35.084538,176.300128>}
      triangle {<27.759745,-35.215534,170.550524>,<29.401194,-35.084538,176.300128>,<28.073069,-35.971966,176.300128>}
      triangle {<28.822245,-34.505589,170.550524>,<29.532183,-33.443089,170.550524>,<30.288622,-33.756413,176.300128>}
      triangle {<28.822245,-34.505589,170.550524>,<30.288622,-33.756413,176.300128>,<29.401194,-35.084538,176.300128>}
      triangle {<29.532183,-33.443089,170.550524>,<29.781481,-32.189785,170.550524>,<30.600237,-32.189785,176.300128>}
      triangle {<29.532183,-33.443089,170.550524>,<30.600237,-32.189785,176.300128>,<30.288622,-33.756413,176.300128>}
      triangle {<29.502749,-32.189785,170.550524>,<29.966731,-30.756481,176.300127>,<29.274668,-31.043148,170.550524>}
      triangle {<29.502749,-32.189785,170.550524>,<30.251833,-32.189785,176.300128>,<29.966731,-30.756481,176.300127>}
      triangle {<29.274668,-31.043148,170.550524>,<29.154833,-29.541386,176.300127>,<28.625147,-30.071072,170.550524>}
      triangle {<29.274668,-31.043148,170.550524>,<29.966731,-30.756481,176.300127>,<29.154833,-29.541386,176.300127>}
      triangle {<28.625147,-30.071072,170.550524>,<27.939738,-28.729496,176.300127>,<27.653079,-29.421543,170.550523>}
      triangle {<28.625147,-30.071072,170.550524>,<29.154833,-29.541386,176.300127>,<27.939738,-28.729496,176.300127>}
      triangle {<27.653079,-29.421543,170.550523>,<26.506434,-28.444393,176.300127>,<26.506434,-29.193470,170.550523>}
      triangle {<27.653079,-29.421543,170.550523>,<27.939738,-28.729496,176.300127>,<26.506434,-28.444393,176.300127>}
      triangle {<26.506434,-29.193470,170.550523>,<25.073138,-28.729496,176.300127>,<25.359797,-29.421543,170.550523>}
      triangle {<26.506434,-29.193470,170.550523>,<26.506434,-28.444393,176.300127>,<25.073138,-28.729496,176.300127>}
      triangle {<25.359797,-29.421543,170.550523>,<23.858042,-29.541386,176.300127>,<24.387721,-30.071072,170.550524>}
      triangle {<25.359797,-29.421543,170.550523>,<25.073138,-28.729496,176.300127>,<23.858042,-29.541386,176.300127>}
      triangle {<24.387721,-30.071072,170.550524>,<23.046137,-30.756481,176.300127>,<23.738207,-31.043148,170.550524>}
      triangle {<24.387721,-30.071072,170.550524>,<23.858042,-29.541386,176.300127>,<23.046137,-30.756481,176.300127>}
      triangle {<23.738207,-31.043148,170.550524>,<22.761042,-32.189785,176.300128>,<23.510119,-32.189785,170.550524>}
      triangle {<23.738207,-31.043148,170.550524>,<23.046137,-30.756481,176.300127>,<22.761042,-32.189785,176.300128>}
      triangle {<23.510119,-32.189785,170.550524>,<23.046137,-33.623081,176.300128>,<23.738207,-33.336422,170.550524>}
      triangle {<23.510119,-32.189785,170.550524>,<22.761042,-32.189785,176.300128>,<23.046137,-33.623081,176.300128>}
      triangle {<23.738207,-33.336422,170.550524>,<23.858042,-34.838177,176.300128>,<24.387721,-34.308498,170.550524>}
      triangle {<23.738207,-33.336422,170.550524>,<23.046137,-33.623081,176.300128>,<23.858042,-34.838177,176.300128>}
      triangle {<24.387721,-34.308498,170.550524>,<25.073138,-35.650074,176.300128>,<25.359797,-34.958019,170.550524>}
      triangle {<24.387721,-34.308498,170.550524>,<23.858042,-34.838177,176.300128>,<25.073138,-35.650074,176.300128>}
      triangle {<25.359797,-34.958019,170.550524>,<26.506434,-35.935177,176.300128>,<26.506434,-35.186100,170.550524>}
      triangle {<25.359797,-34.958019,170.550524>,<25.073138,-35.650074,176.300128>,<26.506434,-35.935177,176.300128>}
      triangle {<26.506434,-35.186100,170.550524>,<27.939738,-35.650074,176.300128>,<27.653079,-34.958019,170.550524>}
      triangle {<26.506434,-35.186100,170.550524>,<26.506434,-35.935177,176.300128>,<27.939738,-35.650074,176.300128>}
      triangle {<27.653079,-34.958019,170.550524>,<29.154833,-34.838177,176.300128>,<28.625147,-34.308498,170.550524>}
      triangle {<27.653079,-34.958019,170.550524>,<27.939738,-35.650074,176.300128>,<29.154833,-34.838177,176.300128>}
      triangle {<28.625147,-34.308498,170.550524>,<29.966731,-33.623081,176.300128>,<29.274676,-33.336422,170.550524>}
      triangle {<28.625147,-34.308498,170.550524>,<29.154833,-34.838177,176.300128>,<29.966731,-33.623081,176.300128>}
      triangle {<29.274676,-33.336422,170.550524>,<30.251833,-32.189785,176.300128>,<29.502749,-32.189785,170.550524>}
      triangle {<29.274676,-33.336422,170.550524>,<29.966731,-33.623081,176.300128>,<30.251833,-32.189785,176.300128>}
      triangle {<29.781481,-32.189785,170.550524>,<29.502749,-32.189785,170.550524>,<29.274668,-31.043148,170.550524>}
      triangle {<29.781481,-32.189785,170.550524>,<29.274668,-31.043148,170.550524>,<29.532183,-30.936481,170.550524>}
      triangle {<29.532183,-30.936481,170.550524>,<29.274668,-31.043148,170.550524>,<28.625147,-30.071072,170.550524>}
      triangle {<29.532183,-30.936481,170.550524>,<28.625147,-30.071072,170.550524>,<28.822245,-29.873981,170.550524>}
      triangle {<28.822245,-29.873981,170.550524>,<28.625147,-30.071072,170.550524>,<27.653079,-29.421543,170.550523>}
      triangle {<28.822245,-29.873981,170.550524>,<27.653079,-29.421543,170.550523>,<27.759745,-29.164036,170.550523>}
      triangle {<27.759745,-29.164036,170.550523>,<27.653079,-29.421543,170.550523>,<26.506434,-29.193470,170.550523>}
      triangle {<27.759745,-29.164036,170.550523>,<26.506434,-29.193470,170.550523>,<26.506434,-28.914745,170.550523>}
      triangle {<26.506434,-28.914745,170.550523>,<26.506434,-29.193470,170.550523>,<25.359797,-29.421543,170.550523>}
      triangle {<26.506434,-28.914745,170.550523>,<25.359797,-29.421543,170.550523>,<25.253130,-29.164036,170.550523>}
      triangle {<25.253130,-29.164036,170.550523>,<25.359797,-29.421543,170.550523>,<24.387721,-30.071072,170.550524>}
      triangle {<25.253130,-29.164036,170.550523>,<24.387721,-30.071072,170.550524>,<24.190630,-29.873981,170.550524>}
      triangle {<24.190630,-29.873981,170.550524>,<24.387721,-30.071072,170.550524>,<23.738207,-31.043148,170.550524>}
      triangle {<24.190630,-29.873981,170.550524>,<23.738207,-31.043148,170.550524>,<23.480692,-30.936481,170.550524>}
      triangle {<23.480692,-30.936481,170.550524>,<23.738207,-31.043148,170.550524>,<23.510119,-32.189785,170.550524>}
      triangle {<23.480692,-30.936481,170.550524>,<23.510119,-32.189785,170.550524>,<23.231394,-32.189785,170.550524>}
      triangle {<23.231394,-32.189785,170.550524>,<23.510119,-32.189785,170.550524>,<23.738207,-33.336422,170.550524>}
      triangle {<23.231394,-32.189785,170.550524>,<23.738207,-33.336422,170.550524>,<23.480692,-33.443089,170.550524>}
      triangle {<23.480692,-33.443089,170.550524>,<23.738207,-33.336422,170.550524>,<24.387721,-34.308498,170.550524>}
      triangle {<23.480692,-33.443089,170.550524>,<24.387721,-34.308498,170.550524>,<24.190630,-34.505589,170.550524>}
      triangle {<24.190630,-34.505589,170.550524>,<24.387721,-34.308498,170.550524>,<25.359797,-34.958019,170.550524>}
      triangle {<24.190630,-34.505589,170.550524>,<25.359797,-34.958019,170.550524>,<25.253130,-35.215534,170.550524>}
      triangle {<25.253130,-35.215534,170.550524>,<25.359797,-34.958019,170.550524>,<26.506434,-35.186100,170.550524>}
      triangle {<25.253130,-35.215534,170.550524>,<26.506434,-35.186100,170.550524>,<26.506434,-35.464825,170.550524>}
      triangle {<26.506434,-35.464825,170.550524>,<26.506434,-35.186100,170.550524>,<27.653079,-34.958019,170.550524>}
      triangle {<26.506434,-35.464825,170.550524>,<27.653079,-34.958019,170.550524>,<27.759745,-35.215534,170.550524>}
      triangle {<27.759745,-35.215534,170.550524>,<27.653079,-34.958019,170.550524>,<28.625147,-34.308498,170.550524>}
      triangle {<27.759745,-35.215534,170.550524>,<28.625147,-34.308498,170.550524>,<28.822245,-34.505589,170.550524>}
      triangle {<28.822245,-34.505589,170.550524>,<28.625147,-34.308498,170.550524>,<29.274676,-33.336422,170.550524>}
      triangle {<28.822245,-34.505589,170.550524>,<29.274676,-33.336422,170.550524>,<29.532183,-33.443089,170.550524>}
      triangle {<29.532183,-33.443089,170.550524>,<29.274676,-33.336422,170.550524>,<29.502749,-32.189785,170.550524>}
      triangle {<29.532183,-33.443089,170.550524>,<29.502749,-32.189785,170.550524>,<29.781481,-32.189785,170.550524>}
      triangle {<30.600237,-32.189785,176.300128>,<30.288622,-30.623150,176.300127>,<29.966731,-30.756481,176.300127>}
      triangle {<30.600237,-32.189785,176.300128>,<29.966731,-30.756481,176.300127>,<30.251833,-32.189785,176.300128>}
      triangle {<30.288622,-30.623150,176.300127>,<29.401194,-29.295025,176.300127>,<29.154833,-29.541386,176.300127>}
      triangle {<30.288622,-30.623150,176.300127>,<29.154833,-29.541386,176.300127>,<29.966731,-30.756481,176.300127>}
      triangle {<29.401194,-29.295025,176.300127>,<28.073069,-28.407604,176.300127>,<27.939738,-28.729496,176.300127>}
      triangle {<29.401194,-29.295025,176.300127>,<27.939738,-28.729496,176.300127>,<29.154833,-29.541386,176.300127>}
      triangle {<28.073069,-28.407604,176.300127>,<26.506434,-28.095982,176.300127>,<26.506434,-28.444393,176.300127>}
      triangle {<28.073069,-28.407604,176.300127>,<26.506434,-28.444393,176.300127>,<27.939738,-28.729496,176.300127>}
      triangle {<26.506434,-28.095982,176.300127>,<24.939806,-28.407604,176.300127>,<25.073138,-28.729496,176.300127>}
      triangle {<26.506434,-28.095982,176.300127>,<25.073138,-28.729496,176.300127>,<26.506434,-28.444393,176.300127>}
      triangle {<24.939806,-28.407604,176.300127>,<23.611681,-29.295025,176.300127>,<23.858042,-29.541386,176.300127>}
      triangle {<24.939806,-28.407604,176.300127>,<23.858042,-29.541386,176.300127>,<25.073138,-28.729496,176.300127>}
      triangle {<23.611681,-29.295025,176.300127>,<22.724253,-30.623150,176.300127>,<23.046137,-30.756481,176.300127>}
      triangle {<23.611681,-29.295025,176.300127>,<23.046137,-30.756481,176.300127>,<23.858042,-29.541386,176.300127>}
      triangle {<22.724253,-30.623150,176.300127>,<22.412631,-32.189785,176.300128>,<22.761042,-32.189785,176.300128>}
      triangle {<22.724253,-30.623150,176.300127>,<22.761042,-32.189785,176.300128>,<23.046137,-30.756481,176.300127>}
      triangle {<22.412631,-32.189785,176.300128>,<22.724253,-33.756420,176.300128>,<23.046137,-33.623081,176.300128>}
      triangle {<22.412631,-32.189785,176.300128>,<23.046137,-33.623081,176.300128>,<22.761042,-32.189785,176.300128>}
      triangle {<22.724253,-33.756420,176.300128>,<23.611681,-35.084538,176.300128>,<23.858042,-34.838177,176.300128>}
      triangle {<22.724253,-33.756420,176.300128>,<23.858042,-34.838177,176.300128>,<23.046137,-33.623081,176.300128>}
      triangle {<23.611681,-35.084538,176.300128>,<24.939806,-35.971966,176.300128>,<25.073138,-35.650074,176.300128>}
      triangle {<23.611681,-35.084538,176.300128>,<25.073138,-35.650074,176.300128>,<23.858042,-34.838177,176.300128>}
      triangle {<24.939806,-35.971966,176.300128>,<26.506434,-36.283588,176.300128>,<26.506434,-35.935177,176.300128>}
      triangle {<24.939806,-35.971966,176.300128>,<26.506434,-35.935177,176.300128>,<25.073138,-35.650074,176.300128>}
      triangle {<26.506434,-36.283588,176.300128>,<28.073069,-35.971966,176.300128>,<27.939738,-35.650074,176.300128>}
      triangle {<26.506434,-36.283588,176.300128>,<27.939738,-35.650074,176.300128>,<26.506434,-35.935177,176.300128>}
      triangle {<28.073069,-35.971966,176.300128>,<29.401194,-35.084538,176.300128>,<29.154833,-34.838177,176.300128>}
      triangle {<28.073069,-35.971966,176.300128>,<29.154833,-34.838177,176.300128>,<27.939738,-35.650074,176.300128>}
      triangle {<29.401194,-35.084538,176.300128>,<30.288622,-33.756413,176.300128>,<29.966731,-33.623081,176.300128>}
      triangle {<29.401194,-35.084538,176.300128>,<29.966731,-33.623081,176.300128>,<29.154833,-34.838177,176.300128>}
      triangle {<30.288622,-33.756413,176.300128>,<30.600237,-32.189785,176.300128>,<30.251833,-32.189785,176.300128>}
      triangle {<30.288622,-33.756413,176.300128>,<30.251833,-32.189785,176.300128>,<29.966731,-33.623081,176.300128>}
      triangle {<28.244700,-32.182766,174.520843>,<28.013407,-31.319561,174.520843>,<28.013407,-31.319561,176.301447>}
      triangle {<28.244700,-32.182766,174.520843>,<28.013407,-31.319561,176.301447>,<28.244700,-32.182766,176.301447>}
      triangle {<28.013407,-31.319561,174.520843>,<27.381495,-30.687649,174.520843>,<27.381495,-30.687649,176.301447>}
      triangle {<28.013407,-31.319561,174.520843>,<27.381495,-30.687649,176.301447>,<28.013407,-31.319561,176.301447>}
      triangle {<27.381495,-30.687649,174.520843>,<26.518290,-30.456356,174.520843>,<26.518290,-30.456356,176.301447>}
      triangle {<27.381495,-30.687649,174.520843>,<26.518290,-30.456356,176.301447>,<27.381495,-30.687649,176.301447>}
      triangle {<26.518290,-30.456356,174.520843>,<25.655085,-30.687649,174.520843>,<25.655085,-30.687649,176.301447>}
      triangle {<26.518290,-30.456356,174.520843>,<25.655085,-30.687649,176.301447>,<26.518290,-30.456356,176.301447>}
      triangle {<25.655085,-30.687649,174.520843>,<25.023173,-31.319561,174.520843>,<25.023173,-31.319561,176.301447>}
      triangle {<25.655085,-30.687649,174.520843>,<25.023173,-31.319561,176.301447>,<25.655085,-30.687649,176.301447>}
      triangle {<25.023173,-31.319561,174.520843>,<24.791880,-32.182766,174.520843>,<24.791880,-32.182766,176.301447>}
      triangle {<25.023173,-31.319561,174.520843>,<24.791880,-32.182766,176.301447>,<25.023173,-31.319561,176.301447>}
      triangle {<24.791880,-32.182766,174.520843>,<25.023173,-33.045971,174.520843>,<25.023173,-33.045971,176.301447>}
      triangle {<24.791880,-32.182766,174.520843>,<25.023173,-33.045971,176.301447>,<24.791880,-32.182766,176.301447>}
      triangle {<25.023173,-33.045971,174.520843>,<25.655085,-33.677883,174.520843>,<25.655085,-33.677883,176.301448>}
      triangle {<25.023173,-33.045971,174.520843>,<25.655085,-33.677883,176.301448>,<25.023173,-33.045971,176.301447>}
      triangle {<25.655085,-33.677883,174.520843>,<26.518290,-33.909176,174.520843>,<26.518290,-33.909176,176.301448>}
      triangle {<25.655085,-33.677883,174.520843>,<26.518290,-33.909176,176.301448>,<25.655085,-33.677883,176.301448>}
      triangle {<26.518290,-33.909176,174.520843>,<27.381495,-33.677883,174.520843>,<27.381495,-33.677883,176.301448>}
      triangle {<26.518290,-33.909176,174.520843>,<27.381495,-33.677883,176.301448>,<26.518290,-33.909176,176.301448>}
      triangle {<27.381495,-33.677883,174.520843>,<28.013407,-33.045971,174.520843>,<28.013407,-33.045971,176.301447>}
      triangle {<27.381495,-33.677883,174.520843>,<28.013407,-33.045971,176.301447>,<27.381495,-33.677883,176.301448>}
      triangle {<28.013407,-33.045971,174.520843>,<28.244700,-32.182766,174.520843>,<28.244700,-32.182766,176.301447>}
      triangle {<28.013407,-33.045971,174.520843>,<28.244700,-32.182766,176.301447>,<28.013407,-33.045971,176.301447>}
      triangle {<27.814814,-32.182766,174.520843>,<27.641108,-31.534504,176.301447>,<27.641108,-31.534504,174.520843>}
      triangle {<27.814814,-32.182766,174.520843>,<27.814814,-32.182766,176.301447>,<27.641108,-31.534504,176.301447>}
      triangle {<27.641108,-31.534504,174.520843>,<27.166552,-31.059948,176.301447>,<27.166552,-31.059948,174.520843>}
      triangle {<27.641108,-31.534504,174.520843>,<27.641108,-31.534504,176.301447>,<27.166552,-31.059948,176.301447>}
      triangle {<27.166552,-31.059948,174.520843>,<26.518290,-30.886242,176.301447>,<26.518290,-30.886242,174.520850>}
      triangle {<27.166552,-31.059948,174.520843>,<27.166552,-31.059948,176.301447>,<26.518290,-30.886242,176.301447>}
      triangle {<26.518290,-30.886242,174.520850>,<25.870028,-31.059948,176.301447>,<25.870028,-31.059948,174.520843>}
      triangle {<26.518290,-30.886242,174.520850>,<26.518290,-30.886242,176.301447>,<25.870028,-31.059948,176.301447>}
      triangle {<25.870028,-31.059948,174.520843>,<25.395472,-31.534504,176.301447>,<25.395472,-31.534504,174.520843>}
      triangle {<25.870028,-31.059948,174.520843>,<25.870028,-31.059948,176.301447>,<25.395472,-31.534504,176.301447>}
      triangle {<25.395472,-31.534504,174.520843>,<25.221766,-32.182766,176.301447>,<25.221766,-32.182766,174.520843>}
      triangle {<25.395472,-31.534504,174.520843>,<25.395472,-31.534504,176.301447>,<25.221766,-32.182766,176.301447>}
      triangle {<25.221766,-32.182766,174.520843>,<25.395472,-32.831028,176.301447>,<25.395472,-32.831028,174.520843>}
      triangle {<25.221766,-32.182766,174.520843>,<25.221766,-32.182766,176.301447>,<25.395472,-32.831028,176.301447>}
      triangle {<25.395472,-32.831028,174.520843>,<25.870028,-33.305584,176.301447>,<25.870028,-33.305584,174.520843>}
      triangle {<25.395472,-32.831028,174.520843>,<25.395472,-32.831028,176.301447>,<25.870028,-33.305584,176.301447>}
      triangle {<25.870028,-33.305584,174.520843>,<26.518290,-33.479290,176.301448>,<26.518290,-33.479290,174.520843>}
      triangle {<25.870028,-33.305584,174.520843>,<25.870028,-33.305584,176.301447>,<26.518290,-33.479290,176.301448>}
      triangle {<26.518290,-33.479290,174.520843>,<27.166552,-33.305584,176.301447>,<27.166552,-33.305584,174.520843>}
      triangle {<26.518290,-33.479290,174.520843>,<26.518290,-33.479290,176.301448>,<27.166552,-33.305584,176.301447>}
      triangle {<27.166552,-33.305584,174.520843>,<27.641108,-32.831028,176.301447>,<27.641108,-32.831028,174.520843>}
      triangle {<27.166552,-33.305584,174.520843>,<27.166552,-33.305584,176.301447>,<27.641108,-32.831028,176.301447>}
      triangle {<27.641108,-32.831028,174.520843>,<27.814814,-32.182766,176.301447>,<27.814814,-32.182766,174.520843>}
      triangle {<27.641108,-32.831028,174.520843>,<27.641108,-32.831028,176.301447>,<27.814814,-32.182766,176.301447>}
      triangle {<28.244700,-32.182766,174.520843>,<27.814814,-32.182766,174.520843>,<27.641108,-31.534504,174.520843>}
      triangle {<28.244700,-32.182766,174.520843>,<27.641108,-31.534504,174.520843>,<28.013407,-31.319561,174.520843>}
      triangle {<28.013407,-31.319561,174.520843>,<27.641108,-31.534504,174.520843>,<27.166552,-31.059948,174.520843>}
      triangle {<28.013407,-31.319561,174.520843>,<27.166552,-31.059948,174.520843>,<27.381495,-30.687649,174.520843>}
      triangle {<27.381495,-30.687649,174.520843>,<27.166552,-31.059948,174.520843>,<26.518290,-30.886242,174.520850>}
      triangle {<27.381495,-30.687649,174.520843>,<26.518290,-30.886242,174.520850>,<26.518290,-30.456356,174.520843>}
      triangle {<26.518290,-30.456356,174.520843>,<26.518290,-30.886242,174.520850>,<25.870028,-31.059948,174.520843>}
      triangle {<26.518290,-30.456356,174.520843>,<25.870028,-31.059948,174.520843>,<25.655085,-30.687649,174.520843>}
      triangle {<25.655085,-30.687649,174.520843>,<25.870028,-31.059948,174.520843>,<25.395472,-31.534504,174.520843>}
      triangle {<25.655085,-30.687649,174.520843>,<25.395472,-31.534504,174.520843>,<25.023173,-31.319561,174.520843>}
      triangle {<25.023173,-31.319561,174.520843>,<25.395472,-31.534504,174.520843>,<25.221766,-32.182766,174.520843>}
      triangle {<25.023173,-31.319561,174.520843>,<25.221766,-32.182766,174.520843>,<24.791880,-32.182766,174.520843>}
      triangle {<24.791880,-32.182766,174.520843>,<25.221766,-32.182766,174.520843>,<25.395472,-32.831028,174.520843>}
      triangle {<24.791880,-32.182766,174.520843>,<25.395472,-32.831028,174.520843>,<25.023173,-33.045971,174.520843>}
      triangle {<25.023173,-33.045971,174.520843>,<25.395472,-32.831028,174.520843>,<25.870028,-33.305584,174.520843>}
      triangle {<25.023173,-33.045971,174.520843>,<25.870028,-33.305584,174.520843>,<25.655085,-33.677883,174.520843>}
      triangle {<25.655085,-33.677883,174.520843>,<25.870028,-33.305584,174.520843>,<26.518290,-33.479290,174.520843>}
      triangle {<25.655085,-33.677883,174.520843>,<26.518290,-33.479290,174.520843>,<26.518290,-33.909176,174.520843>}
      triangle {<26.518290,-33.909176,174.520843>,<26.518290,-33.479290,174.520843>,<27.166552,-33.305584,174.520843>}
      triangle {<26.518290,-33.909176,174.520843>,<27.166552,-33.305584,174.520843>,<27.381495,-33.677883,174.520843>}
      triangle {<27.381495,-33.677883,174.520843>,<27.166552,-33.305584,174.520843>,<27.641108,-32.831028,174.520843>}
      triangle {<27.381495,-33.677883,174.520843>,<27.641108,-32.831028,174.520843>,<28.013407,-33.045971,174.520843>}
      triangle {<28.013407,-33.045971,174.520843>,<27.641108,-32.831028,174.520843>,<27.814814,-32.182766,174.520843>}
      triangle {<28.013407,-33.045971,174.520843>,<27.814814,-32.182766,174.520843>,<28.244700,-32.182766,174.520843>}
      triangle {<28.244700,-32.182766,176.301447>,<28.013407,-31.319561,176.301447>,<27.641108,-31.534504,176.301447>}
      triangle {<28.244700,-32.182766,176.301447>,<27.641108,-31.534504,176.301447>,<27.814814,-32.182766,176.301447>}
      triangle {<28.013407,-31.319561,176.301447>,<27.381495,-30.687649,176.301447>,<27.166552,-31.059948,176.301447>}
      triangle {<28.013407,-31.319561,176.301447>,<27.166552,-31.059948,176.301447>,<27.641108,-31.534504,176.301447>}
      triangle {<27.381495,-30.687649,176.301447>,<26.518290,-30.456356,176.301447>,<26.518290,-30.886242,176.301447>}
      triangle {<27.381495,-30.687649,176.301447>,<26.518290,-30.886242,176.301447>,<27.166552,-31.059948,176.301447>}
      triangle {<26.518290,-30.456356,176.301447>,<25.655085,-30.687649,176.301447>,<25.870028,-31.059948,176.301447>}
      triangle {<26.518290,-30.456356,176.301447>,<25.870028,-31.059948,176.301447>,<26.518290,-30.886242,176.301447>}
      triangle {<25.655085,-30.687649,176.301447>,<25.023173,-31.319561,176.301447>,<25.395472,-31.534504,176.301447>}
      triangle {<25.655085,-30.687649,176.301447>,<25.395472,-31.534504,176.301447>,<25.870028,-31.059948,176.301447>}
      triangle {<25.023173,-31.319561,176.301447>,<24.791880,-32.182766,176.301447>,<25.221766,-32.182766,176.301447>}
      triangle {<25.023173,-31.319561,176.301447>,<25.221766,-32.182766,176.301447>,<25.395472,-31.534504,176.301447>}
      triangle {<24.791880,-32.182766,176.301447>,<25.023173,-33.045971,176.301447>,<25.395472,-32.831028,176.301447>}
      triangle {<24.791880,-32.182766,176.301447>,<25.395472,-32.831028,176.301447>,<25.221766,-32.182766,176.301447>}
      triangle {<25.023173,-33.045971,176.301447>,<25.655085,-33.677883,176.301448>,<25.870028,-33.305584,176.301447>}
      triangle {<25.023173,-33.045971,176.301447>,<25.870028,-33.305584,176.301447>,<25.395472,-32.831028,176.301447>}
      triangle {<25.655085,-33.677883,176.301448>,<26.518290,-33.909176,176.301448>,<26.518290,-33.479290,176.301448>}
      triangle {<25.655085,-33.677883,176.301448>,<26.518290,-33.479290,176.301448>,<25.870028,-33.305584,176.301447>}
      triangle {<26.518290,-33.909176,176.301448>,<27.381495,-33.677883,176.301448>,<27.166552,-33.305584,176.301447>}
      triangle {<26.518290,-33.909176,176.301448>,<27.166552,-33.305584,176.301447>,<26.518290,-33.479290,176.301448>}
      triangle {<27.381495,-33.677883,176.301448>,<28.013407,-33.045971,176.301447>,<27.641108,-32.831028,176.301447>}
      triangle {<27.381495,-33.677883,176.301448>,<27.641108,-32.831028,176.301447>,<27.166552,-33.305584,176.301447>}
      triangle {<28.013407,-33.045971,176.301447>,<28.244700,-32.182766,176.301447>,<27.814814,-32.182766,176.301447>}
      triangle {<28.013407,-33.045971,176.301447>,<27.814814,-32.182766,176.301447>,<27.641108,-32.831028,176.301447>}
      triangle {<29.866313,-30.798077,174.875946>,<27.999712,-31.571247,175.600400>,<28.122744,-32.189785,175.600393>}
      triangle {<30.143130,-32.189785,174.875946>,<29.866313,-30.798077,174.875946>,<28.122744,-32.189785,175.600393>}
      triangle {<29.077960,-29.618244,174.875943>,<27.649340,-31.046886,175.600393>,<27.999712,-31.571247,175.600400>}
      triangle {<29.866313,-30.798077,174.875946>,<29.077960,-29.618244,174.875943>,<27.999712,-31.571247,175.600400>}
      triangle {<27.898127,-28.829914,174.875946>,<27.124972,-30.696514,175.600393>,<27.649340,-31.046886,175.600393>}
      triangle {<29.077960,-29.618244,174.875943>,<27.898127,-28.829914,174.875946>,<27.649340,-31.046886,175.600393>}
      triangle {<26.506434,-28.553089,174.875942>,<26.506434,-30.573475,175.600393>,<27.124972,-30.696514,175.600393>}
      triangle {<27.898127,-28.829914,174.875946>,<26.506434,-28.553089,174.875942>,<27.124972,-30.696514,175.600393>}
      triangle {<25.114726,-28.829914,174.875946>,<25.887888,-30.696514,175.600393>,<26.506434,-30.573475,175.600393>}
      triangle {<26.506434,-28.553089,174.875942>,<25.114726,-28.829914,174.875946>,<26.506434,-30.573475,175.600393>}
      triangle {<23.934893,-29.618244,174.875943>,<25.363535,-31.046886,175.600393>,<25.887888,-30.696514,175.600393>}
      triangle {<25.114726,-28.829914,174.875946>,<23.934893,-29.618244,174.875943>,<25.887888,-30.696514,175.600393>}
      triangle {<23.146548,-30.798077,174.875946>,<25.013163,-31.571247,175.600400>,<25.363535,-31.046886,175.600393>}
      triangle {<23.934893,-29.618244,174.875943>,<23.146548,-30.798077,174.875946>,<25.363535,-31.046886,175.600393>}
      triangle {<22.869730,-32.189785,174.875946>,<24.890116,-32.189785,175.600393>,<25.013163,-31.571247,175.600400>}
      triangle {<23.146548,-30.798077,174.875946>,<22.869730,-32.189785,174.875946>,<25.013163,-31.571247,175.600400>}
      triangle {<23.146548,-33.581509,174.875946>,<25.013163,-32.808323,175.600393>,<24.890116,-32.189785,175.600393>}
      triangle {<22.869730,-32.189785,174.875946>,<23.146548,-33.581509,174.875946>,<24.890116,-32.189785,175.600393>}
      triangle {<23.934893,-34.761311,174.875947>,<25.363535,-33.332684,175.600393>,<25.013163,-32.808323,175.600393>}
      triangle {<23.146548,-33.581509,174.875946>,<23.934893,-34.761311,174.875947>,<25.013163,-32.808323,175.600393>}
      triangle {<25.114726,-35.549656,174.875943>,<25.887888,-33.683056,175.600393>,<25.363535,-33.332684,175.600393>}
      triangle {<23.934893,-34.761311,174.875947>,<25.114726,-35.549656,174.875943>,<25.363535,-33.332684,175.600393>}
      triangle {<26.506434,-35.826473,174.875947>,<26.506434,-33.806095,175.600393>,<25.887888,-33.683056,175.600393>}
      triangle {<25.114726,-35.549656,174.875943>,<26.506434,-35.826473,174.875947>,<25.887888,-33.683056,175.600393>}
      triangle {<27.898127,-35.549656,174.875943>,<27.124972,-33.683056,175.600393>,<26.506434,-33.806095,175.600393>}
      triangle {<26.506434,-35.826473,174.875947>,<27.898127,-35.549656,174.875943>,<26.506434,-33.806095,175.600393>}
      triangle {<29.077960,-34.761311,174.875947>,<27.649340,-33.332684,175.600393>,<27.124972,-33.683056,175.600393>}
      triangle {<27.898127,-35.549656,174.875943>,<29.077960,-34.761311,174.875947>,<27.124972,-33.683056,175.600393>}
      triangle {<29.866313,-33.581478,174.875946>,<27.999712,-32.808323,175.600393>,<27.649340,-33.332684,175.600393>}
      triangle {<29.077960,-34.761311,174.875947>,<29.866313,-33.581478,174.875946>,<27.649340,-33.332684,175.600393>}
      triangle {<30.143130,-32.189785,174.875946>,<28.122744,-32.189785,175.600393>,<27.999712,-32.808323,175.600393>}
      triangle {<29.866313,-33.581478,174.875946>,<30.143130,-32.189785,174.875946>,<27.999712,-32.808323,175.600393>}
      triangle {<27.872622,-31.623890,175.600393>,<29.580363,-30.916523,174.875943>,<27.985186,-32.189785,175.600393>}
      triangle {<29.580363,-30.916523,174.875943>,<29.833621,-32.189785,174.875946>,<27.985186,-32.189785,175.600393>}
      triangle {<27.552065,-31.144146,175.600393>,<28.859118,-29.837101,174.875943>,<27.872622,-31.623890,175.600393>}
      triangle {<28.859118,-29.837101,174.875943>,<29.580363,-30.916523,174.875943>,<27.872622,-31.623890,175.600393>}
      triangle {<27.072329,-30.823582,175.600393>,<27.779696,-29.115864,174.875946>,<27.552065,-31.144146,175.600393>}
      triangle {<27.779696,-29.115864,174.875946>,<28.859118,-29.837101,174.875943>,<27.552065,-31.144146,175.600393>}
      triangle {<26.506434,-30.711033,175.600393>,<26.506434,-28.862598,174.875946>,<27.072329,-30.823582,175.600393>}
      triangle {<26.506434,-28.862598,174.875946>,<27.779696,-29.115864,174.875946>,<27.072329,-30.823582,175.600393>}
      triangle {<25.940539,-30.823582,175.600393>,<25.233180,-29.115864,174.875946>,<26.506434,-30.711033,175.600393>}
      triangle {<25.233180,-29.115864,174.875946>,<26.506434,-28.862598,174.875946>,<26.506434,-30.711033,175.600393>}
      triangle {<25.460795,-31.144146,175.600393>,<24.153750,-29.837101,174.875943>,<25.940539,-30.823582,175.600393>}
      triangle {<24.153750,-29.837101,174.875943>,<25.233180,-29.115864,174.875946>,<25.940539,-30.823582,175.600393>}
      triangle {<25.140246,-31.623890,175.600393>,<23.432490,-30.916523,174.875943>,<25.460795,-31.144146,175.600393>}
      triangle {<23.432490,-30.916523,174.875943>,<24.153750,-29.837101,174.875943>,<25.460795,-31.144146,175.600393>}
      triangle {<25.027682,-32.189785,175.600393>,<23.179232,-32.189785,174.875946>,<25.140246,-31.623890,175.600393>}
      triangle {<23.179232,-32.189785,174.875946>,<23.432490,-30.916523,174.875943>,<25.140246,-31.623890,175.600393>}
      triangle {<25.140246,-32.755680,175.600393>,<23.432490,-33.463047,174.875946>,<25.027682,-32.189785,175.600393>}
      triangle {<23.432490,-33.463047,174.875946>,<23.179232,-32.189785,174.875946>,<25.027682,-32.189785,175.600393>}
      triangle {<25.460795,-33.235424,175.600393>,<24.153750,-34.542469,174.875947>,<25.140246,-32.755680,175.600393>}
      triangle {<24.153750,-34.542469,174.875947>,<23.432490,-33.463047,174.875946>,<25.140246,-32.755680,175.600393>}
      triangle {<25.940539,-33.555981,175.600393>,<25.233180,-35.263714,174.875943>,<25.460795,-33.235424,175.600393>}
      triangle {<25.233180,-35.263714,174.875943>,<24.153750,-34.542469,174.875947>,<25.460795,-33.235424,175.600393>}
      triangle {<26.506434,-33.668530,175.600393>,<26.506434,-35.516972,174.875943>,<25.940539,-33.555981,175.600393>}
      triangle {<26.506434,-35.516972,174.875943>,<25.233180,-35.263714,174.875943>,<25.940539,-33.555981,175.600393>}
      triangle {<27.072329,-33.555981,175.600393>,<27.779696,-35.263714,174.875943>,<26.506434,-33.668530,175.600393>}
      triangle {<27.779696,-35.263714,174.875943>,<26.506434,-35.516972,174.875943>,<26.506434,-33.668530,175.600393>}
      triangle {<27.552065,-33.235424,175.600393>,<28.859118,-34.542469,174.875947>,<27.072329,-33.555981,175.600393>}
      triangle {<28.859118,-34.542469,174.875947>,<27.779696,-35.263714,174.875943>,<27.072329,-33.555981,175.600393>}
      triangle {<27.872622,-32.755680,175.600393>,<29.580363,-33.463047,174.875946>,<27.552065,-33.235424,175.600393>}
      triangle {<29.580363,-33.463047,174.875946>,<28.859118,-34.542469,174.875947>,<27.552065,-33.235424,175.600393>}
      triangle {<27.985186,-32.189785,175.600393>,<29.833621,-32.189785,174.875946>,<27.872622,-32.755680,175.600393>}
      triangle {<29.833621,-32.189785,174.875946>,<29.580363,-33.463047,174.875946>,<27.872622,-32.755680,175.600393>}
      triangle {<27.872622,-31.623890,175.600393>,<27.985186,-32.189785,175.600393>,<28.122744,-32.189785,175.600393>}
      triangle {<27.999712,-31.571247,175.600400>,<27.872622,-31.623890,175.600393>,<28.122744,-32.189785,175.600393>}
      triangle {<27.552065,-31.144146,175.600393>,<27.872622,-31.623890,175.600393>,<27.999712,-31.571247,175.600400>}
      triangle {<27.649340,-31.046886,175.600393>,<27.552065,-31.144146,175.600393>,<27.999712,-31.571247,175.600400>}
      triangle {<27.072329,-30.823582,175.600393>,<27.552065,-31.144146,175.600393>,<27.649340,-31.046886,175.600393>}
      triangle {<27.124972,-30.696514,175.600393>,<27.072329,-30.823582,175.600393>,<27.649340,-31.046886,175.600393>}
      triangle {<26.506434,-30.711033,175.600393>,<27.072329,-30.823582,175.600393>,<27.124972,-30.696514,175.600393>}
      triangle {<26.506434,-30.573475,175.600393>,<26.506434,-30.711033,175.600393>,<27.124972,-30.696514,175.600393>}
      triangle {<25.940539,-30.823582,175.600393>,<26.506434,-30.711033,175.600393>,<26.506434,-30.573475,175.600393>}
      triangle {<25.887888,-30.696514,175.600393>,<25.940539,-30.823582,175.600393>,<26.506434,-30.573475,175.600393>}
      triangle {<25.460795,-31.144146,175.600393>,<25.940539,-30.823582,175.600393>,<25.887888,-30.696514,175.600393>}
      triangle {<25.363535,-31.046886,175.600393>,<25.460795,-31.144146,175.600393>,<25.887888,-30.696514,175.600393>}
      triangle {<25.140246,-31.623890,175.600393>,<25.460795,-31.144146,175.600393>,<25.363535,-31.046886,175.600393>}
      triangle {<25.013163,-31.571247,175.600400>,<25.140246,-31.623890,175.600393>,<25.363535,-31.046886,175.600393>}
      triangle {<25.027682,-32.189785,175.600393>,<25.140246,-31.623890,175.600393>,<25.013163,-31.571247,175.600400>}
      triangle {<24.890116,-32.189785,175.600393>,<25.027682,-32.189785,175.600393>,<25.013163,-31.571247,175.600400>}
      triangle {<25.140246,-32.755680,175.600393>,<25.027682,-32.189785,175.600393>,<24.890116,-32.189785,175.600393>}
      triangle {<25.013163,-32.808323,175.600393>,<25.140246,-32.755680,175.600393>,<24.890116,-32.189785,175.600393>}
      triangle {<25.460795,-33.235424,175.600393>,<25.140246,-32.755680,175.600393>,<25.013163,-32.808323,175.600393>}
      triangle {<25.363535,-33.332684,175.600393>,<25.460795,-33.235424,175.600393>,<25.013163,-32.808323,175.600393>}
      triangle {<25.940539,-33.555981,175.600393>,<25.460795,-33.235424,175.600393>,<25.363535,-33.332684,175.600393>}
      triangle {<25.887888,-33.683056,175.600393>,<25.940539,-33.555981,175.600393>,<25.363535,-33.332684,175.600393>}
      triangle {<26.506434,-33.668530,175.600393>,<25.940539,-33.555981,175.600393>,<25.887888,-33.683056,175.600393>}
      triangle {<26.506434,-33.806095,175.600393>,<26.506434,-33.668530,175.600393>,<25.887888,-33.683056,175.600393>}
      triangle {<27.072329,-33.555981,175.600393>,<26.506434,-33.668530,175.600393>,<26.506434,-33.806095,175.600393>}
      triangle {<27.124972,-33.683056,175.600393>,<27.072329,-33.555981,175.600393>,<26.506434,-33.806095,175.600393>}
      triangle {<27.552065,-33.235424,175.600393>,<27.072329,-33.555981,175.600393>,<27.124972,-33.683056,175.600393>}
      triangle {<27.649340,-33.332684,175.600393>,<27.552065,-33.235424,175.600393>,<27.124972,-33.683056,175.600393>}
      triangle {<27.872622,-32.755680,175.600393>,<27.552065,-33.235424,175.600393>,<27.649340,-33.332684,175.600393>}
      triangle {<27.999712,-32.808323,175.600393>,<27.872622,-32.755680,175.600393>,<27.649340,-33.332684,175.600393>}
      triangle {<27.985186,-32.189785,175.600393>,<27.872622,-32.755680,175.600393>,<27.999712,-32.808323,175.600393>}
      triangle {<28.122744,-32.189785,175.600393>,<27.985186,-32.189785,175.600393>,<27.999712,-32.808323,175.600393>}
      triangle {<29.580363,-30.916523,174.875943>,<29.866313,-30.798077,174.875946>,<30.143130,-32.189785,174.875946>}
      triangle {<29.833621,-32.189785,174.875946>,<29.580363,-30.916523,174.875943>,<30.143130,-32.189785,174.875946>}
      triangle {<28.859118,-29.837101,174.875943>,<29.077960,-29.618244,174.875943>,<29.866313,-30.798077,174.875946>}
      triangle {<29.580363,-30.916523,174.875943>,<28.859118,-29.837101,174.875943>,<29.866313,-30.798077,174.875946>}
      triangle {<27.779696,-29.115864,174.875946>,<27.898127,-28.829914,174.875946>,<29.077960,-29.618244,174.875943>}
      triangle {<28.859118,-29.837101,174.875943>,<27.779696,-29.115864,174.875946>,<29.077960,-29.618244,174.875943>}
      triangle {<26.506434,-28.862598,174.875946>,<26.506434,-28.553089,174.875942>,<27.898127,-28.829914,174.875946>}
      triangle {<27.779696,-29.115864,174.875946>,<26.506434,-28.862598,174.875946>,<27.898127,-28.829914,174.875946>}
      triangle {<25.233180,-29.115864,174.875946>,<25.114726,-28.829914,174.875946>,<26.506434,-28.553089,174.875942>}
      triangle {<26.506434,-28.862598,174.875946>,<25.233180,-29.115864,174.875946>,<26.506434,-28.553089,174.875942>}
      triangle {<24.153750,-29.837101,174.875943>,<23.934893,-29.618244,174.875943>,<25.114726,-28.829914,174.875946>}
      triangle {<25.233180,-29.115864,174.875946>,<24.153750,-29.837101,174.875943>,<25.114726,-28.829914,174.875946>}
      triangle {<23.432490,-30.916523,174.875943>,<23.146548,-30.798077,174.875946>,<23.934893,-29.618244,174.875943>}
      triangle {<24.153750,-29.837101,174.875943>,<23.432490,-30.916523,174.875943>,<23.934893,-29.618244,174.875943>}
      triangle {<23.179232,-32.189785,174.875946>,<22.869730,-32.189785,174.875946>,<23.146548,-30.798077,174.875946>}
      triangle {<23.432490,-30.916523,174.875943>,<23.179232,-32.189785,174.875946>,<23.146548,-30.798077,174.875946>}
      triangle {<23.432490,-33.463047,174.875946>,<23.146548,-33.581509,174.875946>,<22.869730,-32.189785,174.875946>}
      triangle {<23.179232,-32.189785,174.875946>,<23.432490,-33.463047,174.875946>,<22.869730,-32.189785,174.875946>}
      triangle {<24.153750,-34.542469,174.875947>,<23.934893,-34.761311,174.875947>,<23.146548,-33.581509,174.875946>}
      triangle {<23.432490,-33.463047,174.875946>,<24.153750,-34.542469,174.875947>,<23.146548,-33.581509,174.875946>}
      triangle {<25.233180,-35.263714,174.875943>,<25.114726,-35.549656,174.875943>,<23.934893,-34.761311,174.875947>}
      triangle {<24.153750,-34.542469,174.875947>,<25.233180,-35.263714,174.875943>,<23.934893,-34.761311,174.875947>}
      triangle {<26.506434,-35.516972,174.875943>,<26.506434,-35.826473,174.875947>,<25.114726,-35.549656,174.875943>}
      triangle {<25.233180,-35.263714,174.875943>,<26.506434,-35.516972,174.875943>,<25.114726,-35.549656,174.875943>}
      triangle {<27.779696,-35.263714,174.875943>,<27.898127,-35.549656,174.875943>,<26.506434,-35.826473,174.875947>}
      triangle {<26.506434,-35.516972,174.875943>,<27.779696,-35.263714,174.875943>,<26.506434,-35.826473,174.875947>}
      triangle {<28.859118,-34.542469,174.875947>,<29.077960,-34.761311,174.875947>,<27.898127,-35.549656,174.875943>}
      triangle {<27.779696,-35.263714,174.875943>,<28.859118,-34.542469,174.875947>,<27.898127,-35.549656,174.875943>}
      triangle {<29.580363,-33.463047,174.875946>,<29.866313,-33.581478,174.875946>,<29.077960,-34.761311,174.875947>}
      triangle {<28.859118,-34.542469,174.875947>,<29.580363,-33.463047,174.875946>,<29.077960,-34.761311,174.875947>}
      triangle {<29.833621,-32.189785,174.875946>,<30.143130,-32.189785,174.875946>,<29.866313,-33.581478,174.875946>}
      triangle {<29.580363,-33.463047,174.875946>,<29.833621,-32.189785,174.875946>,<29.866313,-33.581478,174.875946>}
      texture{_Duse01}
    }
    //_Duse04
    mesh{
      triangle {<-24.737073,-32.189785,170.550524>,<-24.986372,-30.936481,170.550524>,<-24.229932,-30.623150,176.300127>}
      triangle {<-24.737073,-32.189785,170.550524>,<-24.229932,-30.623150,176.300127>,<-23.918317,-32.189785,176.300128>}
      triangle {<-24.986372,-30.936481,170.550524>,<-25.696310,-29.873981,170.550524>,<-25.117361,-29.295025,176.300127>}
      triangle {<-24.986372,-30.936481,170.550524>,<-25.117361,-29.295025,176.300127>,<-24.229932,-30.623150,176.300127>}
      triangle {<-25.696310,-29.873981,170.550524>,<-26.758810,-29.164036,170.550523>,<-26.445486,-28.407604,176.300127>}
      triangle {<-25.696310,-29.873981,170.550524>,<-26.445486,-28.407604,176.300127>,<-25.117361,-29.295025,176.300127>}
      triangle {<-26.758810,-29.164036,170.550523>,<-28.012121,-28.914745,170.550523>,<-28.012121,-28.095982,176.300127>}
      triangle {<-26.758810,-29.164036,170.550523>,<-28.012121,-28.095982,176.300127>,<-26.445486,-28.407604,176.300127>}
      triangle {<-28.012121,-28.914745,170.550523>,<-29.265424,-29.164036,170.550523>,<-29.578748,-28.407604,176.300127>}
      triangle {<-28.012121,-28.914745,170.550523>,<-29.578748,-28.407604,176.300127>,<-28.012121,-28.095982,176.300127>}
      triangle {<-29.265424,-29.164036,170.550523>,<-30.327924,-29.873981,170.550524>,<-30.906873,-29.295025,176.300127>}
      triangle {<-29.265424,-29.164036,170.550523>,<-30.906873,-29.295025,176.300127>,<-29.578748,-28.407604,176.300127>}
      triangle {<-30.327924,-29.873981,170.550524>,<-31.037862,-30.936481,170.550524>,<-31.794302,-30.623150,176.300127>}
      triangle {<-30.327924,-29.873981,170.550524>,<-31.794302,-30.623150,176.300127>,<-30.906873,-29.295025,176.300127>}
      triangle {<-31.037862,-30.936481,170.550524>,<-31.287160,-32.189785,170.550524>,<-32.105924,-32.189785,176.300128>}
      triangle {<-31.037862,-30.936481,170.550524>,<-32.105924,-32.189785,176.300128>,<-31.794302,-30.623150,176.300127>}
      triangle {<-31.287160,-32.189785,170.550524>,<-31.037862,-33.443089,170.550524>,<-31.794302,-33.756420,176.300128>}
      triangle {<-31.287160,-32.189785,170.550524>,<-31.794302,-33.756420,176.300128>,<-32.105924,-32.189785,176.300128>}
      triangle {<-31.037862,-33.443089,170.550524>,<-30.327924,-34.505589,170.550524>,<-30.906873,-35.084538,176.300128>}
      triangle {<-31.037862,-33.443089,170.550524>,<-30.906873,-35.084538,176.300128>,<-31.794302,-33.756420,176.300128>}
      triangle {<-30.327924,-34.505589,170.550524>,<-29.265424,-35.215534,170.550524>,<-29.578748,-35.971966,176.300128>}
      triangle {<-30.327924,-34.505589,170.550524>,<-29.578748,-35.971966,176.300128>,<-30.906873,-35.084538,176.300128>}
      triangle {<-29.265424,-35.215534,170.550524>,<-28.012121,-35.464825,170.550524>,<-28.012121,-36.283588,176.300128>}
      triangle {<-29.265424,-35.215534,170.550524>,<-28.012121,-36.283588,176.300128>,<-29.578748,-35.971966,176.300128>}
      triangle {<-28.012121,-35.464825,170.550524>,<-26.758810,-35.215534,170.550524>,<-26.445486,-35.971966,176.300128>}
      triangle {<-28.012121,-35.464825,170.550524>,<-26.445486,-35.971966,176.300128>,<-28.012121,-36.283588,176.300128>}
      triangle {<-26.758810,-35.215534,170.550524>,<-25.696310,-34.505589,170.550524>,<-25.117361,-35.084538,176.300128>}
      triangle {<-26.758810,-35.215534,170.550524>,<-25.117361,-35.084538,176.300128>,<-26.445486,-35.971966,176.300128>}
      triangle {<-25.696310,-34.505589,170.550524>,<-24.986372,-33.443089,170.550524>,<-24.229932,-33.756413,176.300128>}
      triangle {<-25.696310,-34.505589,170.550524>,<-24.229932,-33.756413,176.300128>,<-25.117361,-35.084538,176.300128>}
      triangle {<-24.986372,-33.443089,170.550524>,<-24.737073,-32.189785,170.550524>,<-23.918317,-32.189785,176.300128>}
      triangle {<-24.986372,-33.443089,170.550524>,<-23.918317,-32.189785,176.300128>,<-24.229932,-33.756413,176.300128>}
      triangle {<-25.015806,-32.189785,170.550524>,<-24.551824,-30.756481,176.300127>,<-25.243886,-31.043148,170.550524>}
      triangle {<-25.015806,-32.189785,170.550524>,<-24.266721,-32.189785,176.300128>,<-24.551824,-30.756481,176.300127>}
      triangle {<-25.243886,-31.043148,170.550524>,<-25.363721,-29.541386,176.300127>,<-25.893407,-30.071072,170.550524>}
      triangle {<-25.243886,-31.043148,170.550524>,<-24.551824,-30.756481,176.300127>,<-25.363721,-29.541386,176.300127>}
      triangle {<-25.893407,-30.071072,170.550524>,<-26.578817,-28.729496,176.300127>,<-26.865476,-29.421543,170.550523>}
      triangle {<-25.893407,-30.071072,170.550524>,<-25.363721,-29.541386,176.300127>,<-26.578817,-28.729496,176.300127>}
      triangle {<-26.865476,-29.421543,170.550523>,<-28.012121,-28.444393,176.300127>,<-28.012121,-29.193470,170.550523>}
      triangle {<-26.865476,-29.421543,170.550523>,<-26.578817,-28.729496,176.300127>,<-28.012121,-28.444393,176.300127>}
      triangle {<-28.012121,-29.193470,170.550523>,<-29.445417,-28.729496,176.300127>,<-29.158758,-29.421543,170.550523>}
      triangle {<-28.012121,-29.193470,170.550523>,<-28.012121,-28.444393,176.300127>,<-29.445417,-28.729496,176.300127>}
      triangle {<-29.158758,-29.421543,170.550523>,<-30.660512,-29.541386,176.300127>,<-30.130834,-30.071072,170.550524>}
      triangle {<-29.158758,-29.421543,170.550523>,<-29.445417,-28.729496,176.300127>,<-30.660512,-29.541386,176.300127>}
      triangle {<-30.130834,-30.071072,170.550524>,<-31.472417,-30.756481,176.300127>,<-30.780347,-31.043148,170.550524>}
      triangle {<-30.130834,-30.071072,170.550524>,<-30.660512,-29.541386,176.300127>,<-31.472417,-30.756481,176.300127>}
      triangle {<-30.780347,-31.043148,170.550524>,<-31.757513,-32.189785,176.300128>,<-31.008436,-32.189785,170.550524>}
      triangle {<-30.780347,-31.043148,170.550524>,<-31.472417,-30.756481,176.300127>,<-31.757513,-32.189785,176.300128>}
      triangle {<-31.008436,-32.189785,170.550524>,<-31.472417,-33.623081,176.300128>,<-30.780347,-33.336422,170.550524>}
      triangle {<-31.008436,-32.189785,170.550524>,<-31.757513,-32.189785,176.300128>,<-31.472417,-33.623081,176.300128>}
      triangle {<-30.780347,-33.336422,170.550524>,<-30.660512,-34.838177,176.300128>,<-30.130834,-34.308498,170.550524>}
      triangle {<-30.780347,-33.336422,170.550524>,<-31.472417,-33.623081,176.300128>,<-30.660512,-34.838177,176.300128>}
      triangle {<-30.130834,-34.308498,170.550524>,<-29.445417,-35.650074,176.300128>,<-29.158758,-34.958019,170.550524>}
      triangle {<-30.130834,-34.308498,170.550524>,<-30.660512,-34.838177,176.300128>,<-29.445417,-35.650074,176.300128>}
      triangle {<-29.158758,-34.958019,170.550524>,<-28.012121,-35.935177,176.300128>,<-28.012121,-35.186100,170.550524>}
      triangle {<-29.158758,-34.958019,170.550524>,<-29.445417,-35.650074,176.300128>,<-28.012121,-35.935177,176.300128>}
      triangle {<-28.012121,-35.186100,170.550524>,<-26.578817,-35.650074,176.300128>,<-26.865476,-34.958019,170.550524>}
      triangle {<-28.012121,-35.186100,170.550524>,<-28.012121,-35.935177,176.300128>,<-26.578817,-35.650074,176.300128>}
      triangle {<-26.865476,-34.958019,170.550524>,<-25.363721,-34.838177,176.300128>,<-25.893407,-34.308498,170.550524>}
      triangle {<-26.865476,-34.958019,170.550524>,<-26.578817,-35.650074,176.300128>,<-25.363721,-34.838177,176.300128>}
      triangle {<-25.893407,-34.308498,170.550524>,<-24.551824,-33.623081,176.300128>,<-25.243879,-33.336422,170.550524>}
      triangle {<-25.893407,-34.308498,170.550524>,<-25.363721,-34.838177,176.300128>,<-24.551824,-33.623081,176.300128>}
      triangle {<-25.243879,-33.336422,170.550524>,<-24.266721,-32.189785,176.300128>,<-25.015806,-32.189785,170.550524>}
      triangle {<-25.243879,-33.336422,170.550524>,<-24.551824,-33.623081,176.300128>,<-24.266721,-32.189785,176.300128>}
      triangle {<-24.737073,-32.189785,170.550524>,<-25.015806,-32.189785,170.550524>,<-25.243886,-31.043148,170.550524>}
      triangle {<-24.737073,-32.189785,170.550524>,<-25.243886,-31.043148,170.550524>,<-24.986372,-30.936481,170.550524>}
      triangle {<-24.986372,-30.936481,170.550524>,<-25.243886,-31.043148,170.550524>,<-25.893407,-30.071072,170.550524>}
      triangle {<-24.986372,-30.936481,170.550524>,<-25.893407,-30.071072,170.550524>,<-25.696310,-29.873981,170.550524>}
      triangle {<-25.696310,-29.873981,170.550524>,<-25.893407,-30.071072,170.550524>,<-26.865476,-29.421543,170.550523>}
      triangle {<-25.696310,-29.873981,170.550524>,<-26.865476,-29.421543,170.550523>,<-26.758810,-29.164036,170.550523>}
      triangle {<-26.758810,-29.164036,170.550523>,<-26.865476,-29.421543,170.550523>,<-28.012121,-29.193470,170.550523>}
      triangle {<-26.758810,-29.164036,170.550523>,<-28.012121,-29.193470,170.550523>,<-28.012121,-28.914745,170.550523>}
      triangle {<-28.012121,-28.914745,170.550523>,<-28.012121,-29.193470,170.550523>,<-29.158758,-29.421543,170.550523>}
      triangle {<-28.012121,-28.914745,170.550523>,<-29.158758,-29.421543,170.550523>,<-29.265424,-29.164036,170.550523>}
      triangle {<-29.265424,-29.164036,170.550523>,<-29.158758,-29.421543,170.550523>,<-30.130834,-30.071072,170.550524>}
      triangle {<-29.265424,-29.164036,170.550523>,<-30.130834,-30.071072,170.550524>,<-30.327924,-29.873981,170.550524>}
      triangle {<-30.327924,-29.873981,170.550524>,<-30.130834,-30.071072,170.550524>,<-30.780347,-31.043148,170.550524>}
      triangle {<-30.327924,-29.873981,170.550524>,<-30.780347,-31.043148,170.550524>,<-31.037862,-30.936481,170.550524>}
      triangle {<-31.037862,-30.936481,170.550524>,<-30.780347,-31.043148,170.550524>,<-31.008436,-32.189785,170.550524>}
      triangle {<-31.037862,-30.936481,170.550524>,<-31.008436,-32.189785,170.550524>,<-31.287160,-32.189785,170.550524>}
      triangle {<-31.287160,-32.189785,170.550524>,<-31.008436,-32.189785,170.550524>,<-30.780347,-33.336422,170.550524>}
      triangle {<-31.287160,-32.189785,170.550524>,<-30.780347,-33.336422,170.550524>,<-31.037862,-33.443089,170.550524>}
      triangle {<-31.037862,-33.443089,170.550524>,<-30.780347,-33.336422,170.550524>,<-30.130834,-34.308498,170.550524>}
      triangle {<-31.037862,-33.443089,170.550524>,<-30.130834,-34.308498,170.550524>,<-30.327924,-34.505589,170.550524>}
      triangle {<-30.327924,-34.505589,170.550524>,<-30.130834,-34.308498,170.550524>,<-29.158758,-34.958019,170.550524>}
      triangle {<-30.327924,-34.505589,170.550524>,<-29.158758,-34.958019,170.550524>,<-29.265424,-35.215534,170.550524>}
      triangle {<-29.265424,-35.215534,170.550524>,<-29.158758,-34.958019,170.550524>,<-28.012121,-35.186100,170.550524>}
      triangle {<-29.265424,-35.215534,170.550524>,<-28.012121,-35.186100,170.550524>,<-28.012121,-35.464825,170.550524>}
      triangle {<-28.012121,-35.464825,170.550524>,<-28.012121,-35.186100,170.550524>,<-26.865476,-34.958019,170.550524>}
      triangle {<-28.012121,-35.464825,170.550524>,<-26.865476,-34.958019,170.550524>,<-26.758810,-35.215534,170.550524>}
      triangle {<-26.758810,-35.215534,170.550524>,<-26.865476,-34.958019,170.550524>,<-25.893407,-34.308498,170.550524>}
      triangle {<-26.758810,-35.215534,170.550524>,<-25.893407,-34.308498,170.550524>,<-25.696310,-34.505589,170.550524>}
      triangle {<-25.696310,-34.505589,170.550524>,<-25.893407,-34.308498,170.550524>,<-25.243879,-33.336422,170.550524>}
      triangle {<-25.696310,-34.505589,170.550524>,<-25.243879,-33.336422,170.550524>,<-24.986372,-33.443089,170.550524>}
      triangle {<-24.986372,-33.443089,170.550524>,<-25.243879,-33.336422,170.550524>,<-25.015806,-32.189785,170.550524>}
      triangle {<-24.986372,-33.443089,170.550524>,<-25.015806,-32.189785,170.550524>,<-24.737073,-32.189785,170.550524>}
      triangle {<-23.918317,-32.189785,176.300128>,<-24.229932,-30.623150,176.300127>,<-24.551824,-30.756481,176.300127>}
      triangle {<-23.918317,-32.189785,176.300128>,<-24.551824,-30.756481,176.300127>,<-24.266721,-32.189785,176.300128>}
      triangle {<-24.229932,-30.623150,176.300127>,<-25.117361,-29.295025,176.300127>,<-25.363721,-29.541386,176.300127>}
      triangle {<-24.229932,-30.623150,176.300127>,<-25.363721,-29.541386,176.300127>,<-24.551824,-30.756481,176.300127>}
      triangle {<-25.117361,-29.295025,176.300127>,<-26.445486,-28.407604,176.300127>,<-26.578817,-28.729496,176.300127>}
      triangle {<-25.117361,-29.295025,176.300127>,<-26.578817,-28.729496,176.300127>,<-25.363721,-29.541386,176.300127>}
      triangle {<-26.445486,-28.407604,176.300127>,<-28.012121,-28.095982,176.300127>,<-28.012121,-28.444393,176.300127>}
      triangle {<-26.445486,-28.407604,176.300127>,<-28.012121,-28.444393,176.300127>,<-26.578817,-28.729496,176.300127>}
      triangle {<-28.012121,-28.095982,176.300127>,<-29.578748,-28.407604,176.300127>,<-29.445417,-28.729496,176.300127>}
      triangle {<-28.012121,-28.095982,176.300127>,<-29.445417,-28.729496,176.300127>,<-28.012121,-28.444393,176.300127>}
      triangle {<-29.578748,-28.407604,176.300127>,<-30.906873,-29.295025,176.300127>,<-30.660512,-29.541386,176.300127>}
      triangle {<-29.578748,-28.407604,176.300127>,<-30.660512,-29.541386,176.300127>,<-29.445417,-28.729496,176.300127>}
      triangle {<-30.906873,-29.295025,176.300127>,<-31.794302,-30.623150,176.300127>,<-31.472417,-30.756481,176.300127>}
      triangle {<-30.906873,-29.295025,176.300127>,<-31.472417,-30.756481,176.300127>,<-30.660512,-29.541386,176.300127>}
      triangle {<-31.794302,-30.623150,176.300127>,<-32.105924,-32.189785,176.300128>,<-31.757513,-32.189785,176.300128>}
      triangle {<-31.794302,-30.623150,176.300127>,<-31.757513,-32.189785,176.300128>,<-31.472417,-30.756481,176.300127>}
      triangle {<-32.105924,-32.189785,176.300128>,<-31.794302,-33.756420,176.300128>,<-31.472417,-33.623081,176.300128>}
      triangle {<-32.105924,-32.189785,176.300128>,<-31.472417,-33.623081,176.300128>,<-31.757513,-32.189785,176.300128>}
      triangle {<-31.794302,-33.756420,176.300128>,<-30.906873,-35.084538,176.300128>,<-30.660512,-34.838177,176.300128>}
      triangle {<-31.794302,-33.756420,176.300128>,<-30.660512,-34.838177,176.300128>,<-31.472417,-33.623081,176.300128>}
      triangle {<-30.906873,-35.084538,176.300128>,<-29.578748,-35.971966,176.300128>,<-29.445417,-35.650074,176.300128>}
      triangle {<-30.906873,-35.084538,176.300128>,<-29.445417,-35.650074,176.300128>,<-30.660512,-34.838177,176.300128>}
      triangle {<-29.578748,-35.971966,176.300128>,<-28.012121,-36.283588,176.300128>,<-28.012121,-35.935177,176.300128>}
      triangle {<-29.578748,-35.971966,176.300128>,<-28.012121,-35.935177,176.300128>,<-29.445417,-35.650074,176.300128>}
      triangle {<-28.012121,-36.283588,176.300128>,<-26.445486,-35.971966,176.300128>,<-26.578817,-35.650074,176.300128>}
      triangle {<-28.012121,-36.283588,176.300128>,<-26.578817,-35.650074,176.300128>,<-28.012121,-35.935177,176.300128>}
      triangle {<-26.445486,-35.971966,176.300128>,<-25.117361,-35.084538,176.300128>,<-25.363721,-34.838177,176.300128>}
      triangle {<-26.445486,-35.971966,176.300128>,<-25.363721,-34.838177,176.300128>,<-26.578817,-35.650074,176.300128>}
      triangle {<-25.117361,-35.084538,176.300128>,<-24.229932,-33.756413,176.300128>,<-24.551824,-33.623081,176.300128>}
      triangle {<-25.117361,-35.084538,176.300128>,<-24.551824,-33.623081,176.300128>,<-25.363721,-34.838177,176.300128>}
      triangle {<-24.229932,-33.756413,176.300128>,<-23.918317,-32.189785,176.300128>,<-24.266721,-32.189785,176.300128>}
      triangle {<-24.229932,-33.756413,176.300128>,<-24.266721,-32.189785,176.300128>,<-24.551824,-33.623081,176.300128>}
      triangle {<-26.273855,-32.182766,174.520843>,<-26.505147,-31.319561,174.520843>,<-26.505147,-31.319561,176.301447>}
      triangle {<-26.273855,-32.182766,174.520843>,<-26.505147,-31.319561,176.301447>,<-26.273855,-32.182766,176.301447>}
      triangle {<-26.505147,-31.319561,174.520843>,<-27.137060,-30.687649,174.520843>,<-27.137060,-30.687649,176.301447>}
      triangle {<-26.505147,-31.319561,174.520843>,<-27.137060,-30.687649,176.301447>,<-26.505147,-31.319561,176.301447>}
      triangle {<-27.137060,-30.687649,174.520843>,<-28.000265,-30.456356,174.520843>,<-28.000265,-30.456356,176.301447>}
      triangle {<-27.137060,-30.687649,174.520843>,<-28.000265,-30.456356,176.301447>,<-27.137060,-30.687649,176.301447>}
      triangle {<-28.000265,-30.456356,174.520843>,<-28.863470,-30.687649,174.520843>,<-28.863470,-30.687649,176.301447>}
      triangle {<-28.000265,-30.456356,174.520843>,<-28.863470,-30.687649,176.301447>,<-28.000265,-30.456356,176.301447>}
      triangle {<-28.863470,-30.687649,174.520843>,<-29.495382,-31.319561,174.520843>,<-29.495382,-31.319561,176.301447>}
      triangle {<-28.863470,-30.687649,174.520843>,<-29.495382,-31.319561,176.301447>,<-28.863470,-30.687649,176.301447>}
      triangle {<-29.495382,-31.319561,174.520843>,<-29.726675,-32.182766,174.520843>,<-29.726675,-32.182766,176.301447>}
      triangle {<-29.495382,-31.319561,174.520843>,<-29.726675,-32.182766,176.301447>,<-29.495382,-31.319561,176.301447>}
      triangle {<-29.726675,-32.182766,174.520843>,<-29.495382,-33.045971,174.520843>,<-29.495382,-33.045971,176.301447>}
      triangle {<-29.726675,-32.182766,174.520843>,<-29.495382,-33.045971,176.301447>,<-29.726675,-32.182766,176.301447>}
      triangle {<-29.495382,-33.045971,174.520843>,<-28.863470,-33.677883,174.520843>,<-28.863470,-33.677883,176.301448>}
      triangle {<-29.495382,-33.045971,174.520843>,<-28.863470,-33.677883,176.301448>,<-29.495382,-33.045971,176.301447>}
      triangle {<-28.863470,-33.677883,174.520843>,<-28.000265,-33.909176,174.520843>,<-28.000265,-33.909176,176.301448>}
      triangle {<-28.863470,-33.677883,174.520843>,<-28.000265,-33.909176,176.301448>,<-28.863470,-33.677883,176.301448>}
      triangle {<-28.000265,-33.909176,174.520843>,<-27.137060,-33.677883,174.520843>,<-27.137060,-33.677883,176.301448>}
      triangle {<-28.000265,-33.909176,174.520843>,<-27.137060,-33.677883,176.301448>,<-28.000265,-33.909176,176.301448>}
      triangle {<-27.137060,-33.677883,174.520843>,<-26.505147,-33.045971,174.520843>,<-26.505147,-33.045971,176.301447>}
      triangle {<-27.137060,-33.677883,174.520843>,<-26.505147,-33.045971,176.301447>,<-27.137060,-33.677883,176.301448>}
      triangle {<-26.505147,-33.045971,174.520843>,<-26.273855,-32.182766,174.520843>,<-26.273855,-32.182766,176.301447>}
      triangle {<-26.505147,-33.045971,174.520843>,<-26.273855,-32.182766,176.301447>,<-26.505147,-33.045971,176.301447>}
      triangle {<-26.703741,-32.182766,174.520843>,<-26.877447,-31.534504,176.301447>,<-26.877447,-31.534504,174.520843>}
      triangle {<-26.703741,-32.182766,174.520843>,<-26.703741,-32.182766,176.301447>,<-26.877447,-31.534504,176.301447>}
      triangle {<-26.877447,-31.534504,174.520843>,<-27.352003,-31.059948,176.301447>,<-27.352003,-31.059948,174.520843>}
      triangle {<-26.877447,-31.534504,174.520843>,<-26.877447,-31.534504,176.301447>,<-27.352003,-31.059948,176.301447>}
      triangle {<-27.352003,-31.059948,174.520843>,<-28.000265,-30.886242,176.301447>,<-28.000265,-30.886242,174.520850>}
      triangle {<-27.352003,-31.059948,174.520843>,<-27.352003,-31.059948,176.301447>,<-28.000265,-30.886242,176.301447>}
      triangle {<-28.000265,-30.886242,174.520850>,<-28.648527,-31.059948,176.301447>,<-28.648527,-31.059948,174.520843>}
      triangle {<-28.000265,-30.886242,174.520850>,<-28.000265,-30.886242,176.301447>,<-28.648527,-31.059948,176.301447>}
      triangle {<-28.648527,-31.059948,174.520843>,<-29.123083,-31.534504,176.301447>,<-29.123083,-31.534504,174.520843>}
      triangle {<-28.648527,-31.059948,174.520843>,<-28.648527,-31.059948,176.301447>,<-29.123083,-31.534504,176.301447>}
      triangle {<-29.123083,-31.534504,174.520843>,<-29.296789,-32.182766,176.301447>,<-29.296789,-32.182766,174.520843>}
      triangle {<-29.123083,-31.534504,174.520843>,<-29.123083,-31.534504,176.301447>,<-29.296789,-32.182766,176.301447>}
      triangle {<-29.296789,-32.182766,174.520843>,<-29.123083,-32.831028,176.301447>,<-29.123083,-32.831028,174.520843>}
      triangle {<-29.296789,-32.182766,174.520843>,<-29.296789,-32.182766,176.301447>,<-29.123083,-32.831028,176.301447>}
      triangle {<-29.123083,-32.831028,174.520843>,<-28.648527,-33.305584,176.301447>,<-28.648527,-33.305584,174.520843>}
      triangle {<-29.123083,-32.831028,174.520843>,<-29.123083,-32.831028,176.301447>,<-28.648527,-33.305584,176.301447>}
      triangle {<-28.648527,-33.305584,174.520843>,<-28.000265,-33.479290,176.301448>,<-28.000265,-33.479290,174.520843>}
      triangle {<-28.648527,-33.305584,174.520843>,<-28.648527,-33.305584,176.301447>,<-28.000265,-33.479290,176.301448>}
      triangle {<-28.000265,-33.479290,174.520843>,<-27.352003,-33.305584,176.301447>,<-27.352003,-33.305584,174.520843>}
      triangle {<-28.000265,-33.479290,174.520843>,<-28.000265,-33.479290,176.301448>,<-27.352003,-33.305584,176.301447>}
      triangle {<-27.352003,-33.305584,174.520843>,<-26.877447,-32.831028,176.301447>,<-26.877447,-32.831028,174.520843>}
      triangle {<-27.352003,-33.305584,174.520843>,<-27.352003,-33.305584,176.301447>,<-26.877447,-32.831028,176.301447>}
      triangle {<-26.877447,-32.831028,174.520843>,<-26.703741,-32.182766,176.301447>,<-26.703741,-32.182766,174.520843>}
      triangle {<-26.877447,-32.831028,174.520843>,<-26.877447,-32.831028,176.301447>,<-26.703741,-32.182766,176.301447>}
      triangle {<-26.273855,-32.182766,174.520843>,<-26.703741,-32.182766,174.520843>,<-26.877447,-31.534504,174.520843>}
      triangle {<-26.273855,-32.182766,174.520843>,<-26.877447,-31.534504,174.520843>,<-26.505147,-31.319561,174.520843>}
      triangle {<-26.505147,-31.319561,174.520843>,<-26.877447,-31.534504,174.520843>,<-27.352003,-31.059948,174.520843>}
      triangle {<-26.505147,-31.319561,174.520843>,<-27.352003,-31.059948,174.520843>,<-27.137060,-30.687649,174.520843>}
      triangle {<-27.137060,-30.687649,174.520843>,<-27.352003,-31.059948,174.520843>,<-28.000265,-30.886242,174.520850>}
      triangle {<-27.137060,-30.687649,174.520843>,<-28.000265,-30.886242,174.520850>,<-28.000265,-30.456356,174.520843>}
      triangle {<-28.000265,-30.456356,174.520843>,<-28.000265,-30.886242,174.520850>,<-28.648527,-31.059948,174.520843>}
      triangle {<-28.000265,-30.456356,174.520843>,<-28.648527,-31.059948,174.520843>,<-28.863470,-30.687649,174.520843>}
      triangle {<-28.863470,-30.687649,174.520843>,<-28.648527,-31.059948,174.520843>,<-29.123083,-31.534504,174.520843>}
      triangle {<-28.863470,-30.687649,174.520843>,<-29.123083,-31.534504,174.520843>,<-29.495382,-31.319561,174.520843>}
      triangle {<-29.495382,-31.319561,174.520843>,<-29.123083,-31.534504,174.520843>,<-29.296789,-32.182766,174.520843>}
      triangle {<-29.495382,-31.319561,174.520843>,<-29.296789,-32.182766,174.520843>,<-29.726675,-32.182766,174.520843>}
      triangle {<-29.726675,-32.182766,174.520843>,<-29.296789,-32.182766,174.520843>,<-29.123083,-32.831028,174.520843>}
      triangle {<-29.726675,-32.182766,174.520843>,<-29.123083,-32.831028,174.520843>,<-29.495382,-33.045971,174.520843>}
      triangle {<-29.495382,-33.045971,174.520843>,<-29.123083,-32.831028,174.520843>,<-28.648527,-33.305584,174.520843>}
      triangle {<-29.495382,-33.045971,174.520843>,<-28.648527,-33.305584,174.520843>,<-28.863470,-33.677883,174.520843>}
      triangle {<-28.863470,-33.677883,174.520843>,<-28.648527,-33.305584,174.520843>,<-28.000265,-33.479290,174.520843>}
      triangle {<-28.863470,-33.677883,174.520843>,<-28.000265,-33.479290,174.520843>,<-28.000265,-33.909176,174.520843>}
      triangle {<-28.000265,-33.909176,174.520843>,<-28.000265,-33.479290,174.520843>,<-27.352003,-33.305584,174.520843>}
      triangle {<-28.000265,-33.909176,174.520843>,<-27.352003,-33.305584,174.520843>,<-27.137060,-33.677883,174.520843>}
      triangle {<-27.137060,-33.677883,174.520843>,<-27.352003,-33.305584,174.520843>,<-26.877447,-32.831028,174.520843>}
      triangle {<-27.137060,-33.677883,174.520843>,<-26.877447,-32.831028,174.520843>,<-26.505147,-33.045971,174.520843>}
      triangle {<-26.505147,-33.045971,174.520843>,<-26.877447,-32.831028,174.520843>,<-26.703741,-32.182766,174.520843>}
      triangle {<-26.505147,-33.045971,174.520843>,<-26.703741,-32.182766,174.520843>,<-26.273855,-32.182766,174.520843>}
      triangle {<-26.273855,-32.182766,176.301447>,<-26.505147,-31.319561,176.301447>,<-26.877447,-31.534504,176.301447>}
      triangle {<-26.273855,-32.182766,176.301447>,<-26.877447,-31.534504,176.301447>,<-26.703741,-32.182766,176.301447>}
      triangle {<-26.505147,-31.319561,176.301447>,<-27.137060,-30.687649,176.301447>,<-27.352003,-31.059948,176.301447>}
      triangle {<-26.505147,-31.319561,176.301447>,<-27.352003,-31.059948,176.301447>,<-26.877447,-31.534504,176.301447>}
      triangle {<-27.137060,-30.687649,176.301447>,<-28.000265,-30.456356,176.301447>,<-28.000265,-30.886242,176.301447>}
      triangle {<-27.137060,-30.687649,176.301447>,<-28.000265,-30.886242,176.301447>,<-27.352003,-31.059948,176.301447>}
      triangle {<-28.000265,-30.456356,176.301447>,<-28.863470,-30.687649,176.301447>,<-28.648527,-31.059948,176.301447>}
      triangle {<-28.000265,-30.456356,176.301447>,<-28.648527,-31.059948,176.301447>,<-28.000265,-30.886242,176.301447>}
      triangle {<-28.863470,-30.687649,176.301447>,<-29.495382,-31.319561,176.301447>,<-29.123083,-31.534504,176.301447>}
      triangle {<-28.863470,-30.687649,176.301447>,<-29.123083,-31.534504,176.301447>,<-28.648527,-31.059948,176.301447>}
      triangle {<-29.495382,-31.319561,176.301447>,<-29.726675,-32.182766,176.301447>,<-29.296789,-32.182766,176.301447>}
      triangle {<-29.495382,-31.319561,176.301447>,<-29.296789,-32.182766,176.301447>,<-29.123083,-31.534504,176.301447>}
      triangle {<-29.726675,-32.182766,176.301447>,<-29.495382,-33.045971,176.301447>,<-29.123083,-32.831028,176.301447>}
      triangle {<-29.726675,-32.182766,176.301447>,<-29.123083,-32.831028,176.301447>,<-29.296789,-32.182766,176.301447>}
      triangle {<-29.495382,-33.045971,176.301447>,<-28.863470,-33.677883,176.301448>,<-28.648527,-33.305584,176.301447>}
      triangle {<-29.495382,-33.045971,176.301447>,<-28.648527,-33.305584,176.301447>,<-29.123083,-32.831028,176.301447>}
      triangle {<-28.863470,-33.677883,176.301448>,<-28.000265,-33.909176,176.301448>,<-28.000265,-33.479290,176.301448>}
      triangle {<-28.863470,-33.677883,176.301448>,<-28.000265,-33.479290,176.301448>,<-28.648527,-33.305584,176.301447>}
      triangle {<-28.000265,-33.909176,176.301448>,<-27.137060,-33.677883,176.301448>,<-27.352003,-33.305584,176.301447>}
      triangle {<-28.000265,-33.909176,176.301448>,<-27.352003,-33.305584,176.301447>,<-28.000265,-33.479290,176.301448>}
      triangle {<-27.137060,-33.677883,176.301448>,<-26.505147,-33.045971,176.301447>,<-26.877447,-32.831028,176.301447>}
      triangle {<-27.137060,-33.677883,176.301448>,<-26.877447,-32.831028,176.301447>,<-27.352003,-33.305584,176.301447>}
      triangle {<-26.505147,-33.045971,176.301447>,<-26.273855,-32.182766,176.301447>,<-26.703741,-32.182766,176.301447>}
      triangle {<-26.505147,-33.045971,176.301447>,<-26.703741,-32.182766,176.301447>,<-26.877447,-32.831028,176.301447>}
      triangle {<-24.652242,-30.798077,174.875946>,<-26.518842,-31.571247,175.600400>,<-26.395811,-32.189785,175.600393>}
      triangle {<-24.375425,-32.189785,174.875946>,<-24.652242,-30.798077,174.875946>,<-26.395811,-32.189785,175.600393>}
      triangle {<-25.440595,-29.618244,174.875943>,<-26.869215,-31.046886,175.600393>,<-26.518842,-31.571247,175.600400>}
      triangle {<-24.652242,-30.798077,174.875946>,<-25.440595,-29.618244,174.875943>,<-26.518842,-31.571247,175.600400>}
      triangle {<-26.620428,-28.829914,174.875946>,<-27.393583,-30.696514,175.600393>,<-26.869215,-31.046886,175.600393>}
      triangle {<-25.440595,-29.618244,174.875943>,<-26.620428,-28.829914,174.875946>,<-26.869215,-31.046886,175.600393>}
      triangle {<-28.012121,-28.553089,174.875942>,<-28.012121,-30.573475,175.600393>,<-27.393583,-30.696514,175.600393>}
      triangle {<-26.620428,-28.829914,174.875946>,<-28.012121,-28.553089,174.875942>,<-27.393583,-30.696514,175.600393>}
      triangle {<-29.403829,-28.829914,174.875946>,<-28.630666,-30.696514,175.600393>,<-28.012121,-30.573475,175.600393>}
      triangle {<-28.012121,-28.553089,174.875942>,<-29.403829,-28.829914,174.875946>,<-28.012121,-30.573475,175.600393>}
      triangle {<-30.583662,-29.618244,174.875943>,<-29.155019,-31.046886,175.600393>,<-28.630666,-30.696514,175.600393>}
      triangle {<-29.403829,-28.829914,174.875946>,<-30.583662,-29.618244,174.875943>,<-28.630666,-30.696514,175.600393>}
      triangle {<-31.372007,-30.798077,174.875946>,<-29.505392,-31.571247,175.600400>,<-29.155019,-31.046886,175.600393>}
      triangle {<-30.583662,-29.618244,174.875943>,<-31.372007,-30.798077,174.875946>,<-29.155019,-31.046886,175.600393>}
      triangle {<-31.648824,-32.189785,174.875946>,<-29.628438,-32.189785,175.600393>,<-29.505392,-31.571247,175.600400>}
      triangle {<-31.372007,-30.798077,174.875946>,<-31.648824,-32.189785,174.875946>,<-29.505392,-31.571247,175.600400>}
      triangle {<-31.372007,-33.581509,174.875946>,<-29.505392,-32.808323,175.600393>,<-29.628438,-32.189785,175.600393>}
      triangle {<-31.648824,-32.189785,174.875946>,<-31.372007,-33.581509,174.875946>,<-29.628438,-32.189785,175.600393>}
      triangle {<-30.583662,-34.761311,174.875947>,<-29.155019,-33.332684,175.600393>,<-29.505392,-32.808323,175.600393>}
      triangle {<-31.372007,-33.581509,174.875946>,<-30.583662,-34.761311,174.875947>,<-29.505392,-32.808323,175.600393>}
      triangle {<-29.403829,-35.549656,174.875943>,<-28.630666,-33.683056,175.600393>,<-29.155019,-33.332684,175.600393>}
      triangle {<-30.583662,-34.761311,174.875947>,<-29.403829,-35.549656,174.875943>,<-29.155019,-33.332684,175.600393>}
      triangle {<-28.012121,-35.826473,174.875947>,<-28.012121,-33.806095,175.600393>,<-28.630666,-33.683056,175.600393>}
      triangle {<-29.403829,-35.549656,174.875943>,<-28.012121,-35.826473,174.875947>,<-28.630666,-33.683056,175.600393>}
      triangle {<-26.620428,-35.549656,174.875943>,<-27.393583,-33.683056,175.600393>,<-28.012121,-33.806095,175.600393>}
      triangle {<-28.012121,-35.826473,174.875947>,<-26.620428,-35.549656,174.875943>,<-28.012121,-33.806095,175.600393>}
      triangle {<-25.440595,-34.761311,174.875947>,<-26.869215,-33.332684,175.600393>,<-27.393583,-33.683056,175.600393>}
      triangle {<-26.620428,-35.549656,174.875943>,<-25.440595,-34.761311,174.875947>,<-27.393583,-33.683056,175.600393>}
      triangle {<-24.652242,-33.581478,174.875946>,<-26.518842,-32.808323,175.600393>,<-26.869215,-33.332684,175.600393>}
      triangle {<-25.440595,-34.761311,174.875947>,<-24.652242,-33.581478,174.875946>,<-26.869215,-33.332684,175.600393>}
      triangle {<-24.375425,-32.189785,174.875946>,<-26.395811,-32.189785,175.600393>,<-26.518842,-32.808323,175.600393>}
      triangle {<-24.652242,-33.581478,174.875946>,<-24.375425,-32.189785,174.875946>,<-26.518842,-32.808323,175.600393>}
      triangle {<-26.645933,-31.623890,175.600393>,<-24.938192,-30.916523,174.875943>,<-26.533369,-32.189785,175.600393>}
      triangle {<-24.938192,-30.916523,174.875943>,<-24.684934,-32.189785,174.875946>,<-26.533369,-32.189785,175.600393>}
      triangle {<-26.966489,-31.144146,175.600393>,<-25.659437,-29.837101,174.875943>,<-26.645933,-31.623890,175.600393>}
      triangle {<-25.659437,-29.837101,174.875943>,<-24.938192,-30.916523,174.875943>,<-26.645933,-31.623890,175.600393>}
      triangle {<-27.446226,-30.823582,175.600393>,<-26.738859,-29.115864,174.875946>,<-26.966489,-31.144146,175.600393>}
      triangle {<-26.738859,-29.115864,174.875946>,<-25.659437,-29.837101,174.875943>,<-26.966489,-31.144146,175.600393>}
      triangle {<-28.012121,-30.711033,175.600393>,<-28.012121,-28.862598,174.875946>,<-27.446226,-30.823582,175.600393>}
      triangle {<-28.012121,-28.862598,174.875946>,<-26.738859,-29.115864,174.875946>,<-27.446226,-30.823582,175.600393>}
      triangle {<-28.578016,-30.823582,175.600393>,<-29.285375,-29.115864,174.875946>,<-28.012121,-30.711033,175.600393>}
      triangle {<-29.285375,-29.115864,174.875946>,<-28.012121,-28.862598,174.875946>,<-28.012121,-30.711033,175.600393>}
      triangle {<-29.057760,-31.144146,175.600393>,<-30.364805,-29.837101,174.875943>,<-28.578016,-30.823582,175.600393>}
      triangle {<-30.364805,-29.837101,174.875943>,<-29.285375,-29.115864,174.875946>,<-28.578016,-30.823582,175.600393>}
      triangle {<-29.378309,-31.623890,175.600393>,<-31.086065,-30.916523,174.875943>,<-29.057760,-31.144146,175.600393>}
      triangle {<-31.086065,-30.916523,174.875943>,<-30.364805,-29.837101,174.875943>,<-29.057760,-31.144146,175.600393>}
      triangle {<-29.490873,-32.189785,175.600393>,<-31.339323,-32.189785,174.875946>,<-29.378309,-31.623890,175.600393>}
      triangle {<-31.339323,-32.189785,174.875946>,<-31.086065,-30.916523,174.875943>,<-29.378309,-31.623890,175.600393>}
      triangle {<-29.378309,-32.755680,175.600393>,<-31.086065,-33.463047,174.875946>,<-29.490873,-32.189785,175.600393>}
      triangle {<-31.086065,-33.463047,174.875946>,<-31.339323,-32.189785,174.875946>,<-29.490873,-32.189785,175.600393>}
      triangle {<-29.057760,-33.235424,175.600393>,<-30.364805,-34.542469,174.875947>,<-29.378309,-32.755680,175.600393>}
      triangle {<-30.364805,-34.542469,174.875947>,<-31.086065,-33.463047,174.875946>,<-29.378309,-32.755680,175.600393>}
      triangle {<-28.578016,-33.555981,175.600393>,<-29.285375,-35.263714,174.875943>,<-29.057760,-33.235424,175.600393>}
      triangle {<-29.285375,-35.263714,174.875943>,<-30.364805,-34.542469,174.875947>,<-29.057760,-33.235424,175.600393>}
      triangle {<-28.012121,-33.668530,175.600393>,<-28.012121,-35.516972,174.875943>,<-28.578016,-33.555981,175.600393>}
      triangle {<-28.012121,-35.516972,174.875943>,<-29.285375,-35.263714,174.875943>,<-28.578016,-33.555981,175.600393>}
      triangle {<-27.446226,-33.555981,175.600393>,<-26.738859,-35.263714,174.875943>,<-28.012121,-33.668530,175.600393>}
      triangle {<-26.738859,-35.263714,174.875943>,<-28.012121,-35.516972,174.875943>,<-28.012121,-33.668530,175.600393>}
      triangle {<-26.966489,-33.235424,175.600393>,<-25.659437,-34.542469,174.875947>,<-27.446226,-33.555981,175.600393>}
      triangle {<-25.659437,-34.542469,174.875947>,<-26.738859,-35.263714,174.875943>,<-27.446226,-33.555981,175.600393>}
      triangle {<-26.645933,-32.755680,175.600393>,<-24.938192,-33.463047,174.875946>,<-26.966489,-33.235424,175.600393>}
      triangle {<-24.938192,-33.463047,174.875946>,<-25.659437,-34.542469,174.875947>,<-26.966489,-33.235424,175.600393>}
      triangle {<-26.533369,-32.189785,175.600393>,<-24.684934,-32.189785,174.875946>,<-26.645933,-32.755680,175.600393>}
      triangle {<-24.684934,-32.189785,174.875946>,<-24.938192,-33.463047,174.875946>,<-26.645933,-32.755680,175.600393>}
      triangle {<-26.645933,-31.623890,175.600393>,<-26.533369,-32.189785,175.600393>,<-26.395811,-32.189785,175.600393>}
      triangle {<-26.518842,-31.571247,175.600400>,<-26.645933,-31.623890,175.600393>,<-26.395811,-32.189785,175.600393>}
      triangle {<-26.966489,-31.144146,175.600393>,<-26.645933,-31.623890,175.600393>,<-26.518842,-31.571247,175.600400>}
      triangle {<-26.869215,-31.046886,175.600393>,<-26.966489,-31.144146,175.600393>,<-26.518842,-31.571247,175.600400>}
      triangle {<-27.446226,-30.823582,175.600393>,<-26.966489,-31.144146,175.600393>,<-26.869215,-31.046886,175.600393>}
      triangle {<-27.393583,-30.696514,175.600393>,<-27.446226,-30.823582,175.600393>,<-26.869215,-31.046886,175.600393>}
      triangle {<-28.012121,-30.711033,175.600393>,<-27.446226,-30.823582,175.600393>,<-27.393583,-30.696514,175.600393>}
      triangle {<-28.012121,-30.573475,175.600393>,<-28.012121,-30.711033,175.600393>,<-27.393583,-30.696514,175.600393>}
      triangle {<-28.578016,-30.823582,175.600393>,<-28.012121,-30.711033,175.600393>,<-28.012121,-30.573475,175.600393>}
      triangle {<-28.630666,-30.696514,175.600393>,<-28.578016,-30.823582,175.600393>,<-28.012121,-30.573475,175.600393>}
      triangle {<-29.057760,-31.144146,175.600393>,<-28.578016,-30.823582,175.600393>,<-28.630666,-30.696514,175.600393>}
      triangle {<-29.155019,-31.046886,175.600393>,<-29.057760,-31.144146,175.600393>,<-28.630666,-30.696514,175.600393>}
      triangle {<-29.378309,-31.623890,175.600393>,<-29.057760,-31.144146,175.600393>,<-29.155019,-31.046886,175.600393>}
      triangle {<-29.505392,-31.571247,175.600400>,<-29.378309,-31.623890,175.600393>,<-29.155019,-31.046886,175.600393>}
      triangle {<-29.490873,-32.189785,175.600393>,<-29.378309,-31.623890,175.600393>,<-29.505392,-31.571247,175.600400>}
      triangle {<-29.628438,-32.189785,175.600393>,<-29.490873,-32.189785,175.600393>,<-29.505392,-31.571247,175.600400>}
      triangle {<-29.378309,-32.755680,175.600393>,<-29.490873,-32.189785,175.600393>,<-29.628438,-32.189785,175.600393>}
      triangle {<-29.505392,-32.808323,175.600393>,<-29.378309,-32.755680,175.600393>,<-29.628438,-32.189785,175.600393>}
      triangle {<-29.057760,-33.235424,175.600393>,<-29.378309,-32.755680,175.600393>,<-29.505392,-32.808323,175.600393>}
      triangle {<-29.155019,-33.332684,175.600393>,<-29.057760,-33.235424,175.600393>,<-29.505392,-32.808323,175.600393>}
      triangle {<-28.578016,-33.555981,175.600393>,<-29.057760,-33.235424,175.600393>,<-29.155019,-33.332684,175.600393>}
      triangle {<-28.630666,-33.683056,175.600393>,<-28.578016,-33.555981,175.600393>,<-29.155019,-33.332684,175.600393>}
      triangle {<-28.012121,-33.668530,175.600393>,<-28.578016,-33.555981,175.600393>,<-28.630666,-33.683056,175.600393>}
      triangle {<-28.012121,-33.806095,175.600393>,<-28.012121,-33.668530,175.600393>,<-28.630666,-33.683056,175.600393>}
      triangle {<-27.446226,-33.555981,175.600393>,<-28.012121,-33.668530,175.600393>,<-28.012121,-33.806095,175.600393>}
      triangle {<-27.393583,-33.683056,175.600393>,<-27.446226,-33.555981,175.600393>,<-28.012121,-33.806095,175.600393>}
      triangle {<-26.966489,-33.235424,175.600393>,<-27.446226,-33.555981,175.600393>,<-27.393583,-33.683056,175.600393>}
      triangle {<-26.869215,-33.332684,175.600393>,<-26.966489,-33.235424,175.600393>,<-27.393583,-33.683056,175.600393>}
      triangle {<-26.645933,-32.755680,175.600393>,<-26.966489,-33.235424,175.600393>,<-26.869215,-33.332684,175.600393>}
      triangle {<-26.518842,-32.808323,175.600393>,<-26.645933,-32.755680,175.600393>,<-26.869215,-33.332684,175.600393>}
      triangle {<-26.533369,-32.189785,175.600393>,<-26.645933,-32.755680,175.600393>,<-26.518842,-32.808323,175.600393>}
      triangle {<-26.395811,-32.189785,175.600393>,<-26.533369,-32.189785,175.600393>,<-26.518842,-32.808323,175.600393>}
      triangle {<-24.938192,-30.916523,174.875943>,<-24.652242,-30.798077,174.875946>,<-24.375425,-32.189785,174.875946>}
      triangle {<-24.684934,-32.189785,174.875946>,<-24.938192,-30.916523,174.875943>,<-24.375425,-32.189785,174.875946>}
      triangle {<-25.659437,-29.837101,174.875943>,<-25.440595,-29.618244,174.875943>,<-24.652242,-30.798077,174.875946>}
      triangle {<-24.938192,-30.916523,174.875943>,<-25.659437,-29.837101,174.875943>,<-24.652242,-30.798077,174.875946>}
      triangle {<-26.738859,-29.115864,174.875946>,<-26.620428,-28.829914,174.875946>,<-25.440595,-29.618244,174.875943>}
      triangle {<-25.659437,-29.837101,174.875943>,<-26.738859,-29.115864,174.875946>,<-25.440595,-29.618244,174.875943>}
      triangle {<-28.012121,-28.862598,174.875946>,<-28.012121,-28.553089,174.875942>,<-26.620428,-28.829914,174.875946>}
      triangle {<-26.738859,-29.115864,174.875946>,<-28.012121,-28.862598,174.875946>,<-26.620428,-28.829914,174.875946>}
      triangle {<-29.285375,-29.115864,174.875946>,<-29.403829,-28.829914,174.875946>,<-28.012121,-28.553089,174.875942>}
      triangle {<-28.012121,-28.862598,174.875946>,<-29.285375,-29.115864,174.875946>,<-28.012121,-28.553089,174.875942>}
      triangle {<-30.364805,-29.837101,174.875943>,<-30.583662,-29.618244,174.875943>,<-29.403829,-28.829914,174.875946>}
      triangle {<-29.285375,-29.115864,174.875946>,<-30.364805,-29.837101,174.875943>,<-29.403829,-28.829914,174.875946>}
      triangle {<-31.086065,-30.916523,174.875943>,<-31.372007,-30.798077,174.875946>,<-30.583662,-29.618244,174.875943>}
      triangle {<-30.364805,-29.837101,174.875943>,<-31.086065,-30.916523,174.875943>,<-30.583662,-29.618244,174.875943>}
      triangle {<-31.339323,-32.189785,174.875946>,<-31.648824,-32.189785,174.875946>,<-31.372007,-30.798077,174.875946>}
      triangle {<-31.086065,-30.916523,174.875943>,<-31.339323,-32.189785,174.875946>,<-31.372007,-30.798077,174.875946>}
      triangle {<-31.086065,-33.463047,174.875946>,<-31.372007,-33.581509,174.875946>,<-31.648824,-32.189785,174.875946>}
      triangle {<-31.339323,-32.189785,174.875946>,<-31.086065,-33.463047,174.875946>,<-31.648824,-32.189785,174.875946>}
      triangle {<-30.364805,-34.542469,174.875947>,<-30.583662,-34.761311,174.875947>,<-31.372007,-33.581509,174.875946>}
      triangle {<-31.086065,-33.463047,174.875946>,<-30.364805,-34.542469,174.875947>,<-31.372007,-33.581509,174.875946>}
      triangle {<-29.285375,-35.263714,174.875943>,<-29.403829,-35.549656,174.875943>,<-30.583662,-34.761311,174.875947>}
      triangle {<-30.364805,-34.542469,174.875947>,<-29.285375,-35.263714,174.875943>,<-30.583662,-34.761311,174.875947>}
      triangle {<-28.012121,-35.516972,174.875943>,<-28.012121,-35.826473,174.875947>,<-29.403829,-35.549656,174.875943>}
      triangle {<-29.285375,-35.263714,174.875943>,<-28.012121,-35.516972,174.875943>,<-29.403829,-35.549656,174.875943>}
      triangle {<-26.738859,-35.263714,174.875943>,<-26.620428,-35.549656,174.875943>,<-28.012121,-35.826473,174.875947>}
      triangle {<-28.012121,-35.516972,174.875943>,<-26.738859,-35.263714,174.875943>,<-28.012121,-35.826473,174.875947>}
      triangle {<-25.659437,-34.542469,174.875947>,<-25.440595,-34.761311,174.875947>,<-26.620428,-35.549656,174.875943>}
      triangle {<-26.738859,-35.263714,174.875943>,<-25.659437,-34.542469,174.875947>,<-26.620428,-35.549656,174.875943>}
      triangle {<-24.938192,-33.463047,174.875946>,<-24.652242,-33.581478,174.875946>,<-25.440595,-34.761311,174.875947>}
      triangle {<-25.659437,-34.542469,174.875947>,<-24.938192,-33.463047,174.875946>,<-25.440595,-34.761311,174.875947>}
      triangle {<-24.684934,-32.189785,174.875946>,<-24.375425,-32.189785,174.875946>,<-24.652242,-33.581478,174.875946>}
      triangle {<-24.938192,-33.463047,174.875946>,<-24.684934,-32.189785,174.875946>,<-24.652242,-33.581478,174.875946>}
      texture{_Duse04}
    }
    //_Duse05
    mesh{
      triangle {<-24.862455,-13.864025,170.550524>,<-25.111753,-12.610722,170.550524>,<-24.355314,-12.297390,176.300127>}
      triangle {<-24.862455,-13.864025,170.550524>,<-24.355314,-12.297390,176.300127>,<-24.043699,-13.864025,176.300128>}
      triangle {<-25.111753,-12.610722,170.550524>,<-25.821691,-11.548222,170.550524>,<-25.242742,-10.969265,176.300127>}
      triangle {<-25.111753,-12.610722,170.550524>,<-25.242742,-10.969265,176.300127>,<-24.355314,-12.297390,176.300127>}
      triangle {<-25.821691,-11.548222,170.550524>,<-26.884191,-10.838276,170.550523>,<-26.570867,-10.081844,176.300127>}
      triangle {<-25.821691,-11.548222,170.550524>,<-26.570867,-10.081844,176.300127>,<-25.242742,-10.969265,176.300127>}
      triangle {<-26.884191,-10.838276,170.550523>,<-28.137502,-10.588985,170.550523>,<-28.137502,-9.770222,176.300127>}
      triangle {<-26.884191,-10.838276,170.550523>,<-28.137502,-9.770222,176.300127>,<-26.570867,-10.081844,176.300127>}
      triangle {<-28.137502,-10.588985,170.550523>,<-29.390806,-10.838276,170.550523>,<-29.704130,-10.081844,176.300127>}
      triangle {<-28.137502,-10.588985,170.550523>,<-29.704130,-10.081844,176.300127>,<-28.137502,-9.770222,176.300127>}
      triangle {<-29.390806,-10.838276,170.550523>,<-30.453306,-11.548222,170.550524>,<-31.032255,-10.969265,176.300127>}
      triangle {<-29.390806,-10.838276,170.550523>,<-31.032255,-10.969265,176.300127>,<-29.704130,-10.081844,176.300127>}
      triangle {<-30.453306,-11.548222,170.550524>,<-31.163244,-12.610722,170.550524>,<-31.919683,-12.297390,176.300127>}
      triangle {<-30.453306,-11.548222,170.550524>,<-31.919683,-12.297390,176.300127>,<-31.032255,-10.969265,176.300127>}
      triangle {<-31.163244,-12.610722,170.550524>,<-31.412542,-13.864025,170.550524>,<-32.231306,-13.864025,176.300128>}
      triangle {<-31.163244,-12.610722,170.550524>,<-32.231306,-13.864025,176.300128>,<-31.919683,-12.297390,176.300127>}
      triangle {<-31.412542,-13.864025,170.550524>,<-31.163244,-15.117329,170.550524>,<-31.919683,-15.430660,176.300128>}
      triangle {<-31.412542,-13.864025,170.550524>,<-31.919683,-15.430660,176.300128>,<-32.231306,-13.864025,176.300128>}
      triangle {<-31.163244,-15.117329,170.550524>,<-30.453306,-16.179829,170.550524>,<-31.032255,-16.758778,176.300128>}
      triangle {<-31.163244,-15.117329,170.550524>,<-31.032255,-16.758778,176.300128>,<-31.919683,-15.430660,176.300128>}
      triangle {<-30.453306,-16.179829,170.550524>,<-29.390806,-16.889774,170.550524>,<-29.704130,-17.646206,176.300128>}
      triangle {<-30.453306,-16.179829,170.550524>,<-29.704130,-17.646206,176.300128>,<-31.032255,-16.758778,176.300128>}
      triangle {<-29.390806,-16.889774,170.550524>,<-28.137502,-17.139065,170.550524>,<-28.137502,-17.957829,176.300128>}
      triangle {<-29.390806,-16.889774,170.550524>,<-28.137502,-17.957829,176.300128>,<-29.704130,-17.646206,176.300128>}
      triangle {<-28.137502,-17.139065,170.550524>,<-26.884191,-16.889774,170.550524>,<-26.570867,-17.646206,176.300128>}
      triangle {<-28.137502,-17.139065,170.550524>,<-26.570867,-17.646206,176.300128>,<-28.137502,-17.957829,176.300128>}
      triangle {<-26.884191,-16.889774,170.550524>,<-25.821691,-16.179829,170.550524>,<-25.242742,-16.758778,176.300128>}
      triangle {<-26.884191,-16.889774,170.550524>,<-25.242742,-16.758778,176.300128>,<-26.570867,-17.646206,176.300128>}
      triangle {<-25.821691,-16.179829,170.550524>,<-25.111753,-15.117329,170.550524>,<-24.355314,-15.430653,176.300128>}
      triangle {<-25.821691,-16.179829,170.550524>,<-24.355314,-15.430653,176.300128>,<-25.242742,-16.758778,176.300128>}
      triangle {<-25.111753,-15.117329,170.550524>,<-24.862455,-13.864025,170.550524>,<-24.043699,-13.864025,176.300128>}
      triangle {<-25.111753,-15.117329,170.550524>,<-24.043699,-13.864025,176.300128>,<-24.355314,-15.430653,176.300128>}
      triangle {<-25.141187,-13.864025,170.550524>,<-24.677206,-12.430721,176.300127>,<-25.369268,-12.717388,170.550524>}
      triangle {<-25.141187,-13.864025,170.550524>,<-24.392103,-13.864025,176.300128>,<-24.677206,-12.430721,176.300127>}
      triangle {<-25.369268,-12.717388,170.550524>,<-25.489103,-11.215626,176.300127>,<-26.018789,-11.745312,170.550524>}
      triangle {<-25.369268,-12.717388,170.550524>,<-24.677206,-12.430721,176.300127>,<-25.489103,-11.215626,176.300127>}
      triangle {<-26.018789,-11.745312,170.550524>,<-26.704198,-10.403736,176.300127>,<-26.990858,-11.095783,170.550523>}
      triangle {<-26.018789,-11.745312,170.550524>,<-25.489103,-11.215626,176.300127>,<-26.704198,-10.403736,176.300127>}
      triangle {<-26.990858,-11.095783,170.550523>,<-28.137502,-10.118633,176.300127>,<-28.137502,-10.867710,170.550523>}
      triangle {<-26.990858,-11.095783,170.550523>,<-26.704198,-10.403736,176.300127>,<-28.137502,-10.118633,176.300127>}
      triangle {<-28.137502,-10.867710,170.550523>,<-29.570798,-10.403736,176.300127>,<-29.284139,-11.095783,170.550523>}
      triangle {<-28.137502,-10.867710,170.550523>,<-28.137502,-10.118633,176.300127>,<-29.570798,-10.403736,176.300127>}
      triangle {<-29.284139,-11.095783,170.550523>,<-30.785894,-11.215626,176.300127>,<-30.256216,-11.745312,170.550524>}
      triangle {<-29.284139,-11.095783,170.550523>,<-29.570798,-10.403736,176.300127>,<-30.785894,-11.215626,176.300127>}
      triangle {<-30.256216,-11.745312,170.550524>,<-31.597799,-12.430721,176.300127>,<-30.905729,-12.717388,170.550524>}
      triangle {<-30.256216,-11.745312,170.550524>,<-30.785894,-11.215626,176.300127>,<-31.597799,-12.430721,176.300127>}
      triangle {<-30.905729,-12.717388,170.550524>,<-31.882894,-13.864025,176.300128>,<-31.133817,-13.864025,170.550524>}
      triangle {<-30.905729,-12.717388,170.550524>,<-31.597799,-12.430721,176.300127>,<-31.882894,-13.864025,176.300128>}
      triangle {<-31.133817,-13.864025,170.550524>,<-31.597799,-15.297321,176.300128>,<-30.905729,-15.010662,170.550524>}
      triangle {<-31.133817,-13.864025,170.550524>,<-31.882894,-13.864025,176.300128>,<-31.597799,-15.297321,176.300128>}
      triangle {<-30.905729,-15.010662,170.550524>,<-30.785894,-16.512417,176.300128>,<-30.256216,-15.982738,170.550524>}
      triangle {<-30.905729,-15.010662,170.550524>,<-31.597799,-15.297321,176.300128>,<-30.785894,-16.512417,176.300128>}
      triangle {<-30.256216,-15.982738,170.550524>,<-29.570798,-17.324314,176.300128>,<-29.284139,-16.632259,170.550524>}
      triangle {<-30.256216,-15.982738,170.550524>,<-30.785894,-16.512417,176.300128>,<-29.570798,-17.324314,176.300128>}
      triangle {<-29.284139,-16.632259,170.550524>,<-28.137502,-17.609417,176.300128>,<-28.137502,-16.860340,170.550524>}
      triangle {<-29.284139,-16.632259,170.550524>,<-29.570798,-17.324314,176.300128>,<-28.137502,-17.609417,176.300128>}
      triangle {<-28.137502,-16.860340,170.550524>,<-26.704198,-17.324314,176.300128>,<-26.990858,-16.632259,170.550524>}
      triangle {<-28.137502,-16.860340,170.550524>,<-28.137502,-17.609417,176.300128>,<-26.704198,-17.324314,176.300128>}
      triangle {<-26.990858,-16.632259,170.550524>,<-25.489103,-16.512417,176.300128>,<-26.018789,-15.982738,170.550524>}
      triangle {<-26.990858,-16.632259,170.550524>,<-26.704198,-17.324314,176.300128>,<-25.489103,-16.512417,176.300128>}
      triangle {<-26.018789,-15.982738,170.550524>,<-24.677206,-15.297321,176.300128>,<-25.369260,-15.010662,170.550524>}
      triangle {<-26.018789,-15.982738,170.550524>,<-25.489103,-16.512417,176.300128>,<-24.677206,-15.297321,176.300128>}
      triangle {<-25.369260,-15.010662,170.550524>,<-24.392103,-13.864025,176.300128>,<-25.141187,-13.864025,170.550524>}
      triangle {<-25.369260,-15.010662,170.550524>,<-24.677206,-15.297321,176.300128>,<-24.392103,-13.864025,176.300128>}
      triangle {<-24.862455,-13.864025,170.550524>,<-25.141187,-13.864025,170.550524>,<-25.369268,-12.717388,170.550524>}
      triangle {<-24.862455,-13.864025,170.550524>,<-25.369268,-12.717388,170.550524>,<-25.111753,-12.610722,170.550524>}
      triangle {<-25.111753,-12.610722,170.550524>,<-25.369268,-12.717388,170.550524>,<-26.018789,-11.745312,170.550524>}
      triangle {<-25.111753,-12.610722,170.550524>,<-26.018789,-11.745312,170.550524>,<-25.821691,-11.548222,170.550524>}
      triangle {<-25.821691,-11.548222,170.550524>,<-26.018789,-11.745312,170.550524>,<-26.990858,-11.095783,170.550523>}
      triangle {<-25.821691,-11.548222,170.550524>,<-26.990858,-11.095783,170.550523>,<-26.884191,-10.838276,170.550523>}
      triangle {<-26.884191,-10.838276,170.550523>,<-26.990858,-11.095783,170.550523>,<-28.137502,-10.867710,170.550523>}
      triangle {<-26.884191,-10.838276,170.550523>,<-28.137502,-10.867710,170.550523>,<-28.137502,-10.588985,170.550523>}
      triangle {<-28.137502,-10.588985,170.550523>,<-28.137502,-10.867710,170.550523>,<-29.284139,-11.095783,170.550523>}
      triangle {<-28.137502,-10.588985,170.550523>,<-29.284139,-11.095783,170.550523>,<-29.390806,-10.838276,170.550523>}
      triangle {<-29.390806,-10.838276,170.550523>,<-29.284139,-11.095783,170.550523>,<-30.256216,-11.745312,170.550524>}
      triangle {<-29.390806,-10.838276,170.550523>,<-30.256216,-11.745312,170.550524>,<-30.453306,-11.548222,170.550524>}
      triangle {<-30.453306,-11.548222,170.550524>,<-30.256216,-11.745312,170.550524>,<-30.905729,-12.717388,170.550524>}
      triangle {<-30.453306,-11.548222,170.550524>,<-30.905729,-12.717388,170.550524>,<-31.163244,-12.610722,170.550524>}
      triangle {<-31.163244,-12.610722,170.550524>,<-30.905729,-12.717388,170.550524>,<-31.133817,-13.864025,170.550524>}
      triangle {<-31.163244,-12.610722,170.550524>,<-31.133817,-13.864025,170.550524>,<-31.412542,-13.864025,170.550524>}
      triangle {<-31.412542,-13.864025,170.550524>,<-31.133817,-13.864025,170.550524>,<-30.905729,-15.010662,170.550524>}
      triangle {<-31.412542,-13.864025,170.550524>,<-30.905729,-15.010662,170.550524>,<-31.163244,-15.117329,170.550524>}
      triangle {<-31.163244,-15.117329,170.550524>,<-30.905729,-15.010662,170.550524>,<-30.256216,-15.982738,170.550524>}
      triangle {<-31.163244,-15.117329,170.550524>,<-30.256216,-15.982738,170.550524>,<-30.453306,-16.179829,170.550524>}
      triangle {<-30.453306,-16.179829,170.550524>,<-30.256216,-15.982738,170.550524>,<-29.284139,-16.632259,170.550524>}
      triangle {<-30.453306,-16.179829,170.550524>,<-29.284139,-16.632259,170.550524>,<-29.390806,-16.889774,170.550524>}
      triangle {<-29.390806,-16.889774,170.550524>,<-29.284139,-16.632259,170.550524>,<-28.137502,-16.860340,170.550524>}
      triangle {<-29.390806,-16.889774,170.550524>,<-28.137502,-16.860340,170.550524>,<-28.137502,-17.139065,170.550524>}
      triangle {<-28.137502,-17.139065,170.550524>,<-28.137502,-16.860340,170.550524>,<-26.990858,-16.632259,170.550524>}
      triangle {<-28.137502,-17.139065,170.550524>,<-26.990858,-16.632259,170.550524>,<-26.884191,-16.889774,170.550524>}
      triangle {<-26.884191,-16.889774,170.550524>,<-26.990858,-16.632259,170.550524>,<-26.018789,-15.982738,170.550524>}
      triangle {<-26.884191,-16.889774,170.550524>,<-26.018789,-15.982738,170.550524>,<-25.821691,-16.179829,170.550524>}
      triangle {<-25.821691,-16.179829,170.550524>,<-26.018789,-15.982738,170.550524>,<-25.369260,-15.010662,170.550524>}
      triangle {<-25.821691,-16.179829,170.550524>,<-25.369260,-15.010662,170.550524>,<-25.111753,-15.117329,170.550524>}
      triangle {<-25.111753,-15.117329,170.550524>,<-25.369260,-15.010662,170.550524>,<-25.141187,-13.864025,170.550524>}
      triangle {<-25.111753,-15.117329,170.550524>,<-25.141187,-13.864025,170.550524>,<-24.862455,-13.864025,170.550524>}
      triangle {<-24.043699,-13.864025,176.300128>,<-24.355314,-12.297390,176.300127>,<-24.677206,-12.430721,176.300127>}
      triangle {<-24.043699,-13.864025,176.300128>,<-24.677206,-12.430721,176.300127>,<-24.392103,-13.864025,176.300128>}
      triangle {<-24.355314,-12.297390,176.300127>,<-25.242742,-10.969265,176.300127>,<-25.489103,-11.215626,176.300127>}
      triangle {<-24.355314,-12.297390,176.300127>,<-25.489103,-11.215626,176.300127>,<-24.677206,-12.430721,176.300127>}
      triangle {<-25.242742,-10.969265,176.300127>,<-26.570867,-10.081844,176.300127>,<-26.704198,-10.403736,176.300127>}
      triangle {<-25.242742,-10.969265,176.300127>,<-26.704198,-10.403736,176.300127>,<-25.489103,-11.215626,176.300127>}
      triangle {<-26.570867,-10.081844,176.300127>,<-28.137502,-9.770222,176.300127>,<-28.137502,-10.118633,176.300127>}
      triangle {<-26.570867,-10.081844,176.300127>,<-28.137502,-10.118633,176.300127>,<-26.704198,-10.403736,176.300127>}
      triangle {<-28.137502,-9.770222,176.300127>,<-29.704130,-10.081844,176.300127>,<-29.570798,-10.403736,176.300127>}
      triangle {<-28.137502,-9.770222,176.300127>,<-29.570798,-10.403736,176.300127>,<-28.137502,-10.118633,176.300127>}
      triangle {<-29.704130,-10.081844,176.300127>,<-31.032255,-10.969265,176.300127>,<-30.785894,-11.215626,176.300127>}
      triangle {<-29.704130,-10.081844,176.300127>,<-30.785894,-11.215626,176.300127>,<-29.570798,-10.403736,176.300127>}
      triangle {<-31.032255,-10.969265,176.300127>,<-31.919683,-12.297390,176.300127>,<-31.597799,-12.430721,176.300127>}
      triangle {<-31.032255,-10.969265,176.300127>,<-31.597799,-12.430721,176.300127>,<-30.785894,-11.215626,176.300127>}
      triangle {<-31.919683,-12.297390,176.300127>,<-32.231306,-13.864025,176.300128>,<-31.882894,-13.864025,176.300128>}
      triangle {<-31.919683,-12.297390,176.300127>,<-31.882894,-13.864025,176.300128>,<-31.597799,-12.430721,176.300127>}
      triangle {<-32.231306,-13.864025,176.300128>,<-31.919683,-15.430660,176.300128>,<-31.597799,-15.297321,176.300128>}
      triangle {<-32.231306,-13.864025,176.300128>,<-31.597799,-15.297321,176.300128>,<-31.882894,-13.864025,176.300128>}
      triangle {<-31.919683,-15.430660,176.300128>,<-31.032255,-16.758778,176.300128>,<-30.785894,-16.512417,176.300128>}
      triangle {<-31.919683,-15.430660,176.300128>,<-30.785894,-16.512417,176.300128>,<-31.597799,-15.297321,176.300128>}
      triangle {<-31.032255,-16.758778,176.300128>,<-29.704130,-17.646206,176.300128>,<-29.570798,-17.324314,176.300128>}
      triangle {<-31.032255,-16.758778,176.300128>,<-29.570798,-17.324314,176.300128>,<-30.785894,-16.512417,176.300128>}
      triangle {<-29.704130,-17.646206,176.300128>,<-28.137502,-17.957829,176.300128>,<-28.137502,-17.609417,176.300128>}
      triangle {<-29.704130,-17.646206,176.300128>,<-28.137502,-17.609417,176.300128>,<-29.570798,-17.324314,176.300128>}
      triangle {<-28.137502,-17.957829,176.300128>,<-26.570867,-17.646206,176.300128>,<-26.704198,-17.324314,176.300128>}
      triangle {<-28.137502,-17.957829,176.300128>,<-26.704198,-17.324314,176.300128>,<-28.137502,-17.609417,176.300128>}
      triangle {<-26.570867,-17.646206,176.300128>,<-25.242742,-16.758778,176.300128>,<-25.489103,-16.512417,176.300128>}
      triangle {<-26.570867,-17.646206,176.300128>,<-25.489103,-16.512417,176.300128>,<-26.704198,-17.324314,176.300128>}
      triangle {<-25.242742,-16.758778,176.300128>,<-24.355314,-15.430653,176.300128>,<-24.677206,-15.297321,176.300128>}
      triangle {<-25.242742,-16.758778,176.300128>,<-24.677206,-15.297321,176.300128>,<-25.489103,-16.512417,176.300128>}
      triangle {<-24.355314,-15.430653,176.300128>,<-24.043699,-13.864025,176.300128>,<-24.392103,-13.864025,176.300128>}
      triangle {<-24.355314,-15.430653,176.300128>,<-24.392103,-13.864025,176.300128>,<-24.677206,-15.297321,176.300128>}
      triangle {<-24.777624,-12.472317,174.875943>,<-26.644224,-13.245487,175.600393>,<-26.521192,-13.864025,175.600393>}
      triangle {<-24.500806,-13.864025,174.875943>,<-24.777624,-12.472317,174.875943>,<-26.521192,-13.864025,175.600393>}
      triangle {<-25.565977,-11.292484,174.875943>,<-26.994596,-12.721127,175.600393>,<-26.644224,-13.245487,175.600393>}
      triangle {<-24.777624,-12.472317,174.875943>,<-25.565977,-11.292484,174.875943>,<-26.644224,-13.245487,175.600393>}
      triangle {<-26.745809,-10.504154,174.875943>,<-27.518964,-12.370754,175.600393>,<-26.994596,-12.721127,175.600393>}
      triangle {<-25.565977,-11.292484,174.875943>,<-26.745809,-10.504154,174.875943>,<-26.994596,-12.721127,175.600393>}
      triangle {<-28.137502,-10.227329,174.875942>,<-28.137502,-12.247715,175.600393>,<-27.518964,-12.370754,175.600393>}
      triangle {<-26.745809,-10.504154,174.875943>,<-28.137502,-10.227329,174.875942>,<-27.518964,-12.370754,175.600393>}
      triangle {<-29.529211,-10.504154,174.875943>,<-28.756048,-12.370754,175.600393>,<-28.137502,-12.247715,175.600393>}
      triangle {<-28.137502,-10.227329,174.875942>,<-29.529211,-10.504154,174.875943>,<-28.137502,-12.247715,175.600393>}
      triangle {<-30.709043,-11.292484,174.875943>,<-29.280401,-12.721127,175.600393>,<-28.756048,-12.370754,175.600393>}
      triangle {<-29.529211,-10.504154,174.875943>,<-30.709043,-11.292484,174.875943>,<-28.756048,-12.370754,175.600393>}
      triangle {<-31.497388,-12.472317,174.875943>,<-29.630773,-13.245487,175.600393>,<-29.280401,-12.721127,175.600393>}
      triangle {<-30.709043,-11.292484,174.875943>,<-31.497388,-12.472317,174.875943>,<-29.280401,-12.721127,175.600393>}
      triangle {<-31.774206,-13.864025,174.875943>,<-29.753820,-13.864025,175.600393>,<-29.630773,-13.245487,175.600393>}
      triangle {<-31.497388,-12.472317,174.875943>,<-31.774206,-13.864025,174.875943>,<-29.630773,-13.245487,175.600393>}
      triangle {<-31.497388,-15.255749,174.875943>,<-29.630773,-14.482563,175.600393>,<-29.753820,-13.864025,175.600393>}
      triangle {<-31.774206,-13.864025,174.875943>,<-31.497388,-15.255749,174.875943>,<-29.753820,-13.864025,175.600393>}
      triangle {<-30.709043,-16.435551,174.875943>,<-29.280401,-15.006924,175.600393>,<-29.630773,-14.482563,175.600393>}
      triangle {<-31.497388,-15.255749,174.875943>,<-30.709043,-16.435551,174.875943>,<-29.630773,-14.482563,175.600393>}
      triangle {<-29.529211,-17.223896,174.875943>,<-28.756048,-15.357296,175.600393>,<-29.280401,-15.006924,175.600393>}
      triangle {<-30.709043,-16.435551,174.875943>,<-29.529211,-17.223896,174.875943>,<-29.280401,-15.006924,175.600393>}
      triangle {<-28.137502,-17.500713,174.875943>,<-28.137502,-15.480335,175.600393>,<-28.756048,-15.357296,175.600393>}
      triangle {<-29.529211,-17.223896,174.875943>,<-28.137502,-17.500713,174.875943>,<-28.756048,-15.357296,175.600393>}
      triangle {<-26.745809,-17.223896,174.875943>,<-27.518964,-15.357296,175.600393>,<-28.137502,-15.480335,175.600393>}
      triangle {<-28.137502,-17.500713,174.875943>,<-26.745809,-17.223896,174.875943>,<-28.137502,-15.480335,175.600393>}
      triangle {<-25.565977,-16.435551,174.875943>,<-26.994596,-15.006924,175.600393>,<-27.518964,-15.357296,175.600393>}
      triangle {<-26.745809,-17.223896,174.875943>,<-25.565977,-16.435551,174.875943>,<-27.518964,-15.357296,175.600393>}
      triangle {<-24.777624,-15.255718,174.875943>,<-26.644224,-14.482563,175.600393>,<-26.994596,-15.006924,175.600393>}
      triangle {<-25.565977,-16.435551,174.875943>,<-24.777624,-15.255718,174.875943>,<-26.994596,-15.006924,175.600393>}
      triangle {<-24.500806,-13.864025,174.875943>,<-26.521192,-13.864025,175.600393>,<-26.644224,-14.482563,175.600393>}
      triangle {<-24.777624,-15.255718,174.875943>,<-24.500806,-13.864025,174.875943>,<-26.644224,-14.482563,175.600393>}
      triangle {<-26.771314,-13.298130,175.600393>,<-25.063573,-12.590763,174.875943>,<-26.658750,-13.864025,175.600393>}
      triangle {<-25.063573,-12.590763,174.875943>,<-24.810316,-13.864025,174.875943>,<-26.658750,-13.864025,175.600393>}
      triangle {<-27.091871,-12.818386,175.600393>,<-25.784818,-11.511341,174.875943>,<-26.771314,-13.298130,175.600393>}
      triangle {<-25.784818,-11.511341,174.875943>,<-25.063573,-12.590763,174.875943>,<-26.771314,-13.298130,175.600393>}
      triangle {<-27.571607,-12.497822,175.600393>,<-26.864240,-10.790104,174.875943>,<-27.091871,-12.818386,175.600393>}
      triangle {<-26.864240,-10.790104,174.875943>,<-25.784818,-11.511341,174.875943>,<-27.091871,-12.818386,175.600393>}
      triangle {<-28.137502,-12.385273,175.600393>,<-28.137502,-10.536839,174.875943>,<-27.571607,-12.497822,175.600393>}
      triangle {<-28.137502,-10.536839,174.875943>,<-26.864240,-10.790104,174.875943>,<-27.571607,-12.497822,175.600393>}
      triangle {<-28.703397,-12.497822,175.600393>,<-29.410757,-10.790104,174.875943>,<-28.137502,-12.385273,175.600393>}
      triangle {<-29.410757,-10.790104,174.875943>,<-28.137502,-10.536839,174.875943>,<-28.137502,-12.385273,175.600393>}
      triangle {<-29.183141,-12.818386,175.600393>,<-30.490186,-11.511341,174.875943>,<-28.703397,-12.497822,175.600393>}
      triangle {<-30.490186,-11.511341,174.875943>,<-29.410757,-10.790104,174.875943>,<-28.703397,-12.497822,175.600393>}
      triangle {<-29.503690,-13.298130,175.600393>,<-31.211446,-12.590763,174.875943>,<-29.183141,-12.818386,175.600393>}
      triangle {<-31.211446,-12.590763,174.875943>,<-30.490186,-11.511341,174.875943>,<-29.183141,-12.818386,175.600393>}
      triangle {<-29.616254,-13.864025,175.600393>,<-31.464704,-13.864025,174.875943>,<-29.503690,-13.298130,175.600393>}
      triangle {<-31.464704,-13.864025,174.875943>,<-31.211446,-12.590763,174.875943>,<-29.503690,-13.298130,175.600393>}
      triangle {<-29.503690,-14.429920,175.600393>,<-31.211446,-15.137287,174.875943>,<-29.616254,-13.864025,175.600393>}
      triangle {<-31.211446,-15.137287,174.875943>,<-31.464704,-13.864025,174.875943>,<-29.616254,-13.864025,175.600393>}
      triangle {<-29.183141,-14.909664,175.600393>,<-30.490186,-16.216709,174.875943>,<-29.503690,-14.429920,175.600393>}
      triangle {<-30.490186,-16.216709,174.875943>,<-31.211446,-15.137287,174.875943>,<-29.503690,-14.429920,175.600393>}
      triangle {<-28.703397,-15.230221,175.600393>,<-29.410757,-16.937954,174.875943>,<-29.183141,-14.909664,175.600393>}
      triangle {<-29.410757,-16.937954,174.875943>,<-30.490186,-16.216709,174.875943>,<-29.183141,-14.909664,175.600393>}
      triangle {<-28.137502,-15.342770,175.600393>,<-28.137502,-17.191212,174.875943>,<-28.703397,-15.230221,175.600393>}
      triangle {<-28.137502,-17.191212,174.875943>,<-29.410757,-16.937954,174.875943>,<-28.703397,-15.230221,175.600393>}
      triangle {<-27.571607,-15.230221,175.600393>,<-26.864240,-16.937954,174.875943>,<-28.137502,-15.342770,175.600393>}
      triangle {<-26.864240,-16.937954,174.875943>,<-28.137502,-17.191212,174.875943>,<-28.137502,-15.342770,175.600393>}
      triangle {<-27.091871,-14.909664,175.600393>,<-25.784818,-16.216709,174.875943>,<-27.571607,-15.230221,175.600393>}
      triangle {<-25.784818,-16.216709,174.875943>,<-26.864240,-16.937954,174.875943>,<-27.571607,-15.230221,175.600393>}
      triangle {<-26.771314,-14.429920,175.600393>,<-25.063573,-15.137287,174.875943>,<-27.091871,-14.909664,175.600393>}
      triangle {<-25.063573,-15.137287,174.875943>,<-25.784818,-16.216709,174.875943>,<-27.091871,-14.909664,175.600393>}
      triangle {<-26.658750,-13.864025,175.600393>,<-24.810316,-13.864025,174.875943>,<-26.771314,-14.429920,175.600393>}
      triangle {<-24.810316,-13.864025,174.875943>,<-25.063573,-15.137287,174.875943>,<-26.771314,-14.429920,175.600393>}
      triangle {<-26.771314,-13.298130,175.600393>,<-26.658750,-13.864025,175.600393>,<-26.521192,-13.864025,175.600393>}
      triangle {<-26.644224,-13.245487,175.600393>,<-26.771314,-13.298130,175.600393>,<-26.521192,-13.864025,175.600393>}
      triangle {<-27.091871,-12.818386,175.600393>,<-26.771314,-13.298130,175.600393>,<-26.644224,-13.245487,175.600393>}
      triangle {<-26.994596,-12.721127,175.600393>,<-27.091871,-12.818386,175.600393>,<-26.644224,-13.245487,175.600393>}
      triangle {<-27.571607,-12.497822,175.600393>,<-27.091871,-12.818386,175.600393>,<-26.994596,-12.721127,175.600393>}
      triangle {<-27.518964,-12.370754,175.600393>,<-27.571607,-12.497822,175.600393>,<-26.994596,-12.721127,175.600393>}
      triangle {<-28.137502,-12.385273,175.600393>,<-27.571607,-12.497822,175.600393>,<-27.518964,-12.370754,175.600393>}
      triangle {<-28.137502,-12.247715,175.600393>,<-28.137502,-12.385273,175.600393>,<-27.518964,-12.370754,175.600393>}
      triangle {<-28.703397,-12.497822,175.600393>,<-28.137502,-12.385273,175.600393>,<-28.137502,-12.247715,175.600393>}
      triangle {<-28.756048,-12.370754,175.600393>,<-28.703397,-12.497822,175.600393>,<-28.137502,-12.247715,175.600393>}
      triangle {<-29.183141,-12.818386,175.600393>,<-28.703397,-12.497822,175.600393>,<-28.756048,-12.370754,175.600393>}
      triangle {<-29.280401,-12.721127,175.600393>,<-29.183141,-12.818386,175.600393>,<-28.756048,-12.370754,175.600393>}
      triangle {<-29.503690,-13.298130,175.600393>,<-29.183141,-12.818386,175.600393>,<-29.280401,-12.721127,175.600393>}
      triangle {<-29.630773,-13.245487,175.600393>,<-29.503690,-13.298130,175.600393>,<-29.280401,-12.721127,175.600393>}
      triangle {<-29.616254,-13.864025,175.600393>,<-29.503690,-13.298130,175.600393>,<-29.630773,-13.245487,175.600393>}
      triangle {<-29.753820,-13.864025,175.600393>,<-29.616254,-13.864025,175.600393>,<-29.630773,-13.245487,175.600393>}
      triangle {<-29.503690,-14.429920,175.600393>,<-29.616254,-13.864025,175.600393>,<-29.753820,-13.864025,175.600393>}
      triangle {<-29.630773,-14.482563,175.600393>,<-29.503690,-14.429920,175.600393>,<-29.753820,-13.864025,175.600393>}
      triangle {<-29.183141,-14.909664,175.600393>,<-29.503690,-14.429920,175.600393>,<-29.630773,-14.482563,175.600393>}
      triangle {<-29.280401,-15.006924,175.600393>,<-29.183141,-14.909664,175.600393>,<-29.630773,-14.482563,175.600393>}
      triangle {<-28.703397,-15.230221,175.600393>,<-29.183141,-14.909664,175.600393>,<-29.280401,-15.006924,175.600393>}
      triangle {<-28.756048,-15.357296,175.600393>,<-28.703397,-15.230221,175.600393>,<-29.280401,-15.006924,175.600393>}
      triangle {<-28.137502,-15.342770,175.600393>,<-28.703397,-15.230221,175.600393>,<-28.756048,-15.357296,175.600393>}
      triangle {<-28.137502,-15.480335,175.600393>,<-28.137502,-15.342770,175.600393>,<-28.756048,-15.357296,175.600393>}
      triangle {<-27.571607,-15.230221,175.600393>,<-28.137502,-15.342770,175.600393>,<-28.137502,-15.480335,175.600393>}
      triangle {<-27.518964,-15.357296,175.600393>,<-27.571607,-15.230221,175.600393>,<-28.137502,-15.480335,175.600393>}
      triangle {<-27.091871,-14.909664,175.600393>,<-27.571607,-15.230221,175.600393>,<-27.518964,-15.357296,175.600393>}
      triangle {<-26.994596,-15.006924,175.600393>,<-27.091871,-14.909664,175.600393>,<-27.518964,-15.357296,175.600393>}
      triangle {<-26.771314,-14.429920,175.600393>,<-27.091871,-14.909664,175.600393>,<-26.994596,-15.006924,175.600393>}
      triangle {<-26.644224,-14.482563,175.600393>,<-26.771314,-14.429920,175.600393>,<-26.994596,-15.006924,175.600393>}
      triangle {<-26.658750,-13.864025,175.600393>,<-26.771314,-14.429920,175.600393>,<-26.644224,-14.482563,175.600393>}
      triangle {<-26.521192,-13.864025,175.600393>,<-26.658750,-13.864025,175.600393>,<-26.644224,-14.482563,175.600393>}
      triangle {<-25.063573,-12.590763,174.875943>,<-24.777624,-12.472317,174.875943>,<-24.500806,-13.864025,174.875943>}
      triangle {<-24.810316,-13.864025,174.875943>,<-25.063573,-12.590763,174.875943>,<-24.500806,-13.864025,174.875943>}
      triangle {<-25.784818,-11.511341,174.875943>,<-25.565977,-11.292484,174.875943>,<-24.777624,-12.472317,174.875943>}
      triangle {<-25.063573,-12.590763,174.875943>,<-25.784818,-11.511341,174.875943>,<-24.777624,-12.472317,174.875943>}
      triangle {<-26.864240,-10.790104,174.875943>,<-26.745809,-10.504154,174.875943>,<-25.565977,-11.292484,174.875943>}
      triangle {<-25.784818,-11.511341,174.875943>,<-26.864240,-10.790104,174.875943>,<-25.565977,-11.292484,174.875943>}
      triangle {<-28.137502,-10.536839,174.875943>,<-28.137502,-10.227329,174.875942>,<-26.745809,-10.504154,174.875943>}
      triangle {<-26.864240,-10.790104,174.875943>,<-28.137502,-10.536839,174.875943>,<-26.745809,-10.504154,174.875943>}
      triangle {<-29.410757,-10.790104,174.875943>,<-29.529211,-10.504154,174.875943>,<-28.137502,-10.227329,174.875942>}
      triangle {<-28.137502,-10.536839,174.875943>,<-29.410757,-10.790104,174.875943>,<-28.137502,-10.227329,174.875942>}
      triangle {<-30.490186,-11.511341,174.875943>,<-30.709043,-11.292484,174.875943>,<-29.529211,-10.504154,174.875943>}
      triangle {<-29.410757,-10.790104,174.875943>,<-30.490186,-11.511341,174.875943>,<-29.529211,-10.504154,174.875943>}
      triangle {<-31.211446,-12.590763,174.875943>,<-31.497388,-12.472317,174.875943>,<-30.709043,-11.292484,174.875943>}
      triangle {<-30.490186,-11.511341,174.875943>,<-31.211446,-12.590763,174.875943>,<-30.709043,-11.292484,174.875943>}
      triangle {<-31.464704,-13.864025,174.875943>,<-31.774206,-13.864025,174.875943>,<-31.497388,-12.472317,174.875943>}
      triangle {<-31.211446,-12.590763,174.875943>,<-31.464704,-13.864025,174.875943>,<-31.497388,-12.472317,174.875943>}
      triangle {<-31.211446,-15.137287,174.875943>,<-31.497388,-15.255749,174.875943>,<-31.774206,-13.864025,174.875943>}
      triangle {<-31.464704,-13.864025,174.875943>,<-31.211446,-15.137287,174.875943>,<-31.774206,-13.864025,174.875943>}
      triangle {<-30.490186,-16.216709,174.875943>,<-30.709043,-16.435551,174.875943>,<-31.497388,-15.255749,174.875943>}
      triangle {<-31.211446,-15.137287,174.875943>,<-30.490186,-16.216709,174.875943>,<-31.497388,-15.255749,174.875943>}
      triangle {<-29.410757,-16.937954,174.875943>,<-29.529211,-17.223896,174.875943>,<-30.709043,-16.435551,174.875943>}
      triangle {<-30.490186,-16.216709,174.875943>,<-29.410757,-16.937954,174.875943>,<-30.709043,-16.435551,174.875943>}
      triangle {<-28.137502,-17.191212,174.875943>,<-28.137502,-17.500713,174.875943>,<-29.529211,-17.223896,174.875943>}
      triangle {<-29.410757,-16.937954,174.875943>,<-28.137502,-17.191212,174.875943>,<-29.529211,-17.223896,174.875943>}
      triangle {<-26.864240,-16.937954,174.875943>,<-26.745809,-17.223896,174.875943>,<-28.137502,-17.500713,174.875943>}
      triangle {<-28.137502,-17.191212,174.875943>,<-26.864240,-16.937954,174.875943>,<-28.137502,-17.500713,174.875943>}
      triangle {<-25.784818,-16.216709,174.875943>,<-25.565977,-16.435551,174.875943>,<-26.745809,-17.223896,174.875943>}
      triangle {<-26.864240,-16.937954,174.875943>,<-25.784818,-16.216709,174.875943>,<-26.745809,-17.223896,174.875943>}
      triangle {<-25.063573,-15.137287,174.875943>,<-24.777624,-15.255718,174.875943>,<-25.565977,-16.435551,174.875943>}
      triangle {<-25.784818,-16.216709,174.875943>,<-25.063573,-15.137287,174.875943>,<-25.565977,-16.435551,174.875943>}
      triangle {<-24.810316,-13.864025,174.875943>,<-24.500806,-13.864025,174.875943>,<-24.777624,-15.255718,174.875943>}
      triangle {<-25.063573,-15.137287,174.875943>,<-24.810316,-13.864025,174.875943>,<-24.777624,-15.255718,174.875943>}
      triangle {<-26.399236,-13.857006,174.520843>,<-26.630529,-12.993801,174.520843>,<-26.630529,-12.993801,176.301447>}
      triangle {<-26.399236,-13.857006,174.520843>,<-26.630529,-12.993801,176.301447>,<-26.399236,-13.857006,176.301447>}
      triangle {<-26.630529,-12.993801,174.520843>,<-27.262441,-12.361889,174.520843>,<-27.262441,-12.361889,176.301447>}
      triangle {<-26.630529,-12.993801,174.520843>,<-27.262441,-12.361889,176.301447>,<-26.630529,-12.993801,176.301447>}
      triangle {<-27.262441,-12.361889,174.520843>,<-28.125646,-12.130596,174.520843>,<-28.125646,-12.130596,176.301447>}
      triangle {<-27.262441,-12.361889,174.520843>,<-28.125646,-12.130596,176.301447>,<-27.262441,-12.361889,176.301447>}
      triangle {<-28.125646,-12.130596,174.520843>,<-28.988851,-12.361889,174.520843>,<-28.988851,-12.361889,176.301447>}
      triangle {<-28.125646,-12.130596,174.520843>,<-28.988851,-12.361889,176.301447>,<-28.125646,-12.130596,176.301447>}
      triangle {<-28.988851,-12.361889,174.520843>,<-29.620763,-12.993801,174.520843>,<-29.620763,-12.993801,176.301447>}
      triangle {<-28.988851,-12.361889,174.520843>,<-29.620763,-12.993801,176.301447>,<-28.988851,-12.361889,176.301447>}
      triangle {<-29.620763,-12.993801,174.520843>,<-29.852056,-13.857006,174.520843>,<-29.852056,-13.857006,176.301447>}
      triangle {<-29.620763,-12.993801,174.520843>,<-29.852056,-13.857006,176.301447>,<-29.620763,-12.993801,176.301447>}
      triangle {<-29.852056,-13.857006,174.520843>,<-29.620763,-14.720211,174.520843>,<-29.620763,-14.720211,176.301447>}
      triangle {<-29.852056,-13.857006,174.520843>,<-29.620763,-14.720211,176.301447>,<-29.852056,-13.857006,176.301447>}
      triangle {<-29.620763,-14.720211,174.520843>,<-28.988851,-15.352123,174.520843>,<-28.988851,-15.352123,176.301448>}
      triangle {<-29.620763,-14.720211,174.520843>,<-28.988851,-15.352123,176.301448>,<-29.620763,-14.720211,176.301447>}
      triangle {<-28.988851,-15.352123,174.520843>,<-28.125646,-15.583416,174.520843>,<-28.125646,-15.583416,176.301448>}
      triangle {<-28.988851,-15.352123,174.520843>,<-28.125646,-15.583416,176.301448>,<-28.988851,-15.352123,176.301448>}
      triangle {<-28.125646,-15.583416,174.520843>,<-27.262441,-15.352123,174.520843>,<-27.262441,-15.352123,176.301448>}
      triangle {<-28.125646,-15.583416,174.520843>,<-27.262441,-15.352123,176.301448>,<-28.125646,-15.583416,176.301448>}
      triangle {<-27.262441,-15.352123,174.520843>,<-26.630529,-14.720211,174.520843>,<-26.630529,-14.720211,176.301447>}
      triangle {<-27.262441,-15.352123,174.520843>,<-26.630529,-14.720211,176.301447>,<-27.262441,-15.352123,176.301448>}
      triangle {<-26.630529,-14.720211,174.520843>,<-26.399236,-13.857006,174.520843>,<-26.399236,-13.857006,176.301447>}
      triangle {<-26.630529,-14.720211,174.520843>,<-26.399236,-13.857006,176.301447>,<-26.630529,-14.720211,176.301447>}
      triangle {<-26.829122,-13.857006,174.520843>,<-27.002828,-13.208744,176.301447>,<-27.002828,-13.208744,174.520843>}
      triangle {<-26.829122,-13.857006,174.520843>,<-26.829122,-13.857006,176.301447>,<-27.002828,-13.208744,176.301447>}
      triangle {<-27.002828,-13.208744,174.520843>,<-27.477384,-12.734188,176.301447>,<-27.477384,-12.734188,174.520843>}
      triangle {<-27.002828,-13.208744,174.520843>,<-27.002828,-13.208744,176.301447>,<-27.477384,-12.734188,176.301447>}
      triangle {<-27.477384,-12.734188,174.520843>,<-28.125646,-12.560482,176.301447>,<-28.125646,-12.560482,174.520843>}
      triangle {<-27.477384,-12.734188,174.520843>,<-27.477384,-12.734188,176.301447>,<-28.125646,-12.560482,176.301447>}
      triangle {<-28.125646,-12.560482,174.520843>,<-28.773908,-12.734188,176.301447>,<-28.773908,-12.734188,174.520843>}
      triangle {<-28.125646,-12.560482,174.520843>,<-28.125646,-12.560482,176.301447>,<-28.773908,-12.734188,176.301447>}
      triangle {<-28.773908,-12.734188,174.520843>,<-29.248464,-13.208744,176.301447>,<-29.248464,-13.208744,174.520843>}
      triangle {<-28.773908,-12.734188,174.520843>,<-28.773908,-12.734188,176.301447>,<-29.248464,-13.208744,176.301447>}
      triangle {<-29.248464,-13.208744,174.520843>,<-29.422170,-13.857006,176.301447>,<-29.422170,-13.857006,174.520843>}
      triangle {<-29.248464,-13.208744,174.520843>,<-29.248464,-13.208744,176.301447>,<-29.422170,-13.857006,176.301447>}
      triangle {<-29.422170,-13.857006,174.520843>,<-29.248464,-14.505268,176.301447>,<-29.248464,-14.505268,174.520843>}
      triangle {<-29.422170,-13.857006,174.520843>,<-29.422170,-13.857006,176.301447>,<-29.248464,-14.505268,176.301447>}
      triangle {<-29.248464,-14.505268,174.520843>,<-28.773908,-14.979824,176.301447>,<-28.773908,-14.979824,174.520843>}
      triangle {<-29.248464,-14.505268,174.520843>,<-29.248464,-14.505268,176.301447>,<-28.773908,-14.979824,176.301447>}
      triangle {<-28.773908,-14.979824,174.520843>,<-28.125646,-15.153530,176.301448>,<-28.125646,-15.153530,174.520843>}
      triangle {<-28.773908,-14.979824,174.520843>,<-28.773908,-14.979824,176.301447>,<-28.125646,-15.153530,176.301448>}
      triangle {<-28.125646,-15.153530,174.520843>,<-27.477384,-14.979824,176.301447>,<-27.477384,-14.979824,174.520843>}
      triangle {<-28.125646,-15.153530,174.520843>,<-28.125646,-15.153530,176.301448>,<-27.477384,-14.979824,176.301447>}
      triangle {<-27.477384,-14.979824,174.520843>,<-27.002828,-14.505268,176.301447>,<-27.002828,-14.505268,174.520843>}
      triangle {<-27.477384,-14.979824,174.520843>,<-27.477384,-14.979824,176.301447>,<-27.002828,-14.505268,176.301447>}
      triangle {<-27.002828,-14.505268,174.520843>,<-26.829122,-13.857006,176.301447>,<-26.829122,-13.857006,174.520843>}
      triangle {<-27.002828,-14.505268,174.520843>,<-27.002828,-14.505268,176.301447>,<-26.829122,-13.857006,176.301447>}
      triangle {<-26.399236,-13.857006,174.520843>,<-26.829122,-13.857006,174.520843>,<-27.002828,-13.208744,174.520843>}
      triangle {<-26.399236,-13.857006,174.520843>,<-27.002828,-13.208744,174.520843>,<-26.630529,-12.993801,174.520843>}
      triangle {<-26.630529,-12.993801,174.520843>,<-27.002828,-13.208744,174.520843>,<-27.477384,-12.734188,174.520843>}
      triangle {<-26.630529,-12.993801,174.520843>,<-27.477384,-12.734188,174.520843>,<-27.262441,-12.361889,174.520843>}
      triangle {<-27.262441,-12.361889,174.520843>,<-27.477384,-12.734188,174.520843>,<-28.125646,-12.560482,174.520843>}
      triangle {<-27.262441,-12.361889,174.520843>,<-28.125646,-12.560482,174.520843>,<-28.125646,-12.130596,174.520843>}
      triangle {<-28.125646,-12.130596,174.520843>,<-28.125646,-12.560482,174.520843>,<-28.773908,-12.734188,174.520843>}
      triangle {<-28.125646,-12.130596,174.520843>,<-28.773908,-12.734188,174.520843>,<-28.988851,-12.361889,174.520843>}
      triangle {<-28.988851,-12.361889,174.520843>,<-28.773908,-12.734188,174.520843>,<-29.248464,-13.208744,174.520843>}
      triangle {<-28.988851,-12.361889,174.520843>,<-29.248464,-13.208744,174.520843>,<-29.620763,-12.993801,174.520843>}
      triangle {<-29.620763,-12.993801,174.520843>,<-29.248464,-13.208744,174.520843>,<-29.422170,-13.857006,174.520843>}
      triangle {<-29.620763,-12.993801,174.520843>,<-29.422170,-13.857006,174.520843>,<-29.852056,-13.857006,174.520843>}
      triangle {<-29.852056,-13.857006,174.520843>,<-29.422170,-13.857006,174.520843>,<-29.248464,-14.505268,174.520843>}
      triangle {<-29.852056,-13.857006,174.520843>,<-29.248464,-14.505268,174.520843>,<-29.620763,-14.720211,174.520843>}
      triangle {<-29.620763,-14.720211,174.520843>,<-29.248464,-14.505268,174.520843>,<-28.773908,-14.979824,174.520843>}
      triangle {<-29.620763,-14.720211,174.520843>,<-28.773908,-14.979824,174.520843>,<-28.988851,-15.352123,174.520843>}
      triangle {<-28.988851,-15.352123,174.520843>,<-28.773908,-14.979824,174.520843>,<-28.125646,-15.153530,174.520843>}
      triangle {<-28.988851,-15.352123,174.520843>,<-28.125646,-15.153530,174.520843>,<-28.125646,-15.583416,174.520843>}
      triangle {<-28.125646,-15.583416,174.520843>,<-28.125646,-15.153530,174.520843>,<-27.477384,-14.979824,174.520843>}
      triangle {<-28.125646,-15.583416,174.520843>,<-27.477384,-14.979824,174.520843>,<-27.262441,-15.352123,174.520843>}
      triangle {<-27.262441,-15.352123,174.520843>,<-27.477384,-14.979824,174.520843>,<-27.002828,-14.505268,174.520843>}
      triangle {<-27.262441,-15.352123,174.520843>,<-27.002828,-14.505268,174.520843>,<-26.630529,-14.720211,174.520843>}
      triangle {<-26.630529,-14.720211,174.520843>,<-27.002828,-14.505268,174.520843>,<-26.829122,-13.857006,174.520843>}
      triangle {<-26.630529,-14.720211,174.520843>,<-26.829122,-13.857006,174.520843>,<-26.399236,-13.857006,174.520843>}
      triangle {<-26.399236,-13.857006,176.301447>,<-26.630529,-12.993801,176.301447>,<-27.002828,-13.208744,176.301447>}
      triangle {<-26.399236,-13.857006,176.301447>,<-27.002828,-13.208744,176.301447>,<-26.829122,-13.857006,176.301447>}
      triangle {<-26.630529,-12.993801,176.301447>,<-27.262441,-12.361889,176.301447>,<-27.477384,-12.734188,176.301447>}
      triangle {<-26.630529,-12.993801,176.301447>,<-27.477384,-12.734188,176.301447>,<-27.002828,-13.208744,176.301447>}
      triangle {<-27.262441,-12.361889,176.301447>,<-28.125646,-12.130596,176.301447>,<-28.125646,-12.560482,176.301447>}
      triangle {<-27.262441,-12.361889,176.301447>,<-28.125646,-12.560482,176.301447>,<-27.477384,-12.734188,176.301447>}
      triangle {<-28.125646,-12.130596,176.301447>,<-28.988851,-12.361889,176.301447>,<-28.773908,-12.734188,176.301447>}
      triangle {<-28.125646,-12.130596,176.301447>,<-28.773908,-12.734188,176.301447>,<-28.125646,-12.560482,176.301447>}
      triangle {<-28.988851,-12.361889,176.301447>,<-29.620763,-12.993801,176.301447>,<-29.248464,-13.208744,176.301447>}
      triangle {<-28.988851,-12.361889,176.301447>,<-29.248464,-13.208744,176.301447>,<-28.773908,-12.734188,176.301447>}
      triangle {<-29.620763,-12.993801,176.301447>,<-29.852056,-13.857006,176.301447>,<-29.422170,-13.857006,176.301447>}
      triangle {<-29.620763,-12.993801,176.301447>,<-29.422170,-13.857006,176.301447>,<-29.248464,-13.208744,176.301447>}
      triangle {<-29.852056,-13.857006,176.301447>,<-29.620763,-14.720211,176.301447>,<-29.248464,-14.505268,176.301447>}
      triangle {<-29.852056,-13.857006,176.301447>,<-29.248464,-14.505268,176.301447>,<-29.422170,-13.857006,176.301447>}
      triangle {<-29.620763,-14.720211,176.301447>,<-28.988851,-15.352123,176.301448>,<-28.773908,-14.979824,176.301447>}
      triangle {<-29.620763,-14.720211,176.301447>,<-28.773908,-14.979824,176.301447>,<-29.248464,-14.505268,176.301447>}
      triangle {<-28.988851,-15.352123,176.301448>,<-28.125646,-15.583416,176.301448>,<-28.125646,-15.153530,176.301448>}
      triangle {<-28.988851,-15.352123,176.301448>,<-28.125646,-15.153530,176.301448>,<-28.773908,-14.979824,176.301447>}
      triangle {<-28.125646,-15.583416,176.301448>,<-27.262441,-15.352123,176.301448>,<-27.477384,-14.979824,176.301447>}
      triangle {<-28.125646,-15.583416,176.301448>,<-27.477384,-14.979824,176.301447>,<-28.125646,-15.153530,176.301448>}
      triangle {<-27.262441,-15.352123,176.301448>,<-26.630529,-14.720211,176.301447>,<-27.002828,-14.505268,176.301447>}
      triangle {<-27.262441,-15.352123,176.301448>,<-27.002828,-14.505268,176.301447>,<-27.477384,-14.979824,176.301447>}
      triangle {<-26.630529,-14.720211,176.301447>,<-26.399236,-13.857006,176.301447>,<-26.829122,-13.857006,176.301447>}
      triangle {<-26.630529,-14.720211,176.301447>,<-26.829122,-13.857006,176.301447>,<-27.002828,-14.505268,176.301447>}
      texture{_Duse05}
    }
    //_BrDetail01
    mesh{
      triangle {<-22.835737,26.881138,134.905097>,<-14.537649,26.881138,134.905097>,<-14.537649,30.086582,134.905097>}
      triangle {<-22.835737,26.881138,134.905097>,<-14.537649,30.086582,134.905097>,<-22.835737,30.086582,134.905097>}
      triangle {<-22.835737,26.881138,134.905097>,<-22.835737,26.881138,134.492652>,<-14.537649,26.881138,134.492652>}
      triangle {<-22.835737,26.881138,134.905097>,<-14.537649,26.881138,134.492652>,<-14.537649,26.881138,134.905097>}
      triangle {<-14.537649,26.881138,134.905097>,<-14.537649,26.881138,134.492652>,<-14.537649,30.086582,134.492652>}
      triangle {<-14.537649,26.881138,134.905097>,<-14.537649,30.086582,134.492652>,<-14.537649,30.086582,134.905097>}
      triangle {<-14.537649,30.086582,134.905097>,<-14.537649,30.086582,134.492652>,<-22.835737,30.086582,134.492652>}
      triangle {<-14.537649,30.086582,134.905097>,<-22.835737,30.086582,134.492652>,<-22.835737,30.086582,134.905097>}
      triangle {<-22.835737,30.086582,134.905097>,<-22.835737,30.086582,134.492652>,<-22.835737,26.881138,134.492652>}
      triangle {<-22.835737,30.086582,134.905097>,<-22.835737,26.881138,134.492652>,<-22.835737,26.881138,134.905097>}
      triangle {<-22.835737,26.881138,134.492652>,<-22.835737,30.086582,134.492652>,<-14.537649,30.086582,134.492652>}
      triangle {<-22.835737,26.881138,134.492652>,<-14.537649,30.086582,134.492652>,<-14.537649,26.881138,134.492652>}
      triangle {<-16.317655,29.551304,134.905097>,<-14.031217,29.551304,134.905097>,<-14.031217,32.465305,134.905097>}
      triangle {<-16.317655,29.551304,134.905097>,<-14.031217,32.465305,134.905097>,<-16.317655,32.465305,134.905097>}
      triangle {<-16.317655,29.551304,134.905097>,<-16.317655,29.551304,134.492652>,<-14.031217,29.551304,134.492652>}
      triangle {<-16.317655,29.551304,134.905097>,<-14.031217,29.551304,134.492652>,<-14.031217,29.551304,134.905097>}
      triangle {<-14.031217,29.551304,134.905097>,<-14.031217,29.551304,134.492652>,<-14.031217,32.465305,134.492652>}
      triangle {<-14.031217,29.551304,134.905097>,<-14.031217,32.465305,134.492652>,<-14.031217,32.465305,134.905097>}
      triangle {<-14.031217,32.465305,134.905097>,<-14.031217,32.465305,134.492652>,<-16.317655,32.465305,134.492652>}
      triangle {<-14.031217,32.465305,134.905097>,<-16.317655,32.465305,134.492652>,<-16.317655,32.465305,134.905097>}
      triangle {<-16.317655,32.465305,134.905097>,<-16.317655,32.465305,134.492652>,<-16.317655,29.551304,134.492652>}
      triangle {<-16.317655,32.465305,134.905097>,<-16.317655,29.551304,134.492652>,<-16.317655,29.551304,134.905097>}
      triangle {<-16.317655,29.551304,134.492652>,<-16.317655,32.465305,134.492652>,<-14.031217,32.465305,134.492652>}
      triangle {<-16.317655,29.551304,134.492652>,<-14.031217,32.465305,134.492652>,<-14.031217,29.551304,134.492652>}
      triangle {<-12.877645,29.551304,134.905097>,<-8.548017,29.551304,134.905097>,<-8.548017,32.465305,134.905097>}
      triangle {<-12.877645,29.551304,134.905097>,<-8.548017,32.465305,134.905097>,<-12.877645,32.465305,134.905097>}
      triangle {<-12.877645,29.551304,134.905097>,<-12.877645,29.551304,134.492652>,<-8.548017,29.551304,134.492652>}
      triangle {<-12.877645,29.551304,134.905097>,<-8.548017,29.551304,134.492652>,<-8.548017,29.551304,134.905097>}
      triangle {<-8.548017,29.551304,134.905097>,<-8.548017,29.551304,134.492652>,<-8.548017,32.465305,134.492652>}
      triangle {<-8.548017,29.551304,134.905097>,<-8.548017,32.465305,134.492652>,<-8.548017,32.465305,134.905097>}
      triangle {<-8.548017,32.465305,134.905097>,<-8.548017,32.465305,134.492652>,<-12.877645,32.465305,134.492652>}
      triangle {<-8.548017,32.465305,134.905097>,<-12.877645,32.465305,134.492652>,<-12.877645,32.465305,134.905097>}
      triangle {<-12.877645,32.465305,134.905097>,<-12.877645,32.465305,134.492652>,<-12.877645,29.551304,134.492652>}
      triangle {<-12.877645,32.465305,134.905097>,<-12.877645,29.551304,134.492652>,<-12.877645,29.551304,134.905097>}
      triangle {<-12.877645,29.551304,134.492652>,<-12.877645,32.465305,134.492652>,<-8.548017,32.465305,134.492652>}
      triangle {<-12.877645,29.551304,134.492652>,<-8.548017,32.465305,134.492652>,<-8.548017,29.551304,134.492652>}
      triangle {<-11.091657,26.881138,134.905097>,<-2.793569,26.881138,134.905097>,<-2.793569,30.086582,134.905097>}
      triangle {<-11.091657,26.881138,134.905097>,<-2.793569,30.086582,134.905097>,<-11.091657,30.086582,134.905097>}
      triangle {<-11.091657,26.881138,134.905097>,<-11.091657,26.881138,134.492652>,<-2.793569,26.881138,134.492652>}
      triangle {<-11.091657,26.881138,134.905097>,<-2.793569,26.881138,134.492652>,<-2.793569,26.881138,134.905097>}
      triangle {<-2.793569,26.881138,134.905097>,<-2.793569,26.881138,134.492652>,<-2.793569,30.086582,134.492652>}
      triangle {<-2.793569,26.881138,134.905097>,<-2.793569,30.086582,134.492652>,<-2.793569,30.086582,134.905097>}
      triangle {<-2.793569,30.086582,134.905097>,<-2.793569,30.086582,134.492652>,<-11.091657,30.086582,134.492652>}
      triangle {<-2.793569,30.086582,134.905097>,<-11.091657,30.086582,134.492652>,<-11.091657,30.086582,134.905097>}
      triangle {<-11.091657,30.086582,134.905097>,<-11.091657,30.086582,134.492652>,<-11.091657,26.881138,134.492652>}
      triangle {<-11.091657,30.086582,134.905097>,<-11.091657,26.881138,134.492652>,<-11.091657,26.881138,134.905097>}
      triangle {<-11.091657,26.881138,134.492652>,<-11.091657,30.086582,134.492652>,<-2.793569,30.086582,134.492652>}
      triangle {<-11.091657,26.881138,134.492652>,<-2.793569,30.086582,134.492652>,<-2.793569,26.881138,134.492652>}
      triangle {<-4.176916,24.173176,134.905097>,<4.121172,24.173176,134.905097>,<4.121172,27.087177,134.905097>}
      triangle {<-4.176916,24.173176,134.905097>,<4.121172,27.087177,134.905097>,<-4.176916,27.087177,134.905097>}
      triangle {<-4.176916,24.173176,134.905097>,<-4.176916,24.173176,134.492652>,<4.121172,24.173176,134.492652>}
      triangle {<-4.176916,24.173176,134.905097>,<4.121172,24.173176,134.492652>,<4.121172,24.173176,134.905097>}
      triangle {<4.121172,24.173176,134.905097>,<4.121172,24.173176,134.492652>,<4.121172,27.087177,134.492652>}
      triangle {<4.121172,24.173176,134.905097>,<4.121172,27.087177,134.492652>,<4.121172,27.087177,134.905097>}
      triangle {<4.121172,27.087177,134.905097>,<4.121172,27.087177,134.492652>,<-4.176916,27.087177,134.492652>}
      triangle {<4.121172,27.087177,134.905097>,<-4.176916,27.087177,134.492652>,<-4.176916,27.087177,134.905097>}
      triangle {<-4.176916,27.087177,134.905097>,<-4.176916,27.087177,134.492652>,<-4.176916,24.173176,134.492652>}
      triangle {<-4.176916,27.087177,134.905097>,<-4.176916,24.173176,134.492652>,<-4.176916,24.173176,134.905097>}
      triangle {<-4.176916,24.173176,134.492652>,<-4.176916,27.087177,134.492652>,<4.121172,27.087177,134.492652>}
      triangle {<-4.176916,24.173176,134.492652>,<4.121172,27.087177,134.492652>,<4.121172,24.173176,134.492652>}
      triangle {<-4.176916,31.086155,134.905097>,<4.121172,31.086155,134.905097>,<4.121172,35.101292,134.905097>}
      triangle {<-4.176916,31.086155,134.905097>,<4.121172,35.101292,134.905097>,<-4.176916,35.101292,134.905097>}
      triangle {<-4.176916,31.086155,134.905097>,<-4.176916,31.086155,134.492652>,<4.121172,31.086155,134.492652>}
      triangle {<-4.176916,31.086155,134.905097>,<4.121172,31.086155,134.492652>,<4.121172,31.086155,134.905097>}
      triangle {<4.121172,31.086155,134.905097>,<4.121172,31.086155,134.492652>,<4.121172,35.101292,134.492652>}
      triangle {<4.121172,31.086155,134.905097>,<4.121172,35.101292,134.492652>,<4.121172,35.101292,134.905097>}
      triangle {<4.121172,35.101292,134.905097>,<4.121172,35.101292,134.492652>,<-4.176916,35.101292,134.492652>}
      triangle {<4.121172,35.101292,134.905097>,<-4.176916,35.101292,134.492652>,<-4.176916,35.101292,134.905097>}
      triangle {<-4.176916,35.101292,134.905097>,<-4.176916,35.101292,134.492652>,<-4.176916,31.086155,134.492652>}
      triangle {<-4.176916,35.101292,134.905097>,<-4.176916,31.086155,134.492652>,<-4.176916,31.086155,134.905097>}
      triangle {<-4.176916,31.086155,134.492652>,<-4.176916,35.101292,134.492652>,<4.121172,35.101292,134.492652>}
      triangle {<-4.176916,31.086155,134.492652>,<4.121172,35.101292,134.492652>,<4.121172,31.086155,134.492652>}
      triangle {<0.237971,28.014698,134.905097>,<4.096583,28.014698,134.905097>,<4.096583,30.928699,134.905097>}
      triangle {<0.237971,28.014698,134.905097>,<4.096583,30.928699,134.905097>,<0.237971,30.928699,134.905097>}
      triangle {<0.237971,28.014698,134.905097>,<0.237971,28.014698,134.492652>,<4.096583,28.014698,134.492652>}
      triangle {<0.237971,28.014698,134.905097>,<4.096583,28.014698,134.492652>,<4.096583,28.014698,134.905097>}
      triangle {<4.096583,28.014698,134.905097>,<4.096583,28.014698,134.492652>,<4.096583,30.928699,134.492652>}
      triangle {<4.096583,28.014698,134.905097>,<4.096583,30.928699,134.492652>,<4.096583,30.928699,134.905097>}
      triangle {<4.096583,30.928699,134.905097>,<4.096583,30.928699,134.492652>,<0.237971,30.928699,134.492652>}
      triangle {<4.096583,30.928699,134.905097>,<0.237971,30.928699,134.492652>,<0.237971,30.928699,134.905097>}
      triangle {<0.237971,30.928699,134.905097>,<0.237971,30.928699,134.492652>,<0.237971,28.014698,134.492652>}
      triangle {<0.237971,30.928699,134.905097>,<0.237971,28.014698,134.492652>,<0.237971,28.014698,134.905097>}
      triangle {<0.237971,28.014698,134.492652>,<0.237971,30.928699,134.492652>,<4.096583,30.928699,134.492652>}
      triangle {<0.237971,28.014698,134.492652>,<4.096583,30.928699,134.492652>,<4.096583,28.014698,134.492652>}
      triangle {<6.994471,30.335056,134.905097>,<11.828104,30.335056,134.905097>,<11.828104,34.400089,134.905097>}
      triangle {<6.994471,30.335056,134.905097>,<11.828104,34.400089,134.905097>,<6.994471,34.400089,134.905097>}
      triangle {<6.994471,30.335056,134.905097>,<6.994471,30.335056,134.492652>,<11.828104,30.335056,134.492652>}
      triangle {<6.994471,30.335056,134.905097>,<11.828104,30.335056,134.492652>,<11.828104,30.335056,134.905097>}
      triangle {<11.828104,30.335056,134.905097>,<11.828104,30.335056,134.492652>,<11.828104,34.400089,134.492652>}
      triangle {<11.828104,30.335056,134.905097>,<11.828104,34.400089,134.492652>,<11.828104,34.400089,134.905097>}
      triangle {<11.828104,34.400089,134.905097>,<11.828104,34.400089,134.492652>,<6.994471,34.400089,134.492652>}
      triangle {<11.828104,34.400089,134.905097>,<6.994471,34.400089,134.492652>,<6.994471,34.400089,134.905097>}
      triangle {<6.994471,34.400089,134.905097>,<6.994471,34.400089,134.492652>,<6.994471,30.335056,134.492652>}
      triangle {<6.994471,34.400089,134.905097>,<6.994471,30.335056,134.492652>,<6.994471,30.335056,134.905097>}
      triangle {<6.994471,30.335056,134.492652>,<6.994471,34.400089,134.492652>,<11.828104,34.400089,134.492652>}
      triangle {<6.994471,30.335056,134.492652>,<11.828104,34.400089,134.492652>,<11.828104,30.335056,134.492652>}
      triangle {<7.018382,27.108509,134.905097>,<15.316470,27.108509,134.905097>,<15.316470,29.859180,134.905097>}
      triangle {<7.018382,27.108509,134.905097>,<15.316470,29.859180,134.905097>,<7.018382,29.859180,134.905097>}
      triangle {<7.018382,27.108509,134.905097>,<7.018382,27.108509,134.492652>,<15.316470,27.108509,134.492652>}
      triangle {<7.018382,27.108509,134.905097>,<15.316470,27.108509,134.492652>,<15.316470,27.108509,134.905097>}
      triangle {<15.316470,27.108509,134.905097>,<15.316470,27.108509,134.492652>,<15.316470,29.859180,134.492652>}
      triangle {<15.316470,27.108509,134.905097>,<15.316470,29.859180,134.492652>,<15.316470,29.859180,134.905097>}
      triangle {<15.316470,29.859180,134.905097>,<15.316470,29.859180,134.492652>,<7.018382,29.859180,134.492652>}
      triangle {<15.316470,29.859180,134.905097>,<7.018382,29.859180,134.492652>,<7.018382,29.859180,134.905097>}
      triangle {<7.018382,29.859180,134.905097>,<7.018382,29.859180,134.492652>,<7.018382,27.108509,134.492652>}
      triangle {<7.018382,29.859180,134.905097>,<7.018382,27.108509,134.492652>,<7.018382,27.108509,134.905097>}
      triangle {<7.018382,27.108509,134.492652>,<7.018382,29.859180,134.492652>,<15.316470,29.859180,134.492652>}
      triangle {<7.018382,27.108509,134.492652>,<15.316470,29.859180,134.492652>,<15.316470,27.108509,134.492652>}
      triangle {<16.238039,27.093510,134.905097>,<24.536128,27.093510,134.905097>,<24.536128,29.874226,134.905097>}
      triangle {<16.238039,27.093510,134.905097>,<24.536128,29.874226,134.905097>,<16.238039,29.874226,134.905097>}
      triangle {<16.238039,27.093510,134.905097>,<16.238039,27.093510,134.492652>,<24.536128,27.093510,134.492652>}
      triangle {<16.238039,27.093510,134.905097>,<24.536128,27.093510,134.492652>,<24.536128,27.093510,134.905097>}
      triangle {<24.536128,27.093510,134.905097>,<24.536128,27.093510,134.492652>,<24.536128,29.874226,134.492652>}
      triangle {<24.536128,27.093510,134.905097>,<24.536128,29.874226,134.492652>,<24.536128,29.874226,134.905097>}
      triangle {<24.536128,29.874226,134.905097>,<24.536128,29.874226,134.492652>,<16.238039,29.874226,134.492652>}
      triangle {<24.536128,29.874226,134.905097>,<16.238039,29.874226,134.492652>,<16.238039,29.874226,134.905097>}
      triangle {<16.238039,29.874226,134.905097>,<16.238039,29.874226,134.492652>,<16.238039,27.093510,134.492652>}
      triangle {<16.238039,29.874226,134.905097>,<16.238039,27.093510,134.492652>,<16.238039,27.093510,134.905097>}
      triangle {<16.238039,27.093510,134.492652>,<16.238039,29.874226,134.492652>,<24.536128,29.874226,134.492652>}
      triangle {<16.238039,27.093510,134.492652>,<24.536128,29.874226,134.492652>,<24.536128,27.093510,134.492652>}
      triangle {<13.921175,31.161976,134.905097>,<21.365099,31.161976,134.905097>,<21.365099,32.830250,134.905097>}
      triangle {<13.921175,31.161976,134.905097>,<21.365099,32.830250,134.905097>,<13.921175,32.830250,134.905097>}
      triangle {<13.921175,31.161976,134.905097>,<13.921175,31.161976,134.492652>,<21.365099,31.161976,134.492652>}
      triangle {<13.921175,31.161976,134.905097>,<21.365099,31.161976,134.492652>,<21.365099,31.161976,134.905097>}
      triangle {<21.365099,31.161976,134.905097>,<21.365099,31.161976,134.492652>,<21.365099,32.830250,134.492652>}
      triangle {<21.365099,31.161976,134.905097>,<21.365099,32.830250,134.492652>,<21.365099,32.830250,134.905097>}
      triangle {<21.365099,32.830250,134.905097>,<21.365099,32.830250,134.492652>,<13.921175,32.830250,134.492652>}
      triangle {<21.365099,32.830250,134.905097>,<13.921175,32.830250,134.492652>,<13.921175,32.830250,134.905097>}
      triangle {<13.921175,32.830250,134.905097>,<13.921175,32.830250,134.492652>,<13.921175,31.161976,134.492652>}
      triangle {<13.921175,32.830250,134.905097>,<13.921175,31.161976,134.492652>,<13.921175,31.161976,134.905097>}
      triangle {<13.921175,31.161976,134.492652>,<13.921175,32.830250,134.492652>,<21.365099,32.830250,134.492652>}
      triangle {<13.921175,31.161976,134.492652>,<21.365099,32.830250,134.492652>,<21.365099,31.161976,134.492652>}
      triangle {<0.264826,36.483875,134.686561>,<0.260363,36.824986,134.686561>,<-24.752401,33.199680,134.686561>}
      triangle {<-24.747930,32.858570,134.686561>,<0.264826,36.483875,134.686561>,<-24.752401,33.199680,134.686561>}
      triangle {<0.260363,36.824986,134.438468>,<-24.752401,33.199680,134.438468>,<-24.752401,33.199680,134.686561>}
      triangle {<0.260363,36.824986,134.686561>,<0.260363,36.824986,134.438468>,<-24.752401,33.199680,134.686561>}
      triangle {<0.264826,36.483875,134.438468>,<0.260363,36.824986,134.438468>,<0.260363,36.824986,134.686561>}
      triangle {<0.264826,36.483875,134.686561>,<0.264826,36.483875,134.438468>,<0.260363,36.824986,134.686561>}
      triangle {<-24.747930,32.858570,134.438468>,<0.264826,36.483875,134.438468>,<0.264826,36.483875,134.686561>}
      triangle {<-24.747930,32.858570,134.686561>,<-24.747930,32.858570,134.438468>,<0.264826,36.483875,134.686561>}
      triangle {<-24.752401,33.199680,134.438468>,<-24.747930,32.858570,134.438468>,<-24.747930,32.858570,134.686561>}
      triangle {<-24.752401,33.199680,134.686561>,<-24.752401,33.199680,134.438468>,<-24.747930,32.858570,134.686561>}
      triangle {<0.264826,36.483875,134.438468>,<-24.747930,32.858570,134.438468>,<-24.752401,33.199680,134.438468>}
      triangle {<0.260363,36.824986,134.438468>,<0.264826,36.483875,134.438468>,<-24.752401,33.199680,134.438468>}
      triangle {<25.272151,33.192066,134.686561>,<0.259341,36.817066,134.686561>,<0.254878,36.475956,134.686561>}
      triangle {<25.272151,33.192066,134.686561>,<0.254878,36.475956,134.686561>,<25.267680,32.850956,134.686561>}
      triangle {<25.272151,33.192066,134.686561>,<25.272151,33.192066,134.438468>,<0.259341,36.817066,134.438468>}
      triangle {<25.272151,33.192066,134.686561>,<0.259341,36.817066,134.438468>,<0.259341,36.817066,134.686561>}
      triangle {<0.259341,36.817066,134.686561>,<0.259341,36.817066,134.438468>,<0.254878,36.475956,134.438468>}
      triangle {<0.259341,36.817066,134.686561>,<0.254878,36.475956,134.438468>,<0.254878,36.475956,134.686561>}
      triangle {<0.254878,36.475956,134.686561>,<0.254878,36.475956,134.438468>,<25.267680,32.850956,134.438468>}
      triangle {<0.254878,36.475956,134.686561>,<25.267680,32.850956,134.438468>,<25.267680,32.850956,134.686561>}
      triangle {<25.267680,32.850956,134.686561>,<25.267680,32.850956,134.438468>,<25.272151,33.192066,134.438468>}
      triangle {<25.267680,32.850956,134.686561>,<25.272151,33.192066,134.438468>,<25.272151,33.192066,134.686561>}
      triangle {<25.272151,33.192066,134.438468>,<25.267680,32.850956,134.438468>,<0.254878,36.475956,134.438468>}
      triangle {<25.272151,33.192066,134.438468>,<0.254878,36.475956,134.438468>,<0.259341,36.817066,134.438468>}
      triangle {<-24.939214,26.283039,134.921489>,<-24.597448,26.283039,134.921489>,<-24.597448,33.099384,134.921489>}
      triangle {<-24.939214,26.283039,134.921489>,<-24.597448,33.099384,134.921489>,<-24.939214,33.099384,134.921489>}
      triangle {<-24.939214,26.283039,134.921489>,<-24.939214,26.283039,134.509044>,<-24.597448,26.283039,134.509044>}
      triangle {<-24.939214,26.283039,134.921489>,<-24.597448,26.283039,134.509044>,<-24.597448,26.283039,134.921489>}
      triangle {<-24.597448,26.283039,134.921489>,<-24.597448,26.283039,134.509044>,<-24.597448,33.099384,134.509044>}
      triangle {<-24.597448,26.283039,134.921489>,<-24.597448,33.099384,134.509044>,<-24.597448,33.099384,134.921489>}
      triangle {<-24.597448,33.099384,134.921489>,<-24.597448,33.099384,134.509044>,<-24.939214,33.099384,134.509044>}
      triangle {<-24.597448,33.099384,134.921489>,<-24.939214,33.099384,134.509044>,<-24.939214,33.099384,134.921489>}
      triangle {<-24.939214,33.099384,134.921489>,<-24.939214,33.099384,134.509044>,<-24.939214,26.283039,134.509044>}
      triangle {<-24.939214,33.099384,134.921489>,<-24.939214,26.283039,134.509044>,<-24.939214,26.283039,134.921489>}
      triangle {<-24.939214,26.283039,134.509044>,<-24.939214,33.099384,134.509044>,<-24.597448,33.099384,134.509044>}
      triangle {<-24.939214,26.283039,134.509044>,<-24.597448,33.099384,134.509044>,<-24.597448,26.283039,134.509044>}
      triangle {<0.101717,22.990772,134.686561>,<0.106181,22.649662,134.686561>,<25.118968,26.274815,134.686561>}
      triangle {<25.114497,26.615925,134.686561>,<0.101717,22.990772,134.686561>,<25.118968,26.274815,134.686561>}
      triangle {<0.106181,22.649662,134.438468>,<25.118968,26.274815,134.438468>,<25.118968,26.274815,134.686561>}
      triangle {<0.106181,22.649662,134.686561>,<0.106181,22.649662,134.438468>,<25.118968,26.274815,134.686561>}
      triangle {<0.101717,22.990772,134.438468>,<0.106181,22.649662,134.438468>,<0.106181,22.649662,134.686561>}
      triangle {<0.101717,22.990772,134.686561>,<0.101717,22.990772,134.438468>,<0.106181,22.649662,134.686561>}
      triangle {<25.114497,26.615925,134.438468>,<0.101717,22.990772,134.438468>,<0.101717,22.990772,134.686561>}
      triangle {<25.114497,26.615925,134.686561>,<25.114497,26.615925,134.438468>,<0.101717,22.990772,134.686561>}
      triangle {<25.118968,26.274815,134.438468>,<25.114497,26.615925,134.438468>,<25.114497,26.615925,134.686561>}
      triangle {<25.118968,26.274815,134.686561>,<25.118968,26.274815,134.438468>,<25.114497,26.615925,134.686561>}
      triangle {<0.101717,22.990772,134.438468>,<25.114497,26.615925,134.438468>,<25.118968,26.274815,134.438468>}
      triangle {<0.106181,22.649662,134.438468>,<0.101717,22.990772,134.438468>,<25.118968,26.274815,134.438468>}
      triangle {<-24.953451,26.274815,134.686561>,<0.059336,22.649662,134.686561>,<0.063799,22.990772,134.686561>}
      triangle {<-24.953451,26.274815,134.686561>,<0.063799,22.990772,134.686561>,<-24.948980,26.615925,134.686561>}
      triangle {<-24.953451,26.274815,134.686561>,<-24.953451,26.274815,134.438468>,<0.059336,22.649662,134.438468>}
      triangle {<-24.953451,26.274815,134.686561>,<0.059336,22.649662,134.438468>,<0.059336,22.649662,134.686561>}
      triangle {<0.059336,22.649662,134.686561>,<0.059336,22.649662,134.438468>,<0.063799,22.990772,134.438468>}
      triangle {<0.059336,22.649662,134.686561>,<0.063799,22.990772,134.438468>,<0.063799,22.990772,134.686561>}
      triangle {<0.063799,22.990772,134.686561>,<0.063799,22.990772,134.438468>,<-24.948980,26.615925,134.438468>}
      triangle {<0.063799,22.990772,134.686561>,<-24.948980,26.615925,134.438468>,<-24.948980,26.615925,134.686561>}
      triangle {<-24.948980,26.615925,134.686561>,<-24.948980,26.615925,134.438468>,<-24.953451,26.274815,134.438468>}
      triangle {<-24.948980,26.615925,134.686561>,<-24.953451,26.274815,134.438468>,<-24.953451,26.274815,134.686561>}
      triangle {<-24.953451,26.274815,134.438468>,<-24.948980,26.615925,134.438468>,<0.063799,22.990772,134.438468>}
      triangle {<-24.953451,26.274815,134.438468>,<0.063799,22.990772,134.438468>,<0.059336,22.649662,134.438468>}
      triangle {<25.111140,26.283039,134.905097>,<25.452906,26.283039,134.905097>,<25.452906,33.099384,134.905097>}
      triangle {<25.111140,26.283039,134.905097>,<25.452906,33.099384,134.905097>,<25.111140,33.099384,134.905097>}
      triangle {<25.111140,26.283039,134.905097>,<25.111140,26.283039,134.492652>,<25.452906,26.283039,134.492652>}
      triangle {<25.111140,26.283039,134.905097>,<25.452906,26.283039,134.492652>,<25.452906,26.283039,134.905097>}
      triangle {<25.452906,26.283039,134.905097>,<25.452906,26.283039,134.492652>,<25.452906,33.099384,134.492652>}
      triangle {<25.452906,26.283039,134.905097>,<25.452906,33.099384,134.492652>,<25.452906,33.099384,134.905097>}
      triangle {<25.452906,33.099384,134.905097>,<25.452906,33.099384,134.492652>,<25.111140,33.099384,134.492652>}
      triangle {<25.452906,33.099384,134.905097>,<25.111140,33.099384,134.492652>,<25.111140,33.099384,134.905097>}
      triangle {<25.111140,33.099384,134.905097>,<25.111140,33.099384,134.492652>,<25.111140,26.283039,134.492652>}
      triangle {<25.111140,33.099384,134.905097>,<25.111140,26.283039,134.492652>,<25.111140,26.283039,134.905097>}
      triangle {<25.111140,26.283039,134.492652>,<25.111140,33.099384,134.492652>,<25.452906,33.099384,134.492652>}
      triangle {<25.111140,26.283039,134.492652>,<25.452906,33.099384,134.492652>,<25.452906,26.283039,134.492652>}
      texture{_BrDetail01}
    }
    //_Object05
    mesh{
      triangle {<13.287631,-23.780544,-11.495599>,<13.287638,-20.999416,-49.361810>,<13.287638,-23.780544,-49.361810>}
      triangle {<13.287631,-23.780544,-11.495599>,<13.287631,-20.999416,-11.495599>,<13.287638,-20.999416,-49.361810>}
      triangle {<13.287631,-23.780544,-11.495599>,<15.863734,-23.780544,-49.361810>,<15.863726,-23.780544,-11.495599>}
      triangle {<13.287631,-23.780544,-11.495599>,<13.287638,-23.780544,-49.361810>,<15.863734,-23.780544,-49.361810>}
      triangle {<13.287638,-23.780544,-49.361810>,<15.863734,-20.999416,-49.361810>,<15.863734,-23.780544,-49.361810>}
      triangle {<13.287638,-23.780544,-49.361810>,<13.287638,-20.999416,-49.361810>,<15.863734,-20.999416,-49.361810>}
      triangle {<13.287638,-20.999416,-49.361810>,<15.863726,-20.999416,-11.495599>,<15.863734,-20.999416,-49.361810>}
      triangle {<13.287638,-20.999416,-49.361810>,<13.287631,-20.999416,-11.495599>,<15.863726,-20.999416,-11.495599>}
      triangle {<13.287631,-20.999416,-11.495599>,<15.863726,-23.780544,-11.495599>,<15.863726,-20.999416,-11.495599>}
      triangle {<13.287631,-20.999416,-11.495599>,<13.287631,-23.780544,-11.495599>,<15.863726,-23.780544,-11.495599>}
      triangle {<15.863726,-23.780544,-11.495599>,<15.863734,-20.999416,-49.361810>,<15.863726,-20.999416,-11.495599>}
      triangle {<15.863726,-23.780544,-11.495599>,<15.863734,-23.780544,-49.361810>,<15.863734,-20.999416,-49.361810>}
      triangle {<13.294650,-32.123951,-11.495599>,<13.294657,-29.342823,-49.361810>,<13.294657,-32.123951,-49.361810>}
      triangle {<13.294650,-32.123951,-11.495599>,<13.294650,-29.342823,-11.495599>,<13.294657,-29.342823,-49.361810>}
      triangle {<13.294650,-32.123951,-11.495599>,<15.870753,-32.123951,-49.361810>,<15.870745,-32.123951,-11.495599>}
      triangle {<13.294650,-32.123951,-11.495599>,<13.294657,-32.123951,-49.361810>,<15.870753,-32.123951,-49.361810>}
      triangle {<13.294657,-32.123951,-49.361810>,<15.870753,-29.342823,-49.361810>,<15.870753,-32.123951,-49.361810>}
      triangle {<13.294657,-32.123951,-49.361810>,<13.294657,-29.342823,-49.361810>,<15.870753,-29.342823,-49.361810>}
      triangle {<13.294657,-29.342823,-49.361810>,<15.870745,-29.342823,-11.495599>,<15.870753,-29.342823,-49.361810>}
      triangle {<13.294657,-29.342823,-49.361810>,<13.294650,-29.342823,-11.495599>,<15.870745,-29.342823,-11.495599>}
      triangle {<13.294650,-29.342823,-11.495599>,<15.870745,-32.123951,-11.495599>,<15.870745,-29.342823,-11.495599>}
      triangle {<13.294650,-29.342823,-11.495599>,<13.294650,-32.123951,-11.495599>,<15.870745,-32.123951,-11.495599>}
      triangle {<15.870745,-32.123951,-11.495599>,<15.870753,-29.342823,-49.361810>,<15.870745,-29.342823,-11.495599>}
      triangle {<15.870745,-32.123951,-11.495599>,<15.870753,-32.123951,-49.361810>,<15.870753,-29.342823,-49.361810>}
      triangle {<-4.337522,-23.590649,-11.495599>,<-4.337514,-20.809521,-49.361810>,<-4.337514,-23.590649,-49.361810>}
      triangle {<-4.337522,-23.590649,-11.495599>,<-4.337522,-20.809521,-11.495599>,<-4.337514,-20.809521,-49.361810>}
      triangle {<-4.337522,-23.590649,-11.495599>,<4.395449,-23.590649,-49.361810>,<4.395442,-23.590649,-11.495599>}
      triangle {<-4.337522,-23.590649,-11.495599>,<-4.337514,-23.590649,-49.361810>,<4.395449,-23.590649,-49.361810>}
      triangle {<-4.337514,-23.590649,-49.361810>,<4.395449,-20.809521,-49.361810>,<4.395449,-23.590649,-49.361810>}
      triangle {<-4.337514,-23.590649,-49.361810>,<-4.337514,-20.809521,-49.361810>,<4.395449,-20.809521,-49.361810>}
      triangle {<-4.337514,-20.809521,-49.361810>,<4.395442,-20.809521,-11.495599>,<4.395449,-20.809521,-49.361810>}
      triangle {<-4.337514,-20.809521,-49.361810>,<-4.337522,-20.809521,-11.495599>,<4.395442,-20.809521,-11.495599>}
      triangle {<-4.337522,-20.809521,-11.495599>,<4.395442,-23.590649,-11.495599>,<4.395442,-20.809521,-11.495599>}
      triangle {<-4.337522,-20.809521,-11.495599>,<-4.337522,-23.590649,-11.495599>,<4.395442,-23.590649,-11.495599>}
      triangle {<4.395442,-23.590649,-11.495599>,<4.395449,-20.809521,-49.361810>,<4.395442,-20.809521,-11.495599>}
      triangle {<4.395442,-23.590649,-11.495599>,<4.395449,-23.590649,-49.361810>,<4.395449,-20.809521,-49.361810>}
      triangle {<-16.213880,-23.780544,-11.495599>,<-16.213872,-20.999416,-49.361810>,<-16.213872,-23.780544,-49.361810>}
      triangle {<-16.213880,-23.780544,-11.495599>,<-16.213880,-20.999416,-11.495599>,<-16.213872,-20.999416,-49.361810>}
      triangle {<-16.213880,-23.780544,-11.495599>,<-13.637777,-23.780544,-49.361810>,<-13.637784,-23.780544,-11.495599>}
      triangle {<-16.213880,-23.780544,-11.495599>,<-16.213872,-23.780544,-49.361810>,<-13.637777,-23.780544,-49.361810>}
      triangle {<-16.213872,-23.780544,-49.361810>,<-13.637777,-20.999416,-49.361810>,<-13.637777,-23.780544,-49.361810>}
      triangle {<-16.213872,-23.780544,-49.361810>,<-16.213872,-20.999416,-49.361810>,<-13.637777,-20.999416,-49.361810>}
      triangle {<-16.213872,-20.999416,-49.361810>,<-13.637784,-20.999416,-11.495599>,<-13.637777,-20.999416,-49.361810>}
      triangle {<-16.213872,-20.999416,-49.361810>,<-16.213880,-20.999416,-11.495599>,<-13.637784,-20.999416,-11.495599>}
      triangle {<-16.213880,-20.999416,-11.495599>,<-13.637784,-23.780544,-11.495599>,<-13.637784,-20.999416,-11.495599>}
      triangle {<-16.213880,-20.999416,-11.495599>,<-16.213880,-23.780544,-11.495599>,<-13.637784,-23.780544,-11.495599>}
      triangle {<-13.637784,-23.780544,-11.495599>,<-13.637777,-20.999416,-49.361810>,<-13.637784,-20.999416,-11.495599>}
      triangle {<-13.637784,-23.780544,-11.495599>,<-13.637777,-23.780544,-49.361810>,<-13.637777,-20.999416,-49.361810>}
      triangle {<-16.213880,-32.123943,-11.495599>,<-16.213872,-29.342815,-49.361810>,<-16.213872,-32.123943,-49.361810>}
      triangle {<-16.213880,-32.123943,-11.495599>,<-16.213880,-29.342815,-11.495599>,<-16.213872,-29.342815,-49.361810>}
      triangle {<-16.213880,-32.123943,-11.495599>,<-13.637777,-32.123943,-49.361810>,<-13.637784,-32.123943,-11.495599>}
      triangle {<-16.213880,-32.123943,-11.495599>,<-16.213872,-32.123943,-49.361810>,<-13.637777,-32.123943,-49.361810>}
      triangle {<-16.213872,-32.123943,-49.361810>,<-13.637777,-29.342815,-49.361810>,<-13.637777,-32.123943,-49.361810>}
      triangle {<-16.213872,-32.123943,-49.361810>,<-16.213872,-29.342815,-49.361810>,<-13.637777,-29.342815,-49.361810>}
      triangle {<-16.213872,-29.342815,-49.361810>,<-13.637784,-29.342815,-11.495599>,<-13.637777,-29.342815,-49.361810>}
      triangle {<-16.213872,-29.342815,-49.361810>,<-16.213880,-29.342815,-11.495599>,<-13.637784,-29.342815,-11.495599>}
      triangle {<-16.213880,-29.342815,-11.495599>,<-13.637784,-32.123943,-11.495599>,<-13.637784,-29.342815,-11.495599>}
      triangle {<-16.213880,-29.342815,-11.495599>,<-16.213880,-32.123943,-11.495599>,<-13.637784,-32.123943,-11.495599>}
      triangle {<-13.637784,-32.123943,-11.495599>,<-13.637777,-29.342815,-49.361810>,<-13.637784,-29.342815,-11.495599>}
      triangle {<-13.637784,-32.123943,-11.495599>,<-13.637777,-32.123943,-49.361810>,<-13.637777,-29.342815,-49.361810>}
      texture{_Object05}
    }
  }
  scale <4, 4, -4> //Star Destroyer =~ 1600m long - 1m : 1 unit
}
